
;-----------------------------------------------------------------------------------------------------------------------------------------
;	( CUERNO-CABRA-01 )                                                                                      	         04/12/2007			
;-----------------------------------------------------------------------------------------------------------------------------------------
;                       ESPIRAL :/EQUIANGULAR/LOGARITMICA/GEOMETRICA     R = Ko * e^(Kp * AgC)   =>   AgC = 1/Kp * Log(R/Ko)						
;-----------------------------------------------------------------------------------------------------------------------------------------

;-----------------------------------------------------------------------------------------------------------------------------------------

"########################################################################################################################################"
;-----------------------------------------------------------------------------------------------------------------------------------------
; *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA ***	
;-----------------------------------------------------------------------------------------------------------------------------------------
"########################################################################################################################################"

(DEFUN C:CUERNO-CABRA-01 ( / )

	;======================================================================================================================================
	;  (00) ARRANCANDO																																							
	;......................................................................................................................................

 	(SETVAR "blipmode" 0) (SETVAR "cmdecho" 0)  (GRAPHSCR)  (COMMAND "-REFENT" "DES")  (COMMAND "SCP" "U")  (COMMAND "ORTO" "DES")

	(TERPRI) (PROMPT " ============================================================================ ")
	(TERPRI) (PROMPT " >>>>>>>>>>>>>>>>>>>>>> INICIO - CUERNO-CABRA-01 >>>>>>>>>>>>>>>>>>>>>>>>>>>> ")
	(TERPRI) (PROMPT " ============================================================================ ") (TERPRI)

	(IF (= CAL nil)(COMMAND "ARX" "L" "GEOMCAL.ARX"))		; CARGA CALCULADORA 
	(SETQ mUNI  1.0e-006  )			; MARGEN EQUAL para VECTORES UNITARIOS  1.02e-006   (( 1.01e-008 ) de LIMITE-MAR-INTER-RECT-01 lsp) 

	;	(00)																																											
	;======================================================================================================================================

 	;======================================================================================================================================
	;	(01) FIJAR VARIABLES EN EL PROGRAMA																																	
	;......................................................................................................................................

	(SETQ vC     2    )		;   N de VUELTAS CUERNO 
	(SETQ PvC  200    )		; PUN por VUELTA  CUERNO 
	(SETQ PvT   20    )		; PUN por VUELTA  TUBO   MULTIPLO de PvC 

	(SETQ Ko     1.0  )		; ESCALA-XY  1PUN=>X 
	(SETQ Kp     0.2  )		; PASO ??             

	(SETQ Kv   100.0  )		; ALTURA ZZc Funcion Lineal

	(SETQ Kt     0.4  )		; RADIO-TUBO = RR12c * Kt 


	(SETQ KKx  300    )		; PUNTO OREGEN PATRON 
	(SETQ KKy    0    )

	(SETQ H-TXT  0.8  )		; ALTURA TEXTO

	;	(01)																																											
	;======================================================================================================================================

 	;======================================================================================================================================
	;	(02) PUNTOS ESPIRAL LOGARITMICA (CUERNO y TUBO)      (EJE) R = Ko * e^(Kp * AgC)													   				
	;......................................................................................................................................

	; AJUSTES K       																																				

	;(SETQ COLO 0 )
	;(SETQ Kp    (- Kp 0.01 ))
	;(REPEAT 5
	;	(SETQ Kp (+ Kp 0.01 ))
	;	(SETQ COLO (+ COLO  1))
	  
			; PLANA   (PRUE)     																																	

			(SETQ LIS-P-ESPIRAL-CUERNO nil)
			(SETQ LIS-P-ESPIRAL-TUBO   nil)

			(SETQ AlUniC (/ Kv (* vC PvC) ))
			(SETQ AlC    (+ Kv AlUniC))

			(SETQ AgUniC (/ (* 2 PI) PvC ))														; ANGULO UNITARIO EJE CUERNO 
			(SETQ AgC    (- (* 2 PI) AgUniC)) ; Enpieza en (* 2 PI) Escala 

			(REPEAT (+ (* vC PvC) 2 )

				(SETQ AgC (+ AgC  AgUniC))

				(SETQ AlC (- AlC  AlUniC))

				(SETQ RR (* Ko (EXP (* Kp AgC))))

				(SETQ XXc (* RR (COS AgC)))
				(SETQ YYc (* RR (SIN AgC)))
				(SETQ ZZc  AlC )

				(SETQ PPc (LIST XXc YYc ZZc ))

				;(COMMAND "COLOR" 6 "PUNTO" PPc )

				(SETQ LIS-P-ESPIRAL-CUERNO  (CONS (LIST PPc RR )  LIS-P-ESPIRAL-CUERNO ))

			) ; repe

			(SETQ LIS-P-ESPIRAL-CUERNO   (REVERSE  LIS-P-ESPIRAL-CUERNO ))							; (LENGTH LIS-P-ESPIRAL-CUERNO ) 


			; PINTA EJE CUERNO  CIRCULOS y PUNTOS TUBO																										

			(SETQ AgUniT (/ (* 2 PI) PvT ))															; ANGULO UNITARIO EJE TUBO 
			(SETQ AgT (- AgUniT))

			(SETQ NC -1)
			(REPEAT (- (LENGTH LIS-P-ESPIRAL-CUERNO) 1)
				(SETQ NC (+ NC 1))

				(SETQ PP1c  (NTH 0 (NTH (+ NC 0) LIS-P-ESPIRAL-CUERNO)))
				(SETQ PP2c  (NTH 0 (NTH (+ NC 1) LIS-P-ESPIRAL-CUERNO)))

				(SETQ RR1c  (NTH 1 (NTH (+ NC 0) LIS-P-ESPIRAL-CUERNO)))
				(SETQ RR2c  (NTH 1 (NTH (+ NC 1) LIS-P-ESPIRAL-CUERNO)))

				(SETQ RR12c (/ (+ RR1c RR2c ) 2.0 ))


				(COMMAND "COLOR" 1  "LINEA" PP1c PP2c "")											; EJE ESPIRAL CUERNO 

				(SETQ PP12c (CAL " PLT ( PP1c , PP2c , 0.5 )"))									; PUNTO MEDIO 

				(SETQ AgT (+ AgT  AgUniT))

				(COMMAND "SCP" "EZ" PP12c PP2c )

					;(IF (= (REM NC PvT) 0 ) (COMMAND "COLOR" 8  "CIRCULO" (LIST 0 0 0) (* RR12c Kt)) )

					(SETQ XXt (* RR12c  Kt (COS AgT)))
					(SETQ YYt (* RR12c  Kt (SIN AgT)))
					(SETQ ZZt 0.0 )
					(SETQ PPt (LIST XXt YYt ZZt ))

					;(COMMAND "COLOR" 5  "PUNTO" PPt )												; PUNTO ESPIRAL TUBO 

					(SETQ PPtU (TRANS PPt 1 0))
					(SETQ LIS-P-ESPIRAL-TUBO  (CONS PPtU  LIS-P-ESPIRAL-TUBO ))

				(COMMAND "SCP" "U" )

			) ; repe

			(SETQ LIS-P-ESPIRAL-TUBO   (REVERSE  LIS-P-ESPIRAL-TUBO ))						; (LENGTH LIS-P-ESPIRAL-TUBO ) 


			(SETQ NT -1)
			(REPEAT (- (LENGTH LIS-P-ESPIRAL-TUBO) 1)
				(SETQ NT (+ NT 1))

				(SETQ PP1t  (NTH (+ NT 0) LIS-P-ESPIRAL-TUBO))
				(SETQ PP2t  (NTH (+ NT 1) LIS-P-ESPIRAL-TUBO))

				(COMMAND "COLOR" 5  "LINEA" PP1t PP2t "")											; EJE ESPIRAL TUBO 

			) ; repe


		;	(COMMAND "COLOR" COLO "TEXTO" "SIZ" PP2c  H-TXT 90 (STRCAT " Ko=" (ITOA (FIX (* Ko 100))) "/100"
		;																		        " Kp=" (ITOA (FIX (* Kp 100))) "/100" ))

	;) ; repe COLO 

	;	(02)																																											
	;======================================================================================================================================


 	;======================================================================================================================================
	;	(03) LINEAS (AA1 AA2) y (BB2 BB3) LAS MAS COPLANARIAS (SUPERFICIE SEMI-DESARROLLABLE)																
	;......................................................................................................................................

	(SETQ LIS-LINE-TAG-PLANAS nil)

	(SETQ N1 -1)
	(REPEAT (- (LENGTH LIS-P-ESPIRAL-TUBO) PvT )
		(SETQ N1 (+ N1  1 ))

		(SETQ AA1 (NTH (+ N1 0) LIS-P-ESPIRAL-TUBO))
		(SETQ AA2 (NTH (+ N1 1) LIS-P-ESPIRAL-TUBO))

		(SETQ WW1 T )
		(SETQ NW (- (+ N1 (/ PvT 4)) 1 ))
		(SETQ N2  NW )
		(WHILE WW1 
			(SETQ N2 (+ N2  1 ))

			(IF (OR (> N2 (+ NW PvT )) (> (+ N2 3) (- (LENGTH LIS-P-ESPIRAL-TUBO) 1 )))

				(SETQ WW1 nil)

				(PROGN
					(SETQ BB1 (NTH (+ N2 0) LIS-P-ESPIRAL-TUBO))
					(SETQ BB2 (NTH (+ N2 1) LIS-P-ESPIRAL-TUBO))
					(SETQ BB3 (NTH (+ N2 2) LIS-P-ESPIRAL-TUBO))
					(SETQ BB4 (NTH (+ N2 3) LIS-P-ESPIRAL-TUBO))

					(SETQ DD1 (CAL "DPP ( BB2 , AA1 , AA2 , BB1 )"))		; DISTANCIA PUNTO (P) PLANO (P1 P2 P3)  DPP( P , P1 , P2 , P3 )
					(SETQ DD2 (CAL "DPP ( BB3 , AA1 , AA2 , BB2 )"))
					(SETQ DD3 (CAL "DPP ( BB4 , AA1 , AA2 , BB3 )"))

					(IF (AND (< DD2 DD1) (< DD2 DD3))
						(PROGN
							;(COMMAND "COLOR" 7  "LINEA" AA1 BB2 "")											; LINEA SUPERFICIE
							(SETQ LIS-LINE-TAG-PLANAS  (CONS (LIST AA1 BB2 )  LIS-LINE-TAG-PLANAS ))
							(SETQ WW1 nil)
						) ; pro
					) ; if
				) ; pro
			) ; if
		) ; WW1
	) ; repe

	(SETQ LIS-LINE-TAG-PLANAS (REVERSE LIS-LINE-TAG-PLANAS))						; (LENGTH LIS-LINE-TAG-PLANAS ) 

	;	(03)																																											
	;======================================================================================================================================


 	;======================================================================================================================================
	;	(04) PINTA SUPERFICIE  3DC => 3D  2D PATRONES												   																
	;......................................................................................................................................

	(SETQ KK1 (LIST    KKx     KKy  0 ))
	(SETQ KK2 (LIST (+ KKx 1)  KKy  0 ))

	(SETQ N3 -1)
	(REPEAT (- (LENGTH LIS-LINE-TAG-PLANAS) 1)
		(SETQ N3 (+ N3 1))

		(SETQ A1  (NTH 0 (NTH (+ N3 0) LIS-LINE-TAG-PLANAS)))
		(SETQ B1  (NTH 1 (NTH (+ N3 0) LIS-LINE-TAG-PLANAS)))

		(SETQ A2  (NTH 0 (NTH (+ N3 1) LIS-LINE-TAG-PLANAS)))
		(SETQ B2  (NTH 1 (NTH (+ N3 1) LIS-LINE-TAG-PLANAS)))

		(COMMAND "COLOR" 2  "3DCARA" B1 A1 A2 B2 "")																	; PINTA 3DCARA  3D 

		(IF (= N3 0 ) (SETQ B1oo  B1))																					; PUNTO INICIO LINEA-REF 

		;============================= PLANO 3DC  3D  
		(COMMAND "SCP" "3P" B1 A1 A2 )
			(SETQ AA1pz (TRANS A1 0 1))    (SETQ AA1p (CAL "XYof( AA1pz )"))									; ? 3DC NO PLANAS RECTIFICAR => Z = 0 
			(SETQ BB1pz (TRANS B1 0 1))    (SETQ BB1p (CAL "XYof( BB1pz )"))
			(SETQ AA2pz (TRANS A2 0 1))    (SETQ AA2p (CAL "XYof( AA2pz )"))
			(SETQ BB2pz (TRANS B2 0 1))    (SETQ BB2p (CAL "XYof( BB2pz )"))

			(SETQ BA11p (CAL " PLT ( BB1p , AA1p , 0.5 )"))															; PUNTO MEDIO

			(COND
				((= N3 0 )
					(COMMAND "COLOR" 5  "LINEA" BB1p AA1p "")															; 1LINEA-REF 3D 
					(COMMAND "COLOR" 5  "TEXTO" "MC" BA11p H-TXT 0 (STRCAT "B=" (ITOA N3) "=A"))			; 1TEXTO LINEA-REF  3D 
				) ; con1

				((EQUAL  B1oo  A1  mUNI )
					(COMMAND "COLOR" 5  "LINEA" BB1p AA1p "")															; LINEA-REF 3D 
					(COMMAND "COLOR" 5  "TEXTO" "MC" BA11p H-TXT 0 (STRCAT "B=" (ITOA N3) "=A"))			; TEXTO LINEA-REF  3D 
				) ; con2
			) ; con
		(COMMAND "SCP" "U" )

		;=============================== PLANO PATRONES 2D  
		(COMMAND "SCP" "3P" KK1 KK2 "" )

			(COMMAND "COLOR" 5 "3DCARA" BB1p AA1p AA2p BB2p "")													; PINTA 3DCARA  2D 

			;                                     (COMMAND "COLOR" 1  "LINEA" AA1p AA2p "")				; LINEAS LATERALES 3DC 2D 
			;(IF (NOT (EQUAL  BB1p  BB2p  mUNI )) (COMMAND "COLOR" 5  "LINEA" BB1p BB2p ""))

			(COND
				((= N3 0 )
					(COMMAND "COLOR" 7  "LINEA" BB1p AA1p "")															; 1LINEA-REF 2D 
					(COMMAND "COLOR" 7  "TEXTO" "MC" BA11p H-TXT 0 (STRCAT "B=" (ITOA N3) "=A"))			; 1TEXTO LINEA-REF  2D 
				) ; con1

				((EQUAL  B1oo  A1  mUNI )
					(COMMAND "COLOR" 7  "LINEA" BB1p AA1p "")															; LINEA-REF 2D 
					(COMMAND "COLOR" 7  "TEXTO" "MC" BA11p H-TXT 0 (STRCAT "B=" (ITOA N3) "=A"))			; TEXTO LINEA-REF  2D
					(SETQ B1oo  B1)
				) ; con2
			) ; con

			(SETQ AA2pU (TRANS AA2p 1 0))
			(SETQ BB2pU (TRANS BB2p 1 0))
		(COMMAND "SCP" "U" )

		(SETQ KK1  BB2pU)
		(SETQ KK2  AA2pU)
	) ; repe

	;	(04)																																											
	;======================================================================================================================================



















  	;======================================================================================================================================
	;	(15) PARANDO																																								
	;......................................................................................................................................
	(SETVAR "blipmode" 1)  (SETVAR "cmdecho"  1)

	(TERPRI) (PROMPT " ============================================================================ ")
	(TERPRI) (PROMPT " >>>>>>>>>>>>>>>>>>>>>>> FINAL - CUERNO-CABRA-01 >>>>>>>>>>>>>>>>>>>>>>>>>>>> ")
	(TERPRI) (PROMPT " ============================================================================ ") (TERPRI)

  	;	(15)																																											
 	;======================================================================================================================================

) ;  DESARROLLO_EJE-BASE_PERFILES-01 

;	(FIN)																																												
;=========================================================================================================================================

