
;-----------------------------------------------------------------------------------------------------------------------------------------
;	( CUERNO-CABRA-23 )                                                                                      	         28/12/2007			
;-----------------------------------------------------------------------------------------------------------------------------------------
;                       ESPIRAL :/EQUIANGULAR/LOGARITMICA/GEOMETRICA     R = Exy * e^(KQQ * AgCuer)   =>   AgCuer = 1/Kp * Log(R/Ko)		
;-----------------------------------------------------------------------------------------------------------------------------------------
;                                                                                                                                         
;	                     PUNTOS EJE (CUERNO) ESPIRAL LOGARITMICA       (EJE) R = Exy * e^(KQQ * AgCuer)												
;	                     PUNTOS CIRCULOS-INICIO (TUBO)																													
;                       SUPERFICIE 3DCs PLANO-TANGENTES a 2 CIRCULOS 																							
;								PATRONES por ### FILAS ###																														
;                                                                                                                                         
;                       CORTE para CREMALLERA (LINEA GEODESICA) EN PROGRAMA																					
;-----------------------------------------------------------------------------------------------------------------------------------------



"########################################################################################################################################"
;-----------------------------------------------------------------------------------------------------------------------------------------
; *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA ***	
;-----------------------------------------------------------------------------------------------------------------------------------------
"########################################################################################################################################"

(DEFUN C:CUERNO-CABRA-23 ( / )

	;======================================================================================================================================
	;  (00) ARRANCANDO																																							
	;......................................................................................................................................

 	(SETVAR "blipmode" 0) (SETVAR "cmdecho" 0)  (GRAPHSCR)  (COMMAND "-REFENT" "DES")  (COMMAND "SCP" "U")  (COMMAND "ORTO" "DES")

	(TERPRI) (PROMPT " ============================================================================ ")
	(TERPRI) (PROMPT " >>>>>>>>>>>>>>>>>>>>>> INICIO - CUERNO-CABRA-23 >>>>>>>>>>>>>>>>>>>>>>>>>>>> ")
	(TERPRI) (PROMPT " ============================================================================ ") (TERPRI)

	(IF (= CAL nil)(COMMAND "ARX" "L" "GEOMCAL.ARX"))		; CARGA CALCULADORA 
	(SETQ mUNI  1.0e-006  )			; MARGEN EQUAL para VECTORES UNITARIOS  1.02e-006   (( 1.01e-008 ) de LIMITE-MAR-INTER-RECT-01 lsp) 

	;	(00)																																											
	;======================================================================================================================================

 	;======================================================================================================================================
	;	(01) FIJAR VARIABLES EN EL PROGRAMA																																	
	;......................................................................................................................................

	(SETQ NVUEL-CUER      3  )							; N de VUELTAS CUERNO

	(SETQ PUN-VUEL-CUER  500  )							; PUN por VUELTA  CUERNO 

	(SETQ NCIRC-TUBO     50  )							; N de CIRCULOS del TUBO por VUELTA ( Multiplo de PUN-VUEL-CUER )

	(SETQ PUN-CIRC-TUBO   24  )							; PUN por CIRCULO  TUBO  

	(SETQ ALT  400.0  )			; ALTURA TOTAL ESPIRAL 


	(SETQ KRTubo 0.5  )			; FACTOR RADIO-TUBO = RR12c * KRTubo 

	(SETQ Exy    1.0  )			; ESCALA-XY  1PUN=>X  ESPIRAL 
	(SETQ KQQ    0.2  )			; PASO ??                      

	(SETQ KKx  2100   )			; PUNTO OREGEN PATRONES 
	(SETQ KKy  -660   )

	(SETQ DIS-P 110   )			; DISTANCIA ENTRE PATRONES 

	(SETQ H-TXT  4    )			; ALTURA TEXTO

	(SETQ NP-CUER-entre-CIRC (/ PUN-VUEL-CUER   NCIRC-TUBO ))		; N PUNTOS CUERNO entre CIRCULOS del TUBO 

	;	(01)																																											
	;======================================================================================================================================


 	;======================================================================================================================================
	;	(02) PUNTOS ESPIRAL LOGARITMICA  (EJE CUERNO) R = Exy * e^(KQQ * AgCuer)																				
	;......................................................................................................................................

	(SETQ LIS-P-ESPIRAL-EJE-CUERNO  nil)

	(SETQ NPUN-TOTAL  (* NVUEL-CUER  PUN-VUEL-CUER) )

	(SETQ SUMA-PA (/ (* NPUN-TOTAL (- NPUN-TOTAL 1 )) 2 ))				; SUMA PROGRESION ARITMETICA  (+ 0 1 2 ... n) Sn= n*(A1 + An)/2 

	(SETQ AlUniC (/ ALT  SUMA-PA ))												; ALTURA-Z UNITARIO EJE CUERNO 
	(SETQ AlCuer (+ ALT  AlUniC))

	(SETQ AgUniC (/ (* 2 PI) PUN-VUEL-CUER ))																; ANGULO UNITARIO EJE CUERNO 
	(SETQ AgCuer (- (* 2 PI) AgUniC))																		; Enpieza en (* 2 PI) Escala 

	(SETQ NPP -1 )

	(REPEAT (+ NPUN-TOTAL 2 )

		(SETQ NPP (+ NPP 1 ))

		(SETQ AgCuer (+ AgCuer  AgUniC))

		(SETQ AlCuer (- AlCuer  (* AlUniC  NPP )))

		(SETQ RR (* Exy (EXP (* KQQ  AgCuer))))															; (EJE CUERNO) R = Exy * e^(KQQ * AgCuer)

		(SETQ XXc (* RR (COS AgCuer)))
		(SETQ YYc (* RR (SIN AgCuer)))
		(SETQ ZZc  AlCuer )
		(SETQ PPc (LIST XXc YYc ZZc ))

		;(COMMAND "COLOR" 2 "PUNTO" PPc )

		(SETQ LIS-P-ESPIRAL-EJE-CUERNO  (CONS (LIST PPc RR )  LIS-P-ESPIRAL-EJE-CUERNO ))

	) ; repe

	(SETQ LIS-P-ESPIRAL-EJE-CUERNO   (REVERSE  LIS-P-ESPIRAL-EJE-CUERNO ))						; (LENGTH LIS-P-ESPIRAL-EJE-CUERNO ) 

	;	(02)																																											
	;======================================================================================================================================

 	;======================================================================================================================================
	;	(03)    =>  LIS-2P-EJE/Z-RADI     																																	
	;......................................................................................................................................

	(SETQ LIS-2P-EJE/Z-RADI  nil )

	(SETQ NPunCU -1)
	(REPEAT  (- (LENGTH  LIS-P-ESPIRAL-EJE-CUERNO ) 1 )
		(SETQ NPunCU (+ NPunCU 1))

		(SETQ PP1c  (NTH 0 (NTH (+ NPunCU 0) LIS-P-ESPIRAL-EJE-CUERNO)))						; (LIST PPc RR )
		(SETQ PP2c  (NTH 0 (NTH (+ NPunCU 1) LIS-P-ESPIRAL-EJE-CUERNO)))
		(SETQ PP12c (CAL " PLT ( PP1c , PP2c , 0.5 )"))													; PUNTO MEDIO 

		(SETQ RR1c  (NTH 1 (NTH (+ NPunCU 0) LIS-P-ESPIRAL-EJE-CUERNO)))
		(SETQ RR2c  (NTH 1 (NTH (+ NPunCU 1) LIS-P-ESPIRAL-EJE-CUERNO)))
		(SETQ RR12c (/ (+ RR1c RR2c ) 2.0 ))																; RADIO MEDIO 

		(COMMAND "COLOR" 5  "LINEA" PP1c PP2c "")															; EJE ESPIRAL CUERNO 

		(IF (= (REM  NPunCU  NP-CUER-entre-CIRC ) 0 )
			(PROGN
				"======== LIS-2P-EJE/Z-RADI ================================================================"
				(SETQ LIS-2P-EJE/Z-RADI  (CONS (LIST PP12c PP2c (* KRTubo RR12c ))  LIS-2P-EJE/Z-RADI ))
			) ; pro
		) ; if
	) ; repe

	(SETQ LIS-2P-EJE/Z-RADI  (REVERSE  LIS-2P-EJE/Z-RADI ))								; (LENGTH LIS-2P-EJE/Z-RADI ) 

	;	(03)																																											
	;======================================================================================================================================


 	;======================================================================================================================================
	;	(04)    =>  LIS-PUN-INICIO-1     																																	
	;......................................................................................................................................

	(SETQ LIS-PUN-INICIO-1 nil )

		(SETQ C0 (NTH 0 (NTH 0 LIS-2P-EJE/Z-RADI)))    
		(SETQ Z0 (NTH 1 (NTH 0 LIS-2P-EJE/Z-RADI)))    
		(SETQ R0 (NTH 2 (NTH 0 LIS-2P-EJE/Z-RADI)))    

		(COMMAND "SCP" "EZ" C0 Z0 )
			(SETQ AgUNI (/ (* 2 PI) PUN-CIRC-TUBO ))
			(SETQ AAg (- AgUNI ))

				(REPEAT PUN-CIRC-TUBO
					(SETQ AAg (+ AAg  AgUNI))
					(SETQ PCiniP (LIST (* R0 (COS AAg))  (* R0 (SIN AAg))  0.0 ))
					;(COMMAND "COLOR" 2  "PUNTO" PCiniP )												; PUNTOS CIRCULO INICIO 

					(SETQ PCini (TRANS PCiniP 1 0 ))
					(SETQ LIS-PUN-INICIO-1 (CONS PCini  LIS-PUN-INICIO-1 ))
				) ; repe
		(COMMAND "SCP" "U" )

		(SETQ LIS-PUN-INICIO-1  (REVERSE  LIS-PUN-INICIO-1 ))												; (LENGTH LIS-PUN-INICIO-1 ) 

	;	(04)																																											
	;======================================================================================================================================



 	;======================================================================================================================================
	;	(05) PUNTOS INTERSECCION entre PLANOS-CIRCULOS   (CHARNELA)     LIS-2P-EJE/Z-RADI																	
	;......................................................................................................................................

	(SETQ LIS-PUN-CHARNELA  nil)
   "---------------------------------------------------------------------------------------------------------"
	(SETQ NC1 -1)
	(REPEAT (- (LENGTH LIS-2P-EJE/Z-RADI ) 1 )
		(SETQ NC1 (+ NC1 1))

		(SETQ LIS-P-EJE/Z-RAD-1 (NTH (+ NC1 0) LIS-2P-EJE/Z-RADI))			; (LIST  PP12c  PP2c  RRcir )
		(SETQ LIS-P-EJE/Z-RAD-2 (NTH (+ NC1 1) LIS-2P-EJE/Z-RADI))

		(SETQ C1 (NTH 0 LIS-P-EJE/Z-RAD-1))    (SETQ C2 (NTH 0 LIS-P-EJE/Z-RAD-2))
		(SETQ Z1 (NTH 1 LIS-P-EJE/Z-RAD-1))    (SETQ Z2 (NTH 1 LIS-P-EJE/Z-RAD-2))
		(SETQ R1 (NTH 2 LIS-P-EJE/Z-RAD-1))    (SETQ R2 (NTH 2 LIS-P-EJE/Z-RAD-2))
   "---------------------------------------------------------------------------------------------------------"
		(COMMAND "SCP" "EZ" C1 Z1 )			; PLANO A 

			(SETQ PInter1a (LIST (* R1 (COS (+ (/ PI 4))))  (* R1 (SIN (+ (/ PI 4))))  0.0 ))
			(SETQ PInter2a (LIST (* R1 (COS (- (/ PI 4))))  (* R1 (SIN (- (/ PI 4))))  0.0 ))

			(SETQ PInter1 (TRANS PInter1a 1 0 ))
			(SETQ PInter2 (TRANS PInter2a 1 0 ))

			(SETQ C100 (TRANS (LIST 0 0) 1 0 ))

			(IF (= NC1 0) (COMMAND "COLOR" 8 "CIRCULO" (LIST 0 0 0) R1 ))

		(COMMAND "SCP" "U" )
   "---------------------------------------------------------------------------------------------------------"
		(COMMAND "SCP" "EZ" C2 Z2 )			; PLANO B 

			(SETQ PInter1b (TRANS PInter1 0 1 ))    (SETQ PInter1b0 (CAL "XYof( PInter1b )"))
			(SETQ PInter2b (TRANS PInter2 0 1 ))    (SETQ PInter2b0 (CAL "XYof( PInter2b )"))
			(SETQ C100b    (TRANS C100    0 1 ))    (SETQ C100b0    (CAL "XYof( C100b    )"))

			(SETQ PInter10 (TRANS PInter1b0 1 0 ))
			(SETQ PInter20 (TRANS PInter2b0 1 0 ))
			(SETQ C1000    (TRANS C100b0    1 0 ))



			(IF ( = NC1 0) (COMMAND "COLOR" 8 "CIRCULO" (LIST 0 0 0) R2 ))
			(IF (/= NC1 0) (COMMAND "COLOR" 8 "CIRCULO" (LIST 0 0 0) R2 ))

		(COMMAND "SCP" "U" )
   "---------------------------------------------------------------------------------------------------------"
		(SETQ INTER1 (CAL "ILL( C1 , PInter1 , C1000 , PInter10 )"))
		(SETQ INTER2 (CAL "ILL( C1 , PInter2 , C1000 , PInter20 )"))

		(SETQ LIS-PUN-CHARNELA (CONS (LIST INTER1  INTER2 )  LIS-PUN-CHARNELA ))

	) ; repe

		(SETQ LIS-PUN-CHARNELA  (REVERSE  LIS-PUN-CHARNELA ))								; (LENGTH LIS-PUN-CHARNELA ) 

	;	(05)																																											
	;======================================================================================================================================


 	;======================================================================================================================================
	;	(06) PUN-TANG-CIRCULOS <= PLANO-TANG-CIRCULOS   TANG-COPLANARIAS																							
	;......................................................................................................................................

	(SETQ LIS-PUN-TAG-CIRCU-TODOS  nil)

	(SETQ NC2 -1)
	(REPEAT  (- (LENGTH LIS-2P-EJE/Z-RADI ) 1 )
		(SETQ NC2 (+ NC2 1))

		(SETQ C1 (NTH 0 (NTH (+ NC2 0) LIS-2P-EJE/Z-RADI)))			; ( PP12c  PP2c  RRcir )
		(SETQ Z1 (NTH 1 (NTH (+ NC2 0) LIS-2P-EJE/Z-RADI)))
		(SETQ R1 (NTH 2 (NTH (+ NC2 0) LIS-2P-EJE/Z-RADI)))			; CIRCULO-1  ( C1 Z1 R1 )

		(SETQ C2 (NTH 0 (NTH (+ NC2 1) LIS-2P-EJE/Z-RADI)))
		(SETQ Z2 (NTH 1 (NTH (+ NC2 1) LIS-2P-EJE/Z-RADI)))
		(SETQ R2 (NTH 2 (NTH (+ NC2 1) LIS-2P-EJE/Z-RADI)))			; CIRCULO-2  ( C2 Z2 R2 )

		(SETQ CHa (NTH 0 (NTH NC2  LIS-PUN-CHARNELA)))					; ( INTER1  INTER2 )
		(SETQ CHb (NTH 1 (NTH NC2  LIS-PUN-CHARNELA)))

		(SETQ LIS-PUN-INICIO-2   nil )
		(SETQ LIS-PUN-TAG-CIRCU  nil )

		(SETQ NC3 -1)
		(REPEAT  (LENGTH LIS-PUN-INICIO-1 )
			(SETQ NC3 (+ NC3 1))

			(SETQ PiniCir1 (NTH NC3  LIS-PUN-INICIO-1))					; PCini

			"=========================== CIRCULO-1 ==========================================================================================="

			(COMMAND "SCP" "EZ" C1 Z1 )					; PLANO-C  CIRCULO-1 

				(SETQ PiniCir1c (TRANS PiniCir1 0 1 ))      (SETQ PiniCir1c0 (CAL "XYof( PiniCir1c )"))
				(SETQ CHaC      (TRANS CHa      0 1 ))      (SETQ CHaC0      (CAL "XYof( CHaC )"     ))
				(SETQ CHbC      (TRANS CHb      0 1 ))      (SETQ CHbC0      (CAL "XYof( CHbC )"     ))

				(SETQ Pooo (LIST 0 0 0))

				;(COMMAND "COLOR" 1  "LINEA" PiniCir1c0 Pooo "")												; RADIO CIRCULO INICIO 
				;(COMMAND "COLOR" 5  "LINEA" CHaC0  CHbC0 "" )													; LINEA CHARNELA 

				(SETQ TagPiniC  (CAL "ROT( Pooo , PiniCir1c0 , 90 )"))										; GIRA CENTRO 90 Sobre PUNTO-Cir => Tag 

				(SETQ PTg00 (TRANS PiniCir1c0 1 0 ))
				(SETQ PTg01 (TRANS TagPiniC   1 0 ))
				(SETQ LIS-PUN-TAG-CIRCU (CONS (LIST PTg00  PTg01 ) LIS-PUN-TAG-CIRCU ))

				(SETQ ChPinic (CAL "ILL( PiniCir1c0 , TagPiniC , CHaC0 , CHbC0 )"))						; PUN-CHARNELA 

				;(COMMAND "COLOR" 3  "LINEA" PiniCir1c0  TagPiniC "" )										; TAG-Ra 
				;(COMMAND "COLOR" 4  "PUNTO" ChPinic )																; PUNTO CH 

				(SETQ ChPini  (TRANS ChPinic 1 0 ))
			(COMMAND "SCP" "U" )

			"=========================== CIRCULO-2 ==========================================================================================="

			(COMMAND "SCP" "EZ" C2 Z2 )					; PLANO-D  CIRCULO-2 

				(SETQ ChPiniD (TRANS ChPini 0 1 ))      (SETQ ChPiniD0 (CAL "XYof( ChPiniD )"))

				(COMMAND "SCP" "3P" Pooo ChPiniD0 "")	; PLANO-Dx  CIRCULO-2 

					(SETQ DIS2  (DISTANCE ChPiniD0 Pooo ))

					(SETQ K2 (/ (+ (/ DIS2 2) (/ DIS2 2) R2 ) 2))
					(SETQ Area2 (SQRT (* K2 (- K2 (/ DIS2 2)) (- K2 (/ DIS2 2)) (- K2 R2))))				; AREA TRIANGULO ( DIS2 DIS2 R2 ) 
					(SETQ YY (/ (* 2 Area2) (/ DIS2 2)))
					(SETQ XX (SQRT (- (* R2 R2) (* YY YY))))

					(SETQ PUN-Tg2d-1 (LIST XX (+ YY )))							; INTERSECCION CIRCULO-2 con CIRCULO-CAPAZ (/ DIS2 2)
					(SETQ PUN-Tg2d-2 (LIST XX (- YY )))

					(SETQ PUN-Tg2-1  (TRANS PUN-Tg2d-1 1 0 ))
					(SETQ PUN-Tg2-2  (TRANS PUN-Tg2d-2 1 0 ))

			(COMMAND "SCP" "U" )
			"================================================================================================================================="

			(SETQ DIS-T1 (DISTANCE PUN-Tg2-1  PiniCir1 ))
			(SETQ DIS-T2 (DISTANCE PUN-Tg2-2  PiniCir1 ))

			(IF (< DIS-T1  DIS-T2 ) (SETQ PUN-Tg2  PUN-Tg2-1 ) (SETQ PUN-Tg2  PUN-Tg2-2 ))
			(SETQ LIS-PUN-INICIO-2  (CONS PUN-Tg2  LIS-PUN-INICIO-2 ))

			;(COMMAND "COLOR" 1  "LINEA" PiniCir1  PUN-Tg2 "")													; PUNTOS TANGENCIA PLANO-CIRCULOS

		) ; repe

		(SETQ LIS-PUN-INICIO-2 (REVERSE LIS-PUN-INICIO-2 ))															; (LENGTH LIS-PUN-INICIO-2 )
		(SETQ LIS-PUN-INICIO-1          LIS-PUN-INICIO-2 )

		(SETQ LIS-PUN-TAG-CIRCU (CONS (NTH (- (LENGTH LIS-PUN-TAG-CIRCU ) 1 ) LIS-PUN-TAG-CIRCU ) LIS-PUN-TAG-CIRCU ))	; COPIA 1 en PENULTIMO 
		(SETQ LIS-PUN-TAG-CIRCU (CONS (NTH (- (LENGTH LIS-PUN-TAG-CIRCU ) 2 ) LIS-PUN-TAG-CIRCU ) LIS-PUN-TAG-CIRCU ))	; COPIA 2 en ULTIMO    

		(SETQ LIS-PUN-TAG-CIRCU (REVERSE    LIS-PUN-TAG-CIRCU ))														; (LENGTH LIS-PUN-TAG-CIRCU )

		(SETQ LIS-PUN-TAG-CIRCU-TODOS (CONS LIS-PUN-TAG-CIRCU   LIS-PUN-TAG-CIRCU-TODOS ))

	) ; repe

	(SETQ LIS-PUN-TAG-CIRCU-TODOS (REVERSE LIS-PUN-TAG-CIRCU-TODOS ))												; (LENGTH LIS-PUN-TAG-CIRCU-TODOS ) 

	;	(06)																																											
	;======================================================================================================================================


 
 	;======================================================================================================================================
	;	(07) INTERSECCION TAGENTES CIRCULOS	 =>  3DCARAS											   																
	;......................................................................................................................................

	(SETQ LIS-FILAS-3DC-TODAS  nil )

	(SETQ NFI -1)																											; # PUN-TAG COLUMNAS 
	(REPEAT  (- (LENGTH LIS-PUN-TAG-CIRCU-TODOS ) 1 )															; ( LIS (LIS   PTg00  PTg01 ) ... ) 
		(SETQ NFI (+ NFI 1))

		(SETQ LIS-PUN-TAG-A (NTH (+ NFI 0) LIS-PUN-TAG-CIRCU-TODOS))					; (LENGTH LIS-PUN-TAG-A )  ( LIS  PTg00 PTg01 )... 
		(SETQ LIS-PUN-TAG-B (NTH (+ NFI 1) LIS-PUN-TAG-CIRCU-TODOS))					; (LENGTH LIS-PUN-TAG-B )  ( LIS  PTg00 PTg01 )... 

		(SETQ LIS-FILA-3DC  nil )

		(SETQ NCO -1)
		(REPEAT  (- (LENGTH LIS-PUN-TAG-A ) 2 )																	; # PUN-TAG FILAS    
			(SETQ NCO (+ NCO 1))

			(SETQ PA1a (NTH 0 (NTH (+ NCO 0) LIS-PUN-TAG-A)))			(SETQ PB1a (NTH 0 (NTH (+ NCO 0) LIS-PUN-TAG-B)))
			(SETQ PA1b (NTH 1 (NTH (+ NCO 0) LIS-PUN-TAG-A)))			(SETQ PB1b (NTH 1 (NTH (+ NCO 0) LIS-PUN-TAG-B)))

			(SETQ PA2a (NTH 0 (NTH (+ NCO 1) LIS-PUN-TAG-A)))			(SETQ PB2a (NTH 0 (NTH (+ NCO 1) LIS-PUN-TAG-B)))
			(SETQ PA2b (NTH 1 (NTH (+ NCO 1) LIS-PUN-TAG-A)))			(SETQ PB2b (NTH 1 (NTH (+ NCO 1) LIS-PUN-TAG-B)))

			(SETQ PA3a (NTH 0 (NTH (+ NCO 2) LIS-PUN-TAG-A)))			(SETQ PB3a (NTH 0 (NTH (+ NCO 2) LIS-PUN-TAG-B)))
			(SETQ PA3b (NTH 1 (NTH (+ NCO 2) LIS-PUN-TAG-A)))			(SETQ PB3b (NTH 1 (NTH (+ NCO 2) LIS-PUN-TAG-B)))

			(SETQ AA1 (CAL "ILL( PA1a , PA1b , PA2a , PA2b )"))												; PUN INTER TAG A 
			(SETQ AA2 (CAL "ILL( PA2a , PA2b , PA3a , PA3b )"))

			(SETQ BB1 (CAL "ILL( PB1a , PB1b , PB2a , PB2b )"))												; PUN INTER TAG B 
			(SETQ BB2 (CAL "ILL( PB2a , PB2b , PB3a , PB3b )"))

			;(COMMAND "COLOR" 2  "3DCARA" AA1 AA2 BB2 BB1 "")													; 3DCARA 3D 

			(SETQ LIS-FILA-3DC (CONS (LIST (+ NFI 1 ) (+ NCO 1 )  AA1 AA2 BB2 BB1 ) LIS-FILA-3DC ))

		) ; repe

		(SETQ LIS-FILA-3DC        (REVERSE  LIS-FILA-3DC ))													; (LENGTH LIS-FILA-3DC )
		(SETQ LIS-FILAS-3DC-TODAS (CONS LIS-FILA-3DC   LIS-FILAS-3DC-TODAS ))

	) ; repe

	(SETQ LIS-FILAS-3DC-TODAS (REVERSE  LIS-FILAS-3DC-TODAS ))												; (LENGTH LIS-FILAS-3DC-TODAS ) 

	;	(07)																																											
	;======================================================================================================================================




 	;======================================================================================================================================
	;	(08) PINTA SUPERFICIE  3DC =>  2D PATRONES    POR FILAS						   																			
	;......................................................................................................................................

	(SETQ LIS-3DC-FIL/COL-3D/2D  nil )

	(SETQ NFILA -1)
	(REPEAT (LENGTH LIS-FILAS-3DC-TODAS )																				; COLUMNAS x FILAS  TODAS de 3DC 
		(SETQ NFILA (+ NFILA 1))

		(SETQ LIS-UNA-FILA-3DC (NTH NFILA  LIS-FILAS-3DC-TODAS ))												; UNA FILAS de 3DC 

		(SETQ KK1 (LIST (-    KKx       (* DIS-P  NFILA ))  KKy  0 ))											; PUNTO ORIGEN PIEZA-FILA 
		(SETQ KK2 (LIST (- (+ KKx  10 ) (* DIS-P  NFILA ))  KKy  0 ))

		(SETQ NCOLU -1)
		(REPEAT (LENGTH LIS-UNA-FILA-3DC )																				; FILAS 
			(SETQ NCOLU (+ NCOLU 1))

			(SETQ UNA-3DC (NTH NCOLU  LIS-UNA-FILA-3DC ))															; UNA 3DC ( NFI  NCO  AA1 AA2 BB2 BB1 ) 

			(SETQ NF    (NTH 0 UNA-3DC))    																			; N  FILA  
			(SETQ NC    (NTH 1 UNA-3DC))    																			; N  COLUM 

			(SETQ A1u3D  (NTH 2 UNA-3DC))    																			; 3DCARA-U  3D 
			(SETQ A2u3D  (NTH 3 UNA-3DC))    
			(SETQ B2u3D  (NTH 4 UNA-3DC))    
			(SETQ B1u3D  (NTH 5 UNA-3DC))    

			(COMMAND "COLOR" 2  "3DCARA" B1u3D  A1u3D  A2u3D  B2u3D "")											; PINTA  3DCARA-U  3D 

			;======================================== PLANO 3DC  3D      												
			(COMMAND "SCP" "3P" B1u3D  A1u3D  B2u3D )

				(SETQ AA1pz (TRANS A1u3D 0 1 ))    (SETQ AA1p (CAL "XYof( AA1pz )"))							; 3DC PLANAS RECTIFICAR => Z = 0 
				(SETQ AA2pz (TRANS A2u3D 0 1 ))    (SETQ AA2p (CAL "XYof( AA2pz )"))
				(SETQ BB2pz (TRANS B2u3D 0 1 ))    (SETQ BB2p (CAL "XYof( BB2pz )"))
				(SETQ BB1pz (TRANS B1u3D 0 1 ))    (SETQ BB1p (CAL "XYof( BB1pz )"))

				(SETQ LA12 (CAL " PLT ( AA1p , AA2p , 0.5 )"))														; PUNTO MEDIO LADO-A 
				(SETQ LB12 (CAL " PLT ( BB1p , BB2p , 0.5 )"))														; PUNTO MEDIO LADO-B 
				(SETQ MeAB (CAL " PLT ( LA12 , LB12 , 0.5 )"))														; PUNTO MEDIO CENTROS LADOS
				(SETQ H-Tx (* (DISTANCE LA12 LB12 ) (/ 0.8 3.7)))													; ALTURA TXT Proporcional-DisB1A1

				(SETQ NFI/CO (+ (* (+ NFILA 1) 100 ) (+ NCOLU 1)))

				(COMMAND "COLOR" 3  "TEXTO" "MC" MeAB  H-Tx  0 (ITOA NFI/CO))									; TEXTO LINEA-REF  3D 

			(COMMAND "SCP" "U" )

			;======================================== PLANO PATRONES 2D  										
			(COMMAND "SCP" "3P" KK1 KK2 "" )

				(COMMAND "COLOR" 7  "3DCARA" BB1p AA1p AA2p BB2p "")												; PINTA  3DCARA-p  2D 

				(SETQ B1u2D (TRANS BB1p 1 0 ))   																		; 3DCARA-U  2D 
				(SETQ A1u2D (TRANS AA1p 1 0 ))
				(SETQ A2u2D (TRANS AA2p 1 0 ))
				(SETQ B2u2D (TRANS BB2p 1 0 ))

				(SETQ LIS-3DC-FIL/COL-3D/2D (CONS (LIST B1u2D  A1u2D  A2u2D  B2u2D ) LIS-3DC-FIL/COL-3D/2D ))
				(SETQ LIS-3DC-FIL/COL-3D/2D (CONS (LIST B1u3D  A1u3D  A2u3D  B2u3D ) LIS-3DC-FIL/COL-3D/2D ))
				(SETQ LIS-3DC-FIL/COL-3D/2D (CONS  NFI/CO                           LIS-3DC-FIL/COL-3D/2D )) ;(LENGTH LIS-3DC-FIL/COL-3D/2D )

				(COMMAND "COLOR" 5  "TEXTO" "MC" MeAB  H-Tx  0 (ITOA NFI/CO))								; TEXTO LINEA-REF  2D 

			(COMMAND "SCP" "U" )

			(SETQ  KK1  B2u2D )
			(SETQ  KK2  A2u2D )

		) ; repe  COLUMNAS 
	) ; repe  FILAS 

	;	(08)																																											
	;======================================================================================================================================


 	;======================================================================================================================================
	;	(09) CORTE PARA CREMALLERA (LINEA GEODESICA)												   																	
	;......................................................................................................................................
	;                                                                                                                                   
	;              P2V4 |     (NORTE)  NFI/CO+1      | P2V3          (SETQ IN-SU (INTERS PLg1 Vec2  P2V1 P2V2)) (SUR)    NFI/CO-1     
	;                 --O-----------------------------O--             (SETQ IN-ES (INTERS PLg1 Vec2  P2V2 P2V3)) (ESTE)   NFI-1/CO     
	;                   |                      AngLG  |               (SETQ IN-NO (INTERS PLg1 Vec2  P2V3 P2V4)) (NORTE)  NFI/CO+1     
	;                   |                          oo(#) PIn2         (SETQ IN-OE (INTERS PLg1 Vec2  P2V4 P2V1)) (OESTE)  NFI+1/CO     
	;                   |       PLg1+VecG     oooo    |                                                                                 
	;           (OESTE) |              (#)ooo         | (ESTE)                                                                          
	;         NFI+1/CO |         oooo                | NFI-1/CO                                                                       
	;                   |    oooo                     |                                                                                 
	;             PLg1 (#)oo           NFI/CO        |                                                                                 
	;                   |                             |                                                                                 
	;                 --O-----------------------------O--                                                                               
	;              P2V1 |      (SUR)   NFI/CO-1      | P2V2                                                                            
	;                                                                                                                                   

	(PROMPT "---- MARCAR INICIO/3DC-3D  >>> N-3DC <<< >>> LINE-GEO <<< (TOCA LADOS 3DC)") (TERPRI)
	(SETQ CONJJ (SSGET))

	(COMMAND "-CAPA" "E" "XX - LINEA-GEODESICA" "" )							; CREA y ACTIBA CAPA XX 

	;	PRIMERA  3DCARA  INICIO																									

	(SETQ NTFi (+ (* NVUEL-CUER  NCIRC-TUBO ) 2))		;  74 ??? 
	(SETQ NTCo  PUN-CIRC-TUBO )									;  16 

	(SETQ N3dc0 (ATOI (CDR (ASSOC 1 (ENTGET (SSNAME CONJJ 0 ))))))												; N3DC INICIO 
	(SETQ 3DC-3D (NTH 1 (MEMBER  N3dc0  LIS-3DC-FIL/COL-3D/2D )))
   	(SETQ pV1 (NTH 0 3DC-3D ))																								; PunVer-3DC  3D  SCU 
		(SETQ pV2 (NTH 1 3DC-3D ))
		(SETQ pV3 (NTH 2 3DC-3D ))
		(SETQ pV4 (NTH 3 3DC-3D ))

	(SETQ PLg1  (CDR (ASSOC 10 (ENTGET (SSNAME CONJJ 1 )))))															; LINEA INICIO POCA LADOS 3DC 
	(SETQ PLg2  (CDR (ASSOC 11 (ENTGET (SSNAME CONJJ 1 )))))

	(COMMAND "COLOR" 8  "3DCARA" pV1  pV2  pV3  pV4 "")																; PINTA  3DCARA-p  3D SCU 
	(COMMAND "COLOR" 7  "LINEA"  PLg1  PLg2  "")

		(SETQ LA12 (CAL " PLT ( pV1 , pV2 , 0.5 )"))																		; PUNTO MEDIO LADO-A 
		(SETQ LB12 (CAL " PLT ( pV4 , pV3 , 0.5 )"))																		; PUNTO MEDIO LADO-B 
		(SETQ MeAB (CAL " PLT ( LA12 , LB12 , 0.5 )"))																	; PUNTO MEDIO CENTROS LADOS
		(SETQ H-Tx (* (DISTANCE LA12 LB12 ) (/ 0.8 3.7)))																; ALTURA TXT Proporcional-DisB1A1
		(COMMAND "COLOR" 8  "TEXTO" "MC" MeAB  H-Tx  0 (ITOA N3dc0))												; TEXTO LINEA-REF  3D 

	(SETQ V1   (CAL " NOR ( pV1 , pV2 , pV3 )"))																			; VECTOR NORMAL PLANO 3DC
	(SETQ AgG1 (CAL " ANG ( PLg2 , pV3 , PLg1 , PLg2 + V1 )"))														; ANGULO  LINE-GEO 

	;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

	(SETQ NFF  (FIX (/ N3dc0 100)))																						; 1...74 
	(SETQ NCC  (REM    N3dc0 100))																							; 1...16

	(IF (> (+ NFF 1) NTFi) (PROGN (SETQ WW1 nil) (PROMPT " INICIO BORDE ARRIBA") (TERPRI)) (SETQ NF+1 (+ NFF 1)))
	(IF (< (- NFF 1)   1  ) (PROGN (SETQ WW1 nil) (PROMPT " INICIO BORDE ABAJO ") (TERPRI)) (SETQ NF-1 (- NFF 1)))

	(IF (> (+ NCC 1) NTCo) (SETQ NC+1   1  ) (SETQ NC+1 (+ NCC 1)))
	(IF (< (- NCC 1)   1  ) (SETQ NC-1 NTCo) (SETQ NC-1 (- NCC 1)))

	(SETQ N3dc-SU (+ (* NFF  100 ) NC-1 ))																				; N3dc-(SUR)   
	(SETQ N3dc-ES (+ (* NF-1 100 ) NCC  ))																				; N3dc-(ESTE)  
	(SETQ N3dc-NO (+ (* NFF  100 ) NC+1 ))																				; N3dc-(NORTE) 
	(SETQ N3dc-OE (+ (* NF+1 100 ) NCC  ))																				; N3dc-(OESTE) 

	(SETQ InSU1 (INTERS pV1 pV2   PLg1 PLg2 ))																			; PUNTO INTERSECCION L-GEO con LADO
	(SETQ InES1 (INTERS pV2 pV3   PLg1 PLg2 ))
	(SETQ InNO1 (INTERS pV3 pV4   PLg1 PLg2 ))
	(SETQ InOE1 (INTERS pV4 pV1   PLg1 PLg2 ))

	(COND
		((AND (/= InSU1 nil) (NOT (EQUAL InSU1 PLg1 mUNI)))  (SETQ  N3dc1  N3dc-SU )) 						; (SUR)  
		((AND (/= InES1 nil) (NOT (EQUAL InES1 PLg1 mUNI)))  (SETQ  N3dc1  N3dc-ES )) 						; (ESTE) 
		((AND (/= InNO1 nil) (NOT (EQUAL InNO1 PLg1 mUNI)))  (SETQ  N3dc1  N3dc-NO )) 						; (NORTE)
		((AND (/= InOE1 nil) (NOT (EQUAL InOE1 PLg1 mUNI)))  (SETQ  N3dc1  N3dc-OE )) 						; (OESTE)
		( T   (PROMPT ">>>>>>>>>> NO INTERSECCION CON LADOS en INICIO  ??? ") (TERPRI))
	) ; con


	;	RESTO  3DCARA																												

	(SETQ CONTA 0 )
	(SETQ WW1   T )
	(WHILE WW1

		(SETQ CONTA (+ CONTA 1))																								; (LENGTH LIS-3DC-FIL/COL-3D/2D ) 630

		(SETQ 3DC-3D (NTH 1 (MEMBER  N3dc1   LIS-3DC-FIL/COL-3D/2D )))
   		(SETQ pV1 (NTH 0 3DC-3D ))																							; PunVer-3DC  3D  SCU 
			(SETQ pV2 (NTH 1 3DC-3D ))
			(SETQ pV3 (NTH 2 3DC-3D ))
			(SETQ pV4 (NTH 3 3DC-3D ))

		(COMMAND "SCP" "3P" pV1  pV2  pV4 )																					; ### SCP  N3dc1  3D ### 
			(SETQ pV1pz (TRANS pV1 0 1 ))   (SETQ pV1p (CAL "XYof( pV1pz )"))
			(SETQ pV2pz (TRANS pV2 0 1 ))   (SETQ pV2p (CAL "XYof( pV2pz )"))
			(SETQ pV3pz (TRANS pV3 0 1 ))   (SETQ pV3p (CAL "XYof( pV3pz )"))
			(SETQ pV4pz (TRANS pV4 0 1 ))   (SETQ pV4p (CAL "XYof( pV4pz )"))
			(SETQ PLg1  PLg2 )																									; 2PUN 13DC => 1PUN 23DC 
			(SETQ PLg1pz (TRANS PLg1 0 1 ))   (SETQ PLg1p (CAL "XYof( PLg1pz )"))

			;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

			(SETQ NFF  (FIX (/ N3dc1 100)))																				; 1...74 
			(SETQ NCC  (REM    N3dc1 100))																					; 1...16

			(IF (> (+ NFF 1) NTFi) (PROGN (SETQ WW1 nil) (PROMPT " FIN BORDE ARRIBA ") (TERPRI)) (SETQ NF+1 (+ NFF 1)))
			(IF (< (- NFF 1)   1  ) (PROGN (SETQ WW1 nil) (PROMPT " FIN BORDE ABAJO " ) (TERPRI)) (SETQ NF-1 (- NFF 1)))

			(IF (> (+ NCC 1) NTCo) (SETQ NC+1   1  ) (SETQ NC+1 (+ NCC 1)))
			(IF (< (- NCC 1)   1  ) (SETQ NC-1 NTCo) (SETQ NC-1 (- NCC 1)))

			(SETQ N3dc-SU (+ (* NFF  100 ) NC-1 ))																		; N3dc-(SUR)   
			(SETQ N3dc-ES (+ (* NF-1 100 ) NCC  ))																		; N3dc-(ESTE)  
			(SETQ N3dc-NO (+ (* NFF  100 ) NC+1 ))																		; N3dc-(NORTE) 
			(SETQ N3dc-OE (+ (* NF+1 100 ) NCC  ))																		; N3dc-(OESTE) 

			;--------------------------------------------------------------------------------------------
			; 1PUNTO (PLg1p) en LADO ( SUR  ESTE  NORTE  OESTE ) 													
			;--------------------------------------------------------------------------------------------
			(COND
				((EQUAL (DISTANCE pV1p pV2p ) (+ (DISTANCE pV1p PLg1p ) (DISTANCE pV2p PLg1p )) mUNI ) 	; CON-SUR 

					;(SETQ LA-ENTRA 'SUR)

					(SETQ PDirLG (CAL " ROT ( pV2p , PLg1p , AgG1 )"))												; PUNTO-DIR L-GEO SUR 
					(SETQ InES (INTERS pV2p pV3p   PLg1p PDirLG nil ))
					(SETQ InNO (INTERS pV3p pV4p   PLg1p PDirLG nil ))
					(SETQ InOE (INTERS pV4p pV1p   PLg1p PDirLG nil ))

					(SETQ LaES (EQUAL (DISTANCE pV2p pV3p ) (+ (DISTANCE pV2p InES ) (DISTANCE pV3p InES )) mUNI ))
					(SETQ LaNO (EQUAL (DISTANCE pV3p pV4p ) (+ (DISTANCE pV3p InNO ) (DISTANCE pV4p InNO )) mUNI ))
					(SETQ LaOE (EQUAL (DISTANCE pV4p pV1p ) (+ (DISTANCE pV4p InOE ) (DISTANCE pV1p InOE )) mUNI ))
					(COND
						((AND (/= InES nil) (= LaES T)) (SETQ PIn2 InES  N3dc2 N3dc-ES  AgG2 (CAL "ANG( InES , pV3p , PLg1p)"))) ; (ESTE) 
						((AND (/= InNO nil) (= LaNO T)) (SETQ PIn2 InNO  N3dc2 N3dc-NO  AgG2 (CAL "ANG( InNO , pV4p , PLg1p)"))) ; (NORTE)
						((AND (/= InOE nil) (= LaOE T)) (SETQ PIn2 InOE  N3dc2 N3dc-OE  AgG2 (CAL "ANG( InOE , pV1p , PLg1p)"))) ; (OESTE)
						( T   (PROMPT ">>>>>>>>>> NO INTER SUR  ??? ") (TERPRI))
					) ; con
				) ; CON-SUR 																										

				((EQUAL (DISTANCE pV2p pV3p ) (+ (DISTANCE pV2p PLg1p ) (DISTANCE pV3p PLg1p )) mUNI ) 	; CON-ESTE 

					;(SETQ LA-ENTRA 'ESTE)

					(SETQ PDirLG (CAL " ROT ( pV3p , PLg1p , AgG1 )"))												; PUNTO-DIR L-GEO ESTE 
					(SETQ InSU (INTERS pV1p pV2p   PLg1p PDirLG nil ))
					(SETQ InNO (INTERS pV3p pV4p   PLg1p PDirLG nil ))
					(SETQ InOE (INTERS pV4p pV1p   PLg1p PDirLG nil ))

					(SETQ LaSU (EQUAL (DISTANCE pV1p pV2p ) (+ (DISTANCE pV1p InSU ) (DISTANCE pV2p InSU )) mUNI ))
					(SETQ LaNO (EQUAL (DISTANCE pV3p pV4p ) (+ (DISTANCE pV3p InNO ) (DISTANCE pV4p InNO )) mUNI ))
					(SETQ LaOE (EQUAL (DISTANCE pV4p pV1p ) (+ (DISTANCE pV4p InOE ) (DISTANCE pV1p InOE )) mUNI ))
					(COND
						((AND (/= InSU nil) (= LaSU T)) (SETQ PIn2 InSU  N3dc2 N3dc-SU  AgG2 (CAL "ANG( InSU , pV2p , PLg1p)"))) ; (SUR)  
						((AND (/= InNO nil) (= LaNO T)) (SETQ PIn2 InNO  N3dc2 N3dc-NO  AgG2 (CAL "ANG( InNO , pV4p , PLg1p)"))) ; (NORTE)
						((AND (/= InOE nil) (= LaOE T)) (SETQ PIn2 InOE  N3dc2 N3dc-OE  AgG2 (CAL "ANG( InOE , pV1p , PLg1p)"))) ; (OESTE)
						( T   (PROMPT ">>>>>>>>>> NO INTER ESTE  ??? ") (TERPRI))
					) ; con
				) ; CON-ESTE 																										

				((EQUAL (DISTANCE pV3p pV4p ) (+ (DISTANCE pV3p PLg1p ) (DISTANCE pV4p PLg1p )) mUNI ) 	; CON-NORTE 

					;(SETQ LA-ENTRA 'NORTE)

					(SETQ PDirLG (CAL " ROT ( pV4p , PLg1p , AgG1 )"))												; PUNTO-DIR L-GEO NORTE 
					(SETQ InSU (INTERS pV1p pV2p   PLg1p PDirLG nil ))
					(SETQ InES (INTERS pV2p pV3p   PLg1p PDirLG nil ))
					(SETQ InOE (INTERS pV4p pV1p   PLg1p PDirLG nil ))

					(SETQ LaSU (EQUAL (DISTANCE pV1p pV2p ) (+ (DISTANCE pV1p InSU ) (DISTANCE pV2p InSU )) mUNI ))
					(SETQ LaES (EQUAL (DISTANCE pV2p pV3p ) (+ (DISTANCE pV2p InES ) (DISTANCE pV3p InES )) mUNI ))
					(SETQ LaOE (EQUAL (DISTANCE pV4p pV1p ) (+ (DISTANCE pV4p InOE ) (DISTANCE pV1p InOE )) mUNI ))
					(COND
						((AND (/= InSU nil) (= LaSU T)) (SETQ PIn2 InSU  N3dc2 N3dc-SU  AgG2 (CAL "ANG( InSU , pV2p , PLg1p)"))) ; (SUR)  
						((AND (/= InES nil) (= LaES T)) (SETQ PIn2 InES  N3dc2 N3dc-ES  AgG2 (CAL "ANG( InES , pV3p , PLg1p)"))) ; (ESTE) 
						((AND (/= InOE nil) (= LaOE T)) (SETQ PIn2 InOE  N3dc2 N3dc-OE  AgG2 (CAL "ANG( InOE , pV1p , PLg1p)"))) ; (OESTE)
						( T   (PROMPT ">>>>>>>>>> NO INTER NORTE  ??? ") (TERPRI))
					) ; con
				) ; CON-NORTE 																										

				((EQUAL (DISTANCE pV4p pV1p ) (+ (DISTANCE pV4p PLg1p ) (DISTANCE pV1p PLg1p )) mUNI ) 	; CON-OESTE 

					;(SETQ LA-ENTRA 'OESTE)

					(SETQ PDirLG (CAL " ROT ( pV1p , PLg1p , AgG1 )"))													; PUNTO-DIR L-GEO OESTE 
					(SETQ InSU (INTERS pV1p pV2p   PLg1p PDirLG nil ))
					(SETQ InES (INTERS pV2p pV3p   PLg1p PDirLG nil ))
					(SETQ InNO (INTERS pV3p pV4p   PLg1p PDirLG nil ))

					(SETQ LaSU (EQUAL (DISTANCE pV1p pV2p ) (+ (DISTANCE pV1p InSU ) (DISTANCE pV2p InSU )) mUNI ))
					(SETQ LaES (EQUAL (DISTANCE pV2p pV3p ) (+ (DISTANCE pV2p InES ) (DISTANCE pV3p InES )) mUNI ))
					(SETQ LaNO (EQUAL (DISTANCE pV3p pV4p ) (+ (DISTANCE pV3p InNO ) (DISTANCE pV4p InNO )) mUNI ))
					(COND
						((AND (/= InSU nil) (= LaSU T)) (SETQ PIn2 InSU  N3dc2 N3dc-SU  AgG2 (CAL "ANG( InSU , pV2p , PLg1p)"))) ; (SUR)  
						((AND (/= InES nil) (= LaES T)) (SETQ PIn2 InES  N3dc2 N3dc-ES  AgG2 (CAL "ANG( InES , pV3p , PLg1p)"))) ; (ESTE) 
						((AND (/= InNO nil) (= LaNO T)) (SETQ PIn2 InNO  N3dc2 N3dc-NO  AgG2 (CAL "ANG( InNO , pV4p , PLg1p)"))) ; (NORTE)
						( T   (PROMPT ">>>>>>>>>> NO INTER OESTE  ??? ") (TERPRI))
					) ; con
				) ; CON-OESTE 																										

				( T
					(SETQ WW1 nil )
					(PROMPT ">>>>>>>>>>> (SETQ WW1 nil ) TODO EQUAL = nil ??? ") (TERPRI)
				) ; CON-T																											
			) ; con

			(COMMAND "COLOR" 8  "3DCARA" pV1p  pV2p  pV3p  pV4p "")													; PINTA  3DCARA-p  3D 
			(COMMAND "COLOR" 7  "LINEA"  PLg1p  PIn2  "")																; 3D 

				(SETQ LA12 (CAL " PLT ( pV1p , pV2p , 0.5 )"))															; PUNTO MEDIO LADO-A 
				(SETQ LB12 (CAL " PLT ( pV4p , pV3p , 0.5 )"))															; PUNTO MEDIO LADO-B 
				(SETQ MeAB (CAL " PLT ( LA12 , LB12 , 0.5 )"))															; PUNTO MEDIO CENTROS LADOS
				(SETQ H-Tx (* (DISTANCE LA12 LB12 ) (/ 0.8 3.7)))														; ALTURA TXT Proporcional-DisB1A1
				(COMMAND "COLOR" 8  "TEXTO" "MC" MeAB  H-Tx  0 (ITOA N3dc1))										; TEXTO LINEA-REF  3D 

			(SETQ PLg2   (TRANS PIn2 1 0 ))
			(SETQ N3dc1  N3dc2 )
			(SETQ AgG1    AgG2 )

		(COMMAND "SCP" "U" )

	) ; ww1 

	(PROMPT ">>>>> FIN >>>>> ") (PRIN1 CONTA) (PROMPT " 3DC de SELECIONADAS de  ")
                               (PRIN1 (/ (LENGTH LIS-3DC-FIL/COL-3D/2D ) 3)) (PROMPT " TOTAL 3DC") (TERPRI)


	;	(09)																																											
	;======================================================================================================================================



  	;======================================================================================================================================
	;	(10) PARANDO																																								
	;......................................................................................................................................

	(SETVAR "blipmode" 1)  (SETVAR "cmdecho"  1)

	(TERPRI) (PROMPT " ============================================================================ ")
	(TERPRI) (PROMPT " >>>>>>>>>>>>>>>>>>>>>>> FINAL - CUERNO-CABRA-23 >>>>>>>>>>>>>>>>>>>>>>>>>>>> ")
	(TERPRI) (PROMPT " ============================================================================ ") (TERPRI)

  	;	(10)																																											
 	;======================================================================================================================================

) ;  CUERNO-CABRA-23 

;	(FIN)																																												
;=========================================================================================================================================





