
;-------------------------------------------------------------------------------------------------------------------------------------
;																																																																			
;	( ESCULTURA-NUDO-01 )                                                                 														05/06/2008				
;																																																																			
;=====================================================================================================================================
;																																																																			
; 		SECCION INICIO: POLIGUNO REGULAR  ( NLados )																																						        
;																																																																			
;			Genera 3DCARAS-PLANAS entre POLIGONOS de LADOS TANGENTES a CIRCULOS (RADIO) en PLANO NORMAL a (P2 P3) en PUNTO MEDIO (P23u)			
;																																																																			
;			SPLINE CAMINO: CURVA-3D  PUNTEADA con DIVIDE (NDiv) => P1 P2 P3 .........																										  
;																																																																			
;			SPLINE PERFIL: SPLINE CURVA-2D  DETERMINA PERFIL DEL CUERPO (PRINCIPIO y FIN en VERTICAL de SPLINE EJE)													
;			SPLINE EJE   : SPLINE RECTA HORIZONTAL (PRINCIPIO y FIN en VERTICAL de SPLINE PERFIL)																						
;																																																																			
;			CIRCULOS de RADIO VARIABLE (RADIO) Generados por DIFERENCIA = Y entre (Spline PERFIL) y (Spline EJE)														
;																																																																			
;			PINTA PATRONES																																																	                
;																																																																			
;-------------------------------------------------------------------------------------------------------------------------------------

	;================================================================================================================================
	;  CALCULA TODAS las SECCIONES																																																	 
	;================================================================================================================================
	;      P1 P2 P3 ... = Puntos Divide Spline             C123o = Centro Circulo Osculador P1 P2 P3                                 
	;      P12 = Punto Medio de P1 P2                      C123z = Punto Eje Circulo Osculador P1 P2 P3                              
	;      PLANO P12-123A = SCP 3P ( P12  C123o  C123z )   de 1Lista de ( LIS-DATOS-SECCIONES )                                     
	;--------------------------------------------------------------------------------------------------------------------------------
	;                                                                                                                                
	;                          C123oz                C234oz                C345oz                C456oz                              
	;                           (O)                   (O)                   (O)                   (O)                                
	;                   Inicio  / \    Coplanirios    / \    Coplanirios    / \    Coplanirios    / \  Final                         
	;                          / | \                 / | \                 / | \                 / | \                               
	;                         /     \               /     \               /     \               /     \                              
	;                        /   |   \             /   |   \             /   |   \             /   |   \                             
	;                       /         \           /         \           /         \           /         \                            
	;                      /     |     \         /     |     \         /     |     \         /     |     \                           
	;                     /             \       /             \       /             \       /             \                          
	;                    /       |       \     /       |       \     /       |       \     /       |       \                         
	;                   /                 \   /                 \   /                 \   /                 \                        
	;      P1          /P12      P2        \ /P23      P3        \ /P34      P4        \ /P45      P5        \ P56       P6          
	;      x----------O----------x----------O----------x----------O----------x----------O----------x----------O----------x           
	;      |          |          |          |          |          |          |          |          |          |          |           
	;      |                                                                 |                     |                     |           
	;      |---------------------LIS-DATOS-SECCIONES = A --------------------|          |          |          |          |           
	;                            |                                                                 |                     |           
	;                 |          |---------------------LIS-DATOS-SECCIONES = B --------------------|          |          |           
	;                                                  |          |                                                      |           
	;                 |          |          |          |---------------------LIS-DATOS-SECCIONES = C --------------------|           
	;                                                                                                                                
	; ----------------|----------|---------------------|---------------------|---------------------|----------|                      
	;                 | Inicio   |    Coplanirios      |    Coplanirios      |    Coplanirios      |  Final   |                      
	; ================|=======================================================================================|                      
	;  PLANOS REALES  | P12-C123 | P23-C123 | P23-C234 | P34-C234 | P34-C345 | P45-C345 | P45-C456 | P56-C456 |                      
	; ================|=======================================================================================|                      
	; ----------------|---------------------------------------------------------------------------------------|                      
	;  PLANOS List-A  | P12-123A | P23-123A | P23-234A | P34-234A |          |          |          |          |                      
	; ----------------|---------------------------------------------------------------------------------------|                      
	;  PLANOS List-B  |          |          | P12-123B | P23-123B | P23-234B | P34-234B |          |          |                      
	; ----------------|---------------------------------------------------------------------------------------|                      
	;  PLANOS List-C  |          |          |          |          | P12-123C | P23-123C | P23-234C | P34-234C |                      
	; ----------------|---------------------------------------------------------------------------------------|                      
	;                 |           Todos los PLANOS de cada Columna son IGUALES                                |                      
	; ----------------|---------------------------------------------------------------------------------------|                      
	; ===========================================================================================================================    
	;  R = Radio    VER = Vertice    TAG = Punto de Tangencia a Circulo    INT = Intersec. de Vertices con Intersec. de Planos       
	; ---------------------------------------------------------------------------------------------------------------------------    
	; ================|=======================================================================================|                      
	;  PLANOS List-1  | P12-123A | P23-123A | P23-234A | P34-234A |          |          |          |          |                      
	; ----------------|---------------------------------------------------------------------------------------|                      
	;                 |  R12     |  R23     .          |          .          |          .          |          |                      
	;                 |  VER-1   | T(INT-1) . T(VER-2) |          .          |          .          |          |                      
	;                 |  TAG-1   |  TAG-2   . INT-2 => |          .          |          .          |          |                      
	;                 |  INT-1   |  VER-2   . => INT-1 |          .          |          .          |          |                      
	; ================|=======================================================================================|                      
	;  PLANOS List-2  |    I     |          | P12-123B | P23-123B | P23-234B | P34-234B |          |          |                      
	; ----------------|--- N -------------------------------------------------------------------------- F ----|                      
	;  Siguiente      |    I     |          .          |  R23     .          |          .          |    I     |                      
	;                 |    C     |          .  INT-1   | T(INT-1) . T(VER-2) |          .          |    N     |                      
	;                 |    I     |          .          |  TAG-2   . INT-2 => |          .          |    A     |                      
	;                 |    O     |          .          |  VER-2   . => INT-1 |          .          |    L     |                      
	; ================|=======================================================================================|                      
	;  PLANOS List-3  |          |          |          |          | P12-123C | P23-123C | P23-234C | P34-234C |                      
	; ----------------|---------------------------------------------------------------------------------------|                      
	;  Siguiente      |          |          .          |          .          |  R23     .          |  R34     |                      
	;                 |          |          .          |          .  INT-1   | T(INT-1) . T(VER-2) | T(INT-2) |                      
	;                 |          |          .          |          .          |  TAG-2   .  INT-2   |  TAG-3   |                      
	;                 |          |          .          |          .          |  VER-2   .          |  VER-3   |                      
	; ----------------|---------------------------------------------------------------------------------------|                      
	;    |===============================================================================================================|					 
	;    |      TODOS los PLANOS de las LISTAS que contiene la Lista ( LIS-DATOS-SECCIONES )                             |					 
	;    |===============================================================================================================|					 
	;    |                        |     |                C O P L N A R I O S              |     |                        |					 
	;    | (1) PLANO-INICIO       |  e  | (2a)PLANO-INTERMEDIO   | (2b)PLANO-INTERMEDIO   |  e  | (3) PLANO-FINAL        |					 
	;    |     P12-C123oz         |  j  |     P23-C123oz         |     P23-C234oz         |  j  |     P34-C234oz         |					 
	;    |     ROJO               |  e  |     AMARILLO           |     VERDE no uso       |  e  |     CIAN               |					 
	;    |========================|     |=================================================|     |========================|					 
	;    |     R12                |  1  |     R23                |                        |  2  |   R34                  |					 
	;    |                        |  2  |     TRAN/INT1(2a)      |                        |  3  |   TRAN/INT2(3)         |					 
	;    |     TAG1               |  3  |     TAG2               |                        |  4  |   TAG3                 |					 
	;    |     VER1               |     |     VER2               | INT1(1) Siguiente Lista|     |   VER3                 |					 
	;    |     INT1(1)            |     |     INT2(2ab)=>INT1(1) | INT2(2ab) con C234oz   |     |                        |					 
	;    |===============================================================================================================|					 

	;--------------------------------------------------------------------------------------------------------------------------------
	;  (1) PLANO-INICIO      P12-C123oz    R12                              TAG1   VER1   INT1(1)                                    
	;--------------------------------------------------------------------------------------------------------------------------------
	;--------------------------------------------------------------------------------------------------------------------------------
	;  (2) PLANO-INTERMEDIO  P23-C123oz    R23   TRAN/INT1(1) => INT1(2a)   TAG2   VER2   INT2(2ab)=>INT1(1)  Siguiente Lista        
	;--------------------------------------------------------------------------------------------------------------------------------
	;--------------------------------------------------------------------------------------------------------------------------------
	;  (3) PLANO-FINAL       P34-C234oz    R34   TRAN/INT2(2ab)=>INT2(3)    TAG3   VER3                                              
	;--------------------------------------------------------------------------------------------------------------------------------

	;================================================================================================================================
	;================================================================================================================================

	;**************|======================================================================================|
	;  CORREJIDO   |      TODOS los PLANOS de las LISTAS que contiene la Lista ( LIS-DATOS-SECCIONES )    |
	;**************|======================================================================================|
	;  					   |                        |     |   C O P L N A R I O S  |     |                        |
	;  PLANOS      | (1) PLANO-INICIO       |     |  (2)PLANO-INTERMEDIO   |     | (3) PLANO-FINAL        |
	;  					   |                        |     |                        |     |                        |
	;   					 |     P12-C123oz         |     |  P23-C123oz   C234oz   |     |   P34-C234oz           |
	;==============|========================|     |========================|     |========================|
	;  ENTRADAS    |     R12  CIRCU-12      |     |     R23                |     |   R34                  |
	;   					 |     T12                |  e  |     INT_u              |  e  |   INT_u                |
	;   					 |     V12                |  j  |                        |  j  |                        |
	;--------------|------------------------|  e  |------------------------|  e  |------------------------|
	;  SALIDAS     |                        |     |     CIRCU-23           |     |   CIRCU-34             |
	;  					   |     IN12_123p          |     |     IN23_123p          |     |   IN34/234             |
	;  					   |                        |  1  |     T23                |  2  |   T34                  |
	;  					   |                        |  2  |     V23                |  3  |   V34                  |
	;  					   |                        |  3  |     IN23_234           |  4  |                        |
	;  					   |     INT_u              |     |     INT_u              |     |                        |
	;  					   |                        |     |                        |     |                        |
	;==============|======================================================================================|

	;--------------------------------------------------------------------------------------------------------------------------------
	; (PL-12) PLANO-INICIO  P12-C123oz   ENTRA( R12  CIR-12  T12  V12 )   SALIR( IN12_123p                     INT_u  T12_u  V12_u ) 
	;--------------------------------------------------------------------------------------------------------------------------------
	;--------------------------------------------------------------------------------------------------------------------------------
	; (PL-23) PLANO-INTERM  P23-C123oz   ENTRA( R23  INT_u )      SALIR( CIR-23  IN23_123p  T23  V23  IN23_234 INT_u  T23_u  V23_u ) 
	;--------------------------------------------------------------------------------------------------------------------------------
	;--------------------------------------------------------------------------------------------------------------------------------
	; (PL-34) PLANO-FINAL   P34-C234oz   ENTRA( R34  INT_u )      SALIR( CIR-34  IN34/234  T34  V34                                ) 
	;--------------------------------------------------------------------------------------------------------------------------------


;-------------------------------------------------------------------------------------------------------------------------------------
;	(01)	(PUNTOS-DIVIDE) = PUNTEA SPLINE a NDIVISIONES ( N-ELE ) + ( NDIDI ) => ( LIS-PUNTOS )																				
;-------------------------------------------------------------------------------------------------------------------------------------

(DEFUN PUNTOS-DIVIDE (/  )

	(SETQ LIS-PUNTOS  nil)

	(SETQ   Elen (MEMBER (ASSOC 10 (ENTGET N-ELE)) (ENTGET N-ELE))									; lista a partir del elemento (incluido)
		    P-1    (CDR (NTH      0              Elen))												      ; primer elemento
		    P-Uo    (CDR (NTH (- (LENGTH Elen) 1) Elen)) )												    ; ultimo elemento

	(COMMAND  "COLOR" 1 "PUNTO"  P-1)																		          ; PINTA Primer Punto (en Base de Datos)
 	(SETQ  N-1P (ENTLAST))																						              ; Nombre ultima entidad principal = 1 punto
	(COMMAND	 "COLOR" 7 "DIVIDE" N-ELE NDIDI																      ; PINTA Punto Divide (en Base de Datos)
			     "COLOR" 5 "PUNTO"  P-Uo       )															          ; PINTA Ultimo Punto (en Base de Datos)

	;	PUNTOS SECCION X (PX1-PXn) =>  LIS-PUNTOS																																													

	(SETQ  N-P1         nil
		   N-P2         nil
		   N-P2         N-1P
		   LIS-PUNTOS   nil
		   LIS-PUNTOS  (LIST (CDR (ASSOC 10 (ENTGET N-1P))))											   ; LIS-PUNTOS => 1 punto
		   WW           T )

	(WHILE WW
	  	(SETQ N-P1 (ENTNEXT N-1P))																			           ; nombre entidad siguiente
				
		(IF (= N-P1 nil)	(SETQ WW nil)
			(PROGN
				(SETQ LIS-PUNTOS (CONS (CDR (ASSOC 10 (ENTGET N-P1))) LIS-PUNTOS))			; LIS-PUNTOS => Resto PUNTOS con ULTIMO
				(SETQ  N-1P N-P1 )
				;(ENTDEL N-P1)																		; BORRA PUNTO
			) ; pro
		) ; if 
	) ; whi
	(SETQ LIS-PUNTOS (REVERSE LIS-PUNTOS))
	;(ENTDEL N-P2)																					; BORRA PUNTO

) ;	(01)  DEFUN   PUNTOS-DIVIDE 

;-------------------------------------------------------------------------------------------------------------------------------------

;-------------------------------------------------------------------------------------------------------------------------------------
;	(02) CALCULOS  PERFIL RADIOS ( RADIO ) CIRCULOS a TANGENTES por SPLINE	SPLINE-REF ----- DIVIDIR NDiv*3 => LIS-Pun-REF => PP1 PP2	
;																		                                      SPLINE-EJE ----- DIVIDIR NDiv   => LIS-Pun-EJE => PPb	    
;-------------------------------------------------------------------------------------------------------------------------------------

(DEFUN LISTA-RADIOS-PERFIL (/  )

  (SETQ LIS-RADI nil)
	(SETQ NEje -1)
	(SETQ NRef -1)

	(REPEAT (LENGTH LIS-Pun-EJE)
		(SETQ NEje (+ NEje 1))

		(IF (NOT (= (REM NEje 2) 0))
			(PROGN
				(SETQ PPb (NTH NEje LIS-Pun-EJE))  (SETQ XXb (CAR PPb) YYb (CADR PPb))
				(SETQ WW T)
				(WHILE WW
					(SETQ NRef (+ NRef 1))
					(SETQ PP1 (NTH (+ NRef 0) LIS-Pun-REF))  (SETQ XX1 (CAR PP1) YY1 (CADR PP1))
					(SETQ PP2 (NTH (+ NRef 1) LIS-Pun-REF))  (SETQ XX2 (CAR PP2) YY2 (CADR PP2))

					(IF (AND (<= XX1 XXb) (< XXb XX2))
						(PROGN																																							
							(SETQ R-REF (/ (+ (* (- YY1 YYb) (- XX2 XXb)) (* (- YY2 YYb) (- XXb XX1))) (- XX2 XX1)))
							(SETQ LIS-RADI (CONS R-REF LIS-RADI))											; (LENGTH LIS-RADI)
							(SETQ WW nil)
							(COMMAND "COLOR" 1 "LINEA" PPb (LIST XXb (+ YYb R-REF)) "")
						) ;pro
					) ;if
					(IF (>= NRef (- (LENGTH LIS-Pun-REF) 2)) (SETQ WW nil))
				) ; Whi NRef
			) ;pro
		) ; if
	) ; repe NEje
	(SETQ LIS-RADI (REVERSE LIS-RADI))																		; (NTH 0 LIS-RADI)  (LENGTH LIS-RADI)

) ;	(02)  DEFUN   LISTA-RADIOS-PERFIL 

;-------------------------------------------------------------------------------------------------------------------------------------


;-------------------------------------------------------------------------------------------------------------------------------------
;	(03)	CALCULO de  LIS-DATOS-SECCIONES ( P12u R12  C123ou C123zu  P23u R23  C234ou C234zu  P34u R34 ) 																
;-------------------------------------------------------------------------------------------------------------------------------------

(DEFUN CALCULO-LIS-DATOS-SECC (/  )


	(SETQ LIS-DATOS-SECCIONES nil)

	(SETQ NSCP -1 )
	(REPEAT  (- (LENGTH LIS-Pun-CAMI) 3)
		(SETQ NSCP (+ NSCP 1))

		(SETQ P1 (NTH (+ NSCP 0) LIS-Pun-CAMI))   (SETQ X1 (CAR P1) Y1 (CADR P1) Z1 (CADDR P1))
		(SETQ P2 (NTH (+ NSCP 1) LIS-Pun-CAMI))   (SETQ X2 (CAR P2) Y2 (CADR P2) Z2 (CADDR P2))
		(SETQ P3 (NTH (+ NSCP 2) LIS-Pun-CAMI))   (SETQ X3 (CAR P3) Y3 (CADR P3) Z3 (CADDR P3))
		(SETQ P4 (NTH (+ NSCP 3) LIS-Pun-CAMI))   (SETQ X4 (CAR P4) Y4 (CADR P4) Z4 (CADDR P4))

		(IF (OR (AND (EQUAL (/ (- Y2 Y1) (- X2 X1)) (/ (- Y3 Y2) (- X3 X2)) mUNI )
					       (EQUAL (/ (- Z2 Z1) (- X2 X1)) (/ (- Z3 Z2) (- X3 X2)) mUNI ))  ; P1 P2 P3 en LINEA 

			      (AND (EQUAL (/ (- Y3 Y2) (- X3 X2)) (/ (- Y4 Y3) (- X4 X3)) mUNI )
					       (EQUAL (/ (- Z3 Z2) (- X3 X2)) (/ (- Z4 Z3) (- X4 X3)) mUNI ))) ; P2 P3 P4 en LINEA 

			(PROGN 	; (P1 P2 P3) y (P2 P3 P4) NO DEFINEN CIRCULOS 	

				(IF (AND (EQUAL (/ (- Y2 Y1) (- X2 X1)) (/ (- Y3 Y2) (- X3 X2)) mUNI )
					       (EQUAL (/ (- Z2 Z1) (- X2 X1)) (/ (- Z3 Z2) (- X3 X2)) mUNI ))  ; P1 P2 P3 en LINEA 
					(PROGN
						(PROMPT " >>>>>>>>>  NO DEFINEN CIRCULO en LINEA (P1 P2 P3)  NSCP = ( ")
						(PRIN1 (+ NSCP 0)) (PROMPT " ") (PRIN1 (+ NSCP 1)) (PROMPT " ")  (PRIN1 (+ NSCP 2)) (PROMPT " )")  (TERPRI)
					) ; pro 
				) ; if

				(IF (AND (EQUAL (/ (- Y3 Y2) (- X3 X2)) (/ (- Y4 Y3) (- X4 X3)) mUNI )
					       (EQUAL (/ (- Z3 Z2) (- X3 X2)) (/ (- Z4 Z3) (- X4 X3)) mUNI ))  ; P2 P3 P4 en LINEA 
					(PROGN
						(PROMPT " >>>>>>>>>  NO DEFINEN CIRCULO en LINEA (P2 P3 P4)  NSCP = ( ")
						(PRIN1 (+ NSCP 1)) (PROMPT " ") (PRIN1 (+ NSCP 2)) (PROMPT " ")  (PRIN1 (+ NSCP 3)) (PROMPT " )")  (TERPRI)
					) ; pro 
				) ; if
			) ; pro 


			(PROGN 	; (P1 P2 P3) y (P2 P3 P4) SI DEFINEN CIRCULOS 	

				; PUNTOS MEDIOS de (P1 P2) (P2 P3) (P3 P4) 																																										

				(SETQ P12u (CAL " PLT( P1 , P2 , 0.5 )"))
				(SETQ P23u (CAL " PLT( P2 , P3 , 0.5 )"))
				(SETQ P34u (CAL " PLT( P3 , P4 , 0.5 )"))

				; CENTRO del CIRCULO-OSCULADOR-AB   P1 P2 P3																																									
 				(COMMAND "SCP" "3P" P1 P2 P3 )																											; PLANO PUNTOS => C123ou   para P12u P23u
					(COMMAND "COLOR" 1  "CIRCULO" "3P" (TRANS P1 0 1) (TRANS P2 0 1) (TRANS P3 0 1))	; CIRCULO-OSCULADOR AB    
					(SETQ   NCi-AB  (ENTLAST))																												; "NCi-AB" NOMBRE CIRCULO-OSCULADOR
					(SETQ    C123ou (TRANS (CDR (ASSOC 10 (ENTGET NCi-AB)))  NCi-AB 0 ))							; CENTRO CIRCULO-OSCULADOR SCU  CHARNELA-0
					(SETQ    CenABp (TRANS (CDR (ASSOC 10 (ENTGET NCi-AB)))  NCi-AB 1 ))							; CENTRO CIRCULO-OSCULADOR SCP-AC
					(SETQ    C123zu (TRANS (LIST (CAR CenABp) (CADR CenABp) 40.0 ) 1   0 ))						; PERPENDICULAR CENTRO CIRCULO-OSCULADOR SCU
					(ENTDEL NCi-AB)																																		; "NCi-AB" BORRA 
				(COMMAND "SCP" "U") 

				; CENTRO del CIRCULO-OSCULADOR-BC   P2 P3 P4																																									
 				(COMMAND "SCP" "3P" P2 P3 P4 )																											; PLANO PUNTOS => C234ou   para P23u P34u
					(COMMAND "COLOR" 2  "CIRCULO" "3P" (TRANS P2 0 1) (TRANS P3 0 1) (TRANS P4 0 1))	; CIRCULO-OSCULADOR AB    
					(SETQ   NCi-BC  (ENTLAST))																												; "NCi-BC" NOMBRE CIRCULO-OSCULADOR
					(SETQ    C234ou (TRANS (CDR (ASSOC 10 (ENTGET NCi-BC)))  NCi-BC 0 ))							; CENTRO CIRCULO-OSCULADOR SCU  CHARNELA-0
					(SETQ    CenBCp (TRANS (CDR (ASSOC 10 (ENTGET NCi-BC)))  NCi-BC 1 ))							; CENTRO CIRCULO-OSCULADOR SCP-AC
					(SETQ    C234zu (TRANS (LIST (CAR CenBCp) (CADR CenBCp) 40.0 ) 1   0 ))						; PERPENDICULAR CENTRO CIRCULO-OSCULADOR SCU
					(ENTDEL NCi-BC)																																		; "NCi-BC" BORRA 
				(COMMAND "SCP" "U") 

				; RADIOS 																																																											

				(SETQ R12 (NTH (+ NSCP 0) LIS-RADI ))
				(SETQ R23 (NTH (+ NSCP 1) LIS-RADI ))
				(SETQ R34 (NTH (+ NSCP 2) LIS-RADI ))

				; LISTA SCP de SECCIONES																																																			
				(SETQ LIS-DATOS-SECCIONES  (CONS  (LIST P12u R12  C123ou C123zu  P23u R23  C234ou C234zu  P34u R34 )  LIS-DATOS-SECCIONES ))

			) ; pro
		) ; if  TRES PUNTOS en LINEA
	) ; repe  LIS-Pun-CAMI 

	(SETQ LIS-DATOS-SECCIONES (REVERSE LIS-DATOS-SECCIONES))   ; (LENGTH LIS-DATOS-SECCIONES ) 

) ;	(03)  DEFUN   CALCULO-LIS-DATOS-SECC 

;-------------------------------------------------------------------------------------------------------------------------------------





"####################################################################################################################################"
;-------------------------------------------------------------------------------------------------------------------------------------
; *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA 	
;-------------------------------------------------------------------------------------------------------------------------------------
"####################################################################################################################################"

(DEFUN C:ESCULTURA-NUDO-01 ( / )

	;===================================================================================================================================
	;  (00) ARRANCANDO																																																									

 	(SETVAR "blipmode" 0) (SETVAR "cmdecho" 0)  (GRAPHSCR)  (COMMAND "-REFENT" "DES")  (COMMAND "SCP" "U")  (COMMAND "ORTO" "DES")

	(PROMPT " ============================================================================")  (TERPRI)
	(PROMPT " >>>> INICIO >>>>>>>>>>>>>>>>>> ESCULTURA-NUDO-01 >>>>>>>>>>>>>>>>>>>>>>>>>>>")  (TERPRI)
	(PROMPT " ============================================================================")  (TERPRI) (TERPRI)

	(IF (= CAL nil)(COMMAND "ARX" "L" "GEOMCAL.ARX"))		; CARGA CALCULADORA 


	;===================================================================================================================================
	;	(01) FIJAR VARIABLES EN EL PROGRAMA																																																

	      (SETQ NDiv   50 )											; N(DIVIDE)  SPLINE ( AJUSTAS a DISTANCIA SECCIONES a 1 Ud ? )
				(SETQ NLados  3 )											; N de LADOS POLIGONO REGULAR en INICIO 

				(SETQ DesviAg  (* (/ PI 180.0) 58 ))			; DESVIACION ANGULO SECCION INICIO 

	      (SETQ mUNI 1.0e-006 )										; MARGEN EQUAL VEC-UNITARIOS (1.01e-008)LIMITE-MAR-INTER-RECT-01.lsp 

	;===================================================================================================================================
	;	(02) TOMA de DATOS en PANTALLA            																																												

 	(SETQ N-CAMI (CAR (ENTSEL "------------------------ MARCA >>>>>>>>>>>>>>>>>  SPLINE - CAMINO ? <<<<<<<<<" ))) (TERPRI)
 	(SETQ N-PERF (CAR (ENTSEL "------------------------ MARCA >>>>>>>>>>>>>>>>>  SPLINE - PERFIL ? <<<<<<<<<" ))) (TERPRI)
 	(SETQ N-BASE (CAR (ENTSEL "------------------------ MARCA >>>>>>>>>>>>>>>>>  SPLINE - EJE    ? <<<<<<<<<" ))) (TERPRI) (TERPRI)

	(PROMPT                   " ****************************************************************************")    (TERPRI)
	(PROMPT                   " ************************** COMENTARIOS y ERRORES ***************************")    (TERPRI) (TERPRI)


	;===================================================================================================================================
	;	(03)	LISTAS PUNTOS ( SPLI-CAMINO   SPLI-PERFIL   SPLI-BASE ) 																																		

	(SETQ  N-ELE N-CAMI   NDIDI    NDiv   )  (PUNTOS-DIVIDE)  (SETQ LIS-Pun-CAMI LIS-PUNTOS   P-Ulti  P-Uo)		; (LENGTH LIS-Pun-CAMI) 
	(SETQ  N-ELE N-PERF   NDIDI (* NDiv 6))  (PUNTOS-DIVIDE)  (SETQ LIS-Pun-REF  LIS-PUNTOS)							  	; (LENGTH LIS-Pun-REF)  
	(SETQ  N-ELE N-BASE   NDIDI (* NDiv 2))  (PUNTOS-DIVIDE)  (SETQ LIS-Pun-EJE  LIS-PUNTOS)									; (LENGTH LIS-Pun-EJE)  

	;===================================================================================================================================
	(LISTA-RADIOS-PERFIL)		  ;	(02) RADIOS CIRCULOS para TANGENTES en SECCCIONES (PERFIL SPLINE)  ( LIS-RADI )  												

	;===================================================================================================================================
	(CALCULO-LIS-DATOS-SECC)	;	(03) CALCULO de LIS-DATOS-SECCIONES ( P12u R12  C123ou C123zu  P23u R23  C234ou C234zu  P34u R34 )			


	"##################################################################################################################################"
	;===================================================================================================================================
	;  CALCULA TODAS las SECCIONES																																																			
	;===================================================================================================================================

	(SETQ LisVerTODOu nil )
	(SETQ LisTagTODOu nil )

	(SETQ NSEC  -1 )
	(REPEAT  (LENGTH LIS-DATOS-SECCIONES )					 						; POR PLANOS  
		(SETQ NSEC  (+ NSEC 1))

		(SETQ LIS-DATOS (NTH  NSEC  LIS-DATOS-SECCIONES))				; ( P12u R12  C123ou C123zu  P23u R23  C234ou C234zu  P34u R34 ) 

		(SETQ P12u      (NTH 0 LIS-DATOS))
		(SETQ R12       (NTH 1 LIS-DATOS))
		(SETQ C123ou    (NTH 2 LIS-DATOS))
		(SETQ C123zu    (NTH 3 LIS-DATOS))
		(SETQ P23u      (NTH 4 LIS-DATOS))
		(SETQ R23       (NTH 5 LIS-DATOS))
		(SETQ C234ou    (NTH 6 LIS-DATOS))
		(SETQ C234zu    (NTH 7 LIS-DATOS))
		(SETQ P34u      (NTH 8 LIS-DATOS))
		(SETQ R34       (NTH 9 LIS-DATOS))

		"################################################################################################################################"
		;---------------------------------------------------------------------------------------------------------------------------------
		; (1) PLANO-INICIO  P12-C123oz   ENTRA( R12    T12  V12 )   SALIR( CIR-12  IN12_123p  INT_u  T12_u  V12_u )                   		
		;---------------------------------------------------------------------------------------------------------------------------------
				;																																																															
				;  LisV12_p  LisT12_p  
				;																																																														
				; LisIN12_u    LisV12_u      V12a_p   T12_p   IN12_123p   IN12u       V12u           T12u                                   
				; Lis-Antes_IN_u             V12b_p                     LisIN12_u  LisV12_u        LisT12_u                                 
				;                                                                  Lis-Antes_IN_u  Lis-Antes_T_u                            

		(IF (= NSEC 0 )
			(PROGN

				; (1) SECCION de REF-INICIO: POLIGONO REGULAR  ( NLados )	(1VERTICE en EJE-X + DesviAg )    LisV12_p   LisT12_p						

  			(SETQ LisV12_p nil)
  			(SETQ LisT12_p nil)

				(SETQ RaInc (NTH 0 LIS-RADI ))        (SETQ AgInc (/      PI  NLados ))						; 1RADIO y ANGULO CIRCULO INCRITO     
				(SETQ RaCir (/ RaInc (COS AgInc )))	  (SETQ AgCir (/ (* 2 PI) NLados ))						; 1RADIO y ANGULO CIRCULO CIRCUNCRITO 

				(SETQ Ag-CC (+ (- AgCir       ) DesviAg ))
				(SETQ Ag-II (+ (- AgInc AgCir ) DesviAg ))

				(REPEAT  NLados
					(SETQ Ag-CC  (+ Ag-CC  AgCir ))
					(SETQ Ag-II  (+ Ag-II  AgCir ))

					(SETQ V12o_p (LIST (* RaCir (COS Ag-CC))  (* RaCir (SIN Ag-CC))  0.0 ))						; PUNTO VERTICE      
					(SETQ T12o_p (LIST (* RaInc (COS Ag-II))  (* RaInc (SIN Ag-II))  0.0 ))						; PUNTO de TANGENCIA 

					(SETQ LisV12_p (CONS  V12o_p  LisV12_p ))
					(SETQ LisT12_p (CONS  T12o_p  LisT12_p ))
				) ; repe

				(SETQ LisV12_p (REVERSE LisV12_p ))  ; (LENGTH LisV12_p)
				(SETQ LisT12_p (REVERSE LisT12_p ))  ; (LENGTH LisT12_p)


				; (1) PINTA SECCION REF-INICIO  (COMPROBACION)																																								

				(SETQ  PINTA-SEC-REF-INICIO 'NO )								; PINTA SECC REF SCU 
				(IF (= PINTA-SEC-REF-INICIO 'SI ) (PROGN
					(SETQ Na -1 )
					(REPEAT  (LENGTH LisV12_p)
						(SETQ Na (+ Na 1 ))
						(SETQ Nb (+ Na 1 ))   (IF (= Nb (LENGTH LisV12_p)) (SETQ Nb 0 ))

						(SETQ PV1 (NTH Na  LisV12_p))
						(SETQ PV2 (NTH Nb  LisV12_p))

						(SETQ PT1 (NTH Na  LisT12_p))
						(SETQ PT2 (NTH Nb  LisT12_p))

						(COMMAND "COLOR" (+ Na 1 )  "LINEA" PV1 PV2 "")
						(COMMAND "COLOR" (+ Na 1 )  "LINEA" PT1 PT2 "")
					) ; repe 
				)) ; if pro  PINTA-SEC-REF-INICIO 


				; (1) PINTA CIRCULO y LADOS en PLANO-INICIO (P12-C123oz) R12 VER1 TAG1 INT1 ( Lis-Antes_IN_u ) ( LisV12_u ) ( LisVerTODOu ) 	

				(SETQ LisIN12_u       nil )
				(SETQ Lis-Antes_IN_u  nil )
				(SETQ LisV12_u        nil )
				(SETQ LisT12_u        nil )
				(SETQ Lis-Antes_T_u   nil )

 				(COMMAND "SCP" "3P" P12u  C123ou  C123zu )																						; (1) PLANO-INICIO 

					(COMMAND "COLOR" 7  "CIRCULO" '(0 0 0)  R12 )

					(SETQ N1 -1)
					(REPEAT NLados
						(SETQ N1 (+ N1 1))   (SETQ N2 (+ N1 1))   (IF (= N2  NLados ) (SETQ N2 0 ))

						(SETQ V12a_p (NTH N1  LisV12_p )) (SETQ V12u (TRANS V12a_p 1 0 ))  (SETQ LisV12_u (CONS V12u  LisV12_u ))
						(SETQ V12b_p (NTH N2  LisV12_p ))                ;  V12a_p  V12b_p ???

						(SETQ T12_p  (NTH N1  LisT12_p )) (SETQ T12u (TRANS T12_p  1 0 ))  (SETQ LisT12_u  (CONS T12u  LisT12_u )) 

						;(COMMAND  "COLOR" (+ N1 1)  "PUNTO"  T12_p  )

						; (1) PUNTO INTERSECCION de LADO (V12a_p V12b_p) con CHARNELA (C123op C123zp)  =>  IN12_123p															

						(SETQ C123op (TRANS C123ou 0 1 ))		(SETQ C123op (CAL " XYof( C123op )"))
						(SETQ C123zp (TRANS C123zu 0 1 ))		(SETQ C123zp (CAL " XYof( C123zp )"))

						(IF (= (CAL " ILL( V12a_p , V12b_p , C123op , C123zp)") nil )
							(PROGN
								(PROMPT " >>>>>>>>> LINEAS PARALELAS    N1  = ") (PRIN1 N1) (TERPRI)
							) ; pro 

							(PROGN
								(SETQ IN12_123p (CAL " ILL( V12a_p , V12b_p , C123op , C123zp)"))
						    (SETQ IN12u (TRANS IN12_123p 1 0 ))   (SETQ LisIN12_u (CONS IN12u LisIN12_u ))

								;(COMMAND "COLOR" (+ N1 1)  "PUNTO" IN12_123p )
							) ; pro 
						) ; if 
					) ; repe

					(SETQ LisIN12_u (REVERSE LisIN12_u ))

					(SETQ LisT12_u  (REVERSE LisT12_u  ))   (SETQ LisTagTODOu (CONS LisT12_u  LisTagTODOu ))

					(SETQ LisV12_u  (REVERSE LisV12_u  ))   (SETQ LisVerTODOu (CONS LisV12_u  LisVerTODOu ))

					(SETQ Lis-Antes_IN_u  LisIN12_u )   						; Siguiente Lista Datos   
					(SETQ Lis-Antes_T_u   LisT12_u  )   						; Siguiente Lista Compara 

				(COMMAND "SCP" "U")
			) ; pro
		) ;if (= NSEC 0 ) 


		"################################################################################################################################"
		;---------------------------------------------------------------------------------------------------------------------------------
		; (2) PLANO-INTERMEDIO  P23-C123oz   ENTRA( R23  INT_u )  SALIR( CIR-23  IN23_123p  T23  V23  IN23_234  INT_u  T23_u  V23_u ) 		
		;---------------------------------------------------------------------------------------------------------------------------------
				;																																																															
				;  IN23_123p   T23a_p      T23_p   LisT23_p   
				;              T23b_p      T23_u   LisT23_u   
				;                                   Lis-Antes_T_u  
				;																																																															
				;  T23a_p   V23p   LisV23_p   
				;  T23b_p   V23u   LisV23_u   
				;																																																															
				;  V23a_p   IN23_234p   LisIN23_234u   LisVerTODOu   
				;  V23b_p   IN23_234u   Lis-Antes_IN_u     

 		(COMMAND "SCP" "3P" P23u  C123ou  C123zu ) 								; (2a) PLANO-INTERMEDIO 

			(COMMAND "COLOR" 7  "CIRCULO" '(0 0 0)  R23 )

			; (2) P-TANGENTES de IN23_123p a CIRCULO P23 R23    en TRIANGULO RECTANGULO   DATOS: ( IN23_123p  C123op  R23 )									

			(SETQ LisT23_p  nil )
			(SETQ LisT23_u  nil )

			(SETQ N3 -1)
			(REPEAT NLados
				(SETQ N3 (+ N3 1))

				(SETQ IN23_123p (TRANS (NTH N3 Lis-Antes_IN_u ) 0 1 ))	  (SETQ IN23_123p (CAL " XYof( IN23_123p )"))

				(SETQ SENOa (/ R23 (DISTANCE '(0.0 0.0 0.0) IN23_123p )))
				(SETQ COSEa (+ (SQRT (- 1 (* SENOa SENOa )))))

				(SETQ PTgA (LIST (* R23 SENOa )  (+ (* R23 COSEa ))  0.0 ))
				(SETQ PTgB (LIST (* R23 SENOa )  (- (* R23 COSEa ))  0.0 ))

				; (2) ROTACION DE EJES  TRANSFORMACION de (O) a (O)         AgB = O-X con O-X                   												

				(SETQ C123op (TRANS C123ou 0 1))   (SETQ C123op (CAL " XYof( C123op )"))			; corregido ???

				(SETQ AgB     (CAL " ANG( [0,0,0] ,  C123op , IN23_123p )"))									; ang(P0,P1,P2) ?? 
				(SETQ T23a_p (CAL " ROT(  PTgA  , [0,0,0] , AgB    )"))
				(SETQ T23b_p (CAL " ROT(  PTgB  , [0,0,0] , AgB    )"))											; rot(P1,P0,Ang)

				(SETQ T1u (NTH N3 Lis-Antes_T_u ))																					; PUN TAG ANTERIOR 

				(SETQ T23a_u (TRANS T23a_p 1 0 ))
				(SETQ T23b_u (TRANS T23b_p 1 0 ))

				; (2) ELIGE PUN-TAG  => SIGNO-Z en PLANO  IN12u  P12u  P23u																																		


				(SETQ IN1u (NTH N3 Lis-Antes_IN_u ))

   			(COMMAND "SCP" "U")

				(COMMAND "SCP" "3P" IN1u  P12u  P23u )
					(SETQ T1k    (TRANS T1u    0 1 ))
					(SETQ T23a_k (TRANS T23a_u 0 1 ))
					(SETQ T23b_k (TRANS T23b_u 0 1 ))

					(COND
						((AND (> (CADDR T1k) 0) (> (CADDR T23a_k) 0))  (SETQ T23_p T23a_p) (SETQ LisT23_p (CONS T23_p  LisT23_p)))
						((AND (< (CADDR T1k) 0) (< (CADDR T23a_k) 0))  (SETQ T23_p T23a_p) (SETQ LisT23_p (CONS T23_p  LisT23_p)))
						((AND (> (CADDR T1k) 0) (> (CADDR T23b_k) 0))  (SETQ T23_p T23b_p) (SETQ LisT23_p (CONS T23_p  LisT23_p)))
						((AND (< (CADDR T1k) 0) (< (CADDR T23b_k) 0))  (SETQ T23_p T23b_p) (SETQ LisT23_p (CONS T23_p  LisT23_p)))
					) ; con 
   			(COMMAND "SCP" "U")


				;(SETQ DisA (DISTANCE T1u (TRANS T23a_p 1 0 ) ))
				;(SETQ DisB (DISTANCE T1u (TRANS T23b_p 1 0 ) ))
				;(IF (< DisA DisB ) (SETQ T23_p T23a_p ) (SETQ T23_p T23b_p ))   (SETQ LisT23_p (CONS T23_p  LisT23_p ))  ; ????
				;(IF (> DisA DisB ) (SETQ T23_p T23a_p ) (SETQ T23_p T23b_p ))   (SETQ LisT23_p (CONS T23_p  LisT23_p ))   ; ????


				(COMMAND "SCP" "3P" P23u  C123ou  C123zu )

				;(COMMAND  "COLOR" (+ N3 1)  "PUNTO"  IN23_123p )
				;(COMMAND  "COLOR" (+ N3 1)  "PUNTO"  T23_p  )

				(SETQ T23_u (TRANS T23_p 1 0 ))   (SETQ LisT23_u (CONS T23_u  LisT23_u ))

			) ; repe  NLados TAG2 

			(SETQ LisT23_p (REVERSE LisT23_p ))

			(SETQ LisT23_u (REVERSE LisT23_u ))  (SETQ LisTagTODOu (CONS LisT23_u  LisTagTODOu ))

			(SETQ  Lis-Antes_T_u  LisT23_u )					; Siguiente Lista Compara 


			; (2) VERTICES VER23			INTER ( V23a_p  IN23a_p ) con ( V23b_p  IN23b_p )																											


			(SETQ LisV23_p  nil )
			(SETQ LisV23_u  nil )

			(SETQ N4 -1)
			(REPEAT NLados
				(SETQ N4 (+ N4 1))   (SETQ N5 (+ N4 1))   (IF (= N5  NLados ) (SETQ N5 0 ))

				(SETQ T23a_p (NTH N4 LisT23_p ))																		; (LENGTH LisT23_p )
				(SETQ T23b_p (NTH N5 LisT23_p ))

				(SETQ IN23a_p (TRANS (NTH N4 Lis-Antes_IN_u ) 0 1))   (SETQ IN23a_p (CAL " XYof( IN23a_p )"))
				(SETQ IN23b_p (TRANS (NTH N5 Lis-Antes_IN_u ) 0 1))   (SETQ IN23b_p (CAL " XYof( IN23b_p )"))

				(IF (= (CAL " ILL( T23a_p , IN23a_p , T23b_p , IN23b_p )") nil )
					(PROGN
						(PROMPT " >>>>>>>>> LINEAS PARALELAS    N4  = ") (PRIN1 N4) (TERPRI)
					) ; pro 

					(PROGN
						(SETQ V23p (CAL " ILL( T23a_p , IN23a_p , T23b_p , IN23b_p )"))   (SETQ LisV23_p (CONS V23p  LisV23_p ))
            (SETQ V23u (TRANS V23p 1 0 ))                                     (SETQ LisV23_u (CONS V23u  LisV23_u ))
					) ; pro 
				) ; if 


			) ; repe  NLados VER2 

			(SETQ LisV23_p (REVERSE LisV23_p ))   													; (LENGTH LisV23_p ) 

			; (2) INT2(2ab) = INT1(1) Siguiente Lista Datos    PUNTO INTERSECCION (VeA2p VeB2p)(C234op C234zp)															

			(SETQ LisIN23_234u  nil )

			(SETQ N6 -1)
			(REPEAT NLados
				(SETQ N6 (+ N6 1))   (SETQ N7 (+ N6 1))   (IF (= N7  NLados ) (SETQ N7 0 ))

				(SETQ V23a_p (NTH N6 LisV23_p ))
				(SETQ V23b_p (NTH N7 LisV23_p ))

				(SETQ C234op (TRANS C234ou 0 1 ))		(SETQ C234op (CAL " XYof( C234op )"))
				(SETQ C234zp (TRANS C234zu 0 1 ))		(SETQ C234zp (CAL " XYof( C234zp )"))

				(IF (= (CAL " ILL( V23a_p , V23b_p , C234op , C234zp)") nil )
					(PROGN
						(PROMPT " >>>>>>>>> LINEAS PARALELAS    N6  = ") (PRIN1 N6) (TERPRI)
					) ; pro 

					(PROGN
						(SETQ IN23_234p (CAL " ILL( V23a_p , V23b_p , C234op , C234zp)"))

						(SETQ IN23_234u (TRANS IN23_234p 1 0 ))   (SETQ LisIN23_234u (CONS IN23_234u  LisIN23_234u ))
					) ; pro 
				) ; if 

			) ; repe  NLados INT2 

			(SETQ LisIN23_234u (REVERSE LisIN23_234u ))   ; (LENGTH LisIN23_234u ) 				????????????????????????? 

			(SETQ Lis-Antes_IN_u  LisIN23_234u )   						; Siguiente Lista Datos 

			(SETQ LisV23_u (REVERSE LisV23_u ))   (SETQ LisVerTODOu (CONS LisV23_u  LisVerTODOu ))

   (COMMAND "SCP" "U") 


		"################################################################################################################################"
		;---------------------------------------------------------------------------------------------------------------------------------
		; (3) PLANO-FINAL   P34-C234oz   ENTRA( R34  INT_u )      SALIR( CIR-34  IN34/234  T34  V34 )                                 		
		;---------------------------------------------------------------------------------------------------------------------------------
				;																																																															
				;  IN34_234p  
				;																																																															
				;  T1u   T34_p   LisT34_p   
				;         T34_u   LisT34_u   
				;																																																															
				;   pT34a_p   IN34a_p   V34p                             
				;   pT34b_p   IN34b_p   V34u   LisV34_u   LisVerTODOu    

		(IF (= NSEC (- (LENGTH LIS-DATOS-SECCIONES ) 1 ))
			(PROGN

 				(COMMAND "SCP" "3P" P34u  C234ou  C234zu ) 								; (3) PLANO-FINAL 

					(COMMAND "COLOR" 7  "CIRCULO" '(0 0 0)  R34 )

					; (3) P-TANGENTES DESDE IN34_234 a CIRCULO P34 R34    en TRIANGULO RECTANGULO   DATOS: ( IN34_234p  C234op  R34 )						

					(SETQ LisT34_p  nil )
					(SETQ LisT34_u  nil )

					(SETQ N8 -1)
					(REPEAT NLados
						(SETQ N8 (+ N8 1))

						(SETQ IN34_234p (TRANS (NTH N8 LisIN23_234u ) 0 1))
						(SETQ C234op (TRANS C234ou  0 1))

						(SETQ SENOa (/ R34 (DISTANCE '(0.0 0.0 0.0) IN34_234p )))
						(SETQ COSEa (+ (SQRT (- 1 (* SENOa SENOa )))))

						(SETQ PTgA (LIST (* R34 SENOa )  (+ (* R34 COSEa ))  0.0 ))
						(SETQ PTgB (LIST (* R34 SENOa )  (- (* R34 COSEa ))  0.0 ))

						; (3) ROTACION DE EJES  TRANSFORMACION de (O) a (O)         AgB = O-X con O-X                   										

						(SETQ AgB    (CAL " ANG( [0,0,0] , C234op , IN34_234p )"))
						(SETQ T34a_p (CAL " ROT( PTgA , [0,0,0] , AgB )"))
						(SETQ T34b_p (CAL " ROT( PTgB , [0,0,0] , AgB )"))

						(SETQ T1u (NTH N3 Lis-Antes_T_u ))																						; PUN TAG ANTERIOR 



						(SETQ T34a_u (TRANS T34a_p 1 0 ))
						(SETQ T34b_u (TRANS T34b_p 1 0 ))

						; (3) ELIGE PUN-TAG  => SIGNO-Z en PLANO  IN12u  P23u  P34u																																


						(SETQ IN1u (NTH N3 Lis-Antes_IN_u ))

   					(COMMAND "SCP" "U")

						(COMMAND "SCP" "3P" IN1u  P23u  P34u )
							(SETQ T1k    (TRANS T1u    0 1 ))
							(SETQ T34a_k (TRANS T34a_u 0 1 ))
							(SETQ T34b_k (TRANS T34b_u 0 1 ))

							(COND
								((AND (> (CADDR T1k) 0) (> (CADDR T34a_k) 0))  (SETQ T34_p T34a_p) (SETQ LisT34_p (CONS T34_p  LisT34_p)))
								((AND (< (CADDR T1k) 0) (< (CADDR T34a_k) 0))  (SETQ T34_p T34a_p) (SETQ LisT34_p (CONS T34_p  LisT34_p)))
								((AND (> (CADDR T1k) 0) (> (CADDR T34b_k) 0))  (SETQ T34_p T34b_p) (SETQ LisT34_p (CONS T34_p  LisT34_p)))
								((AND (< (CADDR T1k) 0) (< (CADDR T34b_k) 0))  (SETQ T34_p T34b_p) (SETQ LisT34_p (CONS T34_p  LisT34_p)))
							) ; con 
   					(COMMAND "SCP" "U")


						;(SETQ DisA (DISTANCE T1u (TRANS T34a_p 1 0 ) ))     ; (3) ELIGE PUN-TAG  => MENOR DISTANCIA		
						;(SETQ DisB (DISTANCE T1u (TRANS T34b_p 1 0 ) ))
						;(IF (< DisA DisB ) (SETQ T34_p  T34a_p ) (SETQ T34_p  T34b_p ))   (SETQ LisT34_p (CONS T34_p  LisT34_p ))   ; ????
						;(IF (> DisA DisB ) (SETQ T34_p  T34a_p ) (SETQ T34_p  T34b_p ))   (SETQ LisT34_p (CONS T34_p  LisT34_p ))   ; ????


						(COMMAND "SCP" "3P" P23u  C123ou  C123zu )

						;(COMMAND  "COLOR" (+ N8 1)  "PUNTO"  IN34_234p )
						;(COMMAND  "COLOR" (+ N8 1)  "PUNTO"  T34_p  )

						(SETQ T34_u (TRANS T34_p 1 0 ))   (SETQ LisT34_u (CONS T34_u  LisT34_u ))

					) ; repe  NLados TAG34 

					(SETQ LisT34_p (REVERSE LisT34_p ))
	
					(SETQ LisT34_u (REVERSE LisT34_u ))   (SETQ LisTagTODOu (CONS LisT34_u  LisTagTODOu ))

					; (3) VERTICES VER34			INTER ( PTg3A  INT3A ) con ( PTg3B  INT3B )																												

					(SETQ LisV34_u  nil )

					(SETQ N9 -1)
					(REPEAT NLados
						(SETQ N9 (+ N9 1))   (SETQ N10 (+ N9 1))   (IF (= N10  NLados ) (SETQ N10 0 ))

						(SETQ pT34a_p (NTH N9  LisT34_p ))
						(SETQ pT34b_p (NTH N10 LisT34_p ))

						(SETQ IN34a_p (TRANS (NTH N9  LisIN23_234u ) 0 1))
						(SETQ IN34b_p (TRANS (NTH N10 LisIN23_234u ) 0 1))

						(SETQ V34p (CAL " ILL( pT34a_p , IN34a_p , pT34b_p , IN34b_p )"))
						(SETQ V34u (CAL " U2W( V34p )"))																					 ; SCP => SCU 

						(SETQ LisV34_u (CONS V34u  LisV34_u ))

					) ; repe  NLados VER2 

					(SETQ LisV34_u (REVERSE LisV34_u ))   (SETQ LisVerTODOu (CONS LisV34_u  LisVerTODOu ))

   			(COMMAND "SCP" "U") 

			) ; pro
		) ;if (= FINAL) 

	) ; repe   LIS-DATOS-SECCIONES  NSEC 

	(SETQ LisVerTODOu (REVERSE LisVerTODOu ))   ; (LENGTH LisVerTODOu ) 

	(SETQ LisTagTODOu (REVERSE LisTagTODOu ))   ; (LENGTH LisTagTODOu ) 

	;===================================================================================================================================
	;	(S) PINTA PUNTOS TAG SECIONES 																																																		

	(SETQ  PINTA-P-TAG 'SI )								; PINTA SECC REF SCU 
	(IF (= PINTA-P-TAG 'SI ) (PROGN


	(SETQ N11 -1)
	(REPEAT (- (LENGTH LisTagTODOu) 1 )
		(SETQ N11 (+ N11 1))

		(SETQ N12 -1)
		(REPEAT NLados
			(SETQ N12 (+ N12 1))

			(SETQ TAG-A (NTH N12 (NTH (+ N11 0 )  LisTagTODOu )))
			(SETQ TAG-B (NTH N12 (NTH (+ N11 1 )  LisTagTODOu )))

			(COMMAND "COLOR" (+ N12 1) "LINEA" TAG-A  TAG-B "")

			(COMMAND "COLOR" (+ N12 1) "PUNTO" TAG-A )

		) ; repe  N12 VER 
	) ; repe   N11 

	)) ; pro if  PINTA-P-TAG 


	;===================================================================================================================================
	;	(S) PINTA SECIONES POLIGONALES																																																		

	(SETQ  PINTA-SECCION 'NO )								; PINTA SECC REF SCU 
	(IF (= PINTA-SECCION 'SI ) (PROGN

	(SETQ N11 -1)
	(REPEAT (LENGTH LisVerTODOu )
		(SETQ N11 (+ N11 1))

		(SETQ N12 -1)
		(REPEAT NLados
			(SETQ N12 (+ N12 1))   (SETQ N13 (+ N12 1))   (IF (= N13  NLados ) (SETQ N13 0 ))

			(SETQ VER-1 (NTH N12 (NTH N11  LisVerTODOu )))
			(SETQ VER-2 (NTH N13 (NTH N11  LisVerTODOu )))

			(COMMAND "COLOR" (+ N12 1) "LINEA" VER-1 VER-2 "")

		) ; repe  N12 VER 
	) ; repe   N11 

	)) ; pro if  PINTA-SECCION 

	;===================================================================================================================================
	;	() PARANDO																																																												
	(SETVAR "blipmode" 1)  (SETVAR "cmdecho"  1)

	(PROMPT " ============================================================================") (TERPRI)
	(PROMPT " >>>> FINAL >>>>>>>>>>>>>>>>>>> ESCULTURA-NUDO-01 >>>>>>>>>>>>>>>>>>>>>>>>>>>") (TERPRI)
	(PROMPT " ============================================================================") (TERPRI)

) ; cierre DEFUN    ESCULTURA-NUDO-01 

"####################################################################################################################################"
;-------------------------------------------------------------------------------------------------------------------------------------
