
;-------------------------------------------------------------------------------------------------------------------------------------
;																																																																			
;	( ESCULTURA-NUDO-02 )                                                                 														17/06/2008				
;																																																																			
;=====================================================================================================================================
;																																																																			
; 		SECCION INICIO: POLIGUNO REGULAR  ( NLados )																																						        
;																																																																			
;			Genera 3DCARAS-PLANAS entre POLIGONOS de LADOS TANGENTES a CIRCULOS (RADIO) en PLANO NORMAL a (P2 P3) en PUNTO MEDIO (P23u)			
;																																																																			
;			SPLINE CAMINO: CURVA-3D  PUNTEADA con DIVIDE (NDiv) => P1 P2 P3 .........																										  
;																																																																			
;			SPLINE PERFIL: SPLINE CURVA-2D  DETERMINA PERFIL DEL CUERPO (PRINCIPIO y FIN en VERTICAL de SPLINE EJE)													
;			SPLINE EJE   : SPLINE RECTA HORIZONTAL (PRINCIPIO y FIN en VERTICAL de SPLINE PERFIL)																						
;																																																																			
;			CIRCULOS de RADIO VARIABLE (RADIO) Generados por DIFERENCIA = Y entre (Spline PERFIL) y (Spline EJE)														
;																																																																			
;			PINTA PATRONES y LINEA-GEODESICA (CREMALLERA)																																		                
;																																																																			




;-------------------------------------------------------------------------------------------------------------------------------------
;	(01)	(PUNTOS-DIVIDE) = PUNTEA SPLINE a NDIVISIONES ( N-ELE ) + ( NDIDI ) => ( LIS-PUNTOS )																				
;-------------------------------------------------------------------------------------------------------------------------------------

(DEFUN PUNTOS-DIVIDE (/  )

	(SETQ LIS-PUNTOS  nil)

	(SETQ   Elen (MEMBER (ASSOC 10 (ENTGET N-ELE)) (ENTGET N-ELE))									; lista a partir del elemento (incluido)
		    P-1    (CDR (NTH      0              Elen))												      ; primer elemento
		    P-Uo    (CDR (NTH (- (LENGTH Elen) 1) Elen)) )												    ; ultimo elemento

	(COMMAND  "COLOR" 1 "PUNTO"  P-1)																		          ; PINTA Primer Punto (en Base de Datos)
 	(SETQ  N-1P (ENTLAST))																						              ; Nombre ultima entidad principal = 1 punto
	(COMMAND	 "COLOR" 7 "DIVIDE" N-ELE NDIDI																      ; PINTA Punto Divide (en Base de Datos)
			     "COLOR" 5 "PUNTO"  P-Uo       )															          ; PINTA Ultimo Punto (en Base de Datos)

	;	PUNTOS SECCION X (PX1-PXn) =>  LIS-PUNTOS																																													

	(SETQ  N-P1         nil
		   	N-P2         nil
		   	N-P2         N-1P
		   	LIS-PUNTOS   nil
		   	LIS-PUNTOS  (LIST (CDR (ASSOC 10 (ENTGET N-1P))))											   ; LIS-PUNTOS => 1 punto
		   	WW           T )

	(WHILE WW
	  (SETQ N-P1 (ENTNEXT N-1P))																			         		  ; nombre entidad siguiente
				
		(IF (= N-P1 nil)	(SETQ WW nil)
			(PROGN
				(SETQ LIS-PUNTOS (CONS (CDR (ASSOC 10 (ENTGET N-P1))) LIS-PUNTOS))				; LIS-PUNTOS => Resto PUNTOS con ULTIMO
				(SETQ  N-1P N-P1 )
				(ENTDEL N-P1)																		; BORRA PUNTO N-P1 
			) ; pro
		) ; if 
	) ; whi
	(SETQ LIS-PUNTOS (REVERSE LIS-PUNTOS))
	(ENTDEL N-P2)																					; BORRA PUNTO N-P2 

) ;	(01)  DEFUN   PUNTOS-DIVIDE 

;-------------------------------------------------------------------------------------------------------------------------------------

;-------------------------------------------------------------------------------------------------------------------------------------
;	(02) CALCULOS  PERFIL RADIOS ( RADIO ) CIRCULOS a TANGENTES por SPLINE	SPLINE-REF ----- DIVIDIR NDiv*3 => LIS-Pun-REF => PP1 PP2	
;																		                                      SPLINE-EJE ----- DIVIDIR NDiv   => LIS-Pun-EJE => PPb	    
;-------------------------------------------------------------------------------------------------------------------------------------

(DEFUN LISTA-RADIOS-PERFIL (/  )

  (SETQ LIS-RADI nil)
	(SETQ NEje -1)
	(SETQ NRef -1)

	(REPEAT (LENGTH LIS-Pun-EJE)
		(SETQ NEje (+ NEje 1))

		(IF (NOT (= (REM NEje 2) 0))
			(PROGN
				(SETQ PPb (NTH NEje LIS-Pun-EJE))  (SETQ XXb (CAR PPb) YYb (CADR PPb))
				(SETQ WW T)
				(WHILE WW
					(SETQ NRef (+ NRef 1))
					(SETQ PP1 (NTH (+ NRef 0) LIS-Pun-REF))  (SETQ XX1 (CAR PP1) YY1 (CADR PP1))
					(SETQ PP2 (NTH (+ NRef 1) LIS-Pun-REF))  (SETQ XX2 (CAR PP2) YY2 (CADR PP2))

					(IF (AND (<= XX1 XXb) (< XXb XX2))
						(PROGN																																							
							(SETQ R-REF (/ (+ (* (- YY1 YYb) (- XX2 XXb)) (* (- YY2 YYb) (- XXb XX1))) (- XX2 XX1)))
							(SETQ LIS-RADI (CONS R-REF LIS-RADI))											; (LENGTH LIS-RADI)
							(SETQ WW nil)
							(COMMAND "COLOR" 1 "LINEA" PPb (LIST XXb (+ YYb R-REF)) "")
						) ;pro
					) ;if
					(IF (>= NRef (- (LENGTH LIS-Pun-REF) 2)) (SETQ WW nil))
				) ; Whi NRef
			) ;pro
		) ; if
	) ; repe NEje
	(SETQ LIS-RADI (REVERSE LIS-RADI))																		; (NTH 0 LIS-RADI)  (LENGTH LIS-RADI)

) ;	(02)  DEFUN   LISTA-RADIOS-PERFIL 

;-------------------------------------------------------------------------------------------------------------------------------------


;-------------------------------------------------------------------------------------------------------------------------------------
;	(03)	CALCULO de  LIS-DATOS-SECCIONES ( P12u R12  C123ou C123zu  P23u R23  C234ou C234zu  P34u R34 ) 																
;-------------------------------------------------------------------------------------------------------------------------------------

(DEFUN CALCULO-LIS-DATOS-SECC (/  )


	(SETQ LIS-DATOS-SECCIONES nil)

	(SETQ NSCP -1 )
	(REPEAT  (- (LENGTH LIS-Pun-CAMI) 3)
		(SETQ NSCP (+ NSCP 1))

		(SETQ P1 (NTH (+ NSCP 0) LIS-Pun-CAMI))   (SETQ X1 (CAR P1) Y1 (CADR P1) Z1 (CADDR P1))
		(SETQ P2 (NTH (+ NSCP 1) LIS-Pun-CAMI))   (SETQ X2 (CAR P2) Y2 (CADR P2) Z2 (CADDR P2))
		(SETQ P3 (NTH (+ NSCP 2) LIS-Pun-CAMI))   (SETQ X3 (CAR P3) Y3 (CADR P3) Z3 (CADDR P3))
		(SETQ P4 (NTH (+ NSCP 3) LIS-Pun-CAMI))   (SETQ X4 (CAR P4) Y4 (CADR P4) Z4 (CADDR P4))

		(IF (OR (AND (EQUAL (/ (- Y2 Y1) (- X2 X1)) (/ (- Y3 Y2) (- X3 X2)) mUNI )
					       (EQUAL (/ (- Z2 Z1) (- X2 X1)) (/ (- Z3 Z2) (- X3 X2)) mUNI ))  ; P1 P2 P3 en LINEA 

			      (AND (EQUAL (/ (- Y3 Y2) (- X3 X2)) (/ (- Y4 Y3) (- X4 X3)) mUNI )
					       (EQUAL (/ (- Z3 Z2) (- X3 X2)) (/ (- Z4 Z3) (- X4 X3)) mUNI ))) ; P2 P3 P4 en LINEA 

			(PROGN 	; (P1 P2 P3) y (P2 P3 P4) NO DEFINEN CIRCULOS 	

				(IF (AND (EQUAL (/ (- Y2 Y1) (- X2 X1)) (/ (- Y3 Y2) (- X3 X2)) mUNI )
					       (EQUAL (/ (- Z2 Z1) (- X2 X1)) (/ (- Z3 Z2) (- X3 X2)) mUNI ))  ; P1 P2 P3 en LINEA 
					(PROGN
						(PROMPT " >>>>>>>>>  NO DEFINEN CIRCULO en LINEA (P1 P2 P3)  NSCP = ( ")
						(PRIN1 (+ NSCP 0)) (PROMPT " ") (PRIN1 (+ NSCP 1)) (PROMPT " ")  (PRIN1 (+ NSCP 2)) (PROMPT " )")  (TERPRI)
					) ; pro 
				) ; if

				(IF (AND (EQUAL (/ (- Y3 Y2) (- X3 X2)) (/ (- Y4 Y3) (- X4 X3)) mUNI )
					       (EQUAL (/ (- Z3 Z2) (- X3 X2)) (/ (- Z4 Z3) (- X4 X3)) mUNI ))  ; P2 P3 P4 en LINEA 
					(PROGN
						(PROMPT " >>>>>>>>>  NO DEFINEN CIRCULO en LINEA (P2 P3 P4)  NSCP = ( ")
						(PRIN1 (+ NSCP 1)) (PROMPT " ") (PRIN1 (+ NSCP 2)) (PROMPT " ")  (PRIN1 (+ NSCP 3)) (PROMPT " )")  (TERPRI)
					) ; pro 
				) ; if
			) ; pro 


			(PROGN 	; (P1 P2 P3) y (P2 P3 P4) SI DEFINEN CIRCULOS 	

				; PUNTOS MEDIOS de (P1 P2) (P2 P3) (P3 P4) 																																										

				(SETQ P12u (CAL " PLT( P1 , P2 , 0.5 )"))
				(SETQ P23u (CAL " PLT( P2 , P3 , 0.5 )"))
				(SETQ P34u (CAL " PLT( P3 , P4 , 0.5 )"))

				; CENTRO del CIRCULO-OSCULADOR-AB   P1 P2 P3																																									

				(IF (= (CAL " NOR( P1 , P2 , P3 )") nil)
					(PROGN  (PROMPT " >>> PUNTOS (P1 P2 P3) ALINEADOS  CIR-OSCULA-1   NSCP = ") (PRIN1 NSCP) (TERPRI))

					(PROGN  (COMMAND "SCP" "3P" P1 P2 P3 ))						; PLANO PUNTOS => C123ou   para P12u P23u
				) ; if 

					(COMMAND "COLOR" 1  "CIRCULO" "3P" (TRANS P1 0 1) (TRANS P2 0 1) (TRANS P3 0 1))	; CIRCULO-OSCULADOR AB    
					(SETQ   NCi-AB  (ENTLAST))																												; "NCi-AB" NOMBRE CIRCULO-OSCULADOR
					(SETQ    C123ou (TRANS (CDR (ASSOC 10 (ENTGET NCi-AB)))  NCi-AB 0 ))							; CENTRO CIRCULO-OSCULADOR SCU  CHARNELA-0
					(SETQ    CenABp (TRANS (CDR (ASSOC 10 (ENTGET NCi-AB)))  NCi-AB 1 ))							; CENTRO CIRCULO-OSCULADOR SCP-AC
					(SETQ    C123zu (TRANS (LIST (CAR CenABp) (CADR CenABp) 40.0 ) 1   0 ))						; PERPENDICULAR CENTRO CIRCULO-OSCULADOR SCU
					(ENTDEL NCi-AB)																																		; "NCi-AB" BORRA 
				(COMMAND "SCP" "U") 

				; CENTRO del CIRCULO-OSCULADOR-BC   P2 P3 P4																																									

				(IF (= (CAL " NOR( P2 , P3 , P4 )") nil)
					(PROGN  (PROMPT " >>> PUNTOS (P2 P3 P4) ALINEADOS  CIR-OSCULA-2   NSCP = ") (PRIN1 NSCP) (TERPRI))

					(PROGN  (COMMAND "SCP" "3P" P2 P3 P4 ))						; PLANO PUNTOS => C234ou   para P23u P34u
				) ; if 

					(COMMAND "COLOR" 2  "CIRCULO" "3P" (TRANS P2 0 1) (TRANS P3 0 1) (TRANS P4 0 1))	; CIRCULO-OSCULADOR AB    
					(SETQ   NCi-BC  (ENTLAST))																												; "NCi-BC" NOMBRE CIRCULO-OSCULADOR
					(SETQ    C234ou (TRANS (CDR (ASSOC 10 (ENTGET NCi-BC)))  NCi-BC 0 ))							; CENTRO CIRCULO-OSCULADOR SCU  CHARNELA-0
					(SETQ    CenBCp (TRANS (CDR (ASSOC 10 (ENTGET NCi-BC)))  NCi-BC 1 ))							; CENTRO CIRCULO-OSCULADOR SCP-AC
					(SETQ    C234zu (TRANS (LIST (CAR CenBCp) (CADR CenBCp) 40.0 ) 1   0 ))						; PERPENDICULAR CENTRO CIRCULO-OSCULADOR SCU
					(ENTDEL NCi-BC)																																		; "NCi-BC" BORRA 
				(COMMAND "SCP" "U") 

				; RADIOS 																																																											

				(SETQ R12 (NTH (+ NSCP 0) LIS-RADI ))
				(SETQ R23 (NTH (+ NSCP 1) LIS-RADI ))
				(SETQ R34 (NTH (+ NSCP 2) LIS-RADI ))

				; LISTA SCP de SECCIONES																																																			
				(SETQ LIS-DATOS-SECCIONES  (CONS  (LIST P12u R12  C123ou C123zu  P23u R23  C234ou C234zu  P34u R34 )  LIS-DATOS-SECCIONES ))

			) ; pro
		) ; if  TRES PUNTOS en LINEA
	) ; repe  LIS-Pun-CAMI 

	(SETQ LIS-DATOS-SECCIONES (REVERSE LIS-DATOS-SECCIONES))   ; (LENGTH LIS-DATOS-SECCIONES ) 

) ;	(03)  DEFUN   CALCULO-LIS-DATOS-SECC 

;-------------------------------------------------------------------------------------------------------------------------------------



"####################################################################################################################################"
;-------------------------------------------------------------------------------------------------------------------------------------
; *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA 	
;-------------------------------------------------------------------------------------------------------------------------------------
"####################################################################################################################################"

(DEFUN C:ESCULTURA-NUDO-02 ( / )

	;===================================================================================================================================
	;  (00) ARRANCANDO																																																									

 	(SETVAR "blipmode" 0) (SETVAR "cmdecho" 0)  (GRAPHSCR)  (COMMAND "-REFENT" "DES")  (COMMAND "SCP" "U")  (COMMAND "ORTO" "DES")

	(PROMPT " ============================================================================")  (TERPRI)
	(PROMPT " >>>> INICIO >>>>>>>>>>>>>>>>>> ESCULTURA-NUDO-02 >>>>>>>>>>>>>>>>>>>>>>>>>>>")  (TERPRI)
	(PROMPT " ============================================================================")  (TERPRI) (TERPRI)

	(IF (= CAL nil)(COMMAND "ARX" "L" "GEOMCAL.ARX"))		; CARGA CALCULADORA 


	;===================================================================================================================================
	;	(01) FIJAR VARIABLES EN EL PROGRAMA																																																

	      (SETQ NDiv   60 )												; N(DIVIDE)  SPLINE ( AJUSTAS a DISTANCIA SECCIONES a 1 Ud ? )
				(SETQ NLados  5 )												; N de LADOS POLIGONO REGULAR en INICIO 

				(SETQ DesviAg  (* (/ PI 180.0) 5.0 ))			; DESVIACION ANGULO SECCION INICIO 

	      (SETQ mUNI 1.0e-006 )											; MARGEN EQUAL VEC-UNITARIOS (1.01e-008)LIMITE-MAR-INTER-RECT-01.lsp 

	;===================================================================================================================================
	;	(02) TOMA de DATOS en PANTALLA            																																												

 	(SETQ N-CAMI (CAR (ENTSEL "------------------------ MARCA >>>>>>>>>>>>>>>>>  SPLINE - CAMINO ? <<<<<<<<<" ))) (TERPRI)
 	(SETQ N-PERF (CAR (ENTSEL "------------------------ MARCA >>>>>>>>>>>>>>>>>  SPLINE - PERFIL ? <<<<<<<<<" ))) (TERPRI)
 	(SETQ N-BASE (CAR (ENTSEL "------------------------ MARCA >>>>>>>>>>>>>>>>>  SPLINE - EJE    ? <<<<<<<<<" ))) (TERPRI) (TERPRI)

	(PROMPT                   " ****************************************************************************")    (TERPRI)
	(PROMPT                   " ************************** COMENTARIOS y ERRORES ***************************")    (TERPRI) (TERPRI)


	;===================================================================================================================================
	;	(03)	LISTAS PUNTOS ( SPLI-CAMINO   SPLI-PERFIL   SPLI-BASE ) 																																		

	(SETQ  N-ELE N-CAMI   NDIDI    NDiv   )  (PUNTOS-DIVIDE)  (SETQ LIS-Pun-CAMI LIS-PUNTOS   P-Ulti  P-Uo)		; (LENGTH LIS-Pun-CAMI) 
	(SETQ  N-ELE N-PERF   NDIDI (* NDiv 6))  (PUNTOS-DIVIDE)  (SETQ LIS-Pun-REF  LIS-PUNTOS)							  	; (LENGTH LIS-Pun-REF)  
	(SETQ  N-ELE N-BASE   NDIDI (* NDiv 2))  (PUNTOS-DIVIDE)  (SETQ LIS-Pun-EJE  LIS-PUNTOS)									; (LENGTH LIS-Pun-EJE)  

	;===================================================================================================================================
	(LISTA-RADIOS-PERFIL)		  ;	(04) RADIOS CIRCULOS para TANGENTES en SECCCIONES (PERFIL SPLINE)  ( LIS-RADI )  												

	;===================================================================================================================================
	(CALCULO-LIS-DATOS-SECC)	;	(06) CALCULO de LIS-DATOS-SECCIONES ( P12u R12  C123ou C123zu  P23u R23  C234ou C234zu  P34u R34 )			


	"##################################################################################################################################"
	;===================================================================================================================================
	;	(04)  CALCULA TODAS las SECCIONES																																																	
	;===================================================================================================================================

	(SETQ Lis-VER-TODOu nil )
	(SETQ Lis-TAG-TODOu nil )

	(SETQ NSEC  -1 )
	(REPEAT  (LENGTH LIS-DATOS-SECCIONES )					 						; POR PLANOS  
		(SETQ NSEC  (+ NSEC 1))

		(SETQ LIS-DATOS (NTH  NSEC  LIS-DATOS-SECCIONES))				; ( P12u R12  C123ou C123zu  P23u R23  C234ou C234zu  P34u R34 ) 

		(SETQ P12u      (NTH 0 LIS-DATOS))
		(SETQ R12       (NTH 1 LIS-DATOS))
		(SETQ C123ou    (NTH 2 LIS-DATOS))
		(SETQ C123zu    (NTH 3 LIS-DATOS))
		(SETQ P23u      (NTH 4 LIS-DATOS))
		(SETQ R23       (NTH 5 LIS-DATOS))
		(SETQ C234ou    (NTH 6 LIS-DATOS))
		(SETQ C234zu    (NTH 7 LIS-DATOS))
		(SETQ P34u      (NTH 8 LIS-DATOS))
		(SETQ R34       (NTH 9 LIS-DATOS))

				; COMPRPBACION																																								
				;		(IF (= (REM (+ NSEC 1) 5) 0 ) (SETQ COLO 5 ) (SETQ COLO (REM (+ NSEC 1) 5) ))
				;		(COMMAND "COLOR" COLO  "LINEA" P12u   P23u   "")
				;		(COMMAND "COLOR" COLO  "LINEA" C123ou C123zu "")
			  ; ) ; repe
				; COMPRPBACION																																								


		"################################################################################################################################"
		;---------------------------------------------------------------------------------------------------------------------------------
		; (1) PLANO-INICIO  P12-C123oz   ENTRA   SALIR                   		
		;---------------------------------------------------------------------------------------------------------------------------------

		(IF (= NSEC 0 )
			(PROGN

				; (1) SECCION de REF-INICIO: POLIGONO REGULAR  ( NLados )	(1VERTICE en EJE-X + DesviAg )    Lis-VE-12p   Lis-TA-12p						

  			(SETQ Lis-VE-12p nil)
  			(SETQ Lis-TA-12p nil)

				(SETQ RaInc (NTH 0 LIS-RADI ))        (SETQ AgInc (/      PI  NLados ))						; 1RADIO y ANGULO CIRCULO INCRITO     
				(SETQ RaCir (/ RaInc (COS AgInc )))	  (SETQ AgCir (/ (* 2 PI) NLados ))						; 1RADIO y ANGULO CIRCULO CIRCUNCRITO 

				(SETQ Ag-CC (+ (- AgCir       ) DesviAg ))
				(SETQ Ag-II (+ (- AgInc AgCir ) DesviAg ))
				(REPEAT  NLados
					(SETQ Ag-CC  (+ Ag-CC  AgCir ))
					(SETQ Ag-II  (+ Ag-II  AgCir ))

					(SETQ V12o_p (LIST (* RaCir (COS Ag-CC)) (* RaCir (SIN Ag-CC)) 0.0 )) (SETQ Lis-VE-12p (CONS  V12o_p  Lis-VE-12p ))	; P-VERTIC 
					(SETQ T12o_p (LIST (* RaInc (COS Ag-II)) (* RaInc (SIN Ag-II)) 0.0 )) (SETQ Lis-TA-12p (CONS  T12o_p  Lis-TA-12p ))	; P-TANGEN 
				) ; repe

				(SETQ Lis-VE-12p (REVERSE Lis-VE-12p ))  ; (LENGTH Lis-VE-12p)
				(SETQ Lis-TA-12p (REVERSE Lis-TA-12p ))  ; (LENGTH Lis-TA-12p)

				; (1) PINTA CIRCULO y LADOS en PLANO-INICIO (P12-C123oz) R12 VER1 TAG1 INT1 ( Lis-Antes-INu ) ( Lis-VE-12u ) ( Lis-VER-TODOu ) 	

				(SETQ Lis-IN-12-123u nil )
				(SETQ Lis-VE-12u     nil )
				(SETQ Lis-TA-12u     nil )

				(SETQ Lis-Antes-INu  nil )
				(SETQ Lis-Antes-TAu  nil )

				(IF (= (CAL " NOR( P12u , C123ou , C123zu )") nil)
					(PROGN  (PROMPT " >>> PUNTOS (P12u C123ou C123zu) ALINEADOS PLANO-INICIO   NSEC = ") (PRIN1 NSEC) (TERPRI))

					(PROGN  (COMMAND "SCP" "3P" P12u  C123ou  C123zu ))						; (1) PLANO-INICIO 
				) ; if 

				;	(COMMAND "COLOR" 7  "CIRCULO" '(0 0 0)  R12 )

					(SETQ N1 -1)
					(REPEAT NLados
						(SETQ N1 (+ N1 1))  ; (SETQ N2 (+ N1 1))   (IF (= N2  NLados ) (SETQ N2 0 ))

						(SETQ V12_p (NTH N1  Lis-VE-12p )) (SETQ V12u (TRANS V12_p 1 0 ))  (SETQ Lis-VE-12u (CONS V12u  Lis-VE-12u ))
						(SETQ T12_p (NTH N1  Lis-TA-12p )) (SETQ T12u (TRANS T12_p 1 0 ))  (SETQ Lis-TA-12u (CONS T12u  Lis-TA-12u )) 

						;(COMMAND  "COLOR" (+ N1 1)  "PUNTO"  T12_p  )

						; (1) PUNTO INTERSECCION de LADO (V12_p T12_p) con CHARNELA (C123op C123zp)  =>  IN12_123p																

						(SETQ C123op (TRANS C123ou 0 1 ))		(SETQ C123op (CAL " XYof( C123op )"))
						(SETQ C123zp (TRANS C123zu 0 1 ))		(SETQ C123zp (CAL " XYof( C123zp )"))

						(IF (= (CAL " ILL( V12_p , T12_p , C123op , C123zp)") nil )
							(PROGN
								(PROMPT " >>>>>>>>> LINEAS PARALELAS    N1 = ") (PRIN1 N1) (TERPRI)
							) ; pro 

							(PROGN
								(SETQ IN12_123p (CAL " ILL( V12_p , T12_p , C123op , C123zp)"))

						    (SETQ IN12u (TRANS IN12_123p 1 0 ))   (SETQ Lis-IN-12-123u (CONS IN12u Lis-IN-12-123u ))

								;(COMMAND "COLOR" (+ N1 1)  "PUNTO" IN12_123p )
							) ; pro 
						) ; if 
					) ; repe

					(SETQ Lis-IN-12-123u (REVERSE Lis-IN-12-123u ))
					(SETQ Lis-TA-12u     (REVERSE Lis-TA-12u     ))   (SETQ Lis-TAG-TODOu (CONS Lis-TA-12u  Lis-TAG-TODOu ))
					(SETQ Lis-VE-12u     (REVERSE Lis-VE-12u     ))   (SETQ Lis-VER-TODOu (CONS Lis-VE-12u  Lis-VER-TODOu ))

					(SETQ Lis-Antes-INu  Lis-IN-12-123u )   						; Siguiente Lista Datos   
					(SETQ Lis-Antes-TAu  Lis-TA-12u     )   						; Siguiente Lista Compara 

				(COMMAND "SCP" "U")


				; (1) PINTA SECCION REF-INICIO  (COMPROBACION)																																								

				(SETQ  PINTA-SEC-REF-INICIO 'NO )								; PINTA SECC REF SCU 
				(IF (= PINTA-SEC-REF-INICIO 'SI ) (PROGN
					(SETQ Na -1 )
					(REPEAT  (LENGTH Lis-VE-12p)
						(SETQ Na (+ Na 1 ))
						(SETQ Nb (+ Na 1 ))   (IF (= Nb (LENGTH Lis-VE-12p)) (SETQ Nb 0 ))

						(SETQ PV1 (NTH Na  Lis-VE-12p))
						(SETQ PV2 (NTH Nb  Lis-VE-12p))

						(SETQ PT1 (NTH Na  Lis-TA-12p))
						(SETQ PT2 (NTH Nb  Lis-TA-12p))

						(COMMAND "COLOR" (+ Na 1 )  "LINEA" PV1 PV2 "")
						(COMMAND "COLOR" (+ Na 1 )  "LINEA" PT1 PT2 "")
					) ; repe 
				)) ; if pro  PINTA-SEC-REF-INICIO 

			) ; pro
		) ;if (= NSEC 0 ) 


		"################################################################################################################################"
		;---------------------------------------------------------------------------------------------------------------------------------
		; (2) PLANO-INTERMEDIO  P23-C123oz   ENTRA  SALIR 		
		;---------------------------------------------------------------------------------------------------------------------------------

		(IF (= (CAL " NOR( P23u , C123ou , C123zu )") nil)
			(PROGN  (PROMPT " >>> PUNTOS (P23u C123ou C123zu) ALINEADOS PLANO-INTERMEDIO  NSEC = ") (PRIN1 NSEC) (TERPRI))

			(PROGN  (COMMAND "SCP" "3P" P23u  C123ou  C123zu ))						; (2) PLANO-INTERMEDIO 
		) ; if 

		;	(COMMAND "COLOR" 7  "CIRCULO" '(0 0 0)  R23 )

			; (2) P-TANGENTES de IN23_123p a CIRCULO P23 R23    en TRIANGULO RECTANGULO   DATOS: ( IN23_123p  C123op  R23 )									

			(SETQ Lis-TA-23p  nil )
			(SETQ Lis-TA-23u  nil )

			(SETQ N3 -1)
			(REPEAT NLados
				(SETQ N3 (+ N3 1))

				(SETQ IN23_123p (TRANS (NTH N3 Lis-Antes-INu ) 0 1 ))	  (SETQ IN23_123p (CAL " XYof( IN23_123p )"))

				(SETQ SENOa (/ R23 (DISTANCE '(0.0 0.0 0.0) IN23_123p )))

				(IF (> SENOa 1.0 )
					(PROGN
						(PROMPT " >>>>>>>>> PUNTO ORIGEN TANGENTES DENTRO CIRCULO   N3 = ") (PRIN1 N3) (TERPRI)

					) ; pro 
					(PROGN
						(SETQ COSEa (+ (SQRT (- 1 (* SENOa SENOa )))))
					) ; pro 
				) ; if 

				(SETQ PTgA (LIST (* R23 SENOa )  (+ (* R23 COSEa ))  0.0 ))
				(SETQ PTgB (LIST (* R23 SENOa )  (- (* R23 COSEa ))  0.0 ))

				; (2) ROTACION DE EJES  TRANSFORMACION de (O) a (O)         AgB = O-X con O-X                   												

				(SETQ C123op (TRANS C123ou 0 1))   (SETQ C123op (CAL " XYof( C123op )"))			; corregido ???

				(SETQ AgB     (CAL " ANG( [0,0,0] ,  C123op , IN23_123p )"))									; ang(P0,P1,P2) ?? 
				(SETQ T23a_p (CAL " ROT(  PTgA  , [0,0,0] , AgB    )"))
				(SETQ T23b_p (CAL " ROT(  PTgB  , [0,0,0] , AgB    )"))											; rot(P1,P0,Ang)

				(SETQ T1u (NTH N3 Lis-Antes-TAu ))																					; PUN TAG ANTERIOR 

				(SETQ T23a_u (TRANS T23a_p 1 0 ))
				(SETQ T23b_u (TRANS T23b_p 1 0 ))

				; (2) ELIGE PUN-TAG  => SIGNO-Z en PLANO  IN12u  P12u  P23u																																		

				(SETQ IN1u (NTH N3 Lis-Antes-INu ))

   			(COMMAND "SCP" "U")

				(IF (= (CAL " NOR( IN1u , P12u , P23u )") nil)
					(PROGN  (PROMPT " >>> PUNTOS (IN1u P12u P23u) ALINEADOS PLANO-TAG   NSEC = ") (PRIN1 NSEC) (TERPRI))

					(PROGN  (COMMAND "SCP" "3P" IN1u  P12u  P23u ))
				) ; if 

					(SETQ T1k    (TRANS T1u    0 1 ))
					(SETQ T23a_k (TRANS T23a_u 0 1 ))
					(SETQ T23b_k (TRANS T23b_u 0 1 ))

					(COND
						((AND (> (CADDR T1k) 0) (> (CADDR T23a_k) 0))  (SETQ T23_p T23a_p) (SETQ Lis-TA-23p (CONS T23_p  Lis-TA-23p)))
						((AND (< (CADDR T1k) 0) (< (CADDR T23a_k) 0))  (SETQ T23_p T23a_p) (SETQ Lis-TA-23p (CONS T23_p  Lis-TA-23p)))
						((AND (> (CADDR T1k) 0) (> (CADDR T23b_k) 0))  (SETQ T23_p T23b_p) (SETQ Lis-TA-23p (CONS T23_p  Lis-TA-23p)))
						((AND (< (CADDR T1k) 0) (< (CADDR T23b_k) 0))  (SETQ T23_p T23b_p) (SETQ Lis-TA-23p (CONS T23_p  Lis-TA-23p)))
					) ; con 
   			(COMMAND "SCP" "U")

				(COMMAND "SCP" "3P" P23u  C123ou  C123zu )

				;(COMMAND  "COLOR" (+ N3 1)  "PUNTO"  IN23_123p )
				;(COMMAND  "COLOR" (+ N3 1)  "PUNTO"  T23_p  )

				(SETQ T23_u (TRANS T23_p 1 0 ))   (SETQ Lis-TA-23u (CONS T23_u  Lis-TA-23u ))

			) ; repe  NLados TAG2 

			(SETQ Lis-TA-23p (REVERSE Lis-TA-23p ))
			(SETQ Lis-TA-23u (REVERSE Lis-TA-23u ))  (SETQ Lis-TAG-TODOu (CONS Lis-TA-23u  Lis-TAG-TODOu ))
			(SETQ Lis-Antes-TAu  Lis-TA-23u )					; Siguiente Lista Compara 


			; (2) VERTICES VER23			INTER ( V23a_p  IN23a_p ) con ( V23b_p  IN23b_p )																											

			(SETQ Lis-VE-23p  nil )
			(SETQ Lis-VE-23u  nil )

			(SETQ NQ -2)
			(REPEAT NLados
				(SETQ NQ (+ NQ 1))
				(IF (= NQ -1 )
					(PROGN (SETQ N4 (- NLados 1 )) (SETQ N5     0     ))
					(PROGN (SETQ N4    NQ        ) (SETQ N5 (+ N4 1 )))   
				) ; if 

				(SETQ T23a_p (NTH N4 Lis-TA-23p ))																		; (LENGTH Lis-TA-23p )
				(SETQ T23b_p (NTH N5 Lis-TA-23p ))

				(SETQ IN23a_p (TRANS (NTH N4 Lis-Antes-INu ) 0 1))   (SETQ IN23a_p (CAL " XYof( IN23a_p )"))
				(SETQ IN23b_p (TRANS (NTH N5 Lis-Antes-INu ) 0 1))   (SETQ IN23b_p (CAL " XYof( IN23b_p )"))

				(IF (= (CAL " ILL( T23a_p , IN23a_p , T23b_p , IN23b_p )") nil )
					(PROGN
						(PROMPT " >>>>>>>>> LINEAS PARALELAS    N4  = ") (PRIN1 N4) (TERPRI)
					) ; pro 

					(PROGN
						(SETQ V23p (CAL " ILL( T23a_p , IN23a_p , T23b_p , IN23b_p )"))   (SETQ Lis-VE-23p (CONS V23p  Lis-VE-23p ))
            (SETQ V23u (TRANS V23p 1 0 ))                                     (SETQ Lis-VE-23u (CONS V23u  Lis-VE-23u ))
					) ; pro 
				) ; if 

			) ; repe  NLados VER2 

			(SETQ Lis-VE-23p (REVERSE Lis-VE-23p ))   													; (LENGTH Lis-VE-23p ) 

			; (2) INT2(2ab) = INT1(1) Siguiente Lista Datos    PUNTO INTERSECCION (VeA2p T23a_p)(C234op C234zp)															

			(SETQ Lis-IN-23-234u  nil )

			(SETQ N6 -1)
			(REPEAT NLados
				(SETQ N6 (+ N6 1))   (SETQ N7 (+ N6 1))   (IF (= N7  NLados ) (SETQ N7 0 ))

				(SETQ C234op (TRANS C234ou 0 1 ))		(SETQ C234op (CAL " XYof( C234op )"))
				(SETQ C234zp (TRANS C234zu 0 1 ))		(SETQ C234zp (CAL " XYof( C234zp )"))

				(SETQ V23a_p (NTH N6 Lis-VE-23p ))
				(SETQ V23b_p (NTH N7 Lis-VE-23p ))

				(SETQ T23a_p (NTH N6 Lis-TA-23p ))																		; (LENGTH Lis-TA-23p )
				(SETQ T23b_p (NTH N7 Lis-TA-23p ))

				(IF (= (CAL " ILL( V23a_p , T23a_p , C234op , C234zp)") nil )
					(PROGN
						(PROMPT " >>>>>>>>> LINEAS PARALELAS    N6  = ") (PRIN1 N6) (TERPRI)
					) ; pro 

					(PROGN
						(SETQ IN23_234p (CAL " ILL( V23a_p , T23a_p , C234op , C234zp)"))

						(SETQ IN23_234u (TRANS IN23_234p 1 0 ))   (SETQ Lis-IN-23-234u (CONS IN23_234u  Lis-IN-23-234u ))
					) ; pro 
				) ; if 

			) ; repe  NLados INT2 

			(SETQ Lis-IN-23-234u (REVERSE Lis-IN-23-234u ))   ; (LENGTH Lis-IN-23-234u ) 				????????????????????????? 

			(SETQ Lis-Antes-INu  Lis-IN-23-234u )   						; Siguiente Lista Datos 

			(SETQ Lis-VE-23u (REVERSE Lis-VE-23u ))   (SETQ Lis-VER-TODOu (CONS Lis-VE-23u  Lis-VER-TODOu ))

   (COMMAND "SCP" "U") 


		"################################################################################################################################"
		;---------------------------------------------------------------------------------------------------------------------------------
		; (3) PLANO-FINAL   P34-C234oz   ENTRA      SALIR                                 		
		;---------------------------------------------------------------------------------------------------------------------------------

		(IF (= NSEC (- (LENGTH LIS-DATOS-SECCIONES ) 1 ))
			(PROGN

				(IF (= (CAL " NOR( P34u , C234ou , C234zu )") nil)
					(PROGN  (PROMPT " >>> PUNTOS (P34u C234ou C234zu) ALINEADOS PLANO-INICIO   NSEC = ") (PRIN1 NSEC) (TERPRI))

					(PROGN  (COMMAND "SCP" "3P" P34u  C234ou  C234zu ))						; (3) PLANO-FINAL 
				) ; if 

					;	(COMMAND "COLOR" 7  "CIRCULO" '(0 0 0)  R34 )

					; (3) P-TANGENTES DESDE IN34_234 a CIRCULO P34 R34    en TRIANGULO RECTANGULO   DATOS: ( IN34_234p  C234op  R34 )						

					(SETQ Lis-TA-34p  nil )
					(SETQ Lis-TA-34u  nil )

					(SETQ N8 -1)
					(REPEAT NLados
						(SETQ N8 (+ N8 1))

						(SETQ IN34_234p (TRANS (NTH N8 Lis-IN-23-234u ) 0 1))		; *iguales* 
						(SETQ C234op (TRANS C234ou  0 1))

						(SETQ SENOa (/ R34 (DISTANCE '(0.0 0.0 0.0) IN34_234p )))

						(IF (> SENOa 1.0 )
							(PROGN
								(PROMPT " >>>>>>>>> PUNTO ORIGEN TANGENTES DENTRO CIRCULO   N8  = ") (PRIN1 N8) (TERPRI)
							) ; pro 
							(PROGN
								(SETQ COSEa (+ (SQRT (- 1 (* SENOa SENOa )))))
							) ; pro 
						) ; if 

						(SETQ PTgA (LIST (* R34 SENOa )  (+ (* R34 COSEa ))  0.0 ))
						(SETQ PTgB (LIST (* R34 SENOa )  (- (* R34 COSEa ))  0.0 ))

						; (3) ROTACION DE EJES  TRANSFORMACION de (O) a (O)         AgB = O-X con O-X                   										

						(SETQ AgB     (CAL " ANG( [0,0,0] , C234op , IN34_234p )"))
						(SETQ T34a_p (CAL " ROT( PTgA , [0,0,0] , AgB )"))
						(SETQ T34b_p (CAL " ROT( PTgB , [0,0,0] , AgB )"))

						(SETQ T34a_u (TRANS T34a_p 1 0 ))
						(SETQ T34b_u (TRANS T34b_p 1 0 ))

						; (3) ELIGE PUN-TAG  => SIGNO-Z en PLANO  IN1u  P23u  P34u																																

						(SETQ T1u  (NTH N8 Lis-Antes-TAu ))																						; PUN TAG ANTERIOR 
						(SETQ IN1u (NTH N8 Lis-Antes-INu ))		; *iguales* 

   					(COMMAND "SCP" "U")

						(IF (= (CAL " NOR( IN1u , P23u , P34u )") nil)
							(PROGN  (PROMPT " >>> PUNTOS (IN1u  P23u  P34u) ALINEADOS PLANO-TAG   NSEC = ") (PRIN1 NSEC) (TERPRI))

							(PROGN  (COMMAND "SCP" "3P" IN1u  P23u  P34u ))						; (3) PLANO-TAG 
						) ; if 

							(SETQ T1k    (TRANS T1u    0 1 ))
							(SETQ T34a_k (TRANS T34a_u 0 1 ))
							(SETQ T34b_k (TRANS T34b_u 0 1 ))

							(COND
								((AND (> (CADDR T1k) 0) (> (CADDR T34a_k) 0))  (SETQ T34_p T34a_p) (SETQ Lis-TA-34p (CONS T34_p  Lis-TA-34p)))
								((AND (< (CADDR T1k) 0) (< (CADDR T34a_k) 0))  (SETQ T34_p T34a_p) (SETQ Lis-TA-34p (CONS T34_p  Lis-TA-34p)))
								((AND (> (CADDR T1k) 0) (> (CADDR T34b_k) 0))  (SETQ T34_p T34b_p) (SETQ Lis-TA-34p (CONS T34_p  Lis-TA-34p)))
								((AND (< (CADDR T1k) 0) (< (CADDR T34b_k) 0))  (SETQ T34_p T34b_p) (SETQ Lis-TA-34p (CONS T34_p  Lis-TA-34p)))
							) ; con 
   					(COMMAND "SCP" "U")

						(COMMAND "SCP" "3P" P34u  C234ou  C234zu )

						;(COMMAND  "COLOR" (+ N8 1)  "PUNTO"  IN34_234p )
						;(COMMAND  "COLOR" (+ N8 1)  "PUNTO"  T34_p  )

						(SETQ T34_u (TRANS T34_p 1 0 ))   (SETQ Lis-TA-34u (CONS T34_u  Lis-TA-34u ))   ; ????????????????????????????? 

					) ; repe  NLados TAG34 

					(SETQ Lis-TA-34p (REVERSE Lis-TA-34p ))
					(SETQ Lis-TA-34u (REVERSE Lis-TA-34u ))   (SETQ Lis-TAG-TODOu (CONS Lis-TA-34u  Lis-TAG-TODOu ))

					; (3) VERTICES VER34			INTER ( PTg3A  INT3A ) con ( PTg3B  INT3B )																												

					(SETQ Lis-VE-34u  nil )

					(SETQ NQ -2)
					(REPEAT NLados
						(SETQ NQ (+ NQ 1))
						(IF (= NQ -1 )
							(PROGN (SETQ N9 (- NLados 1 )) (SETQ N10     0     ))
							(PROGN (SETQ N9    NQ        ) (SETQ N10 (+ N9 1 )))
						) ; if 

						(SETQ pT34a_p (NTH N9  Lis-TA-34p ))
						(SETQ pT34b_p (NTH N10 Lis-TA-34p ))

						(SETQ IN34a_p (TRANS (NTH N9  Lis-IN-23-234u ) 0 1))
						(SETQ IN34b_p (TRANS (NTH N10 Lis-IN-23-234u ) 0 1))

						(SETQ V34p (CAL " ILL( pT34a_p , IN34a_p , pT34b_p , IN34b_p )"))

						(SETQ V34u (TRANS V34p 1 0 ))  (SETQ Lis-VE-34u (CONS V34u  Lis-VE-34u ))

					) ; repe  NLados VER2 

					(SETQ Lis-VE-34u (REVERSE Lis-VE-34u ))   (SETQ Lis-VER-TODOu (CONS Lis-VE-34u  Lis-VER-TODOu ))

   			(COMMAND "SCP" "U") 

			) ; pro
		) ;if (= FINAL) 

	) ; repe   LIS-DATOS-SECCIONES  NSEC 

	(SETQ Lis-VER-TODOu (REVERSE Lis-VER-TODOu ))   ; (LENGTH Lis-VER-TODOu ) 
	(SETQ Lis-TAG-TODOu (REVERSE Lis-TAG-TODOu ))   ; (LENGTH Lis-TAG-TODOu ) 



	;***********************************************************************************************************************************
	;===================================================================================================================================
	;	(05) PINTA PUNTOS TAG SECIONES 																																																		

	(SETQ  PINTA-PUN-TAG 'NO )  (IF (= PINTA-PUN-TAG 'SI ) (PROGN


		(SETQ N11 -1)
		(REPEAT (- (LENGTH Lis-TAG-TODOu) 1 )
			(SETQ N11 (+ N11 1))

			(SETQ N12 -1)
			(REPEAT NLados
				(SETQ N12 (+ N12 1))

				(SETQ TAG-A (NTH N12 (NTH (+ N11 0 )  Lis-TAG-TODOu )))
				(SETQ TAG-B (NTH N12 (NTH (+ N11 1 )  Lis-TAG-TODOu )))

				(COMMAND "COLOR" (+ N12 1) "LINEA" TAG-A  TAG-B "")
				(COMMAND "COLOR" (+ N12 1) "PUNTO" TAG-A )

				(IF (= N11 (- (LENGTH Lis-TAG-TODOu) 2 )) (COMMAND "COLOR" (+ N12 1) "PUNTO" TAG-B ))

			) ; repe  N12 VER 
		) ; repe   N11 

	)) ; pro if  PINTA-PUN-TAG 


	;***********************************************************************************************************************************
	;===================================================================================================================================
	;	(06) PINTA SECIONES POLIGONALES																																																		

	(SETQ  PINTA-LIN-SECCION 'NO )  (IF (= PINTA-LIN-SECCION 'SI ) (PROGN


		(SETQ N11 -1)
		(REPEAT (LENGTH Lis-VER-TODOu )
			(SETQ N11 (+ N11 1))

			(SETQ N12 -1)
			(REPEAT NLados
				(SETQ N12 (+ N12 1))   (SETQ N13 (+ N12 1))   (IF (= N13  NLados ) (SETQ N13 0 ))

				(SETQ VER-1 (NTH N12 (NTH N11  Lis-VER-TODOu )))
				(SETQ VER-2 (NTH N13 (NTH N11  Lis-VER-TODOu )))

				(COMMAND "COLOR" (+ N12 1) "LINEA" VER-1 VER-2 "")

			) ; repe  N12 VER 
		) ; repe   N11 

	)) ; pro if  PINTA-LIN-SECCION 


	;***********************************************************************************************************************************
	;===================================================================================================================================
	;	(07) PINTA  3DCARAS-3D  3DCARAS-2D																																																

	(SETQ  PINTA-3DC-3D-2D 'SI )  (IF (= PINTA-3DC-3D-2D 'SI ) (PROGN


		(SETQ SEPARA 1000 )														; SEPARACION ENTRE PATRONES 
		(SETQ LIS-COLUMNA-FILA-3DC-3D nil )
		(SETQ LIS-COLUMNA-FILA-3DC-2D nil )

		(SETQ NP1 -1)
		(REPEAT NLados
			(SETQ NP1 (+ NP1 1))   (SETQ NP2 (+ NP1 1))   (IF (= NP2  NLados ) (SETQ NP2 0 ))

			(SETQ LIS-COLUMNA-3DC-3D nil )
			(SETQ LIS-COLUMNA-3DC-2D nil )

			(SETQ KK1 (LIST (* (+ NP1 1) SEPARA ) 0.0  0.0 ))
			(SETQ KK2 (LIST (+ (CAR KK1) 10 )      0.0  0.0 ))

			(SETQ NSa -1)
			(REPEAT (- (LENGTH Lis-VER-TODOu) 1 )				; ((A1 A2 A3) (B1 B2 B3) ... ) 
				(SETQ NSa (+ NSa 1))
				(SETQ NSb (+ NSa 1))

				(SETQ PA1 (NTH NP1 (NTH NSa  Lis-VER-TODOu )))
				(SETQ PA2 (NTH NP2 (NTH NSa  Lis-VER-TODOu )))

				(SETQ PB1 (NTH NP1 (NTH NSb  Lis-VER-TODOu )))
				(SETQ PB2 (NTH NP2 (NTH NSb  Lis-VER-TODOu )))

				(COMMAND "COLOR" (+ NP1 1)   "3DCARA" PA1 PA2 PB2 PB1 "")																						; 3SCARA-3D 

				(SETQ LIS-LADOS-3DC-3D   (LIST (LIST PA1 PA2) (LIST PA2 PB2) (LIST PB2 PB1) (LIST PB1 PA1)))					; LADOS-3DC-3D 
				(SETQ LIS-COLUMNA-3DC-3D (CONS LIS-LADOS-3DC-3D  LIS-COLUMNA-3DC-3D ))

				(COMMAND "SCP" "3P" PA1 PA2 PB1 )					; PLANO 3DC 3D 
					(SETQ PA1p (LIST 0.0 0.0 0.0))
					(SETQ PA2p (TRANS PA2 0 1 ))   (SETQ PA2p (CAL " XYof( PA2p )"))
					(SETQ PB1p (TRANS PB1 0 1 ))   (SETQ PB1p (CAL " XYof( PB1p )"))
					(SETQ PB2p (TRANS PB2 0 1 ))   (SETQ PB2p (CAL " XYof( PB2p )"))





					(COMMAND "COLOR" (+ NP1 1)  "TEXTO"  (LIST 0.1 0.1)  1.0  0  (STRCAT "<" (ITOA NP1 ) ">" (ITOA NSa )))

   			(COMMAND "SCP" "U")

				(COMMAND "SCP" "3P" KK1 KK2 "" )					; PLANO PATRONES 2D 

					(COMMAND "COLOR" (+ NP1 1)   "3DCARA" PA1p PA2p PB2p PB1p "")																			; 3SCARA-2D 

					(SETQ PA1pU (TRANS PA1p 1 0 ))   (SETQ PA1pU (CAL " XYof( PA1pU )"))
					(SETQ PA2pU (TRANS PA2p 1 0 ))   (SETQ PA2pU (CAL " XYof( PA2pU )"))
					(SETQ PB1pU (TRANS PB1p 1 0 ))   (SETQ PB1pU (CAL " XYof( PB1pU )"))
					(SETQ PB2pU (TRANS PB2p 1 0 ))   (SETQ PB2pU (CAL " XYof( PB2pU )"))

					(SETQ LIS-LADOS-3DC-2D (LIST (LIST PA1pU PA2pU) (LIST PA2pU PB2pU) (LIST PB2pU PB1pU) (LIST PB1pU PA1pU))) ; LADOS-3DC-2D U 

					(SETQ LIS-COLUMNA-3DC-2D (CONS LIS-LADOS-3DC-2D  LIS-COLUMNA-3DC-2D ))

					(SETQ KK1 (TRANS PB1p 1 0 ))
					(SETQ KK2 (TRANS PB2p 1 0 ))





					(COMMAND "COLOR" (+ NP1 1)  "TEXTO"  (LIST 0.1 0.1)  1.0  0  (STRCAT "<" (ITOA NP1 ) ">" (ITOA NSa )))

   			(COMMAND "SCP" "U")

			) ; repe  NP1  Vertices 

			(SETQ LIS-COLUMNA-3DC-3D      (REVERSE LIS-COLUMNA-3DC-3D ))														; (LENGTH LIS-COLUMNA-3DC-3D) 59 
			(SETQ LIS-COLUMNA-FILA-3DC-3D (CONS LIS-COLUMNA-3DC-3D  LIS-COLUMNA-FILA-3DC-3D ))
			(SETQ LIS-COLUMNA-3DC-2D      (REVERSE LIS-COLUMNA-3DC-2D ))														; (LENGTH LIS-COLUMNA-3DC-2D) 59 
			(SETQ LIS-COLUMNA-FILA-3DC-2D (CONS LIS-COLUMNA-3DC-2D  LIS-COLUMNA-FILA-3DC-2D ))

		) ; repe    NSa  Secciones 

		(SETQ LIS-COLUMNA-FILA-3DC-3D (REVERSE LIS-COLUMNA-FILA-3DC-3D ))													; (LENGTH LIS-COLUMNA-FILA-3DC-3D) 3 
		(SETQ LIS-COLUMNA-FILA-3DC-2D (REVERSE LIS-COLUMNA-FILA-3DC-2D ))													; (LENGTH LIS-COLUMNA-FILA-3DC-2D) 3 


	)) ; pro if  PINTA-3DC-3D-2D 





	;"*********************************************************************************************************************************"
	"**********************************************************************************************************************************"
	;===================================================================================================================================
	;	(08) PINTA  LINEA GEODESICA (CREMALLERA)																																													
	;===================================================================================================================================
	"**********************************************************************************************************************************"
	;"*********************************************************************************************************************************"

	(SETQ  PINTA-LINEA-GEODESICA 'NO )  (IF (= PINTA-LINEA-GEODESICA 'SI ) (PROGN


	;(PROMPT " ----------------------------------------------------------------------------")  (TERPRI)
	;(PROMPT " ------------------- MARCA 1LINEA --> GEODESICA en FILA-1 ------------------")  (TERPRI)
	;(SETQ CONJ-1LINEA (SSGET))
	;(SETQ LisLINE (ENTGET (SSNAME CONJ-1LINEA  0 )))					  																	; LIS-1LINEA-Geodesica 
	;(SETQ PGeoA (CDR (ASSOC 10 LisLINE )))
	;(SETQ PGeoB (CDR (ASSOC 11 LisLINE )))

	;(COMMAND "-REFENT" "CERCANO")
	(COMMAND "-REFENT" "FIN")
		(SETQ PGeoA (GETPOINT ">>>>>>>>>>>>> MARCA 1LINEA GEODESICA 1PUNTO (en INICIO)")) (TERPRI)
		(SETQ PGeoB (GETPOINT ">>>>>>>>>>>>> MARCA 1LINEA GEODESICA 2PUNTO "))            (TERPRI)
	(COMMAND "-REFENT" "DES")

	(IF (> (CADDR PGeoA) (CADDR PGeoB)) (PROGN (PROMPT " ---------------------- INVERTIR PUNTOS LINEA ????????????") (TERPRI)))


	;  BUSCA en TODAS(3DC) => N12Cu (1Cuadro(3DC) de 1LINEA-GEO-ACTUAL  +  2Cuadro(3DC) de LINEA-GEO-SIGUIENTE)  LADO COMUN	

	(SETQ N12Cu nil )

	(SETQ NCOLU -1)
	(REPEAT NLados         (SETQ NCOLU (+ NCOLU 1))
		(SETQ NFILA -1)
		(REPEAT (- NDiv 1 )  (SETQ NFILA (+ NFILA 1))
			(SETQ NLADO -1)
				(REPEAT 4         (SETQ NLADO (+ NLADO 1))

				(SETQ Lado1 (NTH 0 (NTH NLADO (NTH NFILA (NTH NCOLU  LIS-COLUMNA-FILA-3DC-3D )))))
				(SETQ Lado2 (NTH 1 (NTH NLADO (NTH NFILA (NTH NCOLU  LIS-COLUMNA-FILA-3DC-3D )))))

				(IF (EQUAL (CAL " VEC1( Lado1 , Lado2 )") (CAL " VEC1( Lado1 , PGeoB  )") mUNI )

					  (PROGN   (SETQ N12Cu (CONS (LIST NCOLU  NFILA  NLADO ) N12Cu ))))

			) ; repe  NLADO 
		) ; repe  NFILA 
	) ; repe  NCOLU 

	(SETQ N12Cu (REVERSE N12Cu ))		;	((NCo1  NFi1  NLa1) (NCo2  NFi2  NLa2))  LADO COMUN en 1 y 2 CUADROS CONSECUTIVOS 


	;  ORDENA  =>  NA1 NA2  (Por Orden de LECTURA Anterior); 2CuNCOLU = (NL-1) y 2CuNLADO = 1	                                	

	(IF (AND (= (NTH 0 (NTH 1 N12Cu )) (- NLados 1 ))  (= (NTH 2 (NTH 1 N12Cu )) 1 ))

		(PROGN  (SETQ NA1 (NTH 1 N12Cu ))
			      (SETQ NA2 (NTH 0 N12Cu )))

		(PROGN  (SETQ NA1 (NTH 0 N12Cu ))						; NA1  CUADRO-(3DC) de LINEA-GEO-ACTUAL      (1 0 2)
			      (SETQ NA2 (NTH 1 N12Cu ))))					; NA2  CUADRO-(3DC) de LINEA-GEO-SIGUIENTE   (1 1 0)


	; 1 LINEA GEODESICA en 3D y 2D PATRONES  INICIO																																										

	"--------------------------------------------------------------------------------------------------------------------------------"
	(COMMAND "COLOR" 7 "LINEA" PGeoA  PGeoB "")	 																										; INICIO 1LINEA GEODESICA 3D 
	"--------------------------------------------------------------------------------------------------------------------------------"

		(SETQ LADOS-NA1d3 (NTH (NTH 1 NA1) (NTH (NTH 0 NA1) LIS-COLUMNA-FILA-3DC-3D )))
		(SETQ LADOS-NA1d2 (NTH (NTH 1 NA1) (NTH (NTH 0 NA1) LIS-COLUMNA-FILA-3DC-2D )))

		(SETQ oA1d3 (NTH 0  (NTH 0  LADOS-NA1d3)))
		(SETQ oA2d3 (NTH 1  (NTH 0  LADOS-NA1d3)))
		(SETQ oB1d3 (NTH 1  (NTH 2  LADOS-NA1d3)))

		(COMMAND "SCP" "3P" oA1d3  oA2d3  oB1d3 )         																						; Plano CARA-3D 
			(SETQ  PGeoA2D (TRANS PGeoA 0 1))     (SETQ PGeoA2D (CAL " XYof( PGeoA2D )"))
			(SETQ  PGeoB2D (TRANS PGeoB 0 1))     (SETQ PGeoB2D (CAL " XYof( PGeoB2D )"))
		(COMMAND "SCP" "U") 

		(SETQ oA1d2 (NTH 0  (NTH 0  LADOS-NA1d2)))
		(SETQ oA2d2 (NTH 1  (NTH 0  LADOS-NA1d2)))
		(SETQ oB1d2 (NTH 1  (NTH 2  LADOS-NA1d2)))

		(COMMAND "SCP" "3P" oA1d2  oA2d2  oB1d2 )	         																					  ; Plano CARA-2D 
			(COMMAND "COLOR" 7 "LINEA" PGeoA2D  PGeoB2D "")																							; 1 LINEA GEODESICA 2D 
		(COMMAND "SCP" "U") 




	;  PUNTOS  CUADRO-GEO-ACTUAL(NA1) y CUADRO-GEO-SIGUIENTE(NA2)      CUADROS CONSECUTIVOS con LADO COMUN														

	(SETQ NdeR -1 )
	(REPEAT (* 2 NDiv )       ; SE DETIENE con ERROR     LIS-COLUMNA-FILA-3DC-3D => nil       ????????????????? 
		(SETQ NdeR (+ NdeR 1 ))

		;                          FILA              COLUMNA                            
		(SETQ LADOS-NA1 (NTH (NTH 1 NA1) (NTH (NTH 0 NA1) LIS-COLUMNA-FILA-3DC-3D )))
		(SETQ LADOS-NA2 (NTH (NTH 1 NA2) (NTH (NTH 0 NA2) LIS-COLUMNA-FILA-3DC-3D )))

		(COND ;  Lado COMUN Cua-A1   Lado COMUN Cua-A2                                              ; oA1 o------------o oA2 
			((AND (= (NTH 2 NA1) 0 ) (= (NTH 2 NA2) 2 ))  ; con1        PUNTO   LADO                ;     |  1  L2  0  |     
				                                              (SETQ oA1 (NTH 1  (NTH 2  LADOS-NA1)))		;     |0          1|     
				                                              (SETQ oA2 (NTH 0  (NTH 2  LADOS-NA1)))		;     |L3 (CuA1) L1|     
				                                              (SETQ oB1 (NTH 0  (NTH 0  LADOS-NA1)))		;     |1          0|     
				                                              (SETQ oB2 (NTH 1  (NTH 0  LADOS-NA1)))		;     |  0  L0  1  |     
				                                              (SETQ oC1 (NTH 0  (NTH 0  LADOS-NA2)))		; oB1 o------------o oB2 
				                                              (SETQ oC2 (NTH 1  (NTH 0  LADOS-NA2)))   ;     |  1  L2  0  |     
                                                      (SETQ NL-B1C1 3 )                        ;     |0          1|     
                                                      (SETQ NL-C1C2 0 )                        ;     |L3 (CuA2) L1|     
                                                      (SETQ NL-C2B2 1 ))                       ;     |1          0|     
                                                                                                ;     |  0  L0  1  |     
                                                                                                ; oC1 o------------o oC2 

			((AND (= (NTH 2 NA1) 1 ) (= (NTH 2 NA2) 3 ))  ; con2        PUNTO   LADO                ; oA2          oB2          oC2 
				                                              (SETQ oA1 (NTH 0  (NTH 0  LADOS-NA1)))   ;  o------------o------------o  
				                                              (SETQ oA2 (NTH 1  (NTH 2  LADOS-NA1)))		;  |  1  L2  0  |  1  L2  0  |  
				                                              (SETQ oB1 (NTH 1  (NTH 0  LADOS-NA1)))		;  |0          1|0          1|  
				                                              (SETQ oB2 (NTH 0  (NTH 2  LADOS-NA1)))		;  |L3 (CuA1) L1|L3 (CuA2) L1|  
				                                              (SETQ oC1 (NTH 1  (NTH 0  LADOS-NA2)))		;  |1          0|1          0|  
				                                              (SETQ oC2 (NTH 0  (NTH 2  LADOS-NA2))) 	;  |  0  L0  1  |  0  L0  1  |  
                                                      (SETQ NL-B1C1 0 )                        ;  o------------o------------o  
                                                      (SETQ NL-C1C2 1 )                        ; oA1          oB1          oC1 
                                                      (SETQ NL-C2B2 2 ))

			((AND (= (NTH 2 NA1) 2 ) (= (NTH 2 NA2) 0 ))  ; con3        PUNTO   LADO                ; oC1 o------------o oC2 
				                                              (SETQ oA1 (NTH 0  (NTH 0  LADOS-NA1)))   ;     |  1  L2  0  |     
				                                              (SETQ oA2 (NTH 1  (NTH 0  LADOS-NA1)))	  ;     |0          1|     
				                                              (SETQ oB1 (NTH 1  (NTH 2  LADOS-NA1)))		;     |L3 (CuA2) L1|     
				                                              (SETQ oB2 (NTH 0  (NTH 2  LADOS-NA1)))		;     |1          0|     
				                                              (SETQ oC1 (NTH 1  (NTH 2  LADOS-NA2)))		;     |  0  L0  1  |     
				                                              (SETQ oC2 (NTH 0  (NTH 2  LADOS-NA2)))   ; oB1 o------------o oB2 
                                                      (SETQ NL-B1C1 3 )                        ;     |  1  L2  0  |     
                                                      (SETQ NL-C1C2 2 )                        ;     |0          1|     
                                                      (SETQ NL-C2B2 1 ))                       ;     |L3 (CuA1) L1|     
                                                                                                ;     |1          0|     
                                                                                                ;     |  0  L0  1  |     
                                                                                                ; oA1 o------------o oA2 

			((AND (= (NTH 2 NA1) 3 ) (= (NTH 2 NA2) 1 ))  ; con4        PUNTO   LADO                ; oC2          oB2          oA2 
				                                              (SETQ oA1 (NTH 0  (NTH 1  LADOS-NA1)))		;  o------------o------------o  
				                                              (SETQ oA2 (NTH 1  (NTH 1  LADOS-NA1)))		;  |  1  L2  0  |  1  L2  0  |  
				                                              (SETQ oB1 (NTH 1  (NTH 3  LADOS-NA1)))		;  |0          1|0          1|  
				                                              (SETQ oB2 (NTH 0  (NTH 3  LADOS-NA1)))		;  |L3 (CuA2) L1|L3 (CuA1) L1|  
				                                              (SETQ oC1 (NTH 1  (NTH 3  LADOS-NA2)))		;  |1          0|1          0|  
				                                              (SETQ oC2 (NTH 0  (NTH 3  LADOS-NA2)))   ;  |  0  L0  1  |  0  L0  1  |  
                                                      (SETQ NL-B1C1 0 )                        ;  o------------o------------o  
                                                      (SETQ NL-C1C2 3 )                        ; oC1          oB1          oA1 
                                                      (SETQ NL-C2B2 2 ))

			(  T  (PROMPT " ------------------- NO CUMPLE CONDICION LADOS ? ------------------")  (TERPRI))
		) ; con


		;                                                                                                       
		;                                            o InC2B2                                                   
		;                                           /|                                                          
		;                                          / |                                                          
		;                                         /  |                                                          
		;                                        /   |                                                          
		;                                       /    |                                                          
		;                       InC1C2 = PGeoC /     |                                                          
		;           oC1 O---------------------o------o oC2                                                      
		;               |                    /       |                                                          
		;               |                   /        |                                                          
		;               |            PGeoR o         |                                                          
		;               |  (oB2 +ROT(AgG))/          |                                                          
		;               |                /           |                                                          
		;               |               /   ROT(AgG) |                                                          
		;               |              /             |                                                          
		;           oB1 o-------------o--------------o oB2                                                      
		;               |            / PGeoB         |                                                          
		;               |      AgG  /                |                                                          
		;               |          /                 |                                                          
		;               |         /                  |                                                          
		;               |        /                   |                                                          
		;               |       /                    |                                                          
		;               |      /                     |                                                          
		;           oA1 o-----o----------------------o oA2                                                      
		;               |    / PGeoA                                                                            
		;               |   /                                                                                   
		;               |  /                                                                                    
		;               | /                                                                                     
		;               |/                                                                                      
		;               o InB1C1                                                                                
		;                                                                                                       
		
		;  SIGUIENTE LINEA-GEODESICA-3D  ( PGeoA PGeoB ) => ( PGeoB PGeoC )																																

		(SETQ Vn0    (CAL " NOR( oA1  , oA2 , oB1 )"))																; VECTOR UNI-NORMAL CUADRO-0   
		(SETQ AgG    (CAL " ANG( PGeoB , oB1 , PGeoA , PGeoB + Vn0 )"))								; Ag = ANG( Po , P1 , P2 , Pz )

		(SETQ Vn1    (CAL " NOR( oB1 , oB2  , oC1 )"))																; VECTOR UNI-NORMAL CUADRO-1   
		(SETQ PGeoR  (CAL " ROT( oB2 , PGeoB , PGeoB + Vn1 , AgG )"))									; P2 = ROT( P1 , Po , Pz , Ag )

		(SETQ InB1C1 (CAL " ILL( PGeoB , PGeoR , oB1 , oC1 )"))
		(SETQ InC1C2 (CAL " ILL( PGeoB , PGeoR , oC1 , oC2 )"))
		(SETQ InC2B2 (CAL " ILL( PGeoB , PGeoR , oC2 , oB2 )"))

		(COND
			((< (ABS (CAL " DIST(oB1 , oC1) - (DIST(oB1 , InB1C1) + DIST(InB1C1 , oC1)) ")) mUNI ) (SETQ PGeoC InB1C1   NLaIN NL-B1C1))
			((< (ABS (CAL " DIST(oC1 , oC2) - (DIST(oC1 , InC1C2) + DIST(InC1C2 , oC2)) ")) mUNI ) (SETQ PGeoC InC1C2   NLaIN NL-C1C2))
			((< (ABS (CAL " DIST(oC2 , oB2) - (DIST(oC2 , InC2B2) + DIST(InC2B2 , oB2)) ")) mUNI ) (SETQ PGeoC InC2B2   NLaIN NL-C2B2))

			(  T  (PROMPT " ------------------- NO CUMPLE CONDICION DIST ? ------------------")  (TERPRI))
		) ; con



		; LINEA GEODESICA en 3D y 2D PATRONES																																															

		"--------------------------------------------------------------------------------------------------------------------------------"
		(COMMAND "COLOR" 7 "LINEA" PGeoB  PGeoC "")	 																									; LINEA GEODESICA 3D 
		"--------------------------------------------------------------------------------------------------------------------------------"
																																													 
		(SETQ LADOS-NA2d3 (NTH (NTH 1 NA2) (NTH (NTH 0 NA2) LIS-COLUMNA-FILA-3DC-3D )))
		(SETQ LADOS-NA2d2 (NTH (NTH 1 NA2) (NTH (NTH 0 NA2) LIS-COLUMNA-FILA-3DC-2D )))

		(SETQ oA1d3 (NTH 0 (NTH 0 LADOS-NA2d3)))
		(SETQ oA2d3 (NTH 1 (NTH 0 LADOS-NA2d3)))
		(SETQ oB1d3 (NTH 1 (NTH 2 LADOS-NA2d3)))


		(COMMAND "SCP" "3P" oA1d3  oA2d3  oB1d3 )         																						; Plano CARA-3D 
			(SETQ  PGeoB2D (TRANS PGeoB 0 1))     (SETQ PGeoB2D (CAL " XYof( PGeoB2D )"))
			(SETQ  PGeoC2D (TRANS PGeoC 0 1))     (SETQ PGeoC2D (CAL " XYof( PGeoC2D )"))
		(COMMAND "SCP" "U") 

		(SETQ oA1d2 (NTH 0 (NTH 0 LADOS-NA2d2)))
		(SETQ oA2d2 (NTH 1 (NTH 0 LADOS-NA2d2)))
		(SETQ oB1d2 (NTH 1 (NTH 2 LADOS-NA2d2)))

		(COMMAND "SCP" "3P" oA1d2  oA2d2  oB1d2 )	         																					  ; Plano CARA-2D 
			(COMMAND "COLOR" 7 "LINEA" PGeoB2D  PGeoC2D "")																							; LINEA GEODESICA 2D 
		(COMMAND "SCP" "U") 



		;  CUADRO/B1-2-GEO-(NB1) y CUADRO/B2-SIGUIENTE-2-GEO-(NB2)																																		

		(SETQ NB1 (LIST (NTH 0 NA2) (NTH 1 NA2) NLaIN ))

		(COND 
			((= (NTH 2 NB1) 0 )  (SETQ NB2  (LIST    (NTH 0 NA2)      (- (NTH 1 NA2) 1 )  2 )) )
			((= (NTH 2 NB1) 1 )  (SETQ NB2  (LIST (+ (NTH 0 NA2) 1 )     (NTH 1 NA2)      3 )) )
			((= (NTH 2 NB1) 2 )  (SETQ NB2  (LIST    (NTH 0 NA2)      (+ (NTH 1 NA2) 1 )  0 )) )
			((= (NTH 2 NB1) 3 )  (SETQ NB2  (LIST (- (NTH 0 NA2) 1 )     (NTH 1 NA2)      1 )) )

			(  T  (PROMPT " ------------------- NO CUMPLE CONDICION NB2 ? ------------------")  (TERPRI))
		) ; con

		(IF (= (NTH 0 NB2) NLados )  (SETQ NB2 (LIST       0        (NTH 1 NB2) (NTH 2 NB2))))
		(IF (= (NTH 0 NB2)   -1    )  (SETQ NB2 (LIST (- NLados 1 ) (NTH 1 NB2) (NTH 2 NB2))))




		; CAMBIA VALORES para SIGUENTE Repeat																																															

		(SETQ PGeoA  PGeoB  )
		(SETQ PGeoB  PGeoC  )

		(SETQ NA1  NB1 )
		(SETQ NA2  NB2 )

	) ;  repe


	)) ; pro if  PINTA-LINEA-GEODESICA 


	;===================================================================================================================================
	;	() PARANDO																																																												
	(SETVAR "blipmode" 1)  (SETVAR "cmdecho"  1)

	(PROMPT " ============================================================================") (TERPRI)
	(PROMPT " >>>> FINAL >>>>>>>>>>>>>>>>>>> ESCULTURA-NUDO-02 >>>>>>>>>>>>>>>>>>>>>>>>>>>") (TERPRI)
	(PROMPT " ============================================================================") (TERPRI)

) ; cierre DEFUN    ESCULTURA-NUDO-02 

"####################################################################################################################################"
;-------------------------------------------------------------------------------------------------------------------------------------







