



;=====================================================================================================================================
;																																																																			
;	( ESCULTURA-NUDO-ELICOIDAL-05 )                                                               										07/07/2008				
;																																																																			
;=====================================================================================================================================
;																																																																			
;		SUPERFICIE DESARROLLABLE (3DC-3D) (3DC-2D) de (SPLINE-CAMINO) y Radios a lo Largo del CAMINO (SPLINE-PERFIL)+(SPLINE-EJE)					
;																																																																			
;		con LINEAS de REFERENCIA para AJUSTE en MONTAGE 									CALCULA-VOLUMEN																									
;																																																																			
;=====================================================================================================================================




;-------------------------------------------------------------------------------------------------------------------------------------
;	(01)	(PUNTOS-DIVIDE) = PUNTEA SPLINE a NDIVISIONES ( N-ELE ) + ( NDIDI ) => ( LIS-PUNTOS )																				
;-------------------------------------------------------------------------------------------------------------------------------------

(DEFUN PUNTOS-DIVIDE (/  )

	(SETQ LIS-PUNTOS  nil)

	(SETQ Elen (MEMBER (ASSOC 10 (ENTGET N-ELE)) (ENTGET N-ELE))								  	; lista a partir del elemento (incluido)		
		    P-1    (CDR (NTH      0              Elen))												      ; primer elemento														
		    P-Uo    (CDR (NTH (- (LENGTH Elen) 1) Elen)))												      ; ultimo elemento														

	(COMMAND  "COLOR" 1 "PUNTO"  P-1)																		          ; PINTA Primer Punto (en Base de Datos)			
 	(SETQ  N-1P (ENTLAST))																						              ; Nombre ultima entidad principal = 1punto	
	(COMMAND "COLOR" 7  "DIVIDE" N-ELE  NDIDI )																    ; PINTA Punto Divide (en Base de Datos)			
	(COMMAND "COLOR" 5  "PUNTO"  P-Uo          )															      ; PINTA Ultimo Punto (en Base de Datos)			

	;	PUNTOS SECCION X (PX1-PXn) =>  LIS-PUNTOS																																													

	(SETQ N-P1         nil
		   	N-P2         nil
		   	N-P2         N-1P
		   	LIS-PUNTOS   nil
		   	LIS-PUNTOS  (LIST (CDR (ASSOC 10 (ENTGET N-1P))))											   ; LIS-PUNTOS => 1 punto
		   	WW           T )

	(WHILE WW
	  (SETQ N-P1 (ENTNEXT N-1P))																			         		  ; nombre entidad siguiente
				
		(IF (= N-P1 nil)	(SETQ WW nil)
			(PROGN
				(SETQ LIS-PUNTOS (CONS (CDR (ASSOC 10 (ENTGET N-P1))) LIS-PUNTOS))				; LIS-PUNTOS => Resto PUNTOS con ULTIMO
				(SETQ  N-1P N-P1 )
				(ENTDEL N-P1)																		; BORRA PUNTO N-P1 
			) ; pro
		) ; if 
	) ; whi
	(SETQ LIS-PUNTOS (REVERSE LIS-PUNTOS))
	(ENTDEL N-P2)																					; BORRA PUNTO N-P2 

) ;	(01)  DEFUN   PUNTOS-DIVIDE 

;-------------------------------------------------------------------------------------------------------------------------------------

;-------------------------------------------------------------------------------------------------------------------------------------
;	(02) CALCULOS  PERFIL RADIOS ( RADIO ) CIRCULOS a TANGENTES por SPLINE	SPLINE-REF ----- DIVIDIR NDiv*3 => LIS-Pun-REF => PP1 PP2	
;																		                                      SPLINE-EJE ----- DIVIDIR NDiv   => LIS-Pun-EJE => PPb	    
;-------------------------------------------------------------------------------------------------------------------------------------

(DEFUN LISTA-RADIOS-PERFIL (/  )

  (SETQ LIS-RADI nil)
	(SETQ NEje -1)
	(SETQ NRef -1)

	(REPEAT (LENGTH LIS-Pun-EJE)
		(SETQ NEje (+ NEje 1))

		(IF (NOT (= (REM NEje 2) 0))
			(PROGN
				(SETQ PPb (NTH NEje LIS-Pun-EJE))  (SETQ XXb (CAR PPb) YYb (CADR PPb))
				(SETQ WW T)
				(WHILE WW
					(SETQ NRef (+ NRef 1))
					(SETQ PP1 (NTH (+ NRef 0) LIS-Pun-REF))  (SETQ XX1 (CAR PP1) YY1 (CADR PP1))
					(SETQ PP2 (NTH (+ NRef 1) LIS-Pun-REF))  (SETQ XX2 (CAR PP2) YY2 (CADR PP2))

					(IF (AND (<= XX1 XXb) (< XXb XX2))
						(PROGN																																							
							(SETQ R-REF (/ (+ (* (- YY1 YYb) (- XX2 XXb)) (* (- YY2 YYb) (- XXb XX1))) (- XX2 XX1)))
							(SETQ LIS-RADI (CONS R-REF LIS-RADI))											; (LENGTH LIS-RADI)
							(SETQ WW nil)
							(COMMAND "COLOR" 8 "LINEA" PPb (LIST XXb (+ YYb R-REF)) "")
						) ;pro
					) ;if
					(IF (>= NRef (- (LENGTH LIS-Pun-REF) 2)) (SETQ WW nil))
				) ; Whi NRef
			) ;pro
		) ; if
	) ; repe NEje
	(SETQ LIS-RADI (REVERSE LIS-RADI))																		; (NTH 0 LIS-RADI)  (LENGTH LIS-RADI)

) ;	(02)  DEFUN   LISTA-RADIOS-PERFIL 

;-------------------------------------------------------------------------------------------------------------------------------------


"####################################################################################################################################"
;-------------------------------------------------------------------------------------------------------------------------------------
; *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA 	
;-------------------------------------------------------------------------------------------------------------------------------------
"####################################################################################################################################"

(DEFUN C:ESCULTURA-NUDO-ELICOIDAL-05 ( / )

	;===================================================================================================================================
	;  (00) ARRANCANDO																																																									

 	(SETVAR "blipmode" 0) (SETVAR "cmdecho" 0)  (GRAPHSCR)  (COMMAND "-REFENT" "DES")  (COMMAND "SCP" "U")  (COMMAND "ORTO" "DES")

	(PROMPT " ============================================================================")  (TERPRI)
	(PROMPT " >>>> INICIO >>>>>>>>>>>>> ESCULTURA-NUDO-ELICOIDAL-05 >>>>>>>>>>>>>>>>>>>>>>")  (TERPRI)
	(PROMPT " ============================================================================")  (TERPRI) (TERPRI)

	(IF (= CAL nil)(COMMAND "ARX" "L" "GEOMCAL.ARX"))		; CARGA CALCULADORA 

	(SETQ mUNI 1.0e-006 )																; MARGEN EQUAL VEC-UNITARIOS (1.01e-008)LIMITE-MAR-INTER-RECT-01.lsp 

	;===================================================================================================================================
	;	(01) FIJAR VARIABLES EN EL PROGRAMA																																																

	"##################################################################################################################################"
	"##################################################################################################################################"

	      (SETQ NVUEL   10 )																	; N de VUELTAS del ELICOIDE 	(70 Escultura) 

	      (SETQ NCaVu   20 )																	; N de CARAS por VUELTA 			(20 Escultura) 
	      (SETQ NPuCa    4 )																	; N de PUNTOS por CARA 			( 4 Escultura) 

	"##################################################################################################################################"
	"##################################################################################################################################"

				(SETQ NPuVu (* NCaVu  NPuCa ))										; N de PUNTOS por VUELTA 	
	      (SETQ NDiv  (* NVUEL  NPuVu ))										; N(DIVIDE)  SPLINE CAMINO 	NDiv * 5 < 32767 

	;===================================================================================================================================
	;	(02) TOMA de DATOS en PANTALLA            																																												

 	(SETQ N-CAMI (CAR (ENTSEL "------------------------ MARCA >>>>>>>>>>>>>>>>>  SPLINE - CAMINO ? <<<<<<<<<" ))) (TERPRI)
 	(SETQ N-PERF (CAR (ENTSEL "------------------------ MARCA >>>>>>>>>>>>>>>>>  SPLINE - PERFIL ? <<<<<<<<<" ))) (TERPRI)
 	(SETQ N-BASE (CAR (ENTSEL "------------------------ MARCA >>>>>>>>>>>>>>>>>  SPLINE - EJE    ? <<<<<<<<<" ))) (TERPRI) (TERPRI)

	(PROMPT                   " ****************************************************************************")    (TERPRI)
	(PROMPT                   " ************************** COMENTARIOS y ERRORES ***************************")    (TERPRI) (TERPRI)


	;===================================================================================================================================
	;	(03)	LISTAS PUNTOS ( SPLI-CAMINO   SPLI-PERFIL   SPLI-BASE ) 																																		

	(SETQ  N-ELE N-CAMI   NDIDI    NDiv   )  (PUNTOS-DIVIDE)  (SETQ LIS-Pun-CAMI  LIS-PUNTOS )					; (LENGTH LIS-Pun-CAMI) 
	(SETQ  N-ELE N-PERF   NDIDI (* NDiv 5))  (PUNTOS-DIVIDE)  (SETQ LIS-Pun-REF   LIS-PUNTOS )					; (LENGTH LIS-Pun-REF)  
	(SETQ  N-ELE N-BASE   NDIDI (* NDiv 2))  (PUNTOS-DIVIDE)  (SETQ LIS-Pun-EJE   LIS-PUNTOS )					; (LENGTH LIS-Pun-EJE)  

	;===================================================================================================================================
	;	(04) RADIOS para PUNTOS ELICOIDE  ( LIS-Pun-REF )+ ( LIS-Pun-EJE ) => ( LIS-RADI )  																							

	(LISTA-RADIOS-PERFIL)		  

	;===================================================================================================================================
	; (05) PUNTOS ELICOIDE																																																							

	(SETQ LIS-PUN-ELICO  nil )
	(SETQ LIS-PUN-MEDIO  nil )

	(SETQ ANGuni (/ (* 2 PI) NPuVu ))
	(SETQ ANGr (- ANGuni))
	(SETQ NE -1)
	(REPEAT (LENGTH LIS-RADI)
		(SETQ NE (+ NE 1))
		(SETQ ANGr (+ ANGr ANGuni ))

		(SETQ P1  (NTH    NE    LIS-Pun-CAMI ))
		(SETQ P2  (NTH (+ NE 1) LIS-Pun-CAMI ))
		(SETQ P12 (CAL " PLT( P1 , P2 , 0.5 )"))
		(COMMAND "COLOR" 1  "PUNTO" P12 )																						; PUNTO EJE ELICOIDE 

		(SETQ RAD  (NTH NE LIS-RADI ))
		(SETQ P12V (CAL " P12 + [10,0,0] "))

		(COMMAND "SCP" "EZ" P12 P2 )
			(SETQ P12Vp (TRANS P12V 0 1))   (SETQ P12VpZ (CAL " XYof( P12Vp )"))
			(SETQ AgV (CAL " ANG( P12VpZ )"))

		(COMMAND "SCP" "Z"  AgV )
			(SETQ PuElp (LIST (* RAD (SIN ANGr)) (* RAD (COS ANGr)) 0.0 ))
			(SETQ PuEl  (TRANS PuElp 1 0 ))
   	(COMMAND "SCP" "U") 

		(SETQ LIS-PUN-ELICO (CONS PuEl  LIS-PUN-ELICO ))
		(SETQ LIS-PUN-MEDIO (CONS P12   LIS-PUN-MEDIO ))
			
		;(COMMAND "COLOR" 2  "LINEA" P12  PuEl "")																; LINEA RADIO ELICOIDE 

	) ; repe  NE 

	(SETQ LIS-PUN-ELICO (REVERSE LIS-PUN-ELICO ))
	(SETQ LIS-PUN-MEDIO (REVERSE LIS-PUN-MEDIO ))


	;===================================================================================================================================
	; (06) 3DC TORNILLO ELICOIDE																																																				

	(SETQ  3DC-ELICOIDE 'NO )
	(IF (= 3DC-ELICOIDE 'SI ) (PROGN
	"--------------------------------"

	(SETQ NL -1)
	(REPEAT (- (LENGTH LIS-PUN-ELICO) 1 )
		(SETQ NL (+ NL 1))

		(SETQ PE1  (NTH    NL    LIS-PUN-ELICO ))
		(SETQ PE2  (NTH (+ NL 1) LIS-PUN-ELICO ))
		(SETQ PM1  (NTH    NL    LIS-PUN-MEDIO ))
		(SETQ PM2  (NTH (+ NL 1) LIS-PUN-MEDIO ))

		(COMMAND "COLOR" 2  "3DCARA" PE1 PE2  PM2 PM1 "")																				; 3DC TORNILLO ELICOIDE 
	) ; repe  NL 

	"--------------------------------"
	)) ; if pro 3DC-ELICOIDE 				 


	;===================================================================================================================================
	; (08) SUPERFICIE DESARROLLABLE																																																			

	(SETQ  SUPERFI-DESA 'SI )
	(IF (= SUPERFI-DESA 'SI ) (PROGN
	"--------------------------------"

	(SETQ LIS-PsPLA nil )

	;	PLANOS TANGENTES a PUNTOS ELICOIDE																																																	

	(SETQ NA (- NPuCa ))
	(REPEAT (FIX (/ (- (LENGTH LIS-PUN-ELICO ) NPuVu ) NPuCa ))				; MENOS ULTIMA VUELTA  
		(SETQ NA (+ NA  NPuCa ))																				; CADA  NPuCa  PUNTOS 

		(SETQ PA1  (NTH    NA    LIS-PUN-ELICO ))
		(SETQ PA2  (NTH (+ NA 1) LIS-PUN-ELICO ))

		(SETQ PsPLA nil )
		(SETQ NB (FIX (- (+ NA  NPuVu ) (/ NPuVu 4 ))))								; NA + 1VUELTA - 1/4 VUEL => + 1/2 VUEL 
		(SETQ NW 0 )
		(SETQ WW T )
		(WHILE WW																													;(REPEAT (FIX (/ NPuVu 2 ))
			(SETQ NB (+ NB 1))
			(SETQ NW (+ NW 1))

			(IF (<= (+ NB 2) (- (LENGTH LIS-PUN-ELICO) 1 ))
				(PROGN
					(IF (<= NW (FIX (/ NPuVu 2 )))
						(PROGN
							(SETQ PB1  (NTH (+ NB 0) LIS-PUN-ELICO ))
							(SETQ PB2  (NTH (+ NB 1) LIS-PUN-ELICO ))
							(SETQ PB3  (NTH (+ NB 2) LIS-PUN-ELICO ))

							(SETQ Vn1 (CAL " 10 * NOR( PA1 , PA2 , PB1 )"))
							(SETQ Vn2 (CAL " 10 * NOR( PA1 , PA2 , PB2 )"))
							(SETQ Vn3 (CAL " 10 * NOR( PA1 , PA2 , PB3 )"))

							(SETQ Ag12 (CAL " ANG( PA1 , PA1 + Vn1 , PA1 + Vn2 , PA2 )"))
							(SETQ Ag23 (CAL " ANG( PA1 , PA1 + Vn2 , PA1 + Vn3 , PA2 )"))

							(IF (OR (AND (< Ag12 180) (> Ag23 180)) (AND (> Ag12 180) (< Ag23 180))  )
								(PROGN
									(SETQ WW nil )
									(SETQ PsPLA (LIST PA1 PA2 PB1 PB2 ))
								) ; pro 
							) ; if 
						) ; pro
						(PROGN (SETQ WW nil ))
					) ; if
				) ; pro
				(PROGN (SETQ WW nil ) (PROMPT " >>>>>>>>>  FINAL TANGENTES  NA = ") (PRIN1 NA) (PROMPT "  NB = ") (PRIN1 NB) (TERPRI) )
			) ; if
		) ; WW  NB 

		(IF (= PsPLA  nil)
			(PROGN  (PROMPT " >>>>>>>>>>>>>>>>  PsPLA = nil   NA = ") (PRIN1 NA) (PROMPT "   NB = ") (PRIN1 NB) (TERPRI) )
			(PROGN  (SETQ LIS-PsPLA (CONS PsPLA  LIS-PsPLA ))
			        ;(COMMAND "COLOR" 8  "LINEA" (NTH 0 PsPLA ) (NTH 2 PsPLA ) "")							; LINEA PLANO TANGENTE 
			) ; pro
		) ; if 

	) ; repe  NA 

	(SETQ LIS-PsPLA (REVERSE LIS-PsPLA ))						; (LENGTH LIS-PsPLA ) 1264 


	"--------------------------------"
	)) ; if pro SUPERFI-DESA 				 


	;===================================================================================================================================
	;	(09) INTERSECCION de PLANOS TANGENTES al ELICOIDE																																									

	(SETQ LIS-PsINTER nil )

	(SETQ NI -1 )
	(REPEAT (- (LENGTH LIS-PsPLA) 1 )
		(SETQ NI (+ NI 1 ))

		(SETQ PsPla1  (NTH    NI    LIS-PsPLA ))
		(SETQ PsPla2  (NTH (+ NI 1) LIS-PsPLA ))

		(SETQ A1 (NTH 0 PsPla1 ))  (SETQ C1 (NTH 0 PsPla2 ))
		(SETQ A2 (NTH 1 PsPla1 ))  (SETQ C2 (NTH 1 PsPla2 ))
		(SETQ B1 (NTH 2 PsPla1 ))  (SETQ D1 (NTH 2 PsPla2 ))
		(SETQ B2 (NTH 3 PsPla1 ))  (SETQ D2 (NTH 3 PsPla2 ))

		(SETQ VnB (CAL " NOR( A1 , A2 , B1 )"))
		(SETQ VnD (CAL " NOR( C1 , C2 , D1 )"))

		(SETQ B2p (CAL " ILP( B2 , B2 + VnB ,  A1 , A2 , B1 )"))
		(SETQ D2p (CAL " ILP( D2 , D2 + VnD ,  C1 , C2 , D1 )"))

		(SETQ InA (CAL " ILP( A1 , A2  ,  C1 , C2 , D1 )"))
		(SETQ InB (CAL " ILP( B1 , B2p ,  C1 , C2 , D1 )"))

		(IF (AND (= InA nil) (= InB nil))
			(PROGN  (PROMPT " >>>>>>>>  (InA = nil) y (InB = nil)   NI = ") (PRIN1 NI) (TERPRI))
			(PROGN (SETQ LIS-PsINTER (CONS (LIST InA InB )  LIS-PsINTER )))
		) ; if

	) ; repe  NI 

	(SETQ LIS-PsINTER (REVERSE LIS-PsINTER ))						; (LENGTH LIS-PsINTER )


	;===================================================================================================================================
	;	(10) 3DCARAS SUPERFICIE DESARROLLABLE																																															

	(SETQ LIS-3DCara-3D nil )
	(SETQ LIS-3DCara-2D nil )
	(SETQ KK1 (LIST 200 0.0 0.0 ))
	(SETQ KK2 (LIST 210 0.0 0.0 ))

	(SETQ NC -1 )
	(REPEAT (- (LENGTH LIS-PsINTER) 1)
		(SETQ NC (+ NC 1 ))
		(SETQ PA10  (NTH 0 (NTH    NC    LIS-PsINTER )))
		(SETQ PA20  (NTH 1 (NTH    NC    LIS-PsINTER )))
		(SETQ PB10  (NTH 0 (NTH (+ NC 1) LIS-PsINTER )))
		(SETQ PB20  (NTH 1 (NTH (+ NC 1) LIS-PsINTER )))

		"----------------------------------------------------------------------------------------------------------------------------"
		(COMMAND "COLOR" 2   "3DCARA" PA10 PA20 PB20 PB10 "")																	; 3DCARA-3D 
		"----------------------------------------------------------------------------------------------------------------------------"
		(SETQ LIS-3DCara-3D (CONS (LIST PA10 PA20 PB20 PB10 )  LIS-3DCara-3D ))

		(COMMAND "SCP" "3P" PA10 PA20 PB10 )					; PLANO 3DC 3D 
			(SETQ PA10p (LIST 0.0 0.0 0.0))
			(SETQ PA20p (TRANS PA20 0 1 ))   (SETQ PA20p (CAL " XYof( PA20p )"))
			(SETQ PB10p (TRANS PB10 0 1 ))   (SETQ PB10p (CAL " XYof( PB10p )"))
			(SETQ PB20p (TRANS PB20 0 1 ))   (SETQ PB20p (CAL " XYof( PB20p )"))
			"----------------------------------------------------------------------------------------------------------------------------"
			(COMMAND "COLOR" 8  "TEXTO"  (LIST 0.4 0.2)  0.6  0  (STRCAT "<" (ITOA NC ) ))			; TEXTO-3D 
			"----------------------------------------------------------------------------------------------------------------------------"
   	(COMMAND "SCP" "U")

		(COMMAND "SCP" "3P" KK1 KK2 "" )					; PLANO PATRONES 2D 

			"----------------------------------------------------------------------------------------------------------------------------"
			(COMMAND "COLOR" 4   "3DCARA" PA10p PA20p PB20p PB10p "")														; 3DCARA-2D 
			"----------------------------------------------------------------------------------------------------------------------------"
			(SETQ PA10pU (TRANS PA10p 1 0 ))   (SETQ PA10pU (CAL " XYof( PA10pU )"))
			(SETQ PA20pU (TRANS PA20p 1 0 ))   (SETQ PA20pU (CAL " XYof( PA20pU )"))
			(SETQ PB10pU (TRANS PB10p 1 0 ))   (SETQ PB10pU (CAL " XYof( PB10pU )"))
			(SETQ PB20pU (TRANS PB20p 1 0 ))   (SETQ PB20pU (CAL " XYof( PB20pU )"))

			(SETQ LIS-3DCara-2D (CONS (LIST PA10pU PA20pU PB20pU PB10pU )  LIS-3DCara-2D ))

			(SETQ KK1 PB10pU)
			(SETQ KK2 PB20pU)
			"----------------------------------------------------------------------------------------------------------------------------"
			(COMMAND "COLOR" 8  "TEXTO"  (LIST 0.4 0.2)  0.6  0  (STRCAT "<" (ITOA NC ) ))			; TEXTO-2D 
			"----------------------------------------------------------------------------------------------------------------------------"
   	(COMMAND "SCP" "U")
	) ; repe  NC 

	(SETQ LIS-3DCara-3D (REVERSE LIS-3DCara-3D ))						; (LENGTH LIS-3DCara-3D )
	(SETQ LIS-3DCara-2D (REVERSE LIS-3DCara-2D ))						; (LENGTH LIS-3DCara-2D )


	;===================================================================================================================================
	;	(11) LINEAS de REFERENCIA para AJUSTE en MONTAGE																																									
	;===================================================================================================================================


	(SETQ  LINEAS-REFERENCIA 'SI )
	(IF (= LINEAS-REFERENCIA 'SI ) (PROGN


	;  1 3DCARA => 1LINE-REF  =  PA41 - PA32																																													

	(SETQ Ca3dA (NTH 0  LIS-3DCara-3D ))  (SETQ PA1d3  (NTH 0 Ca3dA ))          
																				(SETQ PA2d3  (NTH 1 Ca3dA ))          
																				(SETQ PA3d3  (NTH 2 Ca3dA ))          
																				(SETQ PA4d3  (NTH 3 Ca3dA ))          
																				(SETQ PA41d3 (CAL " PLT( PA4d3 , PA1d3 , 0.5 )"))        
																				(SETQ PA23d3 (CAL " PLT( PA2d3 , PA3d3 , 0.5 )"))

	(SETQ Ca2dA (NTH 0  LIS-3DCara-2D ))  (SETQ PA1d2  (NTH 0 Ca2dA ))          
																				(SETQ PA2d2  (NTH 1 Ca2dA ))          
																				(SETQ PA3d2  (NTH 2 Ca2dA ))          
																				(SETQ PA4d2  (NTH 3 Ca2dA ))          
																				(SETQ PA41d2 (CAL " PLT( PA4d2 , PA1d2 , 0.5 )"))        
																				(SETQ PA23d2 (CAL " PLT( PA2d2 , PA3d2 , 0.5 )"))        

	(COMMAND "COLOR" 7 "LINEA" PA41d3 PA23d3 "")				; 1 LINEA-REF-3D 

	(COMMAND "SCP" "3P" PA41d3  PA23d3  PA4d3 )					; PLANO 3DC-A 3D 
		(SETQ PA23d3p (TRANS PA23d3 0 1 ))   (SETQ PA23d3p (CAL " Xof( PA23d3p )"))
		"-------------------------------------------------------------------------------------------------------------------"
		(COMMAND "COLOR" 7  "TEXTO" "II" (LIST 0.4 0.0 )  1.0  0  (STRCAT "<" (ITOA 0 )))							; TEXTO-3D LINEA-REF
		(COMMAND "COLOR" 7  "TEXTO" "ID" (LIST (- (CAR PA23d3p) 0.4) (CADR PA23d3p))  1.0  0  (STRCAT (ITOA 1 ) ">" ))
		"-------------------------------------------------------------------------------------------------------------------"
  (COMMAND "SCP" "U")

	(COMMAND "COLOR" 7 "LINEA" PA41d2 PA23d2 "")				; 1 LINEA-REF-2D 

	(COMMAND "SCP" "3P" PA41d2  PA23d2  PA4d2 )					; PLANO 3DC-A 2D 
		(SETQ PA23d2p (TRANS PA23d2 0 1 ))   (SETQ PA23d2p (CAL " Xof( PA23d2p )"))
		"-------------------------------------------------------------------------------------------------------------------"
		(COMMAND "COLOR" 7  "TEXTO" "II" (LIST 0.4 0.0)  1.0  0  (STRCAT "<" (ITOA 0 )))							; TEXTO-2D LINEA-REF
		(COMMAND "COLOR" 7  "TEXTO" "ID" (LIST (- (CAR PA23d2p) 0.4) (CADR PA23d2p))  1.0  0  (STRCAT (ITOA 1 ) ">" ))
		"-------------------------------------------------------------------------------------------------------------------"
  (COMMAND "SCP" "U")


	;                            PB32                                       |                                                       
	;                   PB3 o----o--------o PB2                             |   1LINE-REF  =>  PA41 - PA32                         
	;                       |    |        |                                 |                                                       
	;                       |    |  ----  |                       | -2      |   (REPEAT (- (/ (LENGTH LIS-3DCara-3D ) NCaVu ) 1 )  
	;                       |    |  3dcB  |    N3DC = n + NCaVu | ...     |                                                       
	;                       |    |  ----  |                       | +2      |     PB41o = el MAS CERCANO a  PA32                    
	;                       |    |        |                                 |                                                       
	;                   PB4 o----o--------o PB1                             |     nLINE-REF  =>  PB41o - PB32                      
	;                            PB41o                                      |                                                       
	;                            PA32                                       |     PA32 = PB32                                       
	;                   PA3 o----o--------o PA2                             |                                                       
	;                       |    |        |                                 |   ) ; repe                                            
	;                       |    |  ----  |                                 |                                                       
	;                       |    |  3dcA  |    N3DC = n                    |                                                       
	;                       |    |  ----  |                                 |                                                       
	;                       |    |        |                                 |                                                       
	;                   PA4 o----o--------o PA1                             |                                                       
	;                            PA41o                                      |                                                       

	;	PUNTO MAS CERCANO a  PA23d3  en LINEA ( PB4d3 - PB1d3 ) =>  PB41d3o   NKK   N3dc2																								

	(SETQ N3dc1 0 )
	(SETQ NTx   0 )
	(REPEAT (/ (LENGTH LIS-3DCara-3D )  NCaVu )														; (LIST PA10 PA20 PB20 PB10 ) 
		(SETQ NTx (+ NTx 1 ))

		(SETQ NRepe 100 )
		(SETQ DISr1  100 )
		(SETQ NBB   -5  )
		(REPEAT  9
			(SETQ NBB (+ NBB 1))		; -4 ... +4 
		  (SETQ Ca3dBB (NTH (+ N3dc1  NCaVu  NBB ) LIS-3DCara-3D ))  (SETQ PB1d3BB  (NTH 0 Ca3dBB ))
		  																															(SETQ PB2d3BB  (NTH 1 Ca3dBB ))
		  																															(SETQ PB3d3BB  (NTH 2 Ca3dBB ))
		  																															(SETQ PB4d3BB  (NTH 3 Ca3dBB ))
																																		(SETQ PB41BB (CAL " PLT( PB4d3BB , PB1d3BB , 0.5 )"))
																																		(SETQ PB23BB (CAL " PLT( PB2d3BB , PB3d3BB , 0.5 )"))
																																		(SETQ PBMMM  (CAL " PLT( PB41BB  , PB23BB  , 0.1 )"))

			(COMMAND "COLOR" 6   "LINEA" PB1d3BB  PBMMM  PB4d3BB "") 			 ; LINEA de 3DCs que COMPARA  PUNTO MAS CERCANO 

			(SETQ NK 0 )
			(REPEAT (- NRepe 1 )
				(SETQ NK (+ NK (/ 1.0 NRepe)))														; 0.01...0.99 

				(SETQ PB41d3x (CAL " PLT( PB4d3BB , PB1d3BB , NK )"))
				(SETQ DISr2   (DISTANCE PA23d3  PB41d3x ))

				(IF (< DISr2  DISr1) (PROGN (SETQ DISr1  DISr2) (SETQ PB41d3o  PB41d3x) (SETQ NKK  NK) (SETQ N3dc2 (+ N3dc1 NCaVu NBB))))

			) ; repe  NK 
		) ; repe  NBB 


	;  RESTO 3DCARA => nLINEA-REF  =  PB41o - PB32																																											

		(SETQ Ca3dB (NTH N3dc2  LIS-3DCara-3D ))   (SETQ PB1d3  (NTH 0 Ca3dB ))
																								(SETQ PB2d3  (NTH 1 Ca3dB ))
																								(SETQ PB3d3  (NTH 2 Ca3dB ))
																								(SETQ PB4d3  (NTH 3 Ca3dB ))
																								(SETQ PB23d3 (CAL " PLT( PB2d3 , PB3d3 , 0.5 )"))

		(SETQ Ca2dB (NTH N3dc2  LIS-3DCara-2D ))   (SETQ PB1d2  (NTH 0 Ca2dB ))
																								(SETQ PB2d2  (NTH 1 Ca2dB ))
																								(SETQ PB3d2  (NTH 2 Ca2dB ))
																								(SETQ PB4d2  (NTH 3 Ca2dB ))
																								(SETQ PB23d2 (CAL " PLT( PB2d2 , PB3d2 , 0.5 )"))

		(COMMAND "COLOR" 7 "LINEA" PB41d3o  PB23d3 "")				; n LINEA-REF-3D 

		(COMMAND "SCP" "3P" PB41d3o  PB23d3  PB4d3 )					; PLANO 3DC-B 3D 
			(SETQ PB23d3p (TRANS PB23d3 0 1 ))   (SETQ PB23d3p (CAL " Xof( PB23d3p )"))
			"-------------------------------------------------------------------------------------------------------------------"
			(COMMAND "COLOR" 7  "TEXTO" "II" (LIST 0.4 0.0 )  1.0  0  (STRCAT "<" (ITOA NTx )))							; TEXTO-3D LINEA-REF
			(COMMAND "COLOR" 7  "TEXTO" "ID" (LIST (- (CAR PB23d3p) 0.4) (CADR PB23d3p))  1.0  0  (STRCAT (ITOA (+ NTx 1)) ">" ))
			"-------------------------------------------------------------------------------------------------------------------"
   	(COMMAND "SCP" "U")

		(SETQ PB41d2o (CAL " PLT( PB4d2 , PB1d2 , NKK )"))

		(COMMAND "COLOR" 7 "LINEA" PB41d2o PB23d2 "")					; n LINEA-REF-2D 

		(COMMAND "SCP" "3P" PB41d2o  PB23d2  PB4d2 )					; PLANO 3DC-B 2D 
			(SETQ PB23d2p (TRANS PB23d2 0 1 ))   (SETQ PB23d2p (CAL " Xof( PB23d2p )"))
			"-------------------------------------------------------------------------------------------------------------------"
			(COMMAND "COLOR" 7  "TEXTO" "II" (LIST 0.4 0.0)  1.0  0  (STRCAT "<" (ITOA NTx )))							; TEXTO-2D LINEA-REF
			(COMMAND "COLOR" 7  "TEXTO" "ID" (LIST (- (CAR PB23d2p) 0.4) (CADR PB23d2p))  1.0  0  (STRCAT (ITOA (+ NTx 1)) ">" ))
			"-------------------------------------------------------------------------------------------------------------------"
   	(COMMAND "SCP" "U")

		(SETQ PA23d3  PB23d3 )
		(SETQ N3dc1  N3dc2 )

	) ; repe  NTx 


	)) ; pro if  LINEAS-REFERENCIA 


	;===================================================================================================================================
	;	(12) CALCULA VOLUMEN CUERPO																																																				

	(SETQ  CALCULA-VOLUMEN 'SI )
	(IF (= CALCULA-VOLUMEN 'SI ) (PROGN

		(SETQ VOLUMEN-TOTAL 0 )
		(SETQ LONGITUD-EJE  0 )
		(SETQ SUMA-RADIOS   0 )
		(SETQ RADIO-MEDIO   0 )

		(SETQ NSec -1)
		(REPEAT (- NDiv 1)												; ((A1 A2 A3 A4..) (B1 B2 B3 B4..) ... )  = (LENGTH Lis-VER-TODOu ) 
			(SETQ NSec (+ NSec 1))

			(SETQ Pc1  (NTH (+ NSec 0)  LIS-Pun-CAMI ))
			(SETQ Pc2  (NTH (+ NSec 1)  LIS-Pun-CAMI ))
			(SETQ Pc3  (NTH (+ NSec 2)  LIS-Pun-CAMI ))

			(SETQ Pc12 (CAL " PLT( Pc1 , Pc2 , 0.5 )"))
			(SETQ Pc23 (CAL " PLT( Pc2 , Pc3 , 0.5 )"))

			(SETQ RADI-A (NTH (+ NSec 0)  LIS-RADI))
			(SETQ RADI-B (NTH (+ NSec 1)  LIS-RADI))

			(SETQ VOLUMEN-TOTAL (+ VOLUMEN-TOTAL (* (/ (+ (* PI RADI-A RADI-A ) (* PI RADI-B RADI-B )) 2.0 ) (DISTANCE Pc12 Pc23 ))))
			(SETQ LONGITUD-EJE  (+ LONGITUD-EJE (DISTANCE Pc12 Pc23 )))
			(IF (= NSec 0 )  (SETQ SUMA-RADIOS (+ SUMA-RADIOS  RADI-A )))
			                  (SETQ SUMA-RADIOS (+ SUMA-RADIOS  RADI-B ))
		) ; repe   NSec 

		(SETQ RADIO-MEDIO     (/ SUMA-RADIOS (- NDiv 1)))
		(SETQ VOLUMEN-COMPROL (FIX (/ (* (* PI RADIO-MEDIO RADIO-MEDIO ) LONGITUD-EJE ) 1000)))

		(PROMPT " >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  VOLUMEN-TOTAL = ") (PRIN1 (FIX (/ VOLUMEN-TOTAL 1000))) (PROMPT " Litros") (TERPRI)

		(COMMAND "COLOR" 7  "TEXTO"  (LIST -30 -70) 3.0 0 (STRCAT "VOLUMEN-TOTAL = " (ITOA (FIX (/ VOLUMEN-TOTAL 1000)) ) " Litros" ))


	)) ; pro if  CALCULA-VOLUMEN 




	;=====================================================================================================================================
	;	(13) PARANDO																																																												
	(SETVAR "blipmode" 1)  (SETVAR "cmdecho"  1)

	(PROMPT " ============================================================================") (TERPRI)
	(PROMPT " >>>> FINAL >>>>>>>>>>>>>> ESCULTURA-NUDO-ELICOIDAL-05 >>>>>>>>>>>>>>>>>>>>>>") (TERPRI)
	(PROMPT " ============================================================================") (TERPRI)

) ; cierre DEFUN    ESCULTURA-NUDO-ELICOIDAL-05 

"####################################################################################################################################"
;-------------------------------------------------------------------------------------------------------------------------------------



