

"#########################################################################################################################################"
;==========================================================================================================================================
;																																														 
;	 ( CAJAS-CARAS-PLANAS-entre-SPLINES-EMBUDOS-06 )					                     						16/10/2009	=>  04/12/2012	 	    
;																																														 
;					SECCION BASE INDEPENDIENTE (POLILINEA) y SPLINE COLUMNA-VERTEBRAL  (POR INTERSECCION VELTORIAL de 3 CARAS)						 
;																																														 
;  DATOS :     SPLINES PERFILES PLANOS-CARAS => SPLINE COLUMNA-VERTEBRAL DEFINE SECCIONES PLANOS DE CORTE y PUNTOS-BASE GIRADOS            
;==========================================================================================================================================
"#########################################################################################################################################"





;------------------------------------------------------------------------------------------------------------------------------------------
;	PUNTOS-SPLI-DIVIDE   DIVIDE SPLINE ( NomSpl ) con ( Ndivide ) => LISTA PUNTOS ( LIS-PUN-SPL )  									             
;------------------------------------------------------------------------------------------------------------------------------------------

	(DEFUN PUNTOS-SPLI-DIVIDE ( / )

		(SETQ LIS-PUN-SPL nil)
		(SETQ ALIS  (ENTGET NomSpl))  																; lista Spline A
		(SETQ AELE  (ASSOC 10 ALIS))  																; 1 Punto Asociado a 10 (10.punto)
		(SETQ AELES (MEMBER AELE ALIS)) 																; lista a partir del Alterior (10.punto)....(11.punto)
		(SETQ X-primer (CDR (NTH 0 AELES))) 													   ; primer elemento (10.punto)
		(SETQ X-ultimo (CDR (NTH (- (LENGTH AELES) 1) AELES)))								; ultimo elemento (11.punto)
		(COMMAND "COLOR" COLO )																			; COLOR  = A
		;(COMMAND "TEXTO" "MI" X-primer 5.0 0 TEX)												;  TEXTO = A
		(COMMAND "PUNTO" X-primer)																		; PINTA 1 punto A
		(SETQ N-enti-A1 (ENTLAST))																		; nombre ultima entidad principal 1 punto A
		(COMMAND "DIVIDE" NomSpl Ndivide)															; GRADUA SPLI-A
		(COMMAND "PUNTO" X-ultimo)																		; PINTA Ultimo Punto A
		;	PUNTOS SECCION-A (PA1-PAn) =>   LIS-PUN-SPL  Lon-LPA													                                        
		(SETQ LIS-PUN-SPL nil)																			; LISTA  PUNTOS-A
		(SETQ LIS-PUN-SPL (CONS (CDR (ASSOC 10 (ENTGET N-enti-A1))) LIS-PUN-SPL))		; lista entidad -> (1 Punto-A)
		(SETQ W1A T)
		(WHILE W1A
			(SETQ N-enti-A2 (ENTNEXT N-enti-A1))													; Nombre entidad siguiente
			(COMMAND "BORRA" N-enti-A1 "")															; BORRA entidad (Punto)
			(IF (= N-enti-A2 nil)  (SETQ W1A nil)
				(PROGN
					(SETQ LIS-PUN-SPL (CONS (CDR (ASSOC 10 (ENTGET N-enti-A2))) LIS-PUN-SPL))
					(SETQ N-enti-A1  N-enti-A2 )
				);progn
			);if
		) ;While W1A
		;	LISTA ( LIS-PUN-SPL ) Ordenada																                                                    
		(SETQ LIS-PUN-SPL (REVERSE LIS-PUN-SPL ))													; ( LIS-PUN-SPL Ordenada )

	) ; Defun PUNTOS-SPLI-DIVIDE

;																						                                                                         



"#########################################################################################################################################"
;==========================================================================================================================================
;	  *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** 				 
;==========================================================================================================================================
"#########################################################################################################################################"

(DEFUN C:CAJAS-CARAS-PLANAS-entre-SPLINES-EMBUDOS-06 (/ )

	;========================================================================================================================================
	;	(01) DATOS INTERNOS       Ndivide																												                 
	; (02) DATOS EXTERNOS				SPLINES-PERFILES		SPLINE-COLUMNA-VERTEBRAL		POLILINEA-BASE						   						  
	;========================================================================================================================================
	; FORMACION de PLANO CARA-PLANA : 2-PUN SECC-1 BASE-USO  con  1/PUN SECC-2 SPLINES-PERFILES  (SECC NORMALES a SPLINE-COLUMNA-VERTEBRAL)  
	;========================================================================================================================================
	;	(01) DATOS  															=>	Ndivide				                 													  
	;----------------------------------------------------------------------------------------------------------------------------------------
	;  (02) SEALA COJUNTO de SPLINES                           =>	CONJ-SPL-PER   									 										  
	;----------------------------------------------------------------------------------------------------------------------------------------
	;	(03) PUNTOS-SPLI-DIVIDE   NOMBRE SPLINE-X + Ndivide    	LIS-PUN-SPL 	=> 	LIS-LIS-P-SLI-LONGI              							  
	;----------------------------------------------------------------------------------------------------------------------------------------
	;	(04) LISTAS PUNTOS de SPLINES por SECC-TRANVERSALES    	LIS-LIS-P-SLI-LONGI  =>  LIS-LIS-P-SLI-TRANS							 				  
	;----------------------------------------------------------------------------------------------------------------------------------------
	;	(05) PUNTOS COLUMNA-VERTEBRAL               					LIS-LIS-P-SLI-TRANS  =>  LIS-PUN-COLUM-Vertebral  	 	 		 					  
	;----------------------------------------------------------------------------------------------------------------------------------------
	;	(06) PLANOS NORMALES a COLUMNA-VERTEBRAL                 LIS-PUN-COLUM-Vertebral	=>	LIS-3PUN-PLA-NorColVer					 				  
	;----------------------------------------------------------------------------------------------------------------------------------------
	;	(06) PINTA LINEAS o 3DCARAS  BORDE de 3P-PLANOS    				 ( COMPROBACION )                 	 	 				 						  
	;----------------------------------------------------------------------------------------------------------------------------------------
	;	(07) PUNTOS-INTER-SPLINES con PLANOS-NOR-COLUM    			LIS-3PUN-PLA-NorColVer + LIS-LIS-P-SLI-LONGI	=>	LIS-LIS-P-SEC-NORcolu-LONGI  
	;----------------------------------------------------------------------------------------------------------------------------------------
	;	(07) AADE  Ps-Prinera-SECC y  Ps-Ultima-SECC a  			LIS-LIS-P-SEC-NORcolu-LONGI	=>  LIS-LIS-P-SEC-NORcolu-TRANS+inis 			  
	;----------------------------------------------------------------------------------------------------------------------------------------
	;	(07) PINTA 3DCARAS con PUNTOS de LIS-LIS-P-SEC-NORcolu-TRANS+inis  ( COMPROBACION )              	 		 									  
	;----------------------------------------------------------------------------------------------------------------------------------------
	;  (08) PUNTOS BASE-0 (= N7 1 )  POLIGONO BASE (PUNTOS POLILINEA BASE)    =>   LIS-PUN-BASE-0     												  
	;========================================================================================================================================
	;	(09) PUNTO INTERSECCION de PLANOS-2CARAS con PLANO-SECC     INTER-3-PLANOS (VECTORIAL)                                                
	;========================================================================================================================================
	; 	(09-1)  DETERMINAN PLANO SECCION N7  3-PUNTOS(0 1 2) N7 (1..20) LIS-LIS-P-SEC-NORcolu-TRANS+inis   =>   PlaSo PlaSx PlaSy 			  
	;----------------------------------------------------------------------------------------------------------------------------------------
	; 	(09-2)  PUNTOS BASE-USO  			Si (= N7 1 ) => ( BASE-USO = BASE-0 ) SiNo ( BASE-USO = BASE-INTER )			          				  
	;----------------------------------------------------------------------------------------------------------------------------------------
	; 	(09-3)  PUNTOS BASE-INTER  	PUN-SECC-INTERSECCION-3PLANOS			=>		LIS-PUN-INTER-BASE														  
	;========================================================================================================================================
	;  (10) PINTA 3DC CARAS LATERALES CAJA                                                         														  
	;----------------------------------------------------------------------------------------------------------------------------------------


	;========================================================================================================================================
	;	(00) ARRANCANDO																																							  
	(SETVAR "blipmode" 0) (SETVAR "cmdecho" 0) (GRAPHSCR) (COMMAND "-REFENT" "DES"  "SCP" "U"  "ORTO" "DES")
	(IF (= CAL nil)(COMMAND "ARX" "L" "GEOMCAL.ARX"))			; CARGA CALCULADORA

	;========================================================================================================================================
	;	(01) DATOS INTERNOS       Ndivide																												                 

	"///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////"
	(SETQ Ndivide  80 )			;  NO mas de  32768  Divisiones 
	"///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////"

	;----------------------------------------------------------------------------------------------------------------------------------------
	; (02) DATOS EXTERNOS														   																							  

	(TERPRI)
	(PROMPT                       "####################################################################")   (TERPRI)
	(PROMPT                       " ---------------- MARCA SPLINES PERFILES en ORDEN -----[ENTER]------")   (TERPRI)
	(SETQ CONJ-SPL-PER (SSGET))																												   ; (SSLENGTH CONJ-SPL-PER )
	(SETQ NoCOLU     (CAR (ENTSEL " >>>>>>>>>>>>>>>> MARCA SPLINE  COLUMNA-VERTEBRAL <<<<<<<<<<<<<<<<<<"))) (TERPRI)	; nombre Spline COLUM-VERTEBRAL

	(SETQ N-poliBASE (CAR (ENTSEL " >>>>>>>>>>>>>>>> MARCA POLILINEA BASE (ORDEN y ALINEADAS) <<<<<<<<<"))) (TERPRI)	; nombre POLILINEA BASE 

	(PROMPT                       "####################################################################")   (TERPRI)

	;========================================================================================================================================
	;	(03) PUNTOS SPLINE-PERFILES  NOMBRE  con  Ndivide  =>  LIS-PUN-SPL => LIS-LIS-P-SLI-LONGI                     	 	 	 				  

	(SETQ LIS-LIS-P-SLI-LONGI nil )

	(SETQ N0 -1 )
	(REPEAT (SSLENGTH CONJ-SPL-PER )																; (SSLENGTH CONJ-SPL-PER ) 3 
		(SETQ N0 (+ N0  1 ))
		(SETQ NomSpl (SSNAME CONJ-SPL-PER N0 ))   											; <Nombre entidad: 7efd3c98> 
		(SETQ COLO (+ N0 1)  TEX (ITOA (+ N0 1)))

		(PUNTOS-SPLI-DIVIDE) 																		; => LIS-PUN-SPL 

		(SETQ LIS-LIS-P-SLI-LONGI (CONS LIS-PUN-SPL   LIS-LIS-P-SLI-LONGI ))			; (LENGTH LIS-PUN-SPL )   81 

		; AADIMOS a LIS-PUN-SPL PUNTOS PVpri PVult => LIS-PUN-SPL+Ps																								 
		;																																												 
		;(SETQ PRI1 (NTH 0  LIS-PUN-SPL ))
		;(SETQ PRI2 (NTH 1  LIS-PUN-SPL ))
		;(SETQ ULT2 (NTH (- (LENGTH LIS-PUN-SPL ) 2 ) LIS-PUN-SPL ))
		;(SETQ ULT1 (NTH (- (LENGTH LIS-PUN-SPL ) 1 ) LIS-PUN-SPL ))
		;(SETQ PVpri  (CAL " PRI1 + ( 1000 * VEC1( PRI2 , PRI1 ))"))												; PUN PRIMERO  * 1000 ? 
		;(SETQ PVult  (CAL " ULT1 + ( 1000 * VEC1( ULT2 , ULT1 ))"))												; PUN ULTIMO   * 1000 ? 
		;(SETQ LIS-PUN-SPL+Ps (REVERSE     LIS-PUN-SPL    ))
		;(SETQ LIS-PUN-SPL+Ps (CONS PVult  LIS-PUN-SPL+Ps ))
		;(SETQ LIS-PUN-SPL+Ps (REVERSE     LIS-PUN-SPL+Ps ))
		;(SETQ LIS-PUN-SPL+Ps (CONS PVpri  LIS-PUN-SPL+Ps ))
		;(SETQ LIS-LIS-P-SLI-LONGI (CONS LIS-PUN-SPL+Ps   LIS-LIS-P-SLI-LONGI ))								; (LENGTH LIS-PUN-SPL+Ps )   83 


	) ; repe N0 

	(SETQ LIS-LIS-P-SLI-LONGI (REVERSE LIS-LIS-P-SLI-LONGI ))     													; (LENGTH LIS-LIS-P-SLI-LONGI ) 6 

	;========================================================================================================================================
	;	(04) PUNTOS SPLINE COLUM-VERTEBRAL  NOMBRE  con  Ndivide  =>  LIS-PUN-COLUM-Vertebral       	 	 	 										  

		(SETQ NomSpl NoCOLU)   																									; <Nombre entidad: 7efd3c98> 
		(PUNTOS-SPLI-DIVIDE) 																									; => LIS-PUN-SPL 
		(SETQ LIS-PUN-COLUM-Vertebral   LIS-PUN-SPL )																	; (LENGTH LIS-PUN-COLUM-Vertebral ) 21 


	;========================================================================================================================================
	;	(04) PINTA y NUMERA 1PUNTOS de SPLINES PERFILES y COLUMNA-VERTEBRAL       	 	 	 											 				 	  

	(SETQ N1 -1 )
	(REPEAT (LENGTH LIS-LIS-P-SLI-LONGI )																					; (LENGTH LIS-LIS-P-SLI-LONGI )  
		(SETQ N1 (+ N1  1 ))
		(SETQ P0x (NTH 0 (NTH N1  LIS-LIS-P-SLI-LONGI ) ))
		(COMMAND  "COLOR" (+ (REM N1 7) 1 )  "CIRCULO" P0x 0.5   "TEXTO" "MC" P0x 0.8 0 (ITOA (+ N1 1 )))
	) ; repe N1 

	(SETQ P0c (NTH 0 LIS-PUN-COLUM-Vertebral ))
	(COMMAND  "COLOR" 7  "CIRCULO" P0c 0.5   "TEXTO" "MC" P0c 0.8 0 (ITOA 0 ))


			;                                                                                                                                
			;                                                                                                                                
			;                         #D5---------------------#C5                                                                            
			;                        /|                      /|                                                                              
			;                       / #D4                   / #C4                                                                            
			;                      /  |                    /  |          LIS-LIS-P-SLI-LONGI =>                                              
			;                     /   #D3     |           /   #C3          (LIS-PUN-SP-A  LIS-PUN-SPL-B  LIS-PUN-SPL-C  LIS-PUN-SPL-D ...)   
			;                    /    |       |          /    |                                                                              
			;                   #A5---------------------#B5   #C2                                                                            
			;                   |     |       |         |     |          LIS-PUN-COLUM-Vertebral                                             
			;                   #A4   #D1     |         #B4   #C1                                                                            
			;                   |     |       |         |     |                                                                              
			;                   #A3   #D0-----|---------#B3---#C0                                                                            
			;                   |    /|       |         |    /|                                                                              
			;                   #A2 / SPL-D   |         #B2 / SPL-C                                                                          
			;                   |  /          |         |  /                                                                                 
			;                   #A1       SPL-COLU      #B1                                                                                  
			;                   |/                      |/                                                                                   
			;                   #A0---------------------#B0                                                                                  
			;                   |                       |                                                                                    
			;                   SPL-A                   SPL-B                                                                                
			;                                                                                                                                

	;========================================================================================================================================
	;	(05) LISTAS PUNTOS de SPLINES por SECC-TRANVERSALES      LIS-LIS-P-SLI-LONGI  =>	 LIS-LIS-P-SLI-TRANS										     

	(SETQ LIS-LIS-P-SLI-TRANS nil )    ; LIS-LIS-P-SLI-TRANS
	(SETQ NPun -1 )
	(REPEAT (LENGTH (NTH 0 LIS-LIS-P-SLI-LONGI))  																		; N-PUN-SPL  21 FILAS 
		(SETQ NPun (+ NPun 1 ))																								; 0..12 

		(SETQ LIS-PUN-SECC nil )
		(SETQ NSpl -1 )
		(REPEAT (LENGTH LIS-LIS-P-SLI-LONGI )																				; N-SPLNES   6 COLUMNAS 
			(SETQ NSpl (+ NSpl 1 ))																							; 0..5 
			(SETQ PUsIZs (NTH NPun (NTH NSpl  LIS-LIS-P-SLI-LONGI )))
			(SETQ LIS-PUN-SECC (CONS PUsIZs  LIS-PUN-SECC ))
		) ; repe NSpl
		(SETQ LIS-PUN-SECC (REVERSE LIS-PUN-SECC ))																		; (LENGTH LIS-PUN-SECC ) 6 
		(SETQ LIS-LIS-P-SLI-TRANS (CONS LIS-PUN-SECC   LIS-LIS-P-SLI-TRANS ))

	) ; repe NPun
	(SETQ LIS-LIS-P-SLI-TRANS (REVERSE LIS-LIS-P-SLI-TRANS ))														; (LENGTH LIS-LIS-P-SLI-TRANS ) 21 


	;========================================================================================================================================
	;	(06) PLANOS NORMALES a COLUMNA-VERTEBRAL                 LIS-PUN-COLUM-Vertebral	=>	LIS-3PUN-PLA-NorColVer									  

	(SETQ LIS-3PUN-PLA-NorColVer nil )

	(SETQ NA -1 )
	(REPEAT (- (LENGTH LIS-PUN-COLUM-Vertebral ) 2 )																	; 21 -2 = 19 
		(SETQ NA (+ NA 1 ))																									; 0..18 

		(SETQ PC1 (NTH (+ NA 0 ) LIS-PUN-COLUM-Vertebral ))
		(SETQ PC2 (NTH (+ NA 1 ) LIS-PUN-COLUM-Vertebral ))
		(SETQ PC3 (NTH (+ NA 2 ) LIS-PUN-COLUM-Vertebral ))

		(SETQ PnC2y (CAL " PC2 + ( 5 * NOR( PC1 , PC2 , PC3 ))"))													; LONGITUD VECTOR # 200 

		(SETQ PmC12 (CAL " PLT( PC1 , PC2 , 0.5 )"))
		(SETQ PmC23 (CAL " PLT( PC2 , PC3 , 0.5 )"))
		(SETQ PnC12 (CAL " PmC12 + NOR( PC1 , PC2 , PnC2y )"))
		(SETQ PnC23 (CAL " PmC23 + NOR( PC2 , PC3 , PnC2y )"))

		(SETQ CenC   (CAL " ILL( PmC12 , PnC12 , PmC23 , PnC23 )"))													; INTERSECCION 2-LINEAS 
		(SETQ PnC2x  (CAL " PC2 + ( 5 * VEC1( PC2 , CenC ))"))														; LONGITUD VECTOR # 200 

		(SETQ LIS-3PUN-PLA-NorColVer (CONS (LIST PC2  PnC2x  PnC2y )  LIS-3PUN-PLA-NorColVer ))

		;(COMMAND "COLOR" 255 "LINEA" PnC2x  PC2  PnC2y "" )

	) ; repe NA

	(SETQ LIS-3PUN-PLA-NorColVer (REVERSE LIS-3PUN-PLA-NorColVer ))												; (LENGTH LIS-3PUN-PLA-NorColVer ) 19 


 (IF T (PROGN  ;//////////////////////////  COMPROBACION  ///////////////////////////////////////////////////////////////////////////////
	;========================================================================================================================================
	;	(06) PINTA LINEAS o 3DCARAS  BORDE de 3P-PLANOS    ( COMPROBACION )                 	 	 				 										  

	;                                                                 
	;                    O B3                                         
	;                B0 /|                                            
	;        B4 O------O------O B2                                    
	;           |     /| |    |                                       
	;           | B1 O | |    |                                       
	;           |    | | |    |                                       
	;           |    | | O A3 |                                       
	;           |    | |/     |                                       
	;        A4 O----|-O------O A2                                    
	;                |/ A0                                            
	;             A1 O                                                
	;                                                                 

	(SETQ NBO -1 )   ; (SETQ NBO 60 )
	(REPEAT (- (LENGTH LIS-3PUN-PLA-NorColVer ) 1 )																					; N-PLANOS       19    
		(SETQ NBO (+ NBO 1 ))																												; 0..18

		(SETQ A0 (NTH 0 (NTH (+ NBO 0 ) LIS-3PUN-PLA-NorColVer )))
		(SETQ A1 (NTH 1 (NTH (+ NBO 0 ) LIS-3PUN-PLA-NorColVer )))
		(SETQ A2 (NTH 2 (NTH (+ NBO 0 ) LIS-3PUN-PLA-NorColVer )))
		;(SETQ A3 (CAL " A0 + VEC( A1 , A0 ) "))
		;(SETQ A4 (CAL " A0 + VEC( A2 , A0 ) "))

		(SETQ B0 (NTH 0 (NTH (+ NBO 1 ) LIS-3PUN-PLA-NorColVer )))
		(SETQ B1 (NTH 1 (NTH (+ NBO 1 ) LIS-3PUN-PLA-NorColVer )))
		(SETQ B2 (NTH 2 (NTH (+ NBO 1 ) LIS-3PUN-PLA-NorColVer )))
		;(SETQ B3 (CAL " B0 + VEC( B1 , B0 ) "))
		;(SETQ B4 (CAL " B0 + VEC( B2 , B0 ) "))

		(COMMAND "COLOR" 255 "LINEA" A0  A1 "" )
		(COMMAND "COLOR" 255 "LINEA" A1  B1 "" )
		(COMMAND "COLOR"   5 "LINEA" A0  A2 "" )
		(COMMAND "COLOR"   5 "LINEA" A2  B2 "" )
		(COMMAND "COLOR"   7 "LINEA" A0  B0 "" )
		(IF (= (+ NBO 1 ) (- (LENGTH LIS-3PUN-PLA-NorColVer ) 1 ))
			(PROGN
				(COMMAND "COLOR" 255 "LINEA" B0  B1 "" )
				(COMMAND "COLOR"   5 "LINEA" B0  B2 "" )
			) ; pro
		) ; if

	) ; repe NBO 

 ))  ;IF PROGN  /////////////////////////////  COMPROBACION  //////////////////////////////////////////////////////////////////////////////



	;========================================================================================================================================
	;	(07) PUNTOS-INTERSECCION de las SPLINES con PLANOS-NORMALES-COLUMNA  LIS-3PUN-PLA-NorColVer + LIS-LIS-P-SLI-LONGI	=>	LIS-LIS-pSPL-SecNOR

	(SETQ LIS-LIS-pSPL-SecNOR  nil )

	(SETQ NPLA -1 )    ; (SETQ NPLA 60 )
	(REPEAT (LENGTH LIS-3PUN-PLA-NorColVer )																						; N-PLANOS        19 
		(SETQ NPLA (+ NPLA 1 ))																										; 0..18 

		(SETQ ppO (NTH 0 (NTH NPLA  LIS-3PUN-PLA-NorColVer )))																; PUNTOS PLANO-NOR-COLUMNA 
		(SETQ ppX (NTH 1 (NTH NPLA  LIS-3PUN-PLA-NorColVer )))
		(SETQ ppY (NTH 2 (NTH NPLA  LIS-3PUN-PLA-NorColVer )))																; (LIST  PC2  PnC2x  PnC2y ) 

		; (COMMAND "COLOR" 4 "LINEA" ppX ppO ppY "" )

		(SETQ LIS-pSPL-SecNOR  nil )

		(SETQ NSPL  -1 )
		(REPEAT (LENGTH LIS-LIS-P-SLI-LONGI )																						; N-SPLINES       6  
			(SETQ NSPL (+ NSPL 1 ))																									; 0..5  

			(SETQ LIS-INT-1SPL  nil )
			(SETQ NPUN  -1 )
			(REPEAT (- (LENGTH (NTH NSPL  LIS-LIS-P-SLI-LONGI )) 1 )
				(SETQ NPUN (+ NPUN 1 ))																								; N-PUNTO-SPL   0..19  1..20 

				(SETQ Ps1 (NTH (+ NPUN 0 ) (NTH NSPL  LIS-LIS-P-SLI-LONGI )))
				(SETQ Ps2 (NTH (+ NPUN 1 ) (NTH NSPL  LIS-LIS-P-SLI-LONGI )))

				(SETQ PIn12 (CAL " ILP( Ps1 , Ps2 ,  ppO , ppX , ppY)"))														; INTERSEC LINE PLANO
				(SETQ Dis12 (DISTANCE Ps1   Ps2 ))
				(SETQ Dis1  (DISTANCE PIn12 Ps1 ))
				(SETQ Dis2  (DISTANCE PIn12 Ps2 ))

				(IF (EQUAL Dis12 (+ Dis1 Dis2 ) 0.0001)																			; INTER DENTRO de Ps1 Ps2 
					(PROGN
						(SETQ PunPLA (CAL "PLT( Ps1 , Ps2 , Dis1 / ( Dis1 + Dis2 ))"))										; PUN en LINEA en % 
						(SETQ LIS-INT-1SPL (CONS (LIST PunPLA  ppO )  LIS-INT-1SPL ))
					) ; pro
				) ; if

			) ; repe NPUN


			(COND
				((= (LENGTH LIS-INT-1SPL ) 0 )
					(PROMPT "  ### INTER FUERA de Ps1 Ps2  ERROR? ###") (PROMPT "  NPLA = ") (PRIN1 NPLA ) (PROMPT "  NSPL = ") (PRIN1 NSPL ) (TERPRI)) ; con0 

				((= (LENGTH LIS-INT-1SPL ) 1 )  (SETQ LIS-pSPL-SecNOR (CONS PunPLA  LIS-pSPL-SecNOR )))	; con1 

				((= (LENGTH LIS-INT-1SPL ) 2 )
					(SETQ PuPla1 (NTH 0 (NTH 0  LIS-INT-1SPL )))
					(SETQ PuPla2 (NTH 0 (NTH 1  LIS-INT-1SPL )))
					(SETQ ppO1   (NTH 1 (NTH 0  LIS-INT-1SPL )))
					(SETQ ppO2   (NTH 1 (NTH 1  LIS-INT-1SPL )))
					(IF (EQUAL ppO1 ppO2 0.0001)
						(PROGN
							(IF (AND (EQUAL ppO1 ppO2 0.0001) (> (DISTANCE PuPla1 ppO1 ) (DISTANCE PuPla2 ppO1 )))
								(PROGN
									(SETQ LIS-pSPL-SecNOR (CONS PuPla2  LIS-pSPL-SecNOR ))
								) ; pro
								(PROGN
									(SETQ LIS-pSPL-SecNOR (CONS PuPla1  LIS-pSPL-SecNOR ))
								) ; pro
							) ; if 
						) ; pro
						(PROGN
							(PROMPT "  ### NO IGUALES ppO1 ppO2  ERROR? ### ") (PRIN1 ppO1 ) (PROMPT " / ") (PRIN1 ppO2 ) (TERPRI)
						) ; pro
					)	; if 
				 ) ; con2 

				((= (LENGTH LIS-INT-1SPL ) 3 ) (PROMPT " =========> 3 INTER en NPLA = ") (PRIN1 NPLA ) (PROMPT "  NSPL = ") (PRIN1 NSPL ) (TERPRI))
				((= (LENGTH LIS-INT-1SPL ) 4 ) (PROMPT " ============> 4 INTER en NPLA = ") (PRIN1 NPLA ) (PROMPT "  NSPL = ") (PRIN1 NSPL ) (TERPRI))
				((= (LENGTH LIS-INT-1SPL ) 5 ) (PROMPT " ===============> 5 INTER en NPLA = ") (PRIN1 NPLA ) (PROMPT "  NSPL = ") (PRIN1 NSPL ) (TERPRI))
			) ; con
			
		) ; repe NSPL

		(SETQ LIS-pSPL-SecNOR  (REVERSE LIS-pSPL-SecNOR ))																			; (LENGTH LIS-pSPL-SecNOR )  
		(SETQ LIS-LIS-pSPL-SecNOR (CONS LIS-pSPL-SecNOR   LIS-LIS-pSPL-SecNOR ))

	) ; repe NPLA 

	;(SETQ LIS-LIS-pSPL-SecNOR  (REVERSE LIS-LIS-pSPL-SecNOR ))	; NO REVERSE para AADIR  

	;========================================================================================================================================
	;	(07) AADE  Ps-Prinera-SECC y  Ps-Ultima-SECC a ( LIS-LIS-pSPL-SecNOR )  =>  LIS-LIS-pSPL-SecNOR                 	 	 			 		  

	(SETQ LIS-P-SEC-00 (NTH 0 LIS-LIS-P-SLI-TRANS ))																; PRIMERA SECC (LENGTH LIS-P-SEC-00 ) 6 
	(SETQ LIS-P-SEC-UL (LAST  LIS-LIS-P-SLI-TRANS ))																; ULTIMA  SECC (LENGTH LIS-P-SEC-UL ) 6 

	(SETQ LIS-LIS-P-SEC-NORcolu-TRANS+inis (CONS LIS-P-SEC-UL   LIS-LIS-pSPL-SecNOR   ))
	(SETQ LIS-LIS-P-SEC-NORcolu-TRANS+inis (REVERSE             LIS-LIS-P-SEC-NORcolu-TRANS+inis ))
	(SETQ LIS-LIS-P-SEC-NORcolu-TRANS+inis (CONS LIS-P-SEC-00   LIS-LIS-P-SEC-NORcolu-TRANS+inis ))	; (LENGTH LIS-LIS-P-SEC-NORcolu-TRANS+inis ) 21 




 (IF T (PROGN  ;/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	;========================================================================================================================================
	;	(07) PINTA 3DCARAS con PUNTOS de LIS-LIS-P-SEC-NORcolu-TRANS+inis con PRIMERA y ULTIMA SECC    =>	3DCARAS   ( COMPROBACION )         

	(SETQ NE -1 )
	(REPEAT (- (LENGTH LIS-LIS-P-SEC-NORcolu-TRANS+inis ) 1 )	
		(SETQ NE (+ NE 1 ))
		(SETQ LIS-P-SecA (NTH (+ NE 0 ) LIS-LIS-P-SEC-NORcolu-TRANS+inis ))
		(SETQ LIS-P-SecB (NTH (+ NE 1 ) LIS-LIS-P-SEC-NORcolu-TRANS+inis ))

		(SETQ NF -1 )
		(REPEAT (LENGTH LIS-P-SecA )
			(SETQ NF (+ NF 1 ))
			(SETQ PSA1 (NTH (REM (+ NF 0 ) (LENGTH LIS-P-SecA )) LIS-P-SecA ))
			(SETQ PSA2 (NTH (REM (+ NF 1 ) (LENGTH LIS-P-SecA )) LIS-P-SecA ))

			(SETQ PSB1 (NTH (REM (+ NF 0 ) (LENGTH LIS-P-SecB )) LIS-P-SecB ))
			(SETQ PSB2 (NTH (REM (+ NF 1 ) (LENGTH LIS-P-SecB )) LIS-P-SecB ))

	    (COMMAND  "COLOR" 4   "3DCARA" PSA1 PSA2 PSB2 PSB1 "")		; COMPROBACION 

		) ; repe NF 
	) ; repe NE

 ))  ;IF PROGN  /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


	;-------------------------------------------------------------------------------------------------------------------------------------
	; (08) PUNTOS BASE-0   PUNTOS ORDENADOS POLILINEA BASE    =>   LIS-PUN-BASE-0     																	  

	(SETQ LIS-PUN-BASE-0  nil )
	(SETQ LIS-POLI-X (ENTGET N-poliBASE ))  												; lista POLILINEA BASE 
	(SETQ N-ENT (CDR (ASSOC -1 LIS-POLI-X )))												; NOMBRE ENTIDAD 
	(SETQ NVER (CDR (ASSOC 90 LIS-POLI-X )))  											; N VERTICES  4 

	(SETQ ELEM-0     (ASSOC 10 LIS-POLI-X ))
	(SETQ VERT-sco-0 (CDR ELEM-0 ))


	(SETQ VERT-SCU-0 (TRANS  VERT-sco-0  N-ENT  0 ))								; SCO => SCU 
	(SETQ LIS-PUN-BASE-0 (CONS  VERT-SCU-0  LIS-PUN-BASE-0 ))

	(REPEAT (- NVER 1 )
		(SETQ LIS-POLI-X (SUBST '(#####)  ELEM-0  LIS-POLI-X ))
		(SETQ ELEM-1     (ASSOC 10 LIS-POLI-X ))
		(SETQ VERT-sco-1 (CDR ELEM-1 ))


		(SETQ VERT-SCU-1 (TRANS  VERT-sco-1  N-ENT  0 ))							; SCO => SCU 
		(SETQ LIS-PUN-BASE-0 (CONS  VERT-SCU-1  LIS-PUN-BASE-0 ))
		(SETQ ELEM-0  ELEM-1 )
	) ; repe

	(SETQ LIS-POLI-X (SUBST '(#####)  ELEM-0  LIS-POLI-X ))
	(SETQ LIS-PUN-BASE-0 (REVERSE LIS-PUN-BASE-0 ))


	;-------------------------------------------------------------------------------------------------------------------------------------
	; (08) PINTA y NUMERA PUNTOS LIS-PUN-BASE-0        																											  

	(SETQ N2 -1 )
	(REPEAT (LENGTH LIS-PUN-BASE-0 )																				; (LENGTH LIS-PUN-BASE-0 ) 4 
		(SETQ N2 (+ N2  1 ))
		(SETQ P0b (NTH N2  LIS-PUN-BASE-0 ))
		(COMMAND  "COLOR" (+ (REM N2 7) 1 )  "CIRCULO" P0b 0.5   "TEXTO" "MC" P0b  0.8 0 (ITOA (+ N2 1 )))
	) ; repe N2 



	;-------------------------------------------------------------------------------------------------------------------------------------
	;	(09) PUNTO INTERSECCION de PLANOS-2CARAS con PLANO-SECC     INTER-3-PLANOS (VECTORIAL)                                             
	;                                                                                                                                     
	;   3-PUN-BASE ( PuU1 PuU2 PuU3 )    2-PUN-AJUSTE ( PuS1 PuS2 )    3-PUN-PLANO-SECC ( PlaSo PlaSx PlaSy ) => INTERSECCION ( In3PLA )  

	;                                                                                                                                     
	;                                            -------O PlaSy                                                                           
	;                                                  /                                                                                  
	;                                                 /                INTERSECCION de 3-PLANOS                                           
	;               /                                /                                   PLANO-CARA-1 ( PuU1  PuU2  PuS1  )               
	;              /                                O PuS2                               PLANO-CARA-2 ( PuU2  PuU3  PuS2  )               
	;             /                                /                                     PLANO-SECC-2 ( PlaSo PlaSx PlaSy ) => ( In3PLA ) 
	;            /  PuS1                   PlaSx  /   |                                                                                   
	;     PlaSo O----O-----------------------O---O In3PLA                                                                                 
	;                                            |    |                 /                  |                                              
	;                                         ---|----O PuU3           / VNu12s1           |                                              
	;                |   /                       |   /                /          VNu23s2   | VNu2                                         
	;                |  /                        |  /                /         --------    |                                              
	;                | /                         | /                                                                                      
	;                |/                          |/                                                                                       
	;           PuU1 O---------------------------O PuU2                                                                                   
	;                                                                                                                                     

	(SETQ LIS-de-LIS-PUN-TAPA-CAJAS nil )

	(SETQ N7  0 )
	(REPEAT (- (LENGTH LIS-LIS-P-SEC-NORcolu-TRANS+inis ) 1 )									; 21 -1     NSECCIONES 
		(SETQ N7 (+ N7 1 ))		                          										; 1..20 

		;-----------------------------------------------------------------------------------------------------------------------------------
		; (09-1)  DETERMINAN PLANO SECCION N7  3-PUNTOS(0 1 2) N7 (1..20) LIS-LIS-P-SEC-NORcolu-TRANS+inis   =>   PlaSo PlaSx PlaSy 		

		(SETQ PlaSo (NTH 0 (NTH N7  LIS-LIS-P-SEC-NORcolu-TRANS+inis )))						; 3 PUN DETERMINAN PLANO SECCION N7 
		(SETQ PlaSx (NTH 1 (NTH N7  LIS-LIS-P-SEC-NORcolu-TRANS+inis )))
		(SETQ PlaSy (NTH 2 (NTH N7  LIS-LIS-P-SEC-NORcolu-TRANS+inis )))

		;-----------------------------------------------------------------------------------------------------------------------------------
		; (09-2)  PUNTOS BASE-USO  			Si (= N7 1 ) => ( BASE-USO = BASE-0 ) SiNo ( BASE-USO = BASE-INTER )			          			

		(IF (= N7 1 ) (SETQ LIS-PUN-BASE-USO  LIS-PUN-BASE-0 ) (SETQ LIS-PUN-BASE-USO   LIS-PUN-INTER-BASE ))   ; SECC 1..10 

		;-----------------------------------------------------------------------------------------------------------------------------------
		; (09-3)  PUNTOS BASE-INTER  	PUN-SECC-INTERSECCION-3PLANOS			=>		LIS-PUN-INTER-BASE														

		(SETQ LIS-PUN-INTER-BASE  nil )

		(SETQ N8 -1 )
		(REPEAT (LENGTH (NTH N7  LIS-LIS-P-SEC-NORcolu-TRANS+inis ))															; 6    PUN-SECC 
			(SETQ N8 (+ N8 1 ))		                              															; 0..5 

			(SETQ PuU1 (NTH (REM (+ N8 0) (LENGTH LIS-PUN-BASE-USO ))  LIS-PUN-BASE-USO )) 				 				; SECC 0 
			(SETQ PuU2 (NTH (REM (+ N8 1) (LENGTH LIS-PUN-BASE-USO ))  LIS-PUN-BASE-USO ))
			(SETQ PuU3 (NTH (REM (+ N8 2) (LENGTH LIS-PUN-BASE-USO ))  LIS-PUN-BASE-USO ))

			(SETQ PuS1 (NTH (REM (+ N8 1) (LENGTH (NTH N7  LIS-LIS-P-SEC-NORcolu-TRANS+inis ))) (NTH N7  LIS-LIS-P-SEC-NORcolu-TRANS+inis )))	; SECC 1 
			(SETQ PuS2 (NTH (REM (+ N8 2) (LENGTH (NTH N7  LIS-LIS-P-SEC-NORcolu-TRANS+inis ))) (NTH N7  LIS-LIS-P-SEC-NORcolu-TRANS+inis )))

			(SETQ VNu12s1 (CAL "NOR( PuU1 , PuU2 , PuS1 )"))									; VECTOR NORMAL a CARA-AB 
			(SETQ VNu23s2 (CAL "NOR( PuU2 , PuU3 , PuS2 )"))									; VECTOR NORMAL a CARA-BC 
			(SETQ VNu2    (CAL "NOR( PuU2 , PuU2 + VNu12s1 , PuU2 + VNu23s2 )"))			; VECTOR NORMAL a VECTORES NORMALES de DOS CARAS en PuU1 

			(SETQ PuU2v   (CAL " PuU2 + VNu2 "))													; PUNTO de NORMAL en PuU2 
			(SETQ In3PLA  (CAL "ILP( PuU2 , PuU2v ,  PlaSo , PlaSx , PlaSy )"))			; INTERSECCION 3-PLANOS (2-CARAS 1-SECC) 

				;-------------------------------------------------------------------------------------------------------------------------------
				; (09-4)  PERPENDICULAR a PuU1-PuU2 desde PuS1					(COMPROBACION)																		  
				;-------------------------------------------------------------------------------------------------------------------------------
				;(SETQ VNu12s1 (CAL "NOR( PuU1 , PuU2 , PuS1 )"))
				;(SETQ VCARA   (CAL "NOR( PuU1 , PuU2 , PuU1 + VNu12s1 )"))
				;(SETQ PuS1L   (CAL "ILP( PuS1 , PuS1 + VCARA ,  PuU1 , PuU2 , PuU1 + VNu12s1 )")) 							; INTERSECCION LINEA PLANO 
				;(COMMAND "COLOR" 5 "LINEA" PuS1  PuS1L PuU1 "" )
				;(COMMAND "COLOR" 4 "3DCARA" PuS1L PuU2 In3PLA PuS1 "" )
				;-------------------------------------------------------------------------------------------------------------------------------


			(IF (= In3PLA nil)
				(PROGN (PROMPT " ------ ### MAL ###   In3PLA => nil  en N8 = ") (PRIN1 N8) (TERPRI))		; CONTROL

				(PROGN 
					(IF (= (+ N8 1 ) (LENGTH (NTH N7  LIS-LIS-P-SEC-NORcolu-TRANS+inis )))					; (LENGTH LIS-LIS-P-SEC-NORcolu-TRANS+inis ) 179 ?????? 

						(SETQ In3PLAulti  In3PLA )

						(SETQ LIS-PUN-INTER-BASE (CONS In3PLA   LIS-PUN-INTER-BASE ))
					) ; if

	      ;(COMMAND "COLOR" 5 "CIRCULO" In3PLA 4 "TEXTO" "MC" In3PLA 3 0 (ITOA (+ N8 1 )))

				) ; pro
			) ; if
		) ; repe N8

		(SETQ LIS-PUN-INTER-BASE (REVERSE          LIS-PUN-INTER-BASE ))
		(SETQ LIS-PUN-INTER-BASE (CONS In3PLAulti  LIS-PUN-INTER-BASE ))											; AADE el ULTIMO el PRIMERO ?? 

		(SETQ LIS-de-LIS-PUN-TAPA-CAJAS (CONS LIS-PUN-BASE-USO    LIS-de-LIS-PUN-TAPA-CAJAS ))

	) ; repe N7

	(SETQ LIS-de-LIS-PUN-TAPA-CAJAS   (CONS LIS-PUN-INTER-BASE  LIS-de-LIS-PUN-TAPA-CAJAS ))
	(SETQ LIS-de-LIS-PUN-TAPA-CAJAS   (REVERSE                  LIS-de-LIS-PUN-TAPA-CAJAS ))     		; (LENGTH LIS-de-LIS-PUN-TAPA-CAJAS ) 11 



	;---------------------------------------------------------------------------------------------------------------------------------------
	; (10) PINTA 3DC CARAS LATERALES CAJA                                                         														 

	(SETQ N10 -1 )
	(REPEAT (LENGTH (NTH 0 LIS-de-LIS-PUN-TAPA-CAJAS ))
		(SETQ N10 (+ N10 1 ))

		(SETQ KK1 (LIST (* 40 (+ N10 1 )) -50.0  0.0 ))																	; PUNTOS ARRAN PATRONES 
		(SETQ KK2 (LIST (* 41 (+ N10 1 )) -50.0  0.0 ))

		(SETQ N11 -1 )
		(REPEAT (- (LENGTH LIS-de-LIS-PUN-TAPA-CAJAS ) 1 )
			(SETQ N11 (+ N11 1 ))

			(SETQ LIS-P-TAPA-A (NTH (+ N11 0) LIS-de-LIS-PUN-TAPA-CAJAS ))
			(SETQ LIS-P-TAPA-B (NTH (+ N11 1) LIS-de-LIS-PUN-TAPA-CAJAS ))


			(SETQ PA1 (NTH (REM (+ N10 0) (LENGTH LIS-P-TAPA-A )) LIS-P-TAPA-A ))        	;      KK1                     KK2   
			(SETQ PA2 (NTH (REM (+ N10 1) (LENGTH LIS-P-TAPA-A )) LIS-P-TAPA-A ))	      	;      PB1 O-----------------O PB2   
                                                                                       	;          |     3D Cara     |       
			(SETQ PB1 (NTH (REM (+ N10 0) (LENGTH LIS-P-TAPA-B )) LIS-P-TAPA-B ))        	;          |                 |       
			(SETQ PB2 (NTH (REM (+ N10 1) (LENGTH LIS-P-TAPA-B )) LIS-P-TAPA-B ))        	;      PA1 O-----------------O PA2   


			"==( 3D )====================================================================================================================="
			"-----------------------------------------------------------------------------------------------------------------------------"
			(COMMAND "COLOR" 255 "3DCARA" PA1 PA2 PB2 PB1 "" )																; 3DCARA-3D

			(COMMAND "SCP" "3P" PA1 PA2 PB1 )																					; PLANO-3DC ( 3D ) 
				(SETQ PA1p (LIST 0.0 0.0 0.0))
				(SETQ PA2p (TRANS PA2 0 1 ))
				(SETQ PB1p (TRANS PB1 0 1 ))
				(SETQ PB2p (TRANS PB2 0 1 ))
				"----------------------------------------------------------------------------------------------------------------------------"
		;		(COMMAND "COLOR" 1  "TEXTO"  (LIST 0.42 0.18)  0.42  0  (STRCAT (ITOA (+ N10 1 )) "/" (ITOA (+ N11 1 ))))		; TEXTO-3D 
   		(COMMAND "SCP" "U")


			"==( 2D )======================================================================================================================"
			(COMMAND "SCP" "3P" KK1 KK2 "" )																						; PLANO-3DC ( 2D ) PATRONES
				"----------------------------------------------------------------------------------------------------------------------------"
				(COMMAND "COLOR" 7   "3DCARA" PA1p  PA2p  PB2p  PB1p "")													; 3DCARA-2D
				(SETQ PB1pU (TRANS PB1p 1 0 ))
				(SETQ PB2pU (TRANS PB2p 1 0 ))
				(SETQ KK1 PB1pU )
				(SETQ KK2 PB2pU )
				"----------------------------------------------------------------------------------------------------------------------------"
		;		(COMMAND "COLOR" 1  "TEXTO"  (LIST 0.42 0.18)  0.42  0  (STRCAT (ITOA (+ N10 1 )) "/" (ITOA (+ N11 1 ))))		; TEXTO-2D 
   		(COMMAND "SCP" "U")

		) ; repe N11
	) ; repe N10



	;	(50) PARANDO																																							 
	(SETVAR "blipmode" 1) (SETVAR "cmdecho" 1)

) ;CIERRE DEFUN  CAJAS-CARAS-PLANAS-entre-SPLINES-EMBUDOS-06

;=======================================================================================================================================


