

;=========================================================================================================================================
;                                                                                                                         						
;	( SUPERFI-CLEBSCH-a-pelo-013-MAQUETA-1 )     "a Pelo"   MALLA EQUILATERA CIRCULAR  -> F20(xyz)=0 => PUNTO    		  		09-03-2006		
;                                                                                                                         						
;													DOBLE SELECCION + INTERPOLACION LINEAL																					
;=========================================================================================================================================
;	(1) SUPERFICIE  CUVICA de CLEBSCH          64x^3 -31z^3 +48zx^2 -192xy^2 +48zy^2 -54Az^2  -24A^2z = 0												
;-----------------------------------------------------------------------------------------------------------------------------------------
;	(2) SUPERFICIE  CUVICA de CLEBSCH          16x^3 -31z^3 +24zx^2          +24zy^2 -54R3z^2 -72z  +16y^3 -48yx^2 -48xy = 0					
;-----------------------------------------------------------------------------------------------------------------------------------------


;	(1) OPERA FUNCION     SUPERFICIE de CLEBSCH   64x^3-31z^3+48zx^2-192xy^2+48zy^2-54Az^2-24zA^2=0       VAL-Fun2(X Y Z) => Fxyz				

(DEFUN VAL-Fun1 (/ )

	(IF (AND (/= X nil) (/= Y nil) (/= Z nil) (/= Q nil))

		(PROGN  
			(SETQ Fxyz (+ 	(*  +64         (EXPT X       3))      ;  +64    x^3 
          	      		(*  +48    Z    (EXPT X       2))      ;  +48 z  x^2 
          	          	(* -192  X      (EXPT   Y     2))      ; -192 x  y^2 
                  	  	(*  +48    Z    (EXPT   Y     2))      ;  +48 z  y^2 
                   	 	(*  -31         (EXPT     Z   3))      ;  -31    z^3 
                   	 	(*  -54      Q  (EXPT     Z   2))      ;  -54 Q  z^2 
                   	 	(*  -24    Z    (EXPT       Q 2))))    ;  -24 z  Q^2 
		) ;pro

		(PROGN  
			(PROMPT "      $$$ ALGUNO ES NIL (X Y Z Q) $$$") (TERPRI)
		) ;pro

	);if
) ;Defun   VAL-Fun1

;																																														


;	(2) SUPERFICIE de CLEBSCH   +(16 x^3) +(16 y^3) -(31 z^3) +(24 x^2 z) -(48 x^2 y) -(48 x y) +(24 y^2 z) -(54 3^1/2 z^2) -(72 z) = 0 	

(DEFUN VAL-Fun2 (/ )

	(IF (AND (/= X nil) (/= Y nil) (/= Z nil) )

		(PROGN  
			(SETQ Fxyz (+ 	(*  +16          (EXPT X     3))      ;  +(16 x^3           ) +(16 x^3)
          	      		(*  +16          (EXPT   Y   3))      ;  +(16      y^3      ) +(16 y^3)
          	          	(*  -31          (EXPT     Z 3))      ;  -(31           z^3 ) -(31 z^3)
                  	  	(*  +24      Z   (EXPT X     2))      ;  +(24 x^2       z   ) +(24 x^2 z)
                   	 	(*  -48    Y     (EXPT X     2))      ;  -(48 x^2  y        ) -(48 x^2 y)
                   	 	(*  +24      Z   (EXPT   Y   2))      ;  +(24      y^2  z   ) +(24 y^2 z)
                   	 	(*  -54 (SQRT 3) (EXPT     Z 2))      ;  -(54 3^1/3     z^2 ) -(54 3^1/2 z^2)
                   	 	(*  -48  X Y                   )      ;  -(48 x    y        ) -(48 x y)
                   	 	(*  -72      Z                 )))    ;  -(72           z   ) -(72 z)
		) ;pro

		(PROGN  
			(PROMPT "      ??? ALGUNO ES NIL ( X Y Z ) ???") (TERPRI)
		) ;pro

	);if
) ;Defun   VAL-Fun2

;																																														


;	DOBLE SELECCION + INTERPOLACION LINEAL    (Fa Fb)     (Xa Xb) => Xs		(Ya Yb) => Ys																	

		(DEFUN SELEC-INPOLA-XY (/ )

			(SETQ pasX (/ (- Xb Xa) Nps))
			(SETQ pasY (/ (- Yb Ya) Nps))

			(SETQ nps1 -1 )
			(SETQ W1    T )

			(WHILE W1

				(SETQ nps1 (+ nps1 1))
				(SETQ Xps0 (+ Xa (* nps1 pasX)))
				(SETQ Yps0 (+ Ya (* nps1 pasY)))
				(SETQ X nil Y nil Z nil Fxyz nil  X Xps0  Y Yps0  Z Z0 ) (VAL-Fun2) (IF (/= Fxyz nil) (SETQ VF0 Fxyz))


				(SETQ nps2 (+ nps1 1))
				(SETQ Xps1 (+ Xa (* nps2 pasX)))
				(SETQ Yps1 (+ Ya (* nps2 pasY)))
				(SETQ X nil Y nil Z nil Fxyz nil  X Xps1  Y Yps1  Z Z0 ) (VAL-Fun2) (IF (/= Fxyz nil) (SETQ VF1 Fxyz))

				(IF (AND (/= VF0  nil) (/= VF1  nil)
            			(/= Xps0 nil) (/= Yps0 nil)
          				(/= Xps1 nil) (/= Yps1 nil)
            			(OR (< VF0 0.0 VF1) (> VF0 0.0 VF1)))

					(PROGN
						;	INTERPOLACION LINEAL    																
						(SETQ Xs (+ Xps0 (* (/ (- Xps1 Xps0) (+ (ABS VF1) (ABS VF0))) (ABS VF0))))
						(SETQ Ys (+ Yps0 (* (/ (- Yps1 Yps0) (+ (ABS VF1) (ABS VF0))) (ABS VF0))))

						(SETQ W1 nil)

					) ;pro
				) ;if

				(IF (> nps1 (- Nps 1)) (SETQ W1 nil))

			) ;whi
		) ;Defun   SELEC-INPOLA-XY

;																																														




;	DOBLE SELECCION + INTERPOLACION LINEAL    (Fa Fb)     (Xa Xb) => Xs																							

(DEFUN SELEC-INPOLA-X (/ )

	(IF (AND (/= Fa nil) (/= Fb nil)
            (/= Xa nil) 
            (/= Xb nil) 
            (OR (< Fa 0.0 Fb) (> Fa 0.0 Fb)))

		(PROGN
			(SETQ pasX (/ (- Xb Xa) Nps))

			(SETQ nps1 -1 )
			(SETQ W1    T )

			(WHILE W1

				(SETQ nps1 (+ nps1 1))
				(SETQ Xps0 (+ Xa (* nps1 pasX)))
				(SETQ X nil Y nil Z nil Fxyz nil   X Xps0  Y Y0  Z Z0 ) (VAL-Fun2) (IF (/= Fxyz nil) (SETQ VF0 Fxyz))


				(SETQ nps2 (+ nps1 1))
				(SETQ Xps1 (+ Xa (* nps2 pasX)))
				(SETQ X nil Y nil Z nil Fxyz nil   X Xps1  Y Y0  Z Z0 ) (VAL-Fun2) (IF (/= Fxyz nil) (SETQ VF1 Fxyz))

				(IF (AND (/= VF0  nil) (/= VF1  nil)
            			(/= Xps0 nil)
          				(/= Xps1 nil)
            			(OR (< VF0 0.0 VF1) (> VF0 0.0 VF1)))

					(PROGN

						;	INTERPOLACION LINEAL    																
						(SETQ Xs (+ Xps0 (* (/ (- Xps1 Xps0) (+ (ABS VF1) (ABS VF0))) (ABS VF0))))

						(SETQ W1 nil)

					) ;pro
				) ;if

				(IF (> nps1 (- Nps 1)) (SETQ W1 nil))

			) ;whi
		) ;pro
	) ;if
) ;Defun   SELEC-INPOLA-X

;																																														




;	PUNTO MAX-Y   ELIMINA PUNTOS DOBLES   ORDENA por MINI-DIS    LIS-Pxyz => (ORDENA) => LIS-PxyOR														

(DEFUN ORDENA (/ )

	;	PUNTO MAX A LA IZQUIERDA   MINIMA-X																																	

	(SETQ LON# 10000)
	(SETQ N0 -1)
	(REPEAT (LENGTH LIS-Pxyz)
		(SETQ N0 (+ N0 1))
		(SETQ Px1 (NTH N0 LIS-Pxyz))
		(IF (< (CAR Px1) LON#) (SETQ LON# (CAR Px1)  PminX Px1 )) 		; PUNTO MINIMA-X   IZQUIERDA 
	) ; Repe

	;	ELIMINA PUNTOS DOBLES																																					

	(SETQ N1 -1)
	(REPEAT (LENGTH LIS-Pxyz)
		(SETQ N1 (+ N1 1))
		(SETQ PA (NTH N1 LIS-Pxyz))

		(IF (/= PA "no")
			(PROGN
				(SETQ N2 -1)
				(REPEAT (- (LENGTH LIS-Pxyz) 1)
					(SETQ N2 (+ N2 1))
					(SETQ PB (NTH N2 LIS-Pxyz))

					(IF (AND (/= PB "no") (EQUAL PA PB 0.000001) (/= N1 N2))  (SETQ LIS-Pxyz (SUBST "no" PB LIS-Pxyz)))
				) ; Repe
			) ;pro
		) ;if
	) ; Repe


	;	ORDENA P0R PUNTO MAS CERCANO     ( NO ELIMINA PUNTOS MUY CERCANOS  <(* PaR 0.8) )																

	(SETQ Ntxt   1)
	(SETQ PA1     PminX )
	(SETQ LIS-PxyOR nil )

   (SETQ        LIS-PxyOR (CONS PA1 LIS-PxyOR))
	(SETQ   LIS-Pxyz (SUBST "no" PA1 LIS-Pxyz))
	;(COMMAND "COLOR" 7 "CIRCULO" PA1 (/ PaR 6))
	;(COMMAND "COLOR" 7 "TEXTO"   PA1 0.03 0 1 )
	(SETQ NP0 (+ NP0 1))

	(REPEAT (LENGTH LIS-Pxyz)
		(SETQ Ntxt (+ Ntxt 1))
     	(SETQ Dk  10000)
     	(SETQ PA2k nil )

		(IF (/= PA1 "no")

			(PROGN  (SETQ Nk -1)
           	(REPEAT (LENGTH LIS-Pxyz)  (SETQ Nk (+ Nk 1))  (SETQ PA2 (NTH Nk LIS-Pxyz))
					(IF (AND (/= PA1 "no") (/= PA2 "no"))
						(PROGN  
							(SETQ DisAB (DISTANCE PA1 PA2))

							(IF (< DisAB  Dk) (SETQ Dk DisAB  PA2k PA2))			; Dk = DIS-Minima 
						) ;pro
					) ;if
				) ; Repe Nk

				(IF (/= PA2k nil)
					(PROGN  
           			(SETQ LIS-PxyOR  (CONS       PA2k LIS-PxyOR ))
						(SETQ LIS-Pxyz   (SUBST "no" PA2k LIS-Pxyz  ))

						(SETQ NP0 (+ NP0 1))
						(SETQ PA1 PA2k)

						;(COMMAND "COLOR" 8 "CIRCULO"        PA2k (/ PaR 6))
						;(COMMAND "COLOR" 7 "TEXTO" "U" "MI" PA2k 0.03 0 Ntxt )
					) ;pro
				) ;if
			) ;pro
		) ;if 
	) ; Repe

	(SETQ LIS-PxyOR (REVERSE LIS-PxyOR))

)	; DEFUN         ORDENA

;																																														



;-----------------------------------------------------------------------------------------------------------------------------------------
;	  *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** *** PROGRAMA *** 			
;-----------------------------------------------------------------------------------------------------------------------------------------

(DEFUN C:SUPERFI-CLEBSCH-a-pelo-013-MAQUETA-1 (/ )

	;	(0) ARRANCANDO																																								
	(SETVAR "blipmode" 0) (SETVAR "cmdecho" 0) (GRAPHSCR) (COMMAND   "-REFENT" "DES"    "SCP" "U"    "ORTO" "DES")

	;	(1) DATOS VARIABLES																																						

	(SETQ NPaR    60   ) ; n-enteros  ; N Pasos RADIO  60   
	(SETQ RADI      4.5 )					; Total RADIO      4.5 

	(SETQ NPaZ    50   ) ; n-enteros  ; N CAPAS Z     QUE COINCIDA con CERO  MULTIPLO de ARRz y ABAz  ?  50
	(SETQ ARRz       5.0 )					; Z ARRIBA   5.0 
	(SETQ ABAz      -5.0 )					; Z ABAJO   -5.0 

	;(SETQ  Q        3.0 )					; PARAMETRO Q Ecuacion-1 
	(SETQ  Nps    10   ) ; n-enteros  ; N PASOS SELECCION-INTERPOLA  10 

	(SETQ  Ex       2.5 )					; Escala X  2.5 
	(SETQ  Ey       2.5 )					; Escala Y  2.5 
	(SETQ  Ez       2.5 )					; Escala Z  2.5 

	;	(1) ESCRIBE en PANTALLA DATOS VARIABLES																															

	(SETQ Tx -5  Ty -3  Tz 0 )			; Punto Inicio TEXTO 
	(SETQ AlT 0.1 )						; Altura TEXTO 

	(SETQ V1 (ITOA (FIX (* 1000 (- (ABS NPaR) (ABS (FIX NPaR)))))) )
	(SETQ V2 (ITOA (FIX (* 1000 (- (ABS RADI ) (ABS (FIX RADI )))))) )
	(SETQ V3 (ITOA (FIX (* 1000 (- (ABS NPaZ) (ABS (FIX NPaZ)))))) )
	(SETQ V4 (ITOA (FIX (* 1000 (- (ABS ARRz ) (ABS (FIX ARRz )))))) )
	(SETQ V5 (ITOA (FIX (* 1000 (- (ABS ABAz ) (ABS (FIX ABAz )))))) )	; NO TIENE EN CUENTA EL 1 CERO DECIMAL ??? 
	(SETQ V6 (ITOA (FIX (* 1000 (- (ABS Nps ) (ABS (FIX Nps )))))) )
	(SETQ V7 (ITOA (FIX (* 1000 (- (ABS Ex   ) (ABS (FIX Ex   )))))) )
	(SETQ V8 (ITOA (FIX (* 1000 (- (ABS Ey   ) (ABS (FIX Ey   )))))) )
	(SETQ V9 (ITOA (FIX (* 1000 (- (ABS Ez   ) (ABS (FIX Ez   )))))) )

	(COMMAND
	"COLOR" 5
	"TEXTO" (LIST Tx (- Ty (* 0 1.5 AlT)) Tz) AlT 0 "SUPERFI-CLEBSCH-a-pelo-013"
	"TEXTO" (LIST Tx (- Ty (* 1 1.5 AlT)) Tz) AlT 0 (STRCAT "NPaR = " (ITOA (FIX NPaR)) "," V1 )
	"TEXTO" (LIST Tx (- Ty (* 2 1.5 AlT)) Tz) AlT 0 (STRCAT "RADI  = " (ITOA (FIX RADI )) "," V2 )
	"TEXTO" (LIST Tx (- Ty (* 3 1.5 AlT)) Tz) AlT 0 (STRCAT "NPaZ = " (ITOA (FIX NPaZ)) "," V3 )
	"TEXTO" (LIST Tx (- Ty (* 4 1.5 AlT)) Tz) AlT 0 (STRCAT "ARRz  = " (ITOA (FIX ARRz )) "," V4 )
	"TEXTO" (LIST Tx (- Ty (* 5 1.5 AlT)) Tz) AlT 0 (STRCAT "ABAz  = " (ITOA (FIX ABAz )) "," V5 )
	"TEXTO" (LIST Tx (- Ty (* 6 1.5 AlT)) Tz) AlT 0 (STRCAT "Nps  = " (ITOA (FIX Nps )) "," V6 )
	"TEXTO" (LIST Tx (- Ty (* 7 1.5 AlT)) Tz) AlT 0 (STRCAT "Ex    = " (ITOA (FIX Ex   )) "," V7 )
	"TEXTO" (LIST Tx (- Ty (* 8 1.5 AlT)) Tz) AlT 0 (STRCAT "Ey    = " (ITOA (FIX Ey   )) "," V8 )
	"TEXTO" (LIST Tx (- Ty (* 9 1.5 AlT)) Tz) AlT 0 (STRCAT "Ez    = " (ITOA (FIX Ez   )) "," V9 )
	) ; connand

  	;	(2) DATOS  FIJOS																																							

	(TERPRI) (PROMPT "     ?  N REPET = ") (PRIN1 (/ (* 6 NPaR NPaR NPaZ) 2))  (TERPRI)  (TERPRI)

	;	(3) CALCULOS    LISTA PUNTOS Eje-X y Y       ( LIS-Pxyz)  ( LIS-Pxyz )																					

	(SETQ PaR (/ RADI NPaR ))					; PASO RADIO    
	(SETQ PaZ  (/ (- ARRz ABAz ) NPaZ ))	; PASO ALTURA Z 

	(SETQ NP01 0 )
	(SETQ NP02 0 )
	(SETQ NP12 0 )
	(SETQ NP0  0 )

	;	MALLA EQUILATERA  P0 P1 P2																																				

	(SETQ LIS-Pcapa nil)

	(SETQ Z0 (- ABAz PaZ))
	(REPEAT NPaZ
		(SETQ Z0 (+ Z0 PaZ))								;  Z0 Z0 Z0  

		(SETQ LIS-Pxyz nil)

		(SETQ PPO (LIST     0                           0                       (* Z0 Ez )))
		;(SETQ PP1 (LIST (* RADI Ex (COS (/ PI 3)))  (* RADI Ey (SIN (/ PI 3)))  (* Z0 Ez )))
		;(SETQ PP2 (LIST (* RADI Ex )                    0                       (* Z0 Ez )))
		;(COMMAND "COLOR" 3 "LINEA" PPO PP2 "")												; LIMITES SECTOR CIRCULAR TOTAL (/ PI 3) 
		;(COMMAND "COLOR" 3 "LINEA" PPO PP1 "")		
		;(COMMAND "COLOR" 3 "ARCO" "C" PPO PP2 PP1)	
		(COMMAND "COLOR" 3 "circulo" PPO (* Ex RADI ) )	

		;-----------------------------------------------------------------------------------------------------------------------------------
		;  CORDENADAS PUNTOS MALLA EQUILATERA CIRCULAR EN PLANO  ( P0 P1 P2)																						
		;-----------------------------------------------------------------------------------------------------------------------------------
		;  R0  = NR * PaR             ;  R1  = (NR + 1) * PaR             ;  R2  = R1                                ;        P1          
		;  Ag0 = (PI/(3 * NR)) * NA  ;  Ag1 = (PI/(3 * (NR + 1))) * NA  ;  Ag2 = (PI/(3 * (NR + 1)))*(NA + 1)    ;        /\          
		;                              ;                                    ;                                          ;       /  \         
		;  X0  = R0 * Cos(Ag0)         ;  X1  = R1 * Cos(Ag1)               ;  X2  = R2 * Cos(Ag2)                     ;      /____\        
		;  Y0  = R0 * Sin(Ag0)         ;  Y1  = R1 * Sin(Ag1)               ;  Y2  = R2 * Sin(Ag2)                     ;   P0        P2     
		;-----------------------------------------------------------------------------------------------------------------------------------

		(SETQ NR -1)
		(REPEAT NPaR
			(SETQ NR (+ NR 1))								; NR ( 0 -> ( NPaR + 1 ))  N del RADIO 

			(SETQ R0 (*    NR    PaR))
			(SETQ R1 (* (+ NR 1) PaR))
			(SETQ R2       R1         )

			(SETQ NA -1)
			(REPEAT (+ NR 1)
				(SETQ NA (+ NA 1))							; NA ( 0 -> NR )  N del ANGULO 

				(SETQ NS -1)
				(REPEAT 6
					(SETQ NS (+ NS 1))						; NS ( 0 -> 5 )   N del SECTOR CIRCULAR (/ PI 3)

					(IF (= NR 0) 	(SETQ Ag0 0.0)
          							;(SETQ Ag0 (*   NA (/ PI (* 3 NR )))) )		; Ecuacion-1
          							(SETQ Ag0 (+ (* NA (/ PI (* 3 NR ))) (* NS (/ PI 3)))) )

					;(SETQ Ag1   (* (+ NA 1) (/ PI (* 3 (+ NR 1)))))				; Ecuacion-1
					(SETQ Ag1 (+ (* (+ NA 1) (/ PI (* 3 (+ NR 1)))) (* NS (/ PI 3))))

					;(SETQ Ag2   (*    NA    (/ PI (* 3 (+ NR 1)))))				; Ecuacion-1
					(SETQ Ag2 (+ (*    NA    (/ PI (* 3 (+ NR 1)))) (* NS (/ PI 3))))

					(SETQ X0 (* R0 (COS Ag0)))
					(SETQ Y0 (* R0 (SIN Ag0)))

					(SETQ X1 (* R1 (COS Ag1)))
					(SETQ Y1 (* R1 (SIN Ag1)))

					(SETQ X2 (* R2 (COS Ag2)))
					(SETQ Y2 (* R2 (SIN Ag2)))

					(SETQ P0 (LIST X0  Y0  Z0 ))
					(SETQ P1 (LIST X1  Y1  Z0 ))
					(SETQ P2 (LIST X2  Y2  Z0 ))
					;(COMMAND "COLOR" 1 "LINEA" P0 P1 "")
					;(COMMAND "COLOR" 5 "LINEA" P0 P2 "")
					;(COMMAND "COLOR" 4 "LINEA" P1 P2 "")

					;	VALOR de la FUNCION de CLEBSCH      (VAL-Fun2)    (X Y Z) => Fxyz																			

					(SETQ X nil  Y nil  Z nil  Fxyz nil  F0 nil  X X0   Y Y0   Z Z0 ) (VAL-Fun2) (IF (/= Fxyz nil) (SETQ F0 Fxyz))
					(SETQ X nil  Y nil  Z nil  Fxyz nil  F1 nil  X X1   Y Y1   Z Z0 ) (VAL-Fun2) (IF (/= Fxyz nil) (SETQ F1 Fxyz))
					(SETQ X nil  Y nil  Z nil  Fxyz nil  F2 nil  X X2   Y Y2   Z Z0 ) (VAL-Fun2) (IF (/= Fxyz nil) (SETQ F2 Fxyz))

					;	DOBLE SELECCION + INTERPOLACION LINEAL  (SELEC-INPOLA-XY)    (Fa Fb)     (Xa Xb) => Xs		(Ya Yb) => Ys						

					(IF (AND (/= F0 nil) (/= F1 nil))
              		(PROGN

							(SETQ Fa F0  Fb F1   Xa X0  Xb X1   Ya Y0  Yb Y1   Xs nil  Ys nil )  ;  P0 P1 

							(IF (OR (< Fa 0.0 Fb) (> Fa 0.0 Fb))  (SELEC-INPOLA-XY) ) ;if

							(IF (AND (/= Xs nil) (/= Ys nil))
                	 		(PROGN
									(SETQ P01 (LIST Xs Ys Z0))
									;(COMMAND "COLOR" 1 "PUNTO" P01)
									(SETQ LIS-Pxyz (CONS P01 LIS-Pxyz))		;LISTA PUNTOS P01 
									(SETQ NP01 (+ NP01 1))
					   	)) ;if
					)) ;if

					;	DOBLE SELECCION + INTERPOLACION LINEAL  (SELEC-INPOLA-XY)    (Fa Fb)     (Xa Xb) => Xs												


					(IF (AND (/= F0 nil) (/= F2 nil))
              		(PROGN

							(SETQ Fa F0  Fb F2   Xa X0  Xb X2   Xs nil )  ;  P0 P2 

							(IF (OR (< Fa 0.0 Fb) (> Fa 0.0 Fb))  (SELEC-INPOLA-X) ) ;if

							(IF (AND (/= Xs nil) )
                 			(PROGN
									(SETQ P02 (LIST Xs Y0 Z0))
									;(COMMAND "COLOR" 5 "PUNTO" P02)
									(SETQ LIS-Pxyz (CONS P02 LIS-Pxyz))		;LISTA PUNTOS P02 
									(SETQ NP02 (+ NP02 1))
					  	 )) ;if
					)) ;if

					;	DOBLE SELECCION + INTERPOLACION LINEAL  (SELEC-INPOLA-XY)    (Fa Fb)     (Xa Xb) => Xs		(Ya Yb) => Ys						

					(IF (AND (/= F1 nil) (/= F2 nil))
              		(PROGN

							(SETQ Fa F1  Fb F2  Xa X1  Xb X2   Ya Y1  Yb Y2   Xs nil  Ys nil )  ;  P1 P2 

							(IF (OR (< Fa 0.0 Fb) (> Fa 0.0 Fb))  (SELEC-INPOLA-XY) ) ;if

							(IF (AND (/= Xs nil) (/= Ys nil))
                 			(PROGN
									(SETQ P12 (LIST Xs Ys Z0))
									;(COMMAND "COLOR" 4 "PUNTO" P12)
									(SETQ LIS-Pxyz (CONS P12 LIS-Pxyz))		;LISTA PUNTOS P12 
									(SETQ NP12 (+ NP12 1))
					   	)) ;if
					)) ;if 

				) ; Repe-SS
			) ; Repe-NR
		) ; Repe-NPaR

		;	COMPROBACION																																							
		(IF (= F0 nil)	(PROGN (PROMPT "         @@ Nil  F0  @@ ")  (TERPRI)  (COMMAND "COLOR" 2 "CIRCULO" P0 0.04) ))
		(IF (= F1 nil)	(PROGN (PROMPT "         @@ Nil  F1  @@ ")  (TERPRI)  (COMMAND "COLOR" 2 "CIRCULO" P1 0.06) ))
		(IF (= F2 nil)	(PROGN (PROMPT "         @@ Nil  F2  @@ ")  (TERPRI)  (COMMAND "COLOR" 2 "CIRCULO" P2 0.08) ))

		;	ORDENA   LISTA por PUNTO MAS CERCANO         LIS-Pxyz => (ORDENA) => LIS-PxyOR																	

		(ORDENA)  (SETQ LIS-Pcapa (CONS LIS-PxyOR LIS-Pcapa))							; LIS-Pxyz => (ORDENA) => LIS-PxyOR 

		;	PINTA SECCIONES  ( CURVAS de NIVEL )																															
		(SETQ S1 -1)
		(REPEAT (- (LENGTH LIS-PxyOR) 1)
			(SETQ S1 (+ S1 1))  (SETQ PS1 (NTH S1 LIS-PxyOR))
			(SETQ S2 (+ S1 1))  (SETQ PS2 (NTH S2 LIS-PxyOR))

			(SETQ PS1z (LIST (* (CAR PS1) Ex ) (* (CADR PS1) Ey ) (* (CADDR PS1) Ez )))
			(SETQ PS2z (LIST (* (CAR PS2) Ex ) (* (CADR PS2) Ey ) (* (CADDR PS2) Ez )))

			(COMMAND "COLOR" 7 "LINEA" PS1z PS2z "")		; ( LINEA CURVA de NIVEL ) 

		) ; Repe-LIS-PxyOR

	) ; Repe-NPaZ                                              


	;	(4) INFORMACION																																							
	(TERPRI) (PROMPT "         NR Rojo  = ") (PRIN1 NP01  )
	(TERPRI) (PROMPT "         NR Vert  = ") (PRIN1 NP02  )
	(TERPRI) (PROMPT "         NR Azul  = ") (PRIN1 NP12 )                           	(TERPRI)
	(TERPRI) (PROMPT "        TOTAL NR  = ") (PRIN1 (+ NP01 NP02 NP12))             (TERPRI)
	(TERPRI) (PROMPT "   TOTAL NOrdena  = ") (PRIN1 NP0)                  				(TERPRI)
	;																																													


  	;	(5) PARANDO																																									

	(TERPRI) (PROMPT "         FIN   FIN   FIN   FIN ") (TERPRI)
	(SETVAR "blipmode" 1) (SETVAR "cmdecho" 1)

) ;CIERRE DEFUN     SUPERFI-CLEBSCH-a-pelo-013-MAQUETA-1

;=========================================================================================================================================
