

;==========================================================================================================================================
;																																																																					 
;	 ( CAJAS-CARAS-PLANAS--SPL-ARISTAS-PARES-01 )					(POR INTERSECCION VELTORIAL de 3 PLANOS)                            31/10/2009		 
;																																																																					 
;  DATOS :     SPLINES ARISTAS en PUNTOS-PARES BASE (DEFINE 3PUN PLANOS CARAS)																														 
;              SPLINE COLUMNA-VERTEBRAL DEFINE SECCIONES-NORMALES PLANOS DE CORTE SPLINES ARISTAS																					 
;              PUNTOS-BASE (POLILINEA-3D)     																																														 
;==========================================================================================================================================


;------------------------------------------------------------------------------------------------------------------------------------------
;	PUNTOS-SPLI-DIVIDE   DIVIDE SPLINE ( NomSpl ) con ( Ndivide ) => LISTA PUNTOS ( LIS-PUN-SPL )  									                       
;------------------------------------------------------------------------------------------------------------------------------------------

	(DEFUN PUNTOS-SPLI-DIVIDE ( / )

		(SETQ LIS-PUN-SPL nil)
		(SETQ ALIS  (ENTGET NomSpl))  																								; lista Spline A
		(SETQ AELE  (ASSOC 10 ALIS))  																								; 1 Punto Asociado a 10 (10.punto)
		(SETQ AELES (MEMBER AELE ALIS)) 																							; lista a partir del Alterior (10.punto)....(11.punto)
		(SETQ X-primer (CDR (NTH 0 AELES))) 																					; primer elemento (10.punto)
		(SETQ X-ultimo (CDR (NTH (- (LENGTH AELES) 1) AELES)))												; ultimo elemento (11.punto)
		(COMMAND "COLOR" COLO )																												; COLOR  = A
		;(COMMAND "TEXTO" "MI" X-primer 5.0 0 TEX)																		;  TEXTO = A
		(COMMAND "PUNTO" X-primer)																										; PINTA 1 punto A
		(SETQ N-enti-A1 (ENTLAST))																										; nombre ultima entidad principal 1 punto A
		(COMMAND "DIVIDE" NomSpl Ndivide)																						; GRADUA SPLI-A
		(COMMAND "PUNTO" X-ultimo)																										; PINTA Ultimo Punto A
		;	PUNTOS SECCION-A (PA1-PAn) =>   LIS-PUN-SPL  Lon-LPA													                                                       
		(SETQ LIS-PUN-SPL nil)																												; LISTA  PUNTOS-A
		(SETQ LIS-PUN-SPL (CONS (CDR (ASSOC 10 (ENTGET N-enti-A1))) LIS-PUN-SPL))			; lista entidad -> (1 Punto-A)
		(SETQ W1A T)
		(WHILE W1A
			(SETQ N-enti-A2 (ENTNEXT N-enti-A1))																				; Nombre entidad siguiente
			(COMMAND "BORRA" N-enti-A1 "")																							; BORRA entidad (Punto)
			(IF (= N-enti-A2 nil)  (SETQ W1A nil)
				(PROGN
					(SETQ LIS-PUN-SPL (CONS (CDR (ASSOC 10 (ENTGET N-enti-A2))) LIS-PUN-SPL))
					(SETQ N-enti-A1  N-enti-A2 )
				);progn
			);if
		) ;While W1A
		;	LISTA ( LIS-PUN-SPL ) Ordenada																                                                                       
		(SETQ LIS-PUN-SPL (REVERSE LIS-PUN-SPL ))																			; ( LIS-PUN-SPL Ordenada )

	) ; Defun PUNTOS-SPLI-DIVIDE

;																						                                                                                               


	;========================================================================================================================================
	;	INDICE																																																																 
	;========================================================================================================================================
	;	(00) ARRANCANDO																																																												 
	;	(01) DATOS INTERNOS       Ndivide																												                                             
	; (02) DATOS EXTERNOS														   																																											 
	;	(03) PUNTOS SPLINE-PERFILES  NOMBRE  con  Ndivide  =>  LIS-PUN-SPL => LIS-LIS-P-SLI-PAR-LONGI                     	 	 	 									 
	;	(04) PUNTOS SPLINE COLUM-VERTEBRAL  NOMBRE  con  Ndivide  =>  LIS-P-SLI-EJE-LONGI       	 	 	 											 							 
	; (05) PUNTOS BASE-0   PUNTOS ORDENADOS POLILINEA-3D BASE    =>  LIS-PUN-BASE-INI     																									 
	;----------------------------------------------------------------------------------------------------------------------------------------
	;	(06) PINTA y NUMERA 1PUNTOS de SPLINES PERFILES y COLUMNA-VERTEBRAL       	 	 	 											 							 									 
	; (07) PINTA y NUMERA PUNTOS LIS-PUN-BASE-INI        																																										 
	;----------------------------------------------------------------------------------------------------------------------------------------
	;	(08) LISTAS PUNTOS de SPLINES por SECC-TRANVERSALES      LIS-LIS-P-SLI-PAR-LONGI  =>	 LIS-LIS-P-SLI-PAR-TRANS										   					 
	;	(09) PLANOS NORMALES a COLUMNA-VERTEBRAL                 LIS-P-SLI-EJE-LONGI	=>	LIS-3PUN-PLA-NOR-EJE												 	 
	;----------------------------------------------------------------------------------------------------------------------------------------
	;	(10) PINTA LINEAS o 3DCARAS  BORDE de 3P-PLANOS    ( COMPROBACION )                 	 	 				 																			 
	;----------------------------------------------------------------------------------------------------------------------------------------
	;	(11) PUNTOS-INTER de las SPLINES con PLANOS-NORMALES-COLUMNA    LIS-3PUN-PLA-NOR-EJE + LIS-LIS-P-SLI-PAR-LONGI	=>	LIS-LIS-PsplPAR+PoSECnor	 
	;	(12) AADE  Ps-Prinera-SECC y  Ps-Ultima-SECC a ( LIS-LIS-PsplPAR+PoSECnor )  =>  LIS-LIS-PsplPAR+PoSECnor+ini                 	 	 			 				 
	;----------------------------------------------------------------------------------------------------------------------------------------
	;	(13) PINTA 3DCARAS con PUNTOS de LIS-LIS-PsplPAR+PoSECnor+ini con PRIMERA y ULTIMA SECC    =>	3DCARAS   ( COMPROBACION )           				 
	;----------------------------------------------------------------------------------------------------------------------------------------
	;	(14) PUNTO INTERSECCION de PLANOS-2CARAS con PLANO-SECC     INTER-3-PLANOS (VECTORIAL)                                              	 
	;	 	(14-1)  DETERMINAN PLANO SECCION NSEC  3-PUNTOS(0 1 2) NSEC (1..20) LIS-LIS-PsplPAR+PoSECnor+ini   =>   PLAo PLAx PLAy 							 	 
	;	 	(14-2)  PUNTOS BASE-USO  			Si (= NSEC 1 ) => ( BASE-USO = BASE-0 ) SiNo ( BASE-USO = BASE-INTER )			          							 	 
	;	 	(14-3)  PUNTOS BASE-INTER  	PUN-SECC-INTERSECCION-3PLANOS			=>		LIS-PUN-INTER-BASE																							 
	;----------------------------------------------------------------------------------------------------------------------------------------
	; (15) PINTA 3DC CARAS LATERALES CAJA                                                         																					 
	;	(16) PARANDO																																																													 
	;========================================================================================================================================

	;=======================================================================================================================================
	; FORMACION de CARA-PLANA :   2-PUN SECC-1 (BASE-USO)  +  1/PUN SECC-2 (SPLINES-PERFILES)  +  SECC NORMAL a SPL-COLUMNA-VERTEBRAL				
	;=======================================================================================================================================
	;	(01) DATOS INTERNOS       Ndivide																												                                            
	; (02) DATOS EXTERNOS				SPLINES-PERFILES         --->  (03) LIS-LIS-P-SLI-PAR-LONGI --->  (08) LIS-LIS-P-SLI-PAR-TRANS											
	;                           SPLINE-COLUMNA-VERTEBRAL --->  (04) LIS-P-SLI-EJE-LONGI																									
	;                           POLILINEA-3D-BASE        --->  (05) LIS-PUN-BASE-INI																												
	;---------------------------------------------------------------------------------------------------------------------------------------
	;	(09) PLANOS NORMALES a COLUMNA-VERTEBRAL                 LIS-P-SLI-EJE-LONGI	--->	(09) LIS-3PUN-PLA-NOR-EJE										
	;---------------------------------------------------------------------------------------------------------------------------------------
	;	(11) PUNTOS INTER SPLINES PLANOS-NORMAL-COLUM  + PRI/pSPL + ULT/pSPL  	--->	(11) (12) LIS-LIS-PsplPAR+PoSECnor+ini												
	;---------------------------------------------------------------------------------------------------------------------------------------
	;	(14) PUNTO INTER-3-PLANOS ( CARA1 + CARA2 + SECC )                                                   	 																
	;																																																																				
	;	 	(14-1)  DETERMINAN PLANO SECCION NSEC  3-PUNTOS(0 1 2) NSEC (1..20) LIS-LIS-PsplPAR+PoSECnor+ini   =>   PLAo PLAx PLAy 								
	;																																																																				
	;	 	(14-2)  PUNTOS BASE-USO  			Si (= NSEC 1 ) => ( BASE-USO = BASE-0 ) SiNo ( BASE-USO = BASE-INTER )			          								
	;																																																																				
	;	 	(14-3)  PUNTOS BASE-INTER  	PUN-SECC-INTERSECCION-3PLANOS			=>		LIS-PUN-INTER-BASE																							
	;---------------------------------------------------------------------------------------------------------------------------------------


"#########################################################################################################################################"
;==========================================================================================================================================
;	  *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** 							 
;==========================================================================================================================================
"#########################################################################################################################################"

(DEFUN C:CAJAS-CARAS-PLANAS--SPL-ARISTAS-PARES-01 (/ )

	;========================================================================================================================================
	;	(00) ARRANCANDO																																																												 
	(SETVAR "blipmode" 0) (SETVAR "cmdecho" 0) (GRAPHSCR) (COMMAND "-REFENT" "DES"  "SCP" "U"  "ORTO" "DES")
	(IF (= CAL nil)(COMMAND "ARX" "L" "GEOMCAL.ARX"))			; CARGA CALCULADORA

	;========================================================================================================================================
	;	(01) DATOS INTERNOS       Ndivide																												                                             

	"///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////"
	(SETQ Ndivide  60 )			;  NO mas de  32768  Divisiones 
	"///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////"

	;----------------------------------------------------------------------------------------------------------------------------------------
	; (02) DATOS EXTERNOS														   																																											 

	(TERPRI)
	(PROMPT                       "####################################################################")   (TERPRI)
	(PROMPT                       " ---------------- MARCA SPLINES ARISTAS-PARES en ORDEN ---[ENTER]---")   (TERPRI)
	(SETQ CONJ-SPL-PARES (SSGET))																																											; (SSLENGTH CONJ-SPL-PARES )
	(SETQ NoCOLU     (CAR (ENTSEL " >>>>>>>>>>>>>>>> MARCA SPLINE  EJE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<"))) (TERPRI)	; nombre Spline COLUM-VERTEBRAL
	(SETQ NoPOL-3D-0 (CAR (ENTSEL " >>>>>>>>>>>>>>>> MARCA POLILINEA BASE (3D)(en FASE con SPL) <<<<<<<"))) (TERPRI)	; nombre POLILINEA-3D BASE 
	(PROMPT                       "####################################################################")   (TERPRI)

	;========================================================================================================================================
	;	(03) PUNTOS SPLINE-PARES PERFILES => LIS-LIS-P-SLI-PAR-LONGI                     	 	 	 									 															 

	(SETQ LIS-LIS-P-SLI-PAR-LONGI nil )
	(SETQ N0 -1 )
	(REPEAT (SSLENGTH CONJ-SPL-PARES )																																	; (SSLENGTH CONJ-SPL-PARES ) 2 
		(SETQ N0 (+ N0  1 ))
		(SETQ NomSpl (SSNAME CONJ-SPL-PARES  N0 ))   																										; <Nombre entidad> 
		(SETQ COLO (+ N0 1)  TEX (ITOA (+ N0 1)))
		(PUNTOS-SPLI-DIVIDE) 																																							; => LIS-PUN-SPL 
		(SETQ LIS-LIS-P-SLI-PAR-LONGI (CONS LIS-PUN-SPL   LIS-LIS-P-SLI-PAR-LONGI ))											; (LENGTH LIS-PUN-SPL )   61 
	) ; repe N0

	(SETQ LIS-LIS-P-SLI-PAR-LONGI (REVERSE LIS-LIS-P-SLI-PAR-LONGI ))     															; (LENGTH LIS-LIS-P-SLI-PAR-LONGI ) 2 

	;========================================================================================================================================
	;	(04) PUNTOS SPLINE EJE => LIS-P-SLI-EJE-LONGI                     	 	 	 									 																				 

	(SETQ NomSpl  NoCOLU)   																																						; <Nombre entidad> 
	(PUNTOS-SPLI-DIVIDE) 																																								; => LIS-PUN-SPL 

	(SETQ LIS-P-SLI-EJE-LONGI   LIS-PUN-SPL )																														; (LENGTH LIS-P-SLI-EJE-LONGI ) 61 

	;========================================================================================================================================
	; (05) PUNTOS BASE-0   PUNTOS ORDENADOS POLILINEA-3D BASE    =>   LIS-PUN-BASE-INI     																									 

	(SETQ LIS-PUN-BASE-INI  nil )
	(SETQ LISpO-3D-0 (ENTGET  NoPOL-3D-0 ))
	(SETQ WW1 T )
	(WHILE WW1
		(SETQ NoPOL-3D-1 (ENTNEXT NoPOL-3D-0 ))
		(SETQ LISpO-3D-1 (ENTGET  NoPOL-3D-1 ))
		(SETQ ENDI  (CDR (ASSOC 0 LISpO-3D-1 )))
		(IF (= ENDI "VERTEX" )
			(PROGN
				(SETQ CORD (CDR (ASSOC 10 LISpO-3D-1 )))
				(SETQ LIS-PUN-BASE-INI (CONS CORD  LIS-PUN-BASE-INI ))
				(SETQ NoPOL-3D-0  NoPOL-3D-1 )
			) ; pro
			(PROGN
				(SETQ WW1 nil )
			) ; pro
		) ; if
	) ; WW1

	(SETQ LIS-PUN-BASE-INI (REVERSE LIS-PUN-BASE-INI ))																									; (LENGTH LIS-PUN-BASE-INI ) 4 

	;========================================================================================================================================
	;	(06) PINTA y NUMERA 1PUNTOS de SPLINES PERFILES y COLUMNA-VERTEBRAL       	 	 	 											 							 									 

	(SETQ N1 -1 )
	(REPEAT (LENGTH LIS-LIS-P-SLI-PAR-LONGI )																														; (LENGTH LIS-LIS-P-SLI-PAR-LONGI ) 2 
		(SETQ N1 (+ N1  1 ))
		
		(SETQ P0x  (NTH 0 (NTH N1  LIS-LIS-P-SLI-PAR-LONGI )))

		(COMMAND  "COLOR" 255  "CIRCULO" P0x 0.9   "TEXTO" "MC" P0x 0.8 0 (STRCAT "S" (ITOA (* (+ N1 1 ) 2 ))))

	) ; repe N1

	(SETQ P0c (NTH 0 LIS-P-SLI-EJE-LONGI ))

	(COMMAND    "COLOR" 255  "CIRCULO" P0c 0.9    "TEXTO" "MC" P0c 0.8 0 (STRCAT "S" (ITOA 0 )) )

	;========================================================================================================================================
	; (07) PINTA y NUMERA PUNTOS LIS-PUN-BASE-INI        																																										 

	(SETQ N2 -1 )
	(REPEAT (LENGTH LIS-PUN-BASE-INI )																				; (LENGTH LIS-PUN-BASE-INI ) 4 
		(SETQ N2 (+ N2  1 ))
		(SETQ P0b (NTH N2  LIS-PUN-BASE-INI ))
		(COMMAND  "COLOR"   1  "CIRCULO" P0b 0.4  "TEXTO" "MC" P0b  0.35 0 (STRCAT "V" (ITOA (+ N2 1 ))) )
	) ; repe N2 

			;                                                                                                                                
			;                                                                                                                                
			;                         #D5---------------------#C5                                                                            
			;                        /|                      /|                                                                              
			;                       / #D4                   / #C4                                                                            
			;                      /  |                    /  |          LIS-LIS-P-SLI-PAR-LONGI =>                                          
			;                     /   #D3     |           /   #C3        (LIS-PUN-SP-A  LIS-PUN-SPL-B  LIS-PUN-SPL-C  LIS-PUN-SPL-D ...)     
			;                    /    |       |          /    |                                                                              
			;                   #A5---------------------#B5   #C2                                                                            
			;                   |     |       |         |     |          LIS-P-SLI-EJE-LONGI                                                 
			;                   #A4   #D1     |         #B4   #C1                                                                            
			;                   |     |       |         |     |                                                                              
			;                   #A3   #D0-----|---------#B3---#C0                                                                            
			;                   |    /|       |         |    /|                                                                              
			;                   #A2 / SPL-D   |         #B2 / SPL-C                                                                          
			;                   |  /          |         |  /                                                                                 
			;                   #A1       SPL-COLU      #B1                                                                                  
			;                   |/                      |/                                                                                   
			;                   #A0---------------------#B0                                                                                  
			;                   |                       |                                                                                    
			;                   SPL-A                   SPL-B                                                                                
			;                                                                                                                                

	;========================================================================================================================================
	;	(08) LISTAS PUNTOS de SPLINES por SECC-TRANVERSALES      LIS-LIS-P-SLI-PAR-LONGI  =>	 LIS-LIS-P-SLI-PAR-TRANS										   					 

	(SETQ LIS-LIS-P-SLI-PAR-TRANS nil )    ; LIS-LIS-P-SLI-PAR-TRANS
	(SETQ NPun -1 )
	(REPEAT (LENGTH (NTH 0 LIS-LIS-P-SLI-PAR-LONGI))  																						; N-PUN-SPL  21 FILAS 
		(SETQ NPun (+ NPun 1 ))																																			; 0..12 
		(SETQ LIS-PUN-SECC nil )
		(SETQ NSpl -1 )
		(REPEAT (LENGTH LIS-LIS-P-SLI-PAR-LONGI )																									; N-SPLNES   6 COLUMNAS 
			(SETQ NSpl (+ NSpl 1 ))																																		; 0..5 
			(SETQ PUsIZs (NTH NPun (NTH NSpl  LIS-LIS-P-SLI-PAR-LONGI )))
			(SETQ LIS-PUN-SECC (CONS PUsIZs  LIS-PUN-SECC ))
		) ; repe NSpl
		(SETQ LIS-PUN-SECC (REVERSE LIS-PUN-SECC ))																						; (LENGTH LIS-PUN-SECC ) 6 
		(SETQ LIS-LIS-P-SLI-PAR-TRANS (CONS LIS-PUN-SECC   LIS-LIS-P-SLI-PAR-TRANS ))

	) ; repe NPun

	(SETQ LIS-LIS-P-SLI-PAR-TRANS (REVERSE LIS-LIS-P-SLI-PAR-TRANS ))																; (LENGTH LIS-LIS-P-SLI-PAR-TRANS ) 21 

	;========================================================================================================================================
	;	(09) PLANOS NORMALES a SPLINE EJE                 LIS-P-SLI-EJE-LONGI	=>	LIS-3PUN-PLA-NOR-EJE												 			 					 

	;                                                                
	;                                   O PC3                        
	;                                   |                            
	;                                   |                            
	;                          PmC23    |                            
	;                  CenC O-----O-----O PmC23                      
	;                       |           |                            
	;                       |           |                            
	;                 PnC12 O  PnC2x O  |                            
	;                       |         \ |                            
	;                       |          \|                            
	;          PC1 O--------O-----------O PC2                        
	;                     PmC12        /                             
	;                                 /                              
	;                          PnC2y O                               
	;                                                                

	(SETQ LIS-3PUN-PLA-NOR-EJE nil )
	(SETQ NA -1 )
	(REPEAT (- (LENGTH LIS-P-SLI-EJE-LONGI ) 2 )																											; 61 -2 = 59 
		(SETQ NA (+ NA 1 ))
		(SETQ PC1 (NTH (+ NA 0 ) LIS-P-SLI-EJE-LONGI ))																								; 0..58 
		(SETQ PC2 (NTH (+ NA 1 ) LIS-P-SLI-EJE-LONGI ))																								; 1..59 
		(SETQ PC3 (NTH (+ NA 2 ) LIS-P-SLI-EJE-LONGI ))																								; 2..60 

		(SETQ PnC2y (CAL " PC2 + ( 5 * NOR( PC1 , PC2 , PC3 ))"))																				; PUN EJE/Y    LONGITUD VECTOR # 5 
		(SETQ PmC12 (CAL " PLT( PC1 , PC2 , 0.5 )"))																										; PUN MEDIO 
		(SETQ PmC23 (CAL " PLT( PC2 , PC3 , 0.5 )"))
		(SETQ PnC12 (CAL " PmC12 + NOR( PC1 , PC2 , PnC2y )"))
		(SETQ PnC23 (CAL " PmC23 + NOR( PC2 , PC3 , PnC2y )"))
		(SETQ CenC  (CAL " ILL( PmC12 , PnC12 , PmC23 , PnC23 )"))																			; INTERSECCION 2-LINEAS 
		(SETQ PnC2x (CAL " PC2 + ( 5 * VEC1( PC2 , CenC ))"))																						; PUN EJE/X    LONGITUD VECTOR # 5 
		(SETQ LIS-3PUN-PLA-NOR-EJE (CONS (LIST PC2  PnC2x  PnC2y )  LIS-3PUN-PLA-NOR-EJE ))
	) ; repe NA

	(SETQ LIS-3PUN-PLA-NOR-EJE (REVERSE LIS-3PUN-PLA-NOR-EJE ))																				; (LENGTH LIS-3PUN-PLA-NOR-EJE ) 59 


 (IF  T  (PROGN  ;//////////////////////////  COMPROBACION  ///////////////////////////////////////////////////////////////////////////////
	;========================================================================================================================================
	;	(10) PINTA LINEAS o 3DCARAS  BORDE de 3P-PLANOS    ( COMPROBACION )                 	 	 				 																			 

	;                                                                 
	;                    O B3                                         
	;                B0 /|                                            
	;        B4 O------O------O B2                                    
	;           |     /| |    |                                       
	;           | B1 O | |    |                                       
	;           |    | | |    |                                       
	;           |    | | O A3 |                                       
	;           |    | |/     |                                       
	;        A4 O----|-O------O A2                                    
	;                |/ A0                                            
	;             A1 O                                                
	;                                                                 

	(SETQ NBO -1 )
	(REPEAT (- (LENGTH LIS-3PUN-PLA-NOR-EJE ) 1 )																												; N-PLANOS       48    
		(SETQ NBO (+ NBO 1 ))																																						; 0..18
		(SETQ A0 (NTH 0 (NTH (+ NBO 0 ) LIS-3PUN-PLA-NOR-EJE )))
		(SETQ A1 (NTH 1 (NTH (+ NBO 0 ) LIS-3PUN-PLA-NOR-EJE )))
		(SETQ A2 (NTH 2 (NTH (+ NBO 0 ) LIS-3PUN-PLA-NOR-EJE )))
		;(SETQ A3 (CAL " A0 + VEC( A1 , A0 ) "))
		;(SETQ A4 (CAL " A0 + VEC( A2 , A0 ) "))
		(SETQ B0 (NTH 0 (NTH (+ NBO 1 ) LIS-3PUN-PLA-NOR-EJE )))
		(SETQ B1 (NTH 1 (NTH (+ NBO 1 ) LIS-3PUN-PLA-NOR-EJE )))
		(SETQ B2 (NTH 2 (NTH (+ NBO 1 ) LIS-3PUN-PLA-NOR-EJE )))
		;(SETQ B3 (CAL " B0 + VEC( B1 , B0 ) "))
		;(SETQ B4 (CAL " B0 + VEC( B2 , B0 ) "))
		(COMMAND "COLOR" 255 "LINEA" A0  A1 "" )
		(COMMAND "COLOR" 255 "LINEA" A1  B1 "" )
		(COMMAND "COLOR"   5 "LINEA" A0  A2 "" )
		(COMMAND "COLOR"   5 "LINEA" A2  B2 "" )
		(COMMAND "COLOR"   7 "LINEA" A0  B0 "" )
		(IF (= (+ NBO 1 ) (- (LENGTH LIS-3PUN-PLA-NOR-EJE ) 1 ))
			(PROGN
				(COMMAND "COLOR" 255 "LINEA" B0  B1 "" )
				(COMMAND "COLOR"   5 "LINEA" B0  B2 "" )
			) ; pro
		) ; if
	) ; repe NBO 

 ))  ;IF PROGN  /////////////////////////////  COMPROBACION  //////////////////////////////////////////////////////////////////////////////


	;========================================================================================================================================
	;	(11) PUNTOS-INTERSECCION de las SPLINES con PLANOS-NORMALES-EJE    LIS-3PUN-PLA-NOR-EJE + LIS-LIS-P-SLI-PAR-LONGI	=>	LIS-LIS-PsplPAR+PoSECnor

	(SETQ LIS-LIS-PsplPAR+PoSECnor  nil )

	(SETQ NPLA -1 )    ; (SETQ NPLA 60 )
	(REPEAT (LENGTH LIS-3PUN-PLA-NOR-EJE )																						; N-PLANOS        19 
		(SETQ NPLA (+ NPLA 1 ))																																				; 0..18 

		(SETQ ppO (NTH 0 (NTH NPLA  LIS-3PUN-PLA-NOR-EJE )))																						; PUNTOS PLANO-NOR-COLUMNA 
		(SETQ ppX (NTH 1 (NTH NPLA  LIS-3PUN-PLA-NOR-EJE )))
		(SETQ ppY (NTH 2 (NTH NPLA  LIS-3PUN-PLA-NOR-EJE )))																						; (LIST  PC2  PnC2x  PnC2y ) 

		; (COMMAND "COLOR" 4 "LINEA" ppX ppO ppY "" )

		(SETQ LIS-P-SPL-PAR-SEC-NOR  nil )

		(SETQ NSPL  -1 )
		(REPEAT (LENGTH LIS-LIS-P-SLI-PAR-LONGI )																							; N-SPLINES       2  
			(SETQ NSPL (+ NSPL 1 ))																																			; 0..1  

			(SETQ LIS-INT-1SPL  nil )
			(SETQ NPUN  -1 )
			(REPEAT (- (LENGTH (NTH NSPL  LIS-LIS-P-SLI-PAR-LONGI )) 1 )
				(SETQ NPUN (+ NPUN 1 ))																											; N-PUNTO-SPL   0..59  1..60 

				(SETQ Ps1 (NTH (+ NPUN 0 ) (NTH NSPL  LIS-LIS-P-SLI-PAR-LONGI )))
				(SETQ Ps2 (NTH (+ NPUN 1 ) (NTH NSPL  LIS-LIS-P-SLI-PAR-LONGI )))

				(SETQ PIn12 (CAL " ILP( Ps1 , Ps2 ,  ppO , ppX , ppY )"))																		; INTERSEC LINE PLANO
				(SETQ Dis12 (DISTANCE Ps1   Ps2 ))
				(SETQ Dis1  (DISTANCE PIn12 Ps1 ))
				(SETQ Dis2  (DISTANCE PIn12 Ps2 ))

				(IF (EQUAL Dis12 (+ Dis1 Dis2 ) 0.0001)																											; INTER DENTRO de Ps1 Ps2 
					(PROGN
						(SETQ PunPLA (CAL "PLT( Ps1 , Ps2 , Dis1 / ( Dis1 + Dis2 ))"))													; PUN en LINEA en % 
						(SETQ LIS-INT-1SPL (CONS (LIST PunPLA  ppO )  LIS-INT-1SPL ))
					) ; pro
				) ; if

			) ; repe NPUN


			(COND
				((= (LENGTH LIS-INT-1SPL ) 0 )
					(PROMPT "  ### INTER FUERA de Ps1 Ps2  ERROR? ###") (PROMPT "  NPLA = ") (PRIN1 NPLA ) (PROMPT "  NSPL = ") (PRIN1 NSPL ) (TERPRI)) ; con0 

				((= (LENGTH LIS-INT-1SPL ) 1 )  (SETQ LIS-P-SPL-PAR-SEC-NOR (CONS (LIST PunPLA  ppO ) LIS-P-SPL-PAR-SEC-NOR )))	; con1 

				((= (LENGTH LIS-INT-1SPL ) 2 )

					(SETQ PuPla1 (NTH 0 (NTH 0  LIS-INT-1SPL )))
					(SETQ ppO1   (NTH 1 (NTH 0  LIS-INT-1SPL )))

					(SETQ PuPla2 (NTH 0 (NTH 1  LIS-INT-1SPL )))
					(SETQ ppO2   (NTH 1 (NTH 1  LIS-INT-1SPL )))

					(IF (EQUAL ppO1 ppO2 0.0001)
						(PROGN
							(IF (AND (EQUAL ppO1 ppO2 0.0001) (> (DISTANCE PuPla1 ppO1 ) (DISTANCE PuPla2 ppO1 )))
								(PROGN
									(SETQ LIS-P-SPL-PAR-SEC-NOR (CONS (LIST PuPla2  ppO2 ) LIS-P-SPL-PAR-SEC-NOR ))
								) ; pro
								(PROGN
									(SETQ LIS-P-SPL-PAR-SEC-NOR (CONS (LIST PuPla1  ppO1 ) LIS-P-SPL-PAR-SEC-NOR ))
								) ; pro
							) ; if 
						) ; pro
						(PROGN
							(PROMPT "  ### NO IGUALES ppO1 ppO2  ERROR? ### ") (PRIN1 ppO1 ) (PROMPT " / ") (PRIN1 ppO2 ) (TERPRI)
						) ; pro
					)	; if 
				 ) ; con2 

				((= (LENGTH LIS-INT-1SPL ) 3 ) (PROMPT " =========> 3 INTER en NPLA = ") (PRIN1 NPLA ) (PROMPT "  NSPL = ") (PRIN1 NSPL ) (TERPRI))
				((= (LENGTH LIS-INT-1SPL ) 4 ) (PROMPT " ============> 4 INTER en NPLA = ") (PRIN1 NPLA ) (PROMPT "  NSPL = ") (PRIN1 NSPL ) (TERPRI))
				((= (LENGTH LIS-INT-1SPL ) 5 ) (PROMPT " ===============> 5 INTER en NPLA = ") (PRIN1 NPLA ) (PROMPT "  NSPL = ") (PRIN1 NSPL ) (TERPRI))
			) ; con
			
		) ; repe NSPL

		(SETQ LIS-P-SPL-PAR-SEC-NOR  (REVERSE LIS-P-SPL-PAR-SEC-NOR ))																			; (LENGTH LIS-P-SPL-PAR-SEC-NOR )  
		(SETQ LIS-LIS-PsplPAR+PoSECnor (CONS LIS-P-SPL-PAR-SEC-NOR   LIS-LIS-PsplPAR+PoSECnor ))

	) ; repe NPLA 


	;========================================================================================================================================
	;	(12) AADE  Ps-Prinera-SECC y  Ps-Ultima-SECC a ( LIS-LIS-PsplPAR+PoSECnor )  =>  LIS-LIS-PsplPAR+PoSECnor                 	 	 			 

	(SETQ LIS-P-SEC-00# nil)
	(SETQ LIS-P-SEC-UL# nil)

	(SETQ LIS-P-SEC-00 (NTH 0 LIS-LIS-P-SLI-PAR-TRANS ))																					; PRIMERA SECC (LENGTH LIS-P-SEC-00 ) 2 
	(SETQ LIS-P-SEC-UL (LAST  LIS-LIS-P-SLI-PAR-TRANS ))																					; ULTIMA  SECC (LENGTH LIS-P-SEC-UL ) 2 

	(SETQ P-EJE-00 (NTH 0 LIS-P-SLI-EJE-LONGI ))																									; PRIMERA PUN LIS-P-SLI-EJE-LONGI 
	(SETQ P-EJE-UL (LAST  LIS-P-SLI-EJE-LONGI ))																									; ULTIMA  PUN LIS-P-SLI-EJE-LONGI 

	(SETQ NN -1)
	(REPEAT (LENGTH LIS-P-SEC-00 )
		(SETQ NN (+ NN 1 ))

		(SETQ P-00 (NTH NN LIS-P-SEC-00 ))
		(SETQ P-UL (NTH NN LIS-P-SEC-UL ))

		(SETQ LIS-P-SEC-00# (CONS (LIST P-00 P-EJE-00 ) LIS-P-SEC-00# ))
		(SETQ LIS-P-SEC-UL# (CONS (LIST P-UL P-EJE-00 ) LIS-P-SEC-UL# ))

	) ; repe

	(SETQ LIS-P-SEC-00# (REVERSE LIS-P-SEC-00# ))
	(SETQ LIS-P-SEC-UL# (REVERSE LIS-P-SEC-UL# ))

	(SETQ LIS-LIS-PsplPAR+PoSECnor+ini (CONS LIS-P-SEC-UL#   LIS-LIS-PsplPAR+PoSECnor     ))
	(SETQ LIS-LIS-PsplPAR+PoSECnor+ini (REVERSE              LIS-LIS-PsplPAR+PoSECnor+ini ))			; (LENGTH LIS-LIS-PsplPAR+PoSECnor+ini ) 61 
	(SETQ LIS-LIS-PsplPAR+PoSECnor+ini (CONS LIS-P-SEC-00#   LIS-LIS-PsplPAR+PoSECnor+ini ))			; (((PunPLA  ppO) (PunPLA  ppO).. ).. )


 (IF  T  (PROGN  ;/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	;========================================================================================================================================
	;	(13) PINTA 3DCARAS con PUNTOS de LIS-LIS-PsplPAR+PoSECnor+ini con PRIMERA y ULTIMA SECC    =>	3DCARAS   ( COMPROBACION )           

	(SETQ NE -1 )
	(REPEAT (- (LENGTH LIS-LIS-PsplPAR+PoSECnor+ini ) 1 )	
		(SETQ NE (+ NE 1 ))
		(SETQ LIS-P-SecA (NTH (+ NE 0 ) LIS-LIS-PsplPAR+PoSECnor+ini ))   ; ((PunPLA  ppO) (PunPLA  ppO)..) 
		(SETQ LIS-P-SecB (NTH (+ NE 1 ) LIS-LIS-PsplPAR+PoSECnor+ini ))

		(SETQ NF -1 )
		(REPEAT (LENGTH LIS-P-SecA )
			(SETQ NF (+ NF 1 ))
			(SETQ PSA1 (NTH 0 (NTH (REM (+ NF 0 ) (LENGTH LIS-P-SecA )) LIS-P-SecA )))
			(SETQ PSA2 (NTH 0 (NTH (REM (+ NF 1 ) (LENGTH LIS-P-SecA )) LIS-P-SecA )))

			(SETQ PSB1 (NTH 0 (NTH (REM (+ NF 0 ) (LENGTH LIS-P-SecB )) LIS-P-SecB )))
			(SETQ PSB2 (NTH 0 (NTH (REM (+ NF 1 ) (LENGTH LIS-P-SecB )) LIS-P-SecB )))

	    (COMMAND  "COLOR" 4   "3DCARA" PSA1 PSA2 PSB2 PSB1 "")		; COMPROBACION 

		) ; repe NF 
	) ; repe NE

 ))  ;IF PROGN  /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


	;-------------------------------------------------------------------------------------------------------------------------------------
	;	(14) PUNTO INTERSECCION de PLANOS-2CARAS con PLANO-SECC     INTER-3-PLANOS (VECTORIAL)                                              
	;                                                                                                                                     

	;                                                                                                                                     
	;   3-PUN-BASE ( VER1 VER2 VER3 )    2-PUN-AJUSTE ( PSp12 PSp23 )    3-PUN-PLANO-SECC ( PLAo PLAx PLAy ) => INTERSECCION ( INver2 )   
	;-------------------------------------------------------------------------------------------------------------------------------------
	;                                                                                                                                     
	;                                          O PLAy                                                                                     
	;                                         /                   INTERSECCION de 3-PLANOS                                                
	;                                        /                                      PLANO-CARA-1 ( VER1  VER2  PSp12  )                   
	;                                       O PSp23                                 PLANO-CARA-2 ( VER2  VER3  PSp23  )                   
	;                                      /                    /                   PLANO-SECC-2 ( PLAo PLAx PLAy ) => ( INver2 )         
	;           PLAo        PSp12   PLAx O/                    / VnC1                                                                     
	;             O-----------O----------O <== INver2                                                                                     
	;                                    |                   --- VnC2               ( VER1 VER2 VER3 )  LIS-PUN-BASE-USO                  
	;                                    |    O VER3                                                                                      
	;                                    |   /                 | Vn12               ( PSp12 PSp23 )     LIS-LIS-PsplPAR+PoSECnor+ini      
	;                                    |  /                  |                                                                          
	;                                    | /                                        ( PLAo PLAx PLAy )  LIS-LIS-PsplPAR+PoSECnor+ini      
	;                                    |/                                                                                               
	;        VER1 O----------------------O VER2                                                                                           
	;                                                                                                                                     
	;-------------------------------------------------------------------------------------------------------------------------------------
			;                                                                                          
			;            Psp4                                DISPUSICION ORDENADA  de                  
			;                 O-----------------O                                                      
			;                 | VER4       VER3 |            VERTICES POLILINEA BASE-INICIO ( PARES )  
			;                 |                 |                                                      
			;                 |                 |            PUNTOS DE INICIO SPLINES PARES            
			;                 |                 |                                                      
			;                 |                 |                                                      
			;                 |                 |                                                      
			;                 | VER1       VER2 |                                                      
			;                 O-----------------O                                                      
			;                                     Psp2                                                 
			;                                                                                          

	(SETQ LIS-LIS-PUN-TAPA-CAJAS nil )

	(SETQ TotaSEC (LENGTH LIS-LIS-PsplPAR+PoSECnor+ini ))
	(SETQ TotaVER (LENGTH LIS-PUN-BASE-INI ))

	(SETQ NSEC  0 )
	(REPEAT (- TotaSEC 1 ) 																																					; NSECCION 60 
		(SETQ NSEC (+ NSEC 1 ))		 																																	; NSEC  1..60 

		; (14-1)  DETERMINAN PLANO SECCION NSEC  3-PUNTOS(0 1 2) NSEC (1..20) LIS-LIS-PsplPAR+PoSECnor+ini   =>   PLAo PLAx PLAy 					

		(SETQ PLAo (NTH 1 (NTH 0 (NTH NSEC  LIS-LIS-PsplPAR+PoSECnor+ini ))))												; (((PunPLA  ppO) (PunPLA  ppO).. ).. )
		(SETQ PLAx (NTH 0 (NTH 0 (NTH NSEC  LIS-LIS-PsplPAR+PoSECnor+ini ))))
		(SETQ PLAy (NTH 0 (NTH 1 (NTH NSEC  LIS-LIS-PsplPAR+PoSECnor+ini ))))												; 3 PUN DETERMINAN PLANO SECCION NSEC 
		" ### DOS SPLINES NO DEFINEN PLANO ?????? (PONER ORIGEN) => (LIST PunPLA  ppO )###"

		; (14-2)  PUNTOS BASE-USO  			Si (= NSEC 1 ) => ( BASE-USO = BASE-0 ) SiNo ( BASE-USO = BASE-INTER )			          							

		(IF (= NSEC 1 ) (SETQ LIS-PUN-BASE-USO  LIS-PUN-BASE-INI ) (SETQ LIS-PUN-BASE-USO   LIS-PUN-INTER-BASE ))   ; SECC 0..60 

		; (14-3)  PUNTOS BASE-INTER  	PUN-SECC-INTERSECCION-3PLANOS			=>		LIS-PUN-INTER-BASE																						

		(SETQ LIS-PUN-INTER-BASE  nil )

		(SETQ NVER -1 )
		(REPEAT TotaVER
			(SETQ NVER (+ NVER 1 ))		   																																			; NVER  0..3 

			(SETQ VER1  (NTH (REM (+ NVER 0) TotaVER ) LIS-PUN-BASE-USO )) 				 														; en SECC-0 
			(SETQ VER2  (NTH (REM (+ NVER 1) TotaVER ) LIS-PUN-BASE-USO ))																			; (V1 V2 V3 .. )
			(SETQ VER3  (NTH (REM (+ NVER 2) TotaVER ) LIS-PUN-BASE-USO ))

			(IF (= (REM (+ NVER 1) 2 ) 1 )

				; ## IMPAR = VER1 =>  V1 -- V2 (S2) -- V3    																																												
				(PROGN
					(IF (= (+ NVER 1 ) TotaVER )																																		; SI  NVER es el ULTIMO  
						(PROGN
							(SETQ Psp2 (NTH 0 (NTH (REM (/ (+ NVER 1) 2 ) (/ TotaVER 2 )) (NTH NSEC  LIS-LIS-PsplPAR+PoSECnor+ini ))))	; en SECC-1 
							(SETQ INver2-ULT  Psp2 )	; ?????																																		; NVER ULTIMO => INver2-ULT
						) ; pro
						(PROGN
							(SETQ Psp2 (NTH 0 (NTH (REM (/ (+ NVER 1) 2 ) (/ TotaVER 2 )) (NTH NSEC  LIS-LIS-PsplPAR+PoSECnor+ini ))))	; en SECC-1
							(SETQ LIS-PUN-INTER-BASE (CONS Psp2   LIS-PUN-INTER-BASE ))
						) ; pro
					) ; if
				) ; pro

				; ## PAR = VER1  =>  V2 (S2) -- V3 -- V4 (S4)   																																										
				(PROGN
					(SETQ Psp2 (NTH 0 (NTH (REM (/ (+ NVER 1) 2 ) (/ TotaVER 2 )) (NTH NSEC  LIS-LIS-PsplPAR+PoSECnor+ini ))))	; en SECC-1 (DIVIDIENDO NUMEROS ENTEROS)
					(SETQ Psp4 (NTH 0 (NTH (REM (/ (+ NVER 3) 2 ) (/ TotaVER 2 )) (NTH NSEC  LIS-LIS-PsplPAR+PoSECnor+ini ))))	; (((PunPLA ppO) (PunPLA ppO)..)..)
					(SETQ PSp12 Psp2   PSp23 Psp4 )

					(SETQ VnC1   (CAL "NOR( VER1 , VER2 , PSp12 )"))																											; VECTOR NORMAL a CARA-1 
					(SETQ VnC2   (CAL "NOR( VER2 , VER3 , PSp23 )"))																											; VECTOR NORMAL a CARA-2 
					(SETQ Vn12   (CAL "NOR( VER2 , VER2 + VnC1 , VER2 + VnC2 )"))											 ; VECTOR NORMAL a VECTORES NORMALES a CARA-1 CARA-2 en VER2 
					(SETQ PuU2v  (CAL " VER2 + Vn12 "))																																		; PUNTO de NORMAL en VER2 
					(SETQ INver2 (CAL "ILP( VER2 , PuU2v ,  PLAo , PLAx , PLAy )"))																				; INTERSECCION 3-PLANOS (2-CARAS 1-SECC) 

					(IF (= INver2 nil)
						(PROGN (PROMPT " --- ### MAL ###  INver2 => nil") (PROMPT "  NVER = ") (PRIN1 NVER ) (PROMPT "  NSEC = ") (PRIN1 NSEC ) (TERPRI))	; CONTROL
						(PROGN
							(IF (= (+ NVER 1 ) TotaVER )																																		; SI  NVER es el ULTIMO  
								(PROGN
									(SETQ INver2-ULT  INver2 )																																		; NVER ULTIMO => INver2-ULT
								) ; pro
								(PROGN
								(SETQ LIS-PUN-INTER-BASE (CONS INver2   LIS-PUN-INTER-BASE ))
								) ; pro
							) ; if
						) ; pro
					) ; if
				) ; pro
			) ; if

		) ; repe NVER

		(SETQ LIS-PUN-INTER-BASE     (REVERSE  LIS-PUN-INTER-BASE ))
		(SETQ LIS-PUN-INTER-BASE     (CONS INver2-ULT  LIS-PUN-INTER-BASE ))													; AADE el ULTIMO al PRINCIPIO (POR DESFASE LIS)
		(SETQ LIS-LIS-PUN-TAPA-CAJAS (CONS LIS-PUN-INTER-BASE    LIS-LIS-PUN-TAPA-CAJAS ))


	) ; repe NSEC

	(SETQ LIS-LIS-PUN-TAPA-CAJAS (REVERSE LIS-LIS-PUN-TAPA-CAJAS ))   													  	; (LENGTH LIS-LIS-PUN-TAPA-CAJAS ) 11 
	(SETQ LIS-LIS-PUN-TAPA-CAJAS (CONS LIS-PUN-BASE-INI    LIS-LIS-PUN-TAPA-CAJAS ))


		; PINTA  LIS-LIS-PUN-TAPA-CAJAS  3DCARAS  (COMPROBACION)																																						

		(SETQ NLI1 -1 )
		(REPEAT (LENGTH LIS-LIS-PUN-TAPA-CAJAS )
			(SETQ NLI1 (+ NLI1 1 ))		   																															; NLI1  0..60 

			(SETQ LIS-PUN-TAPA  (NTH NLI1  LIS-LIS-PUN-TAPA-CAJAS )) 

			(SETQ NPU1 -1 )
			(REPEAT (/ (LENGTH LIS-PUN-TAPA ) 4 )
				(SETQ NPU1 (+ NPU1 1 ))		   																														; NPU1  0..3 

				(SETQ PU-1 (NTH (REM (+ NPU1 0) (LENGTH LIS-PUN-TAPA )) LIS-PUN-TAPA )) 
				(SETQ PU-2 (NTH (REM (+ NPU1 1) (LENGTH LIS-PUN-TAPA )) LIS-PUN-TAPA )) 
				(SETQ PU-3 (NTH (REM (+ NPU1 2) (LENGTH LIS-PUN-TAPA )) LIS-PUN-TAPA )) 
				(SETQ PU-4 (NTH (REM (+ NPU1 3) (LENGTH LIS-PUN-TAPA )) LIS-PUN-TAPA )) 

				(SETQ COLO1 (+ (REM NLI1 5 ) 1))
				(COMMAND "COLOR" COLO1   "3DCARA" PU-1  PU-2 PU-3  PU-4 "" )

			) ; repe NPU1
		) ; repe NLI1

		;	(COMPROBACION)																																																										






 (IF  T  (PROGN  "##########################################################################################################################################"

	;---------------------------------------------------------------------------------------------------------------------------------------
	; (15) PINTA 3DC CARAS LATERALES CAJA                                                         																					

	(SETQ N10 -1 )
	(REPEAT (LENGTH (NTH 0 LIS-LIS-PUN-TAPA-CAJAS ))
		(SETQ N10 (+ N10 1 ))

		(SETQ KK1 (LIST (* 40 (+ N10 1 )) -50.0  0.0 ))																	; PUNTOS ARRAN PATRONES 
		(SETQ KK2 (LIST (* 41 (+ N10 1 )) -50.0  0.0 ))

		(SETQ N11 -1 )
		(REPEAT (- (LENGTH LIS-LIS-PUN-TAPA-CAJAS ) 1 )
			(SETQ N11 (+ N11 1 ))

			(SETQ LIS-P-TAPA-A (NTH (+ N11 0) LIS-LIS-PUN-TAPA-CAJAS ))
			(SETQ LIS-P-TAPA-B (NTH (+ N11 1) LIS-LIS-PUN-TAPA-CAJAS ))


			(SETQ PA1 (NTH (REM (+ N10 0) (LENGTH LIS-P-TAPA-A )) LIS-P-TAPA-A ))        	;      KK1                     KK2   
			(SETQ PA2 (NTH (REM (+ N10 1) (LENGTH LIS-P-TAPA-A )) LIS-P-TAPA-A ))	      	;      PB1 O-----------------O PB2   
                                                                                    	;          |     3D Cara     |       
			(SETQ PB1 (NTH (REM (+ N10 0) (LENGTH LIS-P-TAPA-B )) LIS-P-TAPA-B ))        	;          |                 |       
			(SETQ PB2 (NTH (REM (+ N10 1) (LENGTH LIS-P-TAPA-B )) LIS-P-TAPA-B ))        	;      PA1 O-----------------O PA2   

			"==( 3D )====================================================================================================================="
			"-----------------------------------------------------------------------------------------------------------------------------"
			(COMMAND "COLOR" 255 "3DCARA" PA1 PA2 PB2 PB1 "" )																														; 3DCARA-3D

			(COMMAND "SCP" "3P" PA1 PA2 PB1 )																																							; PLANO-3DC ( 3D ) 
				(SETQ PA1p (LIST 0.0 0.0 0.0))
				(SETQ PA2p (TRANS PA2 0 1 ))
				(SETQ PB1p (TRANS PB1 0 1 ))
				(SETQ PB2p (TRANS PB2 0 1 ))
				"----------------------------------------------------------------------------------------------------------------------------"
		;		(COMMAND "COLOR" 1  "TEXTO"  (LIST 0.42 0.18)  0.42  0  (STRCAT (ITOA (+ N10 1 )) "/" (ITOA (+ N11 1 ))))		; TEXTO-3D 
   		(COMMAND "SCP" "U")

			"==( 2D )======================================================================================================================"
			(COMMAND "SCP" "3P" KK1 KK2 "" )																																							; PLANO-3DC ( 2D ) PATRONES
				"----------------------------------------------------------------------------------------------------------------------------"
				(COMMAND "COLOR" 7   "3DCARA" PA1p  PA2p  PB2p  PB1p "")																										; 3DCARA-2D
				(SETQ PB1pU (TRANS PB1p 1 0 ))
				(SETQ PB2pU (TRANS PB2p 1 0 ))
				(SETQ KK1 PB1pU )
				(SETQ KK2 PB2pU )
				"----------------------------------------------------------------------------------------------------------------------------"
		;		(COMMAND "COLOR" 1  "TEXTO"  (LIST 0.42 0.18)  0.42  0  (STRCAT (ITOA (+ N10 1 )) "/" (ITOA (+ N11 1 ))))		; TEXTO-2D 
   		(COMMAND "SCP" "U")

		) ; repe N11
	) ; repe N10


 ))  "IF PROGN  #######################################################################################################################################"




	;	(16) PARANDO																																																												
	(SETVAR "blipmode" 1) (SETVAR "cmdecho" 1)

) ;CIERRE DEFUN  CAJAS-CARAS-PLANAS--SPL-ARISTAS-PARES-01

;=======================================================================================================================================


