
;==========================================================================================================================================
;																																																																					 
;	 ( CAJAS-CARAS-PLANAS--SPL-ARISTAS-PARES-02 )					(POR INTERSECCION VELTORIAL de 3 PLANOS)                            04/11/2009		 
;																																																																					 
;  DATOS :     SPLINES ARISTAS en PUNTOS-PARES BASE (DEFINE 3PUN PLANOS CARAS)																														 
;              SPLINE COLUMNA-VERTEBRAL DEFINE SECCIONES-NORMALES PLANOS DE CORTE SPLINES ARISTAS																					 
;              PUNTOS-BASE (POLILINEA-3D)     																																														 
;==========================================================================================================================================


;------------------------------------------------------------------------------------------------------------------------------------------
;	PUNTOS-SPLI-DIVIDE   DIVIDE SPLINE ( NomSpl ) con ( Ndivide ) => LISTA PUNTOS ( LIS-PUN-SPL )  									                       
;------------------------------------------------------------------------------------------------------------------------------------------

	(DEFUN PUNTOS-SPLI-DIVIDE ( / )

		(SETQ LIS-PUN-SPL nil)
		(SETQ ALIS  (ENTGET NomSpl))  																								; lista Spline A
		(SETQ AELE  (ASSOC 10 ALIS))  																								; 1 Punto Asociado a 10 (10.punto)
		(SETQ AELES (MEMBER AELE ALIS)) 																							; lista a partir del Alterior (10.punto)....(11.punto)
		(SETQ X-primer (CDR (NTH 0 AELES))) 																					; primer elemento (10.punto)
		(SETQ X-ultimo (CDR (NTH (- (LENGTH AELES) 1) AELES)))												; ultimo elemento (11.punto)
		(COMMAND "PUNTO" X-primer)																										; PINTA 1 punto A
		(SETQ N-enti-A1 (ENTLAST))																										; nombre ultima entidad principal 1 punto A
		(COMMAND "DIVIDE" NomSpl Ndivide)																						; GRADUA SPLI-A
		(COMMAND "PUNTO" X-ultimo)																										; PINTA Ultimo Punto A
		;	PUNTOS SECCION-A (PA1-PAn) =>   LIS-PUN-SPL  Lon-LPA													                                                       
		(SETQ LIS-PUN-SPL (CONS (CDR (ASSOC 10 (ENTGET N-enti-A1))) LIS-PUN-SPL))			; lista entidad -> (1 Punto-A)
		(SETQ W1A T)
		(WHILE W1A
			(SETQ N-enti-A2 (ENTNEXT N-enti-A1))																				; Nombre entidad siguiente
			(COMMAND "BORRA" N-enti-A1 "")																							; BORRA entidad (Punto)
			(IF (= N-enti-A2 nil)  (SETQ W1A nil)
				(PROGN
					(SETQ LIS-PUN-SPL (CONS (CDR (ASSOC 10 (ENTGET N-enti-A2))) LIS-PUN-SPL))
					(SETQ N-enti-A1  N-enti-A2 )
				);progn
			);if
		) ;While W1A
		;	LISTA ( LIS-PUN-SPL ) Ordenada																                                                                       
		(SETQ LIS-PUN-SPL (REVERSE LIS-PUN-SPL ))																			; ( LIS-PUN-SPL Ordenada )

	) ; Defun PUNTOS-SPLI-DIVIDE

;																						                                                                                               


;------------------------------------------------------------------------------------------------------------------------------------------
;	PINTA PUN  # LIS-LIS-P-SLI-PAR-LONGI  # LIS-P-SLI-EJE-LONGI  # LIS-PUN-BASE-INI   									                       							 
;------------------------------------------------------------------------------------------------------------------------------------------

(DEFUN PINTA-PUN-SPLINES ( / )

	;========================================================================================================================================
	;	(06) PINTA PUN      LIS-LIS-P-SLI-PAR-LONGI 										       	 	 	 											 							 									 		 

	(SETQ N1 -1 )
	(REPEAT (LENGTH LIS-LIS-P-SLI-PAR-LONGI )																														; (LENGTH LIS-LIS-P-SLI-PAR-LONGI ) 3 
		(SETQ N1 (+ N1  1 ))
		(SETQ LIS-P-SLI-PAR-L (NTH N1  LIS-LIS-P-SLI-PAR-LONGI ))																				; (LENGTH LIS-P-SLI-PAR-L ) 63 
		(SETQ N2 -1 )
		(REPEAT (LENGTH LIS-P-SLI-PAR-L )
			(SETQ N2 (+ N2  1 ))
			(SETQ P0a (NTH N2  LIS-P-SLI-PAR-L ))
			(COMMAND  "COLOR" 5  "CIRCULO" P0a 1.2   "TEXTO" "MC" P0a 0.8 0 (STRCAT "S" (ITOA (+ N2 1 ))))
		) ; repe N2
	) ; repe N1

	;========================================================================================================================================
	;	(06) PINTA PUN      LIS-P-SLI-EJE-LONGI       	 	 	 											 							 									 												 		 
	(SETQ N3 -1 )
	(REPEAT (LENGTH LIS-P-SLI-EJE-LONGI )																				; (LENGTH LIS-P-SLI-EJE-LONGI ) 63 
		(SETQ N3 (+ N3  1 ))
		(SETQ P0b (NTH N3  LIS-P-SLI-EJE-LONGI ))
		(COMMAND   "COLOR" 7  "CIRCULO" P0b 1.2    "TEXTO" "MC" P0b 0.8 0 (STRCAT "S" (ITOA (+ N3 1 ))))
	) ; repe N3 

	;========================================================================================================================================
	; (06) PINTA PUN    LIS-PUN-BASE-INI        																																								 						 
	(SETQ N4 -1 )
	(REPEAT (LENGTH LIS-PUN-BASE-INI )																				; (LENGTH LIS-PUN-BASE-INI ) 6 
		(SETQ N4 (+ N4  1 ))
		(SETQ P0c (NTH N4  LIS-PUN-BASE-INI ))
		(COMMAND  "COLOR" 1  "CIRCULO" P0c 1.2  "TEXTO" "MC" P0c  0.8 0 (STRCAT "V" (ITOA (+ N4 1 ))))
	) ; repe N4 

) ; Defun 	PINTA-PUN-SPLINES

;																						                                                                                               


	;========================================================================================================================================
	;	(10) PINTA LINEAS   BORDE de 3P-PLANOS    ( COMPROBACION )                 	 	 				 																			 					 
	;========================================================================================================================================
	;                                                                 
	;                    O B3                                         
	;                B0 /|                                            
	;        B4 O------O------O B2                                    
	;           |     /| |    |                                       
	;           | B1 O | |    |                                       
	;           |    | | |    |                                       
	;           |    | | O A3 |                                       
	;           |    | |/     |                                       
	;        A4 O----|-O------O A2                                    
	;                |/ A0                                            
	;             A1 O                                                
	;                                                                 

(DEFUN PINTA-LINE-P3-PLANO ( / )

	(SETQ NBO -1 )
	(REPEAT (- (LENGTH LIS-3PUN-PLA-NOR-EJE ) 1 )																												; N-PLANOS       48    
		(SETQ NBO (+ NBO 1 ))																																						; 0..18
		(SETQ A0 (NTH 0 (NTH (+ NBO 0 ) LIS-3PUN-PLA-NOR-EJE )))
		(SETQ A1 (NTH 1 (NTH (+ NBO 0 ) LIS-3PUN-PLA-NOR-EJE )))
		(SETQ A2 (NTH 2 (NTH (+ NBO 0 ) LIS-3PUN-PLA-NOR-EJE )))
		;(SETQ A3 (CAL " A0 + VEC( A1 , A0 ) "))
		;(SETQ A4 (CAL " A0 + VEC( A2 , A0 ) "))
		(SETQ B0 (NTH 0 (NTH (+ NBO 1 ) LIS-3PUN-PLA-NOR-EJE )))
		(SETQ B1 (NTH 1 (NTH (+ NBO 1 ) LIS-3PUN-PLA-NOR-EJE )))
		(SETQ B2 (NTH 2 (NTH (+ NBO 1 ) LIS-3PUN-PLA-NOR-EJE )))
		;(SETQ B3 (CAL " B0 + VEC( B1 , B0 ) "))
		;(SETQ B4 (CAL " B0 + VEC( B2 , B0 ) "))
		(COMMAND "COLOR" 255 "LINEA" A0  A1 "" )
		(COMMAND "COLOR" 255 "LINEA" A1  B1 "" )
		(COMMAND "COLOR"   5 "LINEA" A0  A2 "" )
		(COMMAND "COLOR"   5 "LINEA" A2  B2 "" )
		(COMMAND "COLOR"   7 "LINEA" A0  B0 "" )
		(IF (= (+ NBO 1 ) (- (LENGTH LIS-3PUN-PLA-NOR-EJE ) 1 ))
			(PROGN
				(COMMAND "COLOR" 255 "LINEA" B0  B1 "" )
				(COMMAND "COLOR"   5 "LINEA" B0  B2 "" )
			) ; pro
		) ; if
	) ; repe NBO 

) ; Defun 	PINTA-LINE-P3-PLANO

;																						                                                                                               


	;========================================================================================================================================
	;	(11) PINTA 3DCARAS con PUNTOS de LIS-LIS-PuIN-SPL-PAR-SEC-NOR 																															           

(DEFUN PINTA-3DC-PuIN-SPL-PAR-SEC-NOR ( / )

	(SETQ NE -1 )
	(REPEAT (- (LENGTH LIS-LIS-PuIN-SPL-PAR-SEC-NOR ) 1 )   						; 61 - 1 = 60  
		(SETQ NE (+ NE 1 ))

		(SETQ LIS-P-SecA (NTH (+ NE 0 ) LIS-LIS-PuIN-SPL-PAR-SEC-NOR ))  ; ("#" (134.699 -22.1252 95.237) "#" (116.699 7.83137 72.729) "#" (125.297 14.3118 112.883))
		(SETQ LIS-P-SecB (NTH (+ NE 1 ) LIS-LIS-PuIN-SPL-PAR-SEC-NOR ))

		(IF (= (REM (+ NE 1 ) 5 ) 0 ) (SETQ COL1 5 ) (SETQ COL1 (REM (+ NE 1 ) 5 )))

		(SETQ NF -1 )
		(REPEAT (LENGTH LIS-P-SecA )																			; 6 
			(SETQ NF (+ NF 2 ))

			(SETQ PSA1 (NTH (REM (+ NF 0 ) (LENGTH LIS-P-SecA )) LIS-P-SecA ))
			(SETQ PSA2 (NTH (REM (+ NF 2 ) (LENGTH LIS-P-SecA )) LIS-P-SecA ))

			(SETQ PSB1 (NTH (REM (+ NF 0 ) (LENGTH LIS-P-SecB )) LIS-P-SecB ))
			(SETQ PSB2 (NTH (REM (+ NF 2 ) (LENGTH LIS-P-SecB )) LIS-P-SecB ))

	    (COMMAND  "COLOR" COL1   "3DCARA" PSA1 PSA2 PSB2 PSB1 "")		; COMPROBACION 

		) ; repe NF 
	) ; repe NE

) ; Defun 	PINTA-3DC-PuIN-SPL-PAR-SEC-NOR

;																						                                                                                               








"#########################################################################################################################################"
;==========================================================================================================================================
;	  *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** 							 
;==========================================================================================================================================
"#########################################################################################################################################"

(DEFUN C:CAJAS-CARAS-PLANAS--SPL-ARISTAS-PARES-02 (/ )

	;========================================================================================================================================
	;	(00) ARRANCANDO																																																												 
	(SETVAR "blipmode" 0) (SETVAR "cmdecho" 0) (GRAPHSCR) (COMMAND "-REFENT" "DES"  "SCP" "U"  "ORTO" "DES")
	(IF (= CAL nil)(COMMAND "ARX" "L" "GEOMCAL.ARX"))			; CARGA CALCULADORA

	;========================================================================================================================================
	;	(01) DATOS INTERNOS       Ndivide																												                                             

	"///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////"
	(SETQ Ndivide  80 )			;  NO mas de  32768  Divisiones 
	"///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////"

	;----------------------------------------------------------------------------------------------------------------------------------------
	; (02) DATOS EXTERNOS														   																																											 

	(TERPRI)
	(PROMPT                       "####################################################################")   (TERPRI)
	(PROMPT                       " ---------------- MARCA SPLINES ARISTAS-PARES en ORDEN ---[ENTER]---")   (TERPRI)
	(SETQ CONJ-SPL-PARES (SSGET))																																											; (SSLENGTH CONJ-SPL-PARES )
	(SETQ NoCOLU     (CAR (ENTSEL " >>>>>>>>>>>>>>>> MARCA SPLINE  EJE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<"))) (TERPRI)	; nombre Spline COLUM-VERTEBRAL
	(SETQ NoPOL-3D-0 (CAR (ENTSEL " >>>>>>>>> MARCA ### POLILINEA-3D ### BASE (en FASE con SPL) <<<<<<<"))) (TERPRI)	; nombre POLILINEA-3D BASE 
	(PROMPT                       "####################################################################")   (TERPRI)


	;========================================================================================================================================
	;	(03) PUNTOS SPLINE-PARES PERFILES => LIS-LIS-P-SLI-PAR-LONGI                     	 	 	 									 															 
	(SETQ LIS-LIS-P-SLI-PAR-LONGI nil )
	(SETQ N0 -1 )
	(REPEAT (SSLENGTH CONJ-SPL-PARES )																																; (SSLENGTH CONJ-SPL-PARES ) 3 
		(SETQ N0 (+ N0  1 ))
		(SETQ NomSpl (SSNAME CONJ-SPL-PARES  N0 ))   																									; <Nombre entidad> 
		(PUNTOS-SPLI-DIVIDE) 																																						; => LIS-PUN-SPL
		(SETQ LIS-P-SLI-PAR-L   LIS-PUN-SPL )																														; (LENGTH LIS-P-SLI-PAR-L ) 61 
		;	(03) AADE PUN TANG EXTREMOS a LIS-PUN-SPL                      	 	 	 									 																						 
		(SETQ LIS-SPLI (ENTGET NomSpl))																						; Lista de Spline 
		(SETQ LIS>10 (MEMBER (ASSOC 10 LIS-SPLI ) LIS-SPLI ))											; 10 PUN APOYO = lista a partir del elemento 10 (incluido)  
		(SETQ NP-APOYO (CDR (ASSOC 73 LIS-SPLI )))                         			; 73 NPUNTOS AJUSTE 	; AYUDAS = SPLINE (cdigos de grupo)   
		(SETQ LIS-PUN-APOYO  nil )
		(SETQ NAP -1 )
		(REPEAT NP-APOYO
			(SETQ NAP (+ NAP  1 ))
			(SETQ P-AP (CDR (NTH NAP  LIS>10 )))
			(SETQ LIS-PUN-APOYO (CONS P-AP  LIS-PUN-APOYO ))
		) ; repe
		(SETQ LIS-PUN-APOYO (REVERSE LIS-PUN-APOYO ))											 															; LISTA de PUNTOS de APOYO de SPLINE
		(SETQ T1ini (NTH        0                       LIS-PUN-APOYO ))																; PUNTOS TANGENTES INICIO 
		(SETQ T2ini (NTH        1                       LIS-PUN-APOYO ))
		(SETQ T2fin (NTH (- (LENGTH LIS-PUN-APOYO ) 2 ) LIS-PUN-APOYO ))																; PUNTOS TANGENTES FINAL 
		(SETQ T1fin (NTH (- (LENGTH LIS-PUN-APOYO ) 1 ) LIS-PUN-APOYO ))
		(SETQ PTini (CAL " T1ini + VEC( T2ini , T1ini )"))																							; PUN TAG INI 
		(SETQ PTfin (CAL " T1fin + VEC( T2fin , T1fin )"))																							; PUN TAG FIN 
		(SETQ LIS-P-SLI-PAR-L  (REVERSE     LIS-P-SLI-PAR-L  ))
		(SETQ LIS-P-SLI-PAR-L+ (CONS PTfin  LIS-P-SLI-PAR-L  ))																					; (LENGTH LIS-P-SLI-PAR-L  ) 61 
		(SETQ LIS-P-SLI-PAR-L+ (REVERSE     LIS-P-SLI-PAR-L+ ))
		(SETQ LIS-P-SLI-PAR-L+ (CONS PTini  LIS-P-SLI-PAR-L+ ))																					; (LENGTH LIS-P-SLI-PAR-L+ ) 63 
		(SETQ LIS-LIS-P-SLI-PAR-LONGI (CONS LIS-P-SLI-PAR-L+  LIS-LIS-P-SLI-PAR-LONGI ))
	) ; repe N0
	(SETQ LIS-LIS-P-SLI-PAR-LONGI (REVERSE LIS-LIS-P-SLI-PAR-LONGI ))     														; (LENGTH LIS-LIS-P-SLI-PAR-LONGI )          3 

	;========================================================================================================================================
	;	(04) PUNTOS SPLINE EJE => LIS-P-SLI-EJE-LONGI                     	 	 	 									 																				 		 
	(SETQ NomSpl  NoCOLU)   																																					; <Nombre entidad> 
	(PUNTOS-SPLI-DIVIDE) 																																							; => LIS-PUN-SPL 
	(SETQ LIS-P-SLI-EJE-L   LIS-PUN-SPL )																															; (LENGTH LIS-P-SLI-EJE-L ) 61 
	;	(04) AADE PUN TANG EXTREMOS a LIS-P-SLI-EJE-LONGI												                     	 	 	 									 								 
	(SETQ LIS-SPLI (ENTGET NomSpl))																							; Lista de Spline 
	(SETQ LIS>10 (MEMBER (ASSOC 10 LIS-SPLI ) LIS-SPLI ))												; 10 PUN APOYO = lista a partir del elemento 10 (incluido)  
	(SETQ NP-APOYO (CDR (ASSOC 73 LIS-SPLI )))                        					; 73 NPUNTOS AJUSTE 	; AYUDAS = SPLINE (cdigos de grupo)   
	(SETQ LIS-PUN-APOYO  nil )
	(SETQ NAP -1 )
	(REPEAT NP-APOYO
		(SETQ NAP (+ NAP  1 ))
		(SETQ P-AP (CDR (NTH NAP  LIS>10 )))
		(SETQ LIS-PUN-APOYO (CONS P-AP  LIS-PUN-APOYO ))
	) ; repe
	(SETQ LIS-PUN-APOYO (REVERSE LIS-PUN-APOYO ))											 															; LISTA de PUNTOS de APOYO de SPLINE
	(SETQ T1ini (NTH        0                       LIS-PUN-APOYO ))																; PUNTOS TANGENTES INICIO 
	(SETQ T2ini (NTH        1                       LIS-PUN-APOYO ))
	(SETQ T2fin (NTH (- (LENGTH LIS-PUN-APOYO ) 2 ) LIS-PUN-APOYO ))																; PUNTOS TANGENTES FINAL 
	(SETQ T1fin (NTH (- (LENGTH LIS-PUN-APOYO ) 1 ) LIS-PUN-APOYO ))
	(SETQ PTini (CAL " T1ini + VEC( T2ini , T1ini )"))																							; PUN TAG INI 
	(SETQ PTfin (CAL " T1fin + VEC( T2fin , T1fin )"))																							; PUN TAG FIN 
	(SETQ LIS-P-SLI-EJE-L     (REVERSE     LIS-P-SLI-EJE-L     ))
	(SETQ LIS-P-SLI-EJE-LONGI (CONS PTfin  LIS-P-SLI-EJE-L     ))
	(SETQ LIS-P-SLI-EJE-LONGI (REVERSE     LIS-P-SLI-EJE-LONGI ))
	(SETQ LIS-P-SLI-EJE-LONGI (CONS PTini  LIS-P-SLI-EJE-LONGI ))																		; (LENGTH LIS-P-SLI-EJE-LONGI ) 63 

	;========================================================================================================================================
	; (05) PUNTOS BASE-0   PUNTOS ORDENADOS ### POLILINEA-3D ### BASE    =>   LIS-PUN-BASE-INI     																					 
	(SETQ LIS-PUN-BASE-INI  nil )
	(SETQ LISpO-3D-0 (ENTGET  NoPOL-3D-0 ))
	(SETQ WW1 T )
	(WHILE WW1
		(SETQ NoPOL-3D-1 (ENTNEXT NoPOL-3D-0 ))
		(SETQ LISpO-3D-1 (ENTGET  NoPOL-3D-1 ))
		(SETQ ENDI  (CDR (ASSOC 0 LISpO-3D-1 )))
		(IF (= ENDI "VERTEX" )
			(PROGN
				(SETQ CORD (CDR (ASSOC 10 LISpO-3D-1 )))
				(SETQ LIS-PUN-BASE-INI (CONS CORD  LIS-PUN-BASE-INI ))
				(SETQ NoPOL-3D-0  NoPOL-3D-1 )
			) ; pro
			(PROGN
				(SETQ WW1 nil )
			) ; pro
		) ; if
	) ; WW1
	(SETQ LIS-PUN-BASE-INI (REVERSE LIS-PUN-BASE-INI ))																									; (LENGTH LIS-PUN-BASE-INI ) 6 


	; PINTA =================================================================================================================================
		;			(PINTA-PUN-SPLINES) 		; PINTA PUN  # LIS-LIS-P-SLI-PAR-LONGI  # LIS-P-SLI-EJE-LONGI  # LIS-PUN-BASE-INI 											 
	;========================================================================================================================================


	;========================================================================================================================================
	;	(08) LISTAS PUNTOS de SPLINES por SECC-TRANVERSALES      LIS-LIS-P-SLI-PAR-LONGI  =>	 LIS-LIS-P-SLI-PAR-TRANS										   	 
	;========================================================================================================================================
	;                                                                                                                                
	;                                                                                                                                
	;                         #D5---------------------#C5                                                                            
	;                        /|                      /|                                                                              
	;                       / #D4                   / #C4                                                                            
	;                      /  |                    /  |           LIS-LIS-P-SLI-PAR-LONGI =>                                         
	;                     /   #D3     |           /   #C3        (LIS-PUN-SP-A  LIS-PUN-SPL-B  LIS-PUN-SPL-C  LIS-PUN-SPL-D ...)     
	;                    /    |       |          /    |                                                                              
	;                   #A5---------------------#B5   #C2                                                                            
	;                   |     |       |         |     |          LIS-P-SLI-EJE-LONGI                                                 
	;                   #A4   #D1     |         #B4   #C1                                                                            
	;                   |     |       |         |     |                                                                              
	;                   #A3   #D0-----|---------#B3---#C0                                                                            
	;                   |    /|       |         |    /|                                                                              
	;                   #A2 / SPL-D   |         #B2 / SPL-C                                                                          
	;                   |  /          |         |  /                                                                                 
	;                   #A1       SPL-COLU      #B1                                                                                  
	;                   |/                      |/                                                                                   
	;                   #A0---------------------#B0                                                                                  
	;                   |                       |                                                                                    
	;                   SPL-A                   SPL-B                                                                                
	;                                                                                                                                

	(SETQ LIS-LIS-P-SLI-PAR-TRANS nil )
	(SETQ NPun -1 )
	(REPEAT (LENGTH (NTH 0 LIS-LIS-P-SLI-PAR-LONGI))  																			; N-PUN-SPL  63 
		(SETQ NPun (+ NPun 1 ))																															; 0..62            61 ????
		(SETQ LIS-PUN-SECC nil )
		(SETQ NSpl -1 )
		(REPEAT (LENGTH LIS-LIS-P-SLI-PAR-LONGI )																							; N-SPLNES    3 
			(SETQ NSpl (+ NSpl 1 ))																														; 0..2 
			(SETQ PUsIZs (NTH NPun (NTH NSpl  LIS-LIS-P-SLI-PAR-LONGI )))
			(SETQ LIS-PUN-SECC (CONS PUsIZs  LIS-PUN-SECC ))
		) ; repe NSpl
		(SETQ LIS-PUN-SECC (REVERSE LIS-PUN-SECC ))																						; (LENGTH LIS-PUN-SECC ) 6 
		(SETQ LIS-LIS-P-SLI-PAR-TRANS (CONS LIS-PUN-SECC   LIS-LIS-P-SLI-PAR-TRANS ))
	) ; repe NPun

	(SETQ LIS-LIS-P-SLI-PAR-TRANS (REVERSE LIS-LIS-P-SLI-PAR-TRANS ))																; (LENGTH LIS-LIS-P-SLI-PAR-TRANS ) 63 

	;========================================================================================================================================
	;	(09) PLANOS NORMALES a SPLINE EJE                 LIS-P-SLI-EJE-LONGI	=>	LIS-3PUN-PLA-NOR-EJE												 			 					 
	;========================================================================================================================================
	;                                                                
	;                                   O PC3                        
	;                                   |                            
	;                                   |                            
	;                          PmC23    |                            
	;                  CenC O-----O-----O PmC23                      
	;                       |           |                            
	;                       |           |                            
	;                 PnC12 O  PnC2x O  |                            
	;                       |         \ |                            
	;                       |          \|                            
	;          PC1 O--------O-----------O PC2                        
	;                     PmC12        /                             
	;                                 /                              
	;                          PnC2y O                               
	;                                                                

	(SETQ LIS-3PUN-PLA-NOR-EJE nil )
	(SETQ NA -1 )
	(REPEAT (- (LENGTH LIS-P-SLI-EJE-LONGI ) 2 )																											; 63 -2 = 61 
		(SETQ NA (+ NA 1 ))

		(SETQ PC1 (NTH (+ NA 0 ) LIS-P-SLI-EJE-LONGI ))																								; 0..60 
		(SETQ PC2 (NTH (+ NA 1 ) LIS-P-SLI-EJE-LONGI ))																								; 1..61 
		(SETQ PC3 (NTH (+ NA 2 ) LIS-P-SLI-EJE-LONGI ))																								; 2..62 

		(SETQ PnC2y (CAL " PC2 + ( 30 * NOR( PC1 , PC2 , PC3 ))"))																			; LONGITUD VECTOR # 30   PUN EJE/Y 
		(SETQ PmC12 (CAL " PLT( PC1 , PC2 , 0.5 )"))																										; PUN MEDIO 
		(SETQ PmC23 (CAL " PLT( PC2 , PC3 , 0.5 )"))
		(SETQ PnC12 (CAL " PmC12 + NOR( PC1 , PC2 , PnC2y )"))
		(SETQ PnC23 (CAL " PmC23 + NOR( PC2 , PC3 , PnC2y )"))
		(SETQ CenC  (CAL " ILL( PmC12 , PnC12 , PmC23 , PnC23 )"))																			; INTERSECCION 2-LINEAS 
		(SETQ PnC2x (CAL " PC2 + ( 30 * VEC1( PC2 , CenC ))"))																					; LONGITUD VECTOR # 30   PUN EJE/X 

		(SETQ LIS-3PUN-PLA-NOR-EJE (CONS (LIST PC2  PnC2x  PnC2y )  LIS-3PUN-PLA-NOR-EJE ))
	) ; repe NA

	(SETQ LIS-3PUN-PLA-NOR-EJE (REVERSE LIS-3PUN-PLA-NOR-EJE ))																				; (LENGTH LIS-3PUN-PLA-NOR-EJE ) 61 


	; PINTA =================================================================================================================================
	;				(PINTA-LINE-P3-PLANO) 		; PINTA LINEAS 			LIS-3PUN-PLA-NOR-EJE 													 																		 
	;========================================================================================================================================


	;========================================================================================================================================
	;	(11) PUNTOS-INTERSECCION de las SPLINES con PLANOS-NORMALES-EJE    LIS-3PUN-PLA-NOR-EJE + LIS-LIS-P-SLI-PAR-LONGI	=>	LIS-LIS-PuIN-SPL-PAR-SEC-NOR

	(SETQ LIS-LIS-PuIN-SPL-PAR-SEC-NOR  nil )

	(SETQ NPLA -1 )
	(REPEAT (LENGTH LIS-3PUN-PLA-NOR-EJE )																														; N-PLANOS        61 
		(SETQ NPLA (+ NPLA 1 ))																																				; 0..60 

		(SETQ ppO (NTH 0 (NTH NPLA  LIS-3PUN-PLA-NOR-EJE )))																						; PUNTOS PLANO-NOR-COLUMNA 
		(SETQ ppX (NTH 1 (NTH NPLA  LIS-3PUN-PLA-NOR-EJE )))
		(SETQ ppY (NTH 2 (NTH NPLA  LIS-3PUN-PLA-NOR-EJE )))																						; (LIST  PC2  PnC2x  PnC2y ) 

		 ;	(COMMAND "COLOR" 8  "LINEA" ppO ppX "" )
		 ;	(COMMAND "COLOR" 8  "LINEA" ppO ppY "" )

		(SETQ LIS-P-SPL-PAR-SEC-NOR  nil )

		(SETQ NSPL  -1 )
		(REPEAT (LENGTH LIS-LIS-P-SLI-PAR-LONGI )																												; N-SPLINES       3  
			(SETQ NSPL (+ NSPL 1 ))																																			; 0..2  

			(SETQ LIS-INT-1SPL  nil )
			(SETQ NPUN  -1 )
			(REPEAT (- (LENGTH (NTH NSPL  LIS-LIS-P-SLI-PAR-LONGI )) 1 )																	; N-PUNTO-SPL 63 - 1 = 62 
				(SETQ NPUN (+ NPUN 1 ))																					

				(SETQ Ps1 (NTH (+ NPUN 0 ) (NTH NSPL  LIS-LIS-P-SLI-PAR-LONGI )))													; 0..61 
				(SETQ Ps2 (NTH (+ NPUN 1 ) (NTH NSPL  LIS-LIS-P-SLI-PAR-LONGI )))													; 1..62 

				(SETQ PIn12 (CAL " ILP( Ps1 , Ps2 ,  ppO , ppX , ppY )"))																		; INTERSEC LINE PLANO
				(SETQ Dis12 (DISTANCE Ps1   Ps2 ))
				(SETQ Dis1  (DISTANCE PIn12 Ps1 ))
				(SETQ Dis2  (DISTANCE PIn12 Ps2 ))

				(IF (EQUAL Dis12 (+ Dis1 Dis2 ) 0.0001)																											; INTER DENTRO de Ps1 Ps2 
					(PROGN
						(SETQ PunPLA (CAL "PLT( Ps1 , Ps2 , Dis1 / ( Dis1 + Dis2 ))"))													; PUN en LINEA en % 
						(SETQ LIS-INT-1SPL (CONS (LIST PunPLA  ppO )  LIS-INT-1SPL ))
					) ; pro
				) ; if

			) ; repe NPUN


			(COND  ; A 
				((= (LENGTH LIS-INT-1SPL ) 0 )
					(PROMPT "  ### INTER FUERA de Ps1 Ps2  ERROR? ###") (PROMPT "  NPLA = ") (PRIN1 NPLA ) (PROMPT "  NSPL = ") (PRIN1 NSPL ) (TERPRI)) ; conA1 

				((= (LENGTH LIS-INT-1SPL ) 1 )
				 					(SETQ LIS-P-SPL-PAR-SEC-NOR (CONS  "##"   LIS-P-SPL-PAR-SEC-NOR ))
				 					(SETQ LIS-P-SPL-PAR-SEC-NOR (CONS PunPLA  LIS-P-SPL-PAR-SEC-NOR ))	)	; conA2

				((= (LENGTH LIS-INT-1SPL ) 2 )
					(SETQ PuPla1 (NTH 0 (NTH 0  LIS-INT-1SPL )))
					(SETQ ppO1   (NTH 1 (NTH 0  LIS-INT-1SPL )))
					(SETQ PuPla2 (NTH 0 (NTH 1  LIS-INT-1SPL )))
					(SETQ ppO2   (NTH 1 (NTH 1  LIS-INT-1SPL )))

					(COND  ; B 
						((AND (EQUAL ppO1 ppO2 0.0001) (< (DISTANCE PuPla1 ppO1 ) (DISTANCE PuPla2 ppO1 )))

									(SETQ LIS-P-SPL-PAR-SEC-NOR (CONS  "##"   LIS-P-SPL-PAR-SEC-NOR ))
					  	    (SETQ LIS-P-SPL-PAR-SEC-NOR (CONS PuPla1  LIS-P-SPL-PAR-SEC-NOR )))  											; conB1  PuPla1

						((AND (EQUAL ppO1 ppO2 0.0001) (> (DISTANCE PuPla1 ppO1 ) (DISTANCE PuPla2 ppO1 )))

									(SETQ LIS-P-SPL-PAR-SEC-NOR (CONS  "##"    LIS-P-SPL-PAR-SEC-NOR ))
						      (SETQ LIS-P-SPL-PAR-SEC-NOR (CONS PuPla2  LIS-P-SPL-PAR-SEC-NOR )))  											; conB2  PuPla2

						((AND (EQUAL ppO1 ppO2 0.0001) (EQUAL PuPla1 PuPla2 0.0001))

									(SETQ LIS-P-SPL-PAR-SEC-NOR (CONS  "##"   LIS-P-SPL-PAR-SEC-NOR ))
						      (SETQ LIS-P-SPL-PAR-SEC-NOR (CONS PuPla1  LIS-P-SPL-PAR-SEC-NOR )))  											; conB3  PuPla1

						( T (PROMPT "  ### NO IGUALES ppO1 ppO2  ERROR? ### ") (PRIN1 ppO1 ) (PROMPT " / ") (PRIN1 ppO2 ) (TERPRI))  ; conB4 
					) ; CON-B 
				) ; conA3
				
				((= (LENGTH LIS-INT-1SPL ) 3 ) (PROMPT " ======> 3 INTER en NPLA = ") (PRIN1 NPLA ) (PROMPT "  NSPL = ") (PRIN1 NSPL ) (TERPRI)) ; conA4 
				((= (LENGTH LIS-INT-1SPL ) 4 ) (PROMPT " ======> 4 INTER en NPLA = ") (PRIN1 NPLA ) (PROMPT "  NSPL = ") (PRIN1 NSPL ) (TERPRI)) ; conA5 
				((= (LENGTH LIS-INT-1SPL ) 5 ) (PROMPT " ======> 5 INTER en NPLA = ") (PRIN1 NPLA ) (PROMPT "  NSPL = ") (PRIN1 NSPL ) (TERPRI)) ; conA6 
			) ; CON-A 
			
		) ; repe NSPL

		(SETQ LIS-P-SPL-PAR-SEC-NOR  (REVERSE LIS-P-SPL-PAR-SEC-NOR ))																			; (LENGTH LIS-P-SPL-PAR-SEC-NOR )
		(SETQ LIS-LIS-PuIN-SPL-PAR-SEC-NOR (CONS LIS-P-SPL-PAR-SEC-NOR   LIS-LIS-PuIN-SPL-PAR-SEC-NOR ))		; (( PunPLA ) ( PunPLA )..) 

	) ; repe NPLA 

	(SETQ LIS-LIS-PuIN-SPL-PAR-SEC-NOR  (REVERSE LIS-LIS-PuIN-SPL-PAR-SEC-NOR ))													; (LENGTH LIS-LIS-PuIN-SPL-PAR-SEC-NOR )


	; PINTA =================================================================================================================================
		;			(PINTA-3DC-PuIN-SPL-PAR-SEC-NOR) 		; PINTA 3DCARAS con PUNTOS de LIS-LIS-PuIN-SPL-PAR-SEC-NOR	 																 
	;========================================================================================================================================


	;========================================================================================================================================
	;	(14) PUNTO INTERSECCION de PLANOS-2CARAS con PLANO-SECC     INTER-3-PLANOS (VECTORIAL)                                              	 
	;========================================================================================================================================
	;                                                                                                                                        
	;                                                          O PLAy         DISPUSICION ORDENADA de PUNTOS en BASE-INICIO                  
	;    Psp4 O---------------O                               /                                                                              
	;         | VER4     VER3 |                              O Psp4           VERTICES POLILINEA BASE-INICIO     ( VER1  VER2  Psp2 )        
	;         |               |                             /                 CON PUNTOS DE INICIO SPLINES PARES ( Psp2  Psp4 )              
	;         |               |           PLAo Psp2 PLAx O /                                                                                 
	;         |               |            O---O----------O <= INver2                                                                        
	;         |               |                           |                                                                                  
	;         | VER1     VER2 |                           |    O VER3                                                                        
	;         O---------------O Psp2                      |   /              INTERSECCION de 3-PLANOS => ( INver2 )                          
	;                                                     |  /                                                                               
	;      DISPUSICION ORDENADA                           | /                PLANO-CARA-1 ( VER1  VER2  Psp2 ) LIS-PUN-BASE-USO              
	;    de PUNTOS en BASE-INICIO                         |/                 PLANO-CARA-2 ( VER2  VER3  Psp4 ) LIS-LIS-PuIN-SPL-PAR-SEC-NOR  
	;                                     VER1 O----------O VER2             PLANO-SECC-2 ( PLAo  PLAx  PLAy ) LIS-3PUN-PLA-NOR-EJE          
	;                                                                                                                                        

	(SETQ LIS-LIS-PUN-TAPA-CAJAS nil )
	(SETQ TotaVER (LENGTH LIS-PUN-BASE-INI ))																												;  6 

	(SETQ NSEC  0 )
	(REPEAT (- (LENGTH LIS-LIS-PuIN-SPL-PAR-SEC-NOR ) 1 ) 																					; NSECCION 61 - 1 = 60 
		(SETQ NSEC (+ NSEC 1 ))		 																																	; NSEC  1..60 

		; (14-1)  DETERMINAN PLANO SECCION NSEC  3-PUNTOS(0 1 2) NSEC (1..20) LIS-LIS-PuIN-SPL-PAR-SEC-NOR   =>   PLAo PLAx PLAy 					

		(SETQ PLAo (NTH 0 (NTH NSEC  LIS-3PUN-PLA-NOR-EJE )))  																			; (LIST  PC2  PnC2x  PnC2y ) 
		(SETQ PLAx (NTH 1 (NTH NSEC  LIS-3PUN-PLA-NOR-EJE )))
		(SETQ PLAy (NTH 2 (NTH NSEC  LIS-3PUN-PLA-NOR-EJE )))																				; (LENGTH LIS-3PUN-PLA-NOR-EJE ) 61 


		; (14-2)  PUNTOS BASE-USO  			Si (= NSEC 1 ) => ( BASE-USO = BASE-0 ) SiNo ( BASE-USO = BASE-INTER )			          							

		(IF (= NSEC 1 ) (SETQ LIS-PUN-BASE-USO  LIS-PUN-BASE-INI ) (SETQ LIS-PUN-BASE-USO   LIS-PUN-INTER-BASE ))   ; SECC 0..60 

		; (14-3)  PUNTOS BASE-INTER  	PUNTO SECC INTERSECCION 3PLANOS			=>		LIS-PUN-INTER-BASE																						

		(SETQ LIS-PUN-INTER-BASE  nil )

		(SETQ NVER -1 )
		(REPEAT TotaVER																																										; 6 
			(SETQ NVER (+ NVER 1 ))		   																																	; NVER  0..5 
			(SETQ VER1  (NTH (REM (+ NVER 0) TotaVER ) LIS-PUN-BASE-USO )) 				 												; en SECC-0 
			(SETQ VER2  (NTH (REM (+ NVER 1) TotaVER ) LIS-PUN-BASE-USO ))																	; (V1 V2 V3 .. )
			(SETQ VER3  (NTH (REM (+ NVER 2) TotaVER ) LIS-PUN-BASE-USO ))

			(COND
				((= (REM (+ NVER 1) 2 ) 1 )      ; (INPAR) => V1 V2 Psp2 - V2 V3 Psp2 

					(SETQ Psp2 (NTH (REM (+ NVER 1) TotaVER ) (NTH NSEC  LIS-LIS-PuIN-SPL-PAR-SEC-NOR )))		; (.. "#" Psp2 "#" ..) 
					(COND
						((=  (+ NVER 1 ) TotaVER ) (SETQ DFASE2  Psp2 )) 																			; conB1 ; DESFASE NVER ULTIMO => DFASE2
						((/= (+ NVER 1 ) TotaVER ) (SETQ LIS-PUN-INTER-BASE (CONS Psp2  LIS-PUN-INTER-BASE ))) ; conB2
					) ; conB
				) ; conA1

				((= (REM (+ NVER 1) 2 ) 0 )      ; ( PAR ) => V2 V3 Psp2 - V3 V4 Psp4 

					(SETQ Psp2 (NTH (REM (+ NVER 0) TotaVER ) (NTH NSEC  LIS-LIS-PuIN-SPL-PAR-SEC-NOR )))		; (.. Psp2 "#" Psp4 ..) 
					(SETQ Psp4 (NTH (REM (+ NVER 2) TotaVER ) (NTH NSEC  LIS-LIS-PuIN-SPL-PAR-SEC-NOR )))

					(SETQ VnC1   (CAL "NOR( VER1 , VER2 , Psp2 )"))																						; VECTOR NORMAL a CARA-1 
					(SETQ VnC2   (CAL "NOR( VER2 , VER3 , Psp4 )"))																						; VECTOR NORMAL a CARA-2 
					(SETQ Vn12   (CAL "NOR( VER2 , VER2 + VnC1 , VER2 + VnC2 )"))															; VECTOR NORMAL a VEC CARA-1 CARA-2 en VER2 
					(SETQ PuU2v  (CAL " VER2 + Vn12 "))																												; PUNTO de NORMAL en VER2 
					(SETQ INver2 (CAL "ILP( VER2 , PuU2v ,  PLAo , PLAx , PLAy )"))														; INTERSECCION 3-PLANOS (2-CARAS 1-SECC) 

					(COND
						((=  INver2 nil)
							(PROMPT " --- ### MAL ###  INver2 => nil") (PROMPT "  NSEC = ") (PRIN1 NSEC ) (PROMPT "  NVER = ") (PRIN1 NVER ) (TERPRI)
						) ; conC1

						((/= INver2 nil)
							(COND
								((=  (+ NVER 1 ) TotaVER ) (SETQ DFASE2  INver2 )) 																			; conD1 ; DESFASE NVER ULTIMO => DFASE2
								((/= (+ NVER 1 ) TotaVER ) (SETQ LIS-PUN-INTER-BASE (CONS INver2  LIS-PUN-INTER-BASE ))) ; conD2
							) ; conD
						) ; conC2
					) ; conC
				) ; conA2
			) ; conA
		) ; repe NVER

		(SETQ LIS-PUN-INTER-BASE     (REVERSE  LIS-PUN-INTER-BASE ))
		(SETQ LIS-PUN-INTER-BASE     (CONS DFASE2  LIS-PUN-INTER-BASE ))												; AADE el ULTIMO al PRINCIPIO (POR DESFASE LIS)
		(SETQ LIS-LIS-PUN-TAPA-CAJAS (CONS LIS-PUN-INTER-BASE    LIS-LIS-PUN-TAPA-CAJAS ))
	) ; repe NSEC
	(SETQ LIS-LIS-PUN-TAPA-CAJAS (REVERSE LIS-LIS-PUN-TAPA-CAJAS ))   												; (LENGTH LIS-LIS-PUN-TAPA-CAJAS ) 62 
	(SETQ LIS-LIS-PUN-TAPA-CAJAS (CONS LIS-PUN-BASE-INI    LIS-LIS-PUN-TAPA-CAJAS ))


 (IF nil (PROGN  "###############################################################"
				; PINTA PRUE    																													

				(COMMAND  "COLOR" 3   "PUNTO" PLAo )
				(COMMAND  "COLOR" 3   "PUNTO" PLAx )
				(COMMAND  "COLOR" 3   "PUNTO" PLAy )

				(COMMAND  "COLOR" 4   "PUNTO" VER1 )
				(COMMAND  "COLOR" 4   "PUNTO" VER2 )
				(COMMAND  "COLOR" 4   "PUNTO" VER3 )

				(COMMAND  "COLOR" 7   "PUNTO" Psp2 )
	
				(COMMAND  "COLOR" 4   "PUNTO" VER3 )

				(SETQ N# -1)
				(REPEAT (LENGTH LIS-PUN-INTER-BASE )
					(SETQ N# (+ N# 1 ))
					(SETQ PPP  (NTH N# LIS-PUN-INTER-BASE ))
					(COMMAND  "COLOR" 2   "PUNTO" PPP )
				) ; repe

				; PINTA PRUE    																													
 ))  "IF PROGN  #################################################################"

 (IF nil (PROGN  "###############################################################"
		; PINTA  LIS-LIS-PUN-TAPA-CAJAS  3DCARAS  (COMPROBACION)																																						

		(SETQ NPuTapa (LENGTH (NTH 0 LIS-LIS-PUN-TAPA-CAJAS )))

		(SETQ NLI1 -1 )
		(REPEAT (- (LENGTH LIS-LIS-PUN-TAPA-CAJAS ) 1 )																											; 61 
			(SETQ NLI1 (+ NLI1 1 ))		   																															; NLI1  0..60 

			(SETQ LIS-PUN-TAPA-1  (NTH (+ NLI1 0)  LIS-LIS-PUN-TAPA-CAJAS )) 
			(SETQ LIS-PUN-TAPA-2  (NTH (+ NLI1 1)  LIS-LIS-PUN-TAPA-CAJAS )) 

			(SETQ NPU1 -1 )
			(REPEAT NPuTapa																															;  6 
				(SETQ NPU1 (+ NPU1 1 ))		   																														; NPU1  0..5 

				(SETQ PU-1 (NTH (REM (+ NPU1 0) NPuTapa ) LIS-PUN-TAPA-1 )) 
				(SETQ PU-2 (NTH (REM (+ NPU1 1) NPuTapa ) LIS-PUN-TAPA-1 )) 
				(SETQ PU-3 (NTH (REM (+ NPU1 0) NPuTapa ) LIS-PUN-TAPA-2 )) 
				(SETQ PU-4 (NTH (REM (+ NPU1 1) NPuTapa ) LIS-PUN-TAPA-2 )) 

				(SETQ COLO1 (+ (REM NLI1 5 ) 1))
				(COMMAND "COLOR" COLO1   "3DCARA" PU-1  PU-2  PU-4  PU-3 "" )

			) ; repe NPU1
		) ; repe NLI1

		;	(COMPROBACION)																																																										
 ))  "IF PROGN  #################################################################"






 (IF  T  (PROGN  "##########################################################################################################################################"

	;---------------------------------------------------------------------------------------------------------------------------------------
	; (15) PINTA 3DC CARAS LATERALES CAJA y PATRONES                                                        																

	(SETQ N10 -1 )
	(REPEAT (LENGTH (NTH 0 LIS-LIS-PUN-TAPA-CAJAS ))			; 10 
		(SETQ N10 (+ N10 1 ))

		(SETQ KK1 (LIST (* 150 (+ N10 1 )) -50.0  0.0 ))	; PUNTOS ARRANQUE PATRONES 
		(SETQ KK2 (LIST (* 151 (+ N10 1 )) -50.0  0.0 ))

		(SETQ N11 -1 )
		(REPEAT (- (LENGTH LIS-LIS-PUN-TAPA-CAJAS ) 1 )			; 81 
			(SETQ N11 (+ N11 1 ))

			(SETQ LIS-P-TAPA-A (NTH (+ N11 0) LIS-LIS-PUN-TAPA-CAJAS ))
			(SETQ LIS-P-TAPA-B (NTH (+ N11 1) LIS-LIS-PUN-TAPA-CAJAS ))


			(SETQ PA1 (NTH (REM (+ N10 0) (LENGTH LIS-P-TAPA-A )) LIS-P-TAPA-A ))        	;      KK1                     KK2   
			(SETQ PA2 (NTH (REM (+ N10 1) (LENGTH LIS-P-TAPA-A )) LIS-P-TAPA-A ))	      	;      PB1 O-----------------O PB2   
                                                                                    	;          |     3D Cara     |       
			(SETQ PB1 (NTH (REM (+ N10 0) (LENGTH LIS-P-TAPA-B )) LIS-P-TAPA-B ))        	;          |                 |       
			(SETQ PB2 (NTH (REM (+ N10 1) (LENGTH LIS-P-TAPA-B )) LIS-P-TAPA-B ))        	;      PA1 O-----------------O PA2   

			"==( 3D )====================================================================================================================="
			"-----------------------------------------------------------------------------------------------------------------------------"

			(IF (= (REM N10 2 ) 0 ) (SETQ COL3 2 ) (SETQ COL3 3 ))
			(COMMAND "COLOR" COL3 "3DCARA" PA1 PA2 PB2 PB1 "" )																														; 3DCARA-3D

			(COMMAND "SCP" "3P" PA1 PA2 PB1 )																																							; PLANO-3DC ( 3D ) 
				(SETQ PA1p (LIST 0.0 0.0 0.0))
				(SETQ PA2p (TRANS PA2 0 1 ))
				(SETQ PB1p (TRANS PB1 0 1 ))
				(SETQ PB2p (TRANS PB2 0 1 ))
				"----------------------------------------------------------------------------------------------------------------------------"
		;		(COMMAND "COLOR" 1  "TEXTO"  (LIST 0.42 0.18)  0.42  0  (STRCAT (ITOA (+ N10 1 )) "/" (ITOA (+ N11 1 ))))		; TEXTO-3D 
   		(COMMAND "SCP" "U")

			"==( 2D )======================================================================================================================"
			(COMMAND "SCP" "3P" KK1 KK2 "" )																																							; PLANO-3DC ( 2D ) PATRONES
				"----------------------------------------------------------------------------------------------------------------------------"
				(COMMAND "COLOR" 7   "3DCARA" PA1p  PA2p  PB2p  PB1p "")																										; 3DCARA-2D
				(SETQ PB1pU (TRANS PB1p 1 0 ))
				(SETQ PB2pU (TRANS PB2p 1 0 ))
				(SETQ KK1 PB1pU )
				(SETQ KK2 PB2pU )
				"----------------------------------------------------------------------------------------------------------------------------"
		;		(COMMAND "COLOR" 1  "TEXTO"  (LIST 0.42 0.18)  0.42  0  (STRCAT (ITOA (+ N10 1 )) "/" (ITOA (+ N11 1 ))))		; TEXTO-2D 
   		(COMMAND "SCP" "U")

		) ; repe N11
	) ; repe N10


 ))  "IF PROGN  #######################################################################################################################################"




	;	(16) PARANDO																																																												
	(SETVAR "blipmode" 1) (SETVAR "cmdecho" 1)

) ;CIERRE DEFUN  CAJAS-CARAS-PLANAS--SPL-ARISTAS-PARES-02

;=======================================================================================================================================


