
;==========================================================================================================================================
;																																																																					 
;	 ( CAJAS-CARAS-PLANAS--nSPL-nARISTAS-PUN-MEDIO-02 )				( PUN-MEDIO por INTERSECCION VELTORIAL de 3 PLANOS)              18/11/2009		 
;																																																																					 
;	 DATOS:     (1) SPLINES PERFILES-CARAS en VERTICES POLILINEA-3D (3) (en ORDEN)																													 
;	            (2) SPLINE-EJE  COLUMNA-VERTEBRAL																																														 
;	            (3) POLILINEA-3D BASE (en FASE con SPL (1))																																									 
;																																																																					 
;	            (4) AADE PUNTOS de TANGENCIA de los EXTREMOS de SPLINE a (LIS-PUN-SPL)                   																	 
;																																																																					 
;             (5) DIFINE  PLANO-CARA  2-PUN =>(LIS-PUN-BASE-USO) y PUN-MEDIO de 2-PUN =>(LIS-LIS-pSPL-SecNOR) (CONSECUTIVOS y CORELATIBOS) 
;																																																																					 
;==========================================================================================================================================


;------------------------------------------------------------------------------------------------------------------------------------------
;	PUNTOS-SPLI-DIVIDE   DIVIDE SPLINE ( NoSplDIV ) con ( Ndivide ) => LISTA PUNTOS ( LIS-PUN-SPL )  								                       
;------------------------------------------------------------------------------------------------------------------------------------------
	(DEFUN PUNTOS-SPLI-DIVIDE ( / )

		(SETQ LIS-PUN-SPL nil)
		(SETQ LIS-SPL (ENTGET NoSplDIV ))  																						; lista Spline 
		(SETQ 1E10  (ASSOC 10 LIS-SPL ))  																						; 1 Punto Asociado a 10 (10.punto)  1E10
		(SETQ LIS<1E10 (MEMBER 1E10 LIS-SPL )) 																			; lista a partir del Alterior (10.punto)....(11.punto)
		(SETQ Prim10 (CDR (NTH 0 LIS<1E10 ))) 																				; primer elemento (10.punto)
		(SETQ Ulti11 (CDR (NTH (- (LENGTH LIS<1E10) 1) LIS<1E10 )))									; ultimo elemento (11.punto)
		(COMMAND "PUNTO" Prim10)																											; PINTA 1 punto A
		(SETQ N-enti-A1 (ENTLAST))																										; nombre ultima entidad principal 1 punto A
		(COMMAND "DIVIDE" NoSplDIV  Ndivide )																				; GRADUA SPLI-A
		(COMMAND "PUNTO" Ulti11 )																											; PINTA Ultimo Punto A
		;	PUNTOS SECCION-A (PA1-PAn) =>   LIS-PUN-SPL  Lon-LPA													                                                       
		(SETQ LIS-PUN-SPL nil)																												; LISTA  PUNTOS-A
		(SETQ LIS-PUN-SPL (CONS (CDR (ASSOC 10 (ENTGET N-enti-A1))) LIS-PUN-SPL))			; lista entidad -> (1 Punto-A)
		(SETQ W1A T)
		(WHILE W1A
			(SETQ N-enti-A2 (ENTNEXT N-enti-A1))																				; Nombre entidad siguiente
			(COMMAND "BORRA" N-enti-A1 "")																							; BORRA entidad (Punto)
			(IF (= N-enti-A2 nil)  (SETQ W1A nil)
				(PROGN
					(SETQ LIS-PUN-SPL (CONS (CDR (ASSOC 10 (ENTGET N-enti-A2))) LIS-PUN-SPL))
					(SETQ N-enti-A1  N-enti-A2 )
				);progn
			);if
		) ;While W1A
		;	LISTA ( LIS-PUN-SPL ) Ordenada																                                                                       
		(SETQ LIS-PUN-SPL (REVERSE LIS-PUN-SPL ))																			; ( LIS-PUN-SPL Ordenada )

	) ; Defun PUNTOS-SPLI-DIVIDE
;																						                                                                                               





;==========================================================================================================================================
;==========================================================================================================================================
;	  *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** 							 
;==========================================================================================================================================
;==========================================================================================================================================

(DEFUN C:CAJAS-CARAS-PLANAS--nSPL-nARISTAS-PUN-MEDIO-02 (/ )

	;========================================================================================================================================
	;	(00) ARRANCANDO																																																												 
	;========================================================================================================================================
	(SETVAR "blipmode" 0) (SETVAR "cmdecho" 0) (GRAPHSCR) (COMMAND "-REFENT" "DES"  "SCP" "U"  "ORTO" "DES")
	(IF (= CAL nil)(COMMAND "ARX" "L" "GEOMCAL.ARX"))			; CARGA CALCULADORA

	;========================================================================================================================================
	;	(01) DATOS INTERNOS       Ndivide																												                                             
	;========================================================================================================================================

	(SETQ Ndivide 100 )			;  NO mas de  32768  Divisiones 

	;========================================================================================================================================
	; (02) DATOS EXTERNOS														   																																											 
	;========================================================================================================================================

	(TERPRI)
	(PROMPT                       "####################################################################")   (TERPRI)
	(PROMPT                       " ------- (1) MARCA SPLINES ARISTAS (por Vertice) en ORDEN ---[ENTER]")   (TERPRI)
	(SETQ CONJ-SPL-PER (SSGET)) 																																											; (SSLENGTH CONJ-SPL-PER )
	(SETQ NoCOLU     (CAR (ENTSEL " >>>>>>> (2) MARCA SPLINE  EJE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<"))) (TERPRI)	; nombre Spline COLUM-VERTEBRAL
	(SETQ NoPOL-3D-0 (CAR (ENTSEL " >>>>>>> (3) MARCA POLILINEA-3D BASE (Vertice por SPL(1)) <<<<<<<<<<"))) (TERPRI)	; nombre POLILINEA-3D BASE 
	(PROMPT                       "####################################################################")   (TERPRI)


	;========================================================================================================================================
	;  PROGRAMAS a EGECUTAR ( "SI" o "NO" )				   																																												 
	;========================================================================================================================================
	(SETQ Prg03 "SI" )  ;	(03) PUNTOS SPLINE-PERFILES  			NOMBRE con Ndivide => LIS-PUN-SPL => LIS-LIS-P-SPI-PERF-LONGI									 
	(SETQ Prg04 "SI" )  ;	(04) PUNTOS SPLINE EJE 					 	LIS-P-SLI-EJE-LOMGI                     	 	 	 									 								 
	(SETQ Prg05 "SI" )  ; (05) PUNTOS BASE-0  				 			PUNTOS ORDENADOS POLILINEA-3D BASE => LIS-PUN-BASE-INI     											 
	;----------------------------------------------------------------------------------------------------------------------------------------
	(SETQ Prg09 "SI" )  ;	(09) PLANOS NORMALES a SPLINE-EJE   LIS-3PUN-PLA-NorEJE							 			 		 																	 	 
	;----------------------------------------------------------------------------------------------------------------------------------------
	(SETQ Prg11 "SI" )  ;	(11) PUNTOS-INTERSECCION de las SPLINES con PLANOS-NORMALES-EJE   LIS-LIS-pSPL-SecNOR                 				     
	;----------------------------------------------------------------------------------------------------------------------------------------
	(SETQ Prg14 "SI" )  ;	(14) PUNTO INTERSECCION de PLANOS-2CARAS con PLANO-SECC  INTER-3-PLANOS => LIS-LIS-PUN-TAPA-CAJAS    					 	   
	(SETQ Prg16 "SI" )  ; (16) PINTA 3DC CARAS LATERALES CAJA (PATRONES)                                                        						 
	;----------------------------------------------------------------------------------------------------------------------------------------

	;----------------------------------------------------------------------------------------------------------------------------------------
	(SETQ Prg06 "NO" )  ;	(06) PINTA y NUMERA PUNTOS de SPL-PERFILES  																(COMPROBACION)     	 	 	 							 
	(SETQ Prg07 "NO" )  ;	(07) PINTA y NUMERA PUNTOS de SPLINE-EJE    																(COMPROBACION)   	 	 	 								 
	(SETQ Prg08 "NO" )  ; (08) PINTA y NUMERA PUNTOS DE	LIS-PUN-BASE-INI 															(COMPROBACION)       									 
	;----------------------------------------------------------------------------------------------------------------------------------------
	(SETQ Prg10 "NO" )  ;	(10) PINTA 3DCARAS 3P-PLANOS  LIS-3PUN-PLA-NorEJE														(COMPROBACION)     		      		     	 
	;----------------------------------------------------------------------------------------------------------------------------------------
	(SETQ Prg12 "NO" )  ;	(12) PINTA y NUMERA PUNTOS 		de LIS-LIS-pSPL-SecNOR  											(COMPROBACION)     	 	 	 						 	 
	(SETQ Prg13 "NO" )  ;	(13) PINTA 3DCARAS con PUNTOS de LIS-LIS-pSPL-SecNOR =>	3DCARAS 						(COMPROBACION)           							 
	(SETQ Prg15 "NO" )  ;	(15) PINTA 3DCARAS con PUNTOS de LIS-LIS-PUN-TAPA-CAJAS  =>	3DCARAS         (COMPROBACION)           							 



	;========================================================================================================================================


(IF (= Prg03 "SI") (PROGN ;"#####################################"
	;========================================================================================================================================
	;	(03) PUNTOS SPLINE-PERFILES  NOMBRE con Ndivide => LIS-PUN-SPL => LIS-LIS-P-SPI-PERF-LONGI                			 	 	 									 
	;========================================================================================================================================
	(SETQ LIS-LIS-P-SPI-PERF-LONGI nil )
	(SETQ N0 -1 )
	(REPEAT (SSLENGTH CONJ-SPL-PER )																																	; (SSLENGTH CONJ-SPL-PER ) 3 
		(SETQ N0 (+ N0  1 ))
		(SETQ NoSplDIV (SSNAME CONJ-SPL-PER N0 ))   																										; <Nombre entidad: 7efd3c98> 
		(PUNTOS-SPLI-DIVIDE) 																																						; => LIS-PUN-SPL
		(SETQ LIS-P-SLI-LONGI  LIS-PUN-SPL )																														; (LENGTH LIS-P-SLI-LONGI ) 61 
		;	(03) AADE PUN TANG EXTREMOS a LIS-PUN-SPL                      	 	 	 									 																						 
		(SETQ LIS-SPLI (ENTGET NoSplDIV))																					; Lista de Spline 
		(SETQ LIS>10 (MEMBER (ASSOC 10 LIS-SPLI ) LIS-SPLI ))											; 10 PUN APOYO = lista a partir del elemento 10 (incluido)  
		(SETQ NP-APOYO (CDR (ASSOC 73 LIS-SPLI )))                         			; 73 NPUNTOS AJUSTE 	; AYUDAS = SPLINE (cdigos de grupo)   
		(SETQ LIS-PUN-APOYO  nil )
		(SETQ NAP -1 )
		(REPEAT NP-APOYO
			(SETQ NAP (+ NAP  1 ))
			(SETQ P-AP (CDR (NTH NAP  LIS>10 )))
			(SETQ LIS-PUN-APOYO (CONS P-AP  LIS-PUN-APOYO ))
		) ; repe
		(SETQ LIS-PUN-APOYO (REVERSE LIS-PUN-APOYO ))											 															; LISTA de PUNTOS de APOYO de SPLINE
		(SETQ T1ini (NTH        0                       LIS-PUN-APOYO ))																; PUNTOS TANGENTES INICIO 
		(SETQ T2ini (NTH        1                       LIS-PUN-APOYO ))
		(SETQ T2fin (NTH (- (LENGTH LIS-PUN-APOYO ) 2 ) LIS-PUN-APOYO ))																; PUNTOS TANGENTES FINAL 
		(SETQ T1fin (NTH (- (LENGTH LIS-PUN-APOYO ) 1 ) LIS-PUN-APOYO ))
		(SETQ PTini (CAL " T1ini + VEC( T2ini , T1ini )"))																							; PUN TAG INI 
		(SETQ PTfin (CAL " T1fin + VEC( T2fin , T1fin )"))																							; PUN TAG FIN 
		(SETQ LIS-P-SLI-LONGI  (REVERSE     LIS-P-SLI-LONGI  ))
		(SETQ LIS-P-SLI-LONGI+ (CONS PTfin  LIS-P-SLI-LONGI  ))																					; (LENGTH LIS-P-SLI-LONGI  ) 61 
		(SETQ LIS-P-SLI-LONGI+ (REVERSE     LIS-P-SLI-LONGI+ ))
		(SETQ LIS-P-SLI-LONGI+ (CONS PTini  LIS-P-SLI-LONGI+ ))																					; (LENGTH LIS-P-SLI-LONGI+ ) 63 
		(SETQ LIS-LIS-P-SPI-PERF-LONGI (CONS LIS-P-SLI-LONGI+  LIS-LIS-P-SPI-PERF-LONGI ))
	) ; repe N0
	(SETQ LIS-LIS-P-SPI-PERF-LONGI (REVERSE LIS-LIS-P-SPI-PERF-LONGI ))     													; (LENGTH LIS-LIS-P-SPI-PERF-LONGI ) 8 
)) ;"pro if #####################################################"


(IF (= Prg04 "SI") (PROGN ;"#####################################"
	;========================================================================================================================================
	;	(04) PUNTOS SPLINE EJE => LIS-P-SLI-EJE-LOMGI                     	 	 	 									 																				 		 
	;========================================================================================================================================
	(SETQ NoSplDIV  NoCOLU)   																																					; <Nombre entidad> 
	(PUNTOS-SPLI-DIVIDE) 																																							; => LIS-PUN-SPL 
	(SETQ LIS-P-SLI-EJE-LOMGI#   LIS-PUN-SPL )																													; (LENGTH LIS-P-SLI-EJE-LOMGI# ) 61 
	;	(04) AADE PUN TANG EXTREMOS a LIS-P-SLI-EJE-LOMGI												                     	 	 	 									 								 
	(SETQ LIS-SPLI (ENTGET NoSplDIV))																							; Lista de Spline  
	(SETQ LIS>10 (MEMBER (ASSOC 10 LIS-SPLI ) LIS-SPLI ))												; 10 PUN APOYO = lista a partir del elemento 10 (incluido)  
	(SETQ NP-APOYO (CDR (ASSOC 73 LIS-SPLI )))                        					; 73 NPUNTOS AJUSTE 	; AYUDAS = SPLINE (cdigos de grupo)   
	(SETQ LIS-PUN-APOYO  nil )
	(SETQ NAP -1 )
	(REPEAT NP-APOYO
		(SETQ NAP (+ NAP  1 ))
		(SETQ P-AP (CDR (NTH NAP  LIS>10 )))
		(SETQ LIS-PUN-APOYO (CONS P-AP  LIS-PUN-APOYO ))
	) ; repe
	(SETQ LIS-PUN-APOYO (REVERSE LIS-PUN-APOYO ))											 															; LISTA de PUNTOS de APOYO de SPLINE
	(SETQ T1ini (NTH        0                       LIS-PUN-APOYO ))																; PUNTOS TANGENTES INICIO 
	(SETQ T2ini (NTH        1                       LIS-PUN-APOYO ))
	(SETQ T2fin (NTH (- (LENGTH LIS-PUN-APOYO ) 2 ) LIS-PUN-APOYO ))																; PUNTOS TANGENTES FINAL 
	(SETQ T1fin (NTH (- (LENGTH LIS-PUN-APOYO ) 1 ) LIS-PUN-APOYO ))
	(SETQ PTini (CAL " T1ini + VEC( T2ini , T1ini )"))																							; PUN TAG INI 
	(SETQ PTfin (CAL " T1fin + VEC( T2fin , T1fin )"))																							; PUN TAG FIN 
	(SETQ LIS-P-SLI-EJE-LOMGI# (REVERSE     LIS-P-SLI-EJE-LOMGI# ))
	(SETQ LIS-P-SLI-EJE-LOMGI  (CONS PTfin  LIS-P-SLI-EJE-LOMGI# ))																	; (LENGTH LIS-P-SLI-EJE-LOMGI# ) 61 
	(SETQ LIS-P-SLI-EJE-LOMGI  (REVERSE     LIS-P-SLI-EJE-LOMGI  ))
	(SETQ LIS-P-SLI-EJE-LOMGI  (CONS PTini  LIS-P-SLI-EJE-LOMGI  ))																	; (LENGTH LIS-P-SLI-EJE-LOMGI ) 63 
)) ;"pro if #####################################################"


(IF (= Prg05 "SI") (PROGN ;"#####################################"
	;========================================================================================================================================
	; (05) PUNTOS BASE-0   PUNTOS ORDENADOS POLILINEA-3D BASE    =>   LIS-PUN-BASE-INI     																									 
	;========================================================================================================================================
	(SETQ LIS-PUN-BASE-INI  nil )
	(SETQ LISpO-3D-0 (ENTGET  NoPOL-3D-0 ))
	
	(SETQ WW1 T )
	(WHILE WW1
		(SETQ NoPOL-3D-1 (ENTNEXT NoPOL-3D-0 ))
		(SETQ LISpO-3D-1 (ENTGET  NoPOL-3D-1 ))
		(SETQ ENDI  (CDR (ASSOC 0 LISpO-3D-1 )))
		(IF (= ENDI "VERTEX" )
			(PROGN
				(SETQ CORD (CDR (ASSOC 10 LISpO-3D-1 )))
				(SETQ LIS-PUN-BASE-INI (CONS CORD  LIS-PUN-BASE-INI ))
				(SETQ NoPOL-3D-0  NoPOL-3D-1 )
			) ; pro
			(PROGN
				(SETQ WW1 nil )
			) ; pro
		) ; if
	) ; WW1
	
	(SETQ LIS-PUN-BASE-INI (REVERSE LIS-PUN-BASE-INI ))																		; (LENGTH LIS-PUN-BASE-INI ) 8 
)) ;"pro if #####################################################"


(IF (= Prg06 "SI") (PROGN ;"#####################################"
	;========================================================================================================================================
	;	(06) PINTA y NUMERA PUNTOS de SPL-PERFILES					      	 	 	 											 							 									 	 							 
	;========================================================================================================================================
	(SETQ N1 -1 )
	(REPEAT (LENGTH LIS-LIS-P-SPI-PERF-LONGI )																																; (LENGTH LIS-LIS-P-SPI-PERF-LONGI ) 8 
		(SETQ N1 (+ N1  1 ))
		(SETQ LIS-PUN-SPL-LONG  (NTH N1  LIS-LIS-P-SPI-PERF-LONGI ))
		(SETQ N2 -1 )
		(REPEAT (LENGTH LIS-PUN-SPL-LONG )																																					; (LENGTH LIS-PUN-SPL-LONG ) 63 
			(SETQ N2 (+ N2  1 ))
			(SETQ PSp (NTH N2  LIS-PUN-SPL-LONG    ))
			(COMMAND  "COLOR" 5  "CIRCULO" PSp 0.4  "TEXTO" "MC" PSp  0.2 0 (STRCAT (ITOA (+ N1 1)) "-" (ITOA (+ N2 1))))
		) ; repe N2 
	) ; repe N1
)) ;"pro if #####################################################"


(IF (= Prg07 "SI") (PROGN ;"#####################################"
	;========================================================================================================================================
	;	(07) PINTA y NUMERA PUNTOS de SPLINE-EJE       	 	 	 											 							 									 	 													 
	;========================================================================================================================================
	(SETQ N3 -1 )
	(REPEAT (LENGTH LIS-P-SLI-EJE-LOMGI )																				; (LENGTH LIS-P-SLI-EJE-LOMGI ) 8 
		(SETQ N3 (+ N3  1 ))
		(SETQ PSe (NTH N3  LIS-P-SLI-EJE-LOMGI ))
		(COMMAND  "COLOR" 7  "CIRCULO" PSe 0.4  "TEXTO" "MC" PSe  0.2 0 (STRCAT "E" (ITOA (+ N3 1 ))) )
	) ; repe N3 
)) ;"pro if #####################################################"


(IF (= Prg08 "SI") (PROGN ;"#####################################"
	;========================================================================================================================================
	; (08) PINTA y NUMERA PUNTOS LIS-PUN-BASE-INI        																																										 
	;========================================================================================================================================
	(SETQ N4 -1 )
	(REPEAT (LENGTH LIS-PUN-BASE-INI )																				; (LENGTH LIS-PUN-BASE-INI ) 8 
		(SETQ N4 (+ N4  1 ))
		(SETQ P0b (NTH N4  LIS-PUN-BASE-INI ))
		(COMMAND  "COLOR" 1  "CIRCULO" P0b 0.4  "TEXTO" "MC" P0b  0.2 0 (STRCAT "V" (ITOA (+ N3 1 ))) )
	) ; repe N4 
)) ;"pro if #####################################################"


(IF (= Prg09 "SI") (PROGN ;"#####################################"
	;========================================================================================================================================
	;	(09) PLANOS NORMALES a SPLINE-EJE                 LIS-P-SLI-EJE-LOMGI	=>	LIS-3PUN-PLA-NorEJE												 			 		 			 	 
	;========================================================================================================================================

	;                                  PE2                                                
	;                                   O----O PE2y           PLANO "EZ" PE2 PE1          
	;                                  /|                                                 
	;                            PE2x O |                                                 
	;                                   O PE1                                             
	(SETQ LIS-3PUN-PLA-NorEJE nil )
	(SETQ NA -1 )
	(REPEAT (- (LENGTH LIS-P-SLI-EJE-LOMGI ) 2 )																													; 63 -2 = 61 
		(SETQ NA (+ NA 1 ))																																								; 0..60 

	;	(IF (= NA (- (LENGTH LIS-P-SLI-EJE-LOMGI ) 3 ))
	;		(PROGN																								; ULTIMO PUN 
	;			(SETQ PE2b (NTH (+ NA 2 ) LIS-P-SLI-EJE-LOMGI ))
	;			(SETQ PE1b (NTH (+ NA 1 ) LIS-P-SLI-EJE-LOMGI ))
	;			(COMMAND "SCP" "EZ" PE2b PE1b )
	;				(SETQ PE2Xp (TRANS '(40.0  0.0 0.0) 1 0 ))
	;				(SETQ PE2Yp (TRANS '( 0.0 40.0 0.0) 1 0 ))
	;			(COMMAND "SCP" "U" )
	;			(SETQ PE2a  PE1b )
	;			(SETQ PE2x (CAL " PE2Xp +  VEC( PE2b , PE1b )"))
	;			(SETQ PE2y (CAL " PE2Yp +  VEC( PE2b , PE1b )"))
	;		) ; pro

	;		(PROGN																								; RESTO PUN 

				(SETQ PE3a (NTH (+ NA 2 ) LIS-P-SLI-EJE-LOMGI ))
				(SETQ PE2a (NTH (+ NA 1 ) LIS-P-SLI-EJE-LOMGI ))
				(SETQ PE1a (NTH (+ NA 0 ) LIS-P-SLI-EJE-LOMGI ))

				(COMMAND "SCP" "EZ" PE2a PE1a )
					(SETQ PE3ap  (TRANS PE3a 0 1 ))
					(SETQ PE3apo (LIST (CAR PE3ap ) (CADR PE3ap ) 0.0 ))

					(SETQ PE2xp (CAL " [0,0,0] +  15 * VEC1( [0,0,0] , PE3apo )"))
					(SETQ PE2yp (CAL " 15 * NOR( [0,0,0] , PE2xp )")  )

					(SETQ PE2x (TRANS PE2xp 1 0 ))
					(SETQ PE2y (TRANS PE2yp 1 0 ))
				(COMMAND "SCP" "U" )

	;		) ; pro
	;	) ; if

		(SETQ LIS-3PUN-PLA-NorEJE (CONS (LIST PE2a  PE2x  PE2y ) LIS-3PUN-PLA-NorEJE ))
	) ; repe NA
	(SETQ LIS-3PUN-PLA-NorEJE (REVERSE LIS-3PUN-PLA-NorEJE ))																				; (LENGTH LIS-3PUN-PLA-NorEJE ) 61 
)) ;"pro if #####################################################"


(IF (= Prg10 "SI") (PROGN ;"#####################################"
	;========================================================================================================================================
	;	(10) PINTA 3DCARAS 3P-PLANOS    ( COMPROBACION )                 	 	 				 																			 					 					 
	;========================================================================================================================================

	;                    O                                            
	;                Bo /|                                            
	;           O------O------O By                                    
	;           |     /| |    |                                       
	;           | Bx O | |    |                                       
	;           |    | | O    |                                       
	;           |    | |/     |                                       
	;           O----|-O------O Ay                                    
	;                |/ Ao                                            
	;             Ax O                                                

	(SETQ NBO -1 )
	(REPEAT (- (LENGTH LIS-3PUN-PLA-NorEJE ) 1 )																												; N-PLANOS  79 - 1 = 78 
		(SETQ NBO (+ NBO 1 ))																																						; 0..77

		(SETQ Ao (NTH 0 (NTH (+ NBO 0 ) LIS-3PUN-PLA-NorEJE )))																					; (LIST PE2  PE2x  PE2y )
		(SETQ Ax (NTH 1 (NTH (+ NBO 0 ) LIS-3PUN-PLA-NorEJE )))
		(SETQ Ay (NTH 2 (NTH (+ NBO 0 ) LIS-3PUN-PLA-NorEJE )))
		(SETQ Bo (NTH 0 (NTH (+ NBO 1 ) LIS-3PUN-PLA-NorEJE )))
		(SETQ Bx (NTH 1 (NTH (+ NBO 1 ) LIS-3PUN-PLA-NorEJE )))
		(SETQ By (NTH 2 (NTH (+ NBO 1 ) LIS-3PUN-PLA-NorEJE )))

		(COMMAND "COLOR" 1 "3DCARA" Ao Ax Bx Bo "" )
		(COMMAND "COLOR" 2 "3DCARA" Ao Ay By Bo "" )
	) ; repe NBO 
)) ;"pro if #####################################################"


(IF (= Prg11 "SI") (PROGN ;"#####################################"
	;========================================================================================================================================
	;	(11) PUNTOS-INTERSECCION de las SPLINES con PLANOS-NORMALES-EJE    LIS-3PUN-PLA-NorEJE + LIS-LIS-P-SPI-PERF-LONGI	=>	LIS-LIS-pSPL-SecNOR
	;========================================================================================================================================

	(SETQ LIS-LIS-pSPL-SecNOR  nil )
	(SETQ LIS-LIS-pSPL-SecNOR (CONS LIS-PUN-BASE-INI   LIS-LIS-pSPL-SecNOR ))													; En el PLANO de POLILINEA-3D  BASE-INI 

	(SETQ NPLA 0 )
	(REPEAT (- (LENGTH LIS-3PUN-PLA-NorEJE ) 1 )																											; N-PLANOS  81 -1 = 80 
		(SETQ NPLA (+ NPLA 1 ))																																				; 1..80 

		(SETQ ppO (NTH 0 (NTH NPLA  LIS-3PUN-PLA-NorEJE )))																						; PUNTOS PLANO-NOR-COLUMNA 
		(SETQ ppX (NTH 1 (NTH NPLA  LIS-3PUN-PLA-NorEJE )))
		(SETQ ppY (NTH 2 (NTH NPLA  LIS-3PUN-PLA-NorEJE )))																						; (LIST  PE2  PE2x  PE2y ) 

		(SETQ LIS-pSPLs-1SecNOR  nil )
		(SETQ NSPL  -1 )
		(REPEAT (LENGTH LIS-LIS-P-SPI-PERF-LONGI )																											; N-SPLINES    3 SPL 
			(SETQ NSPL (+ NSPL 1 ))																																			; 0..2  

			(SETQ PARsPs-INT-1SPL-1PLA  nil )
			(SETQ NPUN  -1 )
			(REPEAT (- (LENGTH (NTH NSPL  LIS-LIS-P-SPI-PERF-LONGI )) 1 )																; N-PUNTO-SPL   83 - 1 = 82 
				(SETQ NPUN (+ NPUN 1 ))																																		; 0..81 

				(SETQ Ps1 (NTH (+ NPUN 0 ) (NTH NSPL  LIS-LIS-P-SPI-PERF-LONGI )))
				(SETQ Ps2 (NTH (+ NPUN 1 ) (NTH NSPL  LIS-LIS-P-SPI-PERF-LONGI )))

				(SETQ PIn12 (CAL " ILP( Ps1 , Ps2 ,  ppO , ppX , ppY)"))																; INTERSEC LINE PLANO # NO PARALELOS # 
				(SETQ Dis12 (DISTANCE Ps1   Ps2 ))
				(SETQ Dis1  (DISTANCE PIn12 Ps1 ))
				(SETQ Dis2  (DISTANCE PIn12 Ps2 ))

				(IF (EQUAL Dis12 (+ Dis1 Dis2 ) 0.0001)																									; INTER DENTRO de Ps1 Ps2 
					(PROGN
						(SETQ PunPLA (CAL "PLT( Ps1 , Ps2 , Dis1 / ( Dis1 + Dis2 ))"))											; PUN en LINEA en % 
						(SETQ PARsPs-INT-1SPL-1PLA (CONS (LIST PunPLA  ppO )  PARsPs-INT-1SPL-1PLA ))
					) ; pro
				) ; if
			) ; repe NPUN

			;====================================================================================================================================
			;	(11-1)  SELECCIONA PUNTO VALIDO de  PARsPs-INT-1SPL-1PLA																																								 

      (COND
				((= (LENGTH PARsPs-INT-1SPL-1PLA ) 0 )  																								; (LENGTH PARsPs-INT-1SPL-1PLA ) 1 

				 	(PROMPT "  ### INTER del PLANO FUERA de Ps1 Ps2  ERROR? ###")
				 	(PROMPT "  NPLA = ") (PRIN1 NPLA ) (PROMPT "  NSPL = ") (PRIN1 NSPL ) (TERPRI)) 	; con0 


				((= (LENGTH PARsPs-INT-1SPL-1PLA ) 1 )

					(SETQ pPLA1 (NTH 0 (NTH 0 PARsPs-INT-1SPL-1PLA )))
				 	(SETQ LIS-pSPLs-1SecNOR (CONS pPLA1  LIS-pSPLs-1SecNOR )))		; con1 


				((> (LENGTH PARsPs-INT-1SPL-1PLA ) 1 )

					(SETQ DISmin 1000000 )	
					(SETQ NParI -1 )
					(REPEAT (LENGTH PARsPs-INT-1SPL-1PLA )             						;    N INTER por SPL en UN PLANO 
						(SETQ NParI (+ NParI  1 ))

						(SETQ NPUi -1 )
						(REPEAT (LENGTH (NTH NParI  PARsPs-INT-1SPL-1PLA ))        ; 3   PUNTOS 
							(SETQ NPUi (+ NPUi  1 ))
							(SETQ pPLA (NTH 0  (NTH NParI  PARsPs-INT-1SPL-1PLA )))  ; 2 (LIST PunPLA ppO )
							(SETQ pORI (NTH 1  (NTH NParI  PARsPs-INT-1SPL-1PLA )))

							(SETQ DISp12 (DISTANCE pPLA pORI ))
							(IF (< DISp12 DISmin )
								(PROGN (SETQ DISmin  DISp12 )
											 (SETQ ppPLA   pPLA   ))) ; pro if 
						) ; repe NPUi 
					) ; repe NParI

					(SETQ LIS-pSPLs-1SecNOR (CONS ppPLA  LIS-pSPLs-1SecNOR ))  ; (LENGTH LIS-pSPLs-1SecNOR ) 7 

				) ; con2 
			)	; CON

		) ; repe NSPL

		(SETQ LIS-pSPLs-1SecNOR     (REVERSE LIS-pSPLs-1SecNOR ))																				; (LENGTH LIS-pSPLs-1SecNOR ) 3 
		(SETQ LIS-LIS-pSPL-SecNOR (CONS LIS-pSPLs-1SecNOR   LIS-LIS-pSPL-SecNOR ))
	) ; repe NPLA

	(SETQ LIS-LIS-pSPL-SecNOR  (REVERSE LIS-LIS-pSPL-SecNOR ))																		; (LENGTH LIS-LIS-pSPL-SecNOR ) 61 
)) ;"pro if #####################################################"



(IF (= Prg12 "SI") (PROGN ;"#####################################"
	;========================================================================================================================================
	;	(12) PINTA y NUMERA PUNTOS de LIS-LIS-pSPL-SecNOR  (COMPROBACION)     	 	 	 				 							 									 	 							 	 
	;========================================================================================================================================

	(SETQ N1 -1 )																																											; NSECC 
	(REPEAT (LENGTH LIS-LIS-pSPL-SecNOR )																																; (LENGTH LIS-LIS-pSPL-SecNOR ) 81 
		(SETQ N1 (+ N1  1 ))																																						; 0..80 
		(SETQ LIS-pS-SecNOR  (NTH N1  LIS-LIS-pSPL-SecNOR ))

		(SETQ N2 -1 )																																										; NPUN/SEC   3 
		(REPEAT (LENGTH LIS-pS-SecNOR )																																		; (LENGTH LIS-pS-SecNOR ) 3 
			(SETQ N2 (+ N2  1 ))																																					; 0..2 
			(SETQ Ps (NTH N2  LIS-pS-SecNOR ))

			(IF (= (REM (+ N1 1 ) 5 ) 0 ) (SETQ Colo 5 ) (SETQ Colo (REM (+ N1 1 ) 5 )))

			(COMMAND  "COLOR" Colo  "CIRCULO" Ps 0.4  "TEXTO" "MC" Ps  0.2 0 (STRCAT (ITOA (+ N1 1)) "/" (ITOA (+ N2 1))))

		) ; repe N2 
	) ; repe N1
)) ;"pro if #####################################################"


(IF (= Prg13 "SI") (PROGN ;"#####################################"
	;========================================================================================================================================
	;	(13) PINTA 3DCARAS con PUNTOS de LIS-LIS-pSPL-SecNOR  =>	3DCARAS   (COMPROBACION)           																					 
	;========================================================================================================================================

	(SETQ NE -1 )
	(REPEAT (- (LENGTH LIS-LIS-pSPL-SecNOR ) 1 )	
		(SETQ NE (+ NE 1 ))
		(SETQ LIS-P-SecA (NTH (+ NE 0 ) LIS-LIS-pSPL-SecNOR ))
		(SETQ LIS-P-SecB (NTH (+ NE 1 ) LIS-LIS-pSPL-SecNOR ))

		(SETQ NF -1 )
		(REPEAT (LENGTH LIS-P-SecA )
			(SETQ NF (+ NF 1 ))
			(SETQ PSA1 (NTH (REM (+ NF 0 ) (LENGTH LIS-P-SecA )) LIS-P-SecA ))
			(SETQ PSA2 (NTH (REM (+ NF 1 ) (LENGTH LIS-P-SecA )) LIS-P-SecA ))

			(SETQ PSB1 (NTH (REM (+ NF 0 ) (LENGTH LIS-P-SecB )) LIS-P-SecB ))
			(SETQ PSB2 (NTH (REM (+ NF 1 ) (LENGTH LIS-P-SecB )) LIS-P-SecB ))

	    (COMMAND  "COLOR" 4   "3DCARA" PSA1 PSA2 PSB2 PSB1 "")		; COMPROBACION 
		) ; repe NF 
	) ; repe NE
)) ;"pro if #####################################################"


(IF (= Prg14 "SI") (PROGN ;"#####################################"
	;=====================================================================================================================================
	;	(14) PUNTO INTERSECCION de PLANOS-2CARAS con PLANO-SECC     INTER-3-PLANOS (VECTORIAL) => INTERSECCION ( INver2 )                   
	;=====================================================================================================================================

	;-------------------------------------------------------------------------------------------------------------------------------------
	;                  O PLAy                  O SPL3                                                                                     
	;                 /                       /                   INTERSECCION de 3-PLANOS                                                
	;                / PLAo      PLAx        /                                      PLANO-CARA-1 ( VER1  VER2  SPL12  )                   
	;               O----------------O      O SPL23                                 PLANO-CARA-2 ( VER2  VER3  SPL23  )                   
	;                                      /                    /                   PLANO-SECC-2 ( PLAo PLAx PLAy ) => ( INver2 )         
	;           SPL1        SPL12    SPL2 /                    / VnC1                                                                     
	;            O------------O----------O O <== INver2                                                                                   
	;                                    |                   --- VnC2               ( VER1 VER2 VER3 )  LIS-PUN-BASE-USO                  
	;                                    |    O VER3                                                                                      
	;                                    |   /                 | Vn12               ( SPL12 SPL23 )     LIS-LIS-pSPL-SecNOR               
	;                                    |  /                  |                                                                          
	;                                    | /                                        ( PLAo PLAx PLAy )  LIS-LIS-pSPL-SecNOR               
	;                                    |/                                                                                               
	;        VER1 O----------------------O VER2                                                                                           
	;                                                                                                                                     
	;-------------------------------------------------------------------------------------------------------------------------------------
	;                                                                                                                                     
	;            VER4 O-----------------O VER3       DISPUSICION ORDENADA  de                                                             
	;                 | SPL4       SPL3 |                                                                                                 
	;                 |                 |            VERTICES POLILINEA BASE-INICIO                                                       
	;                 |                 |            con PUNTOS DE INICIO SPLINES en los VERTICES                                         
	;                 | SPL1       SPL2 |                                                                                                 
	;            VER1 O-----------------O VER2                                                                                            
	;-------------------------------------------------------------------------------------------------------------------------------------

	(SETQ LIS-LIS-PUN-TAPA-CAJAS nil )

	(SETQ TOTAL/VER (LENGTH LIS-PUN-BASE-INI     ))  ;  3 

	(SETQ NSEC  0 )
	(REPEAT (- (LENGTH LIS-LIS-pSPL-SecNOR  ) 1 ) 																									; NSEC  71 - 1 = 70 
		(SETQ NSEC (+ NSEC 1 ))		 																																	; NSEC  1..69 

		; (14-1)  DETERMINAN PLANO SECCION NSEC  3-PUNTOS(0 1 2) NSEC (1..20) LIS-LIS-pSPL-SecNOR   =>   PLAo PLAx PLAy 									
		(SETQ PLAo (NTH 0 (NTH NSEC  LIS-LIS-pSPL-SecNOR )))																					; 3 PUN DETERMINAN PLANO SECCION NSEC 
		(SETQ PLAx (NTH 1 (NTH NSEC  LIS-LIS-pSPL-SecNOR )))
		(SETQ PLAy (NTH 2 (NTH NSEC  LIS-LIS-pSPL-SecNOR )))

		; (14-2)  PUNTOS BASE-USO  			Si (= NSEC 1 ) => ( BASE-USO = BASE-0 ) SiNo ( BASE-USO = BASE-INTER )			          							
		(IF (= NSEC 1 ) (SETQ LIS-PUN-BASE-USO  LIS-PUN-BASE-INI ) (SETQ LIS-PUN-BASE-USO   LIS-PUN-INTER-BASE ))   ; NSEC  1..60 

		; (14-3)  PUNTOS BASE-INTER  	PUN-SECC-INTERSECCION-3PLANOS			=>		LIS-PUN-INTER-BASE																						
		(SETQ LIS-PUN-INTER-BASE  nil )
		(SETQ NVER -1 )
		(REPEAT TOTAL/VER																																									; PUNS-SECC 8  
			(SETQ NVER (+ NVER 1 ))		   																																	; NVER  0..7 

			(SETQ VER1  (NTH (REM (+ NVER 0) TOTAL/VER ) LIS-PUN-BASE-USO )) 				 											; en SECC-0 
			(SETQ VER2  (NTH (REM (+ NVER 1) TOTAL/VER ) LIS-PUN-BASE-USO ))
			(SETQ VER3  (NTH (REM (+ NVER 2) TOTAL/VER ) LIS-PUN-BASE-USO ))

			(SETQ SPL1 (NTH (REM (+ NVER 0) TOTAL/VER ) (NTH NSEC  LIS-LIS-pSPL-SecNOR )))
			(SETQ SPL2 (NTH (REM (+ NVER 1) TOTAL/VER ) (NTH NSEC  LIS-LIS-pSPL-SecNOR )))
			(SETQ SPL3 (NTH (REM (+ NVER 2) TOTAL/VER ) (NTH NSEC  LIS-LIS-pSPL-SecNOR )))

			(SETQ SPL12 (CAL "PLT( SPL1 , SPL2 , 0.5 )"))																										; en SECC-1 
			(SETQ SPL23 (CAL "PLT( SPL2 , SPL3 , 0.5 )"))

			(SETQ VnC1 (CAL "NOR( VER1 , VER2 , SPL12 )"))																									; VECTOR NORMAL a CARA-1 
			(SETQ VnC2 (CAL "NOR( VER2 , VER3 , SPL23 )"))																									; VECTOR NORMAL a CARA-2 

			(SETQ Vn12 (CAL "NOR( VER2 , VER2 + VnC1 , VER2 + VnC2 )"))																			; VECTOR NORMAL a VECTORES CARA-1y2 en VER2 

			(SETQ PuU2v   (CAL " VER2 + Vn12 "))																														; PUNTO en INTER CARAS en VER2 
			(SETQ INver2  (CAL "ILP( VER2 , PuU2v ,  PLAo , PLAx , PLAy )"))																; INTERSECCION 3-PLANOS (2-CARAS 1-SECC) 

			(IF (= INver2 nil)
				(PROGN (PROMPT " ---- INTERSECCION 3-PLANOS = NULA ???   NSEC = ") (PRIN1 NSEC) (PROMPT "   NVER = ") (PRIN1 NVER) (TERPRI))	; CONTROL
				(PROGN
					(IF (= (+ NVER 1 ) TOTAL/VER )																															; SI  NVER es el ULTIMO  
						(PROGN (SETQ INver2-ULT   INver2 )) 																											; NVER ULTIMO => INver2-ULT  (PARA DESFASE LIS) 
						(PROGN (SETQ LIS-PUN-INTER-BASE (CONS INver2   LIS-PUN-INTER-BASE )))
					) ; if
				) ; pro
			) ; if
		) ; repe NVER
		(SETQ LIS-PUN-INTER-BASE     (REVERSE  LIS-PUN-INTER-BASE ))
		(SETQ LIS-PUN-INTER-BASE     (CONS INver2-ULT  LIS-PUN-INTER-BASE ))													; AADE el ULTIMO al PRINCIPIO  (PARA DESFASE LIS) 
		(SETQ LIS-LIS-PUN-TAPA-CAJAS (CONS LIS-PUN-INTER-BASE    LIS-LIS-PUN-TAPA-CAJAS ))

	) ; repe NSEC
	(SETQ LIS-LIS-PUN-TAPA-CAJAS (REVERSE LIS-LIS-PUN-TAPA-CAJAS ))   													  	; (LENGTH LIS-LIS-PUN-TAPA-CAJAS ) 11 
	(SETQ LIS-LIS-PUN-TAPA-CAJAS (CONS LIS-PUN-BASE-INI    LIS-LIS-PUN-TAPA-CAJAS ))
)) ;"pro if #####################################################"






(IF (= Prg15 "SI") (PROGN ;"#####################################"
	;========================================================================================================================================
	;	(15) PINTA 3DCARAS con PUNTOS de LIS-LIS-PUN-TAPA-CAJAS  =>	3DCARAS   (COMPROBACION)           																				 
	;========================================================================================================================================

	(SETQ NE -1 )
	(REPEAT (- (LENGTH LIS-LIS-PUN-TAPA-CAJAS ) 1 )				; 101 -1 = 100 
		(SETQ NE (+ NE 1 ))   						 								; 0..99 
		(SETQ LIS-P-TapaA (NTH (+ NE 0 ) LIS-LIS-PUN-TAPA-CAJAS ))
		(SETQ LIS-P-TapaB (NTH (+ NE 1 ) LIS-LIS-PUN-TAPA-CAJAS ))

		(SETQ NF -1 )
		(REPEAT (LENGTH LIS-P-TAPA ) 												; 3 
			(SETQ NF (+ NF 1 )) 														; 0..2 

			(SETQ PSA1 (NTH (REM (+ NF 0 ) (LENGTH LIS-P-TapaA )) LIS-P-TapaA ))
			(SETQ PSA2 (NTH (REM (+ NF 1 ) (LENGTH LIS-P-TapaA )) LIS-P-TapaA ))

			(SETQ PSB1 (NTH (REM (+ NF 0 ) (LENGTH LIS-P-TapaB )) LIS-P-TapaB ))
			(SETQ PSB2 (NTH (REM (+ NF 1 ) (LENGTH LIS-P-TapaB )) LIS-P-TapaB ))

			(IF (= (REM (+ NF 1 ) 5 ) 0 ) (SETQ COL 5 ) (SETQ COL (REM (+ NF 1 ) 5 )))



	    (COMMAND  "COLOR" COL   "3DCARA" PSA1 PSA2 PSB2 PSB1 "")		; COMPROBACION 
		) ; repe NF 
	) ; repe NE

)) ;"pro if #####################################################"







(IF (= Prg16 "SI") (PROGN ;"#####################################"
	;=====================================================================================================================================
	; (16) PINTA 3DC CARAS LATERALES CAJA                                                         																				
	;=====================================================================================================================================
	(SETQ NPuTa -1 )
	(REPEAT (LENGTH (NTH 0 LIS-LIS-PUN-TAPA-CAJAS ))
		(SETQ NPuTa (+ NPuTa 1 ))																													; N PUNTOS TAPA 

		(SETQ KK1 (LIST (* 260 (+ NPuTa 1 )) 0.0  0.0 ))																		; PUNTOS ARRANQUE PATRONES 
		(SETQ KK2 (LIST (* 261 (+ NPuTa 1 )) 0.0  0.0 ))

		(IF (= (REM (+ NPuTa 1 ) 5 ) 0 ) (SETQ COL 5 ) (SETQ COL (REM (+ NPuTa 1 ) 5 )))

		(SETQ NTapa -1 )
		(REPEAT (- (LENGTH LIS-LIS-PUN-TAPA-CAJAS ) 1 )
			(SETQ NTapa (+ NTapa 1 ))																												; N TAPA 

			(SETQ LIS-P-TAPA-A (NTH (+ NTapa 0) LIS-LIS-PUN-TAPA-CAJAS ))
			(SETQ LIS-P-TAPA-B (NTH (+ NTapa 1) LIS-LIS-PUN-TAPA-CAJAS ))

			(SETQ PA1 (NTH (REM (+ NPuTa 0) (LENGTH LIS-P-TAPA-A )) LIS-P-TAPA-A ))        	;      KK1                     KK2   
			(SETQ PA2 (NTH (REM (+ NPuTa 1) (LENGTH LIS-P-TAPA-A )) LIS-P-TAPA-A ))	      	;      PB1 O-----------------O PB2   
                                                                                    		;          |     3D Cara     |       
			(SETQ PB1 (NTH (REM (+ NPuTa 0) (LENGTH LIS-P-TAPA-B )) LIS-P-TAPA-B ))        	;          |                 |       
			(SETQ PB2 (NTH (REM (+ NPuTa 1) (LENGTH LIS-P-TAPA-B )) LIS-P-TAPA-B ))        	;      PA1 O-----------------O PA2   

			"==( 3D )====================================================================================================================="
			"-----------------------------------------------------------------------------------------------------------------------------"
			(COMMAND "COLOR" COL   "3DCARA" PA1 PA2 PB2 PB1 "" )																											; 3DCARA-3D

			(COMMAND "SCP" "3P" PA1 PA2 PB1 )																																					; PLANO-3DC ( 3D ) 
				(SETQ PA1p (LIST 0.0 0.0 0.0))
				(SETQ PA2p (TRANS PA2 0 1 ))
				(SETQ PB1p (TRANS PB1 0 1 ))
				(SETQ PB2p (TRANS PB2 0 1 ))
				"----------------------------------------------------------------------------------------------------------------------------"
		;		(COMMAND "COLOR" 1  "TEXTO"  (LIST 0.42 0.18)  0.42  0  (STRCAT (ITOA (+ NPuTa 1 )) "/" (ITOA (+ NTapa 1 ))))		; TEXTO-3D 
   		(COMMAND "SCP" "U")

			"==( 2D )======================================================================================================================"
			(COMMAND "SCP" "3P" KK1 KK2 "" )																																					; PLANO-3DC ( 2D ) PATRONES
				"----------------------------------------------------------------------------------------------------------------------------"
				(COMMAND "COLOR" COL   "3DCARA" PA1p  PA2p  PB2p  PB1p "")																							; 3DCARA-2D

				(SETQ PB1pU (TRANS PB1p 1 0 ))
				(SETQ PB2pU (TRANS PB2p 1 0 ))
				(SETQ KK1 PB1pU )
				(SETQ KK2 PB2pU )
				"----------------------------------------------------------------------------------------------------------------------------"
		;		(COMMAND "COLOR" 1  "TEXTO"  (LIST 0.42 0.18)  0.42  0  (STRCAT (ITOA (+ NPuTa 1 )) "/" (ITOA (+ NTapa 1 ))))		; TEXTO-2D 
   		(COMMAND "SCP" "U")

		) ; repe NTapa
	) ; repe NPuTa
)) ;"pro if #####################################################"


	;=====================================================================================================================================
	;	(16) PARANDO																																																												
	;=====================================================================================================================================
	(SETVAR "blipmode" 1) (SETVAR "cmdecho" 1)

) ;CIERRE DEFUN  CAJAS-CARAS-PLANAS--nSPL-nARISTAS-PUN-MEDIO-02

;=======================================================================================================================================


