

"#########################################################################################################################################"
;==========================================================================================================================================
;																																																																					 
;	 ( CAJAS-CARAS-PLANAS-entre-SPLINES-06a )					                                                                         16/10/2009		 
;																																																																					 
;					SECCION BASE INDEPENDIENTE (POLILINEA) y SPLINE COLUMNA-VERTEBRAL  (POR INTERSECCION VELTORIAL de 3 CARAS)											 
;																																																																					 
;  DATOS :     SPLINES PERFILES PLANOS-CARAS => SPLINE COLUMNA-VERTEBRAL DEFINE SECCIONES PLANOS DE CORTE y PUNTOS-BASE (POLILINEA-3D)     
;==========================================================================================================================================
"#########################################################################################################################################"





;------------------------------------------------------------------------------------------------------------------------------------------
;	PUNTOS-SPLI-DIVIDE   DIVIDE SPLINE ( NomSpl ) con ( Ndivide ) => LISTA PUNTOS ( LIS-PUN-SPL )  									                       
;------------------------------------------------------------------------------------------------------------------------------------------

	(DEFUN PUNTOS-SPLI-DIVIDE ( / )

		(SETQ LIS-PUN-SPL nil)
		(SETQ ALIS  (ENTGET NomSpl))  																								; lista Spline A
		(SETQ AELE  (ASSOC 10 ALIS))  																								; 1 Punto Asociado a 10 (10.punto)
		(SETQ AELES (MEMBER AELE ALIS)) 																							; lista a partir del Alterior (10.punto)....(11.punto)
		(SETQ X-primer (CDR (NTH 0 AELES))) 																					; primer elemento (10.punto)
		(SETQ X-ultimo (CDR (NTH (- (LENGTH AELES) 1) AELES)))												; ultimo elemento (11.punto)
		(COMMAND "COLOR" COLO )																												; COLOR  = A
		;(COMMAND "TEXTO" "MI" X-primer 5.0 0 TEX)																		;  TEXTO = A
		(COMMAND "PUNTO" X-primer)																										; PINTA 1 punto A
		(SETQ N-enti-A1 (ENTLAST))																										; nombre ultima entidad principal 1 punto A
		(COMMAND "DIVIDE" NomSpl Ndivide)																						; GRADUA SPLI-A
		(COMMAND "PUNTO" X-ultimo)																										; PINTA Ultimo Punto A
		;	PUNTOS SECCION-A (PA1-PAn) =>   LIS-PUN-SPL  Lon-LPA													                                                       
		(SETQ LIS-PUN-SPL nil)																												; LISTA  PUNTOS-A
		(SETQ LIS-PUN-SPL (CONS (CDR (ASSOC 10 (ENTGET N-enti-A1))) LIS-PUN-SPL))			; lista entidad -> (1 Punto-A)
		(SETQ W1A T)
		(WHILE W1A
			(SETQ N-enti-A2 (ENTNEXT N-enti-A1))																				; Nombre entidad siguiente
			(COMMAND "BORRA" N-enti-A1 "")																							; BORRA entidad (Punto)
			(IF (= N-enti-A2 nil)  (SETQ W1A nil)
				(PROGN
					(SETQ LIS-PUN-SPL (CONS (CDR (ASSOC 10 (ENTGET N-enti-A2))) LIS-PUN-SPL))
					(SETQ N-enti-A1  N-enti-A2 )
				);progn
			);if
		) ;While W1A
		;	LISTA ( LIS-PUN-SPL ) Ordenada																                                                                       
		(SETQ LIS-PUN-SPL (REVERSE LIS-PUN-SPL ))																			; ( LIS-PUN-SPL Ordenada )

	) ; Defun PUNTOS-SPLI-DIVIDE

;																						                                                                                               


	;========================================================================================================================================
	;	INDICE																																																																 
	;========================================================================================================================================
	;	(00) ARRANCANDO																																																												 
	;	(01) DATOS INTERNOS       Ndivide																												                                             
	; (02) DATOS EXTERNOS														   																																											 
	;	(03) PUNTOS SPLINE-PERFILES  NOMBRE  con  Ndivide  =>  LIS-PUN-SPL => LIS-LIS-P-SLI-LONGI                     	 	 	 									 
	;	(04) PUNTOS SPLINE COLUM-VERTEBRAL  NOMBRE  con  Ndivide  =>  LIS-PUN-COLUM-Vertebral       	 	 	 											 							 
	; (05) PUNTOS BASE-0   PUNTOS ORDENADOS POLILINEA-3D BASE    =>  LIS-PUN-BASE-INI     																									 
	;----------------------------------------------------------------------------------------------------------------------------------------
	;	(06) PINTA y NUMERA 1PUNTOS de SPLINES PERFILES y COLUMNA-VERTEBRAL       	 	 	 											 							 									 
	; (07) PINTA y NUMERA PUNTOS LIS-PUN-BASE-INI        																																										 
	;----------------------------------------------------------------------------------------------------------------------------------------
	;	(08) LISTAS PUNTOS de SPLINES por SECC-TRANVERSALES      LIS-LIS-P-SLI-LONGI  =>	 LIS-LIS-P-SLI-TRANS										   					 
	;	(09) PLANOS NORMALES a COLUMNA-VERTEBRAL                 LIS-PUN-COLUM-Vertebral	=>	LIS-3PUN-PLA-NorColVer												 	 
	;----------------------------------------------------------------------------------------------------------------------------------------
	;	(10) PINTA LINEAS o 3DCARAS  BORDE de 3P-PLANOS    ( COMPROBACION )                 	 	 				 																			 
	;----------------------------------------------------------------------------------------------------------------------------------------
	;	(11) PUNTOS-INTER de las SPLINES con PLANOS-NORMALES-COLUMNA    LIS-3PUN-PLA-NorColVer + LIS-LIS-P-SLI-LONGI	=>	LIS-LIS-pSPL-SecNOR	 
	;	(12) AADE  Ps-Prinera-SECC y  Ps-Ultima-SECC a ( LIS-LIS-pSPL-SecNOR )  =>  LIS-LIS-pSPL-SecNOR+ini                 	 	 			 				 
	;----------------------------------------------------------------------------------------------------------------------------------------
	;	(13) PINTA 3DCARAS con PUNTOS de LIS-LIS-pSPL-SecNOR+ini con PRIMERA y ULTIMA SECC    =>	3DCARAS   ( COMPROBACION )           				 
	;----------------------------------------------------------------------------------------------------------------------------------------
	;	(14) PUNTO INTERSECCION de PLANOS-2CARAS con PLANO-SECC     INTER-3-PLANOS (VECTORIAL)                                              	 
	;	 	(14-1)  DETERMINAN PLANO SECCION NSEC  3-PUNTOS(0 1 2) NSEC (1..20) LIS-LIS-pSPL-SecNOR+ini   =>   PLAo PLAx PLAy 							 	 
	;	 	(14-2)  PUNTOS BASE-USO  			Si (= NSEC 1 ) => ( BASE-USO = BASE-0 ) SiNo ( BASE-USO = BASE-INTER )			          							 	 
	;	 	(14-3)  PUNTOS BASE-INTER  	PUN-SECC-INTERSECCION-3PLANOS			=>		LIS-PUN-INTER-BASE																							 
	;----------------------------------------------------------------------------------------------------------------------------------------
	; (15) PINTA 3DC CARAS LATERALES CAJA                                                         																					 
	;	(16) PARANDO																																																													 
	;========================================================================================================================================

	;=======================================================================================================================================
	; FORMACION de CARA-PLANA :   2-PUN SECC-1 (BASE-USO)  +  1/PUN SECC-2 (SPLINES-PERFILES)  +  SECC NORMAL a SPL-COLUMNA-VERTEBRAL				
	;=======================================================================================================================================
	;	(01) DATOS INTERNOS       Ndivide																												                                            
	; (02) DATOS EXTERNOS				SPLINES-PERFILES         --->  (03) LIS-LIS-P-SLI-LONGI --->  (08) LIS-LIS-P-SLI-TRANS											
	;                           SPLINE-COLUMNA-VERTEBRAL --->  (04) LIS-PUN-COLUM-Vertebral																									
	;                           POLILINEA-3D-BASE        --->  (05) LIS-PUN-BASE-INI																												
	;---------------------------------------------------------------------------------------------------------------------------------------
	;	(09) PLANOS NORMALES a COLUMNA-VERTEBRAL                 LIS-PUN-COLUM-Vertebral	--->	(09) LIS-3PUN-PLA-NorColVer										
	;---------------------------------------------------------------------------------------------------------------------------------------
	;	(11) PUNTOS INTER SPLINES PLANOS-NORMAL-COLUM  + PRI/pSPL + ULT/pSPL  	--->	(11) (12) LIS-LIS-pSPL-SecNOR+ini												
	;---------------------------------------------------------------------------------------------------------------------------------------
	;	(14) PUNTO INTER-3-PLANOS ( CARA1 + CARA2 + SECC )                                                   	 																
	;																																																																				
	;	 	(14-1)  DETERMINAN PLANO SECCION NSEC  3-PUNTOS(0 1 2) NSEC (1..20) LIS-LIS-pSPL-SecNOR+ini   =>   PLAo PLAx PLAy 								
	;																																																																				
	;	 	(14-2)  PUNTOS BASE-USO  			Si (= NSEC 1 ) => ( BASE-USO = BASE-0 ) SiNo ( BASE-USO = BASE-INTER )			          								
	;																																																																				
	;	 	(14-3)  PUNTOS BASE-INTER  	PUN-SECC-INTERSECCION-3PLANOS			=>		LIS-PUN-INTER-BASE																							
	;---------------------------------------------------------------------------------------------------------------------------------------


"#########################################################################################################################################"
;==========================================================================================================================================
;	  *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** 							 
;==========================================================================================================================================
"#########################################################################################################################################"

(DEFUN C:CAJAS-CARAS-PLANAS-entre-SPLINES-06a (/ )

	;========================================================================================================================================
	;	(00) ARRANCANDO																																																												 
	(SETVAR "blipmode" 0) (SETVAR "cmdecho" 0) (GRAPHSCR) (COMMAND "-REFENT" "DES"  "SCP" "U"  "ORTO" "DES")
	(IF (= CAL nil)(COMMAND "ARX" "L" "GEOMCAL.ARX"))			; CARGA CALCULADORA

	;========================================================================================================================================
	;	(01) DATOS INTERNOS       Ndivide																												                                             
	"///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////"
	(SETQ Ndivide  60 )			;  NO mas de  32768  Divisiones 
	"///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////"
	;----------------------------------------------------------------------------------------------------------------------------------------
	; (02) DATOS EXTERNOS														   																																											 
	(TERPRI)
	(PROMPT                       "####################################################################")   (TERPRI)
	(PROMPT                       " ---------------- MARCA SPLINES PERFILES en ORDEN -----[ENTER]------")   (TERPRI)
	(SETQ CONJ-SPL-PER (SSGET))																																												; (SSLENGTH CONJ-SPL-PER )
	(SETQ NoCOLU     (CAR (ENTSEL " >>>>>>>>>>>>>>>> MARCA SPLINE  COLUMNA-VERTEBRAL <<<<<<<<<<<<<<<<<<"))) (TERPRI)	; nombre Spline COLUM-VERTEBRAL
	(SETQ NoPOL-3D-0 (CAR (ENTSEL " >>>>>>>>>>>>>>>> MARCA POLILINEA-3D BASE (ORDEN y ALINEADAS) <<<<<<"))) (TERPRI)	; nombre POLILINEA-3D BASE 
	(PROMPT                       "####################################################################")   (TERPRI)


	;========================================================================================================================================
	;	(03) PUNTOS SPLINE-PERFILES  NOMBRE  con  Ndivide  =>  LIS-PUN-SPL => LIS-LIS-P-SLI-LONGI                     	 	 	 									 

	(SETQ LIS-LIS-P-SLI-LONGI nil )

	(SETQ N0 -1 )
	(REPEAT (SSLENGTH CONJ-SPL-PER )																																		; (SSLENGTH CONJ-SPL-PER ) 3 
		(SETQ N0 (+ N0  1 ))
		(SETQ NomSpl (SSNAME CONJ-SPL-PER N0 ))   																												; <Nombre entidad: 7efd3c98> 
		(SETQ COLO (+ N0 1)  TEX (ITOA (+ N0 1)))
		(PUNTOS-SPLI-DIVIDE) 																																							; => LIS-PUN-SPL 
		(SETQ LIS-LIS-P-SLI-LONGI (CONS LIS-PUN-SPL   LIS-LIS-P-SLI-LONGI ))															; (LENGTH LIS-PUN-SPL )   81 
	) ; repe N0 

	(SETQ LIS-LIS-P-SLI-LONGI (REVERSE LIS-LIS-P-SLI-LONGI ))     																			; (LENGTH LIS-LIS-P-SLI-LONGI ) 6 


	;========================================================================================================================================

		(SETQ NomSpl NoCOLU)   																																						; <Nombre entidad: 7efd3c98> 
		(PUNTOS-SPLI-DIVIDE) 																																							; => LIS-PUN-SPL 
		(SETQ LIS-PUN-COLUM-Vertebral   LIS-PUN-SPL )																											; (LENGTH LIS-PUN-COLUM-Vertebral ) 21 


	;========================================================================================================================================
	; (05) PUNTOS BASE-0   PUNTOS ORDENADOS POLILINEA-3D BASE    =>   LIS-PUN-BASE-INI     																									 

	(SETQ LIS-PUN-BASE-INI  nil )
	(SETQ LISpO-3D-0 (ENTGET  NoPOL-3D-0 ))
	
	(SETQ WW1 T )
	(WHILE WW1
		(SETQ NoPOL-3D-1 (ENTNEXT NoPOL-3D-0 ))
		(SETQ LISpO-3D-1 (ENTGET  NoPOL-3D-1 ))
		(SETQ ENDI  (CDR (ASSOC 0 LISpO-3D-1 )))

		(IF (= ENDI "VERTEX" )
			(PROGN
				(SETQ CORD (CDR (ASSOC 10 LISpO-3D-1 )))
				(SETQ LIS-PUN-BASE-INI (CONS CORD  LIS-PUN-BASE-INI ))
				(SETQ NoPOL-3D-0  NoPOL-3D-1 )
			) ; pro
			(PROGN
				(SETQ WW1 nil )
			) ; pro
		) ; if
	) ; WW1
	
	(SETQ LIS-PUN-BASE-INI (REVERSE LIS-PUN-BASE-INI ))

	;========================================================================================================================================
	;	(06) PINTA y NUMERA 1PUNTOS de SPLINES PERFILES y COLUMNA-VERTEBRAL       	 	 	 											 							 									 

	(SETQ N1 -1 )
	(REPEAT (LENGTH LIS-LIS-P-SLI-LONGI )																																; (LENGTH LIS-LIS-P-SLI-LONGI )  
		(SETQ N1 (+ N1  1 ))
		(SETQ P0x  (NTH 0 (NTH N1  LIS-LIS-P-SLI-LONGI )))
		(SETQ NS1 (+ (REM (+ N1 0 ) (LENGTH LIS-LIS-P-SLI-LONGI )) 1 ))
		(SETQ NS2 (+ (REM (+ N1 1 ) (LENGTH LIS-LIS-P-SLI-LONGI )) 1 ))
		(COMMAND  "COLOR" 255  "CIRCULO" P0x 0.9   "TEXTO" "MC" P0x 0.35 0 (STRCAT "S" (ITOA NS1) "-" (ITOA NS2)) )
	) ; repe N1 
	(SETQ P0c (NTH 0 LIS-PUN-COLUM-Vertebral ))
	(COMMAND    "COLOR" 255  "CIRCULO" P0c 0.9    "TEXTO" "MC" P0c 0.35 0 (STRCAT "S" (ITOA 0 )) )


	;========================================================================================================================================
	; (07) PINTA y NUMERA PUNTOS LIS-PUN-BASE-INI        																																										

	(SETQ N2 -1 )
	(REPEAT (LENGTH LIS-PUN-BASE-INI )																				; (LENGTH LIS-PUN-BASE-INI ) 4 
		(SETQ N2 (+ N2  1 ))
		(SETQ P0b (NTH N2  LIS-PUN-BASE-INI ))
		(COMMAND  "COLOR"   1  "CIRCULO" P0b 0.6  "TEXTO" "MC" P0b  0.35 0 (STRCAT "V" (ITOA (+ N2 1 ))) )
	) ; repe N2 

			;                                                                                                                                
			;                                                                                                                                
			;                         #D5---------------------#C5                                                                            
			;                        /|                      /|                                                                              
			;                       / #D4                   / #C4                                                                            
			;                      /  |                    /  |          LIS-LIS-P-SLI-LONGI =>                                              
			;                     /   #D3     |           /   #C3          (LIS-PUN-SP-A  LIS-PUN-SPL-B  LIS-PUN-SPL-C  LIS-PUN-SPL-D ...)   
			;                    /    |       |          /    |                                                                              
			;                   #A5---------------------#B5   #C2                                                                            
			;                   |     |       |         |     |          LIS-PUN-COLUM-Vertebral                                             
			;                   #A4   #D1     |         #B4   #C1                                                                            
			;                   |     |       |         |     |                                                                              
			;                   #A3   #D0-----|---------#B3---#C0                                                                            
			;                   |    /|       |         |    /|                                                                              
			;                   #A2 / SPL-D   |         #B2 / SPL-C                                                                          
			;                   |  /          |         |  /                                                                                 
			;                   #A1       SPL-COLU      #B1                                                                                  
			;                   |/                      |/                                                                                   
			;                   #A0---------------------#B0                                                                                  
			;                   |                       |                                                                                    
			;                   SPL-A                   SPL-B                                                                                
			;                                                                                                                                

	;========================================================================================================================================
	;	(08) LISTAS PUNTOS de SPLINES por SECC-TRANVERSALES      LIS-LIS-P-SLI-LONGI  =>	 LIS-LIS-P-SLI-TRANS										   					 

	(SETQ LIS-LIS-P-SLI-TRANS nil )    ; LIS-LIS-P-SLI-TRANS
	(SETQ NPun -1 )
	(REPEAT (LENGTH (NTH 0 LIS-LIS-P-SLI-LONGI))  																						; N-PUN-SPL  21 FILAS 
		(SETQ NPun (+ NPun 1 ))																																			; 0..12 

		(SETQ LIS-PUN-SECC nil )
		(SETQ NSpl -1 )
		(REPEAT (LENGTH LIS-LIS-P-SLI-LONGI )																									; N-SPLNES   6 COLUMNAS 
			(SETQ NSpl (+ NSpl 1 ))																																		; 0..5 
			(SETQ PUsIZs (NTH NPun (NTH NSpl  LIS-LIS-P-SLI-LONGI )))
			(SETQ LIS-PUN-SECC (CONS PUsIZs  LIS-PUN-SECC ))
		) ; repe NSpl
		(SETQ LIS-PUN-SECC (REVERSE LIS-PUN-SECC ))																						; (LENGTH LIS-PUN-SECC ) 6 
		(SETQ LIS-LIS-P-SLI-TRANS (CONS LIS-PUN-SECC   LIS-LIS-P-SLI-TRANS ))

	) ; repe NPun
	(SETQ LIS-LIS-P-SLI-TRANS (REVERSE LIS-LIS-P-SLI-TRANS ))																; (LENGTH LIS-LIS-P-SLI-TRANS ) 21 


	;========================================================================================================================================
	;	(09) PLANOS NORMALES a COLUMNA-VERTEBRAL                 LIS-PUN-COLUM-Vertebral	=>	LIS-3PUN-PLA-NorColVer												 			 

	;                                                                
	;                                   O PC3                        
	;                                   |                            
	;                                   |                            
	;                          PmC23    |                            
	;                  CenC O-----O-----O PmC23                      
	;                       |           |                            
	;                       |           |                            
	;                 PnC12 O  PnC2x O  |                            
	;                       |         \ |                            
	;                       |          \|                            
	;          PC1 O--------O-----------O PC2                        
	;                     PmC12        /                             
	;                                 /                              
	;                          PnC2y O                               
	;                                                                

	(SETQ LIS-3PUN-PLA-NorColVer nil )

	(SETQ NA -1 )
	(REPEAT (- (LENGTH LIS-PUN-COLUM-Vertebral ) 2 )																											; 21 -2 = 19 
		(SETQ NA (+ NA 1 ))																																								; 0..18 

		(SETQ PC1 (NTH (+ NA 0 ) LIS-PUN-COLUM-Vertebral ))
		(SETQ PC2 (NTH (+ NA 1 ) LIS-PUN-COLUM-Vertebral ))
		(SETQ PC3 (NTH (+ NA 2 ) LIS-PUN-COLUM-Vertebral ))

		(SETQ PnC2y (CAL " PC2 + ( 5 * NOR( PC1 , PC2 , PC3 ))"))																						; PUN EJE/Y    LONGITUD VECTOR # 5 

		(SETQ PmC12 (CAL " PLT( PC1 , PC2 , 0.5 )"))																												; PUN MEDIO 
		(SETQ PmC23 (CAL " PLT( PC2 , PC3 , 0.5 )"))

		(SETQ PnC12 (CAL " PmC12 + NOR( PC1 , PC2 , PnC2y )"))
		(SETQ PnC23 (CAL " PmC23 + NOR( PC2 , PC3 , PnC2y )"))

		(SETQ CenC   (CAL " ILL( PmC12 , PnC12 , PmC23 , PnC23 )"))																					; INTERSECCION 2-LINEAS 
		(SETQ PnC2x  (CAL " PC2 + ( 5 * VEC1( PC2 , CenC ))"))																							; PUN EJE/X    LONGITUD VECTOR # 5 

		(SETQ LIS-3PUN-PLA-NorColVer (CONS (LIST PC2  PnC2x  PnC2y )  LIS-3PUN-PLA-NorColVer ))

		;(COMMAND "COLOR" 255 "LINEA" PnC2x  PC2  PnC2y "" )

	) ; repe NA

	(SETQ LIS-3PUN-PLA-NorColVer (REVERSE LIS-3PUN-PLA-NorColVer ))																								; (LENGTH LIS-3PUN-PLA-NorColVer ) 19 


 (IF nil (PROGN  ;//////////////////////////  COMPROBACION  ///////////////////////////////////////////////////////////////////////////////
	;========================================================================================================================================
	;	(10) PINTA LINEAS o 3DCARAS  BORDE de 3P-PLANOS    ( COMPROBACION )                 	 	 				 																			 

	;                                                                 
	;                    O B3                                         
	;                B0 /|                                            
	;        B4 O------O------O B2                                    
	;           |     /| |    |                                       
	;           | B1 O | |    |                                       
	;           |    | | |    |                                       
	;           |    | | O A3 |                                       
	;           |    | |/     |                                       
	;        A4 O----|-O------O A2                                    
	;                |/ A0                                            
	;             A1 O                                                
	;                                                                 

	(SETQ NBO -1 )
	(REPEAT (- (LENGTH LIS-3PUN-PLA-NorColVer ) 1 )																												; N-PLANOS       48    
		(SETQ NBO (+ NBO 1 ))																																							; 0..18

		(SETQ A0 (NTH 0 (NTH (+ NBO 0 ) LIS-3PUN-PLA-NorColVer )))
		(SETQ A1 (NTH 1 (NTH (+ NBO 0 ) LIS-3PUN-PLA-NorColVer )))
		(SETQ A2 (NTH 2 (NTH (+ NBO 0 ) LIS-3PUN-PLA-NorColVer )))
		;(SETQ A3 (CAL " A0 + VEC( A1 , A0 ) "))
		;(SETQ A4 (CAL " A0 + VEC( A2 , A0 ) "))

		(SETQ B0 (NTH 0 (NTH (+ NBO 1 ) LIS-3PUN-PLA-NorColVer )))
		(SETQ B1 (NTH 1 (NTH (+ NBO 1 ) LIS-3PUN-PLA-NorColVer )))
		(SETQ B2 (NTH 2 (NTH (+ NBO 1 ) LIS-3PUN-PLA-NorColVer )))
		;(SETQ B3 (CAL " B0 + VEC( B1 , B0 ) "))
		;(SETQ B4 (CAL " B0 + VEC( B2 , B0 ) "))

		(COMMAND "COLOR" 255 "LINEA" A0  A1 "" )
		(COMMAND "COLOR" 255 "LINEA" A1  B1 "" )
		(COMMAND "COLOR"   5 "LINEA" A0  A2 "" )
		(COMMAND "COLOR"   5 "LINEA" A2  B2 "" )
		(COMMAND "COLOR"   7 "LINEA" A0  B0 "" )
		(IF (= (+ NBO 1 ) (- (LENGTH LIS-3PUN-PLA-NorColVer ) 1 ))
			(PROGN
				(COMMAND "COLOR" 255 "LINEA" B0  B1 "" )
				(COMMAND "COLOR"   5 "LINEA" B0  B2 "" )
			) ; pro
		) ; if

	) ; repe NBO 

 ))  ;IF PROGN  /////////////////////////////  COMPROBACION  //////////////////////////////////////////////////////////////////////////////


	;========================================================================================================================================
	;	(11) PUNTOS-INTERSECCION de las SPLINES con PLANOS-NORMALES-COLUMNA    LIS-3PUN-PLA-NorColVer + LIS-LIS-P-SLI-LONGI	=>	LIS-LIS-pSPL-SecNOR

	(SETQ LIS-LIS-pSPL-SecNOR  nil )

(SETQ EGECUTA-Pro T )

(IF EGECUTA-Pro (PROGN  ; NPLA PLANOS 

	(SETQ NPLA -1 )
	(REPEAT (LENGTH LIS-3PUN-PLA-NorColVer )																						; N-PLANOS        19 
		(SETQ NPLA (+ NPLA 1 ))																																				; 0..18 

		(SETQ ppO (NTH 0 (NTH NPLA  LIS-3PUN-PLA-NorColVer )))																						; PUNTOS PLANO-NOR-COLUMNA 
		(SETQ ppX (NTH 1 (NTH NPLA  LIS-3PUN-PLA-NorColVer )))
		(SETQ ppY (NTH 2 (NTH NPLA  LIS-3PUN-PLA-NorColVer )))																						; (LIST  PC2  PnC2x  PnC2y ) 

		; (COMMAND "COLOR" 4 "LINEA" ppX ppO ppY "" )

		(SETQ LIS-pSPL-SecNOR  nil )

(IF EGECUTA-Pro (PROGN  ; NSPL  SPLINES

		(SETQ NSPL  -1 )
		(REPEAT (LENGTH LIS-LIS-P-SLI-LONGI )																							; N-SPLINES       6  
			(SETQ NSPL (+ NSPL 1 ))																																			; 0..5  

			(SETQ LIS-INT-1SPL  nil )
			(SETQ NPUN  -1 )
			(REPEAT (- (LENGTH (NTH NSPL  LIS-LIS-P-SLI-LONGI )) 1 )
				(SETQ NPUN (+ NPUN 1 ))																											; N-PUNTO-SPL   0..19  1..20 

				(SETQ Ps1 (NTH (+ NPUN 0 ) (NTH NSPL  LIS-LIS-P-SLI-LONGI )))
				(SETQ Ps2 (NTH (+ NPUN 1 ) (NTH NSPL  LIS-LIS-P-SLI-LONGI )))

				(SETQ PIn12 (CAL " ILP( Ps1 , Ps2 ,  ppO , ppX , ppY)"))																		; INTERSEC LINE PLANO
				(SETQ Dis12 (DISTANCE Ps1   Ps2 ))
				(SETQ Dis1  (DISTANCE PIn12 Ps1 ))
				(SETQ Dis2  (DISTANCE PIn12 Ps2 ))

				(IF (EQUAL Dis12 (+ Dis1 Dis2 ) 0.0001)																											; INTER DENTRO de Ps1 Ps2 
					(PROGN
						(SETQ PunPLA (CAL "PLT( Ps1 , Ps2 , Dis1 / ( Dis1 + Dis2 ))"))													; PUN en LINEA en % 
						(SETQ LIS-INT-1SPL (CONS (LIST PunPLA  ppO )  LIS-INT-1SPL ))
					) ; pro
				) ; if

			) ; repe NPUN

(IF EGECUTA-Pro (PROGN  ; PLANO FUERA 

			(IF (= (LENGTH LIS-INT-1SPL ) 0 )
				(PROGN
					(PROMPT "   INTER del PLANO FUERA de Ps1 Ps2 ERROR?  ## FIN PROGRAMA ##")
				  (PROMPT "  NPLA = ") (PRIN1 NPLA )
					(PROMPT "  NSPL = ") (PRIN1 NSPL ) (TERPRI)

					(SETQ EGECUTA-Pro nil )

					(SETQ ppZ  (CAL " ppO + ( 5 * NOR( ppO , ppX , ppY )) "))

					(SETQ ppX+ (CAL " ppO + ( 50 * VEC1( ppO , ppX ))"))
					(SETQ ppX- (CAL " ppO - ( 50 * VEC1( ppO , ppX ))"))

					(SETQ ppY+ (CAL " ppO + ( 50 * VEC1( ppO , ppY ))"))
					(SETQ ppY- (CAL " ppO - ( 50 * VEC1( ppO , ppY ))"))

					(COMMAND "COLOR" 7 "LINEA" ppX+ ppX- "" )
					(COMMAND "COLOR" 5 "LINEA" ppY+ ppY- "" )
					(COMMAND "COLOR" 1 "LINEA" ppO  ppZ  "" )

					(COMMAND "SCP" "3P" ppO ppX+ ppZ )
						(COMMAND "_PLAN" "A" )
					(COMMAND "SCP" "U" )

				) ; pro

				(PROGN
        	(COND
				 		((= (LENGTH LIS-INT-1SPL ) 0 )
					 	(PROMPT "  ### INTER del PLANO FUERA de Ps1 Ps2  ERROR? ###")
				   	(PROMPT "  NPLA = ") (PRIN1 NPLA ) (PROMPT "  NSPL = ") (PRIN1 NSPL ) (TERPRI)) ; con0 

						((= (LENGTH LIS-INT-1SPL ) 1 )  (SETQ LIS-pSPL-SecNOR (CONS PunPLA  LIS-pSPL-SecNOR )))	; con1 

						((= (LENGTH LIS-INT-1SPL ) 2 )

							(SETQ PuPla1 (NTH 0 (NTH 0  LIS-INT-1SPL )))
							(SETQ PuPla2 (NTH 0 (NTH 1  LIS-INT-1SPL )))

							(SETQ ppO1   (NTH 1 (NTH 0  LIS-INT-1SPL )))
							(SETQ ppO2   (NTH 1 (NTH 1  LIS-INT-1SPL )))

							(IF (EQUAL ppO1 ppO2 0.0001)
								(PROGN
									(IF (AND (EQUAL ppO1 ppO2 0.0001) (> (DISTANCE PuPla1 ppO1 ) (DISTANCE PuPla2 ppO1 )))
										(PROGN
											(SETQ LIS-pSPL-SecNOR (CONS PuPla2  LIS-pSPL-SecNOR ))
										) ; pro
										(PROGN
											(SETQ LIS-pSPL-SecNOR (CONS PuPla1  LIS-pSPL-SecNOR ))
										) ; pro
									) ; if 
								) ; pro
								(PROGN
									(PROMPT "  ### NO IGUALES ppO1 ppO2  ERROR? ### ") (PRIN1 ppO1 ) (PROMPT " / ") (PRIN1 ppO2 ) (TERPRI)
								) ; pro
							)	; if 
				 		) ; con2 

						((= (LENGTH LIS-INT-1SPL ) 3 ) (PROMPT " =========> 3 INTER en NPLA = ") (PRIN1 NPLA ) (PROMPT "  NSPL = ") (PRIN1 NSPL ) (TERPRI))
						((= (LENGTH LIS-INT-1SPL ) 4 ) (PROMPT " ============> 4 INTER en NPLA = ") (PRIN1 NPLA ) (PROMPT "  NSPL = ") (PRIN1 NSPL ) (TERPRI))
						((= (LENGTH LIS-INT-1SPL ) 5 ) (PROMPT " ===============> 5 INTER en NPLA = ") (PRIN1 NPLA ) (PROMPT "  NSPL = ") (PRIN1 NSPL ) (TERPRI))
					)	; con


					(SETQ EGECUTA-Pro T )
				) ; pro
			) ; if

)) ; if pro PLANO FUERA 

		) ; repe NSPL

)) ; if pro EGECUTA-Pro  NSPL

		(SETQ LIS-pSPL-SecNOR  (REVERSE LIS-pSPL-SecNOR ))																			; (LENGTH LIS-pSPL-SecNOR )  
		(SETQ LIS-LIS-pSPL-SecNOR (CONS LIS-pSPL-SecNOR   LIS-LIS-pSPL-SecNOR ))

	) ; repe NPLA

)) ; if pro EGECUTA-Pro  NPLA

	;========================================================================================================================================
	;	(12) AADE  Ps-Prinera-SECC y  Ps-Ultima-SECC a ( LIS-LIS-pSPL-SecNOR )  =>  LIS-LIS-pSPL-SecNOR                 	 	 			 

(IF EGECUTA-Pro (PROGN  ; (12) - (15) 

	(SETQ LIS-P-SEC-00 (NTH 0 LIS-LIS-P-SLI-TRANS ))																					; PRIMERA SECC (LENGTH LIS-P-SEC-00 ) 6 
	(SETQ LIS-P-SEC-UL (LAST  LIS-LIS-P-SLI-TRANS ))																					; ULTIMA  SECC (LENGTH LIS-P-SEC-UL ) 6 

	(SETQ LIS-LIS-pSPL-SecNOR+ini (CONS LIS-P-SEC-UL   LIS-LIS-pSPL-SecNOR   ))
	(SETQ LIS-LIS-pSPL-SecNOR+ini (REVERSE             LIS-LIS-pSPL-SecNOR+ini ))
	(SETQ LIS-LIS-pSPL-SecNOR+ini (CONS LIS-P-SEC-00   LIS-LIS-pSPL-SecNOR+ini ))							; (LENGTH LIS-LIS-pSPL-SecNOR+ini ) 21 


 (IF nil (PROGN  ;/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	;========================================================================================================================================
	;	(13) PINTA 3DCARAS con PUNTOS de LIS-LIS-pSPL-SecNOR+ini con PRIMERA y ULTIMA SECC    =>	3DCARAS   ( COMPROBACION )           

	(SETQ NE -1 )
	(REPEAT (- (LENGTH LIS-LIS-pSPL-SecNOR+ini ) 1 )	
		(SETQ NE (+ NE 1 ))
		(SETQ LIS-P-SecA (NTH (+ NE 0 ) LIS-LIS-pSPL-SecNOR+ini ))
		(SETQ LIS-P-SecB (NTH (+ NE 1 ) LIS-LIS-pSPL-SecNOR+ini ))

		(SETQ NF -1 )
		(REPEAT (LENGTH LIS-P-SecA )
			(SETQ NF (+ NF 1 ))
			(SETQ PSA1 (NTH (REM (+ NF 0 ) (LENGTH LIS-P-SecA )) LIS-P-SecA ))
			(SETQ PSA2 (NTH (REM (+ NF 1 ) (LENGTH LIS-P-SecA )) LIS-P-SecA ))

			(SETQ PSB1 (NTH (REM (+ NF 0 ) (LENGTH LIS-P-SecB )) LIS-P-SecB ))
			(SETQ PSB2 (NTH (REM (+ NF 1 ) (LENGTH LIS-P-SecB )) LIS-P-SecB ))

	    (COMMAND  "COLOR" 4   "3DCARA" PSA1 PSA2 PSB2 PSB1 "")		; COMPROBACION 

		) ; repe NF 
	) ; repe NE

 ))  ;IF PROGN  /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



	;-------------------------------------------------------------------------------------------------------------------------------------
	;	(14) PUNTO INTERSECCION de PLANOS-2CARAS con PLANO-SECC     INTER-3-PLANOS (VECTORIAL)                                              
	;                                                                                                                                     
	;   3-PUN-BASE ( VER1 VER2 VER3 )    2-PUN-AJUSTE ( SPL12 SPL23 )    3-PUN-PLANO-SECC ( PLAo PLAx PLAy ) => INTERSECCION ( INver2 )   
	;-------------------------------------------------------------------------------------------------------------------------------------
	;                                                                                                                                     
	;                                          O PLAy                                                                                     
	;                                         /                   INTERSECCION de 3-PLANOS                                                
	;                                        /                                      PLANO-CARA-1 ( VER1  VER2  SPL12  )                   
	;                                       O SPL23                                 PLANO-CARA-2 ( VER2  VER3  SPL23  )                   
	;                                      /                    /                   PLANO-SECC-2 ( PLAo PLAx PLAy ) => ( INver2 )         
	;           PLAo        SPL12   PLAx O/                    / VnC1                                                                     
	;             O-----------O----------O  <== INver2                                                                                    
	;                                    |                   --- VnC2               ( VER1 VER2 VER3 )  LIS-PUN-BASE-USO                  
	;                                    |    O VER3                                                                                      
	;                                    |   /                 | Vn12               ( SPL12 SPL23 )     LIS-LIS-pSPL-SecNOR+ini           
	;                                    |  /                  |                                                                          
	;                                    | /                                        ( PLAo PLAx PLAy )  LIS-LIS-pSPL-SecNOR+ini           
	;                                    |/                                                                                               
	;        VER1 O----------------------O VER2                                                                                           
	;                                                                                                                                     
	;-------------------------------------------------------------------------------------------------------------------------------------

	(SETQ LIS-LIS-PUN-TAPA-CAJAS nil )

	(SETQ TOTAL/SEC (LENGTH LIS-LIS-pSPL-SecNOR+ini ))
	(SETQ TOTAL/VER (LENGTH     LIS-PUN-BASE-INI    ))

	(SETQ NSEC  0 )
	(REPEAT (- TOTAL/SEC 1 ) 																																				; NSECCION 51 
		(SETQ NSEC (+ NSEC 1 ))		 																																	; NSEC  0..50 

		; (14-1)  DETERMINAN PLANO SECCION NSEC  3-PUNTOS(0 1 2) NSEC (1..20) LIS-LIS-pSPL-SecNOR+ini   =>   PLAo PLAx PLAy 								

		(SETQ PLAo (NTH 0 (NTH NSEC  LIS-LIS-pSPL-SecNOR+ini )))															; 3 PUN DETERMINAN PLANO SECCION NSEC 
		(SETQ PLAx (NTH 1 (NTH NSEC  LIS-LIS-pSPL-SecNOR+ini )))
		(SETQ PLAy (NTH 2 (NTH NSEC  LIS-LIS-pSPL-SecNOR+ini )))

		; (14-2)  PUNTOS BASE-USO  			Si (= NSEC 1 ) => ( BASE-USO = BASE-0 ) SiNo ( BASE-USO = BASE-INTER )			          								

		(IF (= NSEC 1 ) (SETQ LIS-PUN-BASE-USO  LIS-PUN-BASE-INI ) (SETQ LIS-PUN-BASE-USO   LIS-PUN-INTER-BASE ))   ; SECC 0..60 

		; (14-3)  PUNTOS BASE-INTER  	PUN-SECC-INTERSECCION-3PLANOS			=>		LIS-PUN-INTER-BASE																						

		(SETQ LIS-PUN-INTER-BASE  nil )

		(SETQ NVER -1 )
		(REPEAT TOTAL/VER																																									; PUNS-SECC 8  
			(SETQ NVER (+ NVER 1 ))		   																																	; NVER  0..7 

			;                                                                                
			;                         SPL34                  DISPUSICION ORDENADA  de        
			;            VER4 O--------O--------O VER3                                       
			;                 |                 |            VERTICES POLILINEA BASE-INICIO  
			;                 |                 |                                            
			;                 |                 |            PUNTOS DE INICIO SPLINES        
			;           SPL41 O                 O SPL23                                      
			;                 |                 |                                            
			;                 |                 |                                            
			;                 |                 |                                            
			;            VER1 O--------O--------O VER2                                       
			;                        SPL12                                                   
			;                                                                                

			(SETQ VER1  (NTH (REM (+ NVER 0) TOTAL/VER ) LIS-PUN-BASE-USO )) 				 											; en SECC-0 
			(SETQ VER2  (NTH (REM (+ NVER 1) TOTAL/VER ) LIS-PUN-BASE-USO ))
			(SETQ VER3  (NTH (REM (+ NVER 2) TOTAL/VER ) LIS-PUN-BASE-USO ))

			(SETQ SPL12 (NTH (REM (+ NVER 0) TOTAL/VER ) (NTH NSEC  LIS-LIS-pSPL-SecNOR+ini )))						; en SECC-1 
			(SETQ SPL23 (NTH (REM (+ NVER 1) TOTAL/VER ) (NTH NSEC  LIS-LIS-pSPL-SecNOR+ini )))

			(SETQ VnC1 (CAL "NOR( VER1 , VER2 , SPL12 )"))																									; VECTOR NORMAL a CARA-1 
			(SETQ VnC2 (CAL "NOR( VER2 , VER3 , SPL23 )"))																									; VECTOR NORMAL a CARA-2 

			(SETQ Vn12 (CAL "NOR( VER2 , VER2 + VnC1 , VER2 + VnC2 )"))										; VECTOR NORMAL a VECTORES NORMALES a CARA-1 CARA-2 en VER2 

			(SETQ PuU2v   (CAL " VER2 + Vn12 "))																														; PUNTO de NORMAL en VER2 
			(SETQ INver2  (CAL "ILP( VER2 , PuU2v ,  PLAo , PLAx , PLAy )"))																; INTERSECCION 3-PLANOS (2-CARAS 1-SECC) 


			(IF (= INver2 nil)
				(PROGN (PROMPT " ---- INTERSECCION 3-PLANOS = NULA ???   NSEC = ") (PRIN1 NSEC) (PROMPT "   NVER = ") (PRIN1 NVER) (TERPRI))	; CONTROL

				(PROGN
					(IF (= (+ NVER 1 ) TOTAL/VER )																															; SI  NVER es el ULTIMO  
						(PROGN
							(SETQ INver2-ULT  INver2 )																															; NVER ULTIMO => INver2-ULT
						) ; pro

						(PROGN
							(SETQ LIS-PUN-INTER-BASE (CONS INver2   LIS-PUN-INTER-BASE ))
						) ; pro
					) ; if
				) ; pro
			) ; if
		) ; repe NVER

		(SETQ LIS-PUN-INTER-BASE     (REVERSE  LIS-PUN-INTER-BASE ))

		(SETQ LIS-PUN-INTER-BASE     (CONS INver2-ULT  LIS-PUN-INTER-BASE ))													; AADE el ULTIMO al PRINCIPIO 

		(SETQ LIS-LIS-PUN-TAPA-CAJAS (CONS LIS-PUN-INTER-BASE    LIS-LIS-PUN-TAPA-CAJAS ))

	) ; repe NSEC

	(SETQ LIS-LIS-PUN-TAPA-CAJAS (REVERSE LIS-LIS-PUN-TAPA-CAJAS ))   													  	; (LENGTH LIS-LIS-PUN-TAPA-CAJAS ) 11 

	(SETQ LIS-LIS-PUN-TAPA-CAJAS (CONS LIS-PUN-BASE-INI    LIS-LIS-PUN-TAPA-CAJAS ))


	;---------------------------------------------------------------------------------------------------------------------------------------
	; (15) PINTA 3DC CARAS LATERALES CAJA                                                         																					

	(SETQ LIS-COLO '( 1 2 3 4 5 6 1 2 3 4 5 6 ))

	(SETQ N10 -1 )
	(REPEAT (LENGTH (NTH 0 LIS-LIS-PUN-TAPA-CAJAS ))
		(SETQ N10 (+ N10 1 ))

		(SETQ KK1 (LIST (* 90 (+ N10 1 )) -50.0  0.0 ))																	; PUNTOS ARRAN PATRONES 
		(SETQ KK2 (LIST (* 91 (+ N10 1 )) -50.0  0.0 ))

		(SETQ N11 -1 )
		(REPEAT (- (LENGTH LIS-LIS-PUN-TAPA-CAJAS ) 1 )
			(SETQ N11 (+ N11 1 ))

			(SETQ LIS-P-TAPA-A (NTH (+ N11 0) LIS-LIS-PUN-TAPA-CAJAS ))
			(SETQ LIS-P-TAPA-B (NTH (+ N11 1) LIS-LIS-PUN-TAPA-CAJAS ))


			(SETQ PA1 (NTH (REM (+ N10 0) (LENGTH LIS-P-TAPA-A )) LIS-P-TAPA-A ))        	;      KK1                     KK2   
			(SETQ PA2 (NTH (REM (+ N10 1) (LENGTH LIS-P-TAPA-A )) LIS-P-TAPA-A ))	      	;      PB1 O-----------------O PB2   
                                                                                    	;          |     3D Cara     |       
			(SETQ PB1 (NTH (REM (+ N10 0) (LENGTH LIS-P-TAPA-B )) LIS-P-TAPA-B ))        	;          |                 |       
			(SETQ PB2 (NTH (REM (+ N10 1) (LENGTH LIS-P-TAPA-B )) LIS-P-TAPA-B ))        	;      PA1 O-----------------O PA2   

			"==( 3D )====================================================================================================================="
			"-----------------------------------------------------------------------------------------------------------------------------"
			(COMMAND "COLOR" (NTH N10  LIS-COLO ) "3DCARA" PA1 PA2 PB2 PB1 "" )																					; 3DCARA-3D

			(COMMAND "SCP" "3P" PA1 PA2 PB1 )																																							; PLANO-3DC ( 3D ) 
				(SETQ PA1p (LIST 0.0 0.0 0.0))
				(SETQ PA2p (TRANS PA2 0 1 ))
				(SETQ PB1p (TRANS PB1 0 1 ))
				(SETQ PB2p (TRANS PB2 0 1 ))
				"----------------------------------------------------------------------------------------------------------------------------"
		;		(COMMAND "COLOR" 1  "TEXTO"  (LIST 0.42 0.18)  0.42  0  (STRCAT (ITOA (+ N10 1 )) "/" (ITOA (+ N11 1 ))))		; TEXTO-3D 
   		(COMMAND "SCP" "U")


			"==( 2D )======================================================================================================================"
			(COMMAND "SCP" "3P" KK1 KK2 "" )																																							; PLANO-3DC ( 2D ) PATRONES
				"----------------------------------------------------------------------------------------------------------------------------"
				(COMMAND "COLOR" (NTH N10  LIS-COLO )   "3DCARA" PA1p  PA2p  PB2p  PB1p "")																; 3DCARA-2D

				(SETQ PB1pU (TRANS PB1p 1 0 ))
				(SETQ PB2pU (TRANS PB2p 1 0 ))
				(SETQ KK1 PB1pU )
				(SETQ KK2 PB2pU )
				"----------------------------------------------------------------------------------------------------------------------------"
		;		(COMMAND "COLOR" 1  "TEXTO"  (LIST 0.42 0.18)  0.42  0  (STRCAT (ITOA (+ N10 1 )) "/" (ITOA (+ N11 1 ))))		; TEXTO-2D 
   		(COMMAND "SCP" "U")

		) ; repe N11
	) ; repe N10

)) ; if pro EGECUTA-Pro  (12) - (15) 


	;	(16) PARANDO																																																												
	(SETVAR "blipmode" 1) (SETVAR "cmdecho" 1)

) ;CIERRE DEFUN  CAJAS-CARAS-PLANAS-entre-SPLINES-06a

;=======================================================================================================================================


