

;==========================================================================================================================================
;	( INTER-3DCsA-3DCsB-3P-04-aa )            de (INTER-3DCsA-3DCsB-3P-04)						 								21/12/2011					 
;==========================================================================================================================================
;																																														 
;	   INTERSECCION ENTRE de LADOS TRIANGULO (3DC-A ROJAS) con PLANO (3DC-B AZULES CORTE) por SCP														 
;																																														 
;     UTILIZA los 3 PRIMEROS PUNTOS de 3DC-ROJAS (3DC TRIANGULARES) de 3DC-AZUL (4 PUNTOS)	                        							 
;																																														 
;		PINTA 2D PATRONES																																						 	 
;																																														 
;     (3DC-B AZULES CORTE) => DATOS ( 3 TRAMOS POLILINEA-2D + ALTU )  																							 

;																																														 

;==========================================================================================================================================


;==========================================================================================================================================
; (COND-DENTRO-FUERA) 		( IN1 ) y ( IN2 ) DENTRO-FUERA 	de (B1p B2p B3p B4p)                 														 

		(DEFUN COND-DENTRO-FUERA ( / )

					(COND ; CON (1.1.x)
								; (1.1.1) 		( IN1 ) DENTRO    ( IN2 ) DENTRO 																	(B1p B2p B3p B4p)            							 

								((AND ( = (INTERS CeBp IN1  B1p B2p ) nil )  ( = (INTERS CeBp IN1  B2p B3p ) nil )
										( = (INTERS CeBp IN1  B3p B4p ) nil )  ( = (INTERS CeBp IN1  B4p B1p ) nil )			; ( IN1 ) DENTRO (B1p B2p B3p B4p)
										( = (INTERS CeBp IN2  B1p B2p ) nil )  ( = (INTERS CeBp IN2  B2p B3p ) nil )
										( = (INTERS CeBp IN2  B3p B4p ) nil )  ( = (INTERS CeBp IN2  B4p B1p ) nil ))			; ( IN2 ) DENTRO (B1p B2p B3p B4p)

										(COMMAND "COLOR" CO "LINEA" IN1 IN2 "")  (SETQ LIS-LINE-CUADRO (CONS (LIST IN1 IN2 ) LIS-LINE-CUADRO ))
								) ; con(1.1.1)

								; (1.1.2)     ( IN1 ) FUERA 	  ( IN2 ) DENTRO 																	(B1p B2p B3p B4p)            							 

								((AND	( = (INTERS CeBp IN2  B1p B2p ) nil )  ( = (INTERS CeBp IN2  B2p B3p ) nil )
										( = (INTERS CeBp IN2  B3p B4p ) nil )  ( = (INTERS CeBp IN2  B4p B1p ) nil ))			; ( IN2 ) DENTRO (B1p B2p B3p B4p)

											(COND
												((/= (INTERS CeBp IN1 B1p B2p) nil) (SETQ IN1-12 (INTERS IN1 IN2 B1p B2p))
												 (COMMAND "COLOR" CO "LINEA" IN1-12 IN2 "") (SETQ LIS-LINE-CUADRO (CONS (LIST IN1-12 IN2) LIS-LINE-CUADRO))) ;(IN1)FUERA(B1p B2p)

												((/= (INTERS CeBp IN1 B2p B3p) nil) (SETQ IN1-23 (INTERS IN1 IN2 B2p B3p))
												 (COMMAND "COLOR" CO "LINEA" IN1-23 IN2 "") (SETQ LIS-LINE-CUADRO (CONS (LIST IN1-23 IN2) LIS-LINE-CUADRO))) ;(IN1)FUERA(B2p B3p)

												((/= (INTERS CeBp IN1 B3p B4p) nil) (SETQ IN1-34 (INTERS IN1 IN2 B3p B4p))
												 (COMMAND "COLOR" CO "LINEA" IN1-34 IN2 "") (SETQ LIS-LINE-CUADRO (CONS (LIST IN1-34 IN2) LIS-LINE-CUADRO))) ;(IN1)FUERA(B3p B4p)

												((/= (INTERS CeBp IN1 B4p B1p) nil) (SETQ IN1-41 (INTERS IN1 IN2 B4p B1p))
												 (COMMAND "COLOR"  CO"LINEA" IN1-41 IN2 "") (SETQ LIS-LINE-CUADRO (CONS (LIST IN1-41 IN2) LIS-LINE-CUADRO))) ;(IN1)FUERA(B4p B1p)
											) ; CON 
   							)  ; con(1.1.2)

								; (1.1.3)     ( IN1 ) DENTRO 		( IN2 ) FUERA  																	(B1p B2p B3p B4p)            							 

								((AND	( = (INTERS CeBp IN1  B1p B2p ) nil )  ( = (INTERS CeBp IN1  B2p B3p ) nil )
										( = (INTERS CeBp IN1  B3p B4p ) nil )  ( = (INTERS CeBp IN1  B4p B1p ) nil ))			; ( IN1 ) DENTRO (B1p B2p B3p B4p)

											(COND
												((/= (INTERS CeBp IN2 B1p B2p) nil) (SETQ IN2-12 (INTERS IN1 IN2 B1p B2p))
												 (COMMAND "COLOR" CO "LINEA" IN2-12 IN1 "") (SETQ LIS-LINE-CUADRO (CONS (LIST IN2-12 IN1) LIS-LINE-CUADRO))) ;(IN2)FUERA(B1p B2p)

												((/= (INTERS CeBp IN2 B2p B3p) nil) (SETQ IN2-23 (INTERS IN1 IN2 B2p B3p))
												 (COMMAND "COLOR" CO "LINEA" IN2-23 IN1 "") (SETQ LIS-LINE-CUADRO (CONS (LIST IN2-23 IN1) LIS-LINE-CUADRO))) ;(IN2)FUERA(B2p B3p)

												((/= (INTERS CeBp IN2 B3p B4p) nil) (SETQ IN2-34 (INTERS IN1 IN2 B3p B4p))
												 (COMMAND "COLOR" CO "LINEA" IN2-34 IN1 "") (SETQ LIS-LINE-CUADRO (CONS (LIST IN2-34 IN1) LIS-LINE-CUADRO))) ;(IN2)FUERA(B3p B4p)

												((/= (INTERS CeBp IN2 B4p B1p) nil) (SETQ IN2-41 (INTERS IN1 IN2 B4p B1p))
												 (COMMAND "COLOR" CO "LINEA" IN2-41 IN1 "") (SETQ LIS-LINE-CUADRO (CONS (LIST IN2-41 IN1) LIS-LINE-CUADRO))) ;(IN2)FUERA(B4p B1p)
											) ; CON 
   							)  ; con(1.1.3)
										
					) ; CON (1.1.x)

		) ; Defun COND-DENTRO-FUERA

;																																																									 




;==========================================================================================================================================
;       	  	*** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA ***									 									 
;==========================================================================================================================================

(DEFUN C:INTER-3DCsA-3DCsB-3P-04-aa ( / )

	;========================================================================================================================================
	;	(01) ARRANCANDO																																																		 
	(SETVAR "blipmode" 0) (SETVAR "cmdecho" 0) (GRAPHSCR) (COMMAND  "-REFENT" "DES"   "SCP" "U"   "ORTO" "DES")
	(IF (= CAL nil)(COMMAND "ARX" "L" "GEOMCAL.ARX"))			; CARGA CALCULADORA

	(SETQ Mag  0.00001 )		; MARGEN EQUAL

	;========================================================================================================================================
	;	(02) TOMA DATOS (3DC-PLANO-> A y B )    																																										 

	(TERPRI)
	(PROMPT "###########################################################################################################################3##")   (TERPRI)
	(PRIN1  "----- SELECCIONA TODAS las 3DC-(A CORTAR(ROJAS)) y POLI-2D-(CORTE(AZUL)) => (ENTER)")
	(SETQ   CONJ-ENTI (SSGET))

	;(PRIN1  "SI ERROR Divide/Cero => GIRAR (NO PLANOS paralelos PLA-CORD)?")


	(SETQ ALTU 40 ) 						; ALTURA 3DC CORTE AZULES



	;========================================================================================================================================
	;	(03) PUNTOS TODAS 3DC-ROJA 3DC-AZUL  =>  LIS-Lis4P-3DC-ROJA  LIS-Lis4P-3DC-AZUL	 									 																		 

	(SETQ LIS-Lis4P-3DC-ROJA nil )
	(SETQ LIS-Lis4P-3DC-AZUL nil )

	(SETQ N1 -1 )
	(REPEAT (SSLENGTH CONJ-ENTI )																																; (SSLENGTH CONJ-ENTI )      9355 
		(SETQ N1 (+ N1  1 ))

		(SETQ Nom0 (SSNAME CONJ-ENTI N1 ))  																			; Nombre ENTIDAD 
		(SETQ Lis0 (ENTGET Nom0 ))  																						; lista  ENTIDAD 


		(COND

			; (01) CORDENADAS PUNTOS 3DCARAS           LIS-Lis4P-3DC-ROJA																									  

			((AND (= (CDR (ASSOC 0 Lis0 )) "3DFACE" ) (= (CDR (ASSOC 62 Lis0 )) 1 ))								; ROJAS 
				(SETQ LIS-Lis4P-3DC-ROJA (CONS (LIST (CDR (ASSOC 10 Lis0 ))
																 (CDR (ASSOC 11 Lis0 ))
																 (CDR (ASSOC 12 Lis0 ))
																 (CDR (ASSOC 13 Lis0 ))) LIS-Lis4P-3DC-ROJA )))		; con1


			; (02) CORDENADAS PUNTOS POLILINEA  SCO => SCU           (LIS-POLI) => LIS-PUN-SCU	LIS-Lis4P-3DC-AZUL											  

			((AND (= (CDR (ASSOC 0 Lis0 )) "LWPOLYLINE" ) (= (CDR (ASSOC 62 Lis0 )) 5 ))								; POLILINEA 2D AZULES

			(SETQ LIS-PUN-SCO  nil )
			(SETQ LIS-PUN-SCU  nil )

			(SETQ LIS-POLI   (ENTGET    Nom0 ))  				; lista POLILINEA 
			(SETQ NVER (CDR (ASSOC 90  LIS-POLI )))  		; N VERTICES  4  

			(REPEAT NVER
				(SETQ ELEME  (ASSOC 10 LIS-POLI ))
				(SETQ PuSCO  (CDR ELEME ))

				(SETQ LIS-PUN-SCO (CONS  PuSCO  LIS-PUN-SCO ))
				(SETQ LIS-POLI    (SUBST '(###)  ELEME  LIS-POLI ))

				(SETQ PuSCU (TRANS PuSCO  Nom0  1 ))
				(SETQ LIS-PUN-SCU (CONS  PuSCU  LIS-PUN-SCU ))

			) ; repe

			(SETQ LIS-PUN-SCO (REVERSE LIS-PUN-SCO ))
			(SETQ LIS-PUN-SCU (REVERSE LIS-PUN-SCU ))


				(SETQ A1 (NTH 0 LIS-PUN-SCU))
				(SETQ A2 (NTH 1 LIS-PUN-SCU))
				(SETQ A3 (NTH 2 LIS-PUN-SCU))
				(SETQ A4 (NTH 3 LIS-PUN-SCU))

				(SETQ B1 (LIST (CAR A1) (CADR A1) ALTU ))
				(SETQ B2 (LIST (CAR A2) (CADR A2) ALTU ))
				(SETQ B3 (LIST (CAR A3) (CADR A3) ALTU ))
				(SETQ B4 (LIST (CAR A4) (CADR A4) ALTU ))

				(SETQ LIS-Lis4P-3DC-AZUL (CONS (LIST (LIST  A1 A2 B2 B1 )
																 (LIST  A2 A3 B3 B2 )
																 (LIST  A3 A4 B4 B3 )) LIS-Lis4P-3DC-AZUL ))

											(COMMAND "COLOR" 1  "3DCARA" A1 A2 B2 B1 "")
											(COMMAND "COLOR" 2  "3DCARA" A2 A3 B3 B2 "")
											(COMMAND "COLOR" 3  "3DCARA" A3 A4 B4 B3 "")
		)	; con2

				;         B1             B2          B3             B4        
				;         O--------------O-----------O--------------O         
				;         | DC11         | DC12      | DC13         |         
				;         |              |           |              |         
				;         |              |           |              |         
				;         O--------------O-----------O--------------O         
				;         A1             A2          A3             A4        


		) ; CON
	) ; repe N1
	(SETQ LIS-Lis4P-3DC-ROJA (REVERSE LIS-Lis4P-3DC-ROJA ))																		; (LENGTH LIS-Lis4P-3DC-ROJA ) 9457 
	(SETQ LIS-Lis4P-3DC-AZUL (REVERSE LIS-Lis4P-3DC-AZUL ))		  																; (LENGTH LIS-Lis4P-3DC-AZUL )   20 


	;====================================================================================================================================
	;	(04) INTERSECCION ENTRE 3DCARAS																							 									 													 

	(SETQ NLisAzul (LENGTH LIS-Lis4P-3DC-AZUL ))
	(SETQ NLiAzulx  NLisAzul )     ; CUENTA

	(SETQ KK1 (LIST 45 +15 0 ))
	(SETQ KK2 (LIST 45 -15 0 ))

	(SETQ NB -1 )
	(REPEAT (LENGTH LIS-Lis4P-3DC-AZUL )
		(SETQ NB (+ NB  1 ))

		(SETQ LIS-3LIS-AZ (NTH NB  LIS-Lis4P-3DC-AZUL ))


		(SETQ NB1 -1 )
		(REPEAT (LENGTH LIS-3LIS-AZ )
			(SETQ NB1 (+ NB1  1 ))


			(SETQ B1 (NTH 0 (NTH NB1  LIS-3LIS-AZ )))					;   B4 O------O B3    
			(SETQ B2 (NTH 1 (NTH NB1  LIS-3LIS-AZ )))					;      |      |       
			(SETQ B3 (NTH 2 (NTH NB1  LIS-3LIS-AZ )))					;      |      |       
			(SETQ B4 (NTH 3 (NTH NB1  LIS-3LIS-AZ )))					;   B1 O------O B2    


		;(SETQ B1 (NTH 0 (NTH NB  LIS-Lis4P-3DC-AZUL )))					;   B4 O------O B3    
		;(SETQ B2 (NTH 1 (NTH NB  LIS-Lis4P-3DC-AZUL )))					;      |      |       
		;(SETQ B3 (NTH 2 (NTH NB  LIS-Lis4P-3DC-AZUL )))					;      |      |       
		;(SETQ B4 (NTH 3 (NTH NB  LIS-Lis4P-3DC-AZUL )))					;   B1 O------O B2    

		(SETQ Db13 (DISTANCE B1 B3 ))
		(SETQ Db34 (DISTANCE B3 B4 ))
		(SETQ Db41 (DISTANCE B4 B1 ))

		(IF (AND (NOT (EQUAL B1 B2  Mag ))
					(NOT (EQUAL B1 B3  Mag ))
					(NOT (EQUAL B2 B3  Mag ))
					(NOT (EQUAL B1 B2  Mag ))	; NO IGUALES    B1 B2 B3 B4 
			 		(/= Db13 (+ Db34 Db41  ))
					(/= Db34 (+ Db41 Db13  ))
					(/= Db41 (+ Db13 Db34  )))	; NO COLINEALES B1 B2 B4    
			(PROGN

				(SETQ LIS-LINE-CUADRO nil )

				(COMMAND "SCP" "3P" B4 B1 B3 )

				(SETQ B1p (TRANS B1 0 1 ))
				(SETQ B2p (TRANS B2 0 1 ))
				(SETQ B3p (TRANS B3 0 1 ))
				(SETQ B4p (TRANS B4 0 1 ))

				(SETQ CeBp (CAL "( VEC([], B1p) + VEC([], B2p) + VEC([], B3p) + VEC([], B4p)) / 4 "))

				(IF (= (REM NB 2 ) 0 ) (SETQ CO 255 ) (SETQ CO 2 ))

				(SETQ NA -1 )
				(REPEAT (LENGTH LIS-Lis4P-3DC-ROJA )
					(SETQ NA (+ NA  1 ))

					(SETQ AA1 (NTH 0 (NTH NA  LIS-Lis4P-3DC-ROJA )))
					(SETQ AA2 (NTH 1 (NTH NA  LIS-Lis4P-3DC-ROJA )))
					(SETQ AA3 (NTH 2 (NTH NA  LIS-Lis4P-3DC-ROJA )))
					(SETQ AA4 (NTH 3 (NTH NA  LIS-Lis4P-3DC-ROJA )))

					(COND
						((EQUAL AA3 AA4  Mag ) (SETQ  A1 AA1   A2 AA2   A3 AA3 ))																		; SI SON TRIANGULOS
						((EQUAL AA4 AA1  Mag ) (SETQ  A1 AA1   A2 AA2   A3 AA3 ))
						((EQUAL AA1 AA2  Mag ) (SETQ  A1 AA1   A2 AA3   A3 AA4 ))
						((EQUAL AA2 AA3  Mag ) (SETQ  A1 AA1   A2 AA2   A3 AA4 ))
					) ; CON

					(SETQ Da12 (DISTANCE A1 A2 ))
					(SETQ Da23 (DISTANCE A2 A3 ))
					(SETQ Da31 (DISTANCE A3 A1 ))


					;===============================================================================================================================
					;	(05) INTERSECCION ENTRE LADOS TRIANGULO (3DC-A ROJAS) con PLANO TRIANGULO (3DC-B AZULES) por SCP															

					(IF (AND (NOT (EQUAL A1 A2  Mag ))
								(NOT (EQUAL A1 A3  Mag ))
								(NOT (EQUAL A2 A3  Mag ))				; NO IGUALES  A1 A2 A3 
								(/= Da12 (+ Da23 Da31  ))
								(/= Da23 (+ Da31 Da12  ))
								(/= Da31 (+ Da12 Da23 )))				; NO COLINEALES 
						(PROGN
							(SETQ A1p (TRANS A1 0 1 ))  (SETQ  Z1 (CADDR A1p ))
							(SETQ A2p (TRANS A2 0 1 ))  (SETQ  Z2 (CADDR A2p ))
							(SETQ A3p (TRANS A3 0 1 ))  (SETQ  Z3 (CADDR A3p ))

							(COND ; CON (1.Zx)
								; (1.1)  Z1 CONTRARIO a Z2 y Z3																																								
								((OR (AND (> Z1 0) (< Z2 0) (< Z3 0))  (AND (< Z1 0) (> Z2 0) (> Z3 0)))						; Z1 >< Z2 Z3

									(SETQ K1 (/ (ABS Z1) (+ (ABS Z1) (ABS Z2))))  (SETQ IN1 (CAL "PLT( A1p , A2p , K1 )"))
									(SETQ K2 (/ (ABS Z1) (+ (ABS Z1) (ABS Z3))))  (SETQ IN2 (CAL "PLT( A1p , A3p , K2 )"))

									(COND-DENTRO-FUERA)
								)  ; con(1.1)Z1

								; (1-2)  Z2 CONTRARIO a Z3 y Z1																																								
								((OR (AND (> Z2 0) (< Z3 0) (< Z1 0))  (AND (< Z2 0) (> Z3 0) (> Z1 0)))						; Z2 >< Z3 Z1

									(SETQ K1 (/ (ABS Z2) (+ (ABS Z2) (ABS Z3))))  (SETQ IN1  (CAL "PLT( A2p , A3p , K1 )"))
									(SETQ K2 (/ (ABS Z2) (+ (ABS Z2) (ABS Z1))))  (SETQ IN2  (CAL "PLT( A2p , A1p , K2 )"))

									(COND-DENTRO-FUERA)
								)  ; con(1.2)Z2

								; (1-3)  Z3 CONTRARIO a Z1 y Z2																																								
								((OR (AND (> Z3 0) (< Z1 0) (< Z2 0))  (AND (< Z3 0) (> Z1 0) (> Z2 0)))						; Z3 >< Z1 Z2

								 	(SETQ K1 (/ (ABS Z3) (+ (ABS Z3) (ABS Z1))))  (SETQ IN1  (CAL "PLT( A3p , A1p , K1 )"))
									(SETQ K2 (/ (ABS Z3) (+ (ABS Z3) (ABS Z2))))  (SETQ IN2  (CAL "PLT( A3p , A2p , K2 )"))

									(COND-DENTRO-FUERA)
								)  ; con(1.3)Z3

							) ; CON (1.Zx)

						) ; pro
					) ; if (As NO IGUALES)

				) ; repe NA


				;=================================================================================================================================
				;	(06) PINTA INTERSECCIONES 3D 2D                                                                                                 
				;	                                               B4 O---------------O B3  KK1                                                     
				;	                                                  | o------> Y    |                                                             
				;	                                                  | |             |                                                             
				;	                                                  | | "SCP"       |                                                             
				;	                                                  | |             |                                                             
				;	                                                  | X             |                                                             
				;	                                                  |               |                                                             
				;                                                B1 O---------------O B2  KK2                                                     
				;	                                                                                                                                

					;(COMMAND "COLOR" CO  "3DCARA" B1p  B2p  B3p  B4p "")																	; 3DCARA-3D ; ("SCP" "3P" B4 B1 B3)

					(SETQ Htxt 1.2 )																																			; ALTURA TEXTO 
					(SETQ Ptxt (LIST (+ (CAR B3p) (* 2 Htxt)) (- (CADR B3p) (* 4 Htxt) ) 0))							; PUNTO  TEXTO  B4p -> B3p 
					(COMMAND "COLOR" CO  "TEXTO" Ptxt  Htxt  90 (STRCAT "#" (ITOA (+ NB 1 )))) 					; TEXTO-3D 

				(COMMAND "SCP" "U" )

				(COMMAND "SCP" "3P" KK1 KK2 "" )																												; PLANO-3DC ( 2D ) PATRONES
	
					(COMMAND "COLOR" CO  "3DCARA" B1p  B2p  B3p  B4p "")																	; 3DCARA-2D ; ("SCP" "3P" KK1 KK2 "")
					(COMMAND "COLOR" CO  "TEXTO" Ptxt  Htxt  90  (STRCAT "#" (ITOA (+ NB 1 )))) 					; TEXTO-2D ; 

					(SETQ NL -1 )
					(REPEAT (LENGTH LIS-LINE-CUADRO )
						(SETQ NL (+ NL  1 ))
						(SETQ PP1 (NTH 0 (NTH NL  LIS-LINE-CUADRO )))
						(SETQ PP2 (NTH 1 (NTH NL  LIS-LINE-CUADRO )))
						(COMMAND "COLOR" CO "LINEA" PP1 PP2 "")
					) ;repe NL 

					(SETQ KK1 (TRANS B3p 1 0 ))
					(SETQ KK2 (TRANS B2p 1 0 ))
   		(COMMAND "SCP" "U")

			) ; pro
		) ; if (Bs NO IGUALES)



	) ; repe NB1




		;=================================================================================================================================
		;	(07) IFORMACION PORCENTAGE PROGRAMA	(CUENTA)																																								

		(SETQ NLiAzulx (- NLiAzulx 1 ))											; 28 / 30

		(SETQ NU% (* 100 (/ (FLOAT NLiAzulx ) NLisAzul )))  ; 93.3333
		(SETQ NU%UNI (FIX NU% ) )															; 93
		(SETQ NU%DEC (FIX (- (* NU% 10) (* NU%UNI 10) )))			; 3

		(PROMPT  "        Falta =========> ") (PRIN1 NU%UNI ) (PROMPT "," ) (PRIN1 NU%DEC ) (PROMPT " %" ) (TERPRI)



	) ; repe NB


	;	(08) PARANDO																																																			
	(SETVAR "blipmode" 1)  (SETVAR "cmdecho"  1)

) ;cierre DEFUN   INTER-3DCsA-3DCsB-3P-04-aa 

;-------------------------------------------------------------------------------------------------------------------------------------

