;==========================================================================================================================================
;																																																																					 
;	 ( PLANOS-VERTI-SPL-3D-01  )					                           																									     23/02/2010				 
;																																																																					 
;==========================================================================================================================================



;------------------------------------------------------------------------------------------------------------------------------------------
;	PUNTOS-SPLI-DIVIDE   DIVIDE SPLINE ( NomSpl ) con ( Ndivide ) => LISTA PUNTOS ( LIS-PUN-SPL )  									                       
;------------------------------------------------------------------------------------------------------------------------------------------

	(DEFUN PUNTOS-SPLI-DIVIDE ( / )

		(SETQ LIS-PUN-SPL nil)
		(SETQ ALIS  (ENTGET NomSpl))  																								; lista Spline A
		(SETQ AELE  (ASSOC 10 ALIS))  																								; 1 Punto Asociado a 10 (10.punto)
		(SETQ AELES (MEMBER AELE ALIS)) 																							; lista a partir del Alterior (10.punto)....(11.punto)
		(SETQ X-primer (CDR (NTH 0 AELES))) 																					; primer elemento (10.punto)
		(SETQ X-ultimo (CDR (NTH (- (LENGTH AELES) 1) AELES)))												; ultimo elemento (11.punto)
		(COMMAND "COLOR" COLO )																												; COLOR  = A
		;(COMMAND "TEXTO" "MI" X-primer 5.0 0 TEX)																		;  TEXTO = A
		(COMMAND "PUNTO" X-primer)																										; PINTA 1 punto A
		(SETQ N-enti-A1 (ENTLAST))																										; nombre ultima entidad principal 1 punto A
		(COMMAND "DIVIDE" NomSpl Ndivide)																						; DIVIDE SPLI-A
		(COMMAND "PUNTO" X-ultimo)																										; PINTA Ultimo Punto A
		;	PUNTOS SECCION-A (PA1-PAn) =>   LIS-PUN-SPL  Lon-LPA													                                                       
		(SETQ LIS-PUN-SPL nil)																												; LISTA  PUNTOS-A
		(SETQ LIS-PUN-SPL (CONS (CDR (ASSOC 10 (ENTGET N-enti-A1))) LIS-PUN-SPL))			; lista entidad -> (1 Punto-A)
		(SETQ W1A T)
		(WHILE W1A
			(SETQ N-enti-A2 (ENTNEXT N-enti-A1))																				; Nombre entidad siguiente
			(COMMAND "BORRA" N-enti-A1 "")																							; BORRA entidad (Punto)
			(IF (= N-enti-A2 nil)  (SETQ W1A nil)
				(PROGN
					(SETQ LIS-PUN-SPL (CONS (CDR (ASSOC 10 (ENTGET N-enti-A2))) LIS-PUN-SPL))
					(SETQ N-enti-A1  N-enti-A2 )
				);progn
			);if
		) ;While W1A

		;	LISTA ( LIS-PUN-SPL ) Ordenada																                                                                       

		(SETQ LIS-PUN-SPL (REVERSE LIS-PUN-SPL ))																			; ( LIS-PUN-SPL Ordenada )

	) ; Defun PUNTOS-SPLI-DIVIDE

;																						                                                                                               


"#########################################################################################################################################"
;==========================================================================================================================================
;	  *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** 							 
;==========================================================================================================================================
"#########################################################################################################################################"

(DEFUN C:PLANOS-VERTI-SPL-3D-01 (/ )

	;========================================================================================================================================
	;	(00) ARRANCANDO																																																												 
	(SETVAR "blipmode" 0) (SETVAR "cmdecho" 0) (GRAPHSCR) (COMMAND "-REFENT" "DES"  "SCP" "U"  "ORTO" "DES")
	(IF (= CAL nil)(COMMAND "ARX" "L" "GEOMCAL.ARX"))			; CARGA CALCULADORA

	;========================================================================================================================================
	;	(01) DATOS INTERNOS       Ndivide																												                                             

	(SETQ Ndivide 53  )			;  NO mas de  32768  Divisiones 

	(SETQ ALTO     0.6 )			;  ALTO de 3DC 

	;----------------------------------------------------------------------------------------------------------------------------------------
	; (02) DATOS EXTERNOS (SPL-EJE en Plano XZ )														   																															 
	(TERPRI)
	(PROMPT                    "####################################################################")   (TERPRI)
	(SETQ NoSPeje (CAR (ENTSEL " >>>>>>>>>>>>>>>>>>>>>>>>  MARCA SPLINE  EJE <<<<<<<<<<<<<<<<<<<<<<<"))) (TERPRI)	; nombre Spline 
	(PROMPT                    "####################################################################")   (TERPRI)


	;========================================================================================================================================
	;	(03) PUNTOS SPLINE EJE => LIS-P-SLI-EJE-LOMGI                     	 	 	 									 																				 		 

	(SETQ NomSpl  NoSPeje )   																																					; <Nombre entidad> 

	(PUNTOS-SPLI-DIVIDE ) 																																							; => LIS-PUN-SPL   

	(SETQ LIS-P-SLI-EJE  LIS-PUN-SPL )																																	; (LENGTH LIS-P-SLI-EJE )  


	;========================================================================================================================================
	;	(04) PINTA 3DCARAS 3D 2D ( DESPLAZAMIENTO VERTICAL el ALTO )         	 	 	 																										 		 		 


	(SETQ KK1 (LIST 60  0 0 ))
	(SETQ KK2 (LIST 60 -1 0 ))

	(SETQ N0 -1 )
	(REPEAT (- (LENGTH LIS-P-SLI-EJE ) 1 )
		(SETQ N0 (+ N0  1 ))

		(SETQ PA1 (NTH (+ N0 0 ) LIS-P-SLI-EJE ))
		(SETQ PA2 (NTH (+ N0 1 ) LIS-P-SLI-EJE ))
		(SETQ PB1 (CAL " PA1 + [ 0,0, - ALTO ] "))
		(SETQ PB2 (CAL " PA2 + [ 0,0, - ALTO ] "))

		(SETQ B1 PB1 )
		(SETQ B2 PB2 )
		(SETQ B3 PA2 )
		(SETQ B4 PA1 )

		;	                                                                                                                                
		;	                                               B4 O---------------O B3  KK1           (COMMAND "SCP" "3P" B4 B1 B3 )            
		;	                                                  | o------> Y    |                                                             
		;	                                                  | |             |                                                             
		;	                                                  | | "SCP"       |                   (COMMAND "SCP" "3P" KK1 KK2 "" )          
		;	                                                  | |             |                                                             
		;	                                                  | X             |                                                             
		;	                                                  |               |                                                             
		;                                                B1 O---------------O B2  KK2                                                     
		;	                                                                                                                                

		(IF (= (REM N0 2 ) 0 ) (SETQ CO 255 ) (SETQ CO 2 ))


		(COMMAND "SCP" "3P" B4 B1 B3 )

			(SETQ B1p (TRANS B1 0 1 ))
			(SETQ B2p (TRANS B2 0 1 ))
			(SETQ B3p (TRANS B3 0 1 ))
			(SETQ B4p (TRANS B4 0 1 ))

			(COMMAND "COLOR" CO  "3DCARA" B1p  B2p  B3p  B4p "")																	; 3DCARA-3D ; ("SCP" "3P" B4 B1 B3)

			(SETQ Htxt 0.3 )																																			; ALTURA TEXTO 
			(SETQ Ptxt (LIST (+ (CAR B3p) (* 2 Htxt)) (- (CADR B3p) (* 4 Htxt) ) 0))							; PUNTO  TEXTO  B4p -> B3p 

			(COMMAND "COLOR" CO  "TEXTO" Ptxt  Htxt  90 (STRCAT "#" (ITOA (+ N0 1 )))) 					; TEXTO-3D 

		(COMMAND "SCP" "U" )

		(COMMAND "SCP" "3P" KK1 KK2 "" )																												; PLANO-3DC ( 2D ) PATRONES
	
			(COMMAND "COLOR" CO  "3DCARA" B1p  B2p  B3p  B4p "")																	; 3DCARA-2D ; ("SCP" "3P" KK1 KK2 "")
			(COMMAND "COLOR" CO  "TEXTO" Ptxt  Htxt  90  (STRCAT "#" (ITOA (+ N0 1 )))) 					; TEXTO-2D ; 

			(SETQ KK1 (TRANS B3p 1 0 ))
			(SETQ KK2 (TRANS B2p 1 0 ))

   	(COMMAND "SCP" "U")


	) ; repe N0


	;	(16) PARANDO																																																												
	(SETVAR "blipmode" 1) (SETVAR "cmdecho" 1)

) ;CIERRE DEFUN  PLANOS-VERTI-SPL-3D-01

;=======================================================================================================================================
