
;==========================================================================================================================================
;																																																																					 
;	 ( PLANOS-CORTE-3DC-PARALELOS-01  )					                           																						     20/02/2010				 
;																																																																					 
;==========================================================================================================================================



;------------------------------------------------------------------------------------------------------------------------------------------
;	PUNTOS-SPLI-DIVIDE   DIVIDE SPLINE ( NomSpl ) con ( Ndivide ) => LISTA PUNTOS ( LIS-PUN-SPL )  									                       
;------------------------------------------------------------------------------------------------------------------------------------------

	(DEFUN PUNTOS-SPLI-DIVIDE ( / )

		(SETQ LIS-PUN-SPL nil)
		(SETQ ALIS  (ENTGET NomSpl))  																								; lista Spline A
		(SETQ AELE  (ASSOC 10 ALIS))  																								; 1 Punto Asociado a 10 (10.punto)
		(SETQ AELES (MEMBER AELE ALIS)) 																							; lista a partir del Alterior (10.punto)....(11.punto)
		(SETQ X-primer (CDR (NTH 0 AELES))) 																					; primer elemento (10.punto)
		(SETQ X-ultimo (CDR (NTH (- (LENGTH AELES) 1) AELES)))												; ultimo elemento (11.punto)
		(COMMAND "COLOR" COLO )																												; COLOR  = A
		;(COMMAND "TEXTO" "MI" X-primer 5.0 0 TEX)																		;  TEXTO = A
		(COMMAND "PUNTO" X-primer)																										; PINTA 1 punto A
		(SETQ N-enti-A1 (ENTLAST))																										; nombre ultima entidad principal 1 punto A
		(COMMAND "DIVIDE" NomSpl Ndivide)																						; DIVIDE SPLI-A
		(COMMAND "PUNTO" X-ultimo)																										; PINTA Ultimo Punto A
		;	PUNTOS SECCION-A (PA1-PAn) =>   LIS-PUN-SPL  Lon-LPA													                                                       
		(SETQ LIS-PUN-SPL nil)																												; LISTA  PUNTOS-A
		(SETQ LIS-PUN-SPL (CONS (CDR (ASSOC 10 (ENTGET N-enti-A1))) LIS-PUN-SPL))			; lista entidad -> (1 Punto-A)
		(SETQ W1A T)
		(WHILE W1A
			(SETQ N-enti-A2 (ENTNEXT N-enti-A1))																				; Nombre entidad siguiente
			(COMMAND "BORRA" N-enti-A1 "")																							; BORRA entidad (Punto)
			(IF (= N-enti-A2 nil)  (SETQ W1A nil)
				(PROGN
					(SETQ LIS-PUN-SPL (CONS (CDR (ASSOC 10 (ENTGET N-enti-A2))) LIS-PUN-SPL))
					(SETQ N-enti-A1  N-enti-A2 )
				);progn
			);if
		) ;While W1A

		;	LISTA ( LIS-PUN-SPL ) Ordenada																                                                                       

		(SETQ LIS-PUN-SPL (REVERSE LIS-PUN-SPL ))																			; ( LIS-PUN-SPL Ordenada )

	) ; Defun PUNTOS-SPLI-DIVIDE

;																						                                                                                               


;------------------------------------------------------------------------------------------------------------------------------------------
;	PUNTOS-SPLI-GRADUA   GRADUA SPLINE ( NomSpl ) con ( PASO ) => LISTA PUNTOS ( LIS-PUN-SPL )  									                       
;------------------------------------------------------------------------------------------------------------------------------------------

	(DEFUN PUNTOS-SPLI-GRADUA ( / )

		(SETQ LIS-PUN-SPL nil)
		(SETQ ALIS  (ENTGET NomSpl))  																								; lista Spline A
		(SETQ AELE  (ASSOC 10 ALIS))  																								; 1 Punto Asociado a 10 (10.punto)
		(SETQ AELES (MEMBER AELE ALIS)) 																							; lista a partir del Alterior (10.punto)....(11.punto)
		(SETQ X-primer (CDR (NTH 0 AELES))) 																					; primer elemento (10.punto)
		(SETQ X-ultimo (CDR (NTH (- (LENGTH AELES) 1) AELES)))												; ultimo elemento (11.punto)
		(COMMAND "COLOR" COLO )																												; COLOR  = A
		;(COMMAND "TEXTO" "MI" X-primer 5.0 0 TEX)																		;  TEXTO = A
		(COMMAND "PUNTO" X-primer)																										; PINTA 1 punto A
		(SETQ N-enti-A1 (ENTLAST))																										; nombre ultima entidad principal 1 punto A
		(COMMAND "GRADUA" NomSpl PASO)																								; GRADUA SPLI-A
		(COMMAND "PUNTO" X-ultimo)																										; PINTA Ultimo Punto A
		;	PUNTOS SECCION-A (PA1-PAn) =>   LIS-PUN-SPL  Lon-LPA													                                                       
		(SETQ LIS-PUN-SPL nil)																												; LISTA  PUNTOS-A
		(SETQ LIS-PUN-SPL (CONS (CDR (ASSOC 10 (ENTGET N-enti-A1))) LIS-PUN-SPL))			; lista entidad -> (1 Punto-A)
		(SETQ W1A T)
		(WHILE W1A
			(SETQ N-enti-A2 (ENTNEXT N-enti-A1))																				; Nombre entidad siguiente
			(COMMAND "BORRA" N-enti-A1 "")																							; BORRA entidad (Punto)
			(IF (= N-enti-A2 nil)  (SETQ W1A nil)
				(PROGN
					(SETQ LIS-PUN-SPL (CONS (CDR (ASSOC 10 (ENTGET N-enti-A2))) LIS-PUN-SPL))
					(SETQ N-enti-A1  N-enti-A2 )
				);progn
			);if
		) ;While W1A

		;	LISTA ( LIS-PUN-SPL ) Ordenada																                                                                       

		(SETQ LIS-PUN-SPL (REVERSE LIS-PUN-SPL ))																			; ( LIS-PUN-SPL Ordenada )

	) ; Defun PUNTOS-SPLI-GRADUA

;																						                                                                                               











"#########################################################################################################################################"
;==========================================================================================================================================
;	  *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** 							 
;==========================================================================================================================================
"#########################################################################################################################################"

(DEFUN C:PLANOS-CORTE-3DC-PARALELOS-01 (/ )

	;========================================================================================================================================
	;	(00) ARRANCANDO																																																												 
	(SETVAR "blipmode" 0) (SETVAR "cmdecho" 0) (GRAPHSCR) (COMMAND "-REFENT" "DES"  "SCP" "U"  "ORTO" "DES")
	(IF (= CAL nil)(COMMAND "ARX" "L" "GEOMCAL.ARX"))			; CARGA CALCULADORA

	;========================================================================================================================================
	;	(01) DATOS INTERNOS       Ndivide																												                                             

	(SETQ Ndivide 30  )			;  NO mas de  32768  Divisiones 

	(SETQ PASO     2.5 )			;  PASO GRADUA 

	(SETQ LARGO   27.0 )			;  LARGO de 3DC CORTE 

	;----------------------------------------------------------------------------------------------------------------------------------------
	; (02) DATOS EXTERNOS (SPL-EJE en Plano XZ )														   																															 
	(TERPRI)
	(PROMPT                    "####################################################################")   (TERPRI)
	(SETQ NoSPeje (CAR (ENTSEL " >>>>>>>>>>>>>>>>>>>>>>>>  MARCA SPLINE  EJE <<<<<<<<<<<<<<<<<<<<<<<"))) (TERPRI)	; nombre Spline 
	(PROMPT                    "####################################################################")   (TERPRI)


	;========================================================================================================================================
	;	(03) PUNTOS SPLINE EJE => LIS-P-SLI-EJE-LOMGI                     	 	 	 									 																				 		 

	(SETQ NomSpl  NoSPeje )   																																					; <Nombre entidad> 

	(PUNTOS-SPLI-GRADUA ) 																																							; => LIS-PUN-SPL   

	(SETQ LIS-P-SLI-EJE  LIS-PUN-SPL )																																	; (LENGTH LIS-P-SLI-EJE )  

	(IF nil (PROGN ;////////////////////////////////////////////////////////////////////////////////////
	;========================================================================================================================================
	;	(04) PINTA PUNTOS de  LIS-P-SLI-EJE-LOMGI (COMBROBACION)         	 	 	 								 																				 		 		 

	(SETQ N0 -1 )
	(REPEAT (LENGTH LIS-P-SLI-EJE )
		(SETQ N0 (+ N0  1 ))

		(SETQ PS (NTH N0 LIS-P-SLI-EJE ))
		(COMMAND "COLOR" 3  "TEXTO" PS  0.3  0  (STRCAT "#" (ITOA (+ N0 1 ))))
	) ; repe N0

	;========================================================================================================================================
	;	(04) PINTA PUNTOS MEDIOS de  LIS-P-SLI-EJE-LOMGI (COMBROBACION)         	 	 	 								 																 		 		 

	(SETQ N0 -1 )
	(REPEAT (- (LENGTH LIS-P-SLI-EJE ) 1 )
		(SETQ N0 (+ N0  1 ))

		(SETQ PS1 (NTH (+ N0 0 ) LIS-P-SLI-EJE ))
		(SETQ PS2 (NTH (+ N0 1 ) LIS-P-SLI-EJE ))

		(SETQ PS12 (CAL "PLT(PS1,PS2,0.5)"))
		
		(COMMAND "COLOR" 4  "TEXTO" PS12  0.4  0  (STRCAT "#" (ITOA (+ N0 1 )) (ITOA (+ N0 2 )) ))
	) ; repe N0

	)) ; IF PRO ////////////////////////////////////////////////////////////////////////////////////////////



	;========================================================================================================================================
	;	(05) PINTA 3DCARAS CORTE (SPL-EJE en Plano XZ )                                                                                        
	;	                            |                                                                                                          
	;	                    (3) PA2 O---------------O PB2 (2)      B4 O---------------O B3  KK1      INTER-3DCsA-3DCsB-3P-04a.LSP              
	;	                            | Y             |                 | o------> Y    |                                                        
	;	                            | |             |                 | |             |              (COMMAND "SCP" "3P" B4 B1 B3 )            
	;	                     SPLINE | |             |       ===>      | |  "SCP"      |                                                        
	;	                            | o------> X    |                 | X             |              (COMMAND "SCP" "3P" KK1 KK2 "" )          
	;                     (4) PA1 O---------------O PB1 (1)      B1 O---------------O B2  KK2                                                
	;	                            |     LARGO                                                                                                

	(SETQ N1 -1 )
	(REPEAT (- (LENGTH LIS-P-SLI-EJE ) 1 )
		(SETQ N1 (+ N1  1 ))

		(SETQ PA1 (NTH (+ N1 0 ) LIS-P-SLI-EJE ))
		(SETQ PA2 (NTH (+ N1 1 ) LIS-P-SLI-EJE ))
		(SETQ PB1 (CAL " PA1 + VEC( [0,0,0] , [LARGO,0,0] )"))
		(SETQ PB2 (CAL " PA2 + VEC( [0,0,0] , [LARGO,0,0] )"))

		(COMMAND "COLOR" 5  "3DCARA" PB1  PB2  PA2  PA1 "")

	) ; repe N1











	;	(16) PARANDO																																																												
	(SETVAR "blipmode" 1) (SETVAR "cmdecho" 1)

) ;CIERRE DEFUN  PLANOS-CORTE-3DC-PARALELOS-01

;=======================================================================================================================================
