
;-------------------------------------------------------------------------------------------------------------------------------------
;																																																																			
;	  ( BOTELLA-de-KLEIN-02 )			         				       					                             													20-12-2008			
;																																																																			
;                            RADIO MINIMO VARIABLE ABAJO  (SETQ RAmi2 (+ RAmi1 (* YY2 YY2  DESRa )))  																
;-------------------------------------------------------------------------------------------------------------------------------------


;"###################################################################################################################################"
;-------------------------------------------------------------------------------------------------------------------------------------
;       *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA*** PROGRAMA*** PROGRAMA***											
;-------------------------------------------------------------------------------------------------------------------------------------

(DEFUN C:BOTELLA-de-KLEIN-02 (/ )

	;===================================================================================================================================
	; (00) ARRANCANDO																																																										

 	(SETVAR "blipmode" 0) (SETVAR "cmdecho" 0)  (GRAPHSCR)  (COMMAND "-REFENT" "DES")  (COMMAND "SCP" "U")  (COMMAND "ORTO" "DES")

	(PROMPT " ============================================================================")  (TERPRI)
	(PROMPT " >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> INICIO >>>>>>>>> BOTELLA-de-KLEIN-02 >>>>>>>>")  (TERPRI)
	(PROMPT " ============================================================================")  (TERPRI)  (TERPRI)

	;===================================================================================================================================
	;	(01) FIJA VARIABLES de PROGRAMA																																																		

	(IF (= CAL nil)(COMMAND "ARX" "L" "GEOMCAL.ARX"))		; CARGA CALCULADORA 
	(SETQ mUNI 1.0e-006 )																; MARGEN EQUAL VEC-UNITARIOS (1.01e-008)LIMITE-MAR-INTER-RECT-01.lsp 

	;===================================================================================================================================
	;	(02) ECUACION BOTELLA de KLEIN																																																		

	;																																																																		
	;  p=2*PI*u   q=2*PI*v   r=4*(1-cos(p)/2)                                                                                    				
	;																																																																		
	;  ARR | x1=6*cos(p)*(1+sin(p))+r*cos(p)*cos(q)        	ABA | y1=16*sin(p)+r*sin(p)*cos(q)                 x=((p<=PI)?x1:x2)        
	;      | x2=6*cos(p)*(1+sin(p))-r*cos(q)               	    | y2=16*sin(p)                                 y=((p<=PI)?y1:y2)        
	;      | z=r*sin(q)                                         | z=r*sin(q)                                                            
	;																																																																		

	;===================================================================================================================================
	;	(03) FIJA VARIABLES																																																								


	(SETQ REPE-UU 30 )							; NUMERO de AMILLOS  30 
	(SETQ REPE-VV  5 )							; CARAS por ANILLO   12 

	(SETQ RAmi1    2.0 )						; RADIO MINIMO 2 
	(SETQ DESRa (/ 1.0 29 ) )				; DESVIA RADIO MINIMO 1/29 

	(SETQ Ex    1.0 )
	(SETQ Ey    1.0 ) ; 0.9 
	(SETQ Ez    1.0 ) ; 1.3 

	
	;###################################################################################################################################
	;	(04) # ARRIBA #   PUNTOS BOTELLA de KLEIN   																																											

	(IF T (PROGN  ; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

	(SETQ LIS-LIS-PUN-CIRCUS-ARR  nil )

	(SETQ IniUU  0.0 )  																															; UU (-0.5..+0.5 )  UU =< 0.5   PP ( -PI..+P1 )
  (SETQ FinUU  0.5 )
	(SETQ PasoUU (/ (- FinUU IniUU ) REPE-UU ))

	(SETQ IniVV (- 0.5 ))  																														; VV (-0.5..+0.5 )  VV =< 0.5   QQ ( -PI..+P1 )
  (SETQ FinVV (+ 0.5 ))
	(SETQ PasoVV (/ (- FinVV IniVV ) REPE-VV ))

	(SETQ UU (- IniUU  PasoUU ))
	(REPEAT  (+ REPE-UU 1 )								; N AMILLOS  
		(SETQ UU  (+ UU  PasoUU ))

		(SETQ LIS-P-ARR  nil )
		(SETQ VV (- IniVV  PasoVV ))
		(REPEAT  (+ REPE-VV 1 )				; CARAS por ANILLO 
			(SETQ VV  (+ VV  PasoVV ))

			(SETQ PP (* 2.0 PI UU ))                                                      ; p = 2*PI*u        p < = PI     u < = 1/2   
			(SETQ QQ (* 2.0 PI VV ))                                                      ; q = 2*PI*v                                 
			(SETQ RR (+ RAmi1 (* 4 (/ (- 1 (COS PP)) 2.0 ))))                             ; r = 4*(1-cos(p)/2)    +0 => +2.0 Bien      

			; PARTE de ARRIBA																															
			(SETQ XX1 (+ (*  6.0 (COS PP)  (+ 1.0 (SIN PP))) (* RR (COS PP) (COS QQ ))))  ; x1 = 6*cos(p)*(1+sin(p)) + r*cos(p)*cos(q) 
			(SETQ YY1 (+ (* 16.0 (SIN PP))                   (* RR (SIN PP) (COS QQ ))))  ; y1 = 16*sin(p) + r*sin(p)*cos(q)           
			(SETQ ZZ1 (* RR (SIN QQ )))                                                   ; z1 = r*sin(q)                              

			(SETQ LIS-P-ARR (CONS (LIST (* XX1 Ex ) (* YY1 Ey ) (* ZZ1 Ez )) LIS-P-ARR ))

		) ; repe VV

		(SETQ LIS-P-ARR (REVERSE LIS-P-ARR ))																						; (LENGTH LIS-P-ARR )  
		(SETQ LIS-LIS-PUN-CIRCUS-ARR (CONS LIS-P-ARR  LIS-LIS-PUN-CIRCUS-ARR ))

	) ; repe UU

	(SETQ LIS-LIS-PUN-CIRCUS-ARR (REVERSE LIS-LIS-PUN-CIRCUS-ARR ))										; (LENGTH LIS-LIS-PUN-CIRCUS-ARR ) 100 Anillos 

	)) ; IF "T" - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 



	;###################################################################################################################################
	;	(05) # ABAJO #   PUNTOS BOTELLA de KLEIN   																																												

	(IF T (PROGN  ; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

	(SETQ LIS-LIS-PUN-CIRCUS-ABA  nil )

	(SETQ IniUU    0.0  )  																														; UU (-0.5..+0.5 )  UU =< 0.5   PP ( -PI..+P1 )
  (SETQ FinUU (- 0.5 ))
	(SETQ PasoUU (/ (- FinUU IniUU ) REPE-UU ))

	(SETQ IniVV (- 0.5 ))  																														; VV (-0.5..+0.5 )  VV =< 0.5   QQ ( -PI..+P1 )
  (SETQ FinVV (+ 0.5 ))
	(SETQ PasoVV (/ (- FinVV IniVV ) REPE-VV ))

	(SETQ UU (- IniUU  PasoUU ))
	(REPEAT  (+ REPE-UU 1 )								; N AMILLOS  
		(SETQ UU  (+ UU  PasoUU ))

		(SETQ RAmi2 (+ RAmi1 (* (EXPT (* 16.0 (SIN (* 2.0 PI UU ))) 2 ) DESRa )))  			; YY2^2 /20.0 /15.0 

		(SETQ LIS-P-ABA  nil )
		(SETQ VV (- IniVV  PasoVV ))
		(REPEAT  (+ REPE-VV 1 )				; CARAS por ANILLO 
			(SETQ VV  (+ VV  PasoVV ))

			(SETQ PP (* 2.0 PI UU ))                                                      ; p = 2*PI*u        p < = PI     u < = 1/2   
			(SETQ QQ (* 2.0 PI VV ))                                                      ; q = 2*PI*v                                 
			(SETQ RR (+ RAmi2 (* 4 (/ (- 1 (COS PP)) 2.0 ))))                             ; r = 4*(1-cos(p)/2)    +0 => +2.0 Bien      

			; PARTE de ABAJO																															
			(SETQ XX2 (- (* 6.0 (COS PP) (+ 1.0 (SIN PP))) (* RR (COS QQ))))          		; x3 = 6*cos(p)*(1+sin(p)) -r*cos(q)          
			(SETQ YY2 (* 16.0 (SIN PP)))                                               		; y3 = 16*sin(p)                              
			(SETQ ZZ1 (* RR (SIN QQ )))                                                   ; z1 = r*sin(q)                              

			(SETQ LIS-P-ABA (CONS (LIST (* XX2 Ex ) (* YY2 Ey ) (* ZZ1 Ez )) LIS-P-ABA ))

		) ; repe VV

		(SETQ LIS-P-ABA (REVERSE LIS-P-ABA ))																						; (LENGTH LIS-P-ARR )  
		(SETQ LIS-LIS-PUN-CIRCUS-ABA (CONS LIS-P-ABA  LIS-LIS-PUN-CIRCUS-ABA ))

	) ; repe UU

	(SETQ LIS-LIS-PUN-CIRCUS-ABA (REVERSE LIS-LIS-PUN-CIRCUS-ABA ))										; (LENGTH LIS-LIS-PUN-CIRCUS-ARR ) 100 Anillos 

	)) ; IF "T" - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 


	;===================================================================================================================================
	;	(06) ## ARRIBA ##  PINTA 3DCARAS 3D 2D																																														

	(IF T (PROGN  ; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

	(SETQ N1 -1 )
	(REPEAT (- (LENGTH LIS-LIS-PUN-CIRCUS-ARR ) 1 )											; (LENGTH LIS-LIS-PUN-CIRCUS-ARR ) 31 
		(SETQ N1  (+ N1  1 ))
		(SETQ LIS-PUN-CIR-A1 (NTH (+ N1 0 ) LIS-LIS-PUN-CIRCUS-ARR ))		; (LENGTH LIS-PUN-CIR-A1 ) 13 
		(SETQ LIS-PUN-CIR-A2 (NTH (+ N1 1 ) LIS-LIS-PUN-CIRCUS-ARR ))		; (LENGTH LIS-PUN-CIR-A2 ) 13 

		(SETQ N2 -1 )
		(REPEAT (- (LENGTH LIS-PUN-CIR-A1 ) 1 )
			(SETQ N2  (+ N2  1 ))
			(SETQ A1a (NTH (+ N2 0 ) LIS-PUN-CIR-A1 ))
			(SETQ A2a (NTH (+ N2 1 ) LIS-PUN-CIR-A1 ))
			(SETQ B1a (NTH (+ N2 0 ) LIS-PUN-CIR-A2 ))
			(SETQ B2a (NTH (+ N2 1 ) LIS-PUN-CIR-A2 ))

			(COMMAND "COLOR" 2  "3DCARA" A1a  A2a  B2a  B1a "" )			; 3D 

		) ; repe N2 
	) ; repe N1 

	)) ; IF "T" - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 


	;===================================================================================================================================
	;	(07) ## ABAJO ##  PINTA 3DCARAS 3D 2D																																															

	(IF T (PROGN  ; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

	(SETQ N3 -1 )
	(REPEAT (- (LENGTH LIS-LIS-PUN-CIRCUS-ABA ) 1 )											; (LENGTH LIS-LIS-PUN-CIRCUS-ABA ) 31 
		(SETQ N3  (+ N3  1 ))
		(SETQ LIS-PUN-CIR-B1 (NTH (+ N3 0 ) LIS-LIS-PUN-CIRCUS-ABA ))		; (LENGTH LIS-PUN-CIR-B1 ) 13 
		(SETQ LIS-PUN-CIR-B2 (NTH (+ N3 1 ) LIS-LIS-PUN-CIRCUS-ABA ))		; (LENGTH LIS-PUN-CIR-B2 ) 13 

		(SETQ N4 -1 )
		(REPEAT (- (LENGTH LIS-PUN-CIR-B1 ) 1 )
			(SETQ N4  (+ N4  1 ))
			(SETQ A1b (NTH (+ N4 0 ) LIS-PUN-CIR-B1 ))
			(SETQ A2b (NTH (+ N4 1 ) LIS-PUN-CIR-B1 ))
			(SETQ B1b (NTH (+ N4 0 ) LIS-PUN-CIR-B2 ))
			(SETQ B2b (NTH (+ N4 1 ) LIS-PUN-CIR-B2 ))

			(COMMAND "COLOR" 2  "3DCARA" A1b  A2b  B2b  B1b "" )			; 3D 

		) ; repe N4 
	) ; repe N3 

	)) ; IF "T" - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 



	;===================================================================================================================================
	;	(20) PARANDO																																																											
	(SETVAR "blipmode" 1)  (SETVAR "cmdecho"  1)

	(PROMPT " ============================================================================") (TERPRI)
	(PROMPT " >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> FINAL >>>>>>>>> BOTELLA-de-KLEIN-02 >>>>>>>>") (TERPRI)
	(PROMPT " ============================================================================") (TERPRI)

) ; cierre DEFUN    BOTELLA-de-KLEIN-02 

;-------------------------------------------------------------------------------------------------------------------------------------
;"###################################################################################################################################"
