;-------------------------------------------------------------------------------------------------------------------------------------
;																																																																			
;	  ( BOTELLA-de-KLEIN-03 )			MEDIA BOTELLA (SIMETRICA)     					                       												21-12-2008			
;																																																																			
;-------------------------------------------------------------------------------------------------------------------------------------


;"###################################################################################################################################"
;-------------------------------------------------------------------------------------------------------------------------------------
;       *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA*** PROGRAMA*** PROGRAMA***											
;-------------------------------------------------------------------------------------------------------------------------------------

(DEFUN C:BOTELLA-de-KLEIN-03 (/ )

	;===================================================================================================================================
	; (00) ARRANCANDO																																																										

 	(SETVAR "blipmode" 0) (SETVAR "cmdecho" 0)  (GRAPHSCR)  (COMMAND "-REFENT" "DES")  (COMMAND "SCP" "U")  (COMMAND "ORTO" "DES")

	(PROMPT " ============================================================================")  (TERPRI)
	(PROMPT " >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> INICIO >>>>>>>>> BOTELLA-de-KLEIN-03 >>>>>>>>")  (TERPRI)
	(PROMPT " ============================================================================")  (TERPRI)  (TERPRI)

	;===================================================================================================================================
	;	(01) FIJA VARIABLES de PROGRAMA																																																		

	(IF (= CAL nil)(COMMAND "ARX" "L" "GEOMCAL.ARX"))		; CARGA CALCULADORA 
	(SETQ mUNI 1.0e-006 )																; MARGEN EQUAL VEC-UNITARIOS (1.01e-008)LIMITE-MAR-INTER-RECT-01.lsp 

	;===================================================================================================================================
	;	(02) ECUACION BOTELLA de KLEIN																																																		

	;																																																																		
	;  p=2*PI*u   q=2*PI*v   r=4*(1-cos(p)/2)                                                                                    				
	;																																																																		
	;  ARR | x1=6*cos(p)*(1+sin(p))+r*cos(p)*cos(q)        	ABA | y1=16*sin(p)+r*sin(p)*cos(q)                 x=((p<=PI)?x1:x2)        
	;      | x2=6*cos(p)*(1+sin(p))-r*cos(q)               	    | y2=16*sin(p)                                 y=((p<=PI)?y1:y2)        
	;      | z=r*sin(q)                                         | z=r*sin(q)                                                            
	;																																																																		

	;===================================================================================================================================
	;	(03) FIJA VARIABLES																																																								

	(SETQ nFILA  30 )							; NUMERO de AMILLOS 
	(SETQ nCOLU   3 )							; CARAS por ANILLO  

	(SETQ RAmin   2 )							; RADIO MINIMO 

	(SETQ Ex    1.0  )
	(SETQ Ey    0.95 )
	(SETQ Ez    1.3  )

	;###################################################################################################################################
	;	(04) # ARRIBA #   PUNTOS BOTELLA de KLEIN   																																											
	(IF T (PROGN  ; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

	(SETQ LIS-LIS-PUN-CURVA-ARR  nil )

	(SETQ IniFILA  0.0 )  																														; FILA (-0.5..+0.5 )  FILA =< 0.5  FF ( -PI..+P1 )
  (SETQ FinFILA  0.5 )
	(SETQ PasoFILA (/ (- FinFILA IniFILA ) nFILA ))

	(SETQ IniCOLU  0.0 )  					  																								; COLU (-0.5..+0.5 )  COLU =< 0.5  CC ( -PI..+P1 )
  (SETQ FinCOLU  0.5 )
	(SETQ PasoCOLU (/ (- FinCOLU IniCOLU ) nCOLU ))

	(SETQ COLU (- IniCOLU  PasoCOLU ))
	(REPEAT  (+ nCOLU 1 )											; CARAS por ANILLO 
		(SETQ COLU  (+ COLU  PasoCOLU ))

		(SETQ LIS-P-ARR  nil )

		(SETQ FILA (- IniFILA  PasoFILA ))
		(REPEAT  (+ nFILA 1 )										; N ANILLOS  
			(SETQ FILA  (+ FILA  PasoFILA ))

			(SETQ FF (* 2.0 PI FILA ))                                                    ; p = 2*PI*u        p < = PI     u < = 1/2   
			(SETQ CC (* 2.0 PI COLU ))                                                    ; q = 2*PI*v                                 
			(SETQ RR (+ RAmin (* 4 (/ (- 1 (COS FF)) 2.0 ))))                             ; r = 4*(1-cos(p)/2)    +0 => +2.0 Bien      

			; PARTE de ARRIBA																															
			(SETQ XX1 (+ (*  6.0 (COS FF)  (+ 1.0 (SIN FF))) (* RR (COS FF) (COS CC ))))  ; x1 = 6*cos(p)*(1+sin(p)) + r*cos(p)*cos(q) 
			(SETQ YY1 (+ (* 16.0 (SIN FF))                   (* RR (SIN FF) (COS CC ))))  ; y1 = 16*sin(p) + r*sin(p)*cos(q)           
			(SETQ ZZ1 (* RR (SIN CC )))                                                   ; z1 = r*sin(q)                              

			(SETQ LIS-P-ARR (CONS (LIST (* XX1 Ex ) (* YY1 Ey ) (* ZZ1 Ez )) LIS-P-ARR ))

		) ; repe COLU

		(SETQ LIS-P-ARR (REVERSE LIS-P-ARR ))																						; (LENGTH LIS-P-ARR )  
		(SETQ LIS-LIS-PUN-CURVA-ARR (CONS LIS-P-ARR  LIS-LIS-PUN-CURVA-ARR ))

	) ; repe FILA

	(SETQ LIS-LIS-PUN-CURVA-ARR (REVERSE LIS-LIS-PUN-CURVA-ARR ))										; (LENGTH LIS-LIS-PUN-CURVA-ARR ) 9 Anillos 

	)) ; IF "04T" - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 


	;###################################################################################################################################
	;	(05) # ABAJO #   PUNTOS BOTELLA de KLEIN   																																												
	(IF T (PROGN  ; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

	(SETQ LIS-LIS-PUN-CURVA-ABA  nil )

	(SETQ IniFILA     0.0  )  																												; FILA (-0.5..+0.5 )  FILA =< 0.5   FF ( -PI..+P1 )
  (SETQ FinFILA  (- 0.5 ))
	(SETQ PasoFILA (/ (- FinFILA IniFILA ) nFILA ))

	(SETQ IniCOLU  0.0 )  																														; COLU (-0.5..+0.5 )  COLU =< 0.5   CC ( -PI..+P1 )
  (SETQ FinCOLU  0.5 )
	(SETQ PasoCOLU (/ (- FinCOLU IniCOLU ) nCOLU ))

	(SETQ COLU (- IniCOLU  PasoCOLU ))
	(REPEAT  (+ nCOLU 1 )													; CARAS por ANILLO 
		(SETQ COLU  (+ COLU  PasoCOLU ))

		(SETQ LIS-P-ABA  nil )

		(SETQ FILA (- IniFILA  PasoFILA ))
		(REPEAT  (+ nFILA 1 )												; N ANILLOS  
			(SETQ FILA  (+ FILA  PasoFILA ))

			(SETQ FF (* 2.0 PI FILA ))                                                    ; p = 2*PI*u        p < = PI     u < = 1/2   
			(SETQ CC (* 2.0 PI COLU ))                                                    ; q = 2*PI*v                                 
			(SETQ RR (+ RAmin (* 4 (/ (- 1 (COS FF)) 2.0 ))))                             ; r = 4*(1-cos(p)/2)    +0 => +2.0 Bien      

			; PARTE de ABAJO																															
			(SETQ XX2 (- (* 6.0 (COS FF) (+ 1.0 (SIN FF))) (* RR (COS CC))))          		; x3 = 6*cos(p)*(1+sin(p)) -r*cos(q)         
			(SETQ YY2 (* 16.0 (SIN FF)))                                               		; y3 = 16*sin(p)                             
			(SETQ ZZ1 (* RR (SIN CC )))                                                   ; z1 = r*sin(q)                              

			(SETQ LIS-P-ABA (CONS (LIST (* XX2 Ex ) (* YY2 Ey ) (* ZZ1 Ez )) LIS-P-ABA ))

		) ; repe COLU

		(SETQ LIS-P-ABA (REVERSE LIS-P-ABA ))																						; (LENGTH LIS-P-ARR )  
		(SETQ LIS-LIS-PUN-CURVA-ABA (CONS LIS-P-ABA  LIS-LIS-PUN-CURVA-ABA ))

	) ; repe FILA

	(SETQ LIS-LIS-PUN-CURVA-ABA (REVERSE LIS-LIS-PUN-CURVA-ABA ))										; (LENGTH LIS-LIS-PUN-CURVA-ARR ) 9 Anillos 

	)) ; IF "05T" - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 



	;===================================================================================================================================
	;	(XX) MARCA-TXT PUNTOS LISTAS  ARRIBA  																																														
	(IF T (PROGN  ; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 


	(SETQ N10 -1 )
	(REPEAT (LENGTH LIS-LIS-PUN-CURVA-ARR )																	; (LENGTH LIS-LIS-PUN-CURVA-ARR ) 4 
		(SETQ N10  (+ N10  1 ))
		(SETQ LIS-PUN-CUR-A1 (NTH (+ N10 0 ) LIS-LIS-PUN-CURVA-ARR ))				; (LENGTH LIS-PUN-CUR-A1 ) 31 

		(SETQ N1 -1 )
		(REPEAT (LENGTH LIS-PUN-CUR-A1 )
			(SETQ N1  (+ N1  1 ))

			(SETQ A1a (NTH N1  LIS-PUN-CUR-A1 ))

			(COMMAND "COLOR" 8  "TEXTO" A1a 0.05 0 (STRCAT "_" (ITOA (+ N10 1)) "/" (ITOA (+ N1 1))))			; 3D

		) ; repe N1 
  ) ; repe N10 

	)) ; IF "06T" - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 


	;===================================================================================================================================
	;	(06) ## ARRIBA ##  PINTA 3DCARAS ORIGINALES 3D 																																										
	(IF T (PROGN  ; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

	(SETQ N10 -1 )
	(REPEAT (- (LENGTH LIS-LIS-PUN-CURVA-ARR ) 1 )													; (LENGTH LIS-LIS-PUN-CURVA-ARR ) 31 
		(SETQ N10  (+ N10  1 ))
		(SETQ LIS-PUN-CUR-A1 (NTH (+ N10 0 ) LIS-LIS-PUN-CURVA-ARR ))				; (LENGTH LIS-PUN-CUR-A1 ) 13 
		(SETQ LIS-PUN-CUR-A2 (NTH (+ N10 1 ) LIS-LIS-PUN-CURVA-ARR ))				; (LENGTH LIS-PUN-CUR-A2 ) 13 

		(SETQ N1 -1 )
		(REPEAT (- (LENGTH LIS-PUN-CUR-A1 ) 1 )
			(SETQ N1  (+ N1  1 ))

			(SETQ A1a (NTH (+ N1 0 ) LIS-PUN-CUR-A1 ))
			(SETQ A2a (NTH (+ N1 1 ) LIS-PUN-CUR-A1 ))
			(SETQ B1a (NTH (+ N1 0 ) LIS-PUN-CUR-A2 ))
			(SETQ B2a (NTH (+ N1 1 ) LIS-PUN-CUR-A2 ))

			;(IF (= (REM N10 2) 1 ) (SETQ CO1 1 ) (SETQ CO1 2 ))
			;(COMMAND "COLOR" CO1  "3DCARA" A1a  A2a  B2a  B1a "" )			; 3D

			(COMMAND "COLOR" 8  "3DCARA" A1a  A2a  B2a  B1a "" )				; 3D

		) ; repe N1 
  ) ; repe N10 

	)) ; IF "06T" - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 


	;===================================================================================================================================
	;	(07) ## ABAJO ##  PINTA 3DCARAS ORIGINALES 3D 2D  (LAS 3DCARAS SON PLANAS)																												
	(IF nil (PROGN  ; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

	(SETQ N20 -1 )
	(REPEAT (- (LENGTH LIS-LIS-PUN-CURVA-ABA ) 1 )															; (LENGTH LIS-LIS-PUN-CURVA-ABA ) 31 
		(SETQ N20  (+ N20  1 ))
  	(SETQ LIS-PUN-CUR-B1 (NTH (+ N20 0 ) LIS-LIS-PUN-CURVA-ABA ))						; (LENGTH LIS-PUN-CUR-B1 ) 13 
    (SETQ LIS-PUN-CUR-B2 (NTH (+ N20 1 ) LIS-LIS-PUN-CURVA-ABA ))						; (LENGTH LIS-PUN-CUR-B2 ) 13 

		(SETQ K1Aba (LIST (* 40 (+ (/ N20 2.0) 1)) -40 0 ))
		(SETQ K2Aba (LIST (* 41 (+ (/ N20 2.0) 1)) -40 0 ))

		(SETQ N2 -1 )
		(REPEAT (- (LENGTH LIS-PUN-CUR-B1 ) 1 )
			(SETQ N2  (+ N2  1 ))

			(SETQ A1b (NTH (+ N2 0 ) LIS-PUN-CUR-B1 ))
			(SETQ A2b (NTH (+ N2 1 ) LIS-PUN-CUR-B1 ))
			(SETQ B1b (NTH (+ N2 0 ) LIS-PUN-CUR-B2 ))
			(SETQ B2b (NTH (+ N2 1 ) LIS-PUN-CUR-B2 ))

			(COMMAND "COLOR" 2  "3DCARA" A1b  A2b  B2b  B1b "" )			; 3D

			; PATRONES-2D     ABAJO (LAS 3DCARAS SON PLANAS)																																								

			(COMMAND "SCP" "3P" A1b B1b A2b )
				(SETQ A1bp (TRANS A1b 0 1 ))
				(SETQ A2bp (TRANS A2b 0 1 ))
				(SETQ B2bp (TRANS B2b 0 1 ))
				(SETQ B1bp (TRANS B1b 0 1 ))
				(COMMAND "COLOR" 8  "TEXTO" (LIST 0.15 0.1 0) 0.2 0 (STRCAT (ITOA (+ N20 1)) "-ABA-" (ITOA (+ N2 1))))			; 3D
			(COMMAND "SCP" "U")

			(COMMAND "SCP" "3P" K1Aba K2Aba "" )
				(COMMAND "COLOR" 5  "3DCARA" A1bp  A2bp  B2bp  B1bp "" )			; 2D  3DCARAS PLANAS
				(COMMAND "COLOR" 8  "TEXTO" (LIST 0.15 0.1 0) 0.2 0 (STRCAT (ITOA (+ N20 1)) "-ABA-" (ITOA (+ N2 1))))			; 2D
				(SETQ K1Aba (TRANS A2bp 1 0 ))
				(SETQ K2Aba (TRANS B2bp 1 0 ))
			(COMMAND "SCP" "U")

		) ; repe N2 
	) ; repe N20 

	)) ; IF "07T" - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 





	;===================================================================================================================================
	;===================================================================================================================================
	;	(20) GRAFICA  ANGULOS de ARRIBA																									  																								
	(IF T (PROGN  ; - - - - - - - - - - - - - - - - - - - - - - - - -  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	(SETQ LIS-PUN-CUR-AR1g (NTH 1 LIS-LIS-PUN-CURVA-ARR ))																; (LENGTH LIS-PUN-CUR-AR1 )    21 
	(SETQ LIS-PUN-CUR-AR2g (NTH 2 LIS-LIS-PUN-CURVA-ARR ))																; (LENGTH LIS-PUN-CUR-AR2 )    21 

	(COMMAND "COLOR" 255  "LINEA" (LIST (+ (* 0.2              0                  ) 15.0 ) 0 )
																(LIST (+ (* 0.2 (- (LENGTH LIS-PUN-CUR-AR1 ) 2 )) 15.0 ) 0 ) "" ) ; EJEx 

	(SETQ N30 -1 )																																			; (LENGTH LIS-LIS-PUN-CURVA-ARR )   4 
	(REPEAT  (- (LENGTH LIS-PUN-CUR-AR1g ) 1 )
		(SETQ N30  (+ N30  1 ))

		(SETQ A1 (NTH (+ N30 0 ) LIS-PUN-CUR-AR1g ))
		(SETQ A2 (NTH (+ N30 1 ) LIS-PUN-CUR-AR1g ))

		(IF (= (REM N30 9 ) 0 ) (SETQ COLO2 1) (SETQ COLO2 (+ (REM N30 9 ) 1 )))

		(SETQ N3 -1 )
		(REPEAT (- (LENGTH LIS-PUN-CUR-AR2g ) 2 )
			(SETQ N3  (+ N3  1 ))

			(SETQ B1 (NTH (+ N3 0 ) LIS-PUN-CUR-AR2g ))
			(SETQ B2 (NTH (+ N3 1 ) LIS-PUN-CUR-AR2g ))
			(SETQ B3 (NTH (+ N3 2 ) LIS-PUN-CUR-AR2g ))

			(SETQ N1 (CAL " A1 + NOR( A1 , A2 , B1 ) "))
			(SETQ N2 (CAL " A1 + NOR( A1 , A2 , B2 ) "))
			(SETQ N3 (CAL " A1 + NOR( A1 , A2 , B3 ) "))

			(SETQ Ag12 (CAL " ANG( A1 , N1 , N2 , A2 ) "))  																	; ang( V0 , P1 , P2 , V1 )
			(SETQ Ag13 (CAL " ANG( A1 , N2 , N3 , A2 ) "))

			(IF (< Ag12 180.0) (SETQ ANG1  Ag12)  (SETQ ANG1 (- Ag12 360.0 )))
			(IF (< Ag13 180.0) (SETQ ANG2  Ag13)  (SETQ ANG2 (- Ag13 360.0 )))

			(COMMAND "COLOR" COLO2  "LINEA" (LIST (+ (* 0.2    N3    ) 15.0 ) (* 1.0 ANG1 ))
									 										(LIST (+ (* 0.2 (+ N3 1 )) 15.0 ) (* 1.0 ANG2 )) "" )

		) ; repe N3 
	) ; repe N30 

	)) ; IF "20T" - - - - - - - - - - - - - - - - - - - - - - - - - - - -  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 


	;===================================================================================================================================
	;	(08) PUNTOS de PLANOS TANGENTES a DOS CURVAS-ALABEADAS  ARRIBA																								 										
	(IF T (PROGN  ; - - - - - - - - - - - - - - - - - - - - - - - - -  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	(SETQ LIS-PUN-CERO nil )

	(SETQ LIS-PUN-PLANOS-ARR nil )
	(SETQ LIS-LIS-PUN-PLANOS-ARR nil )

	;(SETQ N400 -1 )
	;(REPEAT  (- (LENGTH LIS-LIS-PUN-CURVA-ARR ) 1 )																			; (LENGTH LIS-LIS-PUN-CURVA-ARR )  4 
	;	(SETQ N400 (+ N400  1 ))


		(SETQ N400  1  ) ; PRUE

		(SETQ LIS-PUN-CUR-AR1 (NTH (+ N400 0 ) LIS-LIS-PUN-CURVA-ARR ))									; (LENGTH LIS-PUN-CUR-AR1 )        31 
		(SETQ LIS-PUN-CUR-AR2 (NTH (+ N400 1 ) LIS-LIS-PUN-CURVA-ARR ))									; (LENGTH LIS-PUN-CUR-AR2 )        31 

		;(SETQ N44 -1 )
		(SETQ N40 -1 )
		(REPEAT  (- (LENGTH LIS-PUN-CUR-AR1 ) 1 )
			(SETQ N40 (+ N40  1 ))

			(SETQ A1 (NTH (+ N40 0 ) LIS-PUN-CUR-AR1 ))
			(SETQ A2 (NTH (+ N40 1 ) LIS-PUN-CUR-AR1 ))

			;(SETQ N4  N44 )
			;(SETQ WW1 T )
			;(WHILE WW1

		(SETQ DISm 10000 )

		(SETQ N4 -1 )
		(REPEAT  (- (LENGTH LIS-PUN-CUR-AR2 ) 2 )
				(SETQ N4 (+ N4  1 ))

				;(IF (>= (+ N4 2 ) (- (LENGTH LIS-PUN-CUR-AR2 ) 1 )) (SETQ WW1 nil ))

				(SETQ B1 (NTH (+ N4 0 ) LIS-PUN-CUR-AR2 ))
				(SETQ B2 (NTH (+ N4 1 ) LIS-PUN-CUR-AR2 ))
				(SETQ B3 (NTH (+ N4 2 ) LIS-PUN-CUR-AR2 ))

				(SETQ N1 (CAL " A1 + NOR( A1 , A2 , B1 ) "))
				(SETQ N2 (CAL " A1 + NOR( A1 , A2 , B2 ) "))
				(SETQ N3 (CAL " A1 + NOR( A1 , A2 , B3 ) "))

				(SETQ Ag12 (CAL " ANG( A1 , N1 , N2 , A2 ) "))  																	; ang( V0 , P1 , P2 , V1 )
				(SETQ Ag13 (CAL " ANG( A1 , N2 , N3 , A2 ) "))

				(IF (< Ag12 180.0) (SETQ ANG1  Ag12)  (SETQ ANG1 (- Ag12 360.0 )))
				(IF (< Ag13 180.0) (SETQ ANG2  Ag13)  (SETQ ANG2 (- Ag13 360.0 )))

				(IF (= (REM N40 9 ) 0 ) (SETQ COLO1 1) (SETQ COLO1 (+ (REM N40 9 ) 1 )))

				;(COND
					;((EQUAL N1 N2  mUNI )
						;(COMMAND "COLOR"  7   "LINEA" A1  B1 "" )
						;(SETQ WW1 nil )
						;(SETQ N44  (- N4 1 ))
						;(SETQ LIS-PUN-PLANOS-ARR (CONS (LIST A1 A2 B1 )  LIS-PUN-PLANOS-ARR ))
					;) ; c1

					;((EQUAL N2 N3  mUNI )
						;(COMMAND "COLOR" 255  "LINEA" A1  B2 "" )
						;(SETQ WW1 nil )
						;(SETQ N44  (- N4 1 ))
						;(SETQ LIS-PUN-PLANOS-ARR (CONS (LIST A1 A2 B2 )  LIS-PUN-PLANOS-ARR ))
					;) ; c2

					;((OR (AND (> ANG1 0.0) (< ANG2 0.0)) (AND (< ANG1 0.0) (> ANG2 0.0)))
						;(COMMAND "COLOR" COLO1  "LINEA" A1  B2 "" )
						;(SETQ WW1 nil )
						;(SETQ N44  (- N4 1 ))
						;(SETQ LIS-PUN-PLANOS-ARR (CONS (LIST A1 A2 B2 )  LIS-PUN-PLANOS-ARR ))
					;) ; c3
				;) ; con

				(IF (OR (AND (> ANG1 0.0) (< ANG2 0.0)) (AND (< ANG1 0.0) (> ANG2 0.0)))
					(PROGN
						(SETQ LIS-PUN-CERO (CONS (LIST A1 A2 B2 )  LIS-PUN-CERO ))
					) ; pro	
				) ; if

			) ; WW1 N4 repe

			(SETQ NCE -1 )
			(REPEAT (LENGTH LIS-PUN-CERO )
				(SETQ NCE (+ NCE  1 ))

				(SETQ LisCE (NTH NCE  LIS-PUN-CERO ))
				(SETQ A1c (NTH 0  LisCE ))
				(SETQ A2c (NTH 0  LisCE ))
				(SETQ B2c (NTH 0  LisCE ))

				(SETQ DISa nil )
				(SETQ DISa (DISTANCE A1c  B2c ))
				(SETQ LIN1 nil )
				(SETQ LIN2 nil )
				(IF (AND (/= DISa nil ) (< DISa  DISm )) (SETQ DISm DISa  LIN1 A1c  LIN2 B2c ) )
			) ; repe

			(IF (AND (/= LIN1 nil ) (/= LIN2 nil )) (COMMAND "COLOR" COLO1  "LINEA" A1  B2 "" ))

		) ; repe N40

		;(SETQ LIS-PUN-PLANOS-ARR (REVERSE LIS-PUN-PLANOS-ARR ))																; (LENGTH LIS-PUN-PLANOS-ARR )    25 
		;(SETQ LIS-LIS-PUN-PLANOS-ARR (CONS LIS-PUN-PLANOS-ARR  LIS-LIS-PUN-PLANOS-ARR ))

	;) ; repe N400 

	;(SETQ LIS-LIS-PUN-PLANOS-ARR (REVERSE LIS-LIS-PUN-PLANOS-ARR ))													; (LENGTH LIS-LIS-PUN-PLANOS-ARR ) 3 

	)) ; IF "08T" - - - - - - - - - - - - - - - - - - - - - - - - - - -  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 


	;===================================================================================================================================
	;	(09) INTERSECCION de PLANOS																								 																												
	(IF nil (PROGN  ; - - - - - - - - - - - - - - - - - - - - - - - - -  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	(SETQ LIS-PUN-INTER-PLANOS-ARR nil )
	(SETQ LIS-LIS-PUN-INTER-PLANOS-ARR nil )

	(SETQ N50 -1 )
	(REPEAT  (LENGTH LIS-LIS-PUN-PLANOS-ARR )																						; (LENGTH LIS-LIS-PUN-PLANOS-ARR )  3 
		(SETQ N50 (+ N50  1 ))

		(SETQ LIS-PUN-PLANOS-ARR (NTH N50  LIS-LIS-PUN-PLANOS-ARR ))											; (LENGTH LIS-PUN-PLANOS-ARR )     25 

		(SETQ N5 -1 )
		(REPEAT  (- (LENGTH LIS-PUN-PLANOS-ARR ) 1 )
			(SETQ N5 (+ N5  1 ))

			(SETQ PLA-A (NTH (+ N5 0 ) LIS-PUN-PLANOS-ARR ))			; (LIST A1 A2 B2 )
			(SETQ PLA-B (NTH (+ N5 1 ) LIS-PUN-PLANOS-ARR ))

			(SETQ A1a (NTH 0 PLA-A ))
			(SETQ A2a (NTH 1 PLA-A ))
			(SETQ B2a (NTH 2 PLA-A ))

			(SETQ A1b (NTH 0 PLA-B ))
			(SETQ A2b (NTH 1 PLA-B ))
			(SETQ B2b (NTH 2 PLA-B ))

			(IF (EQUAL B2a B2b  mUNI )
				(PROGN
					(COMMAND "COLOR" 5  "LINEA" A2a  B2a "" )

					(SETQ LIS-PUN-INTER-PLANOS-ARR (CONS (LIST A2a  B2a )  LIS-PUN-INTER-PLANOS-ARR ))
				) ; pro

				(PROGN
					(SETQ NB2b (CAL " B2b + NOR( A1a , A2a , B2a ) "))
					(SETQ INB2 (CAL " ILP( B2b , NB2b , A1a , A2a , B2a ) "))										; ilp(p1,p2,p3,p4,p5)

					(SETQ CH2 (CAL " ILP( B2a , INB2 , A1b , A2b , B2b ) "))
					(SETQ CH1  A2a )

					(COMMAND "COLOR" 7  "LINEA" CH1  CH2 "" )

					(SETQ LIS-PUN-INTER-PLANOS-ARR (CONS (LIST CH1  CH2 )  LIS-PUN-INTER-PLANOS-ARR ))
				) ; pro
			) ; if
		) ; repe N5 

		(SETQ LIS-PUN-INTER-PLANOS-ARR (REVERSE LIS-PUN-INTER-PLANOS-ARR ))								; (LENGTH LIS-PUN-INTER-PLANOS-ARR ) 18 
		(SETQ LIS-LIS-PUN-INTER-PLANOS-ARR (CONS LIS-PUN-INTER-PLANOS-ARR  LIS-LIS-PUN-INTER-PLANOS-ARR ))

	) ; repe N50 

	(SETQ LIS-LIS-PUN-INTER-PLANOS-ARR (REVERSE LIS-LIS-PUN-INTER-PLANOS-ARR ))				; (LENGTH LIS-LIS-PUN-INTER-PLANOS-ARR ) 3 

	)) ; IF "09T" - - - - - - - - - - - - - - - - - - - - - - - - - - -  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 


	;===================================================================================================================================
	;	(10)   PINTA "3DC-PLANAS" 3D 2D	PATRONES ## ARRIBA ##																																							
	(IF nil (PROGN  ; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

	(SETQ N60 -1 )
	(REPEAT  (- (LENGTH LIS-LIS-PUN-INTER-PLANOS-ARR ) 1 )															; (LENGTH LIS-LIS-PUN-INTER-PLANOS-ARR ) 3 
		(SETQ N60 (+ N60  1 ))

		(SETQ LIS-PUN-INTER-PLANOS-ARR (NTH N60  LIS-LIS-PUN-INTER-PLANOS-ARR ))

		(SETQ K1Arr (LIST (* 40 (+ (/ N60 2.0) 1)) 0 0 ))
		(SETQ K2Arr (LIST (* 41 (+ (/ N60 2.0) 1)) 0 0 ))

		(SETQ N6 -1 )
		(REPEAT (- (LENGTH LIS-PUN-INTER-PLANOS-ARR ) 1 )																	; (LENGTH LIS-PUN-INTER-PLANOS-ARR ) 49 
			(SETQ N6  (+ N6  1 ))
			(SETQ LIS-PUN-INTER-A1 (NTH (+ N6 0 ) LIS-PUN-INTER-PLANOS-ARR ))							; (LENGTH LIS-PUN-INTER-A1 ) 2 
			(SETQ LIS-PUN-INTER-A2 (NTH (+ N6 1 ) LIS-PUN-INTER-PLANOS-ARR ))							; (LENGTH LIS-PUN-INTER-A2 ) 2 

			(SETQ IA1 (NTH 0 LIS-PUN-INTER-A1 ))
			(SETQ IA2 (NTH 1 LIS-PUN-INTER-A1 ))

			(SETQ IB1 (NTH 0 LIS-PUN-INTER-A2 ))
			(SETQ IB2 (NTH 1 LIS-PUN-INTER-A2 ))

			(COMMAND "COLOR" 2  "3DCARA" IA1  IA2  IB2  IB1 "" )			; 3D

			; PATRONES-2D    "3DC PLANAS"   ARRIBA															

			(COMMAND "SCP" "3P" IA1 IB1 IA2 )   ; IA1 = IA2 ???????? 
				(SETQ IA1p (TRANS IA1 0 1 ))
				(SETQ IA2p (TRANS IA2 0 1 ))
				(SETQ IB2p (TRANS IB2 0 1 ))
				(SETQ IB1p (TRANS IB1 0 1 ))
				(COMMAND "COLOR" 8  "TEXTO" (LIST 0.15 0.1 0) 0.2 0 (STRCAT (ITOA (+ N60 1 )) "-ARR-" (ITOA (+ N6 1 ))))			; 3D 
			(COMMAND "SCP" "U")

			(COMMAND "SCP" "3P" K1Arr K2Arr "" )   ; K1Arr = K2Arr ???????? 
				(COMMAND "COLOR" 5  "3DCARA" IA1p  IA2p  IB2p  IB1p "" )			; 2D 
				(COMMAND "COLOR" 8  "TEXTO" (LIST 0.15 0.1 0) 0.2 0 (STRCAT (ITOA (+ N60 1 )) "-ARR-" (ITOA (+ N6 1 ))))			; 2D 

				(SETQ K1Arr (TRANS IA2p  1 0 ))
				(SETQ K2Arr (TRANS IB2p  1 0 ))
			(COMMAND "SCP" "U")

  	) ; repe N6
 	) ; repe N60

	)) ; IF "10T" - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 



	;===================================================================================================================================
	;===================================================================================================================================
	;	(20) GRAFICA  ANGULOS de ARRIBA																									  																								
	(IF nil (PROGN  ; - - - - - - - - - - - - - - - - - - - - - - - - -  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	;(SETQ LIS-PUN-CUR-A1 (NTH 0 LIS-LIS-PUN-CURVA-ARR ))															; (LENGTH LIS-PUN-CUR-A1 )         101 
	(SETQ LIS-PUN-CUR-AR1 (NTH 1 LIS-LIS-PUN-CURVA-ARR ))																; (LENGTH LIS-PUN-CUR-AR1 )         101 
	(SETQ LIS-PUN-CUR-AR2 (NTH 2 LIS-LIS-PUN-CURVA-ARR ))																; (LENGTH LIS-PUN-CUR-AR2 )         101 

	(SETQ N30 -1 )																																			; (LENGTH LIS-LIS-PUN-CURVA-ARR )   3 
	(REPEAT  (- (LENGTH LIS-PUN-CUR-AR2 ) 1 )
		(SETQ N30  (+ N30  1 ))

		(SETQ A1 (NTH (+ N30 0 ) LIS-PUN-CUR-AR2 ))  ;(COMMAND "COLOR" 1  "PUNTO" A1 )
		(SETQ A2 (NTH (+ N30 1 ) LIS-PUN-CUR-AR2 ))  ;(COMMAND "COLOR" 2  "PUNTO" A2 )

		(IF (= (REM N30 5 ) 0 ) (SETQ COLO2 1) (SETQ COLO2 (+ (REM N30 5 ) 1 )))

		(SETQ N3 -1 )
		(REPEAT (- (LENGTH LIS-PUN-CUR-AR1 ) 2 )
			(SETQ N3  (+ N3  1 ))

			(SETQ B1 (NTH (+ N3 0 ) LIS-PUN-CUR-AR1 ))  ;(COMMAND "COLOR" 1  "PUNTO" B1 )
			(SETQ B2 (NTH (+ N3 1 ) LIS-PUN-CUR-AR1 ))  ;(COMMAND "COLOR" 2  "PUNTO" B2 )
			(SETQ B3 (NTH (+ N3 2 ) LIS-PUN-CUR-AR1 ))  ;(COMMAND "COLOR" 3  "PUNTO" B3 )

			(SETQ N1 (CAL " A1 + NOR( A1 , A2 , B1 ) "))
			(SETQ N2 (CAL " A1 + NOR( A1 , A2 , B2 ) "))
			(SETQ N3 (CAL " A1 + NOR( A1 , A2 , B3 ) "))

			(SETQ Ag12 (CAL " ANG( A1 , N1 , N2 , A2 ) "))  																	; ang( V0 , P1 , P2 , V1 )
			(SETQ Ag13 (CAL " ANG( A1 , N2 , N3 , A2 ) "))

			(IF (< Ag12 180.0) (SETQ ANG1  Ag12)  (SETQ ANG1 (- Ag12 360.0 )))
			(IF (< Ag13 180.0) (SETQ ANG2  Ag13)  (SETQ ANG2 (- Ag13 360.0 )))

			(COMMAND "COLOR" COLO2  "LINEA" (LIST (+ (/    N3     3.0 ) 15.0 ) (* 10.0 ANG1 ))
									 										(LIST (+ (/ (+ N3 1 ) 3.0 ) 15.0 ) (* 10.0 ANG2 )) "" )

		) ; repe N3 
	) ; repe N30 

	)) ; IF "20T" - - - - - - - - - - - - - - - - - - - - - - - - - - - -  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 


	;===================================================================================================================================
	;	(30) PARANDO																																																											
	(SETVAR "blipmode" 1)  (SETVAR "cmdecho"  1)

	(PROMPT " ============================================================================") (TERPRI)
	(PROMPT " >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> FINAL >>>>>>>>> BOTELLA-de-KLEIN-03 >>>>>>>>") (TERPRI)
	(PROMPT " ============================================================================") (TERPRI)

) ; cierre DEFUN    BOTELLA-de-KLEIN-03 

;-------------------------------------------------------------------------------------------------------------------------------------
;"###################################################################################################################################"
