
;-------------------------------------------------------------------------------------------------------------------------------------
;																																																																			
;	  ( BOTELLA-de-KLEIN-05 )			MEDIA BOTELLA (SIMETRICA)     					                       												06-01-2009			
;																																																																			
;-------------------------------------------------------------------------------------------------------------------------------------
;	 ECUACION BOTELLA de KLEIN                            p=2*PI*u   q=2*PI*v   r=4*(1-cos(p)/2)																				
;																																																																			
;  ARR | x1=6*cos(p)*(1+sin(p))+r*cos(p)*cos(q)        	ABA | x1=16*sin(p)+r*sin(p)*cos(q)                 x=((p<=PI)?x1:x2)        	
;      | x2=6*cos(p)*(1+sin(p))-r*cos(q)               	    | y2=16*sin(p)                                 y=((p<=PI)?y1:y2)        	
;      | z=r*sin(q)                                         | z=r*sin(q)                                                            	
;-------------------------------------------------------------------------------------------------------------------------------------



	;-----------------------------------------------------------------------------------------------------------------------------------
	;	(03) # PUNTOS-ARRIBA # BOTELLA de KLEIN   =>  LIS-LIS-PUN-CURVA-ARR																																
	(DEFUN PUNTOS-ARRIBA (/  )

	(SETQ LIS-LIS-PUN-CURVA-ARR  nil )

	(SETQ IniFILA  0.0 )  																														; FILA (-0.5..+0.5 )  FILA =< 0.5  FF ( -PI..+P1 )
  (SETQ FinFILA  0.5 )
	(SETQ PasoFILA (/ (- FinFILA IniFILA ) nFILA ))

	(SETQ IniCOLU  0.0 )  					  																								; COLU (-0.5..+0.5 )  COLU =< 0.5  CC ( -PI..+P1 )
  (SETQ FinCOLU  0.5 )
	(SETQ PasoCOLU (/ (- FinCOLU IniCOLU ) nCOLU ))

	(SETQ COLU (- IniCOLU  PasoCOLU ))
	(REPEAT  (+ nCOLU 1 )											; CARAS por ANILLO 
		(SETQ COLU  (+ COLU  PasoCOLU ))

		(SETQ LIS-P-ARR  nil )

		(SETQ FILA (- IniFILA  PasoFILA ))
		(REPEAT  (+ nFILA 1 )										; N ANILLOS  
			(SETQ FILA  (+ FILA  PasoFILA ))

			; ECUACIONES de ARRIBA																												

			(SETQ FF (* 2.0 PI FILA ))                                                    ; p = 2*PI*u        p < = PI     u < = 1/2   
			(SETQ CC (* 2.0 PI COLU ))                                                    ; q = 2*PI*v                                 
			(SETQ RR (+ RAmi1 (* 4 (/ (- 1 (COS FF)) 2.0 ))))                             ; r = 4*(1-cos(p)/2)    +0 => +2.0 Bien      

			(SETQ XX1 (+ (*  6.0 (COS FF)  (+ 1.0 (SIN FF))) (* RR (COS FF) (COS CC ))))  ; x1 = 6*cos(p)*(1+sin(p)) + r*cos(p)*cos(q) 
			(SETQ YY1 (+ (* 16.0 (SIN FF))                   (* RR (SIN FF) (COS CC ))))  ; y1 = 16*sin(p) + r*sin(p)*cos(q)           
			(SETQ ZZ1 (* RR (SIN CC )))                                                   ; z1 = r*sin(q)                              

			(SETQ LIS-P-ARR (CONS (LIST (* XX1 Ex ) (* YY1 Ey ) (* ZZ1 Ez )) LIS-P-ARR ))	; VERTICAL   ARR                              
			;(SETQ LIS-P-ARR (CONS (LIST (* YY1 Ey ) (* XX1 Ex ) (* ZZ1 Ez )) LIS-P-ARR ))	; HORIZONTAL ARR                              

		) ; repe COLU

		(SETQ LIS-P-ARR (REVERSE LIS-P-ARR ))																						; (LENGTH LIS-P-ARR )  
		(SETQ LIS-LIS-PUN-CURVA-ARR (CONS LIS-P-ARR  LIS-LIS-PUN-CURVA-ARR ))

	) ; repe FILA

	(SETQ LIS-LIS-PUN-CURVA-ARR (REVERSE LIS-LIS-PUN-CURVA-ARR ))										; (LENGTH LIS-LIS-PUN-CURVA-ARR ) 9 Anillos 

	) ;  PUNTOS-ARRIBA  =>  LIS-LIS-PUN-CURVA-ARR	- - - - - - - - - - - - - - - - -  - - - - - - - - - - - - - - - - - - - - - - - - -  
	;-----------------------------------------------------------------------------------------------------------------------------------

;-------------------------------------------------------------------------------------------------------------------------------------
;	 ECUACION BOTELLA de KLEIN                            p=2*PI*u   q=2*PI*v   r=4*(1-cos(p)/2)																				
;																																																																			
;  ARR | x1=6*cos(p)*(1+sin(p))+r*cos(p)*cos(q)        	ABA | x1=16*sin(p)+r*sin(p)*cos(q)                 x=((p<=PI)?x1:x2)        	
;      | x2=6*cos(p)*(1+sin(p))-r*cos(q)               	    | y2=16*sin(p)                                 y=((p<=PI)?y1:y2)        	
;      | z=r*sin(q)                                         | z=r*sin(q)                                                            	
;-------------------------------------------------------------------------------------------------------------------------------------

	;-----------------------------------------------------------------------------------------------------------------------------------
	;	(04) # PUNTOS-ABAJO # BOTELLA de KLEIN   =>  LIS-LIS-PUN-CURVA-ABA																																
	(DEFUN PUNTOS-ABAJO (/  )

	(SETQ LIS-LIS-PUN-CURVA-ABA  nil )

	(SETQ IniFILA     0.0  )  																												; FILA (-0.5..+0.5 )  FILA =< 0.5   FF ( -PI..+P1 )
  (SETQ FinFILA  (- 0.5 ))
	(SETQ PasoFILA (/ (- FinFILA IniFILA ) nFILA ))

	(SETQ IniCOLU  0.0 )  																														; COLU (-0.5..+0.5 )  COLU =< 0.5   CC ( -PI..+P1 )
  (SETQ FinCOLU  0.5 )
	(SETQ PasoCOLU (/ (- FinCOLU IniCOLU ) nCOLU ))

	(SETQ COLU (- IniCOLU  PasoCOLU ))
	(REPEAT  (+ nCOLU 1 )													; CARAS por ANILLO 
		(SETQ COLU  (+ COLU  PasoCOLU ))

		(SETQ LIS-P-ABA  nil )


		(SETQ PASOAg  (/ PI (/ nFILA 2.0)))
		(SETQ DESAg  (- PASOAg ))

		(SETQ FILA (- IniFILA  PasoFILA ))
		(REPEAT  (+ nFILA 1 )												; N ANILLOS  
			(SETQ FILA  (+ FILA  PasoFILA ))

			; MODIFICADOR de ABAJO																												

			;(SETQ RAmi2 (+ RAmi1 (* (EXPT (* 16.0 (SIN (* 2.0 PI FILA ))) 2 ) DESRa )))  	; RAmi2 = RAmi1 + ( YY2^2 * DESRa ) 



			(COND
				((> (ABS FILA ) (/ (ABS FinFILA ) 2.0 ))
               (SETQ DESAg (+ DESAg  PASOAg ))
               (SETQ KKy   (* 10.0 (SIN DESAg )))
					     (SETQ RAmi2 (+ KKy  RAmi1 (* (EXPT (* 16.0 (SIN (* 2.0 PI FILA ))) 2 ) DESRa )))) ; c1

				(  T   (SETQ RAmi2 (+      RAmi1 (* (EXPT (* 16.0 (SIN (* 2.0 PI FILA ))) 2 ) DESRa )))) ; c2
			) ; com



			; ECUACIONES de ABAJO																													

			(SETQ FF (* 2.0 PI FILA ))                                                    ; p = 2*PI*u        p < = PI     u < = 1/2   
			(SETQ CC (* 2.0 PI COLU ))                                                    ; q = 2*PI*v                                 
			(SETQ RR (+ RAmi2 (* 4 (/ (- 1 (COS FF)) 2.0 ))))                             ; r = 4*(1-cos(p)/2)    +0 => +2.0 Bien      

			(SETQ XX2 (- (* 6.0 (COS FF) (+ 1.0 (SIN FF))) (* RR (COS CC))))          		; x3 = 6*cos(p)*(1+sin(p)) -r*cos(q)  1???    
			(SETQ YY2 (* 16.0 (SIN FF)))                                               		; y3 = 16*sin(p)                             
			(SETQ ZZ1 (* RR (SIN CC )))                                                   ; z1 = r*sin(q)                              

			;(SETQ XX2 (+ (* 16 (SIN FF)) (* RR (SIN FF) (COS CC))))          							; x3 = 16*sin(p) + r*sin(p)*cos(q)   2???   

			(SETQ LIS-P-ABA (CONS (LIST (* XX2 Ex ) (* YY2 Ey ) (* ZZ1 Ez )) LIS-P-ABA ))	; VERTICAL   ABA                               
			;(SETQ LIS-P-ABA (CONS (LIST (* YY2 Ey ) (* XX2 Ex ) (* ZZ1 Ez )) LIS-P-ABA ))	; HORIZONTAL ABA                               

		) ; repe COLU

		(SETQ LIS-P-ABA (REVERSE LIS-P-ABA ))																						; (LENGTH LIS-P-ABA )  
		(SETQ LIS-LIS-PUN-CURVA-ABA (CONS LIS-P-ABA  LIS-LIS-PUN-CURVA-ABA ))

	) ; repe FILA

	(SETQ LIS-LIS-PUN-CURVA-ABA (REVERSE LIS-LIS-PUN-CURVA-ABA ))										; (LENGTH LIS-LIS-PUN-CURVA-ABA ) 9 Anillos 

	) ;  PUNTOS-ABAJO  =>  LIS-LIS-PUN-CURVA-ABA - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	;-----------------------------------------------------------------------------------------------------------------------------------

	;-----------------------------------------------------------------------------------------------------------------------------------
	;	(05) ## ARRIBA ##  PINTA 3DCARAS ORIGINALES 3D 																																										
	(DEFUN PINTA-3DC-ARRIBA-3D (/  )

	(SETQ N10 -1 )
	(REPEAT (- (LENGTH LIS-LIS-PUN-CURVA-ARR ) 1 )													; (LENGTH LIS-LIS-PUN-CURVA-ARR ) 31 
		(SETQ N10  (+ N10  1 ))
		(SETQ LIS-PUN-CUR-A1 (NTH (+ N10 0 ) LIS-LIS-PUN-CURVA-ARR ))				; (LENGTH LIS-PUN-CUR-A1 ) 13 
		(SETQ LIS-PUN-CUR-A2 (NTH (+ N10 1 ) LIS-LIS-PUN-CURVA-ARR ))				; (LENGTH LIS-PUN-CUR-A2 ) 13 

		(SETQ N1 -1 )
		(REPEAT (- (LENGTH LIS-PUN-CUR-A1 ) 1 )
			(SETQ N1  (+ N1  1 ))

			(SETQ A1a (NTH (+ N1 0 ) LIS-PUN-CUR-A1 ))
			(SETQ A2a (NTH (+ N1 1 ) LIS-PUN-CUR-A1 ))
			(SETQ B1a (NTH (+ N1 0 ) LIS-PUN-CUR-A2 ))
			(SETQ B2a (NTH (+ N1 1 ) LIS-PUN-CUR-A2 ))

			;(IF (= (REM N10 2) 1 ) (SETQ CO1 1 ) (SETQ CO1 2 ))
			;(COMMAND "COLOR" CO1  "3DCARA" A1a  A2a  B2a  B1a "" )			; 3D

			(COMMAND "COLOR" 2  "3DCARA" A1a  A2a  B2a  B1a "" )				; 3D
		) ; repe N1 
  ) ; repe N10 

	) ;  PINTA-3DC-ARRIBA-3D - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	;-----------------------------------------------------------------------------------------------------------------------------------


	;-----------------------------------------------------------------------------------------------------------------------------------
	;	(06) ## ABAJO ##  PINTA 3DCARAS ORIGINALES 3D 2D  ( 3DCARAS-ABAJO SON PLANAS )																										
	(DEFUN PINTA-3DC-ABAJO-3D-2D (/  )

	(SETQ N20 -1 )
	(REPEAT (- (LENGTH LIS-LIS-PUN-CURVA-ABA ) 1 )															; (LENGTH LIS-LIS-PUN-CURVA-ABA ) 31 
		(SETQ N20  (+ N20  1 ))
  	(SETQ LIS-PUN-CUR-B1 (NTH (+ N20 0 ) LIS-LIS-PUN-CURVA-ABA ))						; (LENGTH LIS-PUN-CUR-B1 ) 13 
    (SETQ LIS-PUN-CUR-B2 (NTH (+ N20 1 ) LIS-LIS-PUN-CURVA-ABA ))						; (LENGTH LIS-PUN-CUR-B2 ) 13 

		(SETQ K1Aba (LIST (* 40 (+ (/ N20 2.0) 1)) -40 0 ))
		(SETQ K2Aba (LIST (* 41 (+ (/ N20 2.0) 1)) -40 0 ))

		(SETQ N2 -1 )
		(REPEAT (- (LENGTH LIS-PUN-CUR-B1 ) 1 )
			(SETQ N2  (+ N2  1 ))

			(SETQ A1b (NTH (+ N2 0 ) LIS-PUN-CUR-B1 ))
			(SETQ A2b (NTH (+ N2 1 ) LIS-PUN-CUR-B1 ))
			(SETQ B1b (NTH (+ N2 0 ) LIS-PUN-CUR-B2 ))
			(SETQ B2b (NTH (+ N2 1 ) LIS-PUN-CUR-B2 ))

			(COMMAND "COLOR" 2  "3DCARA" A1b  A2b  B2b  B1b "" )			; 3D  "COLOR" 2 

			; PATRONES-2D     ABAJO (LAS 3DCARAS SON PLANAS)																																								
			(IF PIN-2D (PROGN  ; - - - - - - - - - - - - - - - - - - - - - - - - -  - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

			(COMMAND "SCP" "3P" A1b B1b A2b )
				(SETQ A1bp (TRANS A1b 0 1 ))
				(SETQ A2bp (TRANS A2b 0 1 ))
				(SETQ B2bp (TRANS B2b 0 1 ))
				(SETQ B1bp (TRANS B1b 0 1 ))
				(COMMAND "COLOR" 5  "TEXTO" (LIST 0.0 0.0 ) 0.08 0 (STRCAT "<J" (ITOA (+ N20 1)) "/" (ITOA (+ N2 1))))			; 3D
			(COMMAND "SCP" "U")

			(COMMAND "SCP" "3P" K1Aba K2Aba "" )
				(COMMAND "COLOR" 4  "3DCARA" A1bp  A2bp  B2bp  B1bp "" )			; 2D  3DCARAS PLANAS
				(COMMAND "COLOR" 5  "TEXTO" (LIST 0.0 0.0 ) 0.08 0 (STRCAT "<J" (ITOA (+ N20 1)) "/" (ITOA (+ N2 1))))			; 2D
				(SETQ K1Aba (TRANS A2bp 1 0 ))
				(SETQ K2Aba (TRANS B2bp 1 0 ))
			(COMMAND "SCP" "U")
			)) ; IF "P-2D T" - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

		) ; repe N2 
	) ; repe N20 

	) ;  PINTA-3DC-ABAJO-3D-2D   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	;-----------------------------------------------------------------------------------------------------------------------------------


	;-----------------------------------------------------------------------------------------------------------------------------------
	;	(20) GRAFICA  ANGULOS de TORSION																									  																							
	(DEFUN GRAFICA-ANG-TORSION (/  )

	; FIJA VALORES																																																											

	(SETQ EGx   1.2 )																																			; ESCALA GRAFICA Ang 
	(SETQ EGy   0.2 )

	(SETQ INI-GRAx  -30.0 )																																; DISx INICIO GRAFICA 
	(SETQ DIS-GRAx  -15.0 )																																; DISx ENTRE GRAFICAS 

	(SETQ INI-GRAy   10.0 )																																; DISy INICIO GRAFICA REF 

	; PUNTOS  (A1 A2)  (B1 B2 B3)																																																				

	(SETQ LIS/AB-NANG-0 nil )

	(SETQ NAB -1 )
	(REPEAT  (- (LENGTH LIS-LIS-PUN-CURVAS ) 1 )																					; (LENGTH LIS-LIS-PUN-CURVAS )    4 
		(SETQ NAB  (+ NAB  1 ))

		(SETQ LIS-PUN-CUR-A (NTH (+ NAB 0 ) LIS-LIS-PUN-CURVAS ))													; (LENGTH LIS-PUN-CUR-A )    23 
		(SETQ LIS-PUN-CUR-B (NTH (+ NAB 1 ) LIS-LIS-PUN-CURVAS ))													; (LENGTH LIS-PUN-CUR-B )    23 

		(SETQ DinX (+ (* NAB  DIS-GRAx ) INI-GRAx ))																				; DISTANCIA X INICIO GRAFICA
		(SETQ NTag  (- (LENGTH LIS-PUN-CUR-A) 2 ))																					; N PUNTOS -2 (N TANG)
		(SETQ DISx2  DinX )

		(SETQ LIS/A-NANG-0 nil )

		(SETQ CONTA-AB  0 )

		(SETQ NA -1 )																																			; (LENGTH LIS-LIS-PUN-CURVA-ARR )  23 
		(REPEAT  (- (LENGTH LIS-PUN-CUR-A ) 1 )
			(SETQ NA  (+ NA  1 ))

			(SETQ A1 (NTH (+ NA 0 ) LIS-PUN-CUR-A ))
			(SETQ A2 (NTH (+ NA 1 ) LIS-PUN-CUR-A ))

			; LINEAS VERTICALES de REFERENCIA  (REPARTO UNIFORME)																																						

			(SETQ COLO2 (+ NA 1 ))   ; COLO2 ? 

			(SETQ P-REF1  (LIST (+ (* EGx NA) DinX )  (+ 0.0 INI-GRAy  DinY )))
			(SETQ P-REF2  (LIST (+ (* EGx NA) DinX )  (+ 5.0 INI-GRAy  DinY )))

			(COMMAND "COLOR" COLO2  "LINEA" P-REF1  P-REF2 "" )

			(SETQ LIS/B-NANG-0 nil )

			(SETQ MARCA-A  T )
			(SETQ NB -1 )
			(REPEAT (- (LENGTH LIS-PUN-CUR-B ) 2 )
				(SETQ NB  (+ NB  1 ))

				(SETQ B1 (NTH (+ NB 0 ) LIS-PUN-CUR-B ))
				(SETQ B2 (NTH (+ NB 1 ) LIS-PUN-CUR-B ))
				(SETQ B3 (NTH (+ NB 2 ) LIS-PUN-CUR-B ))

				(SETQ N1 (CAL " A1 + NOR( A1 , A2 , B1 ) "))
				(SETQ N2 (CAL " A1 + NOR( A1 , A2 , B2 ) "))
				(SETQ N3 (CAL " A1 + NOR( A1 , A2 , B3 ) "))

				;  ANGULOS (ANG1 ANG2) <= VECTORES (N1 N2 N3) <=  PUNTOS (A1 A2) (B1 B2 B3)  																									

				(COND
					((AND (NOT (EQUAL N1 N2 mUNI)) (NOT (EQUAL N2 N3 mUNI)))																; ang( V0 , P1 , P2 , V1 )
						(SETQ Ag12 (CAL " ANG( A1 , N1 , N2 , A2 ) ")) (IF (< Ag12 180.0) (SETQ ANG1  Ag12)  (SETQ ANG1 (- Ag12 360.0 )))
						(SETQ Ag23 (CAL " ANG( A1 , N2 , N3 , A2 ) ")) (IF (< Ag23 180.0) (SETQ ANG2  Ag23)  (SETQ ANG2 (- Ag23 360.0 ))) ) ; c1
					
					((AND (EQUAL N1 N2 mUNI) (NOT (EQUAL N2 N3 mUNI)))                  (SETQ ANG1  0.0 )
						(SETQ Ag23 (CAL " ANG( A1 , N2 , N3 , A2 ) ")) (IF (< Ag23 180.0) (SETQ ANG2  Ag23)  (SETQ ANG2 (- Ag23 360.0 ))) ) ; c2
					
					((AND (EQUAL N2 N3 mUNI) (NOT (EQUAL N1 N2 mUNI)))                  (SETQ ANG2  0.0 )
						(SETQ Ag12 (CAL " ANG( A1 , N1 , N2 , A2 ) ")) (IF (< Ag12 180.0) (SETQ ANG1  Ag12)  (SETQ ANG1 (- Ag12 360.0 ))) ) ; c3
					
					((AND (EQUAL N1 N2 mUNI) (EQUAL N2 N3 mUNI))                        (SETQ ANG1 0.0 )  (SETQ ANG2 0.0 )              ) ; c4

					(  T   (PROMPT "  NO CUMPLE COMDICION (N1 N2 N3)  NB = ") (PRIN1 NB ) (TERPRI)                         ) ; c5
				) ; con


				; LINEAS GRAFICA de ANGULOS																																																		

				(SETQ G1 (LIST (+ (* EGx    NB    ) DinX ) (+ (* EGy  ANG1 ) DinY )))
				(SETQ G2 (LIST (+ (* EGx (+ NB 1 )) DinX ) (+ (* EGy  ANG2 ) DinY )))

				(COMMAND "COLOR" COLO2  "LINEA" G1  G2 "" )

				(IF (= NB    0      )
						(COMMAND "COLOR" COLO2  "TEXTO" "MD" G1 0.15 0 (STRCAT     (ITOA (+ NAB 1)) "#" (ITOA (+ NA 1)) ">" )))

				(IF (= NB (- NTag 1))
						(COMMAND "COLOR" COLO2  "TEXTO" "MI" G2 0.15 0 (STRCAT "<" (ITOA (+ NAB 1)) "#" (ITOA (+ NA 1))     )))

				; GRAFICA LINE-VERTICALES donde la GRAFICA-Ag  CORTA al EjeX   Y = 0																													

				(COND
					((AND (>= ANG1 0.0) (<= ANG2 0.0))															; GRAFICA BAJA 

						(SETQ K1 (/ (ABS ANG1 ) (+ (ABS ANG1 ) (ABS ANG2 )) ))
						(SETQ G01 (CAL " PLT( G1 , G2 , K1 ) "))
						(SETQ P-L11 (LIST (CAR G01)  (+ 10.0 INI-GRAy  DinY )))
						(SETQ P-L12 (LIST (CAR G01)  (+ 15.0 INI-GRAy  DinY )))

						(SETQ DISx1 (CAR G01 ))

						(COND
							((AND (= MARCA-A  T ) (>= DISx1  DISx2 ))  ; (>= NB  CONTA-AB )
								(COMMAND "COLOR" COLO2  "LINEA"  P-L11  P-L12  "" )
								(COMMAND "COLOR"  255   "LINEA"  P-L11  P-REF2 "" )
								(COMMAND "COLOR"    7   "PUNTO"  G01 )

								(SETQ DISx2  DISx1 )

								(SETQ MARCA-A nil )
								;(SETQ CONTA-AB (+ CONTA-AB 1 ))
								(SETQ CONTA-AB  (- NB 1 ) )
								(SETQ LIS/B-NANG-0 (CONS (LIST 'BAJA (+ NAB 1) (+ NA 1) (+ NB 1)) LIS/B-NANG-0 ))
							) ; c2

							( T (COMMAND "COLOR"  8  "LINEA"  P-L11  P-REF2  "" )) ; c3
						) ; con

					) ; c1

					((AND (>= ANG2 0.0) (<= ANG1 0.0))															; GRAFICA SUBE 

						(SETQ K2  (/ (ABS ANG2 ) (+ (ABS ANG1 ) (ABS ANG2 )) ))
						(SETQ G02 (CAL " PLT( G2 , G1 , K2 ) "))
						(SETQ P-L21 (LIST (CAR G02)  (+ 10.0 INI-GRAy  DinY )))
						(SETQ P-L22 (LIST (CAR G02)  (+ 15.0 INI-GRAy  DinY )))

						(SETQ DISx1 (CAR G02 ))

						(COND
							((AND (= MARCA-A  T ) (>= DISx1  DISx2 ))  ; (>= NB  CONTA-AB )
								(COMMAND "COLOR" COLO2  "LINEA"  P-L21  P-L22  "" )
								(COMMAND "COLOR"  255   "LINEA"  P-L21  P-REF2 "" )
								(COMMAND "COLOR"    7   "PUNTO"  G02 )

								(SETQ DISx2  DISx1 )

								(SETQ MARCA-A nil )
								;(SETQ CONTA-AB (+ CONTA-AB 1 ))
								(SETQ CONTA-AB  (- NB 1 ) )
								(SETQ LIS/B-NANG-0 (CONS (LIST 'SUBE (+ NAB 1) (+ NA 1) (+ NB 1)) LIS/B-NANG-0 ))
							) ; c2

							( T (COMMAND "COLOR"  8  "LINEA"  P-L21  P-REF2  "" )) ; c3
						) ; con

					) ; c2
				) ; con

			) ; repe NB

		(SETQ LIS/B-NANG-0 (REVERSE LIS/B-NANG-0 ))
		(SETQ LIS/A-NANG-0    (CONS LIS/B-NANG-0  LIS/A-NANG-0 ))

		) ; repe NA


		(SETQ LIS/A-NANG-0 (REVERSE LIS/A-NANG-0 ))
		(SETQ LIS/AB-NANG-0   (CONS LIS/A-NANG-0  LIS/AB-NANG-0 ))



		; EJES HORIZONTALES GRAFICA																																																				

		(COMMAND "COLOR" 7 )
		(COMMAND "LINEA" (LIST (+ (* EGx 0)  DinX) (+ (*   0 EGy) DinY)) (LIST (+ (* EGx NTag) +1 DinX) (+ (*   0 EGy) DinY)) "" ) 
		(COMMAND "COLOR" 8 )
		(COMMAND "LINEA" (LIST (+ (* EGx 0) DinX) (+ (* +10 EGy) DinY)) (LIST (+ (* EGx NTag) DinX) (+ (* +10 EGy) DinY)) "" )
		(COMMAND "LINEA" (LIST (+ (* EGx 0) DinX) (+ (*  +5 EGy) DinY)) (LIST (+ (* EGx NTag) DinX) (+ (*  +5 EGy) DinY)) "" )
		(COMMAND "LINEA" (LIST (+ (* EGx 0) DinX) (+ (*  -5 EGy) DinY)) (LIST (+ (* EGx NTag) DinX) (+ (*  -5 EGy) DinY)) "" )
		(COMMAND "LINEA" (LIST (+ (* EGx 0) DinX) (+ (* -10 EGy) DinY)) (LIST (+ (* EGx NTag) DinX) (+ (* -10 EGy) DinY)) "" )

		(COMMAND "COLOR" 8  "TEXTO" "MI" (LIST (+ (* EGx  NTag) +1 DinX) (+ (* +10 EGy) DinY)) 0.3 0 "< +10")
		(COMMAND "COLOR" 8  "TEXTO" "MI" (LIST (+ (* EGx  NTag) +1 DinX) (+ (*  +5 EGy) DinY)) 0.3 0 "< +05")
		(COMMAND "COLOR" 7  "TEXTO" "MI" (LIST (+ (* EGx  NTag) +1 DinX) (+ (*   0 EGy) DinY)) 0.3 0 "<  00")
		(COMMAND "COLOR" 8  "TEXTO" "MI" (LIST (+ (* EGx  NTag) +1 DinX) (+ (*  -5 EGy) DinY)) 0.3 0 "< -05")
		(COMMAND "COLOR" 8  "TEXTO" "MI" (LIST (+ (* EGx  NTag) +1 DinX) (+ (* -10 EGy) DinY)) 0.3 0 "< -10")


	) ; repe NAB 

	(SETQ LIS/AB-NANG-0  (REVERSE LIS/AB-NANG-0 ))

	) ;  GRAFICA-ANG-TORSION   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	;-----------------------------------------------------------------------------------------------------------------------------------


	;-----------------------------------------------------------------------------------------------------------------------------------
	;	(10) PINTA y NUMERA PUNTOS de CURVAS ORIGINALES de ARRIBA y ABAJO																	 																
	(DEFUN NUMERA-P-CUR-ORIGINALES (/  )

	(SETQ N70 -1 )
	(REPEAT  (LENGTH LIS-LIS-PUN-CURVA-ARR )																										; (LENGTH LIS-LIS-PUN-CURVA-ARR )  5 
		(SETQ N70 (+ N70  1 ))

		(SETQ LIS-PUN-ARR          (NTH N70  LIS-LIS-PUN-CURVA-ARR ))														; (LENGTH LIS-PUN-ARR )        21 
		(SETQ LIS-PUN-ABA (REVERSE (NTH N70  LIS-LIS-PUN-CURVA-ABA )))														; (LENGTH LIS-PUN-ABA )        21 

		(IF (= (REM N70 5 ) 0 ) (SETQ COLO3 1) (SETQ COLO3 (+ (REM N70 5 ) 1 )))

		(SETQ N7 -1 )
		(REPEAT  (- (LENGTH LIS-PUN-ARR ) 1 )
			(SETQ N7 (+ N7  1 ))

			(SETQ P-ARR1 (NTH (+ N7 0)  LIS-PUN-ARR ))
			(SETQ P-ARR2 (NTH (+ N7 1)  LIS-PUN-ARR ))

			(SETQ P-ABA1 (NTH (+ N7 0)  LIS-PUN-ABA ))
			(SETQ P-ABA2 (NTH (+ N7 1)  LIS-PUN-ABA ))

			(IF (= N7 0 )
				(PROGN
					(COMMAND "COLOR" 7  "LINEA" P-ARR1  P-ARR2 "" )
					(COMMAND "COLOR" 5  "LINEA" P-ABA1  P-ABA2 "" )

					(COMMAND "COLOR" COLO3  "PUNTO" P-ARR1 )
					(COMMAND "COLOR" COLO3  "PUNTO" P-ARR2 )
					(COMMAND "COLOR" COLO3  "PUNTO" P-ABA1 )
					(COMMAND "COLOR" COLO3  "PUNTO" P-ABA2 )

					(COMMAND "COLOR" COLO3  "TEXTO" "MI" P-ARR1 0.05 0 (STRCAT "<R-" (ITOA (+ N70 1 )) "/" (ITOA (+ N7 1 ))))
					(COMMAND "COLOR" COLO3  "TEXTO" "MI" P-ARR2 0.05 0 (STRCAT "<R-" (ITOA (+ N70 1 )) "/" (ITOA (+ N7 2 ))))
					(COMMAND "COLOR" COLO3  "TEXTO" "MI" P-ABA1 0.05 0 (STRCAT "<J-" (ITOA (+ N70 1 )) "/" (ITOA (+ N7 1 ))))
					(COMMAND "COLOR" COLO3  "TEXTO" "MI" P-ABA2 0.05 0 (STRCAT "<J-" (ITOA (+ N70 1 )) "/" (ITOA (+ N7 2 ))))
				) ; pro

				(PROGN
					(COMMAND "COLOR" 7  "LINEA" P-ARR1  P-ARR2 "" )
					(COMMAND "COLOR" 5  "LINEA" P-ABA1  P-ABA2 "" )

					(COMMAND "COLOR" COLO3  "PUNTO" P-ARR2 )
					(COMMAND "COLOR" COLO3  "PUNTO" P-ABA2 )

					(COMMAND "COLOR" COLO3  "TEXTO" "MI" P-ARR2 0.05 0 (STRCAT "<R-" (ITOA (+ N70 1 )) "/" (ITOA (+ N7 2 ))))
					(COMMAND "COLOR" COLO3  "TEXTO" "MI" P-ABA2 0.05 0 (STRCAT "<J-" (ITOA (+ N70 1 )) "/" (ITOA (+ N7 2 ))))
				) ; pro
			) ; if

		) ; repe 7
	) ; repe 70

	) ;  NUMERA-P-CUR-ORIGINALES   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	;-----------------------------------------------------------------------------------------------------------------------------------


	;-----------------------------------------------------------------------------------------------------------------------------------
	;	(11) AADE PUNTO DELANTE y DETRAS a LIS-ARRIBA  =>  LIS-LIS-ARRIBA+2P																															
	(DEFUN AADE-P-LIS-ARRIBA (/  )

	(SETQ LIS-LIS-ARRIBA+2P nil )

	(SETQ N9D -1 )
	(SETQ N9I (LENGTH LIS-LIS-PUN-CURVA-ARR ) )
	(REPEAT  (LENGTH LIS-LIS-PUN-CURVA-ARR )																									; (LENGTH LIS-LIS-PUN-CURVA-ARR )  4 
		(SETQ N9D (+ N9D  1 ))
		(SETQ N9I (- N9I  1 ))

		(SETQ LIS-ARR/X          (NTH N9D  LIS-LIS-PUN-CURVA-ARR  ))														; (LENGTH LIS-ARR/X )             21 
		(SETQ LIS-ABA/D (REVERSE (NTH N9D  LIS-LIS-PUN-CURVA-ABA )))														; (LENGTH LIS-ABA/D )             21 
		(SETQ LIS-ABA/I (REVERSE (NTH N9I  LIS-LIS-PUN-CURVA-ABA )))														; (LENGTH LIS-ABA/I )             21 

		(SETQ 2PABA (NTH        1                   LIS-ABA/D ))																; 2-PUNTO    LIS-ABA ORDEN DIRECTO 
		(SETQ 2UABA (NTH (- (LENGTH LIS-ABA/I ) 2 ) LIS-ABA/I ))																; PENULTIMO-P LIS-ABA ORDEN INVERSO 

		(SETQ LIS-AA (REVERSE LIS-ARR/X ))    (SETQ LIS-AA (CONS 2PABA  LIS-AA ))						; AADE 2PABA por  DETRAS  
		(SETQ LIS-AA (REVERSE LIS-AA   ))    (SETQ LIS-AA (CONS 2UABA  LIS-AA ))						; AADE 2UABA por  DELANTE 

		(SETQ LIS-LIS-ARRIBA+2P (CONS LIS-AA  LIS-LIS-ARRIBA+2P ))

	) ; repe N9D

	(SETQ LIS-LIS-ARRIBA+2P (REVERSE LIS-LIS-ARRIBA+2P ))

	) ;  AADE-P-LIS-ARRIBA   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	;-----------------------------------------------------------------------------------------------------------------------------------


	;-----------------------------------------------------------------------------------------------------------------------------------
	;	(10) PINTA y NUMERA PUNTOS de CURVAS de LIS-LIS-ARRIBA+2P											 																										
	(DEFUN NUMERA-LIS-LIS-ARRIBA+2P (/  )

	(SETQ N80 -1 )
	(REPEAT  (LENGTH LIS-LIS-ARRIBA+2P )																													; (LENGTH LIS-LIS-ARRIBA+2P )  5 
		(SETQ N80 (+ N80  1 ))

		(SETQ LIS-PUN-1 (NTH N80  LIS-LIS-ARRIBA+2P ))																						; (LENGTH LIS-PUN-1 )        23 

		(IF (= (REM N80 5 ) 0 ) (SETQ COLO4 1) (SETQ COLO4 (+ (REM N80 5 ) 1 )))

		(SETQ N8 -1 )
		(REPEAT  (- (LENGTH LIS-PUN-1 ) 1)
			(SETQ N8 (+ N8  1 ))

			(SETQ P-1 (NTH (+ N8 0 )  LIS-PUN-1 ))
			(SETQ P-2 (NTH (+ N8 1 )  LIS-PUN-1 ))

			(COMMAND "COLOR" COLO4 )
			(IF (= N8 0 )
				(PROGN
					(COMMAND "PUNTO" P-1 )
					(COMMAND "PUNTO" P-2 )
					(COMMAND "LINEA" P-1 P-2 "" )
					;(COMMAND "TEXTO" "MI" P-1  0.2  0 (STRCAT "(" (ITOA (+ N80 1 )) "/" (ITOA (+ N8 1 )) ")" )) 
					;(COMMAND "TEXTO" "MI" P-2  0.2  0 (STRCAT "(" (ITOA (+ N80 1 )) "/" (ITOA (+ N8 2 )) ")" )) 
				) ; pro

				(PROGN
					(COMMAND "PUNTO" P-2 )
					(COMMAND "LINEA" P-1 P-2 "" )
					;(COMMAND "TEXTO" "MI" P-2  0.2  0 (STRCAT "(" (ITOA (+ N80 1 )) "/" (ITOA (+ N8 2 )) ")" )) 
				) ; pro
			) ; if

		) ; repe 8
	) ; repe 80

	) ;  NUMERA-LIS-LIS-ARRIBA+2P   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	;-----------------------------------------------------------------------------------------------------------------------------------





"####################################################################################################################################"
;-------------------------------------------------------------------------------------------------------------------------------------
;       *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA*** PROGRAMA*** PROGRAMA***											
;-------------------------------------------------------------------------------------------------------------------------------------
"####################################################################################################################################"

(DEFUN C:BOTELLA-de-KLEIN-06 (/ )

	;-----------------------------------------------------------------------------------------------------------------------------------
	; (00) ARRANCANDO																																																										

 	(SETVAR "blipmode" 0) (SETVAR "cmdecho" 0)  (GRAPHSCR)  (COMMAND "-REFENT" "DES")  (COMMAND "SCP" "U")  (COMMAND "ORTO" "DES")

	(PROMPT " ============================================================================")  (TERPRI)
	(PROMPT " >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> INICIO >>>>>>>>> BOTELLA-de-KLEIN-06 >>>>>>>>")  (TERPRI)
	(PROMPT " ============================================================================")  (TERPRI)  (TERPRI)

	;-----------------------------------------------------------------------------------------------------------------------------------
	;	(01) FIJA VARIABLES de PROGRAMA																																																		

	(IF (= CAL nil)(COMMAND "ARX" "L" "GEOMCAL.ARX"))		; CARGA CALCULADORA 
	(SETQ mUNI 1.0e-004 )																; MARGEN EQUAL VEC-UNI (1.0e-006) (1.01e-008)LIMITE-MAR-INTER-RECT-01.lsp 


	;===================================================================================================================================
	;	(02) FIJA VARIABLES																																																								

	(SETQ nFILA  80 )					; 7 	; NUMERO de AMILLOS    NEntero 
	(SETQ nCOLU   2 )								; CARAS por 1/2 ANILLO NEntero 

	(SETQ RAmi1    2.0 )						; RADIO MINIMO 2 
	(SETQ DESRa (/ 1.0 29 ) )				; DESVIA RADIO MINIMO 1/29 

	(SETQ Ex    1.0 )								; ESCALA BOTELLA 
	(SETQ Ey    1.0 )
	(SETQ Ez    1.0 )

	;-----------------------------------------------------------------------------------------------------------------------------------
									 ( PUNTOS-ARRIBA )           ;	(03) # ARRIBA #    PUNTOS BOTELLA de KLEIN   =>  LIS-LIS-PUN-CURVA-ARR							
	;-----------------------------------------------------------------------------------------------------------------------------------
									 ( PUNTOS-ABAJO  )         	 ;	(04) # ABAJO #     PUNTOS BOTELLA de KLEIN   =>  LIS-LIS-PUN-CURVA-ABA							
	;-----------------------------------------------------------------------------------------------------------------------------------
	;								 ( NUMERA-P-CUR-ORIGINALES ) ;	(10) PINTA y NUMERA PUNTOS de CURVAS de ARRIBA y ABAJO															
	;-----------------------------------------------------------------------------------------------------------------------------------
									 ( PINTA-3DC-ARRIBA-3D )     ;	(05) ## ARRIBA ##  PINTA 3DCARAS ORIGINALES 3D 																			
	;-----------------------------------------------------------------------------------------------------------------------------------
	(SETQ PIN-2D nil ) ( PINTA-3DC-ABAJO-3D-2D )	 ;	(06) ## ABAJO ##   PINTA 3DCARAS ORIGINALES 3D 2D  ( 3DCARAS-ABAJO SON PLANAS )		
	;===================================================================================================================================
	;								 ( AADE-P-LIS-ARRIBA )		   ;	(11) AADE PUNTO DELANTE y DETRAS a LIS-ARRIBA  =>  LIS-LIS-ARRIBA+2P								
	;-----------------------------------------------------------------------------------------------------------------------------------
	;(SETQ LIS-LIS-PUN-CURVAS  LIS-LIS-ARRIBA+2P ) (SETQ DinY 0.0 ) (GRAFICA-ANG-TORSION)  ;	(#) GRAFICA  ANGULOS de TORSION ARRIBA	
	;(SETQ LIS-LIS-PUN-CURVAS  LIS-LIS-PUN-CURVA-ABA ) (SETQ DinY -15 ) (GRAFICA-ANG-TORSION)  ;	(#) GRAFICA  ANGULOS de TORSION ABAJO 
	;-----------------------------------------------------------------------------------------------------------------------------------
	;					       ( NUMERA-LIS-LIS-ARRIBA+2P );	(10) PINTA y NUMERA PUNTOS de CURVAS de LIS-LIS-ARRIBA+2P														



	;-----------------------------------------------------------------------------------------------------------------------------------
	;	(07) PUNTOS de PLANOS TANGENTES a DOS CURVAS-ALABEADAS  ARRIBA																								 										
	(IF nil (PROGN  ; - - - - - - - - - - - - - - - - - - - - - - - - -  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	(SETQ LIS-LIS-PUN-PLANOS-ARR nil )

	;(SETQ N400AB -1 )
	;(REPEAT  (- (LENGTH LIS-LIS-PUN-CURVA-ARR ) 1 )																			; (LENGTH LIS-LIS-PUN-CURVA-ARR )  5 
	;	(SETQ N400AB (+ N400AB  1 ))
	;	(SETQ LIS-PUN-CURVA-A (NTH (+ N400AB 0 ) LIS-LIS-PUN-CURVA-ARR ))									; (LENGTH LIS-PUN-CURVA-A )        21 
	;	(SETQ LIS-PUN-CURVA-B (NTH (+ N400AB 1 ) LIS-LIS-PUN-CURVA-ARR ))									; (LENGTH LIS-PUN-CURVA-B )        21 

	(SETQ N400AB -1 )
	(REPEAT  (- (LENGTH LIS-LIS-ARRIBA+2P ) 1 )																					; (LENGTH LIS-LIS-ARRIBA+2P )  3 
		(SETQ N400AB (+ N400AB  1 ))
		(SETQ LIS-PUN-CURVA-A (NTH (+ N400AB 0 ) LIS-LIS-ARRIBA+2P ))												; (LENGTH LIS-PUN-CURVA-A )        83 
		(SETQ LIS-PUN-CURVA-B (NTH (+ N400AB 1 ) LIS-LIS-ARRIBA+2P ))												; (LENGTH LIS-PUN-CURVA-B )        83 

		(SETQ LIS-PUN-PLANOS-ARR nil )

		(SETQ DISx2  0.0 )

		(SETQ N40A -1 )
		(REPEAT  (- (LENGTH LIS-PUN-CURVA-A ) 1 )
			(SETQ N40A (+ N40A  1 ))

			(SETQ A1 (NTH (+ N40A 0 ) LIS-PUN-CURVA-A ))
			(SETQ A2 (NTH (+ N40A 1 ) LIS-PUN-CURVA-A ))

			(SETQ COLO1 (+ N40A 1 ))   ; COLO1 ? 

			(SETQ MARCA-40A T )
			(SETQ N4B  -1 )
			(REPEAT  (- (LENGTH LIS-PUN-CURVA-B ) 2 )
				(SETQ N4B (+ N4B  1 ))

				;(IF (>= (+ N4B 2 ) (- (LENGTH LIS-PUN-CURVA-B ) 1 )) (SETQ WW1 nil ))

				(SETQ B1 (NTH (+ N4B 0 ) LIS-PUN-CURVA-B ))   (SETQ N1 (CAL " A1 + NOR( A1 , A2 , B1 ) "))
				(SETQ B2 (NTH (+ N4B 1 ) LIS-PUN-CURVA-B ))   (SETQ N2 (CAL " A1 + NOR( A1 , A2 , B2 ) "))
				(SETQ B3 (NTH (+ N4B 2 ) LIS-PUN-CURVA-B ))   (SETQ N3 (CAL " A1 + NOR( A1 , A2 , B3 ) "))

				;  ANGULOS (ANG1 ANG2) <= VECTORES (N1 N2 N3) <=  PUNTOS (A1 A2) (B1 B2 B3)  																									

				(COND
					((AND (NOT (EQUAL N1 N2 mUNI)) (NOT (EQUAL N2 N3 mUNI)))																; ang( V0 , P1 , P2 , V1 )
						(SETQ Ag12 (CAL " ANG( A1 , N1 , N2 , A2 ) ")) (IF (< Ag12 180.0) (SETQ ANG1  Ag12)  (SETQ ANG1 (- Ag12 360.0 )))
						(SETQ Ag23 (CAL " ANG( A1 , N2 , N3 , A2 ) ")) (IF (< Ag23 180.0) (SETQ ANG2  Ag23)  (SETQ ANG2 (- Ag23 360.0 )))) ; c1
					
					((AND (EQUAL N1 N2 mUNI) (NOT (EQUAL N2 N3 mUNI)))                  (SETQ ANG1  0.0 )
						(SETQ Ag23 (CAL " ANG( A1 , N2 , N3 , A2 ) ")) (IF (< Ag23 180.0) (SETQ ANG2  Ag23)  (SETQ ANG2 (- Ag23 360.0 )))) ; c2
					
					((AND (EQUAL N2 N3 mUNI) (NOT (EQUAL N1 N2 mUNI)))                  (SETQ ANG2  0.0 )
						(SETQ Ag12 (CAL " ANG( A1 , N1 , N2 , A2 ) ")) (IF (< Ag12 180.0) (SETQ ANG1  Ag12)  (SETQ ANG1 (- Ag12 360.0 )))) ; c3
					
					((AND (EQUAL N1 N2 mUNI) (EQUAL N2 N3 mUNI))                        (SETQ ANG1 0.0 )  (SETQ ANG2 0.0 )             ) ; c4

					(  T  (PROMPT "  NO CUMPLE COMDICION (N1 N2 N3)  NB = ") (PRIN1 NB ) (TERPRI)                          ) ; c5
				) ; con
	

				; PUNTOS de TANGENCIA a  CIRCULO(B1 B2 B3) de haz PLANOS-(A1 A2) ENTRE(B1 B3)  					(T1x T2x)															

				(COND
					((AND (= ANG1 0.0) (/= ANG2 0.0))
						(SETQ DISx1 (+ 1 N4B ))
						(IF (AND (= MARCA-40A  T ) (>= DISx1  DISx2 ))
							(PROGN
								;(COMMAND "COLOR" COLO1  "LINEA" A1  B1 "" )
								(SETQ LIS-PUN-PLANOS-ARR (CONS (LIST A1 A2 B1 )  LIS-PUN-PLANOS-ARR ))
								(SETQ DISx2  DISx1 )
								(SETQ MARCA-40A  nil )
							) ; pro
						) ; if
					) ; c-A

					((AND (/= ANG1 0.0) (= ANG2 0.0))
						(SETQ DISx1 (+ 2 N4B ))
						(IF (AND (= MARCA-40A  T ) (>= DISx1  DISx2 ))
							(PROGN
								;(COMMAND "COLOR" COLO1  "LINEA" A1  B2 "" )
								(SETQ LIS-PUN-PLANOS-ARR (CONS (LIST A1 A2 B2 )  LIS-PUN-PLANOS-ARR ))
								(SETQ DISx2  DISx1 )
								(SETQ MARCA-40A  nil )
							) ; pro
						) ; if
					) ; c-B

					((AND (= ANG1 0.0) (= ANG2 0.0))
						(SETQ DISx1 (+ 2 N4B ))
						(IF (AND (= MARCA-40A  T ) (>= DISx1  DISx2 ))
							(PROGN
								;(COMMAND "COLOR" COLO1  "LINEA" A1  B2 "" )
								(SETQ LIS-PUN-PLANOS-ARR (CONS (LIST A1 A2 B2 )  LIS-PUN-PLANOS-ARR ))
								(SETQ DISx2  DISx1 )
								(SETQ MARCA-40A  nil )
							) ; pro
						) ; if
					) ; c-C

					((OR (AND (> ANG1 0.0) (< ANG2 0.0))	(AND (< ANG1 0.0) (> ANG2 0.0)))
						(SETQ Pg1 (LIST (+ 1 N4B ) ANG1 ))
						(SETQ Pg2 (LIST (+ 2 N4B ) ANG2 ))
						(SETQ DISx1 (CAL " RXOF(PLT( Pg1 , Pg2 , ABS(ANG1)/(ABS(ANG1)+ABS(ANG2)))) "))  ; (+ 0.0 (/ 0.0 0.0))

						(COND
							((AND (= MARCA-40A  T ) (>= DISx1  DISx2 ))
								; PUNTOS TANG-CIRCULO(B1 B2 B3) desde PLANO-(A1 A2) ENTRE(B1 B3)  					(T1x T2x)																
							 	(SETQ B12 (CAL " PLT( B1 , B2 , 0.5 ) "))
								(SETQ B23 (CAL " PLT( B2 , B3 , 0.5 ) "))
								(SETQ NBo (CAL " NOR( B1 , B2 , B3       ) "))
								(SETQ NR1 (CAL " NOR( B1 , B2 , B1 + NBo ) "))
								(SETQ NR2 (CAL " NOR( B2 , B3 , B2 + NBo ) "))

								(SETQ CTR (CAL " ILL( B12 , B12 + NR1 ,  B23 , B23 + NR2 ) "))										; CENTRO  CIRCULO B1 B2 B3 
								(SETQ ECE (CAL " CTR + NBo "))																										; PUN EJE CIRCULO-123 
								(SETQ A1b (CAL " ILP( A1 , A1 + NBo ,  B1 , B2 , B3 ) "))													; PROYECCION de A Sobre PLANO-B 
								(SETQ A2b (CAL " ILP( A2 , A2 + NBo ,  B1 , B2 , B3 ) "))

								(SETQ CH0 (CAL " ILL( A1 , A2 ,  A1b , A2b ) "))																	; PUN PLA-TAG en CHARNELA 
								(SETQ V1c (CAL " VEC1( CTR , CH0 ) "))																						; VEC-uni  CENTRO-B -> P-CHARNELA 

								(SETQ RA  (DISTANCE CTR  B2  ))
								(SETQ IPO (DISTANCE CTR  CH0 ))

 								(IF (NOT (> RA  IPO ))
									(PROGN
										(SETQ AgTA (CAL " 90.0 - ASIN( RA / IPO ) "))																	; asin(-1..+1) 
										(SETQ AgTB (- 360.0 AgTA ))

										(SETQ AgB1 (CAL " ANG( CTR , CH0 , B1 , ECE ) "))															; ANG( V0, p1, p2, V1)
										(SETQ AgB3 (CAL " ANG( CTR , CH0 , B3 , ECE ) "))

										(COND
											((OR (AND (< AgB1 AgTA) (< AgTA AgB3)) (AND (> AgB1 AgTA) (> AgTA AgB3)))		; AgB1 < AgTA < AgB3 
												(SETQ T1x (CAL " ROT( CTR + (RA * V1c) , CTR , ECE , AgTA ) "))						; AgB1 > AgTA > AgB3 
												;(COMMAND "COLOR" COLO1  "LINEA" A1  T1x "" )
												(SETQ LIS-PUN-PLANOS-ARR (CONS (LIST A1 A2 T1x )  LIS-PUN-PLANOS-ARR ))									; ROT( p, V0, V1, ng )

												(SETQ DISx2  DISx1 )
												(SETQ MARCA-40A  nil )
											) ; c1

											((OR (AND (< AgB1 AgTB) (< AgTB AgB3)) (AND (> AgB1 AgTB) (> AgTB AgB3)))		; AgB1 < AgTB < AgB3 
												(SETQ T2x (CAL " ROT( CTR + (RA * V1c) , CTR , ECE , AgTB ) "))						; AgB1 > AgTB > AgB3 
												;(COMMAND "COLOR" COLO1  "LINEA" A1  T2x "" )
												(SETQ LIS-PUN-PLANOS-ARR (CONS (LIST A1 A2 T2x )  LIS-PUN-PLANOS-ARR ))

												(SETQ DISx2  DISx1 )
												(SETQ MARCA-40A  nil )
											) ; c2

											(  T
												(PROMPT "  NO PINTO LINEA-Ag en N4B = ") (PRIN1 N4B ) (TERPRI)
											) ; c3
										) ; con
									) ; pro

									(PROGN
										(PROMPT " ????????????????????????????????????????????????????????????????????????????") (TERPRI)
										(PROMPT "  EL RADIO ES MAYOR QUE LA HIPOTENUSA ") (TERPRI)
									) ; pro
								) ; if

							) ; c2 AND
						) ; con2 AND

					) ; c-D
				) ; con1 OR

			) ; repe N4B repe
		) ; repe N40A

		(SETQ LIS-PUN-PLANOS-ARR (REVERSE LIS-PUN-PLANOS-ARR ))																; (LENGTH LIS-PUN-PLANOS-ARR )    20 
		(SETQ LIS-LIS-PUN-PLANOS-ARR (CONS LIS-PUN-PLANOS-ARR  LIS-LIS-PUN-PLANOS-ARR ))

	) ; repe N400AB 

	(SETQ LIS-LIS-PUN-PLANOS-ARR (REVERSE LIS-LIS-PUN-PLANOS-ARR ))													; (LENGTH LIS-LIS-PUN-PLANOS-ARR ) 4 

	)) ; IF "08T" - - - - - - - - - - - - - - - - - - - - - - - - - - -  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	;-----------------------------------------------------------------------------------------------------------------------------------


	;-----------------------------------------------------------------------------------------------------------------------------------
	;	(08) INTERSECCION de PLANOS																								 																												
	(IF nil (PROGN  ; - - - - - - - - - - - - - - - - - - - - - - - - -  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	(SETQ LIS-LIS-PUN-INTER-PLANOS-ARR nil )

	(SETQ N50 -1 )
	(REPEAT  (LENGTH LIS-LIS-PUN-PLANOS-ARR )																						; (LENGTH LIS-LIS-PUN-PLANOS-ARR )  4 
		(SETQ N50 (+ N50  1 ))

		(SETQ LIS-PUN-PLANOS-ARR (NTH N50  LIS-LIS-PUN-PLANOS-ARR ))											; (LENGTH LIS-PUN-PLANOS-ARR )     20 

		(SETQ LIS-PUN-INTER-PLANOS-ARR nil )

		(SETQ N5 -1 )
		(REPEAT  (- (LENGTH LIS-PUN-PLANOS-ARR ) 1 )
			(SETQ N5 (+ N5  1 ))

			(SETQ PLA-A (NTH (+ N5 0 ) LIS-PUN-PLANOS-ARR ))			; (LIST A1 A2 B2 )
			(SETQ PLA-B (NTH (+ N5 1 ) LIS-PUN-PLANOS-ARR ))

			(SETQ A1a (NTH 0 PLA-A ))
			(SETQ A2a (NTH 1 PLA-A ))
			(SETQ B2a (NTH 2 PLA-A ))

			(SETQ A1b (NTH 0 PLA-B ))
			(SETQ A2b (NTH 1 PLA-B ))
			(SETQ B2b (NTH 2 PLA-B ))

			(IF (EQUAL B2a B2b  mUNI )
				(PROGN
					;(COMMAND "COLOR" 255  "LINEA" A2a  B2a "" )

					(SETQ LIS-PUN-INTER-PLANOS-ARR (CONS (LIST A2a  B2a )  LIS-PUN-INTER-PLANOS-ARR ))
				) ; pro

				(PROGN
					(SETQ NB2b (CAL " B2b + NOR( A1a , A2a , B2a ) "))
					(SETQ INB2 (CAL " ILP( B2b , NB2b , A1a , A2a , B2a ) "))										; ilp(p1,p2,p3,p4,p5)

					(SETQ CH2 (CAL " ILP( B2a , INB2 , A1b , A2b , B2b ) "))
					(SETQ CH1  A2a )

					;(COMMAND "COLOR" 255  "LINEA" CH1  CH2 "" )

					(SETQ LIS-PUN-INTER-PLANOS-ARR (CONS (LIST CH1  CH2 )  LIS-PUN-INTER-PLANOS-ARR ))
				) ; pro
			) ; if
		) ; repe N5 

		(SETQ LIS-PUN-INTER-PLANOS-ARR (REVERSE LIS-PUN-INTER-PLANOS-ARR ))								; (LENGTH LIS-PUN-INTER-PLANOS-ARR ) 19 
		(SETQ LIS-LIS-PUN-INTER-PLANOS-ARR (CONS LIS-PUN-INTER-PLANOS-ARR  LIS-LIS-PUN-INTER-PLANOS-ARR ))

	) ; repe N50 

	(SETQ LIS-LIS-PUN-INTER-PLANOS-ARR (REVERSE LIS-LIS-PUN-INTER-PLANOS-ARR ))				; (LENGTH LIS-LIS-PUN-INTER-PLANOS-ARR ) 4 

	)) ; IF "08 T" - - - - - - - - - - - - - - - - - - - - - - - - - - -  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	;-----------------------------------------------------------------------------------------------------------------------------------


	;-----------------------------------------------------------------------------------------------------------------------------------
	;	(09)   PINTA "3DC-PLANAS" 3D 2D	PATRONES ## ARRIBA ##																																							
	(IF nil (PROGN  ; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

	(SETQ N60 -1 )
	(REPEAT  (LENGTH LIS-LIS-PUN-INTER-PLANOS-ARR )																			; (LENGTH LIS-LIS-PUN-INTER-PLANOS-ARR ) 4 
		(SETQ N60 (+ N60  1 ))

		(SETQ LIS-PUN-INTER-PLANOS-ARR (NTH N60  LIS-LIS-PUN-INTER-PLANOS-ARR ))

		(SETQ K1Arr (LIST (* 40 (+ (/ N60 2.0) 1)) 0 0 ))
		(SETQ K2Arr (LIST (* 41 (+ (/ N60 2.0) 1)) 0 0 ))

		(SETQ N6 -1 )
		(REPEAT (- (LENGTH LIS-PUN-INTER-PLANOS-ARR ) 1 )																	; (LENGTH LIS-PUN-INTER-PLANOS-ARR ) 19 
			(SETQ N6  (+ N6  1 ))
			(SETQ LIS-PUN-INTER-A1 (NTH (+ N6 0 ) LIS-PUN-INTER-PLANOS-ARR ))							; (LENGTH LIS-PUN-INTER-A1 ) 2 
			(SETQ LIS-PUN-INTER-A2 (NTH (+ N6 1 ) LIS-PUN-INTER-PLANOS-ARR ))							; (LENGTH LIS-PUN-INTER-A2 ) 2 

			(SETQ IA1 (NTH 0 LIS-PUN-INTER-A1 ))
			(SETQ IA2 (NTH 1 LIS-PUN-INTER-A1 ))

			(SETQ IB1 (NTH 0 LIS-PUN-INTER-A2 ))
			(SETQ IB2 (NTH 1 LIS-PUN-INTER-A2 ))

			(COMMAND "COLOR" 2  "3DCARA" IA1  IA2  IB2  IB1 "" )			; 3D

			; PATRONES-2D    "3DC PLANAS"   ARRIBA															

			(COMMAND "SCP" "3P" IA2 IA1 IB2 )   ; IA1 = IA2 ? 
				(SETQ IA1p (TRANS IA1 0 1 ))
				(SETQ IA2p (TRANS IA2 0 1 ))
				(SETQ IB2p (TRANS IB2 0 1 ))
				(SETQ IB1p (TRANS IB1 0 1 ))
				(COMMAND "COLOR" 5  "TEXTO" (LIST 0.0 0.0 ) 0.08 0 (STRCAT "<R" (ITOA (+ N60 1 )) "/" (ITOA (+ N6 1 ))))			; 3D 
			(COMMAND "SCP" "U")

			(COMMAND "SCP" "3P" K1Arr K2Arr "" )
				(COMMAND "COLOR" 2  "3DCARA" IA1p  IA2p  IB2p  IB1p "" )			; 2D 
				(COMMAND "COLOR" 5  "TEXTO" (LIST 0.0 0.0 ) 0.08 0 (STRCAT "<R" (ITOA (+ N60 1 )) "/" (ITOA (+ N6 1 ))))			; 2D 

				(SETQ K1Arr (TRANS IB2p  1 0 ))
				(SETQ K2Arr (TRANS IB1p  1 0 ))
			(COMMAND "SCP" "U")

  	) ; repe N6
 	) ; repe N60

	)) ; IF "09 T" - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	;-----------------------------------------------------------------------------------------------------------------------------------



	;-----------------------------------------------------------------------------------------------------------------------------------
	;	(30) PARANDO																																																											
	(SETVAR "blipmode" 1)  (SETVAR "cmdecho"  1)

	(PROMPT " ============================================================================") (TERPRI)
	(PROMPT " >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> FINAL >>>>>>>>> BOTELLA-de-KLEIN-06 >>>>>>>>") (TERPRI)
	(PROMPT " ============================================================================") (TERPRI)

) ; cierre DEFUN    BOTELLA-de-KLEIN-06 

;-------------------------------------------------------------------------------------------------------------------------------------
;"###################################################################################################################################"
