

;--------------------------------------------------------------------------------------------------------------------------------
;																																											
;	( ESPIRAL-PERFIL-03 )	 de  ESPIRAL-PERFIL-02			SPLINE-CAMINO ESPIRAL de RADIOS PERFIL						13/03/2007			
;																																											
;--------------------------------------------------------------------------------------------------------------------------------
;	PUNTOS CANICO de la ESPIRAL               X = (* KK/R RA/n+0 (COS (* NRA AG/ud)))                                            
;	                                          Y = (* KK/R RA/n+0 (SIN (* NRA AG/ud)))                                            
;	FUNCION de los RADIOS de las ESFERAS      Z = (+ (* AL/ud  KK/V)  P0z1 )      AL/ud = (/ (+ RA/n+0  RA/n-V) NPvu# )          
;--------------------------------------------------------------------------------------------------------------------------------
;	SUBPROGRAMAS                                                                                                                  
;						(PUNTOS-DIVIDE)                  N-ELE + NDIDI                       =>  LIS-PUNTOS 	                        
;						(LISTA-RADIOS-PERFIL)            LIS-Pun-EJE + LIS-Pun-REF + "TEXTO"  =>  LIS-RADIOS 	                        
;						(LISTA-Pun-INICIO)               LIS-Pun-CAMI + LIS-RADIOS + NLados  =>  LIS-P-INI                            
;						(INTER-PLANO-RECTA)              Pp1 + Pp2 + Pp3 + Pr1 + Pr2          =>  PunINI                               
;						(CALCULA-ELIPSE-INTERSECCION)    LIS-Pun-CAMI + LIS-RADIOS            =>  LIS-ELIP-SCP-VERT                    
;						(PINTA-ELIPSES)                  LIS-ELIP-SCP-VERT                    =>  "ELIPSE" + "SUPREGLA"                
;						(PINTA-3DCARAS)                  LIS-P-INI + LIS-ELIP-SCP-VERT        =>  LIS-LIS-P-VER + "3DCARA"					
;						(PINTA-PATRONES-3DC)  																														
;						(PINTA-ESFERAS)                  LIS-Pun-CAMI + LIS-RADIOS            =>  "_SPHERE" + Seccion X-Z              
;--------------------------------------------------------------------------------------------------------------------------------
;	PROGRAMAS                                                                                                                     
;						FIJA VARIABLES EN EL PROGRAMA    NLados  NPvu#  NVUE#  KK/R  KK/V                                           
;						FIJA SUBPROGRAMA A EJECUTAR		ESFERAS   ELIPSES   3DCARAS      PATRONES                                		
;						LISTAS PUNTOS                    LIS-Pun-REF  LIS-Pun-EJE  ## CON SPLINES ##                                   
;						RADIOS CIRCULOS ESFERAS          LIS-RADIOS                                                                    
;						LISTA PUNTOS CAMINO (ESPIRAL)    LIS-Pun-CAMI                                                                  
;						SUBPROGRAMA EJECUTA		         ESFERAS   ELIPSES   3DCARAS   PATRONES                                   		
;--------------------------------------------------------------------------------------------------------------------------------




;--------------------------------------------------------------------------------------------------------------------------------
;	(PUNTOS-DIVIDE) = PUNTEA SPLINE a NDIVISIONES ( N-ELE ) + ( NDIDI ) => ( LIS-PUNTOS )													
;--------------------------------------------------------------------------------------------------------------------------------

(DEFUN PUNTOS-DIVIDE (/  )

	(SETQ LIS-PUNTOS  nil)

	(SETQ  Elen (MEMBER (ASSOC 10 (ENTGET N-ELE)) (ENTGET N-ELE))							; lista a partir del elemento (incluido)
		    P-1    (CDR (NTH      0              Elen))										; primer elemento
		    P-Uo    (CDR (NTH (- (LENGTH Elen) 1) Elen)) )										; ultimo elemento

	(COMMAND  "COLOR" 1 "PUNTO"  P-1)																; PINTA Primer Punto (en Base de Datos)
 	(SETQ  N-1P (ENTLAST))																				; Nombre ultima entidad principal = 1 punto
	(COMMAND	 "COLOR" 7 "DIVIDE" N-ELE NDIDI														; PINTA Punto Divide (en Base de Datos)
			    "COLOR" 5 "PUNTO"  P-Uo        )													; PINTA Ultimo Punto (en Base de Datos)

	;	PUNTOS SECCION X (PX1-PXn) =>  LIS-PUNTOS																												

	(SETQ N-P1         nil
		   N-P2         nil
		   N-P2         N-1P
		   LIS-PUNTOS   nil
		   LIS-PUNTOS  (LIST (CDR (ASSOC 10 (ENTGET N-1P))))									; LIS-PUNTOS => 1 punto
		   WW           T )

	(WHILE WW
	  	(SETQ N-P1 (ENTNEXT N-1P))																	; nombre entidad siguiente
				
		(IF (= N-P1 nil)	(SETQ WW nil)
			(PROGN
				(SETQ LIS-PUNTOS (CONS (CDR (ASSOC 10 (ENTGET N-P1))) LIS-PUNTOS))		; LIS-PUNTOS => Resto PUNTOS con ULTIMO
				(SETQ  N-1P N-P1 )
				(ENTDEL N-P1)																	; BORRA PUNTO
			) ; pro
		) ; if 
	) ; whi
	(SETQ LIS-PUNTOS (REVERSE LIS-PUNTOS))
	(ENTDEL N-P2)																				; BORRA PUNTO

) ;  DEFUN   PUNTOS-DIVIDE 

;--------------------------------------------------------------------------------------------------------------------------------


;--------------------------------------------------------------------------------------------------------------------------------
;			CALCULA >>> PERFIL RADIOS ( RADI ) 								SPLINE-REF ----- DIVIDIR NDiv*6 => LIS-Pun-REF => P1Ref P2Ref	
;							CIRCULOS a TANGENTES por SPLINE      			SPLINE-EJE ----- DIVIDIR NDiv*1 => LIS-Pun-EJE => P-EJE			
;--------------------------------------------------------------------------------------------------------------------------------

(DEFUN LISTA-RADIOS-PERFIL (/  )      ; # # # # #  LINEA-PERFIL  y  LINEA-REF => SPLINES  # # # # #

  	(SETQ LIS-RADIOS nil)
	(SETQ NEje -1)
	(SETQ NRef -1)

	(SETQ NIZQ  0)
	(SETQ NDER  0)
	(SETQ NINT  0)

	(REPEAT (LENGTH LIS-Pun-EJE)
		(SETQ NEje (+ NEje 1))

				(SETQ P-EJE (NTH NEje LIS-Pun-EJE))  (SETQ P-EJEx (CAR P-EJE) P-EJEy (CADR P-EJE))

				(SETQ HT  1.5 )																								; ALTURA TEXTO 
				(IF (= NEje 0)
					(COMMAND
						"COLOR" 7
						"TEXTO" (LIST (+ P-EJEx        0 ) (- P-EJEy (* HT  2))) HT 0.0 "ESPIRAL-PERFIL-03"	; NOMBRE PROGRAMA 
						"TEXTO" (LIST (+ P-EJEx        0 ) (- P-EJEy (* HT  4))) HT 0.0 "NPvu# = "
						"TEXTO" (LIST (+ P-EJEx (* HT  9)) (- P-EJEy (* HT  4))) HT 0.0  NPvu#				; PUNTOS por VUELTA ESPIRAL 
						"TEXTO" (LIST (+ P-EJEx        0 ) (- P-EJEy (* HT  6))) HT 0.0 "NVUE# = "
						"TEXTO" (LIST (+ P-EJEx (* HT  9)) (- P-EJEy (* HT  6))) HT 0.0  NVUE#				; VUELTAS DATOS del ESPIRAL 
						"TEXTO" (LIST (+ P-EJEx        0 ) (- P-EJEy (* HT  8))) HT 0.0 "KK/R   = "
						"TEXTO" (LIST (+ P-EJEx (* HT  9)) (- P-EJEy (* HT  8))) HT 0.0  KK/R				; FACTOR ESCALA RADIAL 
						"TEXTO" (LIST (+ P-EJEx        0 ) (- P-EJEy (* HT 10))) HT 0.0 "KK/V   = "
						"TEXTO" (LIST (+ P-EJEx (* HT  9)) (- P-EJEy (* HT 10))) HT 0.0  KK/V				; FACTOR ESCALA VERTICAL 
					) ; comm
				) ; if

				(SETQ WW T)
				(WHILE WW
					(SETQ NRef (+ NRef 1))

					(SETQ P1Ref (NTH (+ NRef 0) LIS-Pun-REF))  (SETQ P1Refx (CAR P1Ref) P1Refy (CADR P1Ref))  ; (LENGTH LIS-Pun-REF)
					(SETQ P2Ref (NTH (+ NRef 1) LIS-Pun-REF))  (SETQ P2Refx (CAR P2Ref) P2Refy (CADR P2Ref))

					(COND
						( (EQUAL P1Refx P-EJEx 0.00001)
                                  (SETQ R-REF (- P1Refy P-EJEy))
                                  (SETQ LIS-RADIOS (CONS R-REF LIS-RADIOS))
                                  (SETQ WW nil)
                                  (COMMAND "COLOR" 1 "LINEA" P-EJE (LIST P-EJEx (+ P-EJEy R-REF)) "")  (SETQ NIZQ (+ NIZQ 1))
                                   ;(TERPRI) (PROMPT " ------ CUMPLE PUNTO-IZQUIERDA    NRef = ")
						                 ;(PRIN1 NRef) (PROMPT " - ") (PRIN1 (+ NRef 1))
						)
						( (EQUAL P2Refx P-EJEx 0.00001)
                                  (SETQ R-REF (- P2Refy P-EJEy))
                                  (SETQ LIS-RADIOS (CONS R-REF LIS-RADIOS))
                                  (SETQ WW nil)
                                  (COMMAND "COLOR" 5 "LINEA" P-EJE (LIST P-EJEx (+ P-EJEy R-REF)) "")  (SETQ NDER (+ NDER 1))
                                  ;(TERPRI) (PROMPT " ------ CUMPLE PUNTO-DERECHA      NRef = ")
						                ;(PRIN1 NRef) (PROMPT " - ") (PRIN1 (+ NRef 1))
						)
						( (AND (< P1Refx P-EJEx) (< P-EJEx P2Refx))
						                (SETQ R-REF (/ (+ (* (- P1Refy P-EJEy) (- P2Refx P-EJEx))
																	 (* (- P2Refy P-EJEy) (- P-EJEx P1Refx))) (- P2Refx P1Refx)))
									       (SETQ LIS-RADIOS (CONS R-REF LIS-RADIOS))
									       (SETQ WW nil)
									       (COMMAND "COLOR" 8 "LINEA" P-EJE (LIST P-EJEx (+ P-EJEy R-REF)) "")  (SETQ NINT (+ NINT 1))
                                  ;(TERPRI) (PROMPT " ------ CUMPLE PUNTO-INTERMEDIO   NRef = ")
						                ;(PRIN1 NRef) (PROMPT " - ") (PRIN1 (+ NRef 1))
						)
						;(       T       (TERPRI) (PROMPT " >>>>>>> NO CUMPLE CONDICION (LIS-RADIOS) NRef = ") (PRIN1 NRef) )
					) ; cond

					(IF (>= NRef (- (LENGTH LIS-Pun-REF) 2)) (SETQ WW nil))

				) ; Whi NRef
	) ; repe NEje

	(SETQ LIS-RADIOS (REVERSE LIS-RADIOS))																			; (LENGTH LIS-RADIOS)

	(TERPRI) (PROMPT " ------ (PRIMERO) N PUNTOS IZQUIERDA   =   ") (PRIN1 NIZQ)
	(TERPRI) (PROMPT " ------           N PUNTOS INTERMEDIOS = "  ) (PRIN1 NINT)
	(TERPRI) (PROMPT " ------ (ULTIMO)  N PUNTOS DERECHA     =   ") (PRIN1 NDER)

) ;  DEFUN   LISTA-RADIOS-PERFIL 

;--------------------------------------------------------------------------------------------------------------------------------


;--------------------------------------------------------------------------------------------------------------------------------
;	SECCION de INICIO: POLIGONO REGULAR  	(PUNTOS DIVIDE NLados (CIRCULO 1 RADIO)   EJE Z (1 P1 P2))									
;--------------------------------------------------------------------------------------------------------------------------------


(DEFUN LISTA-Pun-INICIO (/  )

	(SETQ P1i (NTH 0 LIS-Pun-CAMI))
	(SETQ P2i (NTH 1 LIS-Pun-CAMI))
	(SETQ Rci (NTH 0 LIS-RADIOS  ))											; RADIO INICIO CIRCULO 
	(SETQ Rpi (/ (* Rci PI) (* NLados (SIN (/ PI NLados)))))		; RADIO INICIO POLIGONO-SECCION ( IGUAL PERIMETRO ? )

	;(COMMAND  "COLOR" 255 "LINEA"  P1i P2i "")

 	(COMMAND "SCP" "EZ" P1i P2i )									; SISTEMA-I 

		(COMMAND  "COLOR" 255 "CIRCULO"  '(0 0 0) Rpi )		; CIRCULO BASE INICIO
 		(SETQ  N-CIR-B (ENTLAST))
		(COMMAND	 "COLOR" 2 "DIVIDE" N-CIR-B  NLados )		; PINTA Punto Divide

		(SETQ LIS-P-INI nil )
		(SETQ N-PC1     nil )
		(SETQ N-PC2     nil )

		(SETQ N-PC2   N-CIR-B )

		(SETQ WW T )
		(WHILE WW
	  		(SETQ N-PC1 (ENTNEXT N-PC2))							; nombre entidad siguiente
				
			(IF (= N-PC1 nil)	(SETQ WW nil)
				(PROGN
					(SETQ LIS-P-INI (CONS (CDR (ASSOC 10 (ENTGET N-PC1))) LIS-P-INI))
					(SETQ  N-PC2 N-PC1 )

					(ENTDEL N-PC1)										; BORRA PUNTO
				) ; pro
			) ; if 
		) ; whi

		(SETQ LIS-P-INI (REVERSE LIS-P-INI))

		;(ENTDEL N-CIR-B)												; BORRA CIRCULO

	(COMMAND "SCP" "U")

) ;  DEFUN   LISTA-Pun-INICIO 

;--------------------------------------------------------------------------------------------------------------------------------


;--------------------------------------------------------------------------------------------------------------------------------
;	PUNTO INTERSECCION ENTRE PLANO (Pp1 Pp2 Pp3) y RECTA (Pr1 Pr2) => PunINI																		
;--------------------------------------------------------------------------------------------------------------------------------

(DEFUN INTER-PLANO-RECTA ( / )

	;	PLANO =>   P1-(P1x P1y P1z)   P2-(P2x P2y P2z)   P3-(P3x P3y P3z)																				
	(SETQ P1x (CAR Pp1)  P1y (CADR Pp1)  P1z (CADDR Pp1))
	(SETQ P2x (CAR Pp2)  P2y (CADR Pp2)  P2z (CADDR Pp2))
	(SETQ P3x (CAR Pp3)  P3y (CADR Pp3)  P3z (CADDR Pp3))

	;	RECTA =>   R1-(R1x R1y R1z)   R2-(R2x R2y R2z)																										
	(SETQ R1x (CAR Pr1)  R1y (CADR Pr1)  R1z (CADDR Pr1))
	(SETQ R2x (CAR Pr2)  R2y (CADR Pr2)  R2z (CADDR Pr2))

	(SETQ Qx (- (* (- P2z P1z) (- P3y P1y)) (* (- P2y P1y) (- P3z P1z))) )
  	(SETQ Qy (- (* (- P2x P1x) (- P3z P1z)) (* (- P2z P1z) (- P3x P1x))) )
	(SETQ Qz (- (* (- P2y P1y) (- P3x P1x)) (* (- P2x P1x) (- P3y P1y))) )		
  	(SETQ Mp (+ (* P1x Qx) (* P1y Qy) (* P1z Qz)) )													
	(SETQ m1 (- R2y R1y))      (SETQ n1 (- R1x R2x))      (SETQ k1  (- (+ (* R1y R1x) (* R2x R1y)) (* R1x R1y) (* R2y R1x)))
	(SETQ m2 (- R2z R1z))      (SETQ n2 (- R1x R2x))      (SETQ k2  (- (+ (* R1z R1x) (* R2x R1z)) (* R1x R1z) (* R2z R1x)))

  	; INTERSECCION  RECTA-PLANO    																																

	(SETQ VALx (/ (+ (/ (* k1 (/ Qy Qz)) n1) (/ (* Mp (/ Qy Qz)) Qy) (/ k2 n2))
					  (- (/ (* Qx (/ Qy Qz)) Qy) (/ m2 n2) (/ (* m1 (/ Qy Qz)) n1))))				
	(SETQ VALy (+ (- (/ (* m1 VALx) n1)) (- (/ k1 n1))))            													
	(SETQ VALz (/ (+ (- (* m2 VALx)) (- k2)) n2))														

	(SETQ PunINI (LIST VALx VALy VALz))

	;(COMMAND "COLOR" 2  "PUNTO"  PunINI )

) ;cierre DEFUN   INTER-PLANO-RECTA

;--------------------------------------------------------------------------------------------------------------------------------


;--------------------------------------------------------------------------------------------------------------------------------
;	(CALCULA-ELIPSE-INTERSECCION)  PUNTOS ELIPSE INTERSECCION CONOS INCRITOS EN 3 ESFERAS														
;--------------------------------------------------------------------------------------------------------------------------------

(DEFUN CALCULA-ELIPSE-INTERSECCION (/  )

	;	PUNTOS INTERSECCION DE LAS TANGENTES A (CIRCULO(P1 R1) CIRCULO(P2 R2)) Y (CIRCULO(P2 R2) CIRCULO(P3 R3))							

	(SETQ LIS-ELIP-SCP-VERT nil )

	(SETQ N1 -1 )
	(REPEAT  (- (LENGTH LIS-Pun-CAMI) 2)
		(SETQ N1 (+ N1 1))
		(SETQ P1 (NTH (+ N1 0) LIS-Pun-CAMI))									; (LENGTH LIS-Pun-CAMI)
		(SETQ P2 (NTH (+ N1 1) LIS-Pun-CAMI))
		(SETQ P3 (NTH (+ N1 2) LIS-Pun-CAMI))
		(SETQ R1 (NTH (+ N1 0) LIS-RADIOS))									; (LENGTH LIS-RADIOS)
		(SETQ R2 (NTH (+ N1 1) LIS-RADIOS))
		(SETQ R3 (NTH (+ N1 2) LIS-RADIOS))

		(SETQ DisP12 (DISTANCE P1 P2))
		(SETQ DisP23 (DISTANCE P2 P3))

		(IF (< DisP12 (ABS (- R1 R2))) (PROGN (TERPRI) (PROMPT " >>>>  DisP12<R1-R2   RAIZ(-)  N1 = ") (PRIN1 N1) (TERPRI)))
		(IF (< DisP23 (ABS (- R2 R3))) (PROGN (TERPRI) (PROMPT " >>>>  DisP23<R2-R3   RAIZ(-)  N1 = ") (PRIN1 N1) (TERPRI)))

 		(COMMAND "SCP" "3P" P2 P3 P1)									; SISTEMA-B 
			(SETQ  DisP02 (* (/ R2 (- R2 R3)) DisP23))
			(SETQ  DisT02 (SQRT (- (EXPT (ABS DisP02) 2) (EXPT R2 2))))	; RAIZ NEGATIVA  ?? 

			(IF (< DisP02 0.0) (SETQ DisT02 (- DisT02)))

			(SETQ  TA2x (* R2     (/ R2 DisP02)))
			(SETQ  TA2y (* DisT02 (/ R2 DisP02)))

			(SETQ  TA2b (LIST TA2x    TA2y  0.0))
			(SETQ  TB2b (LIST TA2x (- TA2y) 0.0))
			(SETQ  P02b (LIST DisP02  0.0   0.0))

			(SETQ  TA2u (TRANS TA2b 1 0))
			(SETQ  TB2u (TRANS TB2b 1 0))
			(SETQ  P02u (TRANS P02b 1 0))
		(COMMAND "SCP" "U")

 		(COMMAND "SCP" "3P" P1 P2 P3)									; SISTEMA-A 
			(SETQ  DisP01 (* (/ R1 (- R1 R2)) DisP12))
			(SETQ  DisT01 (SQRT (- (EXPT (ABS DisP01) 2) (EXPT R1 2))))	; RAIZ NEGATIVA  ?? 

			(IF (< DisP01 0.0) (SETQ DisT01 (- DisT01)))
			(SETQ  TA1x (* R1     (/ R1 DisP01)))
			(SETQ  TA1y (* DisT01 (/ R1 DisP01)))

			(SETQ  TA1a (LIST TA1x    TA1y  0.0))
			(SETQ  TB1a (LIST TA1x (- TA1y) 0.0))
			(SETQ  P01a (LIST DisP01  0.0   0.0))								; VERTICE CONO-1  SCPa

			(SETQ  TA2a (TRANS TA2u 0 1))
			(SETQ  TB2a (TRANS TB2u 0 1))
			(SETQ  P02a (TRANS P02u 0 1))											; VERTICE CONO-2  SCPa

			(SETQ INT-Aa (INTERS TA1a P01a  TA2a P02a nil))				; INTERSECCION TANGENTES CIRCULOS ARR 
			(SETQ INT-Ba (INTERS TB1a P01a  TB2a P02a nil))				; INTERSECCION TANGENTES CIRCULOS ABA 

			(IF (OR (= INT-Aa nil) (= INT-Ba nil))
				(PROGN (TERPRI) (PROMPT " >>> INTER-A o INTER-B = nil   N1 = ") (PRIN1 N1))
				(PROGN


					(SETQ INT-AB-0a (LIST (+ (CAR  INT-Aa) (/ (- (CAR  INT-Ba) (CAR  INT-Aa)) 2))				; PUNTO MEDIO  Z = 0 
											    (+ (CADR INT-Aa) (/ (- (CADR INT-Ba) (CADR INT-Aa)) 2))  0.0 ))

					(SETQ DD (DISTANCE (TRANS P2 0 1) INT-AB-0a ))

					(SETQ INT-AB-Za (LIST (CAR  INT-AB-0a                  )											; PUNTO MEDIO  Z = H 
											    (CADR INT-AB-0a                  )
												 (SQRT (- (EXPT R2 2) (EXPT DD 2)))))


					(SETQ  EmaxAu (TRANS INT-Aa    1 0))				; EmaxAu  P EJE MALLOR  ELIPSE INTERSECCION CONOS 
					(SETQ  EmaxBu (TRANS INT-Ba    1 0))				; EmaxBu  P EJE MALLOR  ELIPSE INTERSECCION CONOS 

					(SETQ  EcenOu (TRANS INT-AB-0a 1 0))				; EcenOu  P CENTRO      ELIPSE INTERSECCION CONOS 
					(SETQ  EminAu (TRANS INT-AB-Za 1 0))				; EminAu  P EJE MENOR   ELIPSE INTERSECCION CONOS 

					(SETQ  VerCOu      (TRANS P01a      1 0))			; VERTICE  CONO-1  SCPu          (LENGTH LIS-ELIP-SCP-VERT) 

					(SETQ LIS-ELIP-SCP-VERT (CONS  (LIST EmaxAu EmaxBu   EcenOu EminAu   VerCOu )  LIS-ELIP-SCP-VERT ))

					;(COMMAND "COLOR" 255 "LINEA" INT-Aa INT-Ba INTER-AZa "")
				) ; pro
			) ; if
		(COMMAND "SCP" "U")
	) ; repe  LIS-Pun-CAMI 

	(SETQ LIS-ELIP-SCP-VERT (REVERSE LIS-ELIP-SCP-VERT))


) ;cierre DEFUN   CALCULA-ELIPSE-INTERSECCION 

;--------------------------------------------------------------------------------------------------------------------------------


;--------------------------------------------------------------------------------------------------------------------------------
;	(PINTA-ELIPSES)  PUNTOS INTERSECCION DE LAS TANGENTES  INTERSECCION GENERATRIZ CONO-1  PINTA 3DCARAS									
;--------------------------------------------------------------------------------------------------------------------------------

(DEFUN PINTA-ELIPSES (/  )

	(SETQ N3 -1 )													;           0      1        2      3      4                      			
	(REPEAT  (- (LENGTH LIS-ELIP-SCP-VERT) 1)				; (LIST  EmaxAu EmaxBu   EcenOu EminAu   VerCOu )  LIS-ELIP-SCP-VERT )) 	
		(SETQ N3 (+ N3 1))

		(SETQ L-Eli1 (NTH (+ N3 0) LIS-ELIP-SCP-VERT))
		(SETQ L-Eli2 (NTH (+ N3 1) LIS-ELIP-SCP-VERT))

	  	(SETQ PMaxA1 (NTH 0 L-Eli1))		; EmaxAu  
	  	(SETQ PMaxB1 (NTH 1 L-Eli1))		; EmaxBu  
		(SETQ PcenO1 (NTH 2 L-Eli1))		; EcenOu  
	  	(SETQ PMinA1 (NTH 3 L-Eli1))		; EminAu  

	  	(SETQ PMaxA2 (NTH 0 L-Eli2))		; EmaxAu  
	  	(SETQ PMaxB2 (NTH 1 L-Eli2))		; EmaxBu  
		(SETQ PcenO2 (NTH 2 L-Eli2))		; EcenOu  
	  	(SETQ PMinA2 (NTH 3 L-Eli2))		; EminAu  

 		(COMMAND "SCP" "3P" PcenO1 PMaxB1 PMinA1)									; SISTEMA-1E 
			(SETQ PMaxA1e (TRANS PMaxA1 0 1))
			(SETQ PMaxB1e (TRANS PMaxB1 0 1))
			(SETQ PMinA1e (TRANS PMinA1 0 1))
			(COMMAND "COLOR" 2 "ELIPSE" PMaxA1e PMaxB1e PMinA1e )
 			(SETQ  N-Elip1 (ENTLAST))
		(COMMAND "SCP" "U")

 		(COMMAND "SCP" "3P" PcenO2 PMaxB2 PMinA2)									; SISTEMA-2E 
			(SETQ PMaxA2e (TRANS PMaxA2 0 1))
			(SETQ PMaxB2e (TRANS PMaxB2 0 1))
			(SETQ PMinA2e (TRANS PMinA2 0 1))
			(COMMAND "COLOR" 2 "ELIPSE" PMaxA2e PMaxB2e PMinA2e )
 			(SETQ  N-Elip2 (ENTLAST))
		(COMMAND "SCP" "U")

			(COMMAND "COLOR" 2 "SUPREGLA" N-Elip1  N-Elip2 )

			(ENTDEL N-Elip1)																; BORRA N-Elip1
			(ENTDEL N-Elip2)																; BORRA N-Elip2

	) ; repe  LIS-ELIP-SCP-VERT 

) ;cierre DEFUN   PINTA-ELIPSES 

;--------------------------------------------------------------------------------------------------------------------------------


;--------------------------------------------------------------------------------------------------------------------------------
;	(PINTA-3DCARAS)  PUNTOS INTERSECCION DE LAS TANGENTES  INTERSECCION GENERATRIZ CONO-1  PINTA 3DCARAS									
;--------------------------------------------------------------------------------------------------------------------------------

(DEFUN PINTA-3DCARAS (/  )

	;	INTERSECCION GENERATRIZ CONO-1 (VERTICE SECCION) (VERTICE CONO) CON PLANO INTERSECCION CONO-1 CONO-2								

	(SETQ LIS-LIS-P-VER  nil)							; LISTA de (LISTA VERTICES por SECCION) 
	(SETQ LIS-P-V1  LIS-P-INI)
	(SETQ LIS-LIS-P-VER (CONS LIS-P-V1  LIS-LIS-P-VER ))
	(SETQ N2 -1 )											;           0      1        2      3      4                      			
	(REPEAT  (LENGTH LIS-ELIP-SCP-VERT)				; (LIST  EmaxAu EmaxBu   EcenOu EminAu   VerCOu )  LIS-ELIP-SCP-VERT )) 	
		(SETQ N2 (+ N2 1))
		(SETQ L-SCP (NTH N2 LIS-ELIP-SCP-VERT))  	(SETQ P0  (NTH 2 L-SCP))		; EcenOu   P CENTRO ELIPSE  
	  																(SETQ Px  (NTH 0 L-SCP))		; EmaxAu  
	  																(SETQ Py  (NTH 3 L-SCP))		; EminAu   P MEDIO Z
	  																(SETQ PV  (NTH 4 L-SCP))		; VERTICE CONO-1
		(SETQ LIS-P-V2 nil)
		(SETQ N3 -1 )
		(REPEAT  (LENGTH LIS-P-V1)
			(SETQ N3 (+ N3 1))
			(SETQ PUNi (NTH N3 LIS-P-V1))

			;	PUNTO INTERSECCION ENTRE PLANO (Pp1 Pp2 Pp3) y RECTA (Pr1 Pr2) => PunINI															
			(SETQ Pp1 P0  Pp2 Px  Pp3 Py  Pr1 PUNi  Pr2 PV )
			(INTER-PLANO-RECTA)
			(SETQ LIS-P-V2 (CONS PunINI  LIS-P-V2 ))

			;(COMMAND "COLOR" (+ N3 1)  "PUNTO" PunINI )		; PUNTOS VERTICES SECCIONES 
		) ; repe  LIS-P-V1

		(SETQ LIS-P-V2 (REVERSE LIS-P-V2))
		(SETQ LIS-LIS-P-VER (CONS LIS-P-V2  LIS-LIS-P-VER))
		(SETQ LIS-P-V1  LIS-P-V2)
	) ; repe  LIS-ELIP-SCP-VERT 

	;(SETQ LIS-P-ULT  nil)
	;(REPEAT  NLados  (SETQ LIS-P-ULT (CONS (LAST LIS-Pun-CAMI)  LIS-P-ULT)) )	; PUNTO ULTIMO LIS-Pun-CAMI  x  NLados
	;(SETQ LIS-LIS-P-VER (CONS LIS-P-ULT  LIS-LIS-P-VER))	; P-ULT

	(SETQ LIS-LIS-P-VER (REVERSE LIS-LIS-P-VER))

	;	LISTA de LISTAS de 3DC-TIRAS LARGAS       LIS-LIS-TIRA3DC																						

	(SETQ LIS-LIS-TIRA3DC  nil)

	(SETQ N6 -1 )
	(REPEAT  NLados
		(SETQ N6 (+ N6 1))

		(SETQ LIS-TIRA3DC  nil)

		(SETQ N7 -1 )
		(REPEAT  (- (LENGTH LIS-LIS-P-VER) 1)  ; 300 
			(SETQ N7 (+ N7 1))

			(SETQ LIS-SEC1 (NTH (+ N7 0) LIS-LIS-P-VER))		; (LENGTH LIS-SEC1) 7 -1 
			(SETQ LIS-SEC2 (NTH (+ N7 1) LIS-LIS-P-VER))

				(SETQ LIS-SEC1 (CONS (LAST LIS-SEC1) LIS-SEC1))		; COPIA ULTIMO PUNTO el PRIMERO 
				(SETQ LIS-SEC2 (CONS (LAST LIS-SEC2) LIS-SEC2))

			(SETQ PAA1 (NTH (+ N6 0) LIS-SEC1))
			(SETQ PAA2 (NTH (+ N6 1) LIS-SEC1))
			(SETQ PBB1 (NTH (+ N6 0) LIS-SEC2))
			(SETQ PBB2 (NTH (+ N6 1) LIS-SEC2))

			(SETQ LIS-TIRA3DC (CONS (LIST  PAA1 PAA2  PBB1 PBB2 ) LIS-TIRA3DC))

		) ; repe  LIS-LIS-P-VER

		(SETQ LIS-TIRA3DC (REVERSE LIS-TIRA3DC))		; (LENGTH LIS-TIRA3DC) 1794 ??? 

		(SETQ LIS-LIS-TIRA3DC (CONS LIS-TIRA3DC  LIS-LIS-TIRA3DC))

	) ; repe  NLados

	(SETQ LIS-LIS-TIRA3DC (REVERSE LIS-LIS-TIRA3DC))				; LISTA de LISTAS de 3DC-TIRAS LARGAS 

	;	PINTA 3DCARAS y PATRONES            3DC-3D  3DC-2D																									

	(SETQ NTIRA -1 )
	(REPEAT  (LENGTH LIS-LIS-TIRA3DC)   ;  NLados 
		(SETQ NTIRA (+ NTIRA 1))
		(SETQ L#-TIRA (NTH NTIRA  LIS-LIS-TIRA3DC))

		(SETQ N3DC -1 )
		(REPEAT  (LENGTH L#-TIRA)        ;  NDiv   
			(SETQ N3DC (+ N3DC 1))

			(SETQ P-3DC (NTH N3DC  L#-TIRA))

			(SETQ @A1 (NTH 0 P-3DC))
			(SETQ @A2 (NTH 1 P-3DC))
			(SETQ @B1 (NTH 2 P-3DC))
			(SETQ @B2 (NTH 3 P-3DC))

			;(COMMAND  "COLOR" (+ NTIRA 1)  "3DCARA" @A1  @A2  @B2  @B1 "")					; Sistema-SCU   ### PINTA 3D ###

			(COMMAND  "COLOR"        2      "3DCARA" @A1  @A2  @B2  @B1 "")					; Sistema-SCU   ### PINTA 3D ### 

			(IF (= PINTA-PATRONES-3DC  'SI) (PROGN

 				(COMMAND "SCP" "3P" @A1 @A2 @B1)															; Sistema-3DC 

					(SETQ @A1c (TRANS @A1 0 1))
					(SETQ @A2c (TRANS @A2 0 1))
					(SETQ @B1c (TRANS @B1 0 1))
					(SETQ @B2c (TRANS @B2 0 1))

					(IF (= (REM N3DC 10) 0) (PROGN

					  		(COMMAND "COLOR" 7 "LINEA" @A1c @A2c  "" )

							(SETQ Ptxt (LIST (/ ALtxt 3) (/ ALtxt 10)))
							(SETQ TXT  (STRCAT (CHR (+ 65 NTIRA )) "-" (ITOA N3DC)))
							(COMMAND "COLOR" 7 "TEXTO" Ptxt ALtxt  0  TXT )
					)) ; if

				(COMMAND "SCP" "U")

				(IF (= N3DC 0) (PROGN
					(SETQ KK1 (LIST    (* DIS-PATRO (+ NTIRA 1))      0.0))
					(SETQ KK2 (LIST (+ (* DIS-PATRO (+ NTIRA 1)) 10)  0.0))
				)) ; if

 				(COMMAND "SCP" "3P" KK1 KK2 "")															; Sistema-PATRO  ### PINTA 2D ### 

					(COND

						( (= N3DC 0)          ; Con-1 

					  			(COMMAND "COLOR" 7 "TEXTO" Ptxt ALtxt  0  TXT )

								(SETQ PTAAx  (* (/ PTAA (DISTANCE @A1c @A2c)) (- (CAR  @A2c) (CAR  @A1c))))
								(SETQ PTAAy  (* (/ PTAA (DISTANCE @A1c @A2c)) (- (CADR @A2c) (CADR @A1c))))
								(SETQ @A1cPA (LIST (- (CAR @A1c) PTAAx) (- (CADR @A1c) PTAAy)))
								(SETQ @A2cPA (LIST (+ (CAR @A2c) PTAAx) (+ (CADR @A2c) PTAAy)))
					  			(COMMAND "COLOR"      7       "LINEA"  @A1cPA @A2cPA  "" )

					  			(COMMAND "COLOR" (+ NTIRA 1) "_PLINE" @A1c @B1c  "" )  (SETQ  N-Izq1 (ENTLAST))
					  			(COMMAND "COLOR" (+ NTIRA 1) "_PLINE" @A2c @B2c  "" )  (SETQ  N-Der1 (ENTLAST))
						)      ; Con-1 


						( (= (REM N3DC 10) 0) ; Con-2 

					  			(COMMAND "COLOR" 7 "TEXTO" Ptxt ALtxt  0  TXT )

								(SETQ PTAAx  (* (/ PTAA (DISTANCE @A1c @A2c)) (- (CAR  @A2c) (CAR  @A1c))))
								(SETQ PTAAy  (* (/ PTAA (DISTANCE @A1c @A2c)) (- (CADR @A2c) (CADR @A1c))))
								(SETQ @A1cPA (LIST (- (CAR @A1c) PTAAx) (- (CADR @A1c) PTAAy)))
								(SETQ @A2cPA (LIST (+ (CAR @A2c) PTAAx) (+ (CADR @A2c) PTAAy)))
					  			(COMMAND "COLOR"      7       "LINEA"  @A1cPA @A2cPA  "" )

					  			(COMMAND "COLOR" (+ NTIRA 1) "_PLINE" @A1c @B1c  "" )  (SETQ  N-Izq2 (ENTLAST))
					  			(COMMAND "COLOR" (+ NTIRA 1) "_PLINE" @A2c @B2c  "" )  (SETQ  N-Der2 (ENTLAST))


								;(COMMAND "_PEDIT"  N-Izq1  "J"  N-Izq2 "" "" )  (SETQ  N-Izq1 (ENTLAST)) ; "" ?? 
								;(COMMAND "_PEDIT"  N-Der1  "J"  N-Der2 "" "" )  (SETQ  N-Der1 (ENTLAST)) ; "" ?? 

						)      ; Con-2 


						(  T                   ; Con-3 


					  			;(COMMAND "COLOR" (+ NTIRA 1) "LINEA"  @A1c @A2c  "" )  ; LINEAS INTERMEDIAS a NEGRAS 


					  			(COMMAND "COLOR" (+ NTIRA 1) "_PLINE" @A1c @B1c  "" )  (SETQ  N-Izq2 (ENTLAST))
					  			(COMMAND "COLOR" (+ NTIRA 1) "_PLINE" @A2c @B2c  "" )  (SETQ  N-Der2 (ENTLAST))

								(IF (= N3DC (- (LENGTH L#-TIRA) 1)) (COMMAND "COLOR" (+ NTIRA 1) "LINEA"  @B1c @B2c  "" ))

								;(COMMAND "_PEDIT"  N-Izq1  "J"  N-Izq2 "" "" )  (SETQ  N-Izq1 (ENTLAST)) ; "" ?? 
								;(COMMAND "_PEDIT"  N-Der1  "J"  N-Der2 "" "" )  (SETQ  N-Der1 (ENTLAST)) ; "" ?? 

						)      ; Con-3 

					) ; cond

					(SETQ @B1cu (TRANS @B1c 1 0))
					(SETQ @B2cu (TRANS @B2c 1 0))

				(COMMAND "SCP" "U")


				(IF (/= N3DC 0) (PROGN

					;(COMMAND "_PEDIT"  N-Izq1  "J"  N-Izq2 "" "" )  (SETQ  N-Izq1 (ENTLAST)) ; "" ?? 
					;(COMMAND "_PEDIT"  N-Der1  "J"  N-Der2 "" "" )  (SETQ  N-Der1 (ENTLAST)) ; "" ?? 

					;(COMMAND "CHAFLAN"  N-Izq1  N-Izq2 )  (SETQ  N-Izq1 (ENTLAST)) ; "" ?? 
					;(COMMAND "CHAFLAN"  N-Der1  N-Der2 )  (SETQ  N-Der1 (ENTLAST)) ; "" ?? 

				)) ; if


				(SETQ KK1  @B1cu)
				(SETQ KK2  @B2cu)

			)) ; if

		) ; repe  L#-TIRA

	) ; repe  LIS-LIS-TIRA3DC

) ;cierre DEFUN   PINTA-3DCARAS 



;--------------------------------------------------------------------------------------------------------------------------------


;--------------------------------------------------------------------------------------------------------------------------------
;	(PINTA-ESFERAS)  PINTA ESFERA CENTRO: Pn  RADIO: Rn																									
;--------------------------------------------------------------------------------------------------------------------------------

(DEFUN PINTA-ESFERAS ( / )

	(SETQ NLC      -1      )
	(SETQ NLR (- NPvu# 1 ))

	(REPEAT  (LENGTH LIS-Pun-CAMI)
		(SETQ NLC (+ NLC 1))
		(SETQ NLR (+ NLR 1))

		(SETQ PU1 (NTH  NLC  LIS-Pun-CAMI))
		(SETQ RA1 (NTH  NLR  LIS-RADIOS  ))

		(COMMAND "COLOR" 2  "_SPHERE" PU1 RA1 )

		(IF (= (REM  NLR (/ NPvu# 2)) 0 )		; CIRCULOS SECCION ESFERAS en PLANO X-Z 
			(PROGN
				(SETQ PU1ooz (LIST 0.0 0.0 (CADDR PU1)))
				(COMMAND "COLOR" 7 "LINEA"  PU1  PU1ooz "")

				(COMMAND "SCP" "X" "" )
					(SETQ  PU1x (TRANS PU1 0 1))
					(COMMAND  "COLOR" 7 "CIRCULO"  PU1x  RA1 )
 				(COMMAND "SCP" "U" )
			) ; pro
		) ; if

	) ; repe  LIS-Pun-CAMI 

) ;cierre DEFUN   PINTA-ESFERAS

;--------------------------------------------------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------------------------------------------------
;"##############################################################################################################################"
;"  RAMA-GUSANO-06A  *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA ***"
;"##############################################################################################################################"
;--------------------------------------------------------------------------------------------------------------------------------
;	  PUNTOS CANICO de la ESPIRAL               X = (* KK/R RA/n+0 (COS (* NRA AG/ud)))                                          
;	                                            Y = (* KK/R RA/n+0 (SIN (* NRA AG/ud)))                                          
;	  FUNCION de los RADIOS de las ESFERAS      Z = (+ (* AL/ud  KK/V)  P0z1 )      AL/ud = (/ (+ RA/n+0  RA/n-V) NPvu# )        
;--------------------------------------------------------------------------------------------------------------------------------



		(SETQ P0x   (* KK/R RA/n+0 (COS (* NRA AG/ud))))    		; FACTOR ESCALA RADIAL   
		(SETQ P0y   (* KK/R RA/n+0 (SIN (* NRA AG/ud))))

		(SETQ AL/ud (/ (+ RA/n+0  RA/n-V) NPvu# ))					; ALTURA UNITARIA        
		(SETQ P0z2   (+ (* AL/ud  KK/V)  P0z1 ))  					; FACTOR ESCALA VERTICAL 







(DEFUN C:ESPIRAL-PERFIL-03 ( / )

	(SETVAR "blipmode" 0) (SETVAR "cmdecho"  0) (GRAPHSCR) (COMMAND "-REFENT" "DES") (COMMAND "SCP" "U") (COMMAND "ORTO" "DES")

	;	FIJA VARIABLES EN EL PROGRAMA																																

				(SETQ NLados      3   )									; N de LADOS POLIGONO REGULAR en INICIO 

				(SETQ NPvu#     200   )									; PUNTOS por VUELTA ESPIRAL (MULTIPLO de 2 o 4)   
				(SETQ NVUE#       6   )									; VUELTAS DATOS del ESPIRAL   DIBUJO: (NVUE# -1) 

				(SETQ KK/R         3.5 )									; FACTOR ESCALA RADIAL   PUNTOS CAMINO ESPIRAL 
				(SETQ KK/V         3.5 )									; FACTOR ESCALA VERTICAL PUNTOS CAMINO ESPIRAL 

				(SETQ DIS-PATRO  500   )									; DISTANCIA ENTRE PATRONES 
				(SETQ ALtxt        0.5 )									; ALTURA TEXTO  3D y 2D    
				(SETQ PTAA        0.5 )									; ANCHO PESTAA PATRONES   

				;(SETQ QQ-Radi   3.0 )									; SEPARADOR RADIAL Cilindro CENTRAL 
				;(SETQ QQ-Vert   6.0 )									; SEPARADOR VERTICAL por VUELTA 

	;	SUBPROGRAMA A EJECUTAR																															

				(SETQ PINTAR-ESFERAS          'NO )					; PINTA ESFERAS  < 'SI o 'NO > 
				(SETQ INTERSECCION-CILINDROS  'NO )					; PINTA ELIPSES  < 'SI o 'NO > 
				(SETQ PINTAR-3DCARAS          'SI )					; PINTA 3DCARAS  < 'SI o 'NO > 
				(SETQ PINTA-PATRONES-3DC      'SI )					; PINTA PATRONES < 'SI o 'NO > 

	;	CALCULOS																																							
	         (SETQ NDiv (* NPvu#  NVUE#) )						; N(DIVIDE)  SPLINE

	;	LISTAS PUNTOS ( LIS-Pun-REF  LIS-Pun-EJE ) 	############ TODAS TIENEN QUE SER SPLINES ############								
 	(TERPRI)  (SETQ N-PERF (CAR (ENTSEL "--------------- Marca  Spline  PERFIL ?" )))         			;   SPLINE PERFIL 
 	(TERPRI)  (SETQ N-BASE (CAR (ENTSEL "--------------- Marca  Spline  EJE-BASE ?" ))) (TERPRI)			;   SPLINE EJE    

	(SETQ  N-ELE N-PERF   NDIDI (* NDiv 6))  (PUNTOS-DIVIDE)  (SETQ LIS-Pun-REF   LIS-PUNTOS)			;   (LENGTH LIS-Pun-REF ) 
	(SETQ  N-ELE N-BASE   NDIDI    NDiv   )  (PUNTOS-DIVIDE)  (SETQ LIS-Pun-EJE   LIS-PUNTOS)			;   (LENGTH LIS-Pun-EJE ) 

	; RADIOS CIRCULOS para TANGENTES en SECCCIONES     (LENGTH LIS-RADIOS )																			

	(LISTA-RADIOS-PERFIL)											; LIS-RADIOS

	; LISTA PUNTOS CAMINO (ESPIRAL)  ( LIS-Pun-CAMI ) 																										

	(SETQ LIS-Pun-CAMI  nil )

	(SETQ AG/ud (/ (* 2 PI) NPvu#))																							; ANGULO UNIDAD 
	(SETQ P0z1  0.0 )

	;(SETQ NRA -1 )

	(SETQ NRA (- NPvu# 1 ))

	(REPEAT  (- (LENGTH LIS-RADIOS) NPvu# )
		(SETQ NRA (+ NRA 1))													; 1 NRR =  NPvu#  (PUNTOS por VUELTA ESPIRAL) 

		(SETQ RA/n+0 (NTH    NRA          LIS-RADIOS))
		(SETQ RA/n-V (NTH (- NRA  NPvu#) LIS-RADIOS))					; NO PINTA PRIMERA VUELTA 

		;(SETQ P0x   (* (+ QQ-Radi RA/n+0) (COS (* NRA AG/ud))))   ; SEPARADOR RADIAL Cilindro CENTRAL 
		;(SETQ P0y   (* (+ QQ-Radi RA/n+0) (SIN (* NRA AG/ud))))

		(SETQ P0x   (* KK/R RA/n+0 (COS (* NRA AG/ud))))    		; FACTOR ESCALA RADIAL   
		(SETQ P0y   (* KK/R RA/n+0 (SIN (* NRA AG/ud))))

		;(SETQ AL/ud (/ (+ RA/n+0  QQ-Vert  RA/n+V) NPvu# ))  		; SEPARADOR VERTICAL 
		;(SETQ P0z2   (+ AL/ud  P0z1 ))

		;(SETQ AL/ud (/ (+ RA/n+0  QQ-Vert  RA/n-V) NPvu# ))  		; SEPARADOR VERTICAL 
		;(SETQ P0z2   (+ AL/ud  P0z1 ))

		(SETQ AL/ud (/ (+ RA/n+0  RA/n-V) NPvu# ))					; ALTURA UNITARIA        
		(SETQ P0z2   (+ (* AL/ud  KK/V)  P0z1 ))  					; FACTOR ESCALA VERTICAL 


		(SETQ LIS-Pun-CAMI  (CONS (LIST P0x P0y P0z2) LIS-Pun-CAMI ))

	;	(COMMAND "COLOR" 8 "LINEA" (LIST 0.0 0.0 P0z2) (LIST P0x P0y P0z2) "")

		(SETQ P0z1  P0z2 )

	) ; repe  LIS-RADIOS

	(SETQ LIS-Pun-CAMI (REVERSE LIS-Pun-CAMI))																		; (LENGTH LIS-Pun-CAMI) 100

	;	COMPROBACIONES PREVIAS  =>  TIENE QUE SER (ABS DisP12)>(ABS R1-R2) SI NO ERROR															

	(SETQ DifMAXr 0.0)										; MAXIMA DIFERENCIA entre RADIOS R1 R2 
	(SETQ NR -1  )
	(REPEAT  (- (LENGTH LIS-RADIOS) 1)
		(SETQ NR (+ NR 1))
		(SETQ RR1 (NTH (+ NR 0) LIS-RADIOS))
		(SETQ RR2 (NTH (+ NR 1) LIS-RADIOS))
		(IF (> (ABS (- RR1 RR2)) DifMAXr) (SETQ DifMAXr (ABS (- RR1 RR2))))  ; 
	) ; repe  LIS-RADIOS 

	(SETQ Long-SPL      0.0)								; LONGITUD SPLINE 
	(SETQ DisMINp 100000.0)									; MINIMA DISTANCIA entre PUNTOS P1 P2 
	(SETQ NP -1  )
	(REPEAT  (- (LENGTH LIS-Pun-CAMI) 1)
		(SETQ NP (+ NP 1))
		(SETQ PP1 (NTH (+ NP 0) LIS-Pun-CAMI))
		(SETQ PP2 (NTH (+ NP 1) LIS-Pun-CAMI))
		(SETQ DISpp   (DISTANCE PP1 PP2))
		(SETQ Long-SPL (+ Long-SPL DISpp ))
		(IF (< DISpp  DisMINp) (SETQ DisMINp  DISpp))
	) ; repe  LIS-Pun-CAMI 

	(IF (< DisMINp DifMAXr)
		(PROGN (TERPRI) (PROMPT " #  Dis-MIN.Puntos < Dif-MAX.Radios #  RAIZ(-)? ")) (TERPRI))
	(IF (< (FIX (/ Long-SPL DifMAXr)) NDiv)														; LINITE:  NDiv = (/ Long-SPL  DifMAXr) 
		(PROGN (TERPRI) (PROMPT " *** (NDiv) TIENE QUE SER MENOR = ")
		                                     (PRIN1 (FIX (/ Long-SPL DifMAXr))) (PROMPT " NO "       ) (PRIN1 NDiv) (TERPRI)))
	(IF (> (FIX (/ Long-SPL DifMAXr)) NDiv)														; LINITE:  NDiv = (/ Long-SPL  DifMAXr) 
		(PROGN (TERPRI) (PROMPT " *** (NDiv) POEDE SER MAYOR = "    )
		                                     (PRIN1 (FIX (/ Long-SPL DifMAXr))) (PROMPT " en vez de ") (PRIN1 NDiv) (TERPRI)))

	;-----------------------------------------------------------------------------------------------------------------------------
	;	(PINTA-ESFERAS)  PINTA ESFERA CENTRO: P1  RADIO: R1																								

	(IF (= PINTAR-ESFERAS  'SI)  (PROGN (PINTA-ESFERAS) ))

	;-----------------------------------------------------------------------------------------------------------------------------
	;	(PINTA-ELIPSES)  PINTA ELIPSES INTERSECCION CONOS CIRCUSCRITOS ESFERAS E1 E2 E3															

	(IF (= INTERSECCION-CILINDROS  'SI)  (PROGN (CALCULA-ELIPSE-INTERSECCION) (PINTA-ELIPSES) ))

	;-----------------------------------------------------------------------------------------------------------------------------
	;	(LISTA-Pun-INICIO)        PUNTOS POLIGONO REGULAR INICIO (NLados) (PUNTOS DIVIDE CIRCULO  EJE-Z 1(P1 P2))      				
	;  (PINTA-PIRAMIDES-ESFERAS-3DC) PUNTOS INTERSECCION DE LAS TANGENTES  INTERSECCION GENERATRIZ CONO-1  PINTA 3DCARAS				

	(IF (= PINTAR-3DCARAS  'SI)  (PROGN (CALCULA-ELIPSE-INTERSECCION) (LISTA-Pun-INICIO) (PINTA-3DCARAS) ))

	;-----------------------------------------------------------------------------------------------------------------------------

  	;	PARANDO																																							
	(SETVAR "blipmode" 1)  (SETVAR "cmdecho"  1)
	(TERPRI) (PROMPT " >>>>>>>>> FIN >>>>>> ") (TERPRI)

) ;  ESPIRAL-PERFIL-03 
;--------------------------------------------------------------------------------------------------------------------------------
