

;--------------------------------------------------------------------------------------------------------------------------
;																																									
;	( POLAR-ESPIRAL-PERFIL-01 )       de POLARES-03  MODIFICODO 18/03/2007										19/03/2007				
;																																									
;--------------------------------------------------------------------------------------------------------------------------
;																																									
;	CREA SUPERFICIE POLAR A CURVA DETERMINADA																											
;																																									
;	LISTA DE PUNTOS EN QUE SE DIVIDE LA CURVA (LIS-P-SPLI)																						
;	CENTRO DEL  CISCULO OSCULADOR  A 3 Puntos (P1 P2 P3)																							
;	CENTRO DE LA ESFIRA OSCULADORA A 4 Puntos (P1 P2 P3 P4)																						
;																																									
;	PINTA PUNTOS DE CURVA => (LIS-P-SPLI)																												
;	PINTA GENERATRICES DE SUPERFICIE POLAR ENTRE CENTROS CIRCULO Y ESFERA => (C0-cir123u C0-esfe1234u)								
;	PINTA 3DCARS 3D																																			
;	PINTA 3DCARS 2D																																			
;																																									
;	PROPORCIONA EL PROGRAMA LOS PUNTOS-BASE ( P00 )																									
;--------------------------------------------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------------------------------------------
;	(N-PARTES-DIVIDE) = CUENTA NUMERO DE PUNTOS DE ( GARADUA ) CON ( DIS-G ) EN EJE-3D => ( N-DIVIDE )							

(DEFUN N-PARTES-DIVIDE (/  )

	(SETQ AELES (MEMBER (ASSOC 10 (ENTGET N-SPLN)) (ENTGET N-SPLN))) 				; lista a partir del elemento (incluido)
	(SETQ A-primer (CDR (NTH 0 AELES))) 													; primer elemento
	(COMMAND "COLOR" 1) 																			; ROJO
	(COMMAND "PUNTO" A-primer)
 	(SETQ NPA0 (ENTLAST)) 																		; nombre ultima entidad principal 1 punto
	
	(COMMAND "COLOR" 252)																		; GRIS
	(COMMAND "GRADUA" N-SPLN DIS-G)															; gradua

	;	PUNTOS SECCION X (PX1-PXn) =>  LIS-P-SPLI																										

	(SETQ NPA1 nil NPA2 nil)

	(SETQ NPA2 NPA0)

	(SETQ N-DIVIDE 1)
	(SETQ WH-1 T)
	(WHILE WH-1
		(SETQ NPA1 (ENTNEXT NPA0)) 															; nombre entidad siguiente
		(IF (= NPA1 nil)
			(SETQ WH-1 nil)
			(PROGN
				(SETQ NPA0 NPA1)
				(SETQ N-DIVIDE (+ N-DIVIDE 1))
				(ENTDEL NPA1)																		; BORRA PUNTO
			) ;progn
		) ;if
	) ;While WH-1

	(ENTDEL NPA2)																					; BORRA PUNTO

) ;cierre DEFUN N-PARTES-DIVIDE

;--------------------------------------------------------------------------------------------------------------------------


;--------------------------------------------------------------------------------------------------------------------------
;	(PUNTOS-SPLIN) = SPLINE-2D  PUNTEANDOLA A DISTANCIA (DIS-G) => (LIS-P-SPLI)															

(DEFUN PUNTOS-SPLIN (/  )

	(SETQ AELES (MEMBER (ASSOC 10 (ENTGET N-SPLN)) (ENTGET N-SPLN)))				; lista a partir del elemento (incluido)
	(SETQ A-primer (CDR (NTH 0 AELES)))														; primer elemento
	(SETQ A-ultimo (CDR (NTH (- (LENGTH AELES) 1) AELES)))							; ultimo elemento

	(COMMAND "COLOR" 1)																			; ROJO
	(COMMAND "PUNTO" A-primer)
 	(SETQ NPA0 (ENTLAST))																		;nombre ultima entidad principal 1 punto

	(COMMAND "COLOR" 252)																		; GRIS
	(COMMAND "DIVIDE" N-SPLN N-DIVIDE)														; DIVIDE

	(COMMAND "COLOR" 5)																			; AZUL
	(COMMAND "PUNTO" A-ultimo)

	;	PUNTOS SECCION X (PX1-PXn) =>  LIS-P-SPLI																										

	(SETQ NPA1 nil NPA2 nil LIS-P-SPLI nil NPA2 NPA0)
	(SETQ LIS-P-SPLI (LIST (CDR (ASSOC 10 (ENTGET NPA0)))))							; LIS-P-SPLI => 1 punto
	(SETQ WH-1 T)
	(WHILE WH-1
		(SETQ NPA1 (ENTNEXT NPA0))																; nombre entidad siguiente
		(IF (= NPA1 nil)
			(SETQ WH-1 nil)
			(PROGN
				(SETQ LIS-P-SPLI (CONS (CDR (ASSOC 10 (ENTGET NPA1))) LIS-P-SPLI))	;=> resto Puntos
				(SETQ NPA0 NPA1)
				(ENTDEL NPA1)																		; BORRA PUNTO
			) ;progn
		) ;if
	) ;While WH-1

	(SETQ LIS-P-SPLI (REVERSE LIS-P-SPLI))

	(ENTDEL NPA2)																					; BORRA PUNTO

) ;cierre DEFUN PUNTOS-SPLIN

;--------------------------------------------------------------------------------------------------------------------------


;--------------------------------------------------------------------------------------------------------------------------
;	PINTA PUNTOS DE CURVA => (LIS-P-SPLI) 																												

(DEFUN PINTA-PUNTOS-SPLIN (/  )

	(SETQ COOL 4)
	(SETQ M0 (- 1))
	(REPEAT (LENGTH LIS-P-SPLI)
		(SETQ M0 (+ M0 1))

		(SETQ P0U (NTH M0 LIS-P-SPLI))

		(SETQ COOL (+ COOL 1))
		(SETQ COOLO (+ (REM COOL 5) 1))

		(COMMAND "COLOR" COOLO  "PUNTO" P0U)

	) ; Cierre Repeat
) ;cierre DEFUN PINTA-PUNTOS-SPLIN

;--------------------------------------------------------------------------------------------------------------------------


;--------------------------------------------------------------------------------------------------------------------------
;	LISTA PUNTOS-BASE  ( LIS-P-BASE ) 																													

(DEFUN PUNTOS-BASE (/  )

	;	TOMA 4 PRIMEROS PUNTOS DE LIS-P-SPLI 							( P1U P2U P3U P4U )														

	(SETQ P1 (NTH 0 LIS-P-SPLI))
	(SETQ P2 (NTH 1 LIS-P-SPLI))
	(SETQ P3 (NTH 2 LIS-P-SPLI))
	(SETQ P4 (NTH 3 LIS-P-SPLI))

	;	CORDENADAS DEL PUNTO MEDIO DE ( P1U P2U ) => 					( P12 )																	

	(SETQ XP1 (CAR P1) YP1 (CADR P1) ZP1 (CADDR P1))
	(SETQ XP2 (CAR P2) YP2 (CADR P2) ZP2 (CADDR P2))
	(SETQ XP12 (+ (/ (- XP2 XP1) 2) XP1))
	(SETQ YP12 (+ (/ (- YP2 YP1) 2) YP1))
	(SETQ ZP12 (+ (/ (- ZP2 ZP1) 2) ZP1))
	(SETQ P12 (LIST XP12 YP12 ZP12))				; PUNTO MEDIO ( P12 )   OPERABA CON P12 ??? P23 

	;	CENTRO DEL CIRCULO-123  Y PUNTO DE SU PERPENDICULAR 				(C0-cir123u)	(Cz-cir123u)									

	(COMMAND "SCP" "3P" P1 P2 P3)																	; SCP=123 PLANO-AA
 		(SETQ P1aa (TRANS P1 0 1))
		(SETQ P2aa (TRANS P2 0 1))
		(SETQ P3aa (TRANS P3 0 1))

		(COMMAND "CIRCULO" "3P" P1aa P2aa P3aa)												; CIRCULO-123 
		(SETQ N-cir123 (ENTLAST))
	(COMMAND "SCP" "U")

	(COMMAND "SCP" "B" N-cir123) 																	; SCP=CIR123 
		(SETQ C0-cir123u (TRANS (LIST 0  0   0) 1 0))										; CENTRO 123 
		(SETQ Cz-cir123u (TRANS (LIST 0  0 100) 1 0))										; EJE-Z  123 
	(COMMAND "SCP" "U")

	(COMMAND "_ERASE" N-cir123 "")                                                ; BORRA CIRCULO-123

	;	CENTRO DEL CIRCULO-234  Y PUNTO DE SU PERPENDICULAR 				(C0-cir234u)	(Cz-cir234u)									

	(COMMAND "SCP" "3P" P2 P3 P4)																	; SCP=234 PLANO-BB
 		(SETQ P2bb (TRANS P2 0 1))
		(SETQ P3bb (TRANS P3 0 1))
		(SETQ P4bb (TRANS P4 0 1))
		(COMMAND "CIRCULO" "3P" P2bb P3bb P4bb)												; CIRCULO-234 
		(SETQ N-cir234 (ENTLAST))
	(COMMAND "SCP" "U")

	(COMMAND "SCP" "B" N-cir234) 																	; SCP=CIR234 
		(SETQ C0-cir234u (TRANS (LIST 0 0   0) 1 0))											; CENTRO 234 
		(SETQ Cz-cir234u (TRANS (LIST 0 0 100) 1 0))											; EJE-Z  234 
	(COMMAND "SCP" "U")

	(COMMAND "_ERASE" N-cir234 "")                                                ; BORRA CIRCULO-234

	;	CENTRO ESFERA-1234										(C0-esfe1234u)																			

	(SETQ C0-esfe1234u (INTERS C0-cir123u Cz-cir123u   C0-cir234u Cz-cir234u nil)) ; CENTRO ESFERA-1234 

	;	CORDENADAS DE (C0-esfe1234pp) CON (C0-cir123pp) EN ORIGEN-Z(0 0 0) => VECT-1234-123pp											

  	(COMMAND "SCP" "EZ" P12 P2 )																	; PLANO PP 

		(SETQ C0-cir123pp   (TRANS C0-cir123u   0 1))		; en ESPIRAL-PERFIL-2.DWG  capa 031-COMPROBAR-POLARES-3 
		(SETQ C0-esfe1234pp (TRANS C0-esfe1234u 0 1))

		(SETQ VECT-1234-123pp (LIST (- (CAR C0-esfe1234pp) (CAR C0-cir123pp)) (- (CADR C0-esfe1234pp) (CADR C0-cir123pp)) 0.0))

		(SETQ VECT-1234-123u (TRANS VECT-1234-123pp 1 0))

	(COMMAND "SCP" "U")

	;	LIS-P-BASE		en PLANO Perpendicular a P2 P3 en P12   EjeX Paralelo a CEN-CIRCULO-123 y CEN-ESFERA-1234 				

	(SETQ LIS-P-BASE nil)

  	(COMMAND "SCP" "3P" P12  VECT-1234-123u  C0-cir123u )				; PLANO PER12 




					; ### INVESTIGAR ###                                           




		(SETQ ANG-1 (/ PI (* NSup/180 2.0)))								; (+ NSup/180 1) ?
		(SETQ ANG-2 (* ANG-1  2.0))

		(SETQ P00Z (POLAR (LIST 0 0 0) ANG-1 10))							; @ @ @ CORDENADAS POLARES @ @ @ 

 		(SETQ P001 (TRANS P00Z 1 0))

		(SETQ LIS-P-BASE (CONS P001 LIS-P-BASE))

		(REPEAT (- NSup/180 1)												; NSup/180 ? 

			(SETQ ANG-1 (+ ANG-1 ANG-2))	

			(SETQ P00Z (POLAR (LIST 0 0 0) ANG-1 10))

 			(SETQ P001 (TRANS P00Z 1 0))

			(SETQ LIS-P-BASE (CONS P001 LIS-P-BASE))


		) ; fin Repeat

	(COMMAND "SCP" "U")

	(SETQ LIS-P-BASE (REVERSE LIS-P-BASE))

) ;cierre DEFUN PUNTOS-BASE

;--------------------------------------------------------------------------------------------------------------------------


;--------------------------------------------------------------------------------------------------------------------------
;	PINTA GENERATRICES DE SUPERFICIE POLAR ENTRE CENTROS CIRCULO Y ESFERA => (C0-cir123u  C0-esfe1234u)							

(DEFUN PINTA-GENERATRICES (/  )


	;	TOMA PUNTO-BASE DE (LIS-P-BASE)							(P00)																					

	(SETQ  N -1)
	(SETQ NNN 0)
	(SETQ COL 4)
  
		;(SETQ NNN (+ NNN 120))

	(REPEAT (LENGTH LIS-P-BASE)

		(SETQ NNN (+ NNN 120))

		(SETQ PP0 (LIST    NNN     0 0))
		(SETQ PPX (LIST (+ NNN 10) 0 0))


		(SETQ COL (+ COL 1))
		(SETQ COLO (+ (REM COL 5) 1))
		(COMMAND "COLOR" COLO)

		(SETQ N (+ N 1))
		(SETQ P00 (NTH N LIS-P-BASE))  ; ### INVESTIGAR ###      

		;	TOMA 4 PUNTOS DE (LIS-P-SPLI) 							( P1U P2U P3U P4U P5U)														

		(SETQ P1U (NTH 0 LIS-P-SPLI))
		(SETQ P2U (NTH 1 LIS-P-SPLI))
		(SETQ P3U (NTH 2 LIS-P-SPLI))
		(SETQ P4U (NTH 3 LIS-P-SPLI))

		;	CORDENADAS DEL PUNTO MEDIO DE ( P1U P2U ) => 				( P12U-A )																

		(SETQ P12U-A (LIST (+ (/ (- (CAR   P2U) (CAR   P1U)) 2) (CAR   P1U))
					          (+ (/ (- (CADR  P2U) (CADR  P1U)) 2) (CADR  P1U))
					          (+ (/ (- (CADDR P2U) (CADDR P1U)) 2) (CADDR P1U))))

		;(COMMAND "PUNTO" P12U-A)

		;	CENTRO DEL CIRCULO-123  Y PUNTO DE SU PERPENDICULAR 			(C0-cir123u)	(Cz-cir123u)									

		(COMMAND "SCP" "3P" P1U P2U P3U)			; SCP=123 PLANO-A
 			(SETQ P1A (TRANS P1U 0 1))
			(SETQ P2A (TRANS P2U 0 1))
			(SETQ P3A (TRANS P3U 0 1))
			(COMMAND "CIRCULO" "3P" P1A P2A P3A)	; CIRCULO-1
			(SETQ N-CIR1 (ENTLAST))
		(COMMAND "SCP" "U")

		(COMMAND "SCP" "B" N-CIR1) 				; SCP=CIR1 
			(SETQ C0-cir123u (TRANS (LIST 0 0   0) 1 0))
			(SETQ Cz-cir123u (TRANS (LIST 0 0 100) 1 0))
		(COMMAND "SCP" "U")
		(COMMAND "_ERASE" N-CIR1 "")

		;	CENTRO DEL CIRCULO-234  Y PUNTO DE SU PERPENDICULAR 			(C0-cir234u)	(Cz-cir234u)									

		(COMMAND "SCP" "3P" P2U P3U P4U)			; SCP=234 PLANO-B
 			(SETQ P2B (TRANS P2U 0 1))
			(SETQ P3B (TRANS P3U 0 1))
			(SETQ P4B (TRANS P4U 0 1))
			(COMMAND "CIRCULO" "3P" P2B P3B P4B)	; CIRCULO-2
			(SETQ N-CIR2 (ENTLAST))
		(COMMAND "SCP" "U")

		(COMMAND "SCP" "B" N-CIR2) 				; SCP=CIR2 
			(SETQ C0-cir234u (TRANS (LIST 0 0   0) 1 0))
			(SETQ Cz-cir234u (TRANS (LIST 0 0 100) 1 0))
		(COMMAND "SCP" "U")
		(COMMAND "_ERASE" N-CIR2 "")

		;	CENTRO ESFERA-1234									(C0-esfe1234u)																			

		(SETQ C0-esfe1234u (INTERS C0-cir123u Cz-cir123u  C0-cir234u Cz-cir234u nil))    ;    C0-esfe1234u 

		;	EXTREMO GENERATRIZ-1								(EXG-1)																						

		(SETQ EXG-1 (INTERS C0-cir123u C0-esfe1234u  P12U-A  P00 nil))

		(SETQ P00 EXG-1)

		;	PUNTOS ANCHO CAMINO ( P12U-A EXG-1 )							ANCHO (KK1) (KK2)														

		(COMMAND "SCP" "3P" P12U-A EXG-1 P2U)		; PLANO G
			(SETQ KK1 (TRANS (LIST    ANCH  0 0) 1 0))
			(SETQ KK2 (TRANS (LIST (- ANCH) 0 0) 1 0))
		(COMMAND "SCP" "U")

		;	REPITE   TOMA 4 PUNTOS DE LIS-P-SPLI ( P1U P2U P3U P4U )																				

		(SETQ  M1 0)

		(REPEAT (- (LENGTH LIS-P-SPLI) 4)
			(SETQ M1 (+ M1 1))

			(SETQ P1U (NTH    M1    LIS-P-SPLI))
			(SETQ P2U (NTH (+ M1 1) LIS-P-SPLI))
			(SETQ P3U (NTH (+ M1 2) LIS-P-SPLI))
			(SETQ P4U (NTH (+ M1 3) LIS-P-SPLI))

		;	CORDENADAS DEL PUNTO MEDIO DE ( P1U P2U ) => ( P12U-B )																				

			(SETQ XP1 (CAR P1U) YP1 (CADR P1U) ZP1 (CADDR P1U))
			(SETQ XP2 (CAR P2U) YP2 (CADR P2U) ZP2 (CADDR P2U))
			(SETQ XP12 (+ (/ (- XP2 XP1) 2) XP1))
			(SETQ YP12 (+ (/ (- YP2 YP1) 2) YP1))
			(SETQ ZP12 (+ (/ (- ZP2 ZP1) 2) ZP1))
			(SETQ P12U-B (LIST XP12 YP12 ZP12))		; PUNTO MEDIO ( P12U-B )

		;	CENTRO-1 DEL CIRCULO-123 (C0-cir123u) Y PUNTO DE SU PERPENDICULAR (Cz-cir123u)												

			(COMMAND "SCP" "3P" P1U P2U P3U)		; SCP=123 PLANO-A
 				(SETQ P1A (TRANS P1U 0 1))
				(SETQ P2A (TRANS P2U 0 1))
				(SETQ P3A (TRANS P3U 0 1))
				(COMMAND "CIRCULO" "3P" P1A P2A P3A)	; CIRCULO-1
				(SETQ N-CIR1 (ENTLAST))
			(COMMAND "SCP" "U")

			(COMMAND "SCP" "B" N-CIR1) 			; SCP=CIR1 
				(SETQ C0-cir123u (TRANS (LIST 0 0   0) 1 0))
				(SETQ Cz-cir123u (TRANS (LIST 0 0 100) 1 0))
			(COMMAND "SCP" "U")
			(COMMAND "_ERASE" N-CIR1 "")

		;	CENTRO-2 DEL CIRCULO-234 (C0-cir234u) Y PUNTO DE SU PERPENDICULAR (Cz-cir234u)												

			(COMMAND "SCP" "3P" P2U P3U P4U)		; SCP=234 PLANO-B
 				(SETQ P2B (TRANS P2U 0 1))
				(SETQ P3B (TRANS P3U 0 1))
				(SETQ P4B (TRANS P4U 0 1))
				(COMMAND "CIRCULO" "3P" P2B P3B P4B)	; CIRCULO-2
				(SETQ N-CIR2 (ENTLAST))
			(COMMAND "SCP" "U")

			(COMMAND "SCP" "B" N-CIR2) 			; SCP=CIR2 
				(SETQ C0-cir234u (TRANS (LIST 0 0   0) 1 0))
				(SETQ Cz-cir234u (TRANS (LIST 0 0 100) 1 0))
			(COMMAND "SCP" "U")
			(COMMAND "_ERASE" N-CIR2 "")

		;	CENTRO ESFERA-1234																																

			(SETQ C0-esfe1234u (INTERS C0-cir123u Cz-cir123u  C0-cir234u Cz-cir234u nil))

		;	EXTREMO GENERATRIZ-1																																

			(SETQ EXG-1 (INTERS C0-cir123u C0-esfe1234u P12U-B P00 nil))

			(SETQ P00 EXG-1)

		;	COMPRUEBA EMBOLUTAS CONSECUTIVAS ( P12U-B EXG-1 ) ( P12U-B EXG-2 ) EN LA MISMA DIRECCION O CONTRARIA					

			(COMMAND "SCP" "3P" P12U-A KK1 P1U)		; PLANO G

 				(SETQ EXG-1G (TRANS EXG-1 0 1))

				(IF (> (CAR EXG-1G) 0) (SETQ QQ1 1) (SETQ QQ1 2))

			(COMMAND "SCP" "U")

			(COMMAND "SCP" "3P" P12U-B EXG-1 P2U)		; PLANO H

				(IF (= QQ1 1)
					(PROGN
						(SETQ KK3 (TRANS (LIST    ANCH  0 0) 1 0))
						(SETQ KK4 (TRANS (LIST (- ANCH) 0 0) 1 0))
					)
					(PROGN
						(SETQ KK4 (TRANS (LIST    ANCH  0 0) 1 0))
						(SETQ KK3 (TRANS (LIST (- ANCH) 0 0) 1 0))
					)
				)
			(COMMAND "SCP" "U")

		;	PINTA 3DCARAS DE LA EMBOLUTA																													

		;(SETQ COL (+ COL 1))
		;(SETQ COLO (+ (REM COL 5) 1))
		;(COMMAND "COLOR" COLO)

		(COMMAND "3DCARA" KK1 KK2 KK4 KK3 "")		; en 3D


		;	PINTA 3DC EN EL PLANO (PATRONES)																												

		(COMMAND "SCP" "3P" KK1 KK2 KK3)	; PLANO-3D-A
		(SETQ P1A (TRANS KK1 0 1))
		(SETQ P2A (TRANS KK2 0 1))
		(SETQ P3A (TRANS KK3 0 1))
		(SETQ P4A (TRANS KK4 0 1))
		(COMMAND "SCP" "U")

		(SETQ P1A (LIST (CAR P1A) (CADR P1A) 0))
		(SETQ P2A (LIST (CAR P2A) (CADR P2A) 0))
		(SETQ P3A (LIST (CAR P3A) (CADR P3A) 0))
		(SETQ P4A (LIST (CAR P4A) (CADR P4A) 0))

		(COMMAND "SCP" "3P" PP0 PPX "")	; PLANO-2D-X
		(SETQ P1AU (TRANS P1A 1 0))
		(SETQ P2AU (TRANS P2A 1 0))
		(SETQ P3AU (TRANS P3A 1 0))
		(SETQ P4AU (TRANS P4A 1 0))
		(COMMAND "SCP" "U")


		;(SETQ COL (+ COL 1))
		;(SETQ COLO (+ (REM COL 5) 1))
		;(COMMAND "COLOR" COLO)

		(COMMAND "3DCARA" P1AU P2AU P4AU P3AU "")	; en 2D

		(SETQ PP0 P3AU PPX P4AU)


		;	CAMBIA VARIABLES																																	

		(SETQ KK1 KK3  KK2 KK4)
		(SETQ P12U-A   P12U-B)

		) ; Cierre Repeat M1

	) ; Cierre Repeat P00

) ;cierre DEFUN PINTA-GENERATRICES

;--------------------------------------------------------------------------------------------------------------------------



;*****************************************************************************************************************************
;																																										
;    *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA*** PROGRAMA*** PROGRAMA*** PROGRAMA*** PROGRAMA***      
;																																										
;*****************************************************************************************************************************

(DEFUN C:POLAR-ESPIRAL-PERFIL-01 (/ )

	(SETVAR "blipmode" 0) (SETVAR "cmdecho" 0) (GRAPHSCR)
	(COMMAND "SCP" "U")
	(COMMAND "-REFENT" "DES")

;	FIJAR VARIABLES EN EL PROGRAMA																															

	(SETQ DIS-G       4.5) 			; DISTANCIA GRADUA 

	(SETQ ANCH      120  )			; SEMI ANCHO DEL CAMINO

	(SETQ NSup/180  1  )			; N de SUPERFICIES en 180 que PINTA 

;																																										

 	;(SETQ NSup/180 (- NN-P 1)) ; ?

	(SETQ QQ1 1)

;	FIJAR VARIABLES FUERA DEL PROGRAMA																														

	(SETQ N-SPLN (CAR (ENTSEL " =============  SELECIONA CURVA-ESPIRAL (SPLINE) "))) (TERPRI)

;	OPERACIONES																																						


	(N-PARTES-DIVIDE)					; DIS-G     => ( N-DIVIDE ) 

	(PUNTOS-SPLIN)							; N-DIVIDE => ( LIS-P-SPLI )  

	;(PINTA-PUNTOS-SPLIN)

	(PUNTOS-BASE)							; LIS-P-BASE   ( P00 )

	(PINTA-GENERATRICES)

;	PARANDO																																							

	(SETVAR "blipmode" 1) (SETVAR "cmdecho" 1)
	(TERPRI) (PROMPT " >>>>>>>>> FIN >>>>>> ") (TERPRI)

) ;cierre DEFUN POLAR-ESPIRAL-PERFIL-01

;*****************************************************************************************************************************
