
;-----------------------------------------------------------------------------------------------------------------------------------------
;																																														
;	( DESARROLLO-KIWI-41a )  de  DESARROLLO-KIWI-41                                                                     07/09/2007			
;																																														
;                                 DIBUJO: HOMOLOGIA AFIN \ ESCULTURA-PAJARO-KIWI-10 Renedo.DWG   CAPAS: 600-calculos                      
;																																														
;                                 PUNTOS INICIO  Plano M34 = E1234 M34 C234                                                               
;                                                 pINI = GIRO de E1234 en M34 un AgINI                                                    
;                                                      A34 = INTER E1234 - C234 con M34 - pINI                                            
;                                                      PA1 = M34 + (Vma34 * DA1)                                                          
;                                                      PB1 = M34 + (Vma34 * DB1)                                                          
;                                                                                                                                         
;                                 RESTO PUNTOS   Plano M23 = C123 M23 E1234                                                               
;                                                      EP2 = INTER C123 - E1234 con M23 - A34                                             
;                                                      PA2 = M23 + (Vme2 * DA2)                                                           
;                                                      PB2 = M23 + (Vme2 * DB2)                                                           
;                                                                                                                                         









;                                                                                                                                         
;####  REVISAR  ##########################################################################################################################
;                                                                                                                                         
;																																														
;							TRANSFORMA PUNTOS de ( SPLINE-3D-ALAVEADA  BASE-EJE ) en ( LINEAS en PLANO ) ELIMINANDO ANGULO de TORSION				
;																																														
;							( RADIOS LINEAS en PLANO ) CORTAN a SPLINE-VERTICES-AyB 2D => DISTANCIAS VERTICES A y B al CENTRO ( BASE-EJE )			
;																																														
;-----------------------------------------------------------------------------------------------------------------------------------------
;																																														
; *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA ***	
;																																														
;  (0) ARRANCANDO																																									
;	(1) FIJAR VARIABLES EN EL PROGRAMA																																		
;	(2) MARGEN EQUAL para VECTORES UNITARIOS  ( 1.01e-008 ) de LIMITE-MAR-INTER-RECT-01 lsp																
;  (3) TOMA de DATOS en PANTALLA																																				
;  (4) CALCULO LISTAS-PUNTOS  LIS-P-SPL-EJE  LIS-P-SPL-AA  LIS-P-SPL-BB   Z = 0.0  2D   =>  (LIS-P-SPL-Ao)    (LIS-P-SPL-Bo)					
;	(6) PLANIFICA SPLINE-3D y RADIOS de CUVATURA   (ELIMINANDO ANGULO de TORSION)        =>  (LIS-LINE-CORTE-M23)    								
;	(7) GRAFICA ANGULOS de TORSION y FLEXION  2D y 3D   (GRAFICA-Ag-TROSIONyFLEXION)																			
;  (8) PUNTOS DE CORTE  ( LIS-LINE-CORTE-M23 ) con ( LIS-P-SPL-Ao y BB-2D )           =>  (LIS-PUN-CORTE-M23-A)   (LIS-PUN-CORTE-M23-B)	
;  (9) DISTANCIAS de  MM12pU  a  P-CORTE-2D-A y 2D-B                                    =>  (LIS-DIS-CORTE-M23-AB)								
; (10) CALCULO de PUNTOS HOMOLOGOS  FORMA-1 (A1 B1 C1 D1)  FORMA-2 (A2 B2 C2 D2)        =>  (LIS-4P-SECC)											
; (11) PINTA PIEL 3DCARAS 3D  PATRONES 2D																																	
; (12) PARANDO																																										
;-----------------------------------------------------------------------------------------------------------------------------------------
;																																														
; *** SUBPROGRAMAS ***																																							
;																																														
;	(PUNTOS-SPLINE_N-SPL) = PUNTEA CURVA a NDIVISIONES ( NDiv N-SPL ) => (LIS-Pun-Spli)																	
;	GRAFICA ANGULOS de TORSION y FLEXION  2D																																
;	PINTA EJES de SECCIONES	      LIS-PUN-MED-CEN-ESF   (( P1 P2 P3 P4) ( MED12 MED23 MED34) ( CIR123 CIR234) ( ESF1234))						
;																																														
;-----------------------------------------------------------------------------------------------------------------------------------------


;-----------------------------------------------------------------------------------------------------------------------------------------
;	(PUNTOS-SPLINE_N-SPL) = PUNTEA CURVA a NDIVISIONES ( NDiv N-SPL ) => (LIS-Pun-Spli)																	
;-----------------------------------------------------------------------------------------------------------------------------------------

(DEFUN PUNTOS-SPLINE_N-SPL (/  )

	(SETQ LIS-Pun-Spli  nil)
	(SETQ	 Elen (MEMBER (ASSOC 10 (ENTGET N-SPL)) (ENTGET N-SPL))					; lista a partir del elemento (incluido)
		    P-1    (CDR (NTH      0              Elen))								; primer elemento
		    P-Uo    (CDR (NTH (- (LENGTH Elen) 1) Elen)) )								; ultimo elemento

	(COMMAND  "COLOR" 1 "PUNTO"  P-1)	(SETQ  N-1P (ENTLAST))						; PINTA Primer Punto (en Base de Datos)
 																										; Nombre ultima entidad principal = 1 punto
	(COMMAND	 "COLOR" 2 "DIVIDE" N-SPL NDiv												; PINTA Punto Divide (en Base de Datos)
			    "COLOR" 5 "PUNTO"  P-Uo       )												; PINTA Ultimo Punto (en Base de Datos)

	;	PUNTOS SECCION X (PX1-PXn) =>  LIS-Pun-Spli																														
	(SETQ	N-P1      nil
		   N-P2      nil
		   N-P2      N-1P
		   LIS-Pun-Spli   nil
		   LIS-Pun-Spli  (LIST (CDR (ASSOC 10 (ENTGET N-1P))))						; LIS-Pun-Spli => 1 punto
		   WW        T )

	(WHILE WW
	  	(SETQ N-P1 (ENTNEXT N-1P))															; nombre entidad siguiente
				
		(IF (= N-P1 nil)	(SETQ WW nil)
			(PROGN
				(SETQ LIS-Pun-Spli (CONS (CDR (ASSOC 10 (ENTGET N-P1))) LIS-Pun-Spli))		; LIS-Pun-Spli => Resto PUNTOS con ULTIMO
				(SETQ  N-1P N-P1 )
				(ENTDEL N-P1)																		; BORRA PUNTO
			) ; pro
		) ; if 
	) ; whi
	(SETQ LIS-Pun-Spli (REVERSE LIS-Pun-Spli))
	(ENTDEL N-P2)																					; BORRA PUNTO

) ;  DEFUN PUNTOS-SPLINE_N-SPL

;-----------------------------------------------------------------------------------------------------------------------------------------


;-----------------------------------------------------------------------------------------------------------------------------------------
;	GRAFICA ANGULOS de TORSION y FLEXION  2D																																
(DEFUN GRAFICA-Ag-TROSIONyFLEXION (/  )

	(SETQ LIS-GRAFICA nil)

	(SETQ NC  -1)
	(SETQ NX 250)
	(REPEAT (LENGTH LIS-PUN-MED-CEN-ESF)
		(SETQ NC (+ NC  1))
		(SETQ NX (+ NX  (/ 100.0 NDiEJ)))																		; Longitud  TOTAL Grafica = 100 

		(SETQ PG1   (NTH 0 (NTH 1 (NTH NC  LIS-4N-4P-3M-2C-1E))))
		(SETQ PG2   (NTH 1 (NTH 1 (NTH NC  LIS-4N-4P-3M-2C-1E))))
		(SETQ PG3   (NTH 2 (NTH 1 (NTH NC  LIS-4N-4P-3M-2C-1E))))
		(SETQ MG23  (NTH 1 (NTH 2 (NTH NC  LIS-4N-4P-3M-2C-1E))))
		(SETQ CC123 (NTH 0 (NTH 3 (NTH NC  LIS-4N-4P-3M-2C-1E))))
		(SETQ CC234 (NTH 1 (NTH 3 (NTH NC  LIS-4N-4P-3M-2C-1E))))

		(SETQ AgTOR (CAL "ANG ( MG23 , CC123 , CC234 , PG2 )"))												; ###  ANGULO de TORSION  ### 
		(IF (> AgTOR 180) (SETQ AgTOR (- AgTOR 360.0)))

		(COMMAND "COLOR" 255 "LINEA" (LIST NX  0.0) (LIST NX  (* 20.0 AgTOR)) "")					; GRAFICA  AgTOR x 30  (2D) 

		(SETQ VGz   (CAL "NOR ( PG1 , PG2 , PG3 )"))
		(SETQ PG2V  (CAL " PG2 + (VEC ( PG1 , PG2 )) "))

		(SETQ AgFLE (CAL "ANG ( PG2 , PG2V , PG3 , PG2 + VGz )"))											; ###  ANGULO de FLEXION  ### 
		(IF (> AgFLE 180) (SETQ AgFLE (- AgFLE 360.0)))

		(COMMAND "COLOR" 2 "LINEA" (LIST NX  60.0) (LIST NX  (+ 60.0 (* 10.0 AgFLE))) "")			; GRAFICA  AgFLE x 10  (2D) 

		(SETQ K23A  (CAL "PLD ( MG23 , CC123 , LONra )"))													; PUNTO GRAFICA a LONra de P2 
		(SETQ K23B  (CAL "PLD ( MG23 , CC234 , LONra )"))
		(SETQ VeTOR (CAL " 30 * AgTOR * (VEC1 ( K23B  , K23A )) "))											; VeTOR x 30 
		(SETQ VeFLE (CAL " 10 * AgFLE * (VEC1 ( CC123 , MG23 )) "))											; VeFLE x 10 
		(SETQ PgTor (CAL " MG23 + VeTOR "))
		(SETQ PgFle (CAL " MG23 + VeFLE "))

		(SETQ LIS-GRAFICA (CONS (LIST MG23 PgTor PgFle ) LIS-GRAFICA ))

	) ; repe NC 

	(SETQ LIS-GRAFICA (REVERSE LIS-GRAFICA))

	;	GRAFICA ANGULOS de TORSION y FLEXION  3D																															

	(SETQ ND  -1)
	(REPEAT (- (LENGTH LIS-GRAFICA) 1)
		(SETQ ND (+ ND  1))

		(SETQ AA0 (NTH 0 (NTH (+ ND 0) LIS-GRAFICA)))   ; (LIST  MG23  PgTor  PgFle )
		(SETQ AA1 (NTH 1 (NTH (+ ND 0) LIS-GRAFICA)))
		(SETQ AA2 (NTH 2 (NTH (+ ND 0) LIS-GRAFICA)))
		(SETQ BB0 (NTH 0 (NTH (+ ND 1) LIS-GRAFICA)))
		(SETQ BB1 (NTH 1 (NTH (+ ND 1) LIS-GRAFICA)))
		(SETQ BB2 (NTH 2 (NTH (+ ND 1) LIS-GRAFICA)))

		(SETQ VTra (CAL "VEC ( [0,0,0] , [250,0,0] )"))
		(SETQ AA0v (CAL " AA0 + VTra "))
		(SETQ AA1v (CAL " AA1 + VTra "))
		(SETQ AA2v (CAL " AA2 + VTra "))
		(SETQ BB0v (CAL " BB0 + VTra "))
		(SETQ BB1v (CAL " BB1 + VTra "))
		(SETQ BB2v (CAL " BB2 + VTra "))

		(COMMAND "COLOR" 1 "3DCARA" AA0v AA1v BB1v BB0v "")  ; TORSION 
		(COMMAND "COLOR" 2 "3DCARA" AA0v AA2v BB2v BB0v "")  ; FLEXION 

	) ; repe ND 

) ;  DEFUN  GRAFICA-Ag-TROSIONyFLEXION 

;-----------------------------------------------------------------------------------------------------------------------------------------



"########################################################################################################################################"
;-----------------------------------------------------------------------------------------------------------------------------------------
; *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA ***	
;-----------------------------------------------------------------------------------------------------------------------------------------
"########################################################################################################################################"


(DEFUN C:DESARROLLO-KIWI-41a ( / )

	;======================================================================================================================================
	;  (00) ARRANCANDO																																							
	;......................................................................................................................................

	(SETVAR "blipmode" 0)
	(SETVAR "cmdecho"  0)
	(GRAPHSCR)
	(COMMAND "-REFENT" "DES")
	(COMMAND "SCP"     "U"  )
	(COMMAND "ORTO"    "DES")

	(TERPRI) (PROMPT " =================================================== ")
	(TERPRI) (PROMPT " >>>> INICIO >>>>>>> DESARROLLO-KIWI-41a >>>>> ")
	(TERPRI) (PROMPT " =================================================== ") (TERPRI)

	(IF (= CAL nil)(COMMAND "ARX" "L" "GEOMCAL.ARX"))		; CARGA CALCULADORA 

	;	(00)																																											
	;======================================================================================================================================


 	;======================================================================================================================================
	;	(01) FIJAR VARIABLES EN EL PROGRAMA																																	
	;......................................................................................................................................

	(SETQ  NDiEJ     80 )				; NDIVIDE  SPLINE-EJE-BASE     
	(SETQ  NDiAB    160 )				; NDIVIDE  SPLINE-VERTICES-AyB 

	(SETQ H-TXT      0.5 )				; ALTURA TEXTO 
	(SETQ mUNI 1.02e-006 )				; MARGEN EQUAL para VECTORES UNITARIOS  ( 1.01e-008 ) de LIMITE-MAR-INTER-RECT-01 lsp 

	;	(01)																																											
	;======================================================================================================================================


 	;======================================================================================================================================
	;  (02) TOMA de DATOS en PANTALLA																																		
	;......................................................................................................................................

 	(TERPRI)  (SETQ N-SPL-EJ (CAR (ENTSEL "--------------  MARCA  SPLINE-BASE-EJE ------ 3D " )))  (TERPRI)
 	(TERPRI)  (SETQ N-SPL-AA (CAR (ENTSEL "--------------  MARCA  PERFIL-IZQUIER - A <== 2D " )))  (TERPRI)
 	(TERPRI)  (SETQ N-SPL-BB (CAR (ENTSEL "--------------  MARCA  PERFIL-DERECHO - B ==> 2D " )))  (TERPRI)

	;	(02)																																											
	;======================================================================================================================================


 	;======================================================================================================================================
	;  (03) CALCULO  LISTAS-PUNTOS     LIS-P-SPL-EJE  LIS-P-SPL-AA  LIS-P-SPL-BB																				
	;......................................................................................................................................

	(SETQ N-SPL N-SPL-EJ   NDiv (* 2 NDiEJ))  (PUNTOS-SPLINE_N-SPL )  (SETQ LIS-P-SPL-EJE LIS-PUN-SPLI )	; (LENGTH LIS-P-SPL-EJE) 161 
	(SETQ N-SPL N-SPL-AA   NDiv      NDiAB )  (PUNTOS-SPLINE_N-SPL )  (SETQ LIS-P-SPL-AA  LIS-PUN-SPLI )	; (LENGTH LIS-P-SPL-AA)  
	(SETQ N-SPL N-SPL-BB   NDiv      NDiAB )  (PUNTOS-SPLINE_N-SPL )  (SETQ LIS-P-SPL-BB  LIS-PUN-SPLI )	; (LENGTH LIS-P-SPL-BB)  

	;	(03)																																											
	;======================================================================================================================================


 	;======================================================================================================================================
	;  (04) AADIR a ( LIS-P-SPL-EJE con 2*NDiEJ ) 3 puntos por DELANTE y por DETRAS y FORMAR LISTA con los IMPARES                       
	;                                         ( Para que COINCIDAD 1y Utima SECCION con ESTREMOS de SPLINE-BASE-EJE )                     
	;......................................................................................................................................


	; AADE 3 PUNTOS POR DETRAS			REVISAR ??																														

	(SETQ LIS-P/MAS-SPL-EJE-A (REVERSE LIS-P-SPL-EJE ))				; (LENGTH LIS-P-SPL-EJE) 161 

	(SETQ PFin4 (NTH 0 LIS-P/MAS-SPL-EJE-A))
	(SETQ PFin3 (NTH 1 LIS-P/MAS-SPL-EJE-A))
	(SETQ PFin2 (NTH 2 LIS-P/MAS-SPL-EJE-A))
	(SETQ PFin1 (NTH 3 LIS-P/MAS-SPL-EJE-A))

	(SETQ VFin12 (CAL "VEC ( PFin1 , PFin2 ) "))
	(SETQ VFin23 (CAL "VEC ( PFin2 , PFin3 ) "))
	(SETQ VFin34 (CAL "VEC ( PFin3 , PFin4 ) "))

	(SETQ PFin5  (CAL " PFin4 + VFin12 "))
	(SETQ PFin6  (CAL " PFin5 + VFin23 "))
	(SETQ PFin7  (CAL " PFin6 + VFin34 "))

	;(COMMAND "COLOR" 7 "PUNTO" PFin1)
	;(COMMAND "COLOR" 7 "PUNTO" PFin2)  (COMMAND "COLOR" 1 "PUNTO" PFin5)
	;(COMMAND "COLOR" 7 "PUNTO" PFin3)  (COMMAND "COLOR" 2 "PUNTO" PFin6)
	;(COMMAND "COLOR" 7 "PUNTO" PFin4)  (COMMAND "COLOR" 4 "PUNTO" PFin7)

	(SETQ LIS-P/MAS-SPL-EJE-A (CONS PFin5  LIS-P/MAS-SPL-EJE-A))				; AADE POR DETRAS 
	(SETQ LIS-P/MAS-SPL-EJE-A (CONS PFin6  LIS-P/MAS-SPL-EJE-A))
	(SETQ LIS-P/MAS-SPL-EJE-A (CONS PFin7  LIS-P/MAS-SPL-EJE-A))


	; AADE 3 PUNTOS POR DELANTE			REVISAR ??																														

	(SETQ LIS-P/MAS-SPL-EJE-A (REVERSE LIS-P/MAS-SPL-EJE-A ))

	(SETQ PIni1 (NTH 0 LIS-P/MAS-SPL-EJE-A))
	(SETQ PIni2 (NTH 1 LIS-P/MAS-SPL-EJE-A))
	(SETQ PIni3 (NTH 2 LIS-P/MAS-SPL-EJE-A))
	(SETQ PIni4 (NTH 3 LIS-P/MAS-SPL-EJE-A))

	(SETQ VIni43 (CAL "VEC ( PIni4 , PIni3 ) "))
	(SETQ VIni32 (CAL "VEC ( PIni3 , PIni2 ) "))
	(SETQ VIni21 (CAL "VEC ( PIni2 , PIni1 ) "))

	(SETQ PIniA  (CAL " PIni1 + VIni43 "))
	(SETQ PIniB  (CAL " PIniA + VIni32 "))
	(SETQ PIniC  (CAL " PIniB + VIni21 "))

	;(COMMAND "COLOR" 7 "PUNTO" PIni1)
	;(COMMAND "COLOR" 7 "PUNTO" PIni2)  (COMMAND "COLOR" 1 "PUNTO" PIniA)
	;(COMMAND "COLOR" 7 "PUNTO" PIni3)  (COMMAND "COLOR" 2 "PUNTO" PIniB)
	;(COMMAND "COLOR" 7 "PUNTO" PIni4)  (COMMAND "COLOR" 4 "PUNTO" PIniC)

	(SETQ LIS-P/MAS-SPL-EJE-A (CONS PIniA  LIS-P/MAS-SPL-EJE-A))				; AADE POR DELANTE 
	(SETQ LIS-P/MAS-SPL-EJE-A (CONS PIniB  LIS-P/MAS-SPL-EJE-A))
	(SETQ LIS-P/MAS-SPL-EJE-A (CONS PIniC  LIS-P/MAS-SPL-EJE-A))				; (LENGTH LIS-P/MAS-SPL-EJE-A) 167 


	; LISTA PUNTOS PARES																																							

	(SETQ LIS-P/MAS-SPL-EJE-B nil)

	(SETQ NM -2 )
	(REPEAT (+ (/ (LENGTH LIS-P/MAS-SPL-EJE-A) 2) 1)
		(SETQ NM (+ NM 2))										; PUNTOS PARES 

		(SETQ P-PAR (NTH NM  LIS-P/MAS-SPL-EJE-A))

		(SETQ LIS-P/MAS-SPL-EJE-B (CONS P-PAR  LIS-P/MAS-SPL-EJE-B))

		;(COMMAND "COLOR" 7 "PUNTO" P-PAR)

	) ; repe

	(SETQ LIS-P/MAS-SPL-EJE-B (REVERSE LIS-P/MAS-SPL-EJE-B ))				; (LENGTH LIS-P/MAS-SPL-EJE-B) 84 

	;	(04)																																											
	;======================================================================================================================================


 	;======================================================================================================================================
	;  (05) PUNTOS ( LIS-P-SPL-AA ) y ( LIS-P-SPL-BB )  Cordenada Z = 0.0  2D   =>  ( LIS-P-SPL-Ao ) y ( LIS-P-SPL-Bo )							
	;......................................................................................................................................

	(SETQ LIS-P-SPL-Ao nil)
	(SETQ LIS-P-SPL-Bo nil)

	(SETQ NZ0 -1 )
	(REPEAT (LENGTH LIS-P-SPL-AA)
		(SETQ NZ0 (+ NZ0 1))
		(SETQ PAz (NTH NZ0  LIS-P-SPL-AA))      (SETQ PAz2D (CAL " XYof( PAz )"))
		(SETQ PBz (NTH NZ0  LIS-P-SPL-BB))      (SETQ PBz2D (CAL " XYof( PBz )"))
		
		(SETQ LIS-P-SPL-Ao (CONS PAz2D  LIS-P-SPL-Ao ))
		(SETQ LIS-P-SPL-Bo (CONS PBz2D  LIS-P-SPL-Bo ))
	) ; repe NZ0 

	(SETQ LIS-P-SPL-Ao (REVERSE LIS-P-SPL-Ao))													; (LENGTH LIS-P-SPL-Ao) 121
	(SETQ LIS-P-SPL-Bo (REVERSE LIS-P-SPL-Bo))													; (LENGTH LIS-P-SPL-Bo) 121

	;	(05)																																											
	;======================================================================================================================================


 	;======================================================================================================================================
	;  (06)	CENTRO CIRCULO y ESFERAS OSCULADORAS de  4 PUNTOS  =>  ( LIS-4N-4P-3M-2C-1E )																	
	;......................................................................................................................................
	(SETQ  CENTRO-CIRCULO-ESFERAS  'SI )  (IF (= CENTRO-CIRCULO-ESFERAS  'SI )  (PROGN

	(SETQ LIS-4N-4P-3M-2C-1E nil)

	(SETQ STOP-1 nil )
	(SETQ STOP-2 nil )
	(SETQ NC -1 )
	(REPEAT (- (LENGTH LIS-P/MAS-SPL-EJE-B) 3)
		(SETQ NC (+ NC 1))

		; PUNTO LIS-P/MAS-SPL-EJE-B  (de 4 en 4)                  ; VEC-12 UNI (P1 P2) 																				

		(SETQ P1a (NTH (+ NC 0) LIS-P/MAS-SPL-EJE-B))      (SETQ N1a (+ NC 0))
		(SETQ P2a (NTH (+ NC 1) LIS-P/MAS-SPL-EJE-B))      (SETQ N2a (+ NC 1))
		(SETQ P3a (NTH (+ NC 2) LIS-P/MAS-SPL-EJE-B))      (SETQ N3a (+ NC 2))
		(SETQ P4a (NTH (+ NC 3) LIS-P/MAS-SPL-EJE-B))      (SETQ N4a (+ NC 3))

		(SETQ V12a  (CAL "VEC1 ( P1a , P2a ) "))
		(SETQ V23a  (CAL "VEC1 ( P2a , P3a ) "))
		(SETQ V34a  (CAL "VEC1 ( P3a , P4a ) "))

		(IF (OR (EQUAL V12a V23a mUNI) (EQUAL V23a V34a mUNI) )															;    COLIMEALES ( P1 P2 P3 P4 ) 
			(PROGN (TERPRI) (PROMPT "-- (P1 P2 P3 P4) ALGUNOS COLIMEALES => (STOP-1) NC= ") (PRIN1 NC) (SETQ STOP-1 T) ))

		(IF (= STOP-1 nil)																											; NO COLIMEALES ( P1 P2 P3 P4 ) 
			(PROGN
				; PUNTO MEDIO (P1 P2)                                       ; VEC-Z    UNI (P1 P2 P3)														
				(SETQ M12a (CAL "PLT ( P1a , P2a , 0.5 )"))
				(SETQ M23a (CAL "PLT ( P2a , P3a , 0.5 )"))                 (SETQ Vz123a (CAL "NOR ( P1a , P2a , P3a )"))
				(SETQ M34a (CAL "PLT ( P3a , P4a , 0.5 )"))                 (SETQ Vz234a (CAL "NOR ( P2a , P3a , P4a )"))

				; VEC-RADI UNI (P1 P2)                                      ; PUN-RADI (M12a  M12v1)														
				(SETQ V1r12  (CAL "NOR ( P1a , P2a , P1a + Vz123a )"))      (SETQ M12v1 (CAL " M12a + V1r12 "))
				(SETQ V1r23  (CAL "NOR ( P2a , P3a , P2a + Vz123a )"))      (SETQ M23v1 (CAL " M23a + V1r23 "))
				(SETQ V2r23  (CAL "NOR ( P2a , P3a , P2a + Vz234a )"))      (SETQ M23v2 (CAL " M23a + V2r23 "))
				(SETQ V2r34  (CAL "NOR ( P3a , P4a , P3a + Vz234a )"))      (SETQ M34v2 (CAL " M34a + V2r34 "))

				; CENTROS CIRCULOS OSCULADORES																																

				(SETQ C123u (CAL "ILP ( M12a , M12v1 ,   M23a , M23v1 , M23a + Vz123a )"))
				(SETQ C234u (CAL "ILP ( M23a , M23v2 ,   M34a , M34v2 , M34a + Vz234a )"))

				; CENTROS ESFERAS OSCULADORAS																																	
				(IF (EQUAL Vz123a Vz234a mUNI)		                                  	                     ;    COPLANARIOS (P1 P2 P3 P4) 
					 (PROGN (TERPRI) (PROMPT "-- (P1 P2 P3 P4) ALGUNOS COPLANARIOS => (STOP-2) NC= ") (PRIN1 NC) (SETQ STOP-2 T) ))

				(IF (= STOP-2 nil)																									; NO COPLANARIOS (P1 P2 P3 P4) 
					(PROGN
						(SETQ C123v (CAL " C123u + Vz123a "))
						(SETQ C234v (CAL " C234u + Vz234a "))

						(SETQ E1234u (CAL "ILP ( C123u , C123v ,   C234u , C234v , M34a )"))
					) ; pro
					(PROGN
						(TERPRI) (PROMPT "---- COPLANARIOS (P1 P2 P3 P4)=> ( NO EJECUTA CENTRO ESFERA )")
					) ; pro
				) ; if
			) ; pro
			(PROGN
				(TERPRI) (PROMPT "---- COLIMEALES (P1 P2 P3 P4)=> ( NO EJECUTA CENTRO CIRCULOS )")
			) ; pro
		) ; if

		;	LISTA PUNTOS       ( LIS-4N-4P-3M-2C-1E )																														

		(SETQ LIS-4N-4P-3M-2C-1E (CONS (LIST   (LIST N1a N2a N3a N4a) (LIST P1a P2a P3a P4a)
															(LIST M12a M23a M34a)  (LIST C123u C234u) (LIST E1234u)) LIS-4N-4P-3M-2C-1E))

	) ; repe NC

	(SETQ LIS-4N-4P-3M-2C-1E-DIREC (REVERSE LIS-4N-4P-3M-2C-1E ))					; (LENGTH LIS-4N-4P-3M-2C-1E-DIREC) 
	(SETQ LIS-4N-4P-3M-2C-1E-INVER          LIS-4N-4P-3M-2C-1E  )					; (LENGTH LIS-4N-4P-3M-2C-1E-INVER) 

	)) ; pro if   CENTRO-CIRCULO-ESFERAS 
	;	(06)																																											
	;======================================================================================================================================


	;======================================================================================================================================
	;  (07)  PINTA PUNTOS SPLINE TODOS de LISTA MODIFICADA ( LIS-P/MAS-SPL-EJE-B )  																			
	;......................................................................................................................................
	(SETQ  PINTA-PUNTOS-SPL-EJE-B  'SI )  (IF (= PINTA-PUNTOS-SPL-EJE-B  'SI )  (PROGN

	(IF (= STOP-1 nil)																												; NO COLIMEALES (P1 P2 P3) 
		(PROGN
			(SETQ NP -1)
			(REPEAT (- (LENGTH LIS-P/MAS-SPL-EJE-B) 1)
				(SETQ NP (+ NP 1))
				(SETQ P1p (NTH (+ NP 0) LIS-P/MAS-SPL-EJE-B))
				(SETQ P2p (NTH (+ NP 1) LIS-P/MAS-SPL-EJE-B))
				(COMMAND "COLOR" 5 "LINEA"  P1p P2p "")
				;(SETQ M12p (CAL "PLT ( P1p , P2p , 0.5 )"))
				;(COMMAND "COLOR" 1 "PUNTO"  M12p)																				; PUNTO M12 
				(SETQ Ag12p  (+ 90 (CAL "ANG ( P1p , P2p )")))
				(COMMAND "COLOR" 5 "PUNTO"  P1p)																					; PUNTO P1 
				;(COMMAND "COLOR" 5 "TEXTO"  P1p  H-TXT  Ag12p  (STRCAT "_P-" (ITOA NP)))
				(IF (= NP (- (LENGTH LIS-P/MAS-SPL-EJE-B) 2))
					(PROGN
						(COMMAND "COLOR" 5 "PUNTO" P2p)																			; PUNTO P2 
						;(COMMAND "COLOR" 5 "TEXTO" P2p  H-TXT  Ag12p  (STRCAT "_P-" (ITOA (+ NP 1))))
					) ; pro
				) ; if
			) ; repe
		) ; pro
		(PROGN
			(TERPRI) (PROMPT "---- COLIMEALES (P1 P2 P3)=> ( NO EJECUTA PINTA PUNTOS )")
		) ; pro
	) ; if

	)) ; pro if   PINTA-PUNTOS-SPL-EJE-B 
	;	(07)																																											
	;======================================================================================================================================


	;======================================================================================================================================
	;	(08) PLANIFICA SPLINE-3D LINEAS-CORTE  => ( LIS-LINE-CORTE-M23 )    (ELIMINANDO ANGULO de TORSION)												
	;																																													
	;               LIS-4N-4P-3M-2C-1E-DIREC  =>  (( N1 N2 N3 N4 ) ( P1 P2 P3 P4 ) ( M12 M23 M34 ) ( C123 C234 ) ( E1234 ))  					
	;......................................................................................................................................
	(SETQ  PLANIFICA-SPLINE-3D-LINEAS-CORTE  'SI )  (IF (= PLANIFICA-SPLINE-3D-LINEAS-CORTE  'SI )  (PROGN

	(SETQ LONra 15.0 )																	; LONGITUD RADIO GRAFICA 
	(SETQ LIS-LINE-CORTE-M23 nil)
 	(SETQ NCTROmc 0 )				 													; NCRNTROL VECTORES OPUESTOS 


	(SETQ PUN1 (NTH 0 LIS-P/MAS-SPL-EJE-B))
	(SETQ PUN2 (NTH 1 LIS-P/MAS-SPL-EJE-B))
	(SETQ DISq (- (DISTANCE PUN1 PUN2 )))
 
	(SETQ QQo (LIST 0.0 DISq 0.0 ))
	(SETQ QQy (LIST 1.0 DISq 0.0 ))

	(SETQ N4P -1)
	(REPEAT (LENGTH LIS-4N-4P-3M-2C-1E-DIREC )
		(SETQ N4P (+ N4P  1))

		(SETQ PP1   (NTH 0 (NTH 1 (NTH N4P  LIS-4N-4P-3M-2C-1E-DIREC))))
		(SETQ PP2   (NTH 1 (NTH 1 (NTH N4P  LIS-4N-4P-3M-2C-1E-DIREC))))
		(SETQ PP3   (NTH 2 (NTH 1 (NTH N4P  LIS-4N-4P-3M-2C-1E-DIREC))))
		(SETQ PP4   (NTH 3 (NTH 1 (NTH N4P  LIS-4N-4P-3M-2C-1E-DIREC))))

		(SETQ MM12  (NTH 0 (NTH 2 (NTH N4P  LIS-4N-4P-3M-2C-1E-DIREC))))
		(SETQ MM23  (NTH 1 (NTH 2 (NTH N4P  LIS-4N-4P-3M-2C-1E-DIREC))))
		(SETQ MM34  (NTH 2 (NTH 2 (NTH N4P  LIS-4N-4P-3M-2C-1E-DIREC))))

		(SETQ CC123 (NTH 0 (NTH 3 (NTH N4P  LIS-4N-4P-3M-2C-1E-DIREC))))
		(SETQ CC234 (NTH 1 (NTH 3 (NTH N4P  LIS-4N-4P-3M-2C-1E-DIREC))))

		; ORIENTACION VECTORES				VECTORES (OPUESTOS)=> (+V1)+(-V2) < Raiz2     (NO OPUESTOS)=> (+V1)+(+V2) > Raiz2 						

		(SETQ V1mc (CAL " VEC1 ( MM12 , CC123 )"))
		(SETQ V2mc (CAL " VEC1 ( MM23 , CC234 )"))

		(IF (< (CAL " ABS(V1mc + V2mc) ") (SQRT 2))  (SETQ NCTROmc (+ NCTROmc 1 )))
		(IF (= (REM NCTROmc 2) 1)                   (SETQ V2mc (CAL " V2mc * -1 ")))

		;																																												

		(SETQ C12K (CAL " MM12 + ( V1mc * LONra )"))							; PUNTO GRAFICA a LONra de M12  (DIRECCION del RADIO)
		(SETQ C23K (CAL " MM23 + ( V2mc * LONra )"))

		(COMMAND "SCP" "3P" MM12  C12K  PP2 )
			(SETQ PP1p  (TRANS PP1  0 1))
			(SETQ PP2p  (TRANS PP2  0 1))
			(SETQ PP3p  (TRANS PP3  0 1))
			(SETQ PP4p  (TRANS PP4  0 1))

			(SETQ MM12p (TRANS MM12 0 1))
			(SETQ MM23p (TRANS MM23 0 1))

			(SETQ C12kp (TRANS C12K 0 1))
			(SETQ C23kp (TRANS C23K 0 1))
		(COMMAND "SCP" "U" )

		(COMMAND "SCP" "3P" QQo QQy "" )

			(COMMAND "COLOR" 7 "PUNTO" PP1p )										; PINTA PUNTO 2D
			(COMMAND "COLOR" 7 "LINEA" PP1p  PP2p "")

			;(SETQ Ag12s  (+ 90 (CAL "ANG ( PP1p , PP2p )"))) (COMMAND "COLOR" 7 "TEXTO"  PP1p  H-TXT  Ag12s  (STRCAT "_P-" (ITOA N4P)))

			(IF (= N4P (- (LENGTH LIS-4N-4P-3M-2C-1E-DIREC ) 1))
				(PROGN
					(COMMAND "COLOR" 7 "PUNTO" PP2p )								; PINTA PUNTO 2D 
					(COMMAND "COLOR" 7 "LINEA" PP2p  PP3p "")

					(COMMAND "COLOR" 7 "PUNTO" PP3p )
					(COMMAND "COLOR" 7 "PUNTO" PP4p )
					(COMMAND "COLOR" 7 "LINEA" PP3p  PP4p "")

					;(SETQ Ag23s  (+ 90 (CAL "ANG ( PP1p , PP2p )"))) (COMMAND "COLOR" 7 "TEXTO"  PP2p  H-TXT  Ag23s  (STRCAT "_P-" (ITOA (+ N4P 1))))
					;(SETQ Ag34s  (+ 90 (CAL "ANG ( PP1p , PP2p )"))) (COMMAND "COLOR" 7 "TEXTO"  PP3p  H-TXT  Ag34s  (STRCAT "_P-" (ITOA (+ N4P 2))))
																					; (COMMAND "COLOR" 7 "TEXTO"  PP4p  H-TXT  Ag34s  (STRCAT "_P-" (ITOA (+ N4P 3))))
				) ; pro
			) ; if

			(SETQ MM12ppU (TRANS MM12p 1 0))      (SETQ MM12pU (CAL " XYof( MM12ppU )"))
			(SETQ MM23ppU (TRANS MM23p 1 0))      (SETQ MM23pU (CAL " XYof( MM23ppU )"))
			(SETQ C12kppU (TRANS C12kp 1 0))      (SETQ C12kpU (CAL " XYof( C12kppU )"))
			(SETQ C23kppU (TRANS C23kp 1 0))      (SETQ C23kpU (CAL " XYof( C23kppU )"))

		(COMMAND "SCP" "U" )

		;(COMMAND "COLOR" 1 "LINEA" MM23pU  C23kpU "")

		(SETQ LIS-LINE-CORTE-M23 (CONS (LIST  MM23pU  C23kpU ) LIS-LINE-CORTE-M23 ))

		(SETQ QQo  MM23pU )
		(SETQ QQy  C23kpU )

	) ; repe N4P 

	(SETQ LIS-LINE-CORTE-M23 (REVERSE LIS-LINE-CORTE-M23))								; (LENGTH LIS-LINE-CORTE-M23 )

	)) ; pro if   PLANIFICA-SPLINE-3D-LINEAS-CORTE 
	;	(08)																																											
	;======================================================================================================================================

	;======================================================================================================================================
	;	(09) GRAFICA ANGULOS de TORSION y FLEXION  2D y 3D																												
	;......................................................................................................................................
	;                                             		    (GRAFICA-Ag-TROSIONyFLEXION) 
	;	(09)																																											
	;======================================================================================================================================

	;======================================================================================================================================
	;  (10) PUNTOS DE CORTE  (LIS-LINE-CORTE-M23) con (LIS-P-SPL-Ao) y (LIS-P-SPL-Bo) => (LIS-PUN-CORTE-M23-A) y (LIS-PUN-CORTE-M23-B)		
	;......................................................................................................................................
	(SETQ  PUNTOS-CORTE  'SI )  (IF (= PUNTOS-CORTE  'SI )  (PROGN

	(SETQ LIS-PUN-CORTE-M23-A nil )
	(SETQ LIS-PUN-CORTE-M23-B nil )

	(SETQ NA  -1)
	(SETQ NB  -1)

	(SETQ NCR -1)
	(REPEAT (LENGTH LIS-LINE-CORTE-M23)		; 81 
		(SETQ NCR (+ NCR 1))

		(SETQ PPo2D (NTH 0 (NTH NCR  LIS-LINE-CORTE-M23)))		; (LIST  MM12pU  C12kpU ) 
		(SETQ PPx2D (NTH 1 (NTH NCR  LIS-LINE-CORTE-M23)))
		(SETQ PPz2D (CAL " PPo2D + [0,0,10] "))


		; PUNTOS CORTE A																																							

		(SETQ WWa T )
		(WHILE WWa																														; LIS-P-SPL-Ao
			(SETQ NA (+ NA 1))
			(IF (> (+ NA 1) (- (LENGTH LIS-P-SPL-Ao) 1))
				(PROGN  (SETQ WWa nil) )
				(PROGN
					(SETQ PA1  (NTH (+ NA 0) LIS-P-SPL-Ao))
					(SETQ PA2  (NTH (+ NA 1) LIS-P-SPL-Ao))
					(SETQ PinA (CAL "ILP ( PA1 , PA2 , PPo2D , PPx2D , PPz2D )")) (SETQ PinA (CAL " XYof( PinA ) ")) ; INTERSEC LINEA-S-A PLANO 
					
					(COND
						((EQUAL PinA PA1 mUNI)
							(COMMAND "COLOR" 255 "LINEA" PPo2D PinA "" )
							(SETQ WWa nil) (SETQ NA (- NA 1)) (SETQ LIS-PUN-CORTE-M23-A (CONS PinA  LIS-PUN-CORTE-M23-A)))

						((EQUAL PinA PA2 mUNI)
							(COMMAND "COLOR" 255 "LINEA" PPo2D PinA "" )
							(SETQ WWa nil) (SETQ NA (- NA 1)) (SETQ LIS-PUN-CORTE-M23-A (CONS PinA  LIS-PUN-CORTE-M23-A)))

						( T
							(SETQ KcorA nil )
							(SETQ D0a (CAL "DIST ( PA1  , PA2  )"))
							(SETQ D1a (CAL "DIST ( PA1  , PinA )"))
							(SETQ D2a (CAL "DIST ( PinA , PA2  )"))
							(IF (EQUAL D0a (+ D1a D2a) mUNI)
								(PROGN
									(SETQ KcorA T )
									(SETQ WWa nil)
									(SETQ NA (- NA 1))
									(COMMAND "COLOR" 1 "LINEA" PPo2D PinA "" )							; VECTOR VERTICE-A   2D 
									(SETQ LIS-PUN-CORTE-M23-A (CONS PinA  LIS-PUN-CORTE-M23-A))
								) ; pro 
							) ; if
						) ; conAT 
					) ; con
				) ; pro
			) ; if
		) ; WWa

		(IF (= KcorA nil ) (PROGN (TERPRI) (PROMPT " >>>>  NO PUNTO-CORTE-A   en NCR = ") (PRIN1 NCR ) (TERPRI)))


		; PUNTOS CORTE B																																							

		(SETQ WWb T )
		(WHILE WWb																															; LIS-P-SPL-Bo 
			(SETQ NB (+ NB 1))
			(IF (> (+ NB 1) (- (LENGTH LIS-P-SPL-Bo) 1))
				(PROGN  (SETQ WWb nil)) ; pro
				(PROGN
					(SETQ PB1  (NTH (+ NB 0) LIS-P-SPL-Bo))
					(SETQ PB2  (NTH (+ NB 1) LIS-P-SPL-Bo))
					(SETQ PinB (CAL "ILP ( PB1 , PB2 , PPo2D , PPx2D , PPz2D )")) (SETQ PinB (CAL " XYof( PinB ) "))  ; INTERSE LINEA-S-B PLANO 
					
					(COND
						((EQUAL PinB PB1 mUNI)
							(COMMAND "COLOR" 255 "LINEA" PPo2D PinB "" )
							(SETQ WWb nil) (SETQ NB (- NB 1)) (SETQ LIS-PUN-CORTE-M23-B (CONS PinB  LIS-PUN-CORTE-M23-B)))

						((EQUAL PinB PB2 mUNI)
							(COMMAND "COLOR" 255 "LINEA" PPo2D PinB "" )
							(SETQ WWb nil) (SETQ NB (- NB 1)) (SETQ LIS-PUN-CORTE-M23-B (CONS PinB  LIS-PUN-CORTE-M23-B)))

						( T
							(SETQ KcorB nil )
							(SETQ D0b (CAL "DIST ( PB1  , PB2  )"))
							(SETQ D1b (CAL "DIST ( PB1  , PinB )"))
							(SETQ D2b (CAL "DIST ( PinB , PB2  )"))
							(IF (EQUAL D0b (+ D1b D2b) mUNI)
								(PROGN
									(SETQ KcorB T )
									(SETQ WWb nil)
									(SETQ NB (- NB 1))
									(COMMAND "COLOR" 2 "LINEA" PPo2D PinB "" )							; VECTOR VERTICE-B   2D 
									(SETQ LIS-PUN-CORTE-M23-B (CONS PinB  LIS-PUN-CORTE-M23-B))
								) ; pro
							) ; if 
						) ; conBT
					) ; con
				) ; pro
			) ; if
		) ; WWb

		(IF (= KcorB nil ) (PROGN (TERPRI) (PROMPT " >>>>  NO PUNTO-CORTE-B   en NCR = ") (PRIN1 NCR ) (TERPRI)))

	) ; repe NCR

	(SETQ LIS-PUN-CORTE-M23-A (REVERSE LIS-PUN-CORTE-M23-A ))															; (LENGTH LIS-PUN-CORTE-M23-A) 80 
	(SETQ LIS-PUN-CORTE-M23-B (REVERSE LIS-PUN-CORTE-M23-B ))															; (LENGTH LIS-PUN-CORTE-M23-B) 80 

	(SETQ NP-CoA (LENGTH LIS-PUN-CORTE-M23-A))
	(SETQ NP-CoB (LENGTH LIS-PUN-CORTE-M23-B))
	(IF (= NP-CoA  NP-CoB )
	 (PROGN (TERPRI) (PROMPT " >>>>  IGUALES NPUN-CORTE A/B ") (PRIN1 NP-CoA) (PROMPT "/") (PRIN1 NP-CoB) (PROMPT " ( BIEN )") (TERPRI))
	 (PROGN (TERPRI) (PROMPT " >> NO IGUALES NPUN-CORTE A/B ") (PRIN1 NP-CoA) (PROMPT "/") (PRIN1 NP-CoB) (PROMPT " ( MAL ) ") (TERPRI))
	) ; if

	)) ; pro if   PUNTOS-CORTE 
	;	(10)																																											
	;======================================================================================================================================

	;======================================================================================================================================
	;  (11) DISTANCIAS de  MM12pU  a  P-CORTE-2D-A y 2D-B   (LIS-DIS-CORTE-M23-AB)																			
	;......................................................................................................................................
	(SETQ  DISTANCIAS-CORTE  'SI )  (IF (= DISTANCIAS-CORTE  'SI )  (PROGN

	(SETQ LIS-DIS-CORTE-M23-AB nil )

	(SETQ NDI -1)
	(REPEAT (LENGTH LIS-PUN-CORTE-M23-A)		; 80 
		(SETQ NDI (+ NDI 1))

		(SETQ PDisA (NTH NDI LIS-PUN-CORTE-M23-A ))				; (LIST  PinA) 
		(SETQ PDisB (NTH NDI LIS-PUN-CORTE-M23-B ))				; (LIST  PinB) 

		(SETQ PDo (NTH 0 (NTH NDI LIS-LINE-CORTE-M23)))		; (LIST  MM12pU  C12kpU ) 
		(SETQ PDx (NTH 1 (NTH NDI LIS-LINE-CORTE-M23)))

		(COMMAND "SCP" "3P" PDo PDx "" )
			(SETQ PDisAd (TRANS PDisA 0 1 ))
			(SETQ PDisBd (TRANS PDisB 0 1 ))
		(COMMAND "SCP" "U" )

		(SETQ DisA (CAR PDisAd))
		(SETQ DisB (CAR PDisBd))

		(SETQ LIS-DIS-CORTE-M23-AB (CONS (LIST DisA  DisB ) LIS-DIS-CORTE-M23-AB ))

	) ; repe NDI

	(SETQ LIS-DIS-CORTE-M23-AB-DIREC (REVERSE LIS-DIS-CORTE-M23-AB ))											; (LENGTH LIS-DIS-CORTE-M23-AB-DIREC) 80 

	)) ; pro if   DISTANCIAS-CORTE 
  	;	(11)																																											
	;======================================================================================================================================


	;--------------------------------------------------------------------------------------------------------------------------------------
	;  ( LIS-4N-4P-3M-2C-1E )   (LIST          N1         N2         N3         N4         ) N del PUNTO                                  
	;                           (LIST          P1         P2         P3         P4         ) PUNTO                                         
	;                           (LIST               M12        M23        M34              ) PUNTO MEDIO                                   
	;                           (LIST                    C123       C234                   ) CEN-CIRCULO OSCULADOR                         
	;                           (LIST                         E1234                        ) CEN-ESFERA  OSCULADORA                        
	;--------------------------------------------------------------------------------------------------------------------------------------
	;  Plano M12 =  M12  C123  E1234   LIS-4N-4P-3M-2C-1E-DIREC   =>  ((N1 N2 N3 N4) (P1 P2 P3 P4) (M12 M23 M34) (C123 C234) (E1234))      
	;  Plano M23 =  M23  C123  E1234                                                                                                       
	;  Plano M34 =  M34  C234  E1234   LIS-DIS-CORTE-M23-AB-DIREC =>  ( DisA  DisB )                                                       
	;--------------------------------------------------------------------------------------------------------------------------------------


				;                                                                                                                          
				;  DIBUJO: HOMOLOGIA AFIN \ ESCULTURA-PAJARO-KIWI-10 Renedo.DWG   CAPAS: 603 - PLANOS NORMALES EXAGONALES 1 y CALCULOS 3   
				;                                                                       ;                                                  
				;                                                         /             ;                          O PA1                   
				;                                                       (O)(EP1)        ;                         /|\                      
				;                                                     o /               ;                        / | \                     
				;                                                   o  / o              ;                       /  |  \                    
				;                                                 o   /                 ;                      / DM12A \                   
				;                                               o    /  o               ;                     /    |    \                  
				;                                            o      /                   ;                PC1 O     O M12 O PD1             
				;                                          o       /   o                ;                   / \    |    / \                
				;                                        o        /                     ;    ________      /   \ DM12B /   \               
				;                                      o         /    o                 ;    PLANO-12     /     \  |  /     \              
				;                                   o           /                       ;                /       \ | /       \             
				;                                 o            /     o                  ;               /         \|/         \            
				;                               o             /                         ;              /           O PB1       \           
				;                             o              /      o                   ;             /           /|\           \          
				;                     pINI (O)              /                           ;            /           / | \           \         
				;                        o                 /       o                    ;           /           /  EP1\           \        
				;  O P1                o                  /                       P4 O  ;   -------o-----------o---O---o-----------o-------
				;   \           -----o----------         /--------o------           /   ;    ChAC12 \    ChBD12 \  |  / ChBC12    / ChAD12 
				;    \         /  o             \       / PLANO-34       \         /    ;            \           \ | /           /         
				;     \       / o                \     /         o        \       /     ;             \           \|/           /          
				;      \     /o  AgINI            \   /                    \     /      ;              \           O PB2       /           
				;       \   o                 E1234\ /          o           \   /       ;               \         /|\         /            
				;    M12 O------------------------- O -------------------------O M34    ;                \       / | \       /             
				;         \ \   ________           /|\         o ________   / /         ;    ________     \     /  |  \     /              
				;          \ \  PLANO-12          / | \          PLANO-34  / /          ;    PLANO-23      \   / DM23B \   /               
				;           \ \                  /  |  \      o           / /           ;                   \ /    |    \ /                
				;            \ \            C123/   |   C234             / /            ;                PC2 O     O M23 O PD2             
				;             \ -------------- O    |    O --o----------- /             ;                   / \    |    / \                
				;              \               |____|___ |\ o            /              ;                  /   \ DM23A /   \               
				;               \              |PLANO-23 |(O)(EP2)      /               ;                 /     \  |  /     \              
				;                \             |    |    |o \          /                ;                /       \ | /       \             
				;                 \            |    |    o   \        /                 ;               /         \|/         \            
				;                  \           |    |   o|    \      /                  ;              /           O PA2       \           
				;                   \           \   |  o/      \    /                   ;             /           /|\           \          
				;                    \           \  | o/           /                    ;            /           / | \           \         
				;                     \           \ |o/           /                     ;    ChAC23 /    ChBD23 /  |  \ ChBC23    \ ChAD23 
				;                      O------------O------------O                      ;   -------o-----------o---O---o-----------o-------
				;                    P2            M23            P3                    ;    ________              EP2                     
				;                                                                       ;    PLANO-34                                      
				;                                                                       ;                                                  

				;--------------------------------------------------------------------------------------------------------------------------
				;  PLANOS REALES    PLANO-12   PLANO-23   PLANO-34   PLANO-45   PLANO-56   PLANO-67   PLANO-78   PLANO-89                  
				;--------------------------------------------------------------------------------------------------------------------------
				;  NE = 0  =>      PLANO-12   PLANO-23   PLANO-34                                                                         
				;  NE = 1  =>                 PLANO-12   PLANO-23   PLANO-34                                                              
				;  NE = 2  =>                            PLANO-12   PLANO-23   PLANO-34                                                   
				;  NE = 3  =>                                       PLANO-12   PLANO-23   PLANO-34                                        
				;  NE = 4  =>                                                  PLANO-12   PLANO-23   PLANO-34                             
				;  NE = 5  =>                                                             PLANO-12   PLANO-23   PLANO-34                  
				;--------------------------------------------------------------------------------------------------------------------------

				;--------------------------------------------------------------------------------------------------------------------------
				;  PUNTOS INICIO  NE = 0      PLANO-12 = ez(M12 P2) = M12 E1234 C123                                                      
				;--------------------------------------------------------------------------------------------------------------------------
				;  pINI = GIRO SCPez EjeX PLANO-12 CENTRO (M12) AgINI                                                                    	
				;                                                                                                                          
				;  EP1 = INTERSEC (C123 - E1234) con (M12 - pINI)      PA1 = M12 + (Vme1 * DM12A)      PB1 = M12 + (Vme1 * DM12B)      		
				;  EP2 = INTERSEC (C234 - E1234) con (M23 - EP1)       PA2 = M23 + (Vme2 * DM23A)      PB2 = M23 + (Vme2 * DM23B)      		
				;--------------------------------------------------------------------------------------------------------------------------
				;  RESTO PUNTOS   NE = n      PLANO-23 = ez(M23 P3) = M23 E1234 C234                                                      
				;--------------------------------------------------------------------------------------------------------------------------
				;  EP2 = INTERSEC (C234 - E1234) con (M23 - EP1)         PA2 = M23 + (Vme2 * DM23A)      PB2 = M23 + (Vme2 * DM23B)    		
				;--------------------------------------------------------------------------------------------------------------------------


 	;======================================================================================================================================
  	;  (12) PINTA EJES-EVOLUTA con AgINI y (LIS-DIS-CORTE-M23-AB) (LIS-4N-4P-3M-2C-1E-DIREC)                                               
	;                                                                                                                                      
	(SETQ  PINTA-EJES-EVOLUTA  'SI )  (IF (= PINTA-EJES-EVOLUTA  'SI )  (PROGN

	(IF (AND (= STOP-1 nil) (= STOP-2 nil))															; NO-COLIMEALES  NO-COPLANARIOS 
		(PROGN

			(SETQ AgINI -45.551 )     							; AgINI al EJE(M23 C123) /= 90y270      ANGULO INICIO PUNTO (pINI) 
			(SETQ AgVER  45.0   )     							; ANGULO INICIO VERTICES 1SECCION  

			(SETQ LIS-4P-SECC nil )

			(SETQ NOri 0 )																					; NCRNTROL ORIENTACION VECTORES OPUESTOS 
			(SETQ NE  -1) 																					; ENPIEZA por PRINCIPIO 

			(REPEAT (LENGTH LIS-4N-4P-3M-2C-1E-DIREC)													; IGUAL que (LENGTH LIS-DIS-CORTE-M23-AB-DIREC) 
				(SETQ NE  (+ NE  1))

				;  LIS-4N-4P-3M-2C-1E-DIREC  =>  (( N1 N2 N3 N4 ) ( P1 P2 P3 P4 ) ( M12 M23 M34 ) ( C123 C234 ) ( E1234 ))  						

				(SETQ N1    (NTH 0 (NTH 0 (NTH NE  LIS-4N-4P-3M-2C-1E-DIREC))))			; (LENGTH LIS-4N-4P-3M-2C-1E-DIREC) 81 
				(SETQ N2    (NTH 1 (NTH 0 (NTH NE  LIS-4N-4P-3M-2C-1E-DIREC))))			; (LENGTH LIS-P/MAS-SPL-EJE-B)      84 
				(SETQ N3    (NTH 2 (NTH 0 (NTH NE  LIS-4N-4P-3M-2C-1E-DIREC))))
				(SETQ N4    (NTH 3 (NTH 0 (NTH NE  LIS-4N-4P-3M-2C-1E-DIREC))))
 
				(SETQ P1    (NTH 0 (NTH 1 (NTH NE  LIS-4N-4P-3M-2C-1E-DIREC))))
				(SETQ P2    (NTH 1 (NTH 1 (NTH NE  LIS-4N-4P-3M-2C-1E-DIREC))))
				(SETQ P3    (NTH 2 (NTH 1 (NTH NE  LIS-4N-4P-3M-2C-1E-DIREC))))
				(SETQ P4    (NTH 3 (NTH 1 (NTH NE  LIS-4N-4P-3M-2C-1E-DIREC))))
 
				(SETQ M12   (NTH 0 (NTH 2 (NTH NE  LIS-4N-4P-3M-2C-1E-DIREC))))
				(SETQ M23   (NTH 1 (NTH 2 (NTH NE  LIS-4N-4P-3M-2C-1E-DIREC))))
				(SETQ M34   (NTH 2 (NTH 2 (NTH NE  LIS-4N-4P-3M-2C-1E-DIREC))))
 
				(SETQ C123  (NTH 0 (NTH 3 (NTH NE  LIS-4N-4P-3M-2C-1E-DIREC))))
				(SETQ C234  (NTH 1 (NTH 3 (NTH NE  LIS-4N-4P-3M-2C-1E-DIREC))))
 
				(SETQ E1234 (NTH 0 (NTH 4 (NTH NE  LIS-4N-4P-3M-2C-1E-DIREC))))

				;	LIS-DIS-CORTE-M23-AB-DIREC =>  ( DisA  DisB ) 																									

				(SETQ DM23A (NTH 0 (NTH (+ NE 0)  LIS-DIS-CORTE-M23-AB-DIREC)))			; (LENGTH LIS-DIS-CORTE-M23-AB-DIREC) 80 
				(SETQ DM23B (NTH 1 (NTH (+ NE 0)  LIS-DIS-CORTE-M23-AB-DIREC)))


				(IF (= NE 0)
					(PROGN
						; 1-0  --------------------------------------------------------------------------------------------------
						; PUNTOS INICIO 1PLANO-23 NE=0 = 2PLANO-12 NE=1         PLANO-23 = ez(M23 P3) = M23 E1234 C123 C234	

						(COMMAND "SCP" "3P" M23 C123 E1234 )
							(SETQ pINIp (LIST (* (COS (* (/ PI 180) AgINI)) 100)
													(* (SIN (* (/ PI 180) AgINI)) 100) 0.0 ))
							(SETQ pINI  (TRANS pINIp 1 0 ))												; pINI 

						(COMMAND "SCP" "U" )
	
						(SETQ Vme1 (CAL "VEC1 ( M23 , pINI )"))

						(SETQ VA1  (CAL " M23 + (Vme1 * DM23A)"))													; VERTICE-A1   VA1  3D 
						(SETQ VB1  (CAL " M23 + (Vme1 * DM23B)"))													; VERTICE-B1   VB1  3D 

						;(SETQ EP1  (CAL "ILP  ( C123 , E1234 ,  M23 , pINI , P3 )"))						; ARISTA-1    EP1

						(SETQ EP2  (CAL "ILP  ( E1234 , C234 ,  M23 , pINI , P3 )"))						; ARISTA-2    EP2

						; 2-0  --------------------------------------------------------------------------------------------------
						; SECCION INICIO 1PLANO-23 NE=0 = 2PLANO-12 NE=1        INTERSECCION  PLANO-23 PLANO-34 = E1234 C234 

						(COMMAND "SCP" "3P" M23 C123 E1234 )

							(SETQ VA1pp (TRANS VA1 0 1 ))         (SETQ VA1p (CAL "XYof( VA1pp )"))
							(SETQ VB1pp (TRANS VB1 0 1 ))         (SETQ VB1p (CAL "XYof( VB1pp )"))

							; VERTICES INICIO  1CUADRILATERO          ANGULOS	(AgVER)															

							(SETQ pACg  (CAL "ROT ( VB1p , VA1p , (- AgVER) )"))				; ROT(P1,Po,Ag)
							(SETQ pADg  (CAL "ROT ( VB1p , VA1p ,    AgVER  )"))

							(SETQ pBCg  (CAL "ROT ( VA1p , VB1p ,    AgVER  )"))
							(SETQ pBDg  (CAL "ROT ( VA1p , VB1p , (- AgVER) )"))

							(SETQ VC1pp (CAL "ILL ( VA1p , PACg ,  VB1p , PBCg )"))    (SETQ VC1p (CAL "XYof( VC1pp )"))
							(SETQ VD1pp (CAL "ILL ( VA1p , PADg ,  VB1p , PBDg )"))    (SETQ VD1p (CAL "XYof( VD1pp )"))

							(SETQ VC1 (TRANS VC1p 1 0 ))																	; VERTICE-C1   VC1  3D 
							(SETQ VD1 (TRANS VD1p 1 0 ))																	; VERTICE-D1   VD1  3D 

						; 3-0  --------------------------------------------------------------------------------------------------
						; P-CHARNELA INICIO 1PLANO-23 NE=0 = 2PLANO-12 NE=1    INTERSECCION  PLANO-23 PLANO-34 =  E1234 C234 

							(SETQ CH1App  (TRANS E1234 0 1 ))                          (SETQ CH1Ap  (CAL "XYof( CH1App )"))
							(SETQ CH1Bpp  (TRANS C234  0 1 ))                          (SETQ CH1Bp  (CAL "XYof( CH1Bpp )"))

							(SETQ CHac1pp (CAL "ILL ( VA1p , VC1p , CH1Ap , CH1Bp )")) (SETQ CHac1p (CAL "XYof( CHac1pp )"))
							(SETQ CHad1pp (CAL "ILL ( VA1p , VD1p , CH1Ap , CH1Bp )")) (SETQ CHad1p (CAL "XYof( CHad1pp )"))
							(SETQ CHbc1pp (CAL "ILL ( VB1p , VC1p , CH1Ap , CH1Bp )")) (SETQ CHbc1p (CAL "XYof( CHbc1pp )"))
							(SETQ CHbd1pp (CAL "ILL ( VB1p , VD1p , CH1Ap , CH1Bp )")) (SETQ CHbd1p (CAL "XYof( CHbd1pp )"))

							(SETQ CHac1 (TRANS CHac1p 1 0 ))															; CHARNELA  CHac1  3D 
							(SETQ CHad1 (TRANS CHad1p 1 0 ))															; CHARNELA  CHad1  3D 
							(SETQ CHbc1 (TRANS CHbc1p 1 0 ))															; CHARNELA  CHbc1  3D 
							(SETQ CHbd1 (TRANS CHbd1p 1 0 ))															; CHARNELA  CHbd1  3D 
						(COMMAND "SCP" "U" )


						; 4-0  TRATA RESULTADOS INICIO																									

						(COMMAND "COLOR"   1 "LINEA" M23  VA1 "")
						(COMMAND "COLOR"   2 "LINEA" M23  VB1 "")
						(COMMAND "COLOR"   7 "LINEA" VA1  VC1 "")
						(COMMAND "COLOR" 255 "LINEA" VA1  VD1 "")
						(COMMAND "COLOR" 255 "LINEA" VB1  VC1 "")
						(COMMAND "COLOR"   7 "LINEA" VB1  VD1 "")

						(COMMAND "COLOR"   1 "PUNTO" VA2 )
						(COMMAND "COLOR"   2 "PUNTO" VB2 )
						(COMMAND "COLOR"   3 "PUNTO" VC2 )
						(COMMAND "COLOR"   4 "PUNTO" VD2 )

						;(COMMAND "COLOR" 7 "3DCARA"   VA1  VC1  VB1  VD1 "")
						(SETQ LIS-4P-SECC (CONS (LIST VA1  VC1  VB1  VD1 ) LIS-4P-SECC ))

					) ; pro 

					;-----------------------------------------------------------------------------------------------------------


					;-----------------------------------------------------------------------------------------------------------

					(PROGN
						; 1-N  --------------------------------------------------------------------------------------------------
						; PUNTOS RESTANTES 2PLANO-23 NE=n = 1PLANO-34 NE=0       PLANO-23 = ez(M23 P3) = M23 E1234 C123 C234	

						(SETQ EP1 EP2 )

						(SETQ Vme2 (CAL " VEC1 ( M23 , EP1 )"))							; VECTOR ORIENTACION

						(IF (< (CAL " ABS( Vme1 + Vme2 ) ") (SQRT 2)) (SETQ NOri (+ NOri 1)))
						(IF (= (REM NOri 2) 1)  (SETQ VEori (CAL " Vme2 * -1 ")) (SETQ VEori  Vme2 ))
						(SETQ Vme1  Vme2 )

						(SETQ VA2   (CAL " M23 + (VEori * DM23A)"))													; VERTICE-A2   VA2  3D 
						(SETQ VB2   (CAL " M23 + (VEori * DM23B)"))													; VERTICE-B2   VB2  3D 

						(SETQ EP2  (CAL "ILP ( E1234 , C234 ,  M23 , EP1 , P3 )"))								; ARISTA-2    EP2     

						; 2-N  --------------------------------------------------------------------------------------------------
						; SECCION RESTANTES 2PLANO-23      NE = 1..N          INTERSECCION  PLANO-23 PLANO-34 = E1234 C234 		

						(COMMAND "SCP" "3P" M23 C123 E1234 )

							(SETQ CHac1pp (TRANS CHac1 0 1 ))    (SETQ CHac1p (CAL "XYof( CHac1pp )"))
							(SETQ CHad1pp (TRANS CHad1 0 1 ))    (SETQ CHad1p (CAL "XYof( CHad1pp )"))
							(SETQ CHbc1pp (TRANS CHbc1 0 1 ))    (SETQ CHbc1p (CAL "XYof( CHbc1pp )"))
							(SETQ CHbd1pp (TRANS CHbd1 0 1 ))    (SETQ CHbd1p (CAL "XYof( CHbd1pp )"))

							(SETQ VA2pp  (TRANS VA2 0 1 ))       (SETQ VA2p   (CAL "XYof( VA2pp )"))
							(SETQ VB2pp  (TRANS VB2 0 1 ))       (SETQ VB2p   (CAL "XYof( VB2pp )"))

							(SETQ VC2pp (CAL "ILL ( VA2p , CHac1p , VB2p , CHbc1p )"))  (SETQ VC2p (CAL "XYof( VC2pp )"))
							(SETQ VD2pp (CAL "ILL ( VA2p , CHad1p , VB2p , CHbd1p )"))  (SETQ VD2p (CAL "XYof( VD2pp )"))

							(SETQ VC2 (TRANS VC2p 1 0 ))																	; VERTICE-C2   VC2  3D 
							(SETQ VD2 (TRANS VD2p 1 0 ))																	; VERTICE-D2   VD2  3D 

						; 3-N  --------------------------------------------------------------------------------------------------
						; P-CHARNELA RESTANTES 2PLANO-23   NE = 1..N          INTERSECCION  PLANO-23 PLANO-34  =  E1234 C234 	

							(SETQ CH2App  (TRANS E1234 0 1 ))                             (SETQ CH2Ap  (CAL "XYof( CH2App )"))
							(SETQ CH2Bpp  (TRANS C234  0 1 ))                             (SETQ CH2Bp  (CAL "XYof( CH2Bpp )"))

							(SETQ CHac2pp (CAL "ILL ( VA2p , VC2p , CH2Ap , CH2Bp )"))    (SETQ CHac2p (CAL "XYof( CHac2pp )"))
							(SETQ CHad2pp (CAL "ILL ( VA2p , VD2p , CH2Ap , CH2Bp )"))    (SETQ CHad2p (CAL "XYof( CHad2pp )"))
	 						(SETQ CHbc2pp (CAL "ILL ( VB2p , VC2p , CH2Ap , CH2Bp )"))    (SETQ CHbc2p (CAL "XYof( CHbc2pp )"))
							(SETQ CHbd2pp (CAL "ILL ( VB2p , VD2p , CH2Ap , CH2Bp )"))    (SETQ CHbd2p (CAL "XYof( CHbd2pp )"))

							(SETQ CHac2 (TRANS CHac2p 1 0 ))															; CHARNELA  CHac2  3D 
							(SETQ CHad2 (TRANS CHad2p 1 0 ))															; CHARNELA  CHad2  3D 
							(SETQ CHbc2 (TRANS CHbc2p 1 0 ))															; CHARNELA  CHbc2  3D 
							(SETQ CHbd2 (TRANS CHbd2p 1 0 ))															; CHARNELA  CHbd2  3D 
						(COMMAND "SCP" "U" )


						; 4-N  TRATA RESULTADOS RESTANTES																								

						(COMMAND "COLOR"   1 "LINEA" M23  VA2 "")
						(COMMAND "COLOR"   2 "LINEA" M23  VB2 "")
						(COMMAND "COLOR"   7 "LINEA" VA2  VC2 "")
						(COMMAND "COLOR" 255 "LINEA" VA2  VD2 "")
						(COMMAND "COLOR" 255 "LINEA" VB2  VC2 "")
						(COMMAND "COLOR"   7 "LINEA" VB2  VD2 "")

						(COMMAND "COLOR"   1 "PUNTO" VA2 )
						(COMMAND "COLOR"   2 "PUNTO" VB2 )
						(COMMAND "COLOR"   3 "PUNTO" VC2 )
						(COMMAND "COLOR"   4 "PUNTO" VD2 )

						;(COMMAND "COLOR" 7 "3DCARA"   VA2  VC2  VB2  VD2 "")
						(SETQ LIS-4P-SECC (CONS (LIST VA2  VC2  VB2  VD2 ) LIS-4P-SECC ))

						(SETQ  CHac1  CHac2 )
						(SETQ  CHad1  CHad2 )
						(SETQ  CHbc1  CHbc2 )
						(SETQ  CHbd1  CHbd2 )

					) ; pro 
			  
				) ; if NE=0 
			) ; repe NE 




			;	PINTA BORDES EJES EVOLUTA	2D  3D																															

			(SETQ NEE -1)
			(REPEAT (- (LENGTH LIS-4P-SECC) 1)  ; (LIST VA2  VC2  VB2  VD2 )
				(SETQ NEE (+ NEE 1))

				(SETQ PAA1 (NTH 0 (NTH (+ NEE 0)  LIS-4P-SECC)))
				(SETQ PCC1 (NTH 1 (NTH (+ NEE 0)  LIS-4P-SECC)))
				(SETQ PBB1 (NTH 2 (NTH (+ NEE 0)  LIS-4P-SECC)))
				(SETQ PDD1 (NTH 3 (NTH (+ NEE 0)  LIS-4P-SECC)))

				(SETQ PAA2 (NTH 0 (NTH (+ NEE 1)  LIS-4P-SECC)))
				(SETQ PCC2 (NTH 1 (NTH (+ NEE 1)  LIS-4P-SECC)))
				(SETQ PBB2 (NTH 2 (NTH (+ NEE 1)  LIS-4P-SECC)))
				(SETQ PDD2 (NTH 3 (NTH (+ NEE 1)  LIS-4P-SECC)))

				(COMMAND "COLOR" 7 "LINEA" PAA1  PAA2 "")
				(COMMAND "COLOR" 7 "LINEA" PCC1  PCC2 "")
				(COMMAND "COLOR" 7 "LINEA" PBB1  PBB2 "")
				(COMMAND "COLOR" 7 "LINEA" PDD1  PDD2 "")

			) ; repe

		) ; pro

		(PROGN
				(TERPRI) (PROMPT "---- COLIMEALES o COPLANARIOS => ( NO EJECUTA PINTA-EVOLUTA )")
		) ; pro
	) ; if


	)) ; pro if   PINTA-EJES-EVOLUTA
	;	(12)																																											
 	;======================================================================================================================================


 	;======================================================================================================================================
	;  (13) PINTA-3DCARAS  3D 2D Patrones																																	
	;......................................................................................................................................
	(SETQ  PINTA-3DCARAS-3D-2D  'SI )  (IF (= PINTA-3DCARAS-3D-2D  'SI )  (PROGN

		(SETQ KKx  130 )																					; PUNTO OREGEN 1PATRONES 
		(SETQ KKy    0 )

		(SETQ SEPA 110 )																					; SEPARACION ENTRE PATRONES 

		(SETQ DESf 710 )																			; DESPLAZAMIENTO FIGURA 3DC 

		; PINTA 4 SUPERFICIES EXTERNAS																																		

		(SETQ NP1 -1)
		(REPEAT 4																							; 4 CARAS    (LENGTH (NTH 0 LIS-4P-SECC)) 
			(SETQ NP1 (+ NP1 1))
			(SETQ NP2 (+ NP1 1)) (IF (= NP2 4) (SETQ NP2 0)  )

			(SETQ KKx (+ KKx SEPA ))																	; SEPARACION ENTRE PATRONES 

			(SETQ KK1 (LIST    KKx     KKy  0 ))
			(SETQ KK2 (LIST (+ KKx 1)  KKy  0 ))

			(SETQ NCA -1)
			(REPEAT (- (LENGTH LIS-4P-SECC) 1)
				(SETQ NCA (+ NCA 1))

				(SETQ AA1 (NTH NP1 (NTH (+ NCA 0)  LIS-4P-SECC )))							; (LIST  AA1  BB1  CC1  DD1 ) 
				(SETQ BB1 (NTH NP2 (NTH (+ NCA 0)  LIS-4P-SECC )))
				(SETQ AA2 (NTH NP1 (NTH (+ NCA 1)  LIS-4P-SECC )))
				(SETQ BB2 (NTH NP2 (NTH (+ NCA 1)  LIS-4P-SECC )))

				(SETQ AA1des (CAL " AA1 + [ DESf ,0,0] "))
				(SETQ BB1des (CAL " BB1 + [ DESf ,0,0] "))
				(SETQ AA2des (CAL " AA2 + [ DESf ,0,0] "))
				(SETQ BB2des (CAL " BB2 + [ DESf ,0,0] "))

				(COMMAND "COLOR" 2 "3DCARA" AA1des  AA2des  BB2des  BB1des "")				; PINTA FIGURA DESPLAZADA 3DC 3D 

				(COMMAND "SCP" "3P" AA1 BB1 AA2 )
					(SETQ AA1pz (TRANS AA1 0 1))    (SETQ AA1p (CAL "XYof( AA1pz )"))
					(SETQ BB1pz (TRANS BB1 0 1))    (SETQ BB1p (CAL "XYof( BB1pz )"))
					(SETQ AA2pz (TRANS AA2 0 1))    (SETQ AA2p (CAL "XYof( AA2pz )"))
					(SETQ BB2pz (TRANS BB2 0 1))    (SETQ BB2p (CAL "XYof( BB2pz )"))

					;(COMMAND "COLOR" 2  "TEXTO" AA1p 0.4 0 (STRCAT " " (ITOA N6)))										; TEXTO 3DCARA  3D 

				(COMMAND "SCP" "U" )

				(COMMAND "SCP" "3P" KK1 KK2 "" )

					(COMMAND "COLOR" 5 "3DCARA" AA1p AA2p BB2p BB1p "")														; PINTA 3DCARA  2D 

					;(COMMAND "COLOR" 5  "TEXTO" AA1p 0.4 0 (STRCAT " " (ITOA N6)))										; TEXTO 3DCARA  2D 

					(SETQ AA2pU (TRANS AA2p 1 0))
					(SETQ BB2pU (TRANS BB2p 1 0))

				(COMMAND "SCP" "U" )

				(SETQ KK1  AA2pU)
				(SETQ KK2  BB2pU)

			) ; repe NCA
		) ; repe NP1


		; PINTA 1 SUPERFICIE INTERNA																																			

			(SETQ KKx (+ KKx SEPA ))																	; SEPARACION ENTRE PATRONES 

			(SETQ KK1 (LIST    KKx     KKy  0 ))
			(SETQ KK2 (LIST (+ KKx 1)  KKy  0 ))

			(SETQ NCA -1)
			(REPEAT (- (LENGTH LIS-4P-SECC) 1)
				(SETQ NCA (+ NCA 1))

				(SETQ AA1 (NTH 0 (NTH (+ NCA 0)  LIS-4P-SECC )))							; ( AA1  BB1  CC1  DD1 ) <=> ( VA2  VC2  VB2  VD2 )
				(SETQ BB1 (NTH 2 (NTH (+ NCA 0)  LIS-4P-SECC )))
				(SETQ AA2 (NTH 0 (NTH (+ NCA 1)  LIS-4P-SECC )))
				(SETQ BB2 (NTH 2 (NTH (+ NCA 1)  LIS-4P-SECC )))

				(COMMAND "SCP" "3P" AA1 BB1 AA2 )
					(SETQ AA1pz (TRANS AA1 0 1))    (SETQ AA1p (CAL "XYof( AA1pz )"))
					(SETQ BB1pz (TRANS BB1 0 1))    (SETQ BB1p (CAL "XYof( BB1pz )"))
					(SETQ AA2pz (TRANS AA2 0 1))    (SETQ AA2p (CAL "XYof( AA2pz )"))
					(SETQ BB2pz (TRANS BB2 0 1))    (SETQ BB2p (CAL "XYof( BB2pz )"))

					;(COMMAND "COLOR" 2  "TEXTO" AA1p 0.4 0 (STRCAT " " (ITOA N6)))										; TEXTO 3DCARA  3D 

				(COMMAND "SCP" "U" )

				(COMMAND "SCP" "3P" KK1 KK2 "" )

					(COMMAND "COLOR" 7 "3DCARA" AA1p AA2p BB2p BB1p "")														; PINTA 3DCARA  2D 

					;(COMMAND "COLOR" 5  "TEXTO" AA1p 0.4 0 (STRCAT " " (ITOA N6)))										; TEXTO 3DCARA  2D 

					(SETQ AA2pU (TRANS AA2p 1 0))
					(SETQ BB2pU (TRANS BB2p 1 0))

				(COMMAND "SCP" "U" )

				(SETQ KK1  AA2pU)
				(SETQ KK2  BB2pU)

			) ; repe NCA


 	)) ; pro if   PINTA-3DCARAS-3D-2D
	;	(13)																																											
 	;======================================================================================================================================


 	;======================================================================================================================================
	;	(14) PARANDO																																								
	;......................................................................................................................................
	(SETVAR "blipmode" 1)
	(SETVAR "cmdecho"  1)

	(TERPRI) (PROMPT " =================================================== ")
	(TERPRI) (PROMPT " >>>> FINAL >>>>>>>> DESARROLLO-KIWI-41a >>>>> ")
	(TERPRI) (PROMPT " =================================================== ") (TERPRI)

  	;	(14)																																											
 	;======================================================================================================================================

) ;  DESARROLLO-KIWI-41a 

;=========================================================================================================================================
