
;-----------------------------------------------------------------------------------------------------------------------------------------
;																																														
;	( DESARROLLO-KIWI-51 )  de  DESARROLLO-KIWI-50                                                                      10/09/2007			
;																																														
;        RESULTADO:      SUPERFICIES EXTERIOR e INTERIOR 3D 2D Patrones                                           								
;																																														
;        DATOS PARTIDA:  ALZADO (1SUR + 2SUR)  +  ALZADO (1OESTE + 2OESTE)  =>  LIS-P-EJE-BASE									          		
;																																														
;	                      PERFIL IZQUIERTO y DERECHO => (Distancias DIAGUNALES SECCIONES)                                        				
;																																														

;-----------------------------------------------------------------------------------------------------------------------------------------





;-----------------------------------------------------------------------------------------------------------------------------------------
;	(PUNTOS-SPLI-DIVIDE_N-SPL) = PUNTEA CURVA a NDIVISIONES ( NDiv N-SPL1 ) => (LIS-Pun-Spli)															
;-----------------------------------------------------------------------------------------------------------------------------------------

(DEFUN PUNTOS-SPLI-DIVIDE_N-SPL (/  )

	(SETQ LIS-Pun-Spli  nil)
	(SETQ	 Elen (MEMBER (ASSOC 10 (ENTGET N-SPL1)) (ENTGET N-SPL1))							; lista a partir del elemento (incluido) 
		    P-1    (CDR (NTH      0              Elen))											; primer elemento 
		    P-Uo    (CDR (NTH (- (LENGTH Elen) 1) Elen)) )											; ultimo elemento 
	(COMMAND  "COLOR" 1 "PUNTO"  P-1)																	; PINTA Primer Punto (en Base de Datos) 
	(SETQ  N-1P (ENTLAST))																					; Nombre ultima entidad principal = 1 punto 
	(COMMAND	 "COLOR" 2 "DIVIDE" N-SPL1 NDiv															; PINTA Punto Divide (en Base de Datos) 
			    "COLOR" 5 "PUNTO"  P-Uo       )															; PINTA Ultimo Punto (en Base de Datos) 

	;	PUNTOS SECCION X (PX1-PXn) =>  LIS-Pun-Spli																														
	(SETQ	N-P1      nil
		   N-P2      nil
		   N-P2      N-1P
		   LIS-Pun-Spli   nil
		   LIS-Pun-Spli  (LIST (CDR (ASSOC 10 (ENTGET N-1P))))									; LIS-Pun-Spli => 1 punto 
		   WW        T )

	(WHILE WW
	  	(SETQ N-P1 (ENTNEXT N-1P))																		; nombre entidad siguiente 
		(IF (= N-P1 nil)	(SETQ WW nil)
			(PROGN
				(SETQ LIS-Pun-Spli (CONS (CDR (ASSOC 10 (ENTGET N-P1))) LIS-Pun-Spli))		; LIS-Pun-Spli => Resto PUNTOS con ULTIMO 
				(SETQ  N-1P N-P1 )
				(ENTDEL N-P1)																					; BORRA PUNTO 
			) ; pro
		) ; if 
	) ; whi
	(SETQ LIS-Pun-Spli (REVERSE LIS-Pun-Spli))
	(ENTDEL N-P2)																								; BORRA PUNTO 

) ;  DEFUN PUNTOS-SPLI-DIVIDE_N-SPL

;-----------------------------------------------------------------------------------------------------------------------------------------


;-----------------------------------------------------------------------------------------------------------------------------------------
;	PUNTOS-SPLI-GRADUA_N-SPL  =>   GRADUA SPLINE ( N-SPL2 ) con ( NGRADUA ) => LISTA PUNTOS ( LIS-PGX )  										
;-----------------------------------------------------------------------------------------------------------------------------------------

	(DEFUN PUNTOS-SPLI-GRADUA_N-SPL ( / )

		(SETQ ALIS  (ENTGET N-SPL2))  																	; lista Spline A 
		(SETQ AELE  (ASSOC 10 ALIS))  																	; 1 Punto Asociado a 10 (10.punto) 
		(SETQ AELES (MEMBER AELE ALIS)) 																	; lista a partir del Alterior (10.punto)..(11.punto) 
		(SETQ X-primer (CDR (NTH 0 AELES))) 															; primer elemento (10.punto) 
		(SETQ X-ultimo (CDR (NTH (- (LENGTH AELES) 1) AELES)))									; ultimo elemento (11.punto) 
		;(COMMAND "COLOR" 2   "TEXTO" X-primer 10.0 90 "A")										; TEXTO = A 
		(COMMAND "PUNTO" X-primer)																			; PINTA 1 punto 
		(SETQ N-enti-A1 (ENTLAST))																			; nombre ultima entidad principal 1 punto A 
		(COMMAND "GRADUA" N-SPL2  NGRADUA)																; GRADUA SPLI-A 
		(COMMAND "PUNTO" X-ultimo)																			; PINTA Ultimo Punto A 
	
		;	PUNTOS SECCION-A (PA1-PAn) =>   LIS-PGX  Lon-LPA																											
		(SETQ LIS-PGX nil)																					; LISTA  PUNTOS-A 
		(SETQ LIS-PGX (CONS (CDR (ASSOC 10 (ENTGET N-enti-A1))) LIS-PGX))						; lista entidad -> (1 Punto-A) 
		(SETQ W1A T)
		(WHILE W1A
			(SETQ N-enti-A2 (ENTNEXT N-enti-A1))														; Nombre entidad siguiente 
			(COMMAND "BORRA" N-enti-A1 "")
			(IF (= N-enti-A2 nil)  (SETQ W1A nil)
				(PROGN
					(SETQ LIS-PGX (CONS (CDR (ASSOC 10 (ENTGET N-enti-A2))) LIS-PGX))
					(SETQ N-enti-A1  N-enti-A2 )
				);progn
			);if
		) ;While W1A

		(SETQ LIS-PGX  (REVERSE LIS-PGX ))																; LIS-PGX 

	) ; Defun PUNTOS-SPLI-GRADUA_N-SPL

;-----------------------------------------------------------------------------------------------------------------------------------------



;---- DESARROLLO-KIWI-51 -----------------------------------------------------------------------------------------------------------------
	;  (00) ARRANCANDO																																							
	;	(01) FIJAR VARIABLES EN EL PROGRAMA																																	
	;  (02) TOMA de DATOS en PANTALLA																																		
	;  (03) LONGITUD SPLINE => NDIVIDE SPLINES																															
	;  (04) CALCULO  LISTAS-PUNTOS        ( LIS-P-ALZA-SUR1 + LIS-P-ALZA-SUR2 ) => LIS-P-ALZA-SUR														
	;  (05) CALCULO  PUNTOS CURVA-EJE-3D     LIS-P-EJE-BASE   																										
	;  (06) PINTA  PUNTOS CURVA-EJE-3D     LIS-P-EJE-BASE   																											
	;  (07) AADIR a ( LIS-P-SPL-EJE con 2*NDiEJ ) 3 puntos por DELANTE y por DETRAS y FORMAR LISTA con los IMPARES                       
	;  (08) PUNTOS Y=0     ( LIS-P-PER-IZ ) y ( LIS-P-PER-DE )  Cordenada Y = 0.0  2D   =>  ( LIS-P-PER-IZo ) y ( LIS-P-PER-DEo )				
	;--------------------------------------------------------------------------------------------------------------------------------------
	;  (09)	CENTRO CIRCULO y ESFERAS OSCULADORAS de  4 PUNTOS  =>  ( LIS-4N-4P-3M-2C-1E )																	
	;  (10)  PINTA PUNTOS SPLINE TODOS de LISTA MODIFICADA ( LIS-P/MAS-SPL-EJE-B )  																			
	;	(11) PROYECCION de ( LIS-P/MAS-SPL-EJE-B ) sobre PLANO XZ = LIS-P-ALZA-SUR => LIS-LINE-CORTE-M23 												
	;  (12) PUNTOS DE CORTE  (LIS-LINE-CORTE-M23) con (LIS-P-PER-IZo) y (LIS-P-PER-DEo) => (LIS-PUN-CORTE-M23-A) y (LIS-PUN-CORTE-M23-B)	
	;  (13) DISTANCIAS de  MM12pU  a  P-CORTE-2D-A y 2D-B   (LIS-DIS-CORTE-M23-AB)																			
  	;  (14) PINTA EJES-EVOLUTA con AgINI y (LIS-DIS-CORTE-M23-AB) (LIS-4N-4P-3M-2C-1E-DIREC)                                               
	;  (15) PINTA-3DCARAS  3D 2D Patrones																																	
	;	(16) PARANDO																																								
;-----------------------------------------------------------------------------------------------------------------------------------------


"########################################################################################################################################"
;-----------------------------------------------------------------------------------------------------------------------------------------
; *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA ***	
;-----------------------------------------------------------------------------------------------------------------------------------------
"########################################################################################################################################"

(DEFUN C:DESARROLLO-KIWI-51 ( / )

	;======================================================================================================================================
	;  (00) ARRANCANDO																																							
	;......................................................................................................................................

	(SETVAR "blipmode" 0)
	(SETVAR "cmdecho"  0)
	(GRAPHSCR)
	(COMMAND "-REFENT" "DES")
	(COMMAND "SCP"     "U"  )
	(COMMAND "ORTO"    "DES")

	(TERPRI) (PROMPT " =================================================== ")
	(TERPRI) (PROMPT " >>>> INICIO >>>>>>> DESARROLLO-KIWI-51 >>>>> ")
	(TERPRI) (PROMPT " =================================================== ") (TERPRI)

	(IF (= CAL nil)(COMMAND "ARX" "L" "GEOMCAL.ARX"))		; CARGA CALCULADORA 

	;	(00)																																											
	;======================================================================================================================================


 	;======================================================================================================================================
	;	(01) FIJAR VARIABLES EN EL PROGRAMA																																	
	;......................................................................................................................................

	;(SETQ  NDiEJ     80 )				; NDIVIDE  SPLINE-EJE-BASE     

	(SETQ NDIVIDE   30  )				; NDIVIDE SPLINES 

	(SETQ NGRADUA   0.1 )				; DISTANCIA GRADUA SPLINES  (PRECISION de MEDICION) *** NO mas de  32768 ? Divisiones ***


	(SETQ H-TXT      0.5 )				; ALTURA TEXTO 
	(SETQ mUNI 1.02e-006 )				; MARGEN EQUAL para VECTORES UNITARIOS  ( 1.01e-008 ) de LIMITE-MAR-INTER-RECT-01 lsp 

	;	(01)																																											
	;======================================================================================================================================


 	;======================================================================================================================================
	;  (02) TOMA de DATOS en PANTALLA																																		
	;......................................................................................................................................

 	(TERPRI)  (SETQ N-PER-IZ  (CAR (ENTSEL "----  MARCA SPLINE 2D  Plano-XZu    <==  ( Perfil IZQUIER ) ")))  (TERPRI)
 	(TERPRI)  (SETQ N-PER-DE  (CAR (ENTSEL "----  MARCA SPLINE 2D  Plano-XZu    ==>  ( Perfil DERECHO ) ")))  (TERPRI)

 	(TERPRI)  (SETQ N-AlzSUR1 (CAR (ENTSEL "----  MARCA SPLINE CURVA 2D  Plano-XZu   ( Alzado 1SUR )  " )))  (TERPRI)
 	(TERPRI)  (SETQ N-AlzSUR2 (CAR (ENTSEL "----  MARCA SPLINE CURVA 2D  Plano-XZu   ( Alzado 2SUR )  " )))  (TERPRI)
 	(TERPRI)  (SETQ N-AlzOES1 (CAR (ENTSEL "----  MARCA SPLINE CURVA 2D  Plano-YZu   ( Alzado 1OESTE )" )))  (TERPRI)
 	(TERPRI)  (SETQ N-AlzOES2 (CAR (ENTSEL "----  MARCA SPLINE CURVA 2D  Plano-YZu   ( Alzado 2OESTE )" )))  (TERPRI)

	;	(02)																																											
	;======================================================================================================================================


 	;======================================================================================================================================
	;  (03) LONGITUD SPLINE => NDIVIDE SPLINES																															
	;......................................................................................................................................

	(SETQ N-SPL2  N-AlzSUR1 )  (PUNTOS-SPLI-GRADUA_N-SPL)  (SETQ LongSUR1 (* (- (LENGTH LIS-PGX) 2) NGRADUA )) ;  102.8   102.8500 
	(SETQ N-SPL2  N-AlzSUR2 )  (PUNTOS-SPLI-GRADUA_N-SPL)  (SETQ LongSUR2 (* (- (LENGTH LIS-PGX) 2) NGRADUA )) ;  127.7   127.7067 
	(SETQ N-SPL2  N-AlzOES1 )  (PUNTOS-SPLI-GRADUA_N-SPL)  (SETQ LongOES1 (* (- (LENGTH LIS-PGX) 2) NGRADUA )) ;   98.4    98.4710 
	(SETQ N-SPL2  N-AlzOES2 )  (PUNTOS-SPLI-GRADUA_N-SPL)  (SETQ LongOES2 (* (- (LENGTH LIS-PGX) 2) NGRADUA )) ;  160.5   160.5805 

	(SETQ LonParSUR (/ (+ LongSUR1  LongSUR2 ) (* 2  NDIVIDE ))) ; 3.84167 
	(SETQ LonParOES (/ (+ LongOES1  LongOES2 ) (* 20 NDIVIDE ))) ; 0.4315  

	(SETQ NDivSUR1d (/ LongSUR1  LonParSUR ))   (SETQ NDivSUR1 (CAL " ROUND ( NDivSUR1d )"))  ;  26.7592 =>  27 
	(SETQ NDivSUR2d (/ LongSUR2  LonParSUR ))   (SETQ NDivSUR2 (CAL " ROUND ( NDivSUR2d )"))  ;  33.2408 =>  33 
	(SETQ NDivOES1d (/ LongOES1  LonParOES ))   (SETQ NDivOES1 (CAL " ROUND ( NDivOES1d )"))  ; 228.042  => 228 
	(SETQ NDivOES2d (/ LongOES2  LonParOES ))   (SETQ NDivOES2 (CAL " ROUND ( NDivOES2d )"))  ; 371.95   => 372 

	;	(03)																																											
	;======================================================================================================================================


 	;======================================================================================================================================
	;  (04) CALCULO  LISTAS-PUNTOS        ( LIS-P-ALZA-SUR1 + LIS-P-ALZA-SUR2 ) => LIS-P-ALZA-SUR														
	;                                     ( LIS-P-ALZA-OES1 + LIS-P-ALZA-OES2 ) => LIS-P-ALZA-OES														
	;......................................................................................................................................

	(SETQ N-SPL1 N-PER-IZ   NDiv (* 4 NDIVIDE)) (PUNTOS-SPLI-DIVIDE_N-SPL ) (SETQ LIS-P-PER-IZ  LIS-PUN-SPLI)  ; (LENGTH LIS-P-PER-IZ)  
	(SETQ N-SPL1 N-PER-DE   NDiv (* 4 NDIVIDE)) (PUNTOS-SPLI-DIVIDE_N-SPL ) (SETQ LIS-P-PER-DE  LIS-PUN-SPLI)  ; (LENGTH LIS-P-PER-DE)  

	(SETQ N-SPL1 N-AlzSUR1  NDiv NDivSUR1)  (PUNTOS-SPLI-DIVIDE_N-SPL )  (SETQ LIS-P-ALZA-SUR1  LIS-PUN-SPLI) ; (LENGTH LIS-P-ALZA-SUR1)  28
	(SETQ N-SPL1 N-AlzSUR2  NDiv NDivSUR2)  (PUNTOS-SPLI-DIVIDE_N-SPL )  (SETQ LIS-P-ALZA-SUR2  LIS-PUN-SPLI) ; (LENGTH LIS-P-ALZA-SUR2)  34
	(SETQ N-SPL1 N-AlzOES1  NDiv NDivOES1)  (PUNTOS-SPLI-DIVIDE_N-SPL )  (SETQ LIS-P-ALZA-OES1  LIS-PUN-SPLI) ; (LENGTH LIS-P-ALZA-OES1) 229
	(SETQ N-SPL1 N-AlzOES2  NDiv NDivOES2)  (PUNTOS-SPLI-DIVIDE_N-SPL )  (SETQ LIS-P-ALZA-OES2  LIS-PUN-SPLI) ; (LENGTH LIS-P-ALZA-OES2) 373

	(IF (EQUAL (LAST LIS-P-ALZA-SUR1) (NTH 0 LIS-P-ALZA-SUR2))																	; Ult_SUR1 = 1_SUR2
		(SETQ LIS-P-ALZA-SUR (APPEND LIS-P-ALZA-SUR1 (MEMBER (NTH 1  LIS-P-ALZA-SUR2) LIS-P-ALZA-SUR2 ))) 			; (LENGTH LIS-P-ALZA-SUR)  61
		                         (PROGN (TERPRI) (PROMPT " >>>>  Ult_SUR1 y 1_SUR2 => NO SON IGUALES "))) ; if

	(IF (EQUAL (LAST LIS-P-ALZA-OES1) (NTH 0 LIS-P-ALZA-OES2))																	; Ult_OES1 = 1_OES2
		(SETQ LIS-P-ALZA-OES (APPEND LIS-P-ALZA-OES1 (MEMBER (NTH 1  LIS-P-ALZA-OES2) LIS-P-ALZA-OES2 ))) 			; (LENGTH LIS-P-ALZA-OES) 601
		                         (PROGN (TERPRI) (PROMPT " >>>>  Ult_OES1 y 1_OES2 => NO SON IGUALES "))) ; if

	;	(04)																																											
	;======================================================================================================================================


	;======================================================================================================================================
	;  (05) CALCULO  PUNTOS CURVA-EJE-3D     LIS-P-EJE-BASE   																										
	;......................................................................................................................................
	(SETQ  CALCULO-PUN-EJE-BASE  'SI )  (IF (= CALCULO-PUN-EJE-BASE  'SI )  (PROGN

	(SETQ LIS-P-EJE-BASE nil )
	(SETQ LIS-P-EJE-BASE (CONS (LIST 0.0 0.0 0.0)  LIS-P-EJE-BASE))

	(SETQ NOES -1 )
	(SETQ NSUR  0 )
	(REPEAT (- (LENGTH LIS-P-ALZA-SUR) 1 )													; (LENGTH LIS-P-ALZA-SUR) 61 
		(SETQ NSUR (+ NSUR 1))

		(SETQ PSurX (NTH NSUR  LIS-P-ALZA-SUR))
		(SETQ PSurO (LIST 0.0 0.0 (CADDR PSurX)))
		(SETQ PSurY (CAL " PSurO + [0,40,0] "))

		; PUNTOS CORTE ALZA-OES																																					
		(SETQ WWa T )
		(WHILE WWa
			(SETQ NOES (+ NOES 1))
			(IF (> (+ NOES 1) (- (LENGTH LIS-P-ALZA-OES) 1))							; (LENGTH LIS-P-ALZA-OES) 601 
				(PROGN  (SETQ WWa nil) )
				(PROGN
					(SETQ POes1  (NTH (+ NOES 0) LIS-P-ALZA-OES))
					(SETQ POes2  (NTH (+ NOES 1) LIS-P-ALZA-OES))
					(SETQ PinOES (CAL "ILP ( POes1 , POes2 , PSurO , PSurX , PSurY )"))  (SETQ PinOES (CAL " YZof( PinOES ) "))
					
					(COND
						((EQUAL PinOES POes1 mUNI)
							(SETQ CONTROL-OES T )  (SETQ WWa nil)  (SETQ NOES (- NOES 1))
							(SETQ VVy  (CAL "VEC ( PSurO , PinOES )"))
							(SETQ Peje (CAL " PSurX + VVy "))
							(SETQ LIS-P-EJE-BASE (CONS Peje  LIS-P-EJE-BASE)))

							;(COMMAND "COLOR" 255 "LINEA" PinOES Peje "" )
							;(COMMAND "COLOR" 255 "LINEA" PSurX  Peje "" )

						((EQUAL PinOES POes2 mUNI)
							(SETQ CONTROL-OES T )  (SETQ WWa nil)  (SETQ NOES (- NOES 1))
							(SETQ VVy  (CAL "VEC ( PSurO , PinOES )"))
							(SETQ Peje (CAL " PSurX + VVy "))
							(SETQ LIS-P-EJE-BASE (CONS Peje  LIS-P-EJE-BASE)))

							;(COMMAND "COLOR" 255 "LINEA" PinOES Peje "" )
							;(COMMAND "COLOR" 255 "LINEA" PSurX  Peje "" )

						( T
							(SETQ CONTROL-OES nil )
							(SETQ D0a (CAL "DIST ( POes1  , POes2  )"))
							(SETQ D1a (CAL "DIST ( POes1  , PinOES )"))
							(SETQ D2a (CAL "DIST ( PinOES , POes2  )"))
							(IF (EQUAL D0a (+ D1a D2a) mUNI)
								(PROGN
									(SETQ CONTROL-OES T )  (SETQ WWa nil)  (SETQ NOES (- NOES 1))
									(SETQ VVy  (CAL "VEC ( PSurO , PinOES )"))
									(SETQ Peje (CAL " PSurX + VVy "))
									(SETQ LIS-P-EJE-BASE (CONS Peje  LIS-P-EJE-BASE))

									;(COMMAND "COLOR" 3 "LINEA" PinOES Peje "" )
									;(COMMAND "COLOR" 4 "LINEA" PSurX  Peje "" )
								) ; pro 
							) ; if
						) ; con T 
					) ; con
				) ; pro
			) ; if
		) ; WWa

		(IF (= CONTROL-OES nil ) (PROGN (TERPRI) (PROMPT " >>>>  NO PUNTO-CORTE-EJE-BASE-A   en NSUR = ") (PRIN1 NSUR ) (TERPRI)))

	) ; repe NSUR

	(SETQ LIS-P-EJE-BASE (REVERSE LIS-P-EJE-BASE ))															; (LENGTH LIS-P-EJE-BASE) 61 

	)) ; pro if   CALCULO-PUN-EJE-BASE 
	;	(05)																																											
	;======================================================================================================================================


	;======================================================================================================================================
	;  (06) PINTA  PUNTOS CURVA-EJE-3D     LIS-P-EJE-BASE   																											
	;......................................................................................................................................
	(SETQ  PINTA-PUN-EJE-BASE  'SI )  (IF (= PINTA-PUN-EJE-BASE  'SI )  (PROGN

	(SETQ NA -1 )
	(REPEAT (- (LENGTH LIS-P-EJE-BASE ) 1 )
		(SETQ NA (+ NA 1))
		(SETQ PEB1 (NTH (+ NA 0)  LIS-P-EJE-BASE ))
		(SETQ PEB2 (NTH (+ NA 1)  LIS-P-EJE-BASE ))
		(COMMAND "COLOR" 2 "LINEA" PEB1  PEB2 "" )
	) ; repe NSUR

	(SETQ NBA -1 )
	(REPEAT (LENGTH LIS-P-EJE-BASE )
		(SETQ NBA (+ NBA 1))
		(SETQ PBas (NTH NBA  LIS-P-EJE-BASE ))
		(COMMAND "COLOR" 2 "PUNTO" PBas )
	) ; repe NSUR

	(SETQ NB -1 )
	(REPEAT (LENGTH LIS-P-ALZA-SUR )
		(SETQ NB (+ NB 1))
		(SETQ PSur (NTH NB  LIS-P-ALZA-SUR ))
		(COMMAND "COLOR" 7 "PUNTO" PSur )
	) ; repe NSUR

	(SETQ NC -1 )
	(REPEAT (LENGTH LIS-P-ALZA-OES )
		(SETQ NC (+ NC 1))
		(SETQ POes (NTH NC  LIS-P-ALZA-OES ))
		(COMMAND "COLOR" 5 "PUNTO" POes )
	) ; repe NSUR

	)) ; pro if   PINTA-PUN-EJE-BASE 
	;	(06)																																											
	;======================================================================================================================================


 	;======================================================================================================================================
	;  (07) AADIR a ( LIS-P-SPL-EJE con 2*NDiEJ ) 3 puntos por DELANTE y por DETRAS y FORMAR LISTA con los IMPARES                       
	;                                         ( Para que COINCIDAD 1y Utima SECCION con ESTREMOS de SPLINE-BASE-EJE )                     
	;......................................................................................................................................

	(SETQ  AADE-PUNTOS  'SI )  (IF (= AADE-PUNTOS  'SI )  (PROGN



					(SETQ  LIS-P/MAS-SPL-EJE-B   LIS-P-EJE-BASE )    ; PROVISIONAL ?????????????????????????????????



	)) ; pro if   AADE-PUNTOS 

	;	(07)																																											
	;======================================================================================================================================


 	;======================================================================================================================================
	;  (08) PUNTOS Y=0     ( LIS-P-PER-IZ ) y ( LIS-P-PER-DE )  Cordenada Y = 0.0  2D   =>  ( LIS-P-PER-IZo ) y ( LIS-P-PER-DEo )				
	;......................................................................................................................................

	(SETQ LIS-P-PER-IZo nil)
	(SETQ LIS-P-PER-DEo nil)

	(SETQ NZ0 -1 )
	(REPEAT (LENGTH LIS-P-PER-IZ)
		(SETQ NZ0 (+ NZ0 1))
		(SETQ PAz (NTH NZ0  LIS-P-PER-IZ))      (SETQ PAz2D (CAL " XZof( PAz )"))
		(SETQ PBz (NTH NZ0  LIS-P-PER-DE))      (SETQ PBz2D (CAL " XZof( PBz )"))
		
		(SETQ LIS-P-PER-IZo (CONS PAz2D  LIS-P-PER-IZo ))
		(SETQ LIS-P-PER-DEo (CONS PBz2D  LIS-P-PER-DEo ))
	) ; repe NZ0 

	(SETQ LIS-P-PER-IZo (REVERSE LIS-P-PER-IZo))													; (LENGTH LIS-P-PER-IZo) 121
	(SETQ LIS-P-PER-DEo (REVERSE LIS-P-PER-DEo))													; (LENGTH LIS-P-PER-DEo) 121

	;	(08)																																											
	;======================================================================================================================================



	;######################################################################################################################################



 	;======================================================================================================================================
	;  (09)	CENTRO CIRCULO y ESFERAS OSCULADORAS de  4 PUNTOS  =>  ( LIS-4N-4P-3M-2C-1E )																	
	;......................................................................................................................................
	(SETQ  CENTRO-CIRCULO-ESFERAS  'SI )  (IF (= CENTRO-CIRCULO-ESFERAS  'SI )  (PROGN

	(SETQ LIS-4N-4P-3M-2C-1E nil)

	(SETQ STOP-1 nil )
	(SETQ STOP-2 nil )
	(SETQ NC -1 )
	(REPEAT (- (LENGTH LIS-P/MAS-SPL-EJE-B) 3)
		(SETQ NC (+ NC 1))

		; PUNTO LIS-P/MAS-SPL-EJE-B  (de 4 en 4)                  ; VEC-12 UNI (P1 P2) 																				

		(SETQ P1a (NTH (+ NC 0) LIS-P/MAS-SPL-EJE-B))      (SETQ N1a (+ NC 0))
		(SETQ P2a (NTH (+ NC 1) LIS-P/MAS-SPL-EJE-B))      (SETQ N2a (+ NC 1))
		(SETQ P3a (NTH (+ NC 2) LIS-P/MAS-SPL-EJE-B))      (SETQ N3a (+ NC 2))
		(SETQ P4a (NTH (+ NC 3) LIS-P/MAS-SPL-EJE-B))      (SETQ N4a (+ NC 3))

		(SETQ V12a  (CAL "VEC1 ( P1a , P2a ) "))
		(SETQ V23a  (CAL "VEC1 ( P2a , P3a ) "))
		(SETQ V34a  (CAL "VEC1 ( P3a , P4a ) "))

		(IF (OR (EQUAL V12a V23a mUNI) (EQUAL V23a V34a mUNI) )															;    COLIMEALES ( P1 P2 P3 P4 ) 
			(PROGN (TERPRI) (PROMPT "-- (P1 P2 P3 P4) ALGUNOS COLIMEALES => (STOP-1) NC= ") (PRIN1 NC) (SETQ STOP-1 T) ))

		(IF (= STOP-1 nil)																											; NO COLIMEALES ( P1 P2 P3 P4 ) 
			(PROGN
				; PUNTO MEDIO (P1 P2)                                       ; VEC-Z    UNI (P1 P2 P3)														
				(SETQ M12a (CAL "PLT ( P1a , P2a , 0.5 )"))
				(SETQ M23a (CAL "PLT ( P2a , P3a , 0.5 )"))                 (SETQ Vz123a (CAL "NOR ( P1a , P2a , P3a )"))
				(SETQ M34a (CAL "PLT ( P3a , P4a , 0.5 )"))                 (SETQ Vz234a (CAL "NOR ( P2a , P3a , P4a )"))

				; VEC-RADI UNI (P1 P2)                                      ; PUN-RADI (M12a  M12v1)														
				(SETQ V1r12  (CAL "NOR ( P1a , P2a , P1a + Vz123a )"))      (SETQ M12v1 (CAL " M12a + V1r12 "))
				(SETQ V1r23  (CAL "NOR ( P2a , P3a , P2a + Vz123a )"))      (SETQ M23v1 (CAL " M23a + V1r23 "))
				(SETQ V2r23  (CAL "NOR ( P2a , P3a , P2a + Vz234a )"))      (SETQ M23v2 (CAL " M23a + V2r23 "))
				(SETQ V2r34  (CAL "NOR ( P3a , P4a , P3a + Vz234a )"))      (SETQ M34v2 (CAL " M34a + V2r34 "))

				; CENTROS CIRCULOS OSCULADORES																																

				(SETQ C123u (CAL "ILP ( M12a , M12v1 ,   M23a , M23v1 , M23a + Vz123a )"))
				(SETQ C234u (CAL "ILP ( M23a , M23v2 ,   M34a , M34v2 , M34a + Vz234a )"))

				; CENTROS ESFERAS OSCULADORAS																																	
				(IF (EQUAL Vz123a Vz234a mUNI)		                                  	                     ;    COPLANARIOS (P1 P2 P3 P4) 
					 (PROGN (TERPRI) (PROMPT "-- (P1 P2 P3 P4) ALGUNOS COPLANARIOS => (STOP-2) NC= ") (PRIN1 NC) (SETQ STOP-2 T) ))

				(IF (= STOP-2 nil)																									; NO COPLANARIOS (P1 P2 P3 P4) 
					(PROGN
						(SETQ C123v (CAL " C123u + Vz123a "))
						(SETQ C234v (CAL " C234u + Vz234a "))

						(SETQ E1234u (CAL "ILP ( C123u , C123v ,   C234u , C234v , M34a )"))
					) ; pro
					(PROGN
						(TERPRI) (PROMPT "---- COPLANARIOS (P1 P2 P3 P4)=> ( NO EJECUTA CENTRO ESFERA )")
					) ; pro
				) ; if
			) ; pro
			(PROGN
				(TERPRI) (PROMPT "---- COLIMEALES (P1 P2 P3 P4)=> ( NO EJECUTA CENTRO CIRCULOS )")
			) ; pro
		) ; if

		;	LISTA PUNTOS       ( LIS-4N-4P-3M-2C-1E )																														

		(SETQ LIS-4N-4P-3M-2C-1E (CONS (LIST   (LIST N1a   N2a   N3a   N4a)
															(LIST P1a   P2a   P3a   P4a)
															(LIST   M12a  M23a  M34a   )
															(LIST     C123u  C234u     )
															(LIST        E1234u        )) LIS-4N-4P-3M-2C-1E))
	) ; repe NC

	(SETQ LIS-4N-4P-3M-2C-1E-DIREC (REVERSE LIS-4N-4P-3M-2C-1E ))					; (LENGTH LIS-4N-4P-3M-2C-1E-DIREC) 58 

	)) ; pro if   CENTRO-CIRCULO-ESFERAS 
	;	(09)																																											
	;======================================================================================================================================


	;======================================================================================================================================
	;  (10)  PINTA PUNTOS SPLINE TODOS de LISTA MODIFICADA ( LIS-P/MAS-SPL-EJE-B )  																			
	;......................................................................................................................................
	(SETQ  PINTA-PUNTOS-SPL-EJE-B  'SI )  (IF (= PINTA-PUNTOS-SPL-EJE-B  'SI )  (PROGN

	; PINTA  LIS-P/MAS-SPL-EJE-B																																				
	(IF (= STOP-1 nil)																												; NO COLIMEALES (P1 P2 P3) 
		(PROGN
			(SETQ NP -1)
			(REPEAT (- (LENGTH LIS-P/MAS-SPL-EJE-B) 1)
				(SETQ NP (+ NP 1))
				(SETQ P1p (NTH (+ NP 0) LIS-P/MAS-SPL-EJE-B))
				(SETQ P2p (NTH (+ NP 1) LIS-P/MAS-SPL-EJE-B))
				(COMMAND "COLOR" 5 "LINEA"  P1p P2p "")
				;(SETQ M12p (CAL "PLT ( P1p , P2p , 0.5 )"))
				;(COMMAND "COLOR" 1 "PUNTO"  M12p)																				; PUNTO M12 
				(SETQ Ag12p  (+ 90 (CAL "ANG ( P1p , P2p )")))
				(COMMAND "COLOR" 5 "PUNTO"  P1p)																					; PUNTO P1 
				;(COMMAND "COLOR" 5 "TEXTO"  P1p  H-TXT  Ag12p  (STRCAT "_P-" (ITOA NP)))
				(IF (= NP (- (LENGTH LIS-P/MAS-SPL-EJE-B) 2))
					(PROGN
						(COMMAND "COLOR" 5 "PUNTO" P2p)																			; PUNTO P2 
						;(COMMAND "COLOR" 5 "TEXTO" P2p  H-TXT  Ag12p  (STRCAT "_P-" (ITOA (+ NP 1))))
					) ; pro
				) ; if
			) ; repe
		) ; pro
		(PROGN
			(TERPRI) (PROMPT "---- COLIMEALES (P1 P2 P3)=> ( NO EJECUTA PINTA PUNTOS LIS-P/MAS-SPL-EJE-B)")
		) ; pro
	) ; if

	; PINTA  LIS-P-PER-IZo																																						
	(IF (= STOP-1 nil)																												; NO COLIMEALES (P1 P2 P3) 
		(PROGN
			(SETQ NP -1)
			(REPEAT (LENGTH LIS-P-PER-IZo)
				(SETQ NP (+ NP 1))
				(SETQ P1p (NTH (+ NP 0) LIS-P-PER-IZo))
				(COMMAND "COLOR" 255 "PUNTO"  P1p)																					; PUNTO P1 
			) ; repe
		) ; pro
		(PROGN
			(TERPRI) (PROMPT "---- COLIMEALES (P1 P2 P3)=> ( NO EJECUTA PINTA PUNTOS LIS-P-PER-IZo)")
		) ; pro
	) ; if

	; PINTA  LIS-P-PER-DEo																																						
	(IF (= STOP-1 nil)																												; NO COLIMEALES (P1 P2 P3) 
		(PROGN
			(SETQ NP -1)
			(REPEAT (LENGTH LIS-P-PER-DEo)
				(SETQ NP (+ NP 1))
				(SETQ P1p (NTH (+ NP 0) LIS-P-PER-DEo))
				(COMMAND "COLOR" 255 "PUNTO"  P1p)																					; PUNTO P1 
			) ; repe
		) ; pro
		(PROGN
			(TERPRI) (PROMPT "---- COLIMEALES (P1 P2 P3)=> ( NO EJECUTA PINTA PUNTOS LIS-P-PER-DEo)")
		) ; pro
	) ; if

	)) ; pro if   PINTA-PUNTOS-SPL-EJE-B 
	;	(10)																																											
	;======================================================================================================================================


	;======================================================================================================================================
	;	(11) PROYECCION de ( LIS-P/MAS-SPL-EJE-B ) sobre PLANO XZ = LIS-P-ALZA-SUR => LIS-LINE-CORTE-M23 												
	;......................................................................................................................................
	(SETQ  P-ALZA-SUR-LINEAS-CORTE  'SI )  (IF (= P-ALZA-SUR-LINEAS-CORTE  'SI )  (PROGN

	(SETQ LIS-LINE-CORTE-M23 nil)
	(SETQ disRA 15.0 )																	; LONGITUD RADIO GRAFICA 

	(SETQ NS -1)
	(REPEAT (- (LENGTH LIS-P-ALZA-SUR ) 1) ; 60 
		(SETQ NS (+ NS  1))

		(SETQ  P1s (NTH (+ NS 0)  LIS-P-ALZA-SUR))
		(SETQ  P2s (NTH (+ NS 1)  LIS-P-ALZA-SUR))
		(SETQ M12s (CAL "PLT ( P1s , P2s , 0.5 )"))

		(COMMAND "SCP" "3P" (LIST 0 0 0) (LIST 1 0 0) (LIST 0 0 1))
			(SETQ   P1sp (CAL " W2U (  P1s ) "))
			(SETQ   P2sp (CAL " W2U (  P2s ) "))
			(SETQ  M12sp (CAL " W2U ( M12s ) "))
			(SETQ  V12sp (CAL " NOR ( P1sp , P2sp )"))
			(SETQ M12Rsp (CAL " M12sp + ( V12sp * disRA )"))

			(SETQ  M12Rs (CAL " U2W (  M12Rsp ) "))    (SETQ M12Rs (CAL " XZof( M12Rs )"))
		(COMMAND "SCP" "U" )

		(COMMAND "COLOR" 255 "LINEA" M12s  M12Rs "" )

		(SETQ LIS-LINE-CORTE-M23 (CONS (LIST  M12s  M12Rs ) LIS-LINE-CORTE-M23 ))

	) ; repe NS 

	(SETQ LIS-LINE-CORTE-M23 (REVERSE LIS-LINE-CORTE-M23))								; (LENGTH LIS-LINE-CORTE-M23 ) 60 

	)) ; pro if   P-ALZA-SUR-LINEAS-CORTE 
	;	(11)																																											
	;======================================================================================================================================


	;======================================================================================================================================
	;  (12) PUNTOS DE CORTE  (LIS-LINE-CORTE-M23) con (LIS-P-PER-IZo) y (LIS-P-PER-DEo) => (LIS-PUN-CORTE-M23-A) y (LIS-PUN-CORTE-M23-B)		
	;......................................................................................................................................
	(SETQ  PUNTOS-CORTE  'SI )  (IF (= PUNTOS-CORTE  'SI )  (PROGN

	(SETQ LIS-PUN-CORTE-M23-A nil )				; LIS-PUN-CORTE-IZ  CANBIAR  ??? 
	(SETQ LIS-PUN-CORTE-M23-B nil )				; LIS-PUN-CORTE-DE  CANBIAR  ??? 

	(SETQ NCR -1)
	(REPEAT (LENGTH LIS-LINE-CORTE-M23)		; 60 
		(SETQ NCR (+ NCR 1))

		(SETQ PPo2D (NTH 0 (NTH NCR  LIS-LINE-CORTE-M23)))		; (LIST  M12s  M12Rs ) 
		(SETQ PPx2D (NTH 1 (NTH NCR  LIS-LINE-CORTE-M23)))
		(SETQ PPz2D (CAL " PPo2D + [0,10,0] "))

		; PUNTOS CORTE A																																							

		(SETQ NA  -1)
		(SETQ KcorA nil )
		(SETQ WWa T )
		(WHILE WWa																														; LIS-P-PER-IZo
			(SETQ NA (+ NA 1))
			(IF (> (+ NA 1) (- (LENGTH LIS-P-PER-IZo) 1))
				(PROGN  (SETQ WWa nil) )
				(PROGN
					(SETQ PA1  (NTH (+ NA 0) LIS-P-PER-IZo))
					(SETQ PA2  (NTH (+ NA 1) LIS-P-PER-IZo))
					(SETQ PinA (CAL "ILP ( PA1 , PA2 , PPo2D , PPx2D , PPz2D )")) (SETQ PinA (CAL " XYof( PinA ) ")) ; INTERSEC LINEA-S-A PLANO 
					
					(COND
						((EQUAL PinA PA1 mUNI)
							(COMMAND "COLOR" 255 "LINEA" PPo2D PinA "" )
							(SETQ KcorA T ) (SETQ WWa nil) (SETQ NA (- NA 1))
							(SETQ LIS-PUN-CORTE-M23-A (CONS PinA  LIS-PUN-CORTE-M23-A)))

						((EQUAL PinA PA2 mUNI)
							(COMMAND "COLOR" 255 "LINEA" PPo2D PinA "" )
							(SETQ KcorA T ) (SETQ WWa nil) (SETQ NA (- NA 1))
							(SETQ LIS-PUN-CORTE-M23-A (CONS PinA  LIS-PUN-CORTE-M23-A)))

						( T
							(SETQ D0a (CAL "DIST ( PA1  , PA2  )"))
							(SETQ D1a (CAL "DIST ( PA1  , PinA )"))
							(SETQ D2a (CAL "DIST ( PinA , PA2  )"))
							(IF (EQUAL D0a (+ D1a D2a) mUNI)
								(PROGN
									(COMMAND "COLOR" 1 "LINEA" PPo2D PinA "" )							; VECTOR VERTICE-A   2D 
									(SETQ KcorA T )  (SETQ WWa nil)  (SETQ NA (- NA 1))
									(SETQ LIS-PUN-CORTE-M23-A (CONS PinA  LIS-PUN-CORTE-M23-A))
								) ; pro 
							) ; if
						) ; conAT 
					) ; con
				) ; pro
			) ; if
		) ; WWa

		(IF (= KcorA nil ) (PROGN (TERPRI) (PROMPT " >>>>  NO PUNTO-CORTE-A   en NCR = ") (PRIN1 NCR ) (TERPRI)))

		; PUNTOS CORTE B																																							

		(SETQ NB  -1)
		(SETQ KcorB nil )
		(SETQ WWb T )
		(WHILE WWb																															; LIS-P-PER-DEo 
			(SETQ NB (+ NB 1))
			(IF (> (+ NB 1) (- (LENGTH LIS-P-PER-DEo) 1))
				(PROGN  (SETQ WWb nil)) ; pro
				(PROGN
					(SETQ PB1  (NTH (+ NB 0) LIS-P-PER-DEo))
					(SETQ PB2  (NTH (+ NB 1) LIS-P-PER-DEo))
					(SETQ PinB (CAL "ILP ( PB1 , PB2 , PPo2D , PPx2D , PPz2D )")) (SETQ PinB (CAL " XYof( PinB ) "))  ; INTERSE LINEA-S-B PLANO 
					
					(COND
						((EQUAL PinB PB1 mUNI)
							(COMMAND "COLOR" 255 "LINEA" PPo2D PinB "" )
							(SETQ KcorB T ) (SETQ WWb nil) (SETQ NB (- NB 1))
							(SETQ LIS-PUN-CORTE-M23-B (CONS PinB  LIS-PUN-CORTE-M23-B)))

						((EQUAL PinB PB2 mUNI)
							(COMMAND "COLOR" 255 "LINEA" PPo2D PinB "" )
							(SETQ KcorB T ) (SETQ WWb nil) (SETQ NB (- NB 1))
							(SETQ LIS-PUN-CORTE-M23-B (CONS PinB  LIS-PUN-CORTE-M23-B)))

						( T
							(SETQ D0b (CAL "DIST ( PB1  , PB2  )"))
							(SETQ D1b (CAL "DIST ( PB1  , PinB )"))
							(SETQ D2b (CAL "DIST ( PinB , PB2  )"))
							(IF (EQUAL D0b (+ D1b D2b) mUNI)
								(PROGN
									(COMMAND "COLOR" 2 "LINEA" PPo2D PinB "" )							; VECTOR VERTICE-B   2D 
									(SETQ KcorB T )  (SETQ WWb nil)  (SETQ NB (- NB 1))
									(SETQ LIS-PUN-CORTE-M23-B (CONS PinB  LIS-PUN-CORTE-M23-B))
								) ; pro
							) ; if 
						) ; conBT
					) ; con
				) ; pro
			) ; if
		) ; WWb

		(IF (= KcorB nil ) (PROGN (TERPRI) (PROMPT " >>>>  NO PUNTO-CORTE-B   en NCR = ") (PRIN1 NCR ) (TERPRI)))

	) ; repe NCR

	(SETQ LIS-PUN-CORTE-M23-A (REVERSE LIS-PUN-CORTE-M23-A ))															; (LENGTH LIS-PUN-CORTE-M23-A) 80 
	(SETQ LIS-PUN-CORTE-M23-B (REVERSE LIS-PUN-CORTE-M23-B ))															; (LENGTH LIS-PUN-CORTE-M23-B) 80 

	(SETQ NP-CoA (LENGTH LIS-PUN-CORTE-M23-A))
	(SETQ NP-CoB (LENGTH LIS-PUN-CORTE-M23-B))
	(IF (= NP-CoA  NP-CoB )
	 (PROGN (TERPRI) (PROMPT " >>>>  IGUALES NPUN-CORTE A/B ") (PRIN1 NP-CoA) (PROMPT "/") (PRIN1 NP-CoB) (PROMPT " ( BIEN )") (TERPRI))
	 (PROGN (TERPRI) (PROMPT " >> NO IGUALES NPUN-CORTE A/B ") (PRIN1 NP-CoA) (PROMPT "/") (PRIN1 NP-CoB) (PROMPT " ( MAL ) ") (TERPRI))
	) ; if

	)) ; pro if   PUNTOS-CORTE 
	;	(12)																																											
	;======================================================================================================================================

	;======================================================================================================================================
	;  (13) DISTANCIAS de  MM12pU  a  P-CORTE-2D-A y 2D-B   (LIS-DIS-CORTE-M23-AB)																			
	;......................................................................................................................................
	(SETQ  DISTANCIAS-CORTE  'SI )  (IF (= DISTANCIAS-CORTE  'SI )  (PROGN

	(SETQ LIS-DIS-CORTE-M23-AB nil )

	(SETQ NDI -1)
	(REPEAT (LENGTH LIS-PUN-CORTE-M23-A)		; 80 
		(SETQ NDI (+ NDI 1))

		(SETQ PDisA (NTH NDI LIS-PUN-CORTE-M23-A ))				; (LIST  PinA) 
		(SETQ PDisB (NTH NDI LIS-PUN-CORTE-M23-B ))				; (LIST  PinB) 

		(SETQ PDo (NTH 0 (NTH NDI LIS-LINE-CORTE-M23)))		; (LIST  MM12pU  C12RpU ) 
		(SETQ PDx (NTH 1 (NTH NDI LIS-LINE-CORTE-M23)))

		(COMMAND "SCP" "3P" PDo PDx "" )
			(SETQ PDisAd (TRANS PDisA 0 1 ))
			(SETQ PDisBd (TRANS PDisB 0 1 ))
		(COMMAND "SCP" "U" )

		(SETQ DisA (CAR PDisAd))
		(SETQ DisB (CAR PDisBd))

		(SETQ LIS-DIS-CORTE-M23-AB (CONS (LIST DisA  DisB ) LIS-DIS-CORTE-M23-AB ))

	) ; repe NDI

	(SETQ LIS-DIS-CORTE-M23-AB-DIREC (REVERSE LIS-DIS-CORTE-M23-AB ))											; (LENGTH LIS-DIS-CORTE-M23-AB-DIREC) 80 

	)) ; pro if   DISTANCIAS-CORTE 
  	;	(13)																																											
	;======================================================================================================================================


	;--------------------------------------------------------------------------------------------------------------------------------------
	;  ( LIS-4N-4P-3M-2C-1E )   (LIST          N1         N2         N3         N4         ) N del PUNTO                                  
	;                           (LIST          P1         P2         P3         P4         ) PUNTO                                         
	;                           (LIST               M12        M23        M34              ) PUNTO MEDIO                                   
	;                           (LIST                    C123       C234                   ) CEN-CIRCULO OSCULADOR                         
	;                           (LIST                         E1234                        ) CEN-ESFERA  OSCULADORA                        
	;--------------------------------------------------------------------------------------------------------------------------------------
	;  Plano M12 =  M12  C123  E1234   LIS-4N-4P-3M-2C-1E-DIREC   =>  ((N1 N2 N3 N4) (P1 P2 P3 P4) (M12 M23 M34) (C123 C234) (E1234))      
	;  Plano M23 =  M23  C123  E1234                                                                                                       
	;  Plano M34 =  M34  C234  E1234   LIS-DIS-CORTE-M23-AB-DIREC =>  ( DisA  DisB )                                                       
	;--------------------------------------------------------------------------------------------------------------------------------------


				;                                                                                                                          
				;  DIBUJO: HOMOLOGIA AFIN \ ESCULTURA-PAJARO-KIWI-10 Renedo.DWG   CAPAS: 603 - PLANOS NORMALES EXAGONALES 1 y CALCULOS 3   
				;                                                                       ;                                                  
				;                                                         /             ;                          O PA1                   
				;                                                       (O)(EP1)        ;                         /|\                      
				;                                                     o /               ;                        / | \                     
				;                                                   o  / o              ;                       /  |  \                    
				;                                                 o   /                 ;                      / DM12A \                   
				;                                               o    /  o               ;                     /    |    \                  
				;                                            o      /                   ;                PC1 O     O M12 O PD1             
				;                                          o       /   o                ;                   / \    |    / \                
				;                                        o        /                     ;    ________      /   \ DM12B /   \               
				;                                      o         /    o                 ;    PLANO-12     /     \  |  /     \              
				;                                   o           /                       ;                /       \ | /       \             
				;                                 o            /     o                  ;               /         \|/         \            
				;                               o             /                         ;              /           O PB1       \           
				;                             o              /      o                   ;             /           /|\           \          
				;                     pINI (O)              /                           ;            /           / | \           \         
				;                        o                 /       o                    ;           /           /  EP1\           \        
				;  O P1                o                  /                       P4 O  ;   -------o-----------o---O---o-----------o-------
				;   \           -----o----------         /--------o------           /   ;    ChAC12 \    ChBD12 \  |  / ChBC12    / ChAD12 
				;    \         /  o             \       / PLANO-34       \         /    ;            \           \ | /           /         
				;     \       / o                \     /         o        \       /     ;             \           \|/           /          
				;      \     /o  AgINI            \   /                    \     /      ;              \           O PB2       /           
				;       \   o                 E1234\ /          o           \   /       ;               \         /|\         /            
				;    M12 O------------------------- O -------------------------O M34    ;                \       / | \       /             
				;         \ \   ________           /|\         o ________   / /         ;    ________     \     /  |  \     /              
				;          \ \  PLANO-12          / | \          PLANO-34  / /          ;    PLANO-23      \   / DM23B \   /               
				;           \ \                  /  |  \      o           / /           ;                   \ /    |    \ /                
				;            \ \            C123/   |   C234             / /            ;                PC2 O     O M23 O PD2             
				;             \ -------------- O    |    O --o----------- /             ;                   / \    |    / \                
				;              \               |____|___ |\ o            /              ;                  /   \ DM23A /   \               
				;               \              |PLANO-23 |(O)(EP2)      /               ;                 /     \  |  /     \              
				;                \             |    |    |o \          /                ;                /       \ | /       \             
				;                 \            |    |    o   \        /                 ;               /         \|/         \            
				;                  \           |    |   o|    \      /                  ;              /           O PA2       \           
				;                   \           \   |  o/      \    /                   ;             /           /|\           \          
				;                    \           \  | o/           /                    ;            /           / | \           \         
				;                     \           \ |o/           /                     ;    ChAC23 /    ChBD23 /  |  \ ChBC23    \ ChAD23 
				;                      O------------O------------O                      ;   -------o-----------o---O---o-----------o-------
				;                    P2            M23            P3                    ;    ________              EP2                     
				;                                                                       ;    PLANO-34                                      
				;                                                                       ;                                                  

				;--------------------------------------------------------------------------------------------------------------------------
				;  PLANOS REALES    PLANO-12   PLANO-23   PLANO-34   PLANO-45   PLANO-56   PLANO-67   PLANO-78   PLANO-89                  
				;--------------------------------------------------------------------------------------------------------------------------
				;  NE = 0  =>      PLANO-12   PLANO-23   PLANO-34                                                                         
				;  NE = 1  =>                 PLANO-12   PLANO-23   PLANO-34                                                              
				;  NE = 2  =>                            PLANO-12   PLANO-23   PLANO-34                                                   
				;  NE = 3  =>                                       PLANO-12   PLANO-23   PLANO-34                                        
				;  NE = 4  =>                                                  PLANO-12   PLANO-23   PLANO-34                             
				;  NE = 5  =>                                                             PLANO-12   PLANO-23   PLANO-34                  
				;--------------------------------------------------------------------------------------------------------------------------

				;--------------------------------------------------------------------------------------------------------------------------
				;  PUNTOS INICIO  NE = 0      PLANO-12 = ez(M12 P2) = M12 E1234 C123                                                      
				;--------------------------------------------------------------------------------------------------------------------------
				;  pINI = GIRO SCPez EjeX PLANO-12 CENTRO (M12) AgINI                                                                    	
				;                                                                                                                          
				;  EP1 = INTERSEC (C123 - E1234) con (M12 - pINI)      PA1 = M12 + (Vme1 * DM12A)      PB1 = M12 + (Vme1 * DM12B)      		
				;  EP2 = INTERSEC (C234 - E1234) con (M23 - EP1)       PA2 = M23 + (Vme2 * DM23A)      PB2 = M23 + (Vme2 * DM23B)      		
				;--------------------------------------------------------------------------------------------------------------------------
				;  RESTO PUNTOS   NE = n      PLANO-23 = ez(M23 P3) = M23 E1234 C234                                                      
				;--------------------------------------------------------------------------------------------------------------------------
				;  EP2 = INTERSEC (C234 - E1234) con (M23 - EP1)         PA2 = M23 + (Vme2 * DM23A)      PB2 = M23 + (Vme2 * DM23B)    		
				;--------------------------------------------------------------------------------------------------------------------------


 	;======================================================================================================================================
  	;  (14) PINTA EJES-EVOLUTA con AgINI y (LIS-DIS-CORTE-M23-AB) (LIS-4N-4P-3M-2C-1E-DIREC)                                               
	;                                                                                                                                      
	(SETQ  PINTA-EJES-EVOLUTA  'SI )  (IF (= PINTA-EJES-EVOLUTA  'SI )  (PROGN

	(IF (AND (= STOP-1 nil) (= STOP-2 nil))															; NO-COLIMEALES  NO-COPLANARIOS 
		(PROGN

			(SETQ AgINI -45.551 )     							; AgINI al EJE(M23 C123) /= 90y270      ANGULO INICIO PUNTO (pINI) 
			(SETQ AgVER  45.0   )     							; ANGULO INICIO VERTICES 1SECCION  

			(SETQ LIS-4P-SECC nil )

			(SETQ NOri 0 )																					; NCRNTROL ORIENTACION VECTORES OPUESTOS 
			(SETQ NE  -1) 																					; ENPIEZA por PRINCIPIO 

			(REPEAT (LENGTH LIS-4N-4P-3M-2C-1E-DIREC)													; IGUAL que (LENGTH LIS-DIS-CORTE-M23-AB-DIREC) 
				(SETQ NE  (+ NE  1))

				;  LIS-4N-4P-3M-2C-1E-DIREC  =>  (( N1 N2 N3 N4 ) ( P1 P2 P3 P4 ) ( M12 M23 M34 ) ( C123 C234 ) ( E1234 ))  						

				(SETQ N1    (NTH 0 (NTH 0 (NTH NE  LIS-4N-4P-3M-2C-1E-DIREC))))			; (LENGTH LIS-4N-4P-3M-2C-1E-DIREC) 81 
				(SETQ N2    (NTH 1 (NTH 0 (NTH NE  LIS-4N-4P-3M-2C-1E-DIREC))))			; (LENGTH LIS-P/MAS-SPL-EJE-B)      84 
				(SETQ N3    (NTH 2 (NTH 0 (NTH NE  LIS-4N-4P-3M-2C-1E-DIREC))))
				(SETQ N4    (NTH 3 (NTH 0 (NTH NE  LIS-4N-4P-3M-2C-1E-DIREC))))
 
				(SETQ P1    (NTH 0 (NTH 1 (NTH NE  LIS-4N-4P-3M-2C-1E-DIREC))))
				(SETQ P2    (NTH 1 (NTH 1 (NTH NE  LIS-4N-4P-3M-2C-1E-DIREC))))
				(SETQ P3    (NTH 2 (NTH 1 (NTH NE  LIS-4N-4P-3M-2C-1E-DIREC))))
				(SETQ P4    (NTH 3 (NTH 1 (NTH NE  LIS-4N-4P-3M-2C-1E-DIREC))))
 
				(SETQ M12   (NTH 0 (NTH 2 (NTH NE  LIS-4N-4P-3M-2C-1E-DIREC))))
				(SETQ M23   (NTH 1 (NTH 2 (NTH NE  LIS-4N-4P-3M-2C-1E-DIREC))))
				(SETQ M34   (NTH 2 (NTH 2 (NTH NE  LIS-4N-4P-3M-2C-1E-DIREC))))
 
				(SETQ C123  (NTH 0 (NTH 3 (NTH NE  LIS-4N-4P-3M-2C-1E-DIREC))))
				(SETQ C234  (NTH 1 (NTH 3 (NTH NE  LIS-4N-4P-3M-2C-1E-DIREC))))
 
				(SETQ E1234 (NTH 0 (NTH 4 (NTH NE  LIS-4N-4P-3M-2C-1E-DIREC))))

				;	LIS-DIS-CORTE-M23-AB-DIREC =>  ( DisA  DisB ) 																									

				(SETQ DM23A (NTH 0 (NTH (+ NE 0)  LIS-DIS-CORTE-M23-AB-DIREC)))			; (LENGTH LIS-DIS-CORTE-M23-AB-DIREC) 80 
				(SETQ DM23B (NTH 1 (NTH (+ NE 0)  LIS-DIS-CORTE-M23-AB-DIREC)))

				(IF (= NE 0)
					(PROGN
						; 1-0  --------------------------------------------------------------------------------------------------
						; PUNTOS INICIO 1PLANO-23 NE=0 = 2PLANO-12 NE=1         PLANO-23 = ez(M23 P3) = M23 E1234 C123 C234	

						(COMMAND "SCP" "3P" M23 C123 E1234 )
							(SETQ pINIp (LIST (* (COS (* (/ PI 180) AgINI)) 100)
													(* (SIN (* (/ PI 180) AgINI)) 100) 0.0 ))
							(SETQ pINI  (TRANS pINIp 1 0 ))												; pINI 

						(COMMAND "SCP" "U" )
	
						(SETQ Vme1 (CAL "VEC1 ( M23 , pINI )"))

						(SETQ VA1  (CAL " M23 + (Vme1 * DM23A)"))													; VERTICE-A1   VA1  3D 
						(SETQ VB1  (CAL " M23 + (Vme1 * DM23B)"))													; VERTICE-B1   VB1  3D 

						;(SETQ EP1  (CAL "ILP  ( C123 , E1234 ,  M23 , pINI , P3 )"))						; ARISTA-1    EP1

						(SETQ EP2  (CAL "ILP  ( E1234 , C234 ,  M23 , pINI , P3 )"))						; ARISTA-2    EP2

						; 2-0  --------------------------------------------------------------------------------------------------
						; SECCION INICIO 1PLANO-23 NE=0 = 2PLANO-12 NE=1        INTERSECCION  PLANO-23 PLANO-34 = E1234 C234 

						(COMMAND "SCP" "3P" M23 C123 E1234 )

							(SETQ VA1pp (TRANS VA1 0 1 ))         (SETQ VA1p (CAL "XYof( VA1pp )"))
							(SETQ VB1pp (TRANS VB1 0 1 ))         (SETQ VB1p (CAL "XYof( VB1pp )"))

							; VERTICES INICIO  1CUADRILATERO          ANGULOS	(AgVER)															

							(SETQ pACg  (CAL "ROT ( VB1p , VA1p , (- AgVER) )"))				; ROT(P1,Po,Ag)
							(SETQ pADg  (CAL "ROT ( VB1p , VA1p ,    AgVER  )"))

							(SETQ pBCg  (CAL "ROT ( VA1p , VB1p ,    AgVER  )"))
							(SETQ pBDg  (CAL "ROT ( VA1p , VB1p , (- AgVER) )"))

							(SETQ VC1pp (CAL "ILL ( VA1p , PACg ,  VB1p , PBCg )"))    (SETQ VC1p (CAL "XYof( VC1pp )"))
							(SETQ VD1pp (CAL "ILL ( VA1p , PADg ,  VB1p , PBDg )"))    (SETQ VD1p (CAL "XYof( VD1pp )"))

							(SETQ VC1 (TRANS VC1p 1 0 ))																	; VERTICE-C1   VC1  3D 
							(SETQ VD1 (TRANS VD1p 1 0 ))																	; VERTICE-D1   VD1  3D 

						; 3-0  --------------------------------------------------------------------------------------------------
						; P-CHARNELA INICIO 1PLANO-23 NE=0 = 2PLANO-12 NE=1    INTERSECCION  PLANO-23 PLANO-34 =  E1234 C234 

							(SETQ CH1App  (TRANS E1234 0 1 ))                          (SETQ CH1Ap  (CAL "XYof( CH1App )"))
							(SETQ CH1Bpp  (TRANS C234  0 1 ))                          (SETQ CH1Bp  (CAL "XYof( CH1Bpp )"))

							(SETQ CHac1pp (CAL "ILL ( VA1p , VC1p , CH1Ap , CH1Bp )")) (SETQ CHac1p (CAL "XYof( CHac1pp )"))
							(SETQ CHad1pp (CAL "ILL ( VA1p , VD1p , CH1Ap , CH1Bp )")) (SETQ CHad1p (CAL "XYof( CHad1pp )"))
							(SETQ CHbc1pp (CAL "ILL ( VB1p , VC1p , CH1Ap , CH1Bp )")) (SETQ CHbc1p (CAL "XYof( CHbc1pp )"))
							(SETQ CHbd1pp (CAL "ILL ( VB1p , VD1p , CH1Ap , CH1Bp )")) (SETQ CHbd1p (CAL "XYof( CHbd1pp )"))

							(SETQ CHac1 (TRANS CHac1p 1 0 ))															; CHARNELA  CHac1  3D 
							(SETQ CHad1 (TRANS CHad1p 1 0 ))															; CHARNELA  CHad1  3D 
							(SETQ CHbc1 (TRANS CHbc1p 1 0 ))															; CHARNELA  CHbc1  3D 
							(SETQ CHbd1 (TRANS CHbd1p 1 0 ))															; CHARNELA  CHbd1  3D 
						(COMMAND "SCP" "U" )


						; 4-0  TRATA RESULTADOS INICIO																									

						(COMMAND "COLOR"   1 "LINEA" M23  VA1 "")
						(COMMAND "COLOR"   2 "LINEA" M23  VB1 "")
						(COMMAND "COLOR"   7 "LINEA" VA1  VC1 "")
						(COMMAND "COLOR" 255 "LINEA" VA1  VD1 "")
						(COMMAND "COLOR" 255 "LINEA" VB1  VC1 "")
						(COMMAND "COLOR"   7 "LINEA" VB1  VD1 "")

						(COMMAND "COLOR"   1 "PUNTO" VA2 )
						(COMMAND "COLOR"   2 "PUNTO" VB2 )
						(COMMAND "COLOR"   3 "PUNTO" VC2 )
						(COMMAND "COLOR"   4 "PUNTO" VD2 )

						;(COMMAND "COLOR" 7 "3DCARA"   VA1  VC1  VB1  VD1 "")
						(SETQ LIS-4P-SECC (CONS (LIST VA1  VC1  VB1  VD1 ) LIS-4P-SECC ))

					) ; pro 

					;-----------------------------------------------------------------------------------------------------------

					(PROGN
						; 1-N  --------------------------------------------------------------------------------------------------
						; PUNTOS RESTANTES 2PLANO-23 NE=n = 1PLANO-34 NE=0       PLANO-23 = ez(M23 P3) = M23 E1234 C123 C234	

						(SETQ EP1 EP2 )

						(SETQ Vme2 (CAL " VEC1 ( M23 , EP1 )"))							; VECTOR ORIENTACION

						(IF (< (CAL " ABS( Vme1 + Vme2 ) ") (SQRT 2)) (SETQ NOri (+ NOri 1)))
						(IF (= (REM NOri 2) 1)  (SETQ VEori (CAL " Vme2 * -1 ")) (SETQ VEori  Vme2 ))
						(SETQ Vme1  Vme2 )

						(SETQ VA2   (CAL " M23 + (VEori * DM23A)"))													; VERTICE-A2   VA2  3D 
						(SETQ VB2   (CAL " M23 + (VEori * DM23B)"))													; VERTICE-B2   VB2  3D 

						(SETQ EP2  (CAL "ILP ( E1234 , C234 ,  M23 , EP1 , P3 )"))								; ARISTA-2    EP2     

						; 2-N  --------------------------------------------------------------------------------------------------
						; SECCION RESTANTES 2PLANO-23      NE = 1..N          INTERSECCION  PLANO-23 PLANO-34 = E1234 C234 		

						(COMMAND "SCP" "3P" M23 C123 E1234 )

							(SETQ CHac1pp (TRANS CHac1 0 1 ))    (SETQ CHac1p (CAL "XYof( CHac1pp )"))
							(SETQ CHad1pp (TRANS CHad1 0 1 ))    (SETQ CHad1p (CAL "XYof( CHad1pp )"))
							(SETQ CHbc1pp (TRANS CHbc1 0 1 ))    (SETQ CHbc1p (CAL "XYof( CHbc1pp )"))
							(SETQ CHbd1pp (TRANS CHbd1 0 1 ))    (SETQ CHbd1p (CAL "XYof( CHbd1pp )"))

							(SETQ VA2pp  (TRANS VA2 0 1 ))       (SETQ VA2p   (CAL "XYof( VA2pp )"))
							(SETQ VB2pp  (TRANS VB2 0 1 ))       (SETQ VB2p   (CAL "XYof( VB2pp )"))

							(SETQ VC2pp (CAL "ILL ( VA2p , CHac1p , VB2p , CHbc1p )"))  (SETQ VC2p (CAL "XYof( VC2pp )"))
							(SETQ VD2pp (CAL "ILL ( VA2p , CHad1p , VB2p , CHbd1p )"))  (SETQ VD2p (CAL "XYof( VD2pp )"))

							(SETQ VC2 (TRANS VC2p 1 0 ))																	; VERTICE-C2   VC2  3D 
							(SETQ VD2 (TRANS VD2p 1 0 ))																	; VERTICE-D2   VD2  3D 

						; 3-N  --------------------------------------------------------------------------------------------------
						; P-CHARNELA RESTANTES 2PLANO-23   NE = 1..N          INTERSECCION  PLANO-23 PLANO-34  =  E1234 C234 	

							(SETQ CH2App  (TRANS E1234 0 1 ))                             (SETQ CH2Ap  (CAL "XYof( CH2App )"))
							(SETQ CH2Bpp  (TRANS C234  0 1 ))                             (SETQ CH2Bp  (CAL "XYof( CH2Bpp )"))

							(SETQ CHac2pp (CAL "ILL ( VA2p , VC2p , CH2Ap , CH2Bp )"))    (SETQ CHac2p (CAL "XYof( CHac2pp )"))
							(SETQ CHad2pp (CAL "ILL ( VA2p , VD2p , CH2Ap , CH2Bp )"))    (SETQ CHad2p (CAL "XYof( CHad2pp )"))
	 						(SETQ CHbc2pp (CAL "ILL ( VB2p , VC2p , CH2Ap , CH2Bp )"))    (SETQ CHbc2p (CAL "XYof( CHbc2pp )"))
							(SETQ CHbd2pp (CAL "ILL ( VB2p , VD2p , CH2Ap , CH2Bp )"))    (SETQ CHbd2p (CAL "XYof( CHbd2pp )"))

							(SETQ CHac2 (TRANS CHac2p 1 0 ))															; CHARNELA  CHac2  3D 
							(SETQ CHad2 (TRANS CHad2p 1 0 ))															; CHARNELA  CHad2  3D 
							(SETQ CHbc2 (TRANS CHbc2p 1 0 ))															; CHARNELA  CHbc2  3D 
							(SETQ CHbd2 (TRANS CHbd2p 1 0 ))															; CHARNELA  CHbd2  3D 
						(COMMAND "SCP" "U" )


						; 4-N  TRATA RESULTADOS RESTANTES																								

						(COMMAND "COLOR"   1 "LINEA" M23  VA2 "")
						(COMMAND "COLOR"   2 "LINEA" M23  VB2 "")
						(COMMAND "COLOR"   7 "LINEA" VA2  VC2 "")
						(COMMAND "COLOR" 255 "LINEA" VA2  VD2 "")
						(COMMAND "COLOR" 255 "LINEA" VB2  VC2 "")
						(COMMAND "COLOR"   7 "LINEA" VB2  VD2 "")

						(COMMAND "COLOR"   1 "PUNTO" VA2 )
						(COMMAND "COLOR"   2 "PUNTO" VB2 )
						(COMMAND "COLOR"   3 "PUNTO" VC2 )
						(COMMAND "COLOR"   4 "PUNTO" VD2 )

						;(COMMAND "COLOR" 7 "3DCARA"   VA2  VC2  VB2  VD2 "")
						(SETQ LIS-4P-SECC (CONS (LIST VA2  VC2  VB2  VD2 ) LIS-4P-SECC ))

						(SETQ  CHac1  CHac2 )
						(SETQ  CHad1  CHad2 )
						(SETQ  CHbc1  CHbc2 )
						(SETQ  CHbd1  CHbd2 )

					) ; pro 
			  
				) ; if NE=0 
			) ; repe NE 

			;	PINTA BORDES EJES EVOLUTA	2D  3D																															

			(SETQ NEE -1)
			(REPEAT (- (LENGTH LIS-4P-SECC) 1)  ; (LIST VA2  VC2  VB2  VD2 )
				(SETQ NEE (+ NEE 1))

				(SETQ PAA1 (NTH 0 (NTH (+ NEE 0)  LIS-4P-SECC)))
				(SETQ PCC1 (NTH 1 (NTH (+ NEE 0)  LIS-4P-SECC)))
				(SETQ PBB1 (NTH 2 (NTH (+ NEE 0)  LIS-4P-SECC)))
				(SETQ PDD1 (NTH 3 (NTH (+ NEE 0)  LIS-4P-SECC)))

				(SETQ PAA2 (NTH 0 (NTH (+ NEE 1)  LIS-4P-SECC)))
				(SETQ PCC2 (NTH 1 (NTH (+ NEE 1)  LIS-4P-SECC)))
				(SETQ PBB2 (NTH 2 (NTH (+ NEE 1)  LIS-4P-SECC)))
				(SETQ PDD2 (NTH 3 (NTH (+ NEE 1)  LIS-4P-SECC)))

				(COMMAND "COLOR" 7 "LINEA" PAA1  PAA2 "")
				(COMMAND "COLOR" 7 "LINEA" PCC1  PCC2 "")
				(COMMAND "COLOR" 7 "LINEA" PBB1  PBB2 "")
				(COMMAND "COLOR" 7 "LINEA" PDD1  PDD2 "")

			) ; repe

		) ; pro

		(PROGN
				(TERPRI) (PROMPT "---- COLIMEALES o COPLANARIOS => ( NO EJECUTA PINTA-EVOLUTA )")
		) ; pro
	) ; if

	)) ; pro if   PINTA-EJES-EVOLUTA
	;	(14)																																											
 	;======================================================================================================================================


 	;======================================================================================================================================
	;  (15) PINTA-3DCARAS  3D 2D Patrones																																	
	;......................................................................................................................................
	(SETQ  PINTA-3DCARAS-3D-2D  'NO )  (IF (= PINTA-3DCARAS-3D-2D  'SI )  (PROGN

		(SETQ KKx  130 )																					; PUNTO OREGEN 1PATRONES 
		(SETQ KKy    0 )

		(SETQ SEPA 110 )																					; SEPARACION ENTRE PATRONES 

		(SETQ DESf 710 )																			; DESPLAZAMIENTO FIGURA 3DC 

		; PINTA 4 SUPERFICIES EXTERNAS																																		

		(SETQ NP1 -1)
		(REPEAT 4																							; 4 CARAS    (LENGTH (NTH 0 LIS-4P-SECC)) 
			(SETQ NP1 (+ NP1 1))
			(SETQ NP2 (+ NP1 1)) (IF (= NP2 4) (SETQ NP2 0)  )

			(SETQ KKx (+ KKx SEPA ))																	; SEPARACION ENTRE PATRONES 

			(SETQ KK1 (LIST    KKx     KKy  0 ))
			(SETQ KK2 (LIST (+ KKx 1)  KKy  0 ))

			(SETQ NCA -1)
			(REPEAT (- (LENGTH LIS-4P-SECC) 1)
				(SETQ NCA (+ NCA 1))

				(SETQ AA1 (NTH NP1 (NTH (+ NCA 0)  LIS-4P-SECC )))							; (LIST  AA1  BB1  CC1  DD1 ) 
				(SETQ BB1 (NTH NP2 (NTH (+ NCA 0)  LIS-4P-SECC )))
				(SETQ AA2 (NTH NP1 (NTH (+ NCA 1)  LIS-4P-SECC )))
				(SETQ BB2 (NTH NP2 (NTH (+ NCA 1)  LIS-4P-SECC )))

				(SETQ AA1des (CAL " AA1 + [ DESf ,0,0] "))
				(SETQ BB1des (CAL " BB1 + [ DESf ,0,0] "))
				(SETQ AA2des (CAL " AA2 + [ DESf ,0,0] "))
				(SETQ BB2des (CAL " BB2 + [ DESf ,0,0] "))

				(COMMAND "COLOR" 2 "3DCARA" AA1des  AA2des  BB2des  BB1des "")				; PINTA FIGURA DESPLAZADA 3DC 3D 

				(COMMAND "SCP" "3P" AA1 BB1 AA2 )
					(SETQ AA1pz (TRANS AA1 0 1))    (SETQ AA1p (CAL "XYof( AA1pz )"))
					(SETQ BB1pz (TRANS BB1 0 1))    (SETQ BB1p (CAL "XYof( BB1pz )"))
					(SETQ AA2pz (TRANS AA2 0 1))    (SETQ AA2p (CAL "XYof( AA2pz )"))
					(SETQ BB2pz (TRANS BB2 0 1))    (SETQ BB2p (CAL "XYof( BB2pz )"))

					;(COMMAND "COLOR" 2  "TEXTO" AA1p 0.4 0 (STRCAT " " (ITOA N6)))										; TEXTO 3DCARA  3D 

				(COMMAND "SCP" "U" )

				(COMMAND "SCP" "3P" KK1 KK2 "" )

					(COMMAND "COLOR" 5 "3DCARA" AA1p AA2p BB2p BB1p "")														; PINTA 3DCARA  2D 

					;(COMMAND "COLOR" 5  "TEXTO" AA1p 0.4 0 (STRCAT " " (ITOA N6)))										; TEXTO 3DCARA  2D 

					(SETQ AA2pU (TRANS AA2p 1 0))
					(SETQ BB2pU (TRANS BB2p 1 0))

				(COMMAND "SCP" "U" )

				(SETQ KK1  AA2pU)
				(SETQ KK2  BB2pU)

			) ; repe NCA
		) ; repe NP1

		; PINTA 1 SUPERFICIE INTERNA																																			

			(SETQ KKx (+ KKx SEPA ))																	; SEPARACION ENTRE PATRONES 

			(SETQ KK1 (LIST    KKx     KKy  0 ))
			(SETQ KK2 (LIST (+ KKx 1)  KKy  0 ))

			(SETQ NCA -1)
			(REPEAT (- (LENGTH LIS-4P-SECC) 1)
				(SETQ NCA (+ NCA 1))

				(SETQ AA1 (NTH 0 (NTH (+ NCA 0)  LIS-4P-SECC )))							; ( AA1  BB1  CC1  DD1 ) <=> ( VA2  VC2  VB2  VD2 )
				(SETQ BB1 (NTH 2 (NTH (+ NCA 0)  LIS-4P-SECC )))
				(SETQ AA2 (NTH 0 (NTH (+ NCA 1)  LIS-4P-SECC )))
				(SETQ BB2 (NTH 2 (NTH (+ NCA 1)  LIS-4P-SECC )))

				(COMMAND "SCP" "3P" AA1 BB1 AA2 )
					(SETQ AA1pz (TRANS AA1 0 1))    (SETQ AA1p (CAL "XYof( AA1pz )"))
					(SETQ BB1pz (TRANS BB1 0 1))    (SETQ BB1p (CAL "XYof( BB1pz )"))
					(SETQ AA2pz (TRANS AA2 0 1))    (SETQ AA2p (CAL "XYof( AA2pz )"))
					(SETQ BB2pz (TRANS BB2 0 1))    (SETQ BB2p (CAL "XYof( BB2pz )"))

					;(COMMAND "COLOR" 2  "TEXTO" AA1p 0.4 0 (STRCAT " " (ITOA N6)))										; TEXTO 3DCARA  3D 

				(COMMAND "SCP" "U" )

				(COMMAND "SCP" "3P" KK1 KK2 "" )

					(COMMAND "COLOR" 7 "3DCARA" AA1p AA2p BB2p BB1p "")														; PINTA 3DCARA  2D 

					;(COMMAND "COLOR" 5  "TEXTO" AA1p 0.4 0 (STRCAT " " (ITOA N6)))										; TEXTO 3DCARA  2D 

					(SETQ AA2pU (TRANS AA2p 1 0))
					(SETQ BB2pU (TRANS BB2p 1 0))

				(COMMAND "SCP" "U" )

				(SETQ KK1  AA2pU)
				(SETQ KK2  BB2pU)

			) ; repe NCA

 	)) ; pro if   PINTA-3DCARAS-3D-2D
	;	(15)																																											
 	;======================================================================================================================================


 	;======================================================================================================================================
	;	(16) PARANDO																																								
	;......................................................................................................................................
	(SETVAR "blipmode" 1)
	(SETVAR "cmdecho"  1)

	(TERPRI) (PROMPT " =================================================== ")
	(TERPRI) (PROMPT " >>>> FINAL >>>>>>>> DESARROLLO-KIWI-51 >>>>> ")
	(TERPRI) (PROMPT " =================================================== ") (TERPRI)

  	;	(16)																																											
 	;======================================================================================================================================

) ;  DESARROLLO-KIWI-51 

;=========================================================================================================================================
