
;-----------------------------------------------------------------------------------------------------------------------------------------
;																																														
;	( DESARROLLO-KIWI-52 ) de DESARROLLO-KIWI-51 + PUN-CUR-EJE-BASE-00 + PUNTOS-CORTE-01                                  15/09/2007			
;																																														
;        RESULTADO:      SUPERFICIES EXTERIOR e INTERIOR 3D 2D Patrones                                           								
;																																														
;        DATOS PARTIDA:  ALZADO (1SUR + 2SUR)  +  ALZADO (1OESTE + 2OESTE)  =>  LIS-P-EJE-BASE									          		
;																																														
;	                      PERFIL IZQUIERTO y DERECHO => (Distancias DIAGUNALES SECCIONES)                                        				
;																																														

;-----------------------------------------------------------------------------------------------------------------------------------------



;-----------------------------------------------------------------------------------------------------------------------------------------
;	(01) (PUNTOS-SPLI-DIVIDE_N-SPL) = PUNTEA CURVA a NDIVISIONES ( NDiv  N-SPL1 ) => (LIS-Pun-Spli)													
;-----------------------------------------------------------------------------------------------------------------------------------------

(DEFUN PUNTOS-SPLI-DIVIDE_N-SPL (/  )

	(SETQ LIS-Pun-Spli  nil)
	(SETQ	 Elen (MEMBER (ASSOC 10 (ENTGET N-SPL1)) (ENTGET N-SPL1))							; lista a partir del elemento (incluido) 
		    P-1    (CDR (NTH      0              Elen))											; primer elemento 
		    P-Uo    (CDR (NTH (- (LENGTH Elen) 1) Elen)) )											; ultimo elemento 
	(COMMAND  "COLOR" 1 "PUNTO"  P-1)																	; PINTA Primer Punto (en Base de Datos) 
	(SETQ  N-1P (ENTLAST))																					; Nombre ultima entidad principal = 1 punto 
	(COMMAND	 "COLOR" 2 "DIVIDE" N-SPL1 NDiv															; PINTA Punto Divide (en Base de Datos) 
			    "COLOR" 5 "PUNTO"  P-Uo       )															; PINTA Ultimo Punto (en Base de Datos) 

	;	PUNTOS SECCION X (PX1-PXn) =>  LIS-Pun-Spli																														
	(SETQ	N-P1      nil
		   N-P2      nil
		   N-P2      N-1P
		   LIS-Pun-Spli   nil
		   LIS-Pun-Spli  (LIST (CDR (ASSOC 10 (ENTGET N-1P))))									; LIS-Pun-Spli => 1 punto 
		   WW        T )

	(WHILE WW
	  	(SETQ N-P1 (ENTNEXT N-1P))																		; nombre entidad siguiente 
		(IF (= N-P1 nil)	(SETQ WW nil)
			(PROGN
				(SETQ LIS-Pun-Spli (CONS (CDR (ASSOC 10 (ENTGET N-P1))) LIS-Pun-Spli))		; LIS-Pun-Spli => Resto PUNTOS con ULTIMO 
				(SETQ  N-1P N-P1 )
				(ENTDEL N-P1)																					; BORRA PUNTO 
			) ; pro
		) ; if 
	) ; whi
	(SETQ LIS-Pun-Spli (REVERSE LIS-Pun-Spli))
	(ENTDEL N-P2)																								; BORRA PUNTO 

) ;  DEFUN PUNTOS-SPLI-DIVIDE_N-SPL

;--(01)-----------------------------------------------------------------------------------------------------------------------------------


;-----------------------------------------------------------------------------------------------------------------------------------------
;	(02) PUNTOS-SPLI-GRADUA_N-SPL  =>   GRADUA SPLINE ( N-SPL2 ) con ( NGRADUA ) => LISTA PUNTOS ( LIS-PGX )  										
;-----------------------------------------------------------------------------------------------------------------------------------------

	(DEFUN PUNTOS-SPLI-GRADUA_N-SPL ( / )

		(SETQ ALIS  (ENTGET N-SPL2))  																	; lista Spline A 
		(SETQ AELE  (ASSOC 10 ALIS))  																	; 1 Punto Asociado a 10 (10.punto) 
		(SETQ AELES (MEMBER AELE ALIS)) 																	; lista a partir del Alterior (10.punto)..(11.punto)
		(SETQ X-primer (CDR (NTH 0 AELES))) 															; primer elemento (10.punto) 
		(SETQ X-ultimo (CDR (NTH (- (LENGTH AELES) 1) AELES)))									; ultimo elemento (11.punto) 
		;(COMMAND "COLOR" 2   "TEXTO" X-primer 10.0 90 "A")										; TEXTO = A 
		(COMMAND "PUNTO" X-primer)																			; PINTA 1 punto 
		(SETQ N-enti-A1 (ENTLAST))																			; nombre ultima entidad principal 1 punto A 
		(COMMAND "GRADUA" N-SPL2  NGRADUA)																; GRADUA SPLI-A 
		(COMMAND "PUNTO" X-ultimo)																			; PINTA Ultimo Punto A 
	
		;	PUNTOS SECCION-A (PA1-PAn) =>   LIS-PGX  Lon-LPA																											
		(SETQ LIS-PGX nil)																					; LISTA  PUNTOS-A 
		(SETQ LIS-PGX (CONS (CDR (ASSOC 10 (ENTGET N-enti-A1))) LIS-PGX))						; lista entidad -> (1 Punto-A) 
		(SETQ W1A T)
		(WHILE W1A
			(SETQ N-enti-A2 (ENTNEXT N-enti-A1))														; Nombre entidad siguiente 
			(COMMAND "BORRA" N-enti-A1 "")
			(IF (= N-enti-A2 nil)  (SETQ W1A nil)
				(PROGN
					(SETQ LIS-PGX (CONS (CDR (ASSOC 10 (ENTGET N-enti-A2))) LIS-PGX))
					(SETQ N-enti-A1  N-enti-A2 )
				);progn
			);if
		) ;While W1A

		(SETQ LIS-PGX  (REVERSE LIS-PGX ))																; LIS-PGX 

	) ; Defun PUNTOS-SPLI-GRADUA_N-SPL

;--(02)-----------------------------------------------------------------------------------------------------------------------------------


;-----------------------------------------------------------------------------------------------------------------------------------------
;  (03) CALCULO  LISTAS-PUNTOS  =>    LIS-P-PER-IZ    LIS-P-PER-DE    LIS-P-ALZA-SUR    LIS-P-ALZA-OES												
;-----------------------------------------------------------------------------------------------------------------------------------------

(DEFUN CAL-LIS-PUNTOS--PER_DE-IZ--ALZA_SUR-OES (/  )

	;  LONGITUD SPLINE => GRADUA-SPLINES =>  NDivSUR1   NDivSUR2   NDivOES1   NDivOES2																	

	(SETQ N-SPL2  N-AlzSUR1 )  (PUNTOS-SPLI-GRADUA_N-SPL)  (SETQ LongSUR1 (* (- (LENGTH LIS-PGX) 2) NGRADUA ))   ; 
	(SETQ N-SPL2  N-AlzSUR2 )  (PUNTOS-SPLI-GRADUA_N-SPL)  (SETQ LongSUR2 (* (- (LENGTH LIS-PGX) 2) NGRADUA ))   ; 
	(SETQ N-SPL2  N-AlzOES1 )  (PUNTOS-SPLI-GRADUA_N-SPL)  (SETQ LongOES1 (* (- (LENGTH LIS-PGX) 2) NGRADUA ))   ; 
	(SETQ N-SPL2  N-AlzOES2 )  (PUNTOS-SPLI-GRADUA_N-SPL)  (SETQ LongOES2 (* (- (LENGTH LIS-PGX) 2) NGRADUA ))   ; 

	(SETQ LonParSUR (/ (+ LongSUR1  LongSUR2 ) (* 2  NDIVIDE )))
	(SETQ LonParOES (/ (+ LongOES1  LongOES2 ) (* 6  NDIVIDE )))

	(SETQ NDivSUR1d (/ LongSUR1  LonParSUR ))   (SETQ NDivSUR1 (CAL " ROUND ( NDivSUR1d )"))
	(SETQ NDivSUR2d (/ LongSUR2  LonParSUR ))   (SETQ NDivSUR2 (CAL " ROUND ( NDivSUR2d )"))
	(SETQ NDivOES1d (/ LongOES1  LonParOES ))   (SETQ NDivOES1 (CAL " ROUND ( NDivOES1d )"))
	(SETQ NDivOES2d (/ LongOES2  LonParOES ))   (SETQ NDivOES2 (CAL " ROUND ( NDivOES2d )"))

	;  CALCULO  LISTAS-PUNTOS       LIS-P-PER-IZ    LIS-P-PER-DE    ( LIS-P-ALZA-SUR1 + LIS-P-ALZA-SUR2 ) => LIS-P-ALZA-SUR						
	;                                                               ( LIS-P-ALZA-OES1 + LIS-P-ALZA-OES2 ) => LIS-P-ALZA-OES						

	(SETQ N-SPL1 N-PER-IZ   NDiv (* 4 NDIVIDE)) (PUNTOS-SPLI-DIVIDE_N-SPL ) (SETQ LIS-P-PER-IZ  LIS-PUN-SPLI)  ; (LENGTH LIS-P-PER-IZ) 
	(SETQ N-SPL1 N-PER-DE   NDiv (* 4 NDIVIDE)) (PUNTOS-SPLI-DIVIDE_N-SPL ) (SETQ LIS-P-PER-DE  LIS-PUN-SPLI)  ; (LENGTH LIS-P-PER-DE) 

	(SETQ N-SPL1 N-AlzSUR1  NDiv NDivSUR1)  (PUNTOS-SPLI-DIVIDE_N-SPL )  (SETQ LIS-P-ALZA-SUR1  LIS-PUN-SPLI) ; (LENGTH LIS-P-ALZA-SUR1) 
	(SETQ N-SPL1 N-AlzSUR2  NDiv NDivSUR2)  (PUNTOS-SPLI-DIVIDE_N-SPL )  (SETQ LIS-P-ALZA-SUR2  LIS-PUN-SPLI) ; (LENGTH LIS-P-ALZA-SUR2) 
	(SETQ N-SPL1 N-AlzOES1  NDiv NDivOES1)  (PUNTOS-SPLI-DIVIDE_N-SPL )  (SETQ LIS-P-ALZA-OES1  LIS-PUN-SPLI) ; (LENGTH LIS-P-ALZA-OES1) 
	(SETQ N-SPL1 N-AlzOES2  NDiv NDivOES2)  (PUNTOS-SPLI-DIVIDE_N-SPL )  (SETQ LIS-P-ALZA-OES2  LIS-PUN-SPLI) ; (LENGTH LIS-P-ALZA-OES2) 

	(IF (EQUAL (LAST LIS-P-ALZA-SUR1) (NTH 0 LIS-P-ALZA-SUR2) mUNI )																	; Ult_SUR1 = 1_SUR2
		(PROGN (SETQ LIS-P-ALZA-SUR (APPEND LIS-P-ALZA-SUR1 (MEMBER (NTH 1  LIS-P-ALZA-SUR2) LIS-P-ALZA-SUR2 )))) ; (LENGTH LIS-P-ALZA-SUR) 
		(PROGN (TERPRI) (PROMPT " >>>>  Ult_SUR1 y 1_SUR2 => NO SON IGUALES en LIS-P-ALZA-SUR"))) ; if

	(IF (EQUAL (LAST LIS-P-ALZA-OES1) (NTH 0 LIS-P-ALZA-OES2) mUNI )																	; Ult_OES1 = 1_OES2
		(PROGN (SETQ LIS-P-ALZA-OES (APPEND LIS-P-ALZA-OES1 (MEMBER (NTH 1  LIS-P-ALZA-OES2) LIS-P-ALZA-OES2 )))) ; (LENGTH LIS-P-ALZA-OES) 
		(PROGN (TERPRI) (PROMPT " >>>>  Ult_OES1 y 1_OES2 => NO SON IGUALES en LIS-P-ALZA-OES"))) ; if

) ; Defun   CAL-LIS-PUNTOS--PER_DE-IZ--ALZA_SUR-OES 

;--(03)-----------------------------------------------------------------------------------------------------------------------------------


;=========================================================================================================================================
;  (04) CORDENADA Y=0 en LISTAS =>    LIS-P-PER-IZo    LIS-P-PER-DEo    LIS-P-ALZA-SURo    LIS-P-ALZA-OESo X=0										
;.........................................................................................................................................

(DEFUN LIS-Cordenada_Y=0--PER_DEo-IZo--ALZA_SURo-OESo  (/  )

	(SETQ LIS-P-PER-IZo nil)
	(SETQ LIS-P-PER-DEo nil)
	(SETQ NZ0 -1 )
	(REPEAT (LENGTH LIS-P-PER-IZ)
		(SETQ NZ0 (+ NZ0 1))
		(SETQ PAz (NTH NZ0  LIS-P-PER-IZ))      (SETQ PAz2D (CAL " XZof( PAz )"))			; Y = 0 
		(SETQ PBz (NTH NZ0  LIS-P-PER-DE))      (SETQ PBz2D (CAL " XZof( PBz )"))			; Y = 0 
		(SETQ LIS-P-PER-IZo (CONS PAz2D  LIS-P-PER-IZo ))
		(SETQ LIS-P-PER-DEo (CONS PBz2D  LIS-P-PER-DEo ))
	) ; repe NZ0 
	(SETQ LIS-P-PER-IZo (REVERSE LIS-P-PER-IZo))														; (LENGTH LIS-P-PER-IZo) 
	(SETQ LIS-P-PER-DEo (REVERSE LIS-P-PER-DEo))														; (LENGTH LIS-P-PER-DEo) 


	(SETQ LIS-P-ALZA-SURo nil)
	(SETQ NZ1 -1 )
	(REPEAT (LENGTH LIS-P-ALZA-SUR)
		(SETQ NZ1 (+ NZ1 1))
		(SETQ PAz (NTH NZ1  LIS-P-ALZA-SUR))      (SETQ PAz2D (CAL " XZof( PAz )"))		; Y = 0 
		(SETQ LIS-P-ALZA-SURo (CONS PAz2D  LIS-P-ALZA-SURo ))
	) ; repe NZ1 
	(SETQ LIS-P-ALZA-SURo (REVERSE LIS-P-ALZA-SURo))												; (LENGTH LIS-P-ALZA-SURo) 


	(SETQ LIS-P-ALZA-OESo nil)
	(SETQ NZ2 -1 )
	(REPEAT (LENGTH LIS-P-ALZA-OES)
		(SETQ NZ2 (+ NZ2 1))
		(SETQ PAz (NTH NZ2  LIS-P-ALZA-OES))      (SETQ PAz2D (CAL " YZof( PAz )"))		; X = 0 
		(SETQ LIS-P-ALZA-OESo (CONS PAz2D  LIS-P-ALZA-OESo ))
	) ; repe NZ2 
	(SETQ LIS-P-ALZA-OESo (REVERSE LIS-P-ALZA-OESo))												; (LENGTH LIS-P-ALZA-OESo) 

) ; Defun   LIS-Cordenada_Y=0--PER_DEo-IZo--ALZA_SURo-OESo 

;--(04)-----------------------------------------------------------------------------------------------------------------------------------


;=========================================================================================================================================
;  (05) CALCULO PUNTOS CURVA-EJE-BASE =>    LIS-P-ALZA-OES-Cota	y  LIS-P-EJE-BASE  																		
;.........................................................................................................................................

(DEFUN LIS-PUN__ALZA-OES-Cota__EJE-BASE  (/  )

	(SETQ LIS-P-EJE-BASE      nil )
	(SETQ LIS-P-ALZA-OES-Cota nil )

	(SETQ LIS-P-EJE-BASE      (CONS (LIST 0.0 0.0 0.0)  LIS-P-EJE-BASE     ))
	(SETQ LIS-P-ALZA-OES-Cota (CONS (LIST 0.0 0.0 0.0)  LIS-P-ALZA-OES-Cota))


	(SETQ NOES -1 )  ; ( NOES  0...178 )  (NDIVIDE = 30) (* 6 NDIVIDE) = 180  (LENGTH LIS-P-ALZA-OESo)  61 181
	(SETQ NSUR  0 )  ; ( NSUR  1... 59 )  (NDIVIDE = 30) (* 2 NDIVIDE) =  60  (LENGTH LIS-P-ALZA-SURo)  21  61

	(REPEAT (- (LENGTH LIS-P-ALZA-SURo) 1 )																			; (LENGTH LIS-P-ALZA-SURo)  
		(SETQ NSUR (+ NSUR 1))
 
		(SETQ PSurX (NTH NSUR  LIS-P-ALZA-SURo))
		(SETQ PSurO (LIST 0.0 0.0 (CADDR PSurX)))
		(SETQ COTA (CADDR PSurX ))

		; PUNTOS CORTE ALZA-OES	(COTA) ALZA-SUR																															
		(SETQ CONTROL-OES nil )
		(SETQ WWa T )
		(WHILE WWa
			(SETQ NOES (+ NOES 1))
			(IF (>= NOES (- (LENGTH LIS-P-ALZA-OESo) 1))   (PROGN  (SETQ WWa nil ))						; (LENGTH LIS-P-ALZA-OESo)  
				(PROGN
					(SETQ POes1  (NTH (+ NOES 0) LIS-P-ALZA-OESo))   
					(SETQ POes2  (NTH (+ NOES 1) LIS-P-ALZA-OESo))   

					(SETQ Oy1 (CADR POes1))   (SETQ Oz1 (CADDR POes1))
					(SETQ Oy2 (CADR POes2))   (SETQ Oz2 (CADDR POes2))

					(COND
						((EQUAL Oz1 COTA mUNI)          	   (SETQ PinOa  POes1)
																		(SETQ CONTROL-OES T )  (SETQ WWa nil)  (SETQ NOES (- NOES 1))
																		(SETQ VVy  (CAL " VEC ( PSurO , PinOa )"))  (SETQ PEJEa (CAL " PSurX + VVy "))
																		(SETQ LIS-P-EJE-BASE      (CONS PEJEa  LIS-P-EJE-BASE     ))
																		(SETQ LIS-P-ALZA-OES-Cota (CONS PinOa  LIS-P-ALZA-OES-Cota))

																		;(COMMAND "COLOR" 1 "LINEA" PinOa  PEJEa "" )
																		;(COMMAND "COLOR" 1 "LINEA" PSurX  PEJEa "" )
																		;(COMMAND "COLOR" 5 "PUNTO" PinOa )
						) ; con1
						((EQUAL Oz2 COTA mUNI)          	   (SETQ PinOb  POes2)
																		(SETQ CONTROL-OES T )  (SETQ WWa nil)  (SETQ NOES (- NOES 1))
																		(SETQ VVy  (CAL " VEC ( PSurO , PinOb )"))  (SETQ PEJEb (CAL " PSurX + VVy "))
																		(SETQ LIS-P-EJE-BASE      (CONS PEJEb  LIS-P-EJE-BASE     ))
																		(SETQ LIS-P-ALZA-OES-Cota (CONS PinOb  LIS-P-ALZA-OES-Cota))

																		;(COMMAND "COLOR" 2 "LINEA" PinOb  PEJEb "" )
																		;(COMMAND "COLOR" 2 "LINEA" PSurX  PEJEb "" )
																		;(COMMAND "COLOR" 5 "PUNTO" PinOb )
						) ; con2
						((AND (< Oz1 COTA) (> Oz2 COTA))    (SETQ PinOc  (CAL "PLT ( POes1 , POes2 , (COTA - Oz1)/(Oz2 - Oz1) )"))
																		(SETQ CONTROL-OES T )  (SETQ WWa nil)  (SETQ NOES (- NOES 1))
																		(SETQ VVy  (CAL " VEC ( PSurO , PinOc )"))  (SETQ PEJEc (CAL " PSurX + VVy "))
																		(SETQ LIS-P-EJE-BASE      (CONS PEJEc  LIS-P-EJE-BASE     ))
																		(SETQ LIS-P-ALZA-OES-Cota (CONS PinOc  LIS-P-ALZA-OES-Cota))

																		;(COMMAND "COLOR" 3 "LINEA" PinOc  PEJEc "" )
																		;(COMMAND "COLOR" 3 "LINEA" PSurX  PEJEc "" )
																		;(COMMAND "COLOR" 5 "PUNTO" PinOc )
						) ; con3
						((AND (> Oz1 COTA) (< Oz2 COTA))    (SETQ PinOd  (CAL "PLT ( POes2 , POes1 , (COTA - Oz2)/(Oz1 - Oz2) )"))
																		(SETQ CONTROL-OES T )  (SETQ WWa nil)  (SETQ NOES (- NOES 1))
																		(SETQ VVy  (CAL " VEC ( PSurO , PinOd )"))  (SETQ PEJEd (CAL " PSurX + VVy "))
																		(SETQ LIS-P-EJE-BASE      (CONS PEJEd  LIS-P-EJE-BASE     ))
																		(SETQ LIS-P-ALZA-OES-Cota (CONS PinOd  LIS-P-ALZA-OES-Cota))

																		;(COMMAND "COLOR" 4 "LINEA" PinOd  PEJEd "" )
																		;(COMMAND "COLOR" 4 "LINEA" PSurX  PEJEd "" )
																		;(COMMAND "COLOR" 5 "PUNTO" PinOd )
						) ; con4
					) ; COND
				) ; pro
			) ; if
		) ; WWa

		(IF (= CONTROL-OES nil ) (PROGN (TERPRI) (PROMPT " >>>>  NO PUNTO-CORTE  ALZA-OES   en NSUR = ") (PRIN1 NSUR ) (TERPRI)))

	) ; repe NSUR

	(SETQ LIS-P-EJE-BASE      (REVERSE LIS-P-EJE-BASE      ))													; (LENGTH LIS-P-EJE-BASE)       
	(SETQ LIS-P-ALZA-OES-Cota (REVERSE LIS-P-ALZA-OES-Cota ))													; (LENGTH LIS-P-ALZA-OES-Cota)  

) ; Defun   LIS-PUN__ALZA-OES-Cota__EJE-BASE 

;--(05)-----------------------------------------------------------------------------------------------------------------------------------


;=========================================================================================================================================
;  (05p)   PINTA  =>      LIS-P-ALZA-SURo      LIS-P-ALZA-OES-Cota      LIS-P-EJE-BASE																		
;.........................................................................................................................................

(DEFUN PINTA__ALZA-SURo__ALZA-OESc__EJE-BASE  (/  )

			(SETQ NSU -1)
			(REPEAT (- (LENGTH LIS-P-ALZA-SURo) 1)
				(SETQ NSU (+ NSU 1))

				(SETQ P1sur  (NTH (+ NSU 0) LIS-P-ALZA-SURo))
				(SETQ P2sur  (NTH (+ NSU 1) LIS-P-ALZA-SURo))

				(SETQ P1oes  (NTH (+ NSU 0) LIS-P-ALZA-OES-Cota))
				(SETQ P2oes  (NTH (+ NSU 1) LIS-P-ALZA-OES-Cota))

				(SETQ P1base (NTH (+ NSU 0) LIS-P-EJE-BASE))
				(SETQ P2base (NTH (+ NSU 1) LIS-P-EJE-BASE))

				(COMMAND "COLOR"   3 "LINEA"  P1sur   P2sur  "")			; LINEAS VERTICALES  (>= NSU 0) 
				(COMMAND "COLOR"   4 "LINEA"  P1oes   P2oes  "")
				(COMMAND "COLOR" 255 "LINEA"  P1base  P2base "")

				(IF (= NSU 0)
					(PROGN
						;(COMMAND "COLOR"   8 "LINEA" P1base P1sur "") ; LINEA = (000)(000)		; LINEAS HORIZONTALES (= NSU 0) 
						;(COMMAND "COLOR"   8 "LINEA" P1base P1oes "") ; LINEA = (000)(000) 
						(COMMAND "COLOR"   3 "PUNTO" P1sur  ) (COMMAND "COLOR"   3 "TEXTO" P1sur   H-TXT 0 (STRCAT "_P-" (ITOA (+ NSU 1))))
						(COMMAND "COLOR"   4 "PUNTO" P1oes  ) (COMMAND "COLOR"   4 "TEXTO" P1oes   H-TXT 0 (STRCAT "_P-" (ITOA (+ NSU 1))))
						(COMMAND "COLOR" 255 "PUNTO" P1base ) (COMMAND "COLOR" 255 "TEXTO" P1base  H-TXT 0 (STRCAT "_P-" (ITOA (+ NSU 1))))
					) ; pro
				) ; if

				(COMMAND "COLOR"   8 "LINEA" P2base P2sur "")				; LINEAS HORIZONTALES (>= NSU 0) 
				(COMMAND "COLOR"   8 "LINEA" P2base P2oes "")
				(COMMAND "COLOR"   3 "PUNTO" P2sur  ) (COMMAND "COLOR"   3 "TEXTO" P2sur   H-TXT 0 (STRCAT "_P-" (ITOA (+ NSU 2))))
				(COMMAND "COLOR"   4 "PUNTO" P2oes  ) (COMMAND "COLOR"   4 "TEXTO" P2oes   H-TXT 0 (STRCAT "_P-" (ITOA (+ NSU 2))))
				(COMMAND "COLOR" 255 "PUNTO" P2base ) (COMMAND "COLOR" 255 "TEXTO" P2base  H-TXT 0 (STRCAT "_P-" (ITOA (+ NSU 2))))
			) ; repe

) ; Defun   PINTA__ALZA-SURo__ALZA-OESc__EJE-BASE 

;--(05p)----------------------------------------------------------------------------------------------------------------------------------


;=========================================================================================================================================
;  (06) AADE 3+3 PUNTOS LIS-P-EJE-BASE  =>  LIS-P-EJE-BASE-FI (PUNTOS IMPARES) => LISTA DEFINITIVA    LIS-P-EJE-BASE-FIN						
;.........................................................................................................................................

(DEFUN AADE3+3-EJE-BASE-IMPARES__LIS-P-EJE-BASE-FIN  (/  )

	;  PUNTOS TANGENCIAS (P-APOYO)    N-AlzSUR1  N-AlzSUR2       N-AlzOES1  N-AlzOES2																		
	(SETQ LIS-pAPOYO-S2 (MEMBER (ASSOC 10 (ENTGET N-AlzSUR2)) (ENTGET N-AlzSUR2)))
	(SETQ LIS-pAPOYO-O2 (MEMBER (ASSOC 10 (ENTGET N-AlzOES2)) (ENTGET N-AlzOES2)))
	 ;  P-TANGENTE FINAL   ALZ-SUR2                   SCP UNIVERSAL                                                         					
	(SETQ TFs1 (CDR (NTH (- (LENGTH LIS-pAPOYO-S2) 2) LIS-pAPOYO-S2)))
	(SETQ TFs0 (CDR (NTH (- (LENGTH LIS-pAPOYO-S2) 1) LIS-pAPOYO-S2)))
	 ;  P-TANGENTE FINAL   ALZ-OESTE2                 SCP UNIVERSAL                                                         					
	(SETQ TFo1 (CDR (NTH (- (LENGTH LIS-pAPOYO-O2) 2) LIS-pAPOYO-O2)))
	(SETQ TFo0 (CDR (NTH (- (LENGTH LIS-pAPOYO-O2) 1) LIS-pAPOYO-O2)))

	;  AADIR 3 PUNTOS a  LIS-P-EJE-BASE  en INICIO y FINAL   SIMETRICOS a NORMAL a sus TANGENTES   =>   LIS-P-EJE-BASE-FI						
	;	4 PUNTOS INICIO y FINAL  de EJE-BASE																																
	(SETQ I0 (NTH 0 LIS-P-EJE-BASE))               
	(SETQ I1 (NTH 1 LIS-P-EJE-BASE))               
	(SETQ I2 (NTH 2 LIS-P-EJE-BASE))             
	(SETQ I3 (NTH 3 LIS-P-EJE-BASE))             
	(SETQ F3 (NTH (- (LENGTH LIS-P-EJE-BASE) 4) LIS-P-EJE-BASE))
	(SETQ F2 (NTH (- (LENGTH LIS-P-EJE-BASE) 3) LIS-P-EJE-BASE))
	(SETQ F1 (NTH (- (LENGTH LIS-P-EJE-BASE) 2) LIS-P-EJE-BASE))
	(SETQ F0 (NTH (- (LENGTH LIS-P-EJE-BASE) 1) LIS-P-EJE-BASE))
	;	2 PUNTOS TANGENTE INICIO  EJE-BASE    Tg = EJE-Z																												
	(SETQ TI0  (LIST 0.0 0.0   0.0 ))
	(SETQ TI1  (LIST 0.0 0.0 100.0 ))
	;	2 PUNTOS TANGENTE FINAL  EJE-BASE																																	
	(SETQ VF0   (CAL " VEC ( TFo0 , F0 )"))
	(SETQ TFo0B  F0 )
	(SETQ TFo1B (CAL " TFo1 + VF0 "))
	(SETQ TF0    F0 )
	(SETQ TF1   (CAL "ILP ( TFo0B , TFo1B , TFs0 , TFs1 , [0.0,0.0,0.0])"))
	;	3 PUNTOS FINAL SIMETRICOS  a  NORMAL TANGENTE ( TI0 TI1 )																									
	(COMMAND "SCP" "3P" TI0 TI1 "" )
		(SETQ I1p (TRANS I1 0 1 ))       (SETQ I1pS (LIST (- (CAR I1p)) (- (CADR I1p)) (CADDR I1p)))      (SETQ I1S (TRANS I1pS 1 0 ))
		(SETQ I2p (TRANS I2 0 1 ))       (SETQ I2pS (LIST (- (CAR I2p)) (- (CADR I2p)) (CADDR I2p)))      (SETQ I2S (TRANS I2pS 1 0 ))
		(SETQ I3p (TRANS I3 0 1 ))       (SETQ I3pS (LIST (- (CAR I3p)) (- (CADR I3p)) (CADDR I3p)))      (SETQ I3S (TRANS I3pS 1 0 ))
	(COMMAND "SCP" "U" )  ;(COMMAND "COLOR" 1 "PUNTO" I1S )  (COMMAND "COLOR" 2 "PUNTO" I2S )  (COMMAND "COLOR" 3 "PUNTO" I3S )
	;	3 PUNTOS FINAL SIMETRICOS  a  NORMAL TANGENTE ( TF0 TF1 )																									
	(COMMAND "SCP" "3P" TF0 TF1 "" )
		(SETQ F1p (TRANS F1 0 1 ))       (SETQ F1pS (LIST (- (CAR F1p)) (- (CADR F1p)) (CADDR F1p)))      (SETQ F1S (TRANS F1pS 1 0 ))
		(SETQ F2p (TRANS F2 0 1 ))       (SETQ F2pS (LIST (- (CAR F2p)) (- (CADR F2p)) (CADDR F2p)))      (SETQ F2S (TRANS F2pS 1 0 ))
		(SETQ F3p (TRANS F3 0 1 ))       (SETQ F3pS (LIST (- (CAR F3p)) (- (CADR F3p)) (CADDR F3p)))      (SETQ F3S (TRANS F3pS 1 0 ))
	(COMMAND "SCP" "U" )  ;(COMMAND "COLOR" 1 "PUNTO" F1S )  (COMMAND "COLOR" 2 "PUNTO" F2S )  (COMMAND "COLOR" 3 "PUNTO" F3S )

	;	3 PUNTOS AADE al INICIO y FINAL  de  LIS-P-EJE-BASE 																											
	(SETQ LIS-P-EJE-BASE-F   (REVERSE   LIS-P-EJE-BASE    ))											; (LENGTH LIS-P-EJE-BASE   ) 
	(SETQ LIS-P-EJE-BASE-F   (CONS F1S  LIS-P-EJE-BASE-F  ))
	(SETQ LIS-P-EJE-BASE-F   (CONS F2S  LIS-P-EJE-BASE-F  ))
	(SETQ LIS-P-EJE-BASE-F   (CONS F3S  LIS-P-EJE-BASE-F  ))

	(SETQ LIS-P-EJE-BASE-F   (REVERSE   LIS-P-EJE-BASE-F  ))											; (LENGTH LIS-P-EJE-BASE-F ) 
	(SETQ LIS-P-EJE-BASE-FI  (CONS I1S  LIS-P-EJE-BASE-F  ))
	(SETQ LIS-P-EJE-BASE-FI  (CONS I2S  LIS-P-EJE-BASE-FI ))
	(SETQ LIS-P-EJE-BASE-FI  (CONS I3S  LIS-P-EJE-BASE-FI ))											; (LENGTH LIS-P-EJE-BASE-FI) 

	;  PUNTOS INPARES de LIS-P-EJE-BASE-FI   =>    LIS-P-EJE-BASE-FIN           LISTA DEFINITIVA ( EJE-BASE )										
			(SETQ LIS-P-EJE-BASE-FIN nil)
			(SETQ NFIN -1)
			(REPEAT (LENGTH LIS-P-EJE-BASE-FI)
				(SETQ NFIN (+ NFIN 1))
				(IF (= (REM NFIN 2) 0)
					(PROGN
						(SETQ P1fin (NTH NFIN  LIS-P-EJE-BASE-FI))
						(SETQ LIS-P-EJE-BASE-FIN  (CONS P1fin  LIS-P-EJE-BASE-FIN ))
					) ; pro
				) ; if
			) ; repe
			(SETQ LIS-P-EJE-BASE-FIN   (REVERSE   LIS-P-EJE-BASE-FIN  ))							; (LENGTH LIS-P-EJE-BASE-FIN ) 

) ; Defun   AADE3+3-EJE-BASE-IMPARES__LIS-P-EJE-BASE-FIN 

;--(06)-----------------------------------------------------------------------------------------------------------------------------------


;=========================================================================================================================================
;  (06p)   PINTA  =>      LIS-P-EJE-BASE-FIN      																														
;.........................................................................................................................................

(DEFUN PINTA__LIS-P-EJE-BASE-FIN  (/  )

			(SETQ NFINp -1)
			(REPEAT (- (LENGTH LIS-P-EJE-BASE-FIN) 1)
				(SETQ NFINp (+ NFINp 1))

				(SETQ Pfin1  (NTH (+ NFINp 0) LIS-P-EJE-BASE-FIN))
				(SETQ Pfin2  (NTH (+ NFINp 1) LIS-P-EJE-BASE-FIN))
				(SETQ Pfin12 (CAL " PLT ( Pfin1 , Pfin2 , 0.5 )"))

				(IF (= NFINp 0)
					(PROGN
						;(COMMAND "COLOR" 5 "PUNTO" Pfin1 ) (COMMAND "COLOR" 5 "TEXTO" "D" Pfin1  H-TXT 0 (STRCAT "P-" (ITOA NFINp) "_" ))
					) ; pro
				) ; if

				(COMMAND "COLOR" 5 "LINEA" Pfin1 Pfin2 "")
				(COMMAND "COLOR" 7 "PUNTO" Pfin12 ) ;(COMMAND "COLOR" 7 "TEXTO" "D" Pfin12  H-TXT 0 (STRCAT "P-" (ITOA NFINp) "/" (ITOA (+ NFINp 1)) "_" ))
				;(COMMAND "COLOR" 5 "PUNTO" Pfin2  ) (COMMAND "COLOR" 5 "TEXTO" "D" Pfin2   H-TXT 0 (STRCAT "P-" (ITOA (+ NFINp 1)) "_" ))
			) ; repe

) ; Defun   PINTA__LIS-P-EJE-BASE-FIN 

;--(06p)----------------------------------------------------------------------------------------------------------------------------------


;=========================================================================================================================================
;	(07) DISTANCIAS CORTE (LINEAS NORMALES a LIS-P-ALZA-SURo) + (LIS-P-PER-IZo) + (LIS-P-PER-DEo) => LIS-DIS-CORTE-IZ y LIS-DIS-CORTE-DE	
;.........................................................................................................................................

(DEFUN DISTANCIAS-CORTE__LIS-DIS-CORTE-IZ__LIS-DIS-CORTE-DE  (/  )

	;  PUNTOS INPARES de LIS-P-ALZA-SURo   =>    LIS-P-ALZA-SURoIMP           																					
	(SETQ LIS-P-ALZA-SURoIMP nil)

	(SETQ NCUEN 0)
	(SETQ NIM -1)
	(REPEAT (LENGTH LIS-P-ALZA-SURo)															; (LENGTH LIS-P-ALZA-SURo) 61 
		(SETQ NIM (+ NIM 1))
		(IF (= (REM NIM 2) 0)
			(PROGN
				(SETQ pIMP (NTH NIM  LIS-P-ALZA-SURo))

				(COMMAND "COLOR" 5 "PUNTO" pIMP  ) (SETQ NCUEN (+ NCUEN 1)) (COMMAND "COLOR" 5 "TEXTO" pIMP H-TXT 0 (STRCAT "_P-" (ITOA NCUEN) ))

				(SETQ LIS-P-ALZA-SURoIMP (CONS pIMP  LIS-P-ALZA-SURoIMP))
			) ; pro
		) ; if
	) ; repe
	(SETQ LIS-P-ALZA-SURoIMP  (REVERSE   LIS-P-ALZA-SURoIMP))						; (LENGTH LIS-P-ALZA-SURoIMP) 31 

	;	DISTANCIAS CORTE																																							

	(SETQ LIS-DIS-CORTE-IZ nil)																; (LENGTH LIS-DIS-CORTE-IZ ) 31 
	(SETQ LIS-DIS-CORTE-DE nil)																; (LENGTH LIS-DIS-CORTE-DE ) 31 

	(SETQ disRA 15.0 )																			; LONGITUD RADIO GRAFICA 
	(SETQ NA -1)
	(SETQ NB -1)
	(SETQ NS -1)
	(REPEAT (- (LENGTH LIS-P-ALZA-SURoIMP) 1)												; (LENGTH LIS-P-ALZA-SURoIMP )  
		(SETQ NS (+ NS 1))

		(SETQ P1s  (NTH (+ NS 0)  LIS-P-ALZA-SURoIMP))    							;(COMMAND "COLOR" 1   "CIRCULO" P1s   0.3 )
		(SETQ P2s  (NTH (+ NS 1)  LIS-P-ALZA-SURoIMP))    							;(COMMAND "COLOR" 5   "CIRCULO" P2s   0.4 )

		;(SETQ COr0  (CAL " PLT ( P1s , P2s , 0.5 )"))   						;(COMMAND "COLOR" 255 "CIRCULO" COr0  0.3 )

	  	(SETQ COr0  P1s )
		(SETQ V123s (CAL " [ 0.0 , 1.0 , 0.0 ]"))
		(SETQ VCOr  (CAL " NOR ( P1s , P2s , P2s + V123s )"))

		(SETQ COr1 (CAL " COr0 + ( VCOr * disRA )"))  									;(COMMAND "COLOR" 1 "LINEA" COr0  COr1 "")
		(SETQ COr2 (CAL " COr0 - ( VCOr * disRA )"))  									;(COMMAND "COLOR" 2 "LINEA" COr0  COr2 "")

		; PUNTOS CORTE IZQUIERDA																																				
		(SETQ KcorA nil )
		(SETQ WWa T )
		(WHILE WWa
			(SETQ NA (+ NA 1))
			(IF (> (+ NA 1) (- (LENGTH LIS-P-PER-IZo) 1))																		; LIS-P-PER-IZo 
				(PROGN  (SETQ WWa nil) )
				(PROGN
					(SETQ PA1p   (NTH (+ NA 0) LIS-P-PER-IZo))																	; PLANO XYu 
					(SETQ PA2p   (NTH (+ NA 1) LIS-P-PER-IZo))
					(SETQ PinAp (CAL "ILL ( PA1p , PA2p , COr0 , COr1 )"))													; INTERSEC 
					
					(COND
						((EQUAL PinAp PA1p mUNI)		(COMMAND "COLOR" 255 "LINEA" COr0 PinAp "" )
																(SETQ KcorA T ) (SETQ WWa nil) (SETQ NA (- NA 1))
																(SETQ DIS-IZ (DISTANCE COr0 PinAp ))
																(SETQ LIS-DIS-CORTE-IZ (CONS DIS-IZ  LIS-DIS-CORTE-IZ)))

						((EQUAL PinAp PA2p mUNI)		(COMMAND "COLOR" 255 "LINEA" COr0 PinAp "" )
																(SETQ KcorA T ) (SETQ WWa nil) (SETQ NA (- NA 1))
																(SETQ DIS-IZ (DISTANCE COr0 PinAp ))
																(SETQ LIS-DIS-CORTE-IZ (CONS DIS-IZ  LIS-DIS-CORTE-IZ)))

						(  T									(SETQ D0a (CAL "DIST ( PA1p  , PA2p  )"))
																(SETQ D1a (CAL "DIST ( PA1p  , PinAp )"))
																(SETQ D2a (CAL "DIST ( PinAp , PA2p  )"))
																(IF (EQUAL D0a (+ D1a D2a) mUNI) (PROGN
																	(COMMAND "COLOR" 1 "LINEA" COr0 PinAp "" )				; VERTICE-A 2D 
																	(SETQ KcorA T ) (SETQ WWa nil) (SETQ NA (- NA 1))
																	(SETQ DIS-IZ (DISTANCE COr0 PinAp ))
																	(SETQ LIS-DIS-CORTE-IZ (CONS DIS-IZ  LIS-DIS-CORTE-IZ))	; +DIS-IZ 
																))) ; /pro /if /con T 
					) ; con
				) ; pro
			) ; if
		) ; WWa

		(IF (= KcorA nil ) (PROGN (TERPRI) (PROMPT " >>>>  NO PUNTO-CORTE-IZ   en NS = ") (PRIN1 NS ) (TERPRI)))

		; PUNTOS CORTE DERECHA																																					
		(SETQ KcorB nil )
		(SETQ WWb T )
		(WHILE WWb
			(SETQ NB (+ NB 1))
			(IF (> (+ NB 1) (- (LENGTH LIS-P-PER-DEo) 1))																		; LIS-P-PER-DEo 
				(PROGN  (SETQ WWb nil) )
				(PROGN
					(SETQ PB1p   (NTH (+ NB 0) LIS-P-PER-DEo))																	; PLANO XYu 
					(SETQ PB2p   (NTH (+ NB 1) LIS-P-PER-DEo))
					(SETQ PinBp (CAL "ILL ( PB1p , PB2p , COr0 , COr2 )"))													; INTERSEC 
					
					(COND
						((EQUAL PinBp PB1p mUNI)		(COMMAND "COLOR" 255 "LINEA" COr0 PinBp "" )
																(SETQ KcorB T ) (SETQ WWb nil) (SETQ NB (- NB 1))
																(SETQ DIS-DE (DISTANCE COr0 PinBp ))
																(SETQ LIS-DIS-CORTE-DE (CONS (- DIS-DE)  LIS-DIS-CORTE-DE)))

						((EQUAL PinBp PB2p mUNI)		(COMMAND "COLOR" 255 "LINEA" COr0 PinBp "" )
																(SETQ KcorB T ) (SETQ WWb nil) (SETQ NB (- NB 1))
																(SETQ DIS-DE (DISTANCE COr0 PinBp ))
																(SETQ LIS-DIS-CORTE-DE (CONS (- DIS-DE)  LIS-DIS-CORTE-DE)))

						(  T									(SETQ D0b (CAL "DIST ( PB1p  , PB2p  )"))
																(SETQ D1b (CAL "DIST ( PB1p  , PinBp )"))
																(SETQ D2b (CAL "DIST ( PinBp , PB2p  )"))
																(IF (EQUAL D0b (+ D1b D2b) mUNI) (PROGN
																	(COMMAND "COLOR" 2 "LINEA" COr0 PinBp "" )				; VERTICE-B 2D 
																	(SETQ KcorB T ) (SETQ WWb nil) (SETQ NB (- NB 1))
																	(SETQ DIS-DE (DISTANCE COr0 PinBp ))
																	(SETQ LIS-DIS-CORTE-DE (CONS (- DIS-DE)  LIS-DIS-CORTE-DE))	; (- DIS-DE) ?
																))) ; /pro /if /con T 
					) ; con
				) ; pro
			) ; if
		) ; WWa

		(IF (= KcorB nil ) (PROGN (TERPRI) (PROMPT " >>>>  NO PUNTO-CORTE-DE   en NS = ") (PRIN1 NS ) (TERPRI)))

	) ; repe NS 


	(IF (= NS (- (LENGTH LIS-P-ALZA-SURoIMP) 2))
		(PROGN
			(SETQ LIS-DIS-CORTE-IZ (CONS    DIS-IZ  LIS-DIS-CORTE-IZ))			; EL ULTIMO IGUAL QUE EL PENULTIMO por Seccion en P2s 
			(SETQ LIS-DIS-CORTE-DE (CONS (- DIS-DE) LIS-DIS-CORTE-DE))
		) ; pro
	) ; if

	(SETQ LIS-DIS-CORTE-IZ (REVERSE LIS-DIS-CORTE-IZ))						; (LENGTH LIS-DIS-CORTE-IZ )  
	(SETQ LIS-DIS-CORTE-DE (REVERSE LIS-DIS-CORTE-DE))						; (LENGTH LIS-DIS-CORTE-DE )  

	(SETQ ND-IZ (LENGTH LIS-DIS-CORTE-IZ))
	(SETQ ND-DE (LENGTH LIS-DIS-CORTE-DE))

	(IF (= ND-IZ  ND-DE )
		(PROGN (TERPRI) (PROMPT " >>>>  IGUALES  NDIS-CORTE             IZ/DE  =>      ")
			(PRIN1 ND-IZ) (PROMPT "/") (PRIN1 ND-DE) (PROMPT " ( BIEN )") (TERPRI))

		(PROGN (TERPRI) (PROMPT " >> NO IGUALES  NDIS-CORTE             IZ/DE  =>      ")
			(PRIN1 ND-IZ) (PROMPT "/") (PRIN1 ND-DE) (PROMPT " ( MAL ) ") (TERPRI))
	) ; if

  
) ; Defun   DISTANCIAS-CORTE__LIS-DIS-CORTE-IZ__LIS-DIS-CORTE-DE 

;--(07)-----------------------------------------------------------------------------------------------------------------------------------


;=========================================================================================================================================
;  (08)	CENTRO CIRCULO y ESFERAS OSCULADORAS de  4 PUNTOS  =>  ( LIS-4N-4P-3M-2C-1E )																	   
;.........................................................................................................................................

(DEFUN CENTRO-CIRCULO-ESFERAS__LIS-4N-4P-3M-2C-1E  (/  )

	(SETQ LIS-4N-4P-3M-2C-1E nil)

	(SETQ STOP-1 nil )
	(SETQ STOP-2 nil )
	(SETQ NC -1 )
	(REPEAT (- (LENGTH LIS-P-EJE-BASE-FIN) 3)
		(SETQ NC (+ NC 1))

		; PUNTO LIS-P-EJE-BASE-FIN  (de 4 en 4)                  ; VEC-12 UNI (P1 P2) 																		

		(SETQ P1a (NTH (+ NC 0) LIS-P-EJE-BASE-FIN))      (SETQ N1a (+ NC 0))  ; N PUNTO 
		(SETQ P2a (NTH (+ NC 1) LIS-P-EJE-BASE-FIN))      (SETQ N2a (+ NC 1))
		(SETQ P3a (NTH (+ NC 2) LIS-P-EJE-BASE-FIN))      (SETQ N3a (+ NC 2))
		(SETQ P4a (NTH (+ NC 3) LIS-P-EJE-BASE-FIN))      (SETQ N4a (+ NC 3))

		(SETQ V12a  (CAL "VEC1 ( P1a , P2a ) "))
		(SETQ V23a  (CAL "VEC1 ( P2a , P3a ) "))
		(SETQ V34a  (CAL "VEC1 ( P3a , P4a ) "))

		(IF (OR (EQUAL V12a V23a mUNI) (EQUAL V23a V34a mUNI) )															;    COLIMEALES ( P1 P2 P3 P4 ) 
			(PROGN (TERPRI) (PROMPT "-- (P1 P2 P3 P4) ALGUNOS COLIMEALES => (STOP-1) NC= ") (PRIN1 NC) (SETQ STOP-1 T) ))

		(IF (= STOP-1 nil)																											; NO COLIMEALES ( P1 P2 P3 P4 ) 
			(PROGN
				(SETQ M12a (CAL "PLT ( P1a , P2a , 0.5 )"))													; PUNTO MEDIO (P1 P2)								
				(SETQ M23a (CAL "PLT ( P2a , P3a , 0.5 )"))
				(SETQ M34a (CAL "PLT ( P3a , P4a , 0.5 )"))

				(SETQ Vz123a (CAL "NOR ( P1a , P2a , P3a )"))												; VEC-Z  UNI (P1 P2 P3)								
				(SETQ Vz234a (CAL "NOR ( P2a , P3a , P4a )"))

				(SETQ V1r12  (CAL "NOR ( P1a , P2a , P1a + Vz123a )"))									; VEC-RADI UNI (P1 P2)								
				(SETQ V1r23  (CAL "NOR ( P2a , P3a , P2a + Vz123a )"))
				(SETQ V2r23  (CAL "NOR ( P2a , P3a , P2a + Vz234a )"))
				(SETQ V2r34  (CAL "NOR ( P3a , P4a , P3a + Vz234a )"))

				(SETQ M12v1 (CAL " M12a + V1r12 "))																; PUN-RADI (M12a  M12v1)							
				(SETQ M23v1 (CAL " M23a + V1r23 "))
				(SETQ M23v2 (CAL " M23a + V2r23 "))
				(SETQ M34v2 (CAL " M34a + V2r34 "))

				(SETQ C123u (CAL "ILP ( M12a , M12v1 ,   M23a , M23v1 , M23a + Vz123a )"))			; CENTROS CIRCULOS OSCULADORES					
				(SETQ C234u (CAL "ILP ( M23a , M23v2 ,   M34a , M34v2 , M34a + Vz234a )"))

				; CENTROS ESFERAS OSCULADORAS																																	
				(IF (EQUAL Vz123a Vz234a mUNI)		                                  	                     ;    COPLANARIOS (P1 P2 P3 P4) 
					 (PROGN (TERPRI) (PROMPT "-- (P1 P2 P3 P4) ALGUNOS COPLANARIOS => (STOP-2) NC= ") (PRIN1 NC) (SETQ STOP-2 T) ))

				(IF (= STOP-2 nil)																									; NO COPLANARIOS (P1 P2 P3 P4) 
					(PROGN
						(SETQ C123v (CAL " C123u + Vz123a "))
						(SETQ C234v (CAL " C234u + Vz234a "))

						(SETQ E1234u (CAL "ILP ( C123u , C123v ,   C234u , C234v , M34a )"))
					) ; pro
					(PROGN
						(TERPRI) (PROMPT "---- COPLANARIOS (P1 P2 P3 P4)=> ( NO EJECUTA CENTRO ESFERA )")
					) ; pro
				) ; if
			) ; pro
			(PROGN
				(TERPRI) (PROMPT "---- COLIMEALES (P1 P2 P3 P4)=> ( NO EJECUTA CENTRO CIRCULOS )")
			) ; pro
		) ; if

		;	LISTA PUNTOS       ( LIS-4N-4P-3M-2C-1E )																														

		(SETQ LIS-4N-4P-3M-2C-1E (CONS (LIST   (LIST N1a   N2a   N3a   N4a)
															(LIST P1a   P2a   P3a   P4a)
															(LIST   M12a  M23a  M34a   )
															(LIST     C123u  C234u     )
															(LIST        E1234u        )) LIS-4N-4P-3M-2C-1E))
	) ; repe NC

	(SETQ LIS-4N-4P-3M-2C-1E (REVERSE LIS-4N-4P-3M-2C-1E ))														; (LENGTH LIS-4N-4P-3M-2C-1E) 31 


) ; Defun   CENTRO-CIRCULO-ESFERAS__LIS-4N-4P-3M-2C-1E 

;--(08)-----------------------------------------------------------------------------------------------------------------------------------


				;                                                                                                                          
				;  DIBUJO: HOMOLOGIA AFIN \ ESCULTURA-PAJARO-KIWI-10 Renedo.DWG   CAPAS: 603 - PLANOS NORMALES EXAGONALES 1 y CALCULOS 3   
				;                                                                       ;                                                  
				;                                                         /             ;                          O PA1                   
				;                                                       (O)(EP1)        ;                         /|\                      
				;                                                     o /               ;                        / | \                     
				;                                                   o  / o              ;                       /  |  \                    
				;                                                 o   /                 ;                      / DM12A \                   
				;                                               o    /  o               ;                     /    |    \                  
				;                                            o      /                   ;                PC1 O     O M12 O PD1             
				;                                          o       /   o                ;                   / \    |    / \                
				;                                        o        /                     ;    ________      /   \ DM12B /   \               
				;                                      o         /    o                 ;    PLANO-12     /     \  |  /     \              
				;                                   o           /                       ;                /       \ | /       \             
				;                                 o            /     o                  ;               /         \|/         \            
				;                               o             /                         ;              /           O PB1       \           
				;                             o              /      o                   ;             /           /|\           \          
				;                     pINI (O)              /                           ;            /           / | \           \         
				;                        o                 /       o                    ;           /           /  EP1\           \        
				;  O P1                o                  /                       P4 O  ;   -------o-----------o---O---o-----------o-------
				;   \           -----o----------         /--------o------           /   ;    ChAC12 \    ChBD12 \  |  / ChBC12    / ChAD12 
				;    \         /  o             \       / PLANO-34       \         /    ;            \           \ | /           /         
				;     \       / o                \     /         o        \       /     ;             \           \|/           /          
				;      \     /o  AgINI            \   /                    \     /      ;              \           O PB2       /           
				;       \   o                 E1234\ /          o           \   /       ;               \         /|\         /            
				;    M12 O------------------------- O -------------------------O M34    ;                \       / | \       /             
				;         \ \   ________           /|\         o ________   / /         ;    ________     \     /  |  \     /              
				;          \ \  PLANO-12          / | \          PLANO-34  / /          ;    PLANO-23      \   / DM23B \   /               
				;           \ \                  /  |  \      o           / /           ;                   \ /    |    \ /                
				;            \ \            C123/   |   C234             / /            ;                PC2 O     O M23 O PD2             
				;             \ -------------- O    |    O --o----------- /             ;                   / \    |    / \                
				;              \               |____|___ |\ o            /              ;                  /   \ DM23A /   \               
				;               \              |PLANO-23 |(O)(EP2)      /               ;                 /     \  |  /     \              
				;                \             |    |    |o \          /                ;                /       \ | /       \             
				;                 \            |    |    o   \        /                 ;               /         \|/         \            
				;                  \           |    |   o|    \      /                  ;              /           O PA2       \           
				;                   \           \   |  o/      \    /                   ;             /           /|\           \          
				;                    \           \  | o/           /                    ;            /           / | \           \         
				;                     \           \ |o/           /                     ;    ChAC23 /    ChBD23 /  |  \ ChBC23    \ ChAD23 
				;                      O------------O------------O                      ;   -------o-----------o---O---o-----------o-------
				;                    P2            M23            P3                    ;    ________              EP2                     
				;                                                                       ;    PLANO-34                                      
				;                                                                       ;                                                  


;=========================================================================================================================================
;  (09)	SECCIONES 4P con AgINI y (LIS-DIS-CORTE-M23-AB) (LIS-4N-4P-3M-2C-1E)  =>  LIS-4P-SECC               PINTA BORDES      				
;.........................................................................................................................................

(DEFUN SECCIONES-4P__LIS-4P-SECC  (/  )

	(SETQ N-4P  (LENGTH LIS-4N-4P-3M-2C-1E))
	(SETQ ND-IZ (LENGTH LIS-DIS-CORTE-IZ  ))
	(SETQ ND-DE (LENGTH LIS-DIS-CORTE-DE  ))

	(IF (=  N-4P  ND-IZ  ND-DE )

	 (PROGN (TERPRI) (PROMPT " >>>>  IGUALES  N-4P y NDIS-CORTE  4P/IZ/DE  =>  ")
		(PRIN1 N-4P) (PROMPT "/") (PRIN1 ND-IZ) (PROMPT "/") (PRIN1 ND-DE) (PROMPT " ( BIEN )") (TERPRI))

	 (PROGN (TERPRI) (PROMPT " >> NO IGUALES  N-4P y NDIS-CORTE  4P/IZ/DE  =>  ")
		(PRIN1 N-4P) (PROMPT "/") (PRIN1 ND-IZ) (PROMPT "/") (PRIN1 ND-DE) (PROMPT " ( MAL ) ") (TERPRI))
	) ; if

  	;  SECCIONES 4P con AgINI y (LIS-DIS-CORTE-M23-AB) (LIS-4N-4P-3M-2C-1E)  =>  LIS-4P-SECC                                   		

	(IF (AND (= STOP-1 nil) (= STOP-2 nil))															; NO-COLIMEALES  NO-COPLANARIOS 
		(PROGN

			;     AgINI y AgVER  en ARRANQUE PROGRAMA																														

			(SETQ LIS-4P-SECC nil )

			(SETQ NOri 0 )																					; NCRNTROL ORIENTACION VECTORES OPUESTOS 
			(SETQ NE  -1) 																					; ENPIEZA por PRINCIPIO 

			(REPEAT (LENGTH LIS-4N-4P-3M-2C-1E)
				(SETQ NE  (+ NE  1))

				;  LIS-4N-4P-3M-2C-1E  =>  (( N1 N2 N3 N4 ) ( P1 P2 P3 P4 ) ( M12 M23 M34 ) ( C123 C234 ) ( E1234 ))  						

				(SETQ N1    (NTH 0 (NTH 0 (NTH NE  LIS-4N-4P-3M-2C-1E))))			; (LENGTH LIS-4N-4P-3M-2C-1E)  
				(SETQ N2    (NTH 1 (NTH 0 (NTH NE  LIS-4N-4P-3M-2C-1E))))
				(SETQ N3    (NTH 2 (NTH 0 (NTH NE  LIS-4N-4P-3M-2C-1E))))
				(SETQ N4    (NTH 3 (NTH 0 (NTH NE  LIS-4N-4P-3M-2C-1E))))
 
				(SETQ P1    (NTH 0 (NTH 1 (NTH NE  LIS-4N-4P-3M-2C-1E))))
				(SETQ P2    (NTH 1 (NTH 1 (NTH NE  LIS-4N-4P-3M-2C-1E))))
				(SETQ P3    (NTH 2 (NTH 1 (NTH NE  LIS-4N-4P-3M-2C-1E))))
				(SETQ P4    (NTH 3 (NTH 1 (NTH NE  LIS-4N-4P-3M-2C-1E))))
 
				(SETQ M12   (NTH 0 (NTH 2 (NTH NE  LIS-4N-4P-3M-2C-1E))))
				(SETQ M23   (NTH 1 (NTH 2 (NTH NE  LIS-4N-4P-3M-2C-1E))))
				(SETQ M34   (NTH 2 (NTH 2 (NTH NE  LIS-4N-4P-3M-2C-1E))))
 
				(SETQ C123  (NTH 0 (NTH 3 (NTH NE  LIS-4N-4P-3M-2C-1E))))
				(SETQ C234  (NTH 1 (NTH 3 (NTH NE  LIS-4N-4P-3M-2C-1E))))
 
				(SETQ E1234 (NTH 0 (NTH 4 (NTH NE  LIS-4N-4P-3M-2C-1E))))

				;	DISTANCIAS DE CORTE																																	

				(SETQ DcIZ (NTH NE  LIS-DIS-CORTE-IZ))			; (LENGTH LIS-DIS-CORTE-IZ) 31  =  (LENGTH LIS-4N-4P-3M-2C-1E) 31 
				(SETQ DcDE (NTH NE  LIS-DIS-CORTE-DE))			; (LENGTH LIS-DIS-CORTE-DE) 31  

				(IF (= NE 0)
					(PROGN
						; 1-0  --------------------------------------------------------------------------------------------------
						; PUNTOS INICIO 1PLANO-23 NE=0 = 2PLANO-12 NE=1         PLANO-23 = ez(M23 P3) = M23 E1234 C123 C234	

						(COMMAND "SCP" "3P" M23 C123 E1234 )

							(SETQ pINIp (LIST (* (COS (* (/ PI 180) AgINI)) 100)
													(* (SIN (* (/ PI 180) AgINI)) 100) 0.0 ))

							(SETQ pINI  (TRANS pINIp 1 0 ))												; pINI 

						(COMMAND "SCP" "U" )


									(COMMAND "COLOR" 6 "LINEA" M23  C123  "")		; ANGULO = AgINI 
									(COMMAND "COLOR" 6 "LINEA" M23  pINI  "")


						(SETQ Vme1 (CAL "VEC1 ( M23 , pINI )"))

						(SETQ VA1  (CAL " M23 + (Vme1 * DcIZ)"))													; VERTICE-A1   VA1  3D 
						(SETQ VB1  (CAL " M23 + (Vme1 * DcDE)"))													; VERTICE-B1   VB1  3D 

						;(SETQ EP1  (CAL "ILP  ( C123 , E1234 ,  M23 , pINI , P3 )"))						; ARISTA-1    EP1

						(SETQ EP2  (CAL "ILP  ( E1234 , C234 ,  M23 , pINI , P3 )"))						; ARISTA-2    EP2

						; 2-0  --------------------------------------------------------------------------------------------------
						; SECCION INICIO 1PLANO-23 NE=0 = 2PLANO-12 NE=1        INTERSECCION  PLANO-23 PLANO-34 = E1234 C234 

						(COMMAND "SCP" "3P" M23 C123 E1234 )

							(SETQ VA1pp (TRANS VA1 0 1 ))         (SETQ VA1p (CAL "XYof( VA1pp )"))
							(SETQ VB1pp (TRANS VB1 0 1 ))         (SETQ VB1p (CAL "XYof( VB1pp )"))

							; VERTICES INICIO  1CUADRILATERO          ANGULOS	(AgVER)															

							(SETQ pACg  (CAL "ROT ( VB1p , VA1p , (- AgVER) )"))				; ROT(P1,Po,Ag)
							(SETQ pADg  (CAL "ROT ( VB1p , VA1p ,    AgVER  )"))

							(SETQ pBCg  (CAL "ROT ( VA1p , VB1p ,    AgVER  )"))
							(SETQ pBDg  (CAL "ROT ( VA1p , VB1p , (- AgVER) )"))

							(SETQ VC1pp (CAL "ILL ( VA1p , PACg ,  VB1p , PBCg )"))    (SETQ VC1p (CAL "XYof( VC1pp )"))
							(SETQ VD1pp (CAL "ILL ( VA1p , PADg ,  VB1p , PBDg )"))    (SETQ VD1p (CAL "XYof( VD1pp )"))

							(SETQ VC1 (TRANS VC1p 1 0 ))																	; VERTICE-C1   VC1  3D 
							(SETQ VD1 (TRANS VD1p 1 0 ))																	; VERTICE-D1   VD1  3D 

						; 3-0  --------------------------------------------------------------------------------------------------
						; P-CHARNELA INICIO 1PLANO-23 NE=0 = 2PLANO-12 NE=1    INTERSECCION  PLANO-23 PLANO-34 =  E1234 C234 

							(SETQ CH1App  (TRANS E1234 0 1 ))                          (SETQ CH1Ap  (CAL "XYof( CH1App )"))
							(SETQ CH1Bpp  (TRANS C234  0 1 ))                          (SETQ CH1Bp  (CAL "XYof( CH1Bpp )"))

							(SETQ CHac1pp (CAL "ILL ( VA1p , VC1p , CH1Ap , CH1Bp )")) (SETQ CHac1p (CAL "XYof( CHac1pp )"))
							(SETQ CHad1pp (CAL "ILL ( VA1p , VD1p , CH1Ap , CH1Bp )")) (SETQ CHad1p (CAL "XYof( CHad1pp )"))
							(SETQ CHbc1pp (CAL "ILL ( VB1p , VC1p , CH1Ap , CH1Bp )")) (SETQ CHbc1p (CAL "XYof( CHbc1pp )"))
							(SETQ CHbd1pp (CAL "ILL ( VB1p , VD1p , CH1Ap , CH1Bp )")) (SETQ CHbd1p (CAL "XYof( CHbd1pp )"))

							(SETQ CHac1 (TRANS CHac1p 1 0 ))															; CHARNELA  CHac1  3D 
							(SETQ CHad1 (TRANS CHad1p 1 0 ))															; CHARNELA  CHad1  3D 
							(SETQ CHbc1 (TRANS CHbc1p 1 0 ))															; CHARNELA  CHbc1  3D 
							(SETQ CHbd1 (TRANS CHbd1p 1 0 ))															; CHARNELA  CHbd1  3D 
						(COMMAND "SCP" "U" )


						; 4-0  TRATA RESULTADOS INICIO																									

						(COMMAND "COLOR"   1 "LINEA" M23  VA1 "")
						(COMMAND "COLOR"   2 "LINEA" M23  VB1 "")
						(COMMAND "COLOR"   7 "LINEA" VA1  VC1 "")
						(COMMAND "COLOR" 255 "LINEA" VA1  VD1 "")
						(COMMAND "COLOR" 255 "LINEA" VB1  VC1 "")
						(COMMAND "COLOR"   7 "LINEA" VB1  VD1 "")

						(COMMAND "COLOR"   6 "PUNTO" VA1 ) ; 1  COMPROBACION 
						(COMMAND "COLOR"   6 "PUNTO" VB1 ) ; 2 
						(COMMAND "COLOR"   6 "PUNTO" VC1 ) ; 3 
						(COMMAND "COLOR"   6 "PUNTO" VD1 ) ; 4 

						;(COMMAND "COLOR" 7 "3DCARA"   VA1  VC1  VB1  VD1 "")
						(SETQ LIS-4P-SECC (CONS (LIST VA1  VC1  VB1  VD1 ) LIS-4P-SECC ))

					) ; pro 

					;-----------------------------------------------------------------------------------------------------------

					(PROGN
						; 1-N  --------------------------------------------------------------------------------------------------
						; PUNTOS RESTANTES 2PLANO-23 NE=n = 1PLANO-34 NE=0       PLANO-23 = ez(M23 P3) = M23 E1234 C123 C234	

						(SETQ EP1 EP2 )

						(SETQ Vme2 (CAL " VEC1 ( M23 , EP1 )"))							; VECTOR ORIENTACION

						(IF (< (CAL " ABS( Vme1 + Vme2 ) ") (SQRT 2)) (SETQ NOri (+ NOri 1)))
						(IF (= (REM NOri 2) 1)  (SETQ VEori (CAL " Vme2 * -1 ")) (SETQ VEori  Vme2 ))
						(SETQ Vme1  Vme2 )

						(SETQ VA2   (CAL " M23 + (VEori * DcIZ)"))													; VERTICE-A2   VA2  3D 
						(SETQ VB2   (CAL " M23 + (VEori * DcDE)"))													; VERTICE-B2   VB2  3D 

						(SETQ EP2  (CAL "ILP ( E1234 , C234 ,  M23 , EP1 , P3 )"))								; ARISTA-2    EP2     

						; 2-N  --------------------------------------------------------------------------------------------------
						; SECCION RESTANTES 2PLANO-23      NE = 1..N          INTERSECCION  PLANO-23 PLANO-34 = E1234 C234 		

						(COMMAND "SCP" "3P" M23 C123 E1234 )

							(SETQ CHac1pp (TRANS CHac1 0 1 ))    (SETQ CHac1p (CAL "XYof( CHac1pp )"))
							(SETQ CHad1pp (TRANS CHad1 0 1 ))    (SETQ CHad1p (CAL "XYof( CHad1pp )"))
							(SETQ CHbc1pp (TRANS CHbc1 0 1 ))    (SETQ CHbc1p (CAL "XYof( CHbc1pp )"))
							(SETQ CHbd1pp (TRANS CHbd1 0 1 ))    (SETQ CHbd1p (CAL "XYof( CHbd1pp )"))

							(SETQ VA2pp  (TRANS VA2 0 1 ))       (SETQ VA2p   (CAL "XYof( VA2pp )"))
							(SETQ VB2pp  (TRANS VB2 0 1 ))       (SETQ VB2p   (CAL "XYof( VB2pp )"))

							(SETQ VC2pp (CAL "ILL ( VA2p , CHac1p , VB2p , CHbc1p )"))  (SETQ VC2p (CAL "XYof( VC2pp )"))
							(SETQ VD2pp (CAL "ILL ( VA2p , CHad1p , VB2p , CHbd1p )"))  (SETQ VD2p (CAL "XYof( VD2pp )"))

							(SETQ VC2 (TRANS VC2p 1 0 ))																	; VERTICE-C2   VC2  3D 
							(SETQ VD2 (TRANS VD2p 1 0 ))																	; VERTICE-D2   VD2  3D 

						; 3-N  --------------------------------------------------------------------------------------------------
						; P-CHARNELA RESTANTES 2PLANO-23   NE = 1..N          INTERSECCION  PLANO-23 PLANO-34  =  E1234 C234 	

							(SETQ CH2App  (TRANS E1234 0 1 ))                             (SETQ CH2Ap  (CAL "XYof( CH2App )"))
							(SETQ CH2Bpp  (TRANS C234  0 1 ))                             (SETQ CH2Bp  (CAL "XYof( CH2Bpp )"))

							(SETQ CHac2pp (CAL "ILL ( VA2p , VC2p , CH2Ap , CH2Bp )"))    (SETQ CHac2p (CAL "XYof( CHac2pp )"))
							(SETQ CHad2pp (CAL "ILL ( VA2p , VD2p , CH2Ap , CH2Bp )"))    (SETQ CHad2p (CAL "XYof( CHad2pp )"))
	 						(SETQ CHbc2pp (CAL "ILL ( VB2p , VC2p , CH2Ap , CH2Bp )"))    (SETQ CHbc2p (CAL "XYof( CHbc2pp )"))
							(SETQ CHbd2pp (CAL "ILL ( VB2p , VD2p , CH2Ap , CH2Bp )"))    (SETQ CHbd2p (CAL "XYof( CHbd2pp )"))

							(SETQ CHac2 (TRANS CHac2p 1 0 ))															; CHARNELA  CHac2  3D 
							(SETQ CHad2 (TRANS CHad2p 1 0 ))															; CHARNELA  CHad2  3D 
							(SETQ CHbc2 (TRANS CHbc2p 1 0 ))															; CHARNELA  CHbc2  3D 
							(SETQ CHbd2 (TRANS CHbd2p 1 0 ))															; CHARNELA  CHbd2  3D 
						(COMMAND "SCP" "U" )


						; 4-N  TRATA RESULTADOS RESTANTES																								


				(IF (= NE (- (LENGTH LIS-4N-4P-3M-2C-1E) 1))	;	COMPROBACION PUNTOS DE MAS EN FINAL ??? 
					(PROGN

						(COMMAND "COLOR"   7 "LINEA" M23  VA2 "")
						(COMMAND "COLOR"   7 "LINEA" M23  VB2 "")
						(COMMAND "COLOR"   7 "LINEA" VA2  VC2 "")
						(COMMAND "COLOR"   7 "LINEA" VA2  VD2 "")
						(COMMAND "COLOR"   7 "LINEA" VB2  VC2 "")
						(COMMAND "COLOR"   7 "LINEA" VB2  VD2 "")

						(COMMAND "COLOR"   7 "PUNTO" VA2 )	; 1 
						(COMMAND "COLOR"   7 "PUNTO" VB2 )	; 2 
						(COMMAND "COLOR"   7 "PUNTO" VC2 )	; 3 
						(COMMAND "COLOR"   7 "PUNTO" VD2 )	; 4 

					) ; pro

					(PROGN

						(COMMAND "COLOR"   1 "LINEA" M23  VA2 "")
						(COMMAND "COLOR"   2 "LINEA" M23  VB2 "")
						(COMMAND "COLOR"   7 "LINEA" VA2  VC2 "")
						(COMMAND "COLOR" 255 "LINEA" VA2  VD2 "")
						(COMMAND "COLOR" 255 "LINEA" VB2  VC2 "")
						(COMMAND "COLOR"   7 "LINEA" VB2  VD2 "")

						(COMMAND "COLOR"   1 "PUNTO" VA2 )	; 1 
						(COMMAND "COLOR"   2 "PUNTO" VB2 )	; 2 
						(COMMAND "COLOR"   3 "PUNTO" VC2 )	; 3 
						(COMMAND "COLOR"   4 "PUNTO" VD2 )	; 4 

					) ; pro
				) ; if



						;(COMMAND "COLOR" 7 "3DCARA"   VA2  VC2  VB2  VD2 "")
						(SETQ LIS-4P-SECC (CONS (LIST VA2  VC2  VB2  VD2 ) LIS-4P-SECC ))

						(SETQ  CHac1  CHac2 )
						(SETQ  CHad1  CHad2 )
						(SETQ  CHbc1  CHbc2 )
						(SETQ  CHbd1  CHbd2 )

					) ; pro 

				) ; if NE=0 
			) ; repe NE 


			(SETQ LIS-4P-SECC (REVERSE LIS-4P-SECC ))																; (LENGTH LIS-4P-SECC)


			;	PINTA BORDES EJES EVOLUTA	2D  3D																															

			(SETQ NEE -1)
			(REPEAT (- (LENGTH LIS-4P-SECC) 1)  ; (LIST VA2  VC2  VB2  VD2 )
				(SETQ NEE (+ NEE 1))

				(SETQ PAA1 (NTH 0 (NTH (+ NEE 0)  LIS-4P-SECC)))
				(SETQ PCC1 (NTH 1 (NTH (+ NEE 0)  LIS-4P-SECC)))
				(SETQ PBB1 (NTH 2 (NTH (+ NEE 0)  LIS-4P-SECC)))
				(SETQ PDD1 (NTH 3 (NTH (+ NEE 0)  LIS-4P-SECC)))

				(SETQ PAA2 (NTH 0 (NTH (+ NEE 1)  LIS-4P-SECC)))
				(SETQ PCC2 (NTH 1 (NTH (+ NEE 1)  LIS-4P-SECC)))
				(SETQ PBB2 (NTH 2 (NTH (+ NEE 1)  LIS-4P-SECC)))
				(SETQ PDD2 (NTH 3 (NTH (+ NEE 1)  LIS-4P-SECC)))

				(COMMAND "COLOR" 7 "LINEA" PAA1  PAA2 "")
				(COMMAND "COLOR" 7 "LINEA" PCC1  PCC2 "")
				(COMMAND "COLOR" 7 "LINEA" PBB1  PBB2 "")
				(COMMAND "COLOR" 7 "LINEA" PDD1  PDD2 "")

			) ; repe

		) ; pro

		(PROGN
				(TERPRI) (PROMPT "---- COLIMEALES o COPLANARIOS => ( NO EJECUTA PINTA-EVOLUTA )")
		) ; pro
	) ; if

) ; Defun   SECCIONES-4P__LIS-4P-SECC 

;--(09)-----------------------------------------------------------------------------------------------------------------------------------


;=========================================================================================================================================
;  (10)   PINTA-3DCARAS  3D     2D PATRONES																																
;.........................................................................................................................................

(DEFUN PINTA-3DCARAS__3D_2D  (/  )

		(SETQ KKx  130 )																					; PUNTO OREGEN 1PATRONES 
		(SETQ KKy    0 )

		(SETQ SEPA 235 )																					; SEPARACION ENTRE PATRONES    1DIS = KKx + SEPA 

		(SETQ DESf (+ KKx (* 6 SEPA)))																; DESPLAZAMIENTO FIGURA 3DC 

		; PINTA 4 SUPERFICIES EXTERNAS																																		

		(SETQ NP1 -1)
		(REPEAT 4																							; 4 CARAS    (LENGTH (NTH 0 LIS-4P-SECC)) 
			(SETQ NP1 (+ NP1 1))
			(SETQ NP2 (+ NP1 1)) (IF (= NP2 4) (SETQ NP2 0)  )

			(SETQ KKx (+ KKx SEPA ))																	; SEPARACION ENTRE PATRONES 

			(SETQ KK1 (LIST    KKx     KKy  0 ))
			(SETQ KK2 (LIST (+ KKx 1)  KKy  0 ))

			(SETQ NCA -1)
			(REPEAT (- (LENGTH LIS-4P-SECC) 1)
				(SETQ NCA (+ NCA 1))

				(SETQ AA1 (NTH NP1 (NTH (+ NCA 0)  LIS-4P-SECC )))							; (LIST  AA1  BB1  CC1  DD1 ) 
				(SETQ BB1 (NTH NP2 (NTH (+ NCA 0)  LIS-4P-SECC )))
				(SETQ AA2 (NTH NP1 (NTH (+ NCA 1)  LIS-4P-SECC )))
				(SETQ BB2 (NTH NP2 (NTH (+ NCA 1)  LIS-4P-SECC )))

				(SETQ AA1des (CAL " AA1 + [ DESf ,0,0] "))
				(SETQ BB1des (CAL " BB1 + [ DESf ,0,0] "))
				(SETQ AA2des (CAL " AA2 + [ DESf ,0,0] "))
				(SETQ BB2des (CAL " BB2 + [ DESf ,0,0] "))

				(COMMAND "COLOR" 2 "3DCARA" AA1des  AA2des  BB2des  BB1des "")				; PINTA FIGURA DESPLAZADA 3DC 3D 

				(COMMAND "SCP" "3P" AA1 BB1 AA2 )
					(SETQ AA1pz (TRANS AA1 0 1))    (SETQ AA1p (CAL "XYof( AA1pz )"))
					(SETQ BB1pz (TRANS BB1 0 1))    (SETQ BB1p (CAL "XYof( BB1pz )"))
					(SETQ AA2pz (TRANS AA2 0 1))    (SETQ AA2p (CAL "XYof( AA2pz )"))
					(SETQ BB2pz (TRANS BB2 0 1))    (SETQ BB2p (CAL "XYof( BB2pz )"))

					;(COMMAND "COLOR" 2  "TEXTO" AA1p 0.4 0 (STRCAT " " (ITOA N6)))										; TEXTO 3DCARA  3D 

				(COMMAND "SCP" "U" )

				(COMMAND "SCP" "3P" KK1 KK2 "" )

					(COMMAND "COLOR" 5 "3DCARA" AA1p AA2p BB2p BB1p "")														; PINTA 3DCARA  2D 

					;(COMMAND "COLOR" 5  "TEXTO" AA1p 0.4 0 (STRCAT " " (ITOA N6)))										; TEXTO 3DCARA  2D 

					(SETQ AA2pU (TRANS AA2p 1 0))
					(SETQ BB2pU (TRANS BB2p 1 0))

				(COMMAND "SCP" "U" )

				(SETQ KK1  AA2pU)
				(SETQ KK2  BB2pU)

			) ; repe NCA
		) ; repe NP1

		; PINTA 1 SUPERFICIE INTERIOR																																			

			(SETQ KKx (+ KKx SEPA ))																	; SEPARACION ENTRE PATRONES 

			(SETQ KK1 (LIST    KKx     KKy  0 ))
			(SETQ KK2 (LIST (+ KKx 1)  KKy  0 ))

			(SETQ NCA -1)
			(REPEAT (- (LENGTH LIS-4P-SECC) 1)
				(SETQ NCA (+ NCA 1))

				(SETQ AA1 (NTH 0 (NTH (+ NCA 0)  LIS-4P-SECC )))							; ( AA1  BB1  CC1  DD1 ) <=> ( VA2  VC2  VB2  VD2 )
				(SETQ BB1 (NTH 2 (NTH (+ NCA 0)  LIS-4P-SECC )))
				(SETQ AA2 (NTH 0 (NTH (+ NCA 1)  LIS-4P-SECC )))
				(SETQ BB2 (NTH 2 (NTH (+ NCA 1)  LIS-4P-SECC )))

				(COMMAND "SCP" "3P" AA1 BB1 AA2 )
					(SETQ AA1pz (TRANS AA1 0 1))    (SETQ AA1p (CAL "XYof( AA1pz )"))
					(SETQ BB1pz (TRANS BB1 0 1))    (SETQ BB1p (CAL "XYof( BB1pz )"))
					(SETQ AA2pz (TRANS AA2 0 1))    (SETQ AA2p (CAL "XYof( AA2pz )"))
					(SETQ BB2pz (TRANS BB2 0 1))    (SETQ BB2p (CAL "XYof( BB2pz )"))

					;(COMMAND "COLOR" 2  "TEXTO" AA1p 0.4 0 (STRCAT " " (ITOA N6)))										; TEXTO 3DCARA  3D 

				(COMMAND "SCP" "U" )

				(COMMAND "SCP" "3P" KK1 KK2 "" )

					(COMMAND "COLOR" 7 "3DCARA" AA1p AA2p BB2p BB1p "")														; PINTA 3DCARA  2D 

					;(COMMAND "COLOR" 5  "TEXTO" AA1p 0.4 0 (STRCAT " " (ITOA N6)))										; TEXTO 3DCARA  2D 

					(SETQ AA2pU (TRANS AA2p 1 0))
					(SETQ BB2pU (TRANS BB2p 1 0))

				(COMMAND "SCP" "U" )

				(SETQ KK1  AA2pU)
				(SETQ KK2  BB2pU)

			) ; repe NCA

) ; Defun   PINTA-3DCARAS__3D_2D 

;--(10)-----------------------------------------------------------------------------------------------------------------------------------



"########################################################################################################################################"
;-----------------------------------------------------------------------------------------------------------------------------------------
; *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA ***	
;-----------------------------------------------------------------------------------------------------------------------------------------
"########################################################################################################################################"

(DEFUN C:DESARROLLO-KIWI-52 ( / )

	;======================================================================================================================================
	;  (00) ARRANCANDO																																							
	;......................................................................................................................................

 	(SETVAR "blipmode" 0) (SETVAR "cmdecho" 0)  (GRAPHSCR)  (COMMAND "-REFENT" "DES")  (COMMAND "SCP" "U")  (COMMAND "ORTO" "DES")

	(TERPRI) (PROMPT " ========================================================== ")
	(TERPRI) (PROMPT " >>>>>>>> INICIO >>>>>>>>>>> DESARROLLO-KIWI-52 >>>>>>>>>>> ")
	(TERPRI) (PROMPT " ========================================================== ") (TERPRI)

	(IF (= CAL nil)(COMMAND "ARX" "L" "GEOMCAL.ARX"))		; CARGA CALCULADORA 

	;	(00)																																											
	;======================================================================================================================================

 	;======================================================================================================================================
	;	(01) FIJAR VARIABLES EN EL PROGRAMA																																	
	;......................................................................................................................................

	(SETQ NDIVIDE  150   )				; 30 NDIVIDE SPLINES 

	(SETQ NGRADUA   0.3  )				; 0.5 DISTANCIA GRADUA SPLINES  (PRECISION de MEDICION) *** NO mas de  32768 ? Divisiones ***

	(SETQ AgINI   221.974 )     		; AgINI al EJE(M23 C123) /= 90y270      ANGULO INICIO PUNTO (pINI) 
	(SETQ AgVER    45.0   )     		; ANGULO INICIO VERTICES 1SECCION  

	(SETQ H-TXT      0.5  )				; ALTURA TEXTO (SI)
	(SETQ mUNI 1.02e-006  )				; MARGEN EQUAL para VECTORES UNITARIOS  ( 1.01e-008 ) de LIMITE-MAR-INTER-RECT-01 lsp 

	;	(01)																																											
	;======================================================================================================================================

 	;======================================================================================================================================
	;  (02) TOMA de DATOS en PANTALLA																																		
	;......................................................................................................................................

 	(TERPRI)  (SETQ N-PER-IZ  (CAR (ENTSEL "----  MARCA SPLINE 2D  Plano-XZu    <==  ( PERFIL IZQUIER     (ROJO) )")))  (TERPRI)
 	(TERPRI)  (SETQ N-PER-DE  (CAR (ENTSEL "----  MARCA SPLINE 2D  Plano-XZu    ==>  ( PERFIL DERECHO (AMARILLO) )")))  (TERPRI)

 	(TERPRI)  (SETQ N-AlzSUR1 (CAR (ENTSEL "----  MARCA SPLINE CURVA 2D  Plano-XZu   ( ALZADO   1SUR    (NEGRO) )")))  (TERPRI)
 	(TERPRI)  (SETQ N-AlzSUR2 (CAR (ENTSEL "----  MARCA SPLINE CURVA 2D  Plano-XZu   ( ALZADO   2SUR    (NEGRO) )")))  (TERPRI)
 	(TERPRI)  (SETQ N-AlzOES1 (CAR (ENTSEL "----  MARCA SPLINE CURVA 2D  Plano-YZu   ( ALZADO   1OESTE   (AZUL) )")))  (TERPRI)
 	(TERPRI)  (SETQ N-AlzOES2 (CAR (ENTSEL "----  MARCA SPLINE CURVA 2D  Plano-YZu   ( ALZADO   2OESTE   (AZUL) )")))  (TERPRI)

	;	(02)																																											
	;======================================================================================================================================


 	;======================================================================================================================================
	;  (03) CALCULO  LISTAS-PUNTOS  =>          LIS-P-PER-IZ     LIS-P-PER-DE     LIS-P-ALZA-SUR     LIS-P-ALZA-OES								
	;......................................................................................................................................
	        (CAL-LIS-PUNTOS--PER_DE-IZ--ALZA_SUR-OES)
 	;======================================================================================================================================
	;  (04) CORDENADA Y=0 en LISTAS =>          LIS-P-PER-IZo    LIS-P-PER-DEo    LIS-P-ALZA-SURo    LIS-P-ALZA-OESo X=0							
	;......................................................................................................................................
	        (LIS-Cordenada_Y=0--PER_DEo-IZo--ALZA_SURo-OESo)
 	;======================================================================================================================================
	;  (05) CALCULO PUNTOS CURVA-EJE-BASE =>    LIS-P-ALZA-OES-Cota	  LIS-P-EJE-BASE  																	
	;......................................................................................................................................
	        (LIS-PUN__ALZA-OES-Cota__EJE-BASE)
 	;======================================================================================================================================
	;  (05p) PINTA  =>      LIS-P-ALZA-SURo      LIS-P-ALZA-OES-Cota      LIS-P-EJE-BASE  																	
	;......................................................................................................................................
	       ; (PINTA__ALZA-SURo__ALZA-OESc__EJE-BASE)
 	;======================================================================================================================================
	;  (06) AADE 3+3 PUNTOS LIS-P-EJE-BASE  =>  LIS-P-EJE-BASE-FI (PUNTOS IMPARES) => LISTA DEFINITIVA    LIS-P-EJE-BASE-FIN					
	;......................................................................................................................................
	        (AADE3+3-EJE-BASE-IMPARES__LIS-P-EJE-BASE-FIN)
 	;======================================================================================================================================
	;  (06p) PINTA  =>      LIS-P-EJE-BASE-FIN        																													
	;......................................................................................................................................
	      ;  (PINTA__LIS-P-EJE-BASE-FIN)
 	;======================================================================================================================================
	;	(07) DISTANCIAS CORTE (LINEAS NORMALES a LIS-P-ALZA-SURo) + (LIS-P-PER-IZo)+(LIS-P-PER-DEo) => LIS-DIS-CORTE-IZ y LIS-DIS-CORTE-DE	
	;......................................................................................................................................
	        (DISTANCIAS-CORTE__LIS-DIS-CORTE-IZ__LIS-DIS-CORTE-DE)
 	;======================================================================================================================================
	;  (08)	CENTRO CIRCULO y ESFERAS OSCULADORAS de  4 PUNTOS  =>  ( LIS-4N-4P-3M-2C-1E )																	
	;......................................................................................................................................
	        (CENTRO-CIRCULO-ESFERAS__LIS-4N-4P-3M-2C-1E)
 	;======================================================================================================================================
	;  (09)	SECCIONES 4P con AgINI y (LIS-DIS-CORTE-M23-AB) (LIS-4N-4P-3M-2C-1E)  =>  LIS-4P-SECC				PINTA BORDES			      	
	;......................................................................................................................................
	        (SECCIONES-4P__LIS-4P-SECC)                                                          ; (AND (= STOP-1 nil) (= STOP-2 nil)) ??? 
 	;======================================================================================================================================
	;  (10) PINTA-3DCARAS  3D     2D PATRONES																																
	;......................................................................................................................................
	        (PINTA-3DCARAS__3D_2D)
 	;======================================================================================================================================


  	;======================================================================================================================================
	;	(12) PARANDO																																								
	;......................................................................................................................................
	(SETVAR "blipmode" 1)  (SETVAR "cmdecho"  1)

	(TERPRI) (PROMPT " ========================================================== ")
	(TERPRI) (PROMPT " >>>>>>>> FINAL >>>>>>>>>>>> DESARROLLO-KIWI-52 >>>>>>>>>>> ")
	(TERPRI) (PROMPT " ========================================================== ") (TERPRI)

  	;	(12)																																											
 	;======================================================================================================================================

) ;  DESARROLLO-KIWI-52 

